# Translations How-To

[Gettext](http://en.wikipedia.org/wiki/Gettext) is used.

## Marking strings for translation

### Frontend

In Angular components, inject the `translation` service and use `translation._()` or `translation._n()`.

In Angular templates, use `_()` or `_n()`. If a block is only use for translation purposes, remember to use it as a one-time binding (for performance reasons):

    {{_('text')}} #BAD
    {{::_('text')}} #GOOD
    
You can provide parameters to your strings:

    {{_('{nb} comments', {nb: card.nb_comments})}}

### Backend

See Frasco

## Extracting strings

Run:

    $ scripts/translations update

Not all strings are properly extracted. These strings are saved in *not_extracted.pot*.

Each time you update, not extracted strings will be marked as removed in the locale's .po file. **Don't forget to unmark them.**

On Ubuntu, you can use PoEdit to edit the .po files.

## Compiling locales

Compiling locales is needed for them to work:

    $ scripts/translations compile

## Utilities

Some scripts can help you get untranslated strings to send to translators (currently using TextMaster online service for that)

    $ scripts/translations update-not-extracted fr
    $ scripts/translations extract-untranslated fr

At this point you just send the generated file (untranslated.po) to your translators and then you can merge back their work using

    $ scripts/translations merge fr filename
