# Application title
TITLE = "Kantree"

# IMPORTANT: key to encrypt the session
SECRET_KEY = "changeme"


# ---------------------------------------------------------------------------------------------------------
# SERVER

# IMPORTANT: public hostname from which Kantree is accessible
SERVER_NAME = "localhost:5000"

# Application server port
SERVER_PORT = 5000

# Database URI (PostgreSQL only)
# See https://docs.sqlalchemy.org/en/latest/core/engines.html#database-urls
DATABASE_URI = None

# Redis URI
# See https://redis-py.readthedocs.io/en/latest/#redis.Redis.from_url
REDIS_URI = "redis://localhost:6379/0"

# Whether the server is hosted behind HTTPS
SERVER_SECURED = False

# URL to reach the push server from the browser.
# By default, the push server will be available on port 0.0.0.0:4000
# If you are using a reverse proxy to serve Kantree under a single domain, you will have to
# set this URL
PUSH_SERVER_URL = None

# Port on which to serve the push server
PUSH_SERVER_PORT = 4000

# Secret key for the push server. Will use SECRET_KEY if None
PUSH_SECRET = None

# SMTP settings
SMTP_SERVER = '127.0.0.1'
SMTP_USERNAME = None
SMTP_PASSWORD = None
SMTP_PORT = 25
SMTP_USE_TLS = False

# Default sender for all emails
MAIL_DEFAULT_SENDER = "Kantree (no-reply) <no-reply@kantree.io>"

# Directory where to store uploaded files
UPLOAD_DIR = 'uploads'

# Default locale for users (see kantree/translations for available locales)
DEFAULT_LOCALE = 'en'

# Try to auto detect the user locale based on his browser information
AUTO_DETECT_USER_LOCALE = True

# Force the Service Worker Cache name (by default will use the current version of Kantree).
# Allows to force cache invalidation even when the version does not change
CACHE_SERVICE_WORKER_NAME = None

# Whether to disable completly the cache service worker
DISABLE_CACHE_SERVICE_WORKER = False


# ---------------------------------------------------------------------------------------------------------
# QUEUES & SPECIFIC CONNECTIONS

QUEUE_PROJECT_HOOKS = None
QUEUE_AUTOMATIONS = None
QUEUE_RELATED_CARDS = None
QUEUE_COMPUTE_FORMULAS = None
QUEUE_REFRESH_CHARTS = None
QUEUE_BATCH_ACTIONS = None
QUEUE_ASSISTANT = None
QUEUE_PROJECT_IMPORT = None

# Number of cards to process per batches when computing formulas. Batches are ran in parallel
FORMULA_QUEUE_PARALLEL_BATCH_SIZE = 200


# ---------------------------------------------------------------------------------------------------------
# LOGGING

# Log level (one of DEBUG, INFO, WARNING, ERROR)
LOG_LEVEL = 'INFO'

# Log to file
LOG_FILENAME = None

# Log to syslog (SYSLOG_PORT can also be set)
SYSLOG_HOST = None

# Log exceptions to Sentry (https://sentry.io)
SENTRY_DSN = None

# Sentry tracing sample rate
SENTRY_TRACES_SAMPLE_RATE = 0.05

# Sentry tracing sample rate
SENTRY_PROFILES_SAMPLE_RATE = 0.5

# Display a log file in the admin
ADMIN_LOG_FILENAME = None

# Display an iframe in the admin with RQ dashboard proxied through Kantree
ADMIN_RQ_DASHBOARD_URL = None

# Email address to contact when some limits are reached
ADMIN_WARNING_CONTACT = None

# Whether to log or not the server name mismatch error
IGNORE_SERVER_NAME_MISMTATCH_ERROR = False


# ---------------------------------------------------------------------------------------------------------
# SECURITY

# Enable Two Factor Authentification
ENABLE_2FA = True

# Whether admins can add new users from the admin area
ADMIN_CAN_ADD_NEW_USERS = True

# Whether admins can access all projects without limitations
ADMIN_CAN_ACCESS_ALL_PROJECTS = True

# Whether user can signup. Set to false if using external auth like LDAP
ALLOW_SIGNUP = True

# Whether username can be modified (even by admin). Useful when using external auth like LDAP
READONLY_USERNAME = False

# Whether email can be modified (even by admin)
READONLY_EMAIL = False

# Whether user can reset their password
USER_CAN_RESET_PASSWORD = True

# Whether user can delete their account by themselves
USER_CAN_DELETE_ACCOUNT = True

# Only allow emails from these domains when signing up
NEW_USERS_LIMIT_DOMAINS = []

# Prevent emails using these domains to signup
NEW_USERS_BLOCK_DOMAINS = []

# When signing up, all new users will be defined as observers
NEW_USERS_AS_OBSERVERS = False

# Email domains which will be considered approved
USERS_APPROVED_DOMAINS = []

# When NEW_USERS_AS_OBSERVERS=True, automatically set users matching the approved domain list as full members
NEW_USERS_AS_OBSERVERS_AUTO_APPROVE = True

# Whether projects can be made accessible to visitors without authentification
ALLOW_PUBLIC_PROJECTS = True

# Hide logout button. Useful when using SSO
HIDE_LOGOUT_BUTTON = False

# Show a logged out page instead of redirecting to /
SHOW_LOGGED_OUT_PAGE = False

# Add Content-Security-Policy header
CSP_HEADER = True

# Allowed sources
CSP_SAFE_URLS = ["'self'", "'unsafe-inline'", "'unsafe-eval'"]

# Only allowed embedding using iframes from the listed parents (see CSP frame-ancestors) (None to disable)
IFRAME_ALLOWED_ANCESTORS = ["'self'"]

# Disable the possibility for users to get API keys
DISABLE_USER_API_KEYS = False

# Whether to send an email to ask for validation
VALIDATE_USER_EMAILS = False

# Whether to lock the user out until his email is validated
BLOCK_NON_EMAIL_VALIDATED_USERS = False

# TTL for automation rules run token
AUTOMATION_RULES_RUN_TOKEN_TTL = None

# Whether org members can be invited via a link
ENABLE_ORG_INVITE_LINK = True


# ---------------------------------------------------------------------------------------------------------
# Appearance

# Override the navbar logo (200x50px)
NAVBAR_LOGO_URL = None

# Logo to display on authentification pages (100x100px)
AUTH_PAGE_LOGO = None

# Custom background (css property background) for auth page left panel
AUTH_BACKGROUND = None

# Default interface color
THEME_COLOR = None

DEFAULT_FORM_HEADER_COLOR = None

DEFAULT_COLOR_PALETTE = None


# ---------------------------------------------------------------------------------------------------------
# Signup

# Show this message of the signup page
SIGNUP_MESSAGE = None

# Show the "subscribe to newsletter" option on signup page
SIGNUP_NEWSLETTER = False

# Whether to send a welcome email on signup (kantree/emails/welcome.md)
SIGNUP_WELCOME_EMAIL = False

# Show "Login with SSO" link on login & signup page
SSO_LOGIN_URL = None


# ---------------------------------------------------------------------------------------------------------
# Users settings

# Try getting the avatar from gravatar
USER_TRY_GRAVATAR = False

# Whether user can create personal projects outside of orgs
USER_CAN_CREATE_PROJECTS = True

# Whether user can create private personal projects
USER_CAN_CREATE_PRIVATE_PROJECTS = True

# Whether user can join any organizations
USER_CAN_JOIN_ORGANIZATIONS = True

# Whether user can create orgs by themselves
USER_CAN_CREATE_ORGANIZATIONS = True


# ---------------------------------------------------------------------------------------------------------
# ORGS/TEAMS SETTINGS

# What roles are authorized as guests in projects
# If True, all roles are allowed
# Otherwise, it must be a list of role names from the builtins
ORG_AUTHORIZED_GUEST_ROLES = True

# If set to false, only public projects will be allowed in orgs
ORG_CAN_CREATE_PRIVATE_PROJECTS = True

# Whether orgs require at least one owner.
# By default, orgs with no owners are allowed. In this case, only kantree admins can manage them.
ORG_AT_LEAST_ONE_OWNER_REQUIRED = False

# Whether organization owners can export the org by themselves
ORG_CAN_SELF_EXPORT = False

# Default feature flags to activate hidden features on all orgs
# DEFAULT_FEATURE_FLAGS = ['teams', 'org_hub', 'sso', 'portfolios', 'gantt', 'quadrant']
DEFAULT_FEATURE_FLAGS = ['teams', 'org_hub', 'sso']


# ---------------------------------------------------------------------------------------------------------
# ANTI-SPAM

# Maximum number of invites the user can send at once
MAX_INVITES_AT_ONCE = None

# Maximum number of invites a project/team can have during their lifetime
MAX_TOTAL_INVITES = None

# Maximum pending invites in a project or team
MAX_PENDING_INVITES = 100

# Use recaptcha validation on signup
RECAPTCHA_KEY = None
RECAPTCHA_SECRET = None

# Use hcaptcha validation on signup
HCAPTCHA_KEY = None
HCAPTCHA_SECRET = None

# Maximum number of email templates a team can send per day (None to disable)
MAX_EMAIL_TEMPLATE_SEND_PER_DAY = None


# ---------------------------------------------------------------------------------------------------------
# TASK TIMEOUTS

# Timeout (in seconds) for import tasks, can be increased when importing large projects
PROJECT_IMPORTER_TASK_TIMEOUT = 500

# Timeout (in seconds) for tasks that refresh chart data
REFRESH_CHART_TASK_TIMEOUT = 300


# ---------------------------------------------------------------------------------------------------------
# TEMPLATE LIBRARY

# Template library accessibe to unauthenticated users
# Note: even if public, project not marked as public won't be visible to unauthenticated users
PUBLIC_TEMPLATE_LIBRARY = False

# Only display the following tags in the template library.
# Other tags are still permitted but only visible on the template itself.
# Can be a dict for localized tags where keys are the locale name.
TEMPLATE_LIBRARY_DISPLAY_TAGS = None

# Whether any users can publish templates to the library
OPEN_TEMPLATE_LIBRARY = True

# Default template (id of a project)
DEFAULT_TEMPLATE_ID = None

# Name of the tag used for featured templates.
# Can be a dict for localized tag where keys are the locale name.
TEMPLATE_LIBRARY_FEATURED_TAG = 'Featured'

# Hide selection of the preferred template library tag during onboarding
ONBOARDING_HIDE_PREFERRED_TEMPLATE_TAG = False


# ---------------------------------------------------------------------------------------------------------
# HELP & ONBOARDING

# Link towards your custom help site (kantree.io used otherwise)
HELP_SITE_URL = None

# Display a button to open support tickets (opens the url in a new tab)
HELP_TICKET_URL = None

# Show this email for people who want to contact support
SUPPORT_EMAIL = None

# Slug of a project which will be automatically copied to all new users (users must be allowed to have private projects)
ONBOARDING_WELCOME_PROJECT = None

# Name of an org/team to automatically join when signing up
AUTO_JOIN_ORG_AFTER_SIGNUP = None

# Show onboarding tour to new users
ONBOARDING_TOUR_ENABLED = True

# Whether a multi-day drip email campaign to users during their onboarding process
SEND_ONBOARDING_EMAILS = False

# Automatically delete orgs when all members are removed
ORG_AUTO_DELETE_WHEN_NO_MEMBERS = False

# Whether to automatically disable users after no access for X days
AUTO_DISABLE_USER_AFTER_DAYS_NOT_ACCESSED = False

# Show the what's new button
WHATSNEW_ID = 3


# ---------------------------------------------------------------------------------------------------------
# Legal

# Path to a file containing the Terms & Conditions
TERMS_FILE = None

# URL of a T&C page to display a link in the interface
TERMS_URL = None

# Last update date of the Terms & Conditions (YYYY-MM-DD).
# If set, users who haven't accepted terms past this date will be prompted to accept T&C
TERMS_UPDATE_DATE = None

# URL to a privacy page
PRIVACY_URL = None

# URL to data processing agreement page
DATA_PROCESSING_AGREEMENT_URL = None

# Whether to show the terms validation popup after signup
FORCE_TERMS_VALIDATION_AFTER_SIGNUP = False


# ---------------------------------------------------------------------------------------------------------
# AI


# Provider to use (one of "OpenAI", "Claude", "Mistral")
AI_PROVIDER = "Mistral"

# Use a custom provider:
# AI_PROVIDER = {
#     "base_url": "https://api.mistral.ai/v1",
#     "model": "mistral-medium-latest",
#     "kql_model": "mistral-medium-latest", # optional, model dedicated to generating KQL
#     "agent_model": "mistral-medium-latest", # optional, model dedicated to agents
# }

# API KEY
AI_API_KEY = None

# Whether orgs automatically have AI features enabled when globally configured
# If false, AI will be enabled only for some features. Additional features like
# Kantree Assistant and AI automations will required each org to provide an API key.
AI_ORG_AUTO_ENABLED = True

# Whether the assistant can be used
AI_ASSISTANT = True


# ---------------------------------------------------------------------------------------------------------
# MISC

# Use a different upload backend for exports. You must first configure the upload backend as part of the frasco_upload config
EXPORTS_UPLOAD_BACKEND = None

# Max upload size in bytes
MAX_UPLOAD_SIZE = None

# Max upload size from public forms in bytes
MAX_PUBLIC_UPLOAD_SIZE = None

# Limit file types from public forms
# List with any from: documents, media, images, videos, audio, archives
LIMIT_PUBLIC_UPLOAD_FILE_TYPES = None

# Whether exporting can be done sync instead of async
ALLOW_STREAMING_EXPORTS = True

# What action to do when synchronizing users via csv (one of: observer, disable, delete)
BULK_IMPORT_USERS_SYNC = 'disable'

# Domain that will be used for inbound emails and for the reply-to field of outgoing notifications
EMAIL_INBOUND_DOMAIN = None

# Emails to ignore in CCs field when handling inbound emails
IGNORE_INBOUND_EMAIL_CC = []

# When the user is not logged in, the homepage should display the content of this file
PROMO_FILE = None

# When the user is not logged in, the homepage should redirect to the following URL
PROMO_REDIRECT = None

# Same as before but a dict where keys are the locale name and values the url to redirect to
PROMO_LOCALE_REDIRECT = {}

# Track signups with GA (the script will only be included on /signup and /login)
GOOGLE_ANALYTICS_ID = None

# Track signups with Plausible (the script will only be included on /signup and /login)
PLAUSIBLE_URL = None

# Whether to allow the demo parameter on the template lib and projects
ENABLE_DEMO_MODE = False

# Token needed to download geoip databases
MAXMIND_GEOIP_TOKEN = None

KANTREE_COACH_ENABLED = False

# Token to your kantree coach service portal
KANTREE_COACH_TOKEN = None
