var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __esm = (fn, res) => function __init() {
  return fn && (res = (0, fn[__getOwnPropNames(fn)[0]])(fn = 0)), res;
};
var __commonJS = (cb2, mod) => function __require() {
  return mod || (0, cb2[__getOwnPropNames(cb2)[0]])((mod = { exports: {} }).exports, mod), mod.exports;
};
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from2, except, desc) => {
  if (from2 && typeof from2 === "object" || typeof from2 === "function") {
    for (let key of __getOwnPropNames(from2))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from2[key], enumerable: !(desc = __getOwnPropDesc(from2, key)) || desc.enumerable });
  }
  return to;
};
var __reExport = (target, mod, secondTarget) => (__copyProps(target, mod, "default"), secondTarget && __copyProps(secondTarget, mod, "default"));
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// node_modules/tinycolor2/tinycolor.js
var require_tinycolor = __commonJS({
  "node_modules/tinycolor2/tinycolor.js"(exports, module) {
    (function(Math2) {
      var trimLeft = /^\s+/, trimRight = /\s+$/, tinyCounter = 0, mathRound = Math2.round, mathMin = Math2.min, mathMax = Math2.max, mathRandom = Math2.random;
      function tinycolor11(color, opts) {
        color = color ? color : "";
        opts = opts || {};
        if (color instanceof tinycolor11) {
          return color;
        }
        if (!(this instanceof tinycolor11)) {
          return new tinycolor11(color, opts);
        }
        var rgb = inputToRGB(color);
        this._originalInput = color, this._r = rgb.r, this._g = rgb.g, this._b = rgb.b, this._a = rgb.a, this._roundA = mathRound(100 * this._a) / 100, this._format = opts.format || rgb.format;
        this._gradientType = opts.gradientType;
        if (this._r < 1) {
          this._r = mathRound(this._r);
        }
        if (this._g < 1) {
          this._g = mathRound(this._g);
        }
        if (this._b < 1) {
          this._b = mathRound(this._b);
        }
        this._ok = rgb.ok;
        this._tc_id = tinyCounter++;
      }
      tinycolor11.prototype = {
        isDark: function() {
          return this.getBrightness() < 128;
        },
        isLight: function() {
          return !this.isDark();
        },
        isValid: function() {
          return this._ok;
        },
        getOriginalInput: function() {
          return this._originalInput;
        },
        getFormat: function() {
          return this._format;
        },
        getAlpha: function() {
          return this._a;
        },
        getBrightness: function() {
          var rgb = this.toRgb();
          return (rgb.r * 299 + rgb.g * 587 + rgb.b * 114) / 1e3;
        },
        getLuminance: function() {
          var rgb = this.toRgb();
          var RsRGB, GsRGB, BsRGB, R2, G, B;
          RsRGB = rgb.r / 255;
          GsRGB = rgb.g / 255;
          BsRGB = rgb.b / 255;
          if (RsRGB <= 0.03928) {
            R2 = RsRGB / 12.92;
          } else {
            R2 = Math2.pow((RsRGB + 0.055) / 1.055, 2.4);
          }
          if (GsRGB <= 0.03928) {
            G = GsRGB / 12.92;
          } else {
            G = Math2.pow((GsRGB + 0.055) / 1.055, 2.4);
          }
          if (BsRGB <= 0.03928) {
            B = BsRGB / 12.92;
          } else {
            B = Math2.pow((BsRGB + 0.055) / 1.055, 2.4);
          }
          return 0.2126 * R2 + 0.7152 * G + 0.0722 * B;
        },
        setAlpha: function(value2) {
          this._a = boundAlpha(value2);
          this._roundA = mathRound(100 * this._a) / 100;
          return this;
        },
        toHsv: function() {
          var hsv = rgbToHsv(this._r, this._g, this._b);
          return { h: hsv.h * 360, s: hsv.s, v: hsv.v, a: this._a };
        },
        toHsvString: function() {
          var hsv = rgbToHsv(this._r, this._g, this._b);
          var h3 = mathRound(hsv.h * 360), s3 = mathRound(hsv.s * 100), v3 = mathRound(hsv.v * 100);
          return this._a == 1 ? "hsv(" + h3 + ", " + s3 + "%, " + v3 + "%)" : "hsva(" + h3 + ", " + s3 + "%, " + v3 + "%, " + this._roundA + ")";
        },
        toHsl: function() {
          var hsl = rgbToHsl(this._r, this._g, this._b);
          return { h: hsl.h * 360, s: hsl.s, l: hsl.l, a: this._a };
        },
        toHslString: function() {
          var hsl = rgbToHsl(this._r, this._g, this._b);
          var h3 = mathRound(hsl.h * 360), s3 = mathRound(hsl.s * 100), l3 = mathRound(hsl.l * 100);
          return this._a == 1 ? "hsl(" + h3 + ", " + s3 + "%, " + l3 + "%)" : "hsla(" + h3 + ", " + s3 + "%, " + l3 + "%, " + this._roundA + ")";
        },
        toHex: function(allow3Char) {
          return rgbToHex(this._r, this._g, this._b, allow3Char);
        },
        toHexString: function(allow3Char) {
          return "#" + this.toHex(allow3Char);
        },
        toHex8: function(allow4Char) {
          return rgbaToHex(this._r, this._g, this._b, this._a, allow4Char);
        },
        toHex8String: function(allow4Char) {
          return "#" + this.toHex8(allow4Char);
        },
        toRgb: function() {
          return { r: mathRound(this._r), g: mathRound(this._g), b: mathRound(this._b), a: this._a };
        },
        toRgbString: function() {
          return this._a == 1 ? "rgb(" + mathRound(this._r) + ", " + mathRound(this._g) + ", " + mathRound(this._b) + ")" : "rgba(" + mathRound(this._r) + ", " + mathRound(this._g) + ", " + mathRound(this._b) + ", " + this._roundA + ")";
        },
        toPercentageRgb: function() {
          return { r: mathRound(bound01(this._r, 255) * 100) + "%", g: mathRound(bound01(this._g, 255) * 100) + "%", b: mathRound(bound01(this._b, 255) * 100) + "%", a: this._a };
        },
        toPercentageRgbString: function() {
          return this._a == 1 ? "rgb(" + mathRound(bound01(this._r, 255) * 100) + "%, " + mathRound(bound01(this._g, 255) * 100) + "%, " + mathRound(bound01(this._b, 255) * 100) + "%)" : "rgba(" + mathRound(bound01(this._r, 255) * 100) + "%, " + mathRound(bound01(this._g, 255) * 100) + "%, " + mathRound(bound01(this._b, 255) * 100) + "%, " + this._roundA + ")";
        },
        toName: function() {
          if (this._a === 0) {
            return "transparent";
          }
          if (this._a < 1) {
            return false;
          }
          return hexNames[rgbToHex(this._r, this._g, this._b, true)] || false;
        },
        toFilter: function(secondColor) {
          var hex8String = "#" + rgbaToArgbHex(this._r, this._g, this._b, this._a);
          var secondHex8String = hex8String;
          var gradientType = this._gradientType ? "GradientType = 1, " : "";
          if (secondColor) {
            var s3 = tinycolor11(secondColor);
            secondHex8String = "#" + rgbaToArgbHex(s3._r, s3._g, s3._b, s3._a);
          }
          return "progid:DXImageTransform.Microsoft.gradient(" + gradientType + "startColorstr=" + hex8String + ",endColorstr=" + secondHex8String + ")";
        },
        toString: function(format) {
          var formatSet = !!format;
          format = format || this._format;
          var formattedString = false;
          var hasAlpha = this._a < 1 && this._a >= 0;
          var needsAlphaFormat = !formatSet && hasAlpha && (format === "hex" || format === "hex6" || format === "hex3" || format === "hex4" || format === "hex8" || format === "name");
          if (needsAlphaFormat) {
            if (format === "name" && this._a === 0) {
              return this.toName();
            }
            return this.toRgbString();
          }
          if (format === "rgb") {
            formattedString = this.toRgbString();
          }
          if (format === "prgb") {
            formattedString = this.toPercentageRgbString();
          }
          if (format === "hex" || format === "hex6") {
            formattedString = this.toHexString();
          }
          if (format === "hex3") {
            formattedString = this.toHexString(true);
          }
          if (format === "hex4") {
            formattedString = this.toHex8String(true);
          }
          if (format === "hex8") {
            formattedString = this.toHex8String();
          }
          if (format === "name") {
            formattedString = this.toName();
          }
          if (format === "hsl") {
            formattedString = this.toHslString();
          }
          if (format === "hsv") {
            formattedString = this.toHsvString();
          }
          return formattedString || this.toHexString();
        },
        clone: function() {
          return tinycolor11(this.toString());
        },
        _applyModification: function(fn, args) {
          var color = fn.apply(null, [this].concat([].slice.call(args)));
          this._r = color._r;
          this._g = color._g;
          this._b = color._b;
          this.setAlpha(color._a);
          return this;
        },
        lighten: function() {
          return this._applyModification(lighten, arguments);
        },
        brighten: function() {
          return this._applyModification(brighten, arguments);
        },
        darken: function() {
          return this._applyModification(darken, arguments);
        },
        desaturate: function() {
          return this._applyModification(desaturate, arguments);
        },
        saturate: function() {
          return this._applyModification(saturate, arguments);
        },
        greyscale: function() {
          return this._applyModification(greyscale, arguments);
        },
        spin: function() {
          return this._applyModification(spin, arguments);
        },
        _applyCombination: function(fn, args) {
          return fn.apply(null, [this].concat([].slice.call(args)));
        },
        analogous: function() {
          return this._applyCombination(analogous, arguments);
        },
        complement: function() {
          return this._applyCombination(complement, arguments);
        },
        monochromatic: function() {
          return this._applyCombination(monochromatic, arguments);
        },
        splitcomplement: function() {
          return this._applyCombination(splitcomplement, arguments);
        },
        triad: function() {
          return this._applyCombination(triad, arguments);
        },
        tetrad: function() {
          return this._applyCombination(tetrad, arguments);
        }
      };
      tinycolor11.fromRatio = function(color, opts) {
        if (typeof color == "object") {
          var newColor = {};
          for (var i3 in color) {
            if (color.hasOwnProperty(i3)) {
              if (i3 === "a") {
                newColor[i3] = color[i3];
              } else {
                newColor[i3] = convertToPercentage(color[i3]);
              }
            }
          }
          color = newColor;
        }
        return tinycolor11(color, opts);
      };
      function inputToRGB(color) {
        var rgb = { r: 0, g: 0, b: 0 };
        var a3 = 1;
        var s3 = null;
        var v3 = null;
        var l3 = null;
        var ok = false;
        var format = false;
        if (typeof color == "string") {
          color = stringInputToObject(color);
        }
        if (typeof color == "object") {
          if (isValidCSSUnit(color.r) && isValidCSSUnit(color.g) && isValidCSSUnit(color.b)) {
            rgb = rgbToRgb(color.r, color.g, color.b);
            ok = true;
            format = String(color.r).substr(-1) === "%" ? "prgb" : "rgb";
          } else if (isValidCSSUnit(color.h) && isValidCSSUnit(color.s) && isValidCSSUnit(color.v)) {
            s3 = convertToPercentage(color.s);
            v3 = convertToPercentage(color.v);
            rgb = hsvToRgb(color.h, s3, v3);
            ok = true;
            format = "hsv";
          } else if (isValidCSSUnit(color.h) && isValidCSSUnit(color.s) && isValidCSSUnit(color.l)) {
            s3 = convertToPercentage(color.s);
            l3 = convertToPercentage(color.l);
            rgb = hslToRgb(color.h, s3, l3);
            ok = true;
            format = "hsl";
          }
          if (color.hasOwnProperty("a")) {
            a3 = color.a;
          }
        }
        a3 = boundAlpha(a3);
        return {
          ok,
          format: color.format || format,
          r: mathMin(255, mathMax(rgb.r, 0)),
          g: mathMin(255, mathMax(rgb.g, 0)),
          b: mathMin(255, mathMax(rgb.b, 0)),
          a: a3
        };
      }
      function rgbToRgb(r3, g3, b3) {
        return {
          r: bound01(r3, 255) * 255,
          g: bound01(g3, 255) * 255,
          b: bound01(b3, 255) * 255
        };
      }
      function rgbToHsl(r3, g3, b3) {
        r3 = bound01(r3, 255);
        g3 = bound01(g3, 255);
        b3 = bound01(b3, 255);
        var max3 = mathMax(r3, g3, b3), min3 = mathMin(r3, g3, b3);
        var h3, s3, l3 = (max3 + min3) / 2;
        if (max3 == min3) {
          h3 = s3 = 0;
        } else {
          var d3 = max3 - min3;
          s3 = l3 > 0.5 ? d3 / (2 - max3 - min3) : d3 / (max3 + min3);
          switch (max3) {
            case r3:
              h3 = (g3 - b3) / d3 + (g3 < b3 ? 6 : 0);
              break;
            case g3:
              h3 = (b3 - r3) / d3 + 2;
              break;
            case b3:
              h3 = (r3 - g3) / d3 + 4;
              break;
          }
          h3 /= 6;
        }
        return { h: h3, s: s3, l: l3 };
      }
      function hslToRgb(h3, s3, l3) {
        var r3, g3, b3;
        h3 = bound01(h3, 360);
        s3 = bound01(s3, 100);
        l3 = bound01(l3, 100);
        function hue2rgb(p4, q2, t2) {
          if (t2 < 0) t2 += 1;
          if (t2 > 1) t2 -= 1;
          if (t2 < 1 / 6) return p4 + (q2 - p4) * 6 * t2;
          if (t2 < 1 / 2) return q2;
          if (t2 < 2 / 3) return p4 + (q2 - p4) * (2 / 3 - t2) * 6;
          return p4;
        }
        if (s3 === 0) {
          r3 = g3 = b3 = l3;
        } else {
          var q = l3 < 0.5 ? l3 * (1 + s3) : l3 + s3 - l3 * s3;
          var p3 = 2 * l3 - q;
          r3 = hue2rgb(p3, q, h3 + 1 / 3);
          g3 = hue2rgb(p3, q, h3);
          b3 = hue2rgb(p3, q, h3 - 1 / 3);
        }
        return { r: r3 * 255, g: g3 * 255, b: b3 * 255 };
      }
      function rgbToHsv(r3, g3, b3) {
        r3 = bound01(r3, 255);
        g3 = bound01(g3, 255);
        b3 = bound01(b3, 255);
        var max3 = mathMax(r3, g3, b3), min3 = mathMin(r3, g3, b3);
        var h3, s3, v3 = max3;
        var d3 = max3 - min3;
        s3 = max3 === 0 ? 0 : d3 / max3;
        if (max3 == min3) {
          h3 = 0;
        } else {
          switch (max3) {
            case r3:
              h3 = (g3 - b3) / d3 + (g3 < b3 ? 6 : 0);
              break;
            case g3:
              h3 = (b3 - r3) / d3 + 2;
              break;
            case b3:
              h3 = (r3 - g3) / d3 + 4;
              break;
          }
          h3 /= 6;
        }
        return { h: h3, s: s3, v: v3 };
      }
      function hsvToRgb(h3, s3, v3) {
        h3 = bound01(h3, 360) * 6;
        s3 = bound01(s3, 100);
        v3 = bound01(v3, 100);
        var i3 = Math2.floor(h3), f3 = h3 - i3, p3 = v3 * (1 - s3), q = v3 * (1 - f3 * s3), t2 = v3 * (1 - (1 - f3) * s3), mod = i3 % 6, r3 = [v3, q, p3, p3, t2, v3][mod], g3 = [t2, v3, v3, q, p3, p3][mod], b3 = [p3, p3, t2, v3, v3, q][mod];
        return { r: r3 * 255, g: g3 * 255, b: b3 * 255 };
      }
      function rgbToHex(r3, g3, b3, allow3Char) {
        var hex = [
          pad2(mathRound(r3).toString(16)),
          pad2(mathRound(g3).toString(16)),
          pad2(mathRound(b3).toString(16))
        ];
        if (allow3Char && hex[0].charAt(0) == hex[0].charAt(1) && hex[1].charAt(0) == hex[1].charAt(1) && hex[2].charAt(0) == hex[2].charAt(1)) {
          return hex[0].charAt(0) + hex[1].charAt(0) + hex[2].charAt(0);
        }
        return hex.join("");
      }
      function rgbaToHex(r3, g3, b3, a3, allow4Char) {
        var hex = [
          pad2(mathRound(r3).toString(16)),
          pad2(mathRound(g3).toString(16)),
          pad2(mathRound(b3).toString(16)),
          pad2(convertDecimalToHex(a3))
        ];
        if (allow4Char && hex[0].charAt(0) == hex[0].charAt(1) && hex[1].charAt(0) == hex[1].charAt(1) && hex[2].charAt(0) == hex[2].charAt(1) && hex[3].charAt(0) == hex[3].charAt(1)) {
          return hex[0].charAt(0) + hex[1].charAt(0) + hex[2].charAt(0) + hex[3].charAt(0);
        }
        return hex.join("");
      }
      function rgbaToArgbHex(r3, g3, b3, a3) {
        var hex = [
          pad2(convertDecimalToHex(a3)),
          pad2(mathRound(r3).toString(16)),
          pad2(mathRound(g3).toString(16)),
          pad2(mathRound(b3).toString(16))
        ];
        return hex.join("");
      }
      tinycolor11.equals = function(color1, color2) {
        if (!color1 || !color2) {
          return false;
        }
        return tinycolor11(color1).toRgbString() == tinycolor11(color2).toRgbString();
      };
      tinycolor11.random = function() {
        return tinycolor11.fromRatio({
          r: mathRandom(),
          g: mathRandom(),
          b: mathRandom()
        });
      };
      function desaturate(color, amount) {
        amount = amount === 0 ? 0 : amount || 10;
        var hsl = tinycolor11(color).toHsl();
        hsl.s -= amount / 100;
        hsl.s = clamp01(hsl.s);
        return tinycolor11(hsl);
      }
      function saturate(color, amount) {
        amount = amount === 0 ? 0 : amount || 10;
        var hsl = tinycolor11(color).toHsl();
        hsl.s += amount / 100;
        hsl.s = clamp01(hsl.s);
        return tinycolor11(hsl);
      }
      function greyscale(color) {
        return tinycolor11(color).desaturate(100);
      }
      function lighten(color, amount) {
        amount = amount === 0 ? 0 : amount || 10;
        var hsl = tinycolor11(color).toHsl();
        hsl.l += amount / 100;
        hsl.l = clamp01(hsl.l);
        return tinycolor11(hsl);
      }
      function brighten(color, amount) {
        amount = amount === 0 ? 0 : amount || 10;
        var rgb = tinycolor11(color).toRgb();
        rgb.r = mathMax(0, mathMin(255, rgb.r - mathRound(255 * -(amount / 100))));
        rgb.g = mathMax(0, mathMin(255, rgb.g - mathRound(255 * -(amount / 100))));
        rgb.b = mathMax(0, mathMin(255, rgb.b - mathRound(255 * -(amount / 100))));
        return tinycolor11(rgb);
      }
      function darken(color, amount) {
        amount = amount === 0 ? 0 : amount || 10;
        var hsl = tinycolor11(color).toHsl();
        hsl.l -= amount / 100;
        hsl.l = clamp01(hsl.l);
        return tinycolor11(hsl);
      }
      function spin(color, amount) {
        var hsl = tinycolor11(color).toHsl();
        var hue = (hsl.h + amount) % 360;
        hsl.h = hue < 0 ? 360 + hue : hue;
        return tinycolor11(hsl);
      }
      function complement(color) {
        var hsl = tinycolor11(color).toHsl();
        hsl.h = (hsl.h + 180) % 360;
        return tinycolor11(hsl);
      }
      function triad(color) {
        var hsl = tinycolor11(color).toHsl();
        var h3 = hsl.h;
        return [
          tinycolor11(color),
          tinycolor11({ h: (h3 + 120) % 360, s: hsl.s, l: hsl.l }),
          tinycolor11({ h: (h3 + 240) % 360, s: hsl.s, l: hsl.l })
        ];
      }
      function tetrad(color) {
        var hsl = tinycolor11(color).toHsl();
        var h3 = hsl.h;
        return [
          tinycolor11(color),
          tinycolor11({ h: (h3 + 90) % 360, s: hsl.s, l: hsl.l }),
          tinycolor11({ h: (h3 + 180) % 360, s: hsl.s, l: hsl.l }),
          tinycolor11({ h: (h3 + 270) % 360, s: hsl.s, l: hsl.l })
        ];
      }
      function splitcomplement(color) {
        var hsl = tinycolor11(color).toHsl();
        var h3 = hsl.h;
        return [
          tinycolor11(color),
          tinycolor11({ h: (h3 + 72) % 360, s: hsl.s, l: hsl.l }),
          tinycolor11({ h: (h3 + 216) % 360, s: hsl.s, l: hsl.l })
        ];
      }
      function analogous(color, results2, slices) {
        results2 = results2 || 6;
        slices = slices || 30;
        var hsl = tinycolor11(color).toHsl();
        var part = 360 / slices;
        var ret = [tinycolor11(color)];
        for (hsl.h = (hsl.h - (part * results2 >> 1) + 720) % 360; --results2; ) {
          hsl.h = (hsl.h + part) % 360;
          ret.push(tinycolor11(hsl));
        }
        return ret;
      }
      function monochromatic(color, results2) {
        results2 = results2 || 6;
        var hsv = tinycolor11(color).toHsv();
        var h3 = hsv.h, s3 = hsv.s, v3 = hsv.v;
        var ret = [];
        var modification = 1 / results2;
        while (results2--) {
          ret.push(tinycolor11({ h: h3, s: s3, v: v3 }));
          v3 = (v3 + modification) % 1;
        }
        return ret;
      }
      tinycolor11.mix = function(color1, color2, amount) {
        amount = amount === 0 ? 0 : amount || 50;
        var rgb1 = tinycolor11(color1).toRgb();
        var rgb2 = tinycolor11(color2).toRgb();
        var p3 = amount / 100;
        var rgba = {
          r: (rgb2.r - rgb1.r) * p3 + rgb1.r,
          g: (rgb2.g - rgb1.g) * p3 + rgb1.g,
          b: (rgb2.b - rgb1.b) * p3 + rgb1.b,
          a: (rgb2.a - rgb1.a) * p3 + rgb1.a
        };
        return tinycolor11(rgba);
      };
      tinycolor11.readability = function(color1, color2) {
        var c1 = tinycolor11(color1);
        var c22 = tinycolor11(color2);
        return (Math2.max(c1.getLuminance(), c22.getLuminance()) + 0.05) / (Math2.min(c1.getLuminance(), c22.getLuminance()) + 0.05);
      };
      tinycolor11.isReadable = function(color1, color2, wcag2) {
        var readability = tinycolor11.readability(color1, color2);
        var wcag2Parms, out;
        out = false;
        wcag2Parms = validateWCAG2Parms(wcag2);
        switch (wcag2Parms.level + wcag2Parms.size) {
          case "AAsmall":
          case "AAAlarge":
            out = readability >= 4.5;
            break;
          case "AAlarge":
            out = readability >= 3;
            break;
          case "AAAsmall":
            out = readability >= 7;
            break;
        }
        return out;
      };
      tinycolor11.mostReadable = function(baseColor2, colorList, args) {
        var bestColor = null;
        var bestScore = 0;
        var readability;
        var includeFallbackColors, level, size4;
        args = args || {};
        includeFallbackColors = args.includeFallbackColors;
        level = args.level;
        size4 = args.size;
        for (var i3 = 0; i3 < colorList.length; i3++) {
          readability = tinycolor11.readability(baseColor2, colorList[i3]);
          if (readability > bestScore) {
            bestScore = readability;
            bestColor = tinycolor11(colorList[i3]);
          }
        }
        if (tinycolor11.isReadable(baseColor2, bestColor, { "level": level, "size": size4 }) || !includeFallbackColors) {
          return bestColor;
        } else {
          args.includeFallbackColors = false;
          return tinycolor11.mostReadable(baseColor2, ["#fff", "#000"], args);
        }
      };
      var names = tinycolor11.names = {
        aliceblue: "f0f8ff",
        antiquewhite: "faebd7",
        aqua: "0ff",
        aquamarine: "7fffd4",
        azure: "f0ffff",
        beige: "f5f5dc",
        bisque: "ffe4c4",
        black: "000",
        blanchedalmond: "ffebcd",
        blue: "00f",
        blueviolet: "8a2be2",
        brown: "a52a2a",
        burlywood: "deb887",
        burntsienna: "ea7e5d",
        cadetblue: "5f9ea0",
        chartreuse: "7fff00",
        chocolate: "d2691e",
        coral: "ff7f50",
        cornflowerblue: "6495ed",
        cornsilk: "fff8dc",
        crimson: "dc143c",
        cyan: "0ff",
        darkblue: "00008b",
        darkcyan: "008b8b",
        darkgoldenrod: "b8860b",
        darkgray: "a9a9a9",
        darkgreen: "006400",
        darkgrey: "a9a9a9",
        darkkhaki: "bdb76b",
        darkmagenta: "8b008b",
        darkolivegreen: "556b2f",
        darkorange: "ff8c00",
        darkorchid: "9932cc",
        darkred: "8b0000",
        darksalmon: "e9967a",
        darkseagreen: "8fbc8f",
        darkslateblue: "483d8b",
        darkslategray: "2f4f4f",
        darkslategrey: "2f4f4f",
        darkturquoise: "00ced1",
        darkviolet: "9400d3",
        deeppink: "ff1493",
        deepskyblue: "00bfff",
        dimgray: "696969",
        dimgrey: "696969",
        dodgerblue: "1e90ff",
        firebrick: "b22222",
        floralwhite: "fffaf0",
        forestgreen: "228b22",
        fuchsia: "f0f",
        gainsboro: "dcdcdc",
        ghostwhite: "f8f8ff",
        gold: "ffd700",
        goldenrod: "daa520",
        gray: "808080",
        green: "008000",
        greenyellow: "adff2f",
        grey: "808080",
        honeydew: "f0fff0",
        hotpink: "ff69b4",
        indianred: "cd5c5c",
        indigo: "4b0082",
        ivory: "fffff0",
        khaki: "f0e68c",
        lavender: "e6e6fa",
        lavenderblush: "fff0f5",
        lawngreen: "7cfc00",
        lemonchiffon: "fffacd",
        lightblue: "add8e6",
        lightcoral: "f08080",
        lightcyan: "e0ffff",
        lightgoldenrodyellow: "fafad2",
        lightgray: "d3d3d3",
        lightgreen: "90ee90",
        lightgrey: "d3d3d3",
        lightpink: "ffb6c1",
        lightsalmon: "ffa07a",
        lightseagreen: "20b2aa",
        lightskyblue: "87cefa",
        lightslategray: "789",
        lightslategrey: "789",
        lightsteelblue: "b0c4de",
        lightyellow: "ffffe0",
        lime: "0f0",
        limegreen: "32cd32",
        linen: "faf0e6",
        magenta: "f0f",
        maroon: "800000",
        mediumaquamarine: "66cdaa",
        mediumblue: "0000cd",
        mediumorchid: "ba55d3",
        mediumpurple: "9370db",
        mediumseagreen: "3cb371",
        mediumslateblue: "7b68ee",
        mediumspringgreen: "00fa9a",
        mediumturquoise: "48d1cc",
        mediumvioletred: "c71585",
        midnightblue: "191970",
        mintcream: "f5fffa",
        mistyrose: "ffe4e1",
        moccasin: "ffe4b5",
        navajowhite: "ffdead",
        navy: "000080",
        oldlace: "fdf5e6",
        olive: "808000",
        olivedrab: "6b8e23",
        orange: "ffa500",
        orangered: "ff4500",
        orchid: "da70d6",
        palegoldenrod: "eee8aa",
        palegreen: "98fb98",
        paleturquoise: "afeeee",
        palevioletred: "db7093",
        papayawhip: "ffefd5",
        peachpuff: "ffdab9",
        peru: "cd853f",
        pink: "ffc0cb",
        plum: "dda0dd",
        powderblue: "b0e0e6",
        purple: "800080",
        rebeccapurple: "663399",
        red: "f00",
        rosybrown: "bc8f8f",
        royalblue: "4169e1",
        saddlebrown: "8b4513",
        salmon: "fa8072",
        sandybrown: "f4a460",
        seagreen: "2e8b57",
        seashell: "fff5ee",
        sienna: "a0522d",
        silver: "c0c0c0",
        skyblue: "87ceeb",
        slateblue: "6a5acd",
        slategray: "708090",
        slategrey: "708090",
        snow: "fffafa",
        springgreen: "00ff7f",
        steelblue: "4682b4",
        tan: "d2b48c",
        teal: "008080",
        thistle: "d8bfd8",
        tomato: "ff6347",
        turquoise: "40e0d0",
        violet: "ee82ee",
        wheat: "f5deb3",
        white: "fff",
        whitesmoke: "f5f5f5",
        yellow: "ff0",
        yellowgreen: "9acd32"
      };
      var hexNames = tinycolor11.hexNames = flip(names);
      function flip(o3) {
        var flipped = {};
        for (var i3 in o3) {
          if (o3.hasOwnProperty(i3)) {
            flipped[o3[i3]] = i3;
          }
        }
        return flipped;
      }
      function boundAlpha(a3) {
        a3 = parseFloat(a3);
        if (isNaN(a3) || a3 < 0 || a3 > 1) {
          a3 = 1;
        }
        return a3;
      }
      function bound01(n4, max3) {
        if (isOnePointZero(n4)) {
          n4 = "100%";
        }
        var processPercent = isPercentage(n4);
        n4 = mathMin(max3, mathMax(0, parseFloat(n4)));
        if (processPercent) {
          n4 = parseInt(n4 * max3, 10) / 100;
        }
        if (Math2.abs(n4 - max3) < 1e-6) {
          return 1;
        }
        return n4 % max3 / parseFloat(max3);
      }
      function clamp01(val) {
        return mathMin(1, mathMax(0, val));
      }
      function parseIntFromHex(val) {
        return parseInt(val, 16);
      }
      function isOnePointZero(n4) {
        return typeof n4 == "string" && n4.indexOf(".") != -1 && parseFloat(n4) === 1;
      }
      function isPercentage(n4) {
        return typeof n4 === "string" && n4.indexOf("%") != -1;
      }
      function pad2(c3) {
        return c3.length == 1 ? "0" + c3 : "" + c3;
      }
      function convertToPercentage(n4) {
        if (n4 <= 1) {
          n4 = n4 * 100 + "%";
        }
        return n4;
      }
      function convertDecimalToHex(d3) {
        return Math2.round(parseFloat(d3) * 255).toString(16);
      }
      function convertHexToDecimal(h3) {
        return parseIntFromHex(h3) / 255;
      }
      var matchers = function() {
        var CSS_INTEGER = "[-\\+]?\\d+%?";
        var CSS_NUMBER = "[-\\+]?\\d*\\.\\d+%?";
        var CSS_UNIT = "(?:" + CSS_NUMBER + ")|(?:" + CSS_INTEGER + ")";
        var PERMISSIVE_MATCH3 = "[\\s|\\(]+(" + CSS_UNIT + ")[,|\\s]+(" + CSS_UNIT + ")[,|\\s]+(" + CSS_UNIT + ")\\s*\\)?";
        var PERMISSIVE_MATCH4 = "[\\s|\\(]+(" + CSS_UNIT + ")[,|\\s]+(" + CSS_UNIT + ")[,|\\s]+(" + CSS_UNIT + ")[,|\\s]+(" + CSS_UNIT + ")\\s*\\)?";
        return {
          CSS_UNIT: new RegExp(CSS_UNIT),
          rgb: new RegExp("rgb" + PERMISSIVE_MATCH3),
          rgba: new RegExp("rgba" + PERMISSIVE_MATCH4),
          hsl: new RegExp("hsl" + PERMISSIVE_MATCH3),
          hsla: new RegExp("hsla" + PERMISSIVE_MATCH4),
          hsv: new RegExp("hsv" + PERMISSIVE_MATCH3),
          hsva: new RegExp("hsva" + PERMISSIVE_MATCH4),
          hex3: /^#?([0-9a-fA-F]{1})([0-9a-fA-F]{1})([0-9a-fA-F]{1})$/,
          hex6: /^#?([0-9a-fA-F]{2})([0-9a-fA-F]{2})([0-9a-fA-F]{2})$/,
          hex4: /^#?([0-9a-fA-F]{1})([0-9a-fA-F]{1})([0-9a-fA-F]{1})([0-9a-fA-F]{1})$/,
          hex8: /^#?([0-9a-fA-F]{2})([0-9a-fA-F]{2})([0-9a-fA-F]{2})([0-9a-fA-F]{2})$/
        };
      }();
      function isValidCSSUnit(color) {
        return !!matchers.CSS_UNIT.exec(color);
      }
      function stringInputToObject(color) {
        color = color.replace(trimLeft, "").replace(trimRight, "").toLowerCase();
        var named = false;
        if (names[color]) {
          color = names[color];
          named = true;
        } else if (color == "transparent") {
          return { r: 0, g: 0, b: 0, a: 0, format: "name" };
        }
        var match;
        if (match = matchers.rgb.exec(color)) {
          return { r: match[1], g: match[2], b: match[3] };
        }
        if (match = matchers.rgba.exec(color)) {
          return { r: match[1], g: match[2], b: match[3], a: match[4] };
        }
        if (match = matchers.hsl.exec(color)) {
          return { h: match[1], s: match[2], l: match[3] };
        }
        if (match = matchers.hsla.exec(color)) {
          return { h: match[1], s: match[2], l: match[3], a: match[4] };
        }
        if (match = matchers.hsv.exec(color)) {
          return { h: match[1], s: match[2], v: match[3] };
        }
        if (match = matchers.hsva.exec(color)) {
          return { h: match[1], s: match[2], v: match[3], a: match[4] };
        }
        if (match = matchers.hex8.exec(color)) {
          return {
            r: parseIntFromHex(match[1]),
            g: parseIntFromHex(match[2]),
            b: parseIntFromHex(match[3]),
            a: convertHexToDecimal(match[4]),
            format: named ? "name" : "hex8"
          };
        }
        if (match = matchers.hex6.exec(color)) {
          return {
            r: parseIntFromHex(match[1]),
            g: parseIntFromHex(match[2]),
            b: parseIntFromHex(match[3]),
            format: named ? "name" : "hex"
          };
        }
        if (match = matchers.hex4.exec(color)) {
          return {
            r: parseIntFromHex(match[1] + "" + match[1]),
            g: parseIntFromHex(match[2] + "" + match[2]),
            b: parseIntFromHex(match[3] + "" + match[3]),
            a: convertHexToDecimal(match[4] + "" + match[4]),
            format: named ? "name" : "hex8"
          };
        }
        if (match = matchers.hex3.exec(color)) {
          return {
            r: parseIntFromHex(match[1] + "" + match[1]),
            g: parseIntFromHex(match[2] + "" + match[2]),
            b: parseIntFromHex(match[3] + "" + match[3]),
            format: named ? "name" : "hex"
          };
        }
        return false;
      }
      function validateWCAG2Parms(parms) {
        var level, size4;
        parms = parms || { "level": "AA", "size": "small" };
        level = (parms.level || "AA").toUpperCase();
        size4 = (parms.size || "small").toLowerCase();
        if (level !== "AA" && level !== "AAA") {
          level = "AA";
        }
        if (size4 !== "small" && size4 !== "large") {
          size4 = "small";
        }
        return { "level": level, "size": size4 };
      }
      if (typeof module !== "undefined" && module.exports) {
        module.exports = tinycolor11;
      } else if (typeof define === "function" && define.amd) {
        define(function() {
          return tinycolor11;
        });
      } else {
        window.tinycolor = tinycolor11;
      }
    })(Math);
  }
});

// public/app/config/icons.js
var icons_exports = {};
__export(icons_exports, {
  availableIconAliases: () => availableIconAliases,
  availableIcons: () => availableIcons,
  iconClass: () => iconClass
});
function iconClass(input) {
  if (!input) {
    return "";
  }
  if (availableIconAliases[input]) {
    input = availableIconAliases[input];
  }
  if (input.substr(0, 3) === "bi-") {
    return input;
  }
  if (input.substr(0, 4) === "kfi-") {
    return "kfi " + input;
  }
  if (input.substr(0, 3) === "fa-") {
    return "fa " + input;
  }
  return "fa fa-" + input;
}
var availableIcons, availableIconAliases;
var init_icons = __esm({
  "public/app/config/icons.js"() {
    availableIcons = [
      "comments",
      "road",
      "anchor",
      "rocket",
      "line-chart",
      "bolt",
      "bomb",
      "flask",
      "globe",
      "leaf",
      "lock",
      "magic",
      "magnet",
      "paw",
      "retweet",
      "unlock",
      "alarm",
      "asterisk",
      "at",
      "award",
      "bag",
      "ban",
      "bank",
      "bar-chart",
      "gant",
      "basket",
      "battery",
      "bell",
      "bicycle",
      "binoculars",
      "birthday-cake",
      "text",
      "book",
      "bookmarks",
      "box",
      "braces",
      "bricks",
      "suitcase",
      "broadcast",
      "brush",
      "bucket",
      "bug",
      "buildings",
      "bullseye",
      "calculator",
      "calendar",
      "calendar-check",
      "camera",
      "camera-video",
      "shopping-cart",
      "cash",
      "check",
      "checkbox",
      "clipboard",
      "clock",
      "cloud",
      "rain",
      "code",
      "coin",
      "compass",
      "cone",
      "controller",
      "cpu",
      "credit-card",
      "cup",
      "bitcoin",
      "dollar",
      "euro",
      "diargram",
      "dice",
      "display",
      "door",
      "droplet",
      "earbuds",
      "whiteboard",
      "envelope",
      "danger",
      "exclamation-triangle",
      "eye",
      "files",
      "film",
      "flag",
      "flower",
      "folder",
      "gear",
      "gem",
      "gift",
      "grid",
      "hammer",
      "hash",
      "hdd",
      "headset",
      "heart",
      "hourglass",
      "house",
      "image",
      "inbox",
      "info-circle",
      "joystick",
      "key",
      "life-preserver",
      "lightbulb",
      "link",
      "map",
      "megaphone",
      "mic",
      "moon",
      "music-note",
      "newspaper",
      "question-circle",
      "palette",
      "paperclip",
      "pause",
      "pencil",
      "people",
      "person",
      "pie-chart",
      "piggy-bank",
      "pin",
      "play",
      "plug",
      "power",
      "printer",
      "puzzle",
      "receipt",
      "recycle",
      "rss",
      "scissors",
      "server",
      "shield",
      "shop",
      "signpost",
      "snow",
      "speedometer",
      "stack",
      "star",
      "stars",
      "stoplights",
      "stopwatch",
      "sun",
      "sunglasses",
      "tags",
      "telephone",
      "terminal",
      "thermometer",
      "tools",
      "trash",
      "tree",
      "trophy",
      "truck",
      "umbrella",
      "sound",
      "watch",
      "wifi",
      "wind",
      "wrench",
      "kanban",
      "timeline",
      "form",
      "play-circle"
    ];
    availableIconAliases = {
      // Font Awesome 4
      "comments": "fa-comments",
      "road": "fa-road",
      "anchor": "fa-anchor",
      "ban": "fa-ban",
      "birthday-cake": "fa-birthday-cake",
      "bolt": "fa-bolt",
      "bomb": "fa-bomb",
      "flask": "fa-flask",
      "globe": "fa-globe",
      "leaf": "fa-leaf",
      "lock": "fa-lock",
      "magic": "fa-magic",
      "magnet": "fa-magnet",
      "paw": "fa-paw",
      "rocket": "fa-rocket",
      "retweet": "fa-retweet",
      "unlock": "fa-unlock",
      // Bootstrap Icons
      "alarm": "bi-alarm-fill",
      "asterisk": "bi-asterisk",
      "at": "bi-at",
      "award": "bi-award-fill",
      "bag": "bi-bag",
      "bank": "bi-bank2",
      "bar-chart": "bi-bar-chart-fill",
      "gant": "bi-bar-chart-steps",
      "basket": "bi-basket-fill",
      "battery": "bi-battery-full",
      "bell": "bi-bell-fill",
      "bicycle": "bi-bicycle",
      "binoculars": "bi-binoculars-fill",
      "text": "bi-blockquote-left",
      "book": "bi-book",
      "bookmarks": "bi-bookmarks",
      "box": "bi-box",
      "braces": "bi-braces",
      "bricks": "bi-bricks",
      "suitcase": "bi-briefcase-fill",
      "broadcast": "bi-broadcast",
      "brush": "bi-brush-fill",
      "bucket": "bi-bucket-fill",
      "bug": "bi-bug-fill",
      "buildings": "bi-building",
      "bullseye": "bi-bullseye",
      "calculator": "bi-calculator",
      "calendar": "bi-calendar",
      "calendar-check": "bi-calendar2-check",
      "camera": "bi-camera-fill",
      "camera-video": "bi-camera-reels-fill",
      "shopping-cart": "bi-cart",
      "cash": "bi-cash-coin",
      "check": "bi-check2",
      "checkbox": "bi-check2-square",
      "clipboard": "bi-clipboard",
      "clock": "bi-clock",
      "cloud": "bi-cloud-fill",
      "rain": "bi-cloud-rain-heavy-fill",
      "code": "bi-code-slash",
      "coin": "bi-coin",
      "compass": "bi-compass",
      "cone": "bi-cone-striped",
      "controller": "bi-controller",
      "cpu": "bi-cpu-fill",
      "credit-card": "bi-credit-card",
      "cup": "bi-cup-straw",
      "bitcoin": "bi-currency-bitcoin",
      "dollar": "bi-currency-dollar",
      "euro": "bi-currency-euro",
      "diargram": "bi-diagram-3-fill",
      "dice": "bi-dice-6",
      "display": "bi-display",
      "door": "bi-door-closed",
      "droplet": "bi-droplet-fill",
      "earbuds": "bi-earbuds",
      "whiteboard": "bi-easel",
      "envelope": "bi-envelope",
      "danger": "bi-exclamation-diamond-fill",
      "exclamation-triangle": "bi-exclamation-triangle-fill",
      "eye": "bi-eye",
      "files": "bi-files",
      "film": "bi-film",
      "flag": "bi-flag",
      "flower": "bi-flower1",
      "folder": "bi-folder",
      "gear": "bi-gear-fill",
      "gem": "bi-gem",
      "gift": "bi-gift",
      "grid": "bi-grid-3x3-gap-fill",
      "line-chart": "bi-graph-up",
      "hammer": "bi-hammer",
      "hash": "bi-hash",
      "hdd": "bi-hdd",
      "headset": "bi-headset",
      "heart": "bi-heart-fill",
      "hourglass": "bi-hourglass-split",
      "house": "bi-house-fill",
      "image": "bi-image",
      "inbox": "bi-inbox-fill",
      "info-circle": "bi-info-circle-fill",
      "joystick": "bi-joystick",
      "key": "bi-key",
      "life-preserver": "bi-life-preserver",
      "lightbulb": "bi-lightbulb",
      "link": "bi-link",
      "map": "bi-map-fill",
      "megaphone": "bi-megaphone",
      "mic": "bi-mic",
      "moon": "bi-moon",
      "music-note": "bi-music-note-beamed",
      "newspaper": "bi-newspaper",
      "question-circle": "bi-question-circle-fill",
      "palette": "bi-palette",
      "paperclip": "bi-paperclip",
      "pause": "bi-pause-fill",
      "pencil": "bi-pencil-fill",
      "people": "bi-people-fill",
      "person": "bi-person-fill",
      "pie-chart": "bi-pie-chart-fill",
      "piggy-bank": "bi-piggy-bank",
      "pin": "bi-pin-angle-fill",
      "play": "bi-play-fill",
      "plug": "bi-plug-fill",
      "power": "bi-power",
      "printer": "bi-printer",
      "puzzle": "bi-puzzle-fill",
      "receipt": "bi-receipt",
      "recycle": "bi-recycle",
      "rss": "bi-rss-fill",
      "scissors": "bi-scissors",
      "server": "bi-server",
      "shield": "bi-shield-shaded",
      "shop": "bi-shop",
      "signpost": "bi-signpost-2-fill",
      "snow": "bi-snow",
      "speedometer": "bi-speedometer",
      "stack": "bi-stack",
      "star": "bi-star-fill",
      "stars": "bi-stars",
      "stoplights": "bi-stoplights-fill",
      "stopwatch": "bi-stopwatch",
      "sun": "bi-sun-fill",
      "sunglasses": "bi-sunglasses",
      "tags": "bi-tags",
      "telephone": "bi-telephone-fill",
      "terminal": "bi-terminal",
      "thermometer": "bi-thermometer-half",
      "tools": "bi-tools",
      "trash": "fa-trash",
      "tree": "bi-tree-fill",
      "trophy": "bi-trophy-fill",
      "truck": "bi-truck",
      "umbrella": "bi-umbrella-fill",
      "sound": "bi-volume-up-fill",
      "watch": "bi-watch",
      "wifi": "bi-wifi",
      "wind": "bi-wind",
      "wrench": "bi-wrench",
      // aliases
      "life-ring": "bi-life-preserver",
      "calendar-check-o": "bi-calendar2-check",
      "dashboard": "bi-speedometer",
      "check-square-o": "bi-check2-square",
      "times": "fa-times",
      // view modes
      "kanban": "kfi-kanban",
      "timeline": "kfi-timeline",
      "form": "kfi-form",
      // automations
      "play-circle": "bi-play-circle"
    };
  }
});

// node_modules/core-js/internals/global.js
var require_global = __commonJS({
  "node_modules/core-js/internals/global.js"(exports, module) {
    var check = function(it2) {
      return it2 && it2.Math == Math && it2;
    };
    module.exports = // eslint-disable-next-line es-x/no-global-this -- safe
    check(typeof globalThis == "object" && globalThis) || check(typeof window == "object" && window) || // eslint-disable-next-line no-restricted-globals -- safe
    check(typeof self == "object" && self) || check(typeof global == "object" && global) || // eslint-disable-next-line no-new-func -- fallback
    /* @__PURE__ */ function() {
      return this;
    }() || Function("return this")();
  }
});

// node_modules/core-js/internals/is-pure.js
var require_is_pure = __commonJS({
  "node_modules/core-js/internals/is-pure.js"(exports, module) {
    module.exports = false;
  }
});

// node_modules/core-js/internals/define-global-property.js
var require_define_global_property = __commonJS({
  "node_modules/core-js/internals/define-global-property.js"(exports, module) {
    var global5 = require_global();
    var defineProperty2 = Object.defineProperty;
    module.exports = function(key, value2) {
      try {
        defineProperty2(global5, key, { value: value2, configurable: true, writable: true });
      } catch (error) {
        global5[key] = value2;
      }
      return value2;
    };
  }
});

// node_modules/core-js/internals/shared-store.js
var require_shared_store = __commonJS({
  "node_modules/core-js/internals/shared-store.js"(exports, module) {
    var global5 = require_global();
    var defineGlobalProperty = require_define_global_property();
    var SHARED = "__core-js_shared__";
    var store2 = global5[SHARED] || defineGlobalProperty(SHARED, {});
    module.exports = store2;
  }
});

// node_modules/core-js/internals/shared.js
var require_shared = __commonJS({
  "node_modules/core-js/internals/shared.js"(exports, module) {
    var IS_PURE = require_is_pure();
    var store2 = require_shared_store();
    (module.exports = function(key, value2) {
      return store2[key] || (store2[key] = value2 !== void 0 ? value2 : {});
    })("versions", []).push({
      version: "3.25.1",
      mode: IS_PURE ? "pure" : "global",
      copyright: "\xA9 2014-2022 Denis Pushkarev (zloirock.ru)",
      license: "https://github.com/zloirock/core-js/blob/v3.25.1/LICENSE",
      source: "https://github.com/zloirock/core-js"
    });
  }
});

// node_modules/core-js/internals/fails.js
var require_fails = __commonJS({
  "node_modules/core-js/internals/fails.js"(exports, module) {
    module.exports = function(exec) {
      try {
        return !!exec();
      } catch (error) {
        return true;
      }
    };
  }
});

// node_modules/core-js/internals/function-bind-native.js
var require_function_bind_native = __commonJS({
  "node_modules/core-js/internals/function-bind-native.js"(exports, module) {
    var fails2 = require_fails();
    module.exports = !fails2(function() {
      var test = function() {
      }.bind();
      return typeof test != "function" || test.hasOwnProperty("prototype");
    });
  }
});

// node_modules/core-js/internals/function-uncurry-this.js
var require_function_uncurry_this = __commonJS({
  "node_modules/core-js/internals/function-uncurry-this.js"(exports, module) {
    var NATIVE_BIND = require_function_bind_native();
    var FunctionPrototype2 = Function.prototype;
    var bind2 = FunctionPrototype2.bind;
    var call3 = FunctionPrototype2.call;
    var uncurryThis3 = NATIVE_BIND && bind2.bind(call3, call3);
    module.exports = NATIVE_BIND ? function(fn) {
      return fn && uncurryThis3(fn);
    } : function(fn) {
      return fn && function() {
        return call3.apply(fn, arguments);
      };
    };
  }
});

// node_modules/core-js/internals/is-null-or-undefined.js
var require_is_null_or_undefined = __commonJS({
  "node_modules/core-js/internals/is-null-or-undefined.js"(exports, module) {
    module.exports = function(it2) {
      return it2 === null || it2 === void 0;
    };
  }
});

// node_modules/core-js/internals/require-object-coercible.js
var require_require_object_coercible = __commonJS({
  "node_modules/core-js/internals/require-object-coercible.js"(exports, module) {
    var isNullOrUndefined3 = require_is_null_or_undefined();
    var $TypeError = TypeError;
    module.exports = function(it2) {
      if (isNullOrUndefined3(it2)) throw $TypeError("Can't call method on " + it2);
      return it2;
    };
  }
});

// node_modules/core-js/internals/to-object.js
var require_to_object = __commonJS({
  "node_modules/core-js/internals/to-object.js"(exports, module) {
    var requireObjectCoercible3 = require_require_object_coercible();
    var $Object = Object;
    module.exports = function(argument) {
      return $Object(requireObjectCoercible3(argument));
    };
  }
});

// node_modules/core-js/internals/has-own-property.js
var require_has_own_property = __commonJS({
  "node_modules/core-js/internals/has-own-property.js"(exports, module) {
    var uncurryThis3 = require_function_uncurry_this();
    var toObject = require_to_object();
    var hasOwnProperty2 = uncurryThis3({}.hasOwnProperty);
    module.exports = Object.hasOwn || function hasOwn(it2, key) {
      return hasOwnProperty2(toObject(it2), key);
    };
  }
});

// node_modules/core-js/internals/uid.js
var require_uid = __commonJS({
  "node_modules/core-js/internals/uid.js"(exports, module) {
    var uncurryThis3 = require_function_uncurry_this();
    var id = 0;
    var postfix = Math.random();
    var toString6 = uncurryThis3(1 .toString);
    module.exports = function(key) {
      return "Symbol(" + (key === void 0 ? "" : key) + ")_" + toString6(++id + postfix, 36);
    };
  }
});

// node_modules/core-js/internals/is-callable.js
var require_is_callable = __commonJS({
  "node_modules/core-js/internals/is-callable.js"(exports, module) {
    module.exports = function(argument) {
      return typeof argument == "function";
    };
  }
});

// node_modules/core-js/internals/get-built-in.js
var require_get_built_in = __commonJS({
  "node_modules/core-js/internals/get-built-in.js"(exports, module) {
    var global5 = require_global();
    var isCallable2 = require_is_callable();
    var aFunction = function(argument) {
      return isCallable2(argument) ? argument : void 0;
    };
    module.exports = function(namespace, method) {
      return arguments.length < 2 ? aFunction(global5[namespace]) : global5[namespace] && global5[namespace][method];
    };
  }
});

// node_modules/core-js/internals/engine-user-agent.js
var require_engine_user_agent = __commonJS({
  "node_modules/core-js/internals/engine-user-agent.js"(exports, module) {
    var getBuiltIn = require_get_built_in();
    module.exports = getBuiltIn("navigator", "userAgent") || "";
  }
});

// node_modules/core-js/internals/engine-v8-version.js
var require_engine_v8_version = __commonJS({
  "node_modules/core-js/internals/engine-v8-version.js"(exports, module) {
    var global5 = require_global();
    var userAgent = require_engine_user_agent();
    var process3 = global5.process;
    var Deno = global5.Deno;
    var versions = process3 && process3.versions || Deno && Deno.version;
    var v8 = versions && versions.v8;
    var match;
    var version;
    if (v8) {
      match = v8.split(".");
      version = match[0] > 0 && match[0] < 4 ? 1 : +(match[0] + match[1]);
    }
    if (!version && userAgent) {
      match = userAgent.match(/Edge\/(\d+)/);
      if (!match || match[1] >= 74) {
        match = userAgent.match(/Chrome\/(\d+)/);
        if (match) version = +match[1];
      }
    }
    module.exports = version;
  }
});

// node_modules/core-js/internals/symbol-constructor-detection.js
var require_symbol_constructor_detection = __commonJS({
  "node_modules/core-js/internals/symbol-constructor-detection.js"(exports, module) {
    var V8_VERSION = require_engine_v8_version();
    var fails2 = require_fails();
    module.exports = !!Object.getOwnPropertySymbols && !fails2(function() {
      var symbol = Symbol();
      return !String(symbol) || !(Object(symbol) instanceof Symbol) || // Chrome 38-40 symbols are not inherited from DOM collections prototypes to instances
      !Symbol.sham && V8_VERSION && V8_VERSION < 41;
    });
  }
});

// node_modules/core-js/internals/use-symbol-as-uid.js
var require_use_symbol_as_uid = __commonJS({
  "node_modules/core-js/internals/use-symbol-as-uid.js"(exports, module) {
    var NATIVE_SYMBOL = require_symbol_constructor_detection();
    module.exports = NATIVE_SYMBOL && !Symbol.sham && typeof Symbol.iterator == "symbol";
  }
});

// node_modules/core-js/internals/well-known-symbol.js
var require_well_known_symbol = __commonJS({
  "node_modules/core-js/internals/well-known-symbol.js"(exports, module) {
    var global5 = require_global();
    var shared = require_shared();
    var hasOwn = require_has_own_property();
    var uid = require_uid();
    var NATIVE_SYMBOL = require_symbol_constructor_detection();
    var USE_SYMBOL_AS_UID = require_use_symbol_as_uid();
    var WellKnownSymbolsStore = shared("wks");
    var Symbol2 = global5.Symbol;
    var symbolFor = Symbol2 && Symbol2["for"];
    var createWellKnownSymbol = USE_SYMBOL_AS_UID ? Symbol2 : Symbol2 && Symbol2.withoutSetter || uid;
    module.exports = function(name) {
      if (!hasOwn(WellKnownSymbolsStore, name) || !(NATIVE_SYMBOL || typeof WellKnownSymbolsStore[name] == "string")) {
        var description = "Symbol." + name;
        if (NATIVE_SYMBOL && hasOwn(Symbol2, name)) {
          WellKnownSymbolsStore[name] = Symbol2[name];
        } else if (USE_SYMBOL_AS_UID && symbolFor) {
          WellKnownSymbolsStore[name] = symbolFor(description);
        } else {
          WellKnownSymbolsStore[name] = createWellKnownSymbol(description);
        }
      }
      return WellKnownSymbolsStore[name];
    };
  }
});

// node_modules/core-js/internals/to-string-tag-support.js
var require_to_string_tag_support = __commonJS({
  "node_modules/core-js/internals/to-string-tag-support.js"(exports, module) {
    var wellKnownSymbol3 = require_well_known_symbol();
    var TO_STRING_TAG2 = wellKnownSymbol3("toStringTag");
    var test = {};
    test[TO_STRING_TAG2] = "z";
    module.exports = String(test) === "[object z]";
  }
});

// node_modules/core-js/internals/descriptors.js
var require_descriptors = __commonJS({
  "node_modules/core-js/internals/descriptors.js"(exports, module) {
    var fails2 = require_fails();
    module.exports = !fails2(function() {
      return Object.defineProperty({}, 1, { get: function() {
        return 7;
      } })[1] != 7;
    });
  }
});

// node_modules/core-js/internals/is-object.js
var require_is_object = __commonJS({
  "node_modules/core-js/internals/is-object.js"(exports, module) {
    var isCallable2 = require_is_callable();
    var documentAll = typeof document == "object" && document.all;
    var SPECIAL_DOCUMENT_ALL = typeof documentAll == "undefined" && documentAll !== void 0;
    module.exports = SPECIAL_DOCUMENT_ALL ? function(it2) {
      return typeof it2 == "object" ? it2 !== null : isCallable2(it2) || it2 === documentAll;
    } : function(it2) {
      return typeof it2 == "object" ? it2 !== null : isCallable2(it2);
    };
  }
});

// node_modules/core-js/internals/document-create-element.js
var require_document_create_element = __commonJS({
  "node_modules/core-js/internals/document-create-element.js"(exports, module) {
    var global5 = require_global();
    var isObject4 = require_is_object();
    var document2 = global5.document;
    var EXISTS = isObject4(document2) && isObject4(document2.createElement);
    module.exports = function(it2) {
      return EXISTS ? document2.createElement(it2) : {};
    };
  }
});

// node_modules/core-js/internals/ie8-dom-define.js
var require_ie8_dom_define = __commonJS({
  "node_modules/core-js/internals/ie8-dom-define.js"(exports, module) {
    var DESCRIPTORS2 = require_descriptors();
    var fails2 = require_fails();
    var createElement2 = require_document_create_element();
    module.exports = !DESCRIPTORS2 && !fails2(function() {
      return Object.defineProperty(createElement2("div"), "a", {
        get: function() {
          return 7;
        }
      }).a != 7;
    });
  }
});

// node_modules/core-js/internals/v8-prototype-define-bug.js
var require_v8_prototype_define_bug = __commonJS({
  "node_modules/core-js/internals/v8-prototype-define-bug.js"(exports, module) {
    var DESCRIPTORS2 = require_descriptors();
    var fails2 = require_fails();
    module.exports = DESCRIPTORS2 && fails2(function() {
      return Object.defineProperty(function() {
      }, "prototype", {
        value: 42,
        writable: false
      }).prototype != 42;
    });
  }
});

// node_modules/core-js/internals/an-object.js
var require_an_object = __commonJS({
  "node_modules/core-js/internals/an-object.js"(exports, module) {
    var isObject4 = require_is_object();
    var $String = String;
    var $TypeError = TypeError;
    module.exports = function(argument) {
      if (isObject4(argument)) return argument;
      throw $TypeError($String(argument) + " is not an object");
    };
  }
});

// node_modules/core-js/internals/function-call.js
var require_function_call = __commonJS({
  "node_modules/core-js/internals/function-call.js"(exports, module) {
    var NATIVE_BIND = require_function_bind_native();
    var call3 = Function.prototype.call;
    module.exports = NATIVE_BIND ? call3.bind(call3) : function() {
      return call3.apply(call3, arguments);
    };
  }
});

// node_modules/core-js/internals/object-is-prototype-of.js
var require_object_is_prototype_of = __commonJS({
  "node_modules/core-js/internals/object-is-prototype-of.js"(exports, module) {
    var uncurryThis3 = require_function_uncurry_this();
    module.exports = uncurryThis3({}.isPrototypeOf);
  }
});

// node_modules/core-js/internals/is-symbol.js
var require_is_symbol = __commonJS({
  "node_modules/core-js/internals/is-symbol.js"(exports, module) {
    var getBuiltIn = require_get_built_in();
    var isCallable2 = require_is_callable();
    var isPrototypeOf = require_object_is_prototype_of();
    var USE_SYMBOL_AS_UID = require_use_symbol_as_uid();
    var $Object = Object;
    module.exports = USE_SYMBOL_AS_UID ? function(it2) {
      return typeof it2 == "symbol";
    } : function(it2) {
      var $Symbol = getBuiltIn("Symbol");
      return isCallable2($Symbol) && isPrototypeOf($Symbol.prototype, $Object(it2));
    };
  }
});

// node_modules/core-js/internals/try-to-string.js
var require_try_to_string = __commonJS({
  "node_modules/core-js/internals/try-to-string.js"(exports, module) {
    var $String = String;
    module.exports = function(argument) {
      try {
        return $String(argument);
      } catch (error) {
        return "Object";
      }
    };
  }
});

// node_modules/core-js/internals/a-callable.js
var require_a_callable = __commonJS({
  "node_modules/core-js/internals/a-callable.js"(exports, module) {
    var isCallable2 = require_is_callable();
    var tryToString = require_try_to_string();
    var $TypeError = TypeError;
    module.exports = function(argument) {
      if (isCallable2(argument)) return argument;
      throw $TypeError(tryToString(argument) + " is not a function");
    };
  }
});

// node_modules/core-js/internals/get-method.js
var require_get_method = __commonJS({
  "node_modules/core-js/internals/get-method.js"(exports, module) {
    var aCallable = require_a_callable();
    var isNullOrUndefined3 = require_is_null_or_undefined();
    module.exports = function(V2, P3) {
      var func = V2[P3];
      return isNullOrUndefined3(func) ? void 0 : aCallable(func);
    };
  }
});

// node_modules/core-js/internals/ordinary-to-primitive.js
var require_ordinary_to_primitive = __commonJS({
  "node_modules/core-js/internals/ordinary-to-primitive.js"(exports, module) {
    var call3 = require_function_call();
    var isCallable2 = require_is_callable();
    var isObject4 = require_is_object();
    var $TypeError = TypeError;
    module.exports = function(input, pref) {
      var fn, val;
      if (pref === "string" && isCallable2(fn = input.toString) && !isObject4(val = call3(fn, input))) return val;
      if (isCallable2(fn = input.valueOf) && !isObject4(val = call3(fn, input))) return val;
      if (pref !== "string" && isCallable2(fn = input.toString) && !isObject4(val = call3(fn, input))) return val;
      throw $TypeError("Can't convert object to primitive value");
    };
  }
});

// node_modules/core-js/internals/to-primitive.js
var require_to_primitive = __commonJS({
  "node_modules/core-js/internals/to-primitive.js"(exports, module) {
    var call3 = require_function_call();
    var isObject4 = require_is_object();
    var isSymbol = require_is_symbol();
    var getMethod3 = require_get_method();
    var ordinaryToPrimitive = require_ordinary_to_primitive();
    var wellKnownSymbol3 = require_well_known_symbol();
    var $TypeError = TypeError;
    var TO_PRIMITIVE = wellKnownSymbol3("toPrimitive");
    module.exports = function(input, pref) {
      if (!isObject4(input) || isSymbol(input)) return input;
      var exoticToPrim = getMethod3(input, TO_PRIMITIVE);
      var result2;
      if (exoticToPrim) {
        if (pref === void 0) pref = "default";
        result2 = call3(exoticToPrim, input, pref);
        if (!isObject4(result2) || isSymbol(result2)) return result2;
        throw $TypeError("Can't convert object to primitive value");
      }
      if (pref === void 0) pref = "number";
      return ordinaryToPrimitive(input, pref);
    };
  }
});

// node_modules/core-js/internals/to-property-key.js
var require_to_property_key = __commonJS({
  "node_modules/core-js/internals/to-property-key.js"(exports, module) {
    var toPrimitive = require_to_primitive();
    var isSymbol = require_is_symbol();
    module.exports = function(argument) {
      var key = toPrimitive(argument, "string");
      return isSymbol(key) ? key : key + "";
    };
  }
});

// node_modules/core-js/internals/object-define-property.js
var require_object_define_property = __commonJS({
  "node_modules/core-js/internals/object-define-property.js"(exports) {
    var DESCRIPTORS2 = require_descriptors();
    var IE8_DOM_DEFINE = require_ie8_dom_define();
    var V8_PROTOTYPE_DEFINE_BUG = require_v8_prototype_define_bug();
    var anObject3 = require_an_object();
    var toPropertyKey = require_to_property_key();
    var $TypeError = TypeError;
    var $defineProperty = Object.defineProperty;
    var $getOwnPropertyDescriptor = Object.getOwnPropertyDescriptor;
    var ENUMERABLE = "enumerable";
    var CONFIGURABLE = "configurable";
    var WRITABLE = "writable";
    exports.f = DESCRIPTORS2 ? V8_PROTOTYPE_DEFINE_BUG ? function defineProperty2(O4, P3, Attributes) {
      anObject3(O4);
      P3 = toPropertyKey(P3);
      anObject3(Attributes);
      if (typeof O4 === "function" && P3 === "prototype" && "value" in Attributes && WRITABLE in Attributes && !Attributes[WRITABLE]) {
        var current = $getOwnPropertyDescriptor(O4, P3);
        if (current && current[WRITABLE]) {
          O4[P3] = Attributes.value;
          Attributes = {
            configurable: CONFIGURABLE in Attributes ? Attributes[CONFIGURABLE] : current[CONFIGURABLE],
            enumerable: ENUMERABLE in Attributes ? Attributes[ENUMERABLE] : current[ENUMERABLE],
            writable: false
          };
        }
      }
      return $defineProperty(O4, P3, Attributes);
    } : $defineProperty : function defineProperty2(O4, P3, Attributes) {
      anObject3(O4);
      P3 = toPropertyKey(P3);
      anObject3(Attributes);
      if (IE8_DOM_DEFINE) try {
        return $defineProperty(O4, P3, Attributes);
      } catch (error) {
      }
      if ("get" in Attributes || "set" in Attributes) throw $TypeError("Accessors not supported");
      if ("value" in Attributes) O4[P3] = Attributes.value;
      return O4;
    };
  }
});

// node_modules/core-js/internals/function-name.js
var require_function_name = __commonJS({
  "node_modules/core-js/internals/function-name.js"(exports, module) {
    var DESCRIPTORS2 = require_descriptors();
    var hasOwn = require_has_own_property();
    var FunctionPrototype2 = Function.prototype;
    var getDescriptor = DESCRIPTORS2 && Object.getOwnPropertyDescriptor;
    var EXISTS = hasOwn(FunctionPrototype2, "name");
    var PROPER = EXISTS && function something() {
    }.name === "something";
    var CONFIGURABLE = EXISTS && (!DESCRIPTORS2 || DESCRIPTORS2 && getDescriptor(FunctionPrototype2, "name").configurable);
    module.exports = {
      EXISTS,
      PROPER,
      CONFIGURABLE
    };
  }
});

// node_modules/core-js/internals/inspect-source.js
var require_inspect_source = __commonJS({
  "node_modules/core-js/internals/inspect-source.js"(exports, module) {
    var uncurryThis3 = require_function_uncurry_this();
    var isCallable2 = require_is_callable();
    var store2 = require_shared_store();
    var functionToString2 = uncurryThis3(Function.toString);
    if (!isCallable2(store2.inspectSource)) {
      store2.inspectSource = function(it2) {
        return functionToString2(it2);
      };
    }
    module.exports = store2.inspectSource;
  }
});

// node_modules/core-js/internals/weak-map-basic-detection.js
var require_weak_map_basic_detection = __commonJS({
  "node_modules/core-js/internals/weak-map-basic-detection.js"(exports, module) {
    var global5 = require_global();
    var isCallable2 = require_is_callable();
    var WeakMap2 = global5.WeakMap;
    module.exports = isCallable2(WeakMap2) && /native code/.test(String(WeakMap2));
  }
});

// node_modules/core-js/internals/create-property-descriptor.js
var require_create_property_descriptor = __commonJS({
  "node_modules/core-js/internals/create-property-descriptor.js"(exports, module) {
    module.exports = function(bitmap, value2) {
      return {
        enumerable: !(bitmap & 1),
        configurable: !(bitmap & 2),
        writable: !(bitmap & 4),
        value: value2
      };
    };
  }
});

// node_modules/core-js/internals/create-non-enumerable-property.js
var require_create_non_enumerable_property = __commonJS({
  "node_modules/core-js/internals/create-non-enumerable-property.js"(exports, module) {
    var DESCRIPTORS2 = require_descriptors();
    var definePropertyModule = require_object_define_property();
    var createPropertyDescriptor = require_create_property_descriptor();
    module.exports = DESCRIPTORS2 ? function(object2, key, value2) {
      return definePropertyModule.f(object2, key, createPropertyDescriptor(1, value2));
    } : function(object2, key, value2) {
      object2[key] = value2;
      return object2;
    };
  }
});

// node_modules/core-js/internals/shared-key.js
var require_shared_key = __commonJS({
  "node_modules/core-js/internals/shared-key.js"(exports, module) {
    var shared = require_shared();
    var uid = require_uid();
    var keys4 = shared("keys");
    module.exports = function(key) {
      return keys4[key] || (keys4[key] = uid(key));
    };
  }
});

// node_modules/core-js/internals/hidden-keys.js
var require_hidden_keys = __commonJS({
  "node_modules/core-js/internals/hidden-keys.js"(exports, module) {
    module.exports = {};
  }
});

// node_modules/core-js/internals/internal-state.js
var require_internal_state = __commonJS({
  "node_modules/core-js/internals/internal-state.js"(exports, module) {
    var NATIVE_WEAK_MAP = require_weak_map_basic_detection();
    var global5 = require_global();
    var uncurryThis3 = require_function_uncurry_this();
    var isObject4 = require_is_object();
    var createNonEnumerableProperty3 = require_create_non_enumerable_property();
    var hasOwn = require_has_own_property();
    var shared = require_shared_store();
    var sharedKey = require_shared_key();
    var hiddenKeys = require_hidden_keys();
    var OBJECT_ALREADY_INITIALIZED = "Object already initialized";
    var TypeError2 = global5.TypeError;
    var WeakMap2 = global5.WeakMap;
    var set;
    var get3;
    var has3;
    var enforce = function(it2) {
      return has3(it2) ? get3(it2) : set(it2, {});
    };
    var getterFor = function(TYPE) {
      return function(it2) {
        var state;
        if (!isObject4(it2) || (state = get3(it2)).type !== TYPE) {
          throw TypeError2("Incompatible receiver, " + TYPE + " required");
        }
        return state;
      };
    };
    if (NATIVE_WEAK_MAP || shared.state) {
      store2 = shared.state || (shared.state = new WeakMap2());
      wmget = uncurryThis3(store2.get);
      wmhas = uncurryThis3(store2.has);
      wmset = uncurryThis3(store2.set);
      set = function(it2, metadata) {
        if (wmhas(store2, it2)) throw TypeError2(OBJECT_ALREADY_INITIALIZED);
        metadata.facade = it2;
        wmset(store2, it2, metadata);
        return metadata;
      };
      get3 = function(it2) {
        return wmget(store2, it2) || {};
      };
      has3 = function(it2) {
        return wmhas(store2, it2);
      };
    } else {
      STATE = sharedKey("state");
      hiddenKeys[STATE] = true;
      set = function(it2, metadata) {
        if (hasOwn(it2, STATE)) throw TypeError2(OBJECT_ALREADY_INITIALIZED);
        metadata.facade = it2;
        createNonEnumerableProperty3(it2, STATE, metadata);
        return metadata;
      };
      get3 = function(it2) {
        return hasOwn(it2, STATE) ? it2[STATE] : {};
      };
      has3 = function(it2) {
        return hasOwn(it2, STATE);
      };
    }
    var store2;
    var wmget;
    var wmhas;
    var wmset;
    var STATE;
    module.exports = {
      set,
      get: get3,
      has: has3,
      enforce,
      getterFor
    };
  }
});

// node_modules/core-js/internals/make-built-in.js
var require_make_built_in = __commonJS({
  "node_modules/core-js/internals/make-built-in.js"(exports, module) {
    var fails2 = require_fails();
    var isCallable2 = require_is_callable();
    var hasOwn = require_has_own_property();
    var DESCRIPTORS2 = require_descriptors();
    var CONFIGURABLE_FUNCTION_NAME = require_function_name().CONFIGURABLE;
    var inspectSource = require_inspect_source();
    var InternalStateModule2 = require_internal_state();
    var enforceInternalState = InternalStateModule2.enforce;
    var getInternalState2 = InternalStateModule2.get;
    var defineProperty2 = Object.defineProperty;
    var CONFIGURABLE_LENGTH = DESCRIPTORS2 && !fails2(function() {
      return defineProperty2(function() {
      }, "length", { value: 8 }).length !== 8;
    });
    var TEMPLATE = String(String).split("String");
    var makeBuiltIn = module.exports = function(value2, name, options2) {
      if (String(name).slice(0, 7) === "Symbol(") {
        name = "[" + String(name).replace(/^Symbol\(([^)]*)\)/, "$1") + "]";
      }
      if (options2 && options2.getter) name = "get " + name;
      if (options2 && options2.setter) name = "set " + name;
      if (!hasOwn(value2, "name") || CONFIGURABLE_FUNCTION_NAME && value2.name !== name) {
        if (DESCRIPTORS2) defineProperty2(value2, "name", { value: name, configurable: true });
        else value2.name = name;
      }
      if (CONFIGURABLE_LENGTH && options2 && hasOwn(options2, "arity") && value2.length !== options2.arity) {
        defineProperty2(value2, "length", { value: options2.arity });
      }
      try {
        if (options2 && hasOwn(options2, "constructor") && options2.constructor) {
          if (DESCRIPTORS2) defineProperty2(value2, "prototype", { writable: false });
        } else if (value2.prototype) value2.prototype = void 0;
      } catch (error) {
      }
      var state = enforceInternalState(value2);
      if (!hasOwn(state, "source")) {
        state.source = TEMPLATE.join(typeof name == "string" ? name : "");
      }
      return value2;
    };
    Function.prototype.toString = makeBuiltIn(function toString6() {
      return isCallable2(this) && getInternalState2(this).source || inspectSource(this);
    }, "toString");
  }
});

// node_modules/core-js/internals/define-built-in.js
var require_define_built_in = __commonJS({
  "node_modules/core-js/internals/define-built-in.js"(exports, module) {
    var isCallable2 = require_is_callable();
    var definePropertyModule = require_object_define_property();
    var makeBuiltIn = require_make_built_in();
    var defineGlobalProperty = require_define_global_property();
    module.exports = function(O4, key, value2, options2) {
      if (!options2) options2 = {};
      var simple = options2.enumerable;
      var name = options2.name !== void 0 ? options2.name : key;
      if (isCallable2(value2)) makeBuiltIn(value2, name, options2);
      if (options2.global) {
        if (simple) O4[key] = value2;
        else defineGlobalProperty(key, value2);
      } else {
        try {
          if (!options2.unsafe) delete O4[key];
          else if (O4[key]) simple = true;
        } catch (error) {
        }
        if (simple) O4[key] = value2;
        else definePropertyModule.f(O4, key, {
          value: value2,
          enumerable: false,
          configurable: !options2.nonConfigurable,
          writable: !options2.nonWritable
        });
      }
      return O4;
    };
  }
});

// node_modules/core-js/internals/classof-raw.js
var require_classof_raw = __commonJS({
  "node_modules/core-js/internals/classof-raw.js"(exports, module) {
    var uncurryThis3 = require_function_uncurry_this();
    var toString6 = uncurryThis3({}.toString);
    var stringSlice2 = uncurryThis3("".slice);
    module.exports = function(it2) {
      return stringSlice2(toString6(it2), 8, -1);
    };
  }
});

// node_modules/core-js/internals/classof.js
var require_classof = __commonJS({
  "node_modules/core-js/internals/classof.js"(exports, module) {
    var TO_STRING_TAG_SUPPORT2 = require_to_string_tag_support();
    var isCallable2 = require_is_callable();
    var classofRaw = require_classof_raw();
    var wellKnownSymbol3 = require_well_known_symbol();
    var TO_STRING_TAG2 = wellKnownSymbol3("toStringTag");
    var $Object = Object;
    var CORRECT_ARGUMENTS = classofRaw(/* @__PURE__ */ function() {
      return arguments;
    }()) == "Arguments";
    var tryGet = function(it2, key) {
      try {
        return it2[key];
      } catch (error) {
      }
    };
    module.exports = TO_STRING_TAG_SUPPORT2 ? classofRaw : function(it2) {
      var O4, tag, result2;
      return it2 === void 0 ? "Undefined" : it2 === null ? "Null" : typeof (tag = tryGet(O4 = $Object(it2), TO_STRING_TAG2)) == "string" ? tag : CORRECT_ARGUMENTS ? classofRaw(O4) : (result2 = classofRaw(O4)) == "Object" && isCallable2(O4.callee) ? "Arguments" : result2;
    };
  }
});

// node_modules/core-js/internals/object-to-string.js
var require_object_to_string = __commonJS({
  "node_modules/core-js/internals/object-to-string.js"(exports, module) {
    "use strict";
    var TO_STRING_TAG_SUPPORT2 = require_to_string_tag_support();
    var classof = require_classof();
    module.exports = TO_STRING_TAG_SUPPORT2 ? {}.toString : function toString6() {
      return "[object " + classof(this) + "]";
    };
  }
});

// node_modules/core-js/internals/dom-iterables.js
var require_dom_iterables = __commonJS({
  "node_modules/core-js/internals/dom-iterables.js"(exports, module) {
    module.exports = {
      CSSRuleList: 0,
      CSSStyleDeclaration: 0,
      CSSValueList: 0,
      ClientRectList: 0,
      DOMRectList: 0,
      DOMStringList: 0,
      DOMTokenList: 1,
      DataTransferItemList: 0,
      FileList: 0,
      HTMLAllCollection: 0,
      HTMLCollection: 0,
      HTMLFormElement: 0,
      HTMLSelectElement: 0,
      MediaList: 0,
      MimeTypeArray: 0,
      NamedNodeMap: 0,
      NodeList: 1,
      PaintRequestList: 0,
      Plugin: 0,
      PluginArray: 0,
      SVGLengthList: 0,
      SVGNumberList: 0,
      SVGPathSegList: 0,
      SVGPointList: 0,
      SVGStringList: 0,
      SVGTransformList: 0,
      SourceBufferList: 0,
      StyleSheetList: 0,
      TextTrackCueList: 0,
      TextTrackList: 0,
      TouchList: 0
    };
  }
});

// node_modules/core-js/internals/dom-token-list-prototype.js
var require_dom_token_list_prototype = __commonJS({
  "node_modules/core-js/internals/dom-token-list-prototype.js"(exports, module) {
    var documentCreateElement = require_document_create_element();
    var classList2 = documentCreateElement("span").classList;
    var DOMTokenListPrototype3 = classList2 && classList2.constructor && classList2.constructor.prototype;
    module.exports = DOMTokenListPrototype3 === Object.prototype ? void 0 : DOMTokenListPrototype3;
  }
});

// node_modules/core-js/internals/function-bind-context.js
var require_function_bind_context = __commonJS({
  "node_modules/core-js/internals/function-bind-context.js"(exports, module) {
    var uncurryThis3 = require_function_uncurry_this();
    var aCallable = require_a_callable();
    var NATIVE_BIND = require_function_bind_native();
    var bind2 = uncurryThis3(uncurryThis3.bind);
    module.exports = function(fn, that) {
      aCallable(fn);
      return that === void 0 ? fn : NATIVE_BIND ? bind2(fn, that) : function() {
        return fn.apply(that, arguments);
      };
    };
  }
});

// node_modules/core-js/internals/indexed-object.js
var require_indexed_object = __commonJS({
  "node_modules/core-js/internals/indexed-object.js"(exports, module) {
    var uncurryThis3 = require_function_uncurry_this();
    var fails2 = require_fails();
    var classof = require_classof_raw();
    var $Object = Object;
    var split2 = uncurryThis3("".split);
    module.exports = fails2(function() {
      return !$Object("z").propertyIsEnumerable(0);
    }) ? function(it2) {
      return classof(it2) == "String" ? split2(it2, "") : $Object(it2);
    } : $Object;
  }
});

// node_modules/core-js/internals/math-trunc.js
var require_math_trunc = __commonJS({
  "node_modules/core-js/internals/math-trunc.js"(exports, module) {
    var ceil = Math.ceil;
    var floor = Math.floor;
    module.exports = Math.trunc || function trunc(x3) {
      var n4 = +x3;
      return (n4 > 0 ? floor : ceil)(n4);
    };
  }
});

// node_modules/core-js/internals/to-integer-or-infinity.js
var require_to_integer_or_infinity = __commonJS({
  "node_modules/core-js/internals/to-integer-or-infinity.js"(exports, module) {
    var trunc = require_math_trunc();
    module.exports = function(argument) {
      var number = +argument;
      return number !== number || number === 0 ? 0 : trunc(number);
    };
  }
});

// node_modules/core-js/internals/to-length.js
var require_to_length = __commonJS({
  "node_modules/core-js/internals/to-length.js"(exports, module) {
    var toIntegerOrInfinity2 = require_to_integer_or_infinity();
    var min3 = Math.min;
    module.exports = function(argument) {
      return argument > 0 ? min3(toIntegerOrInfinity2(argument), 9007199254740991) : 0;
    };
  }
});

// node_modules/core-js/internals/length-of-array-like.js
var require_length_of_array_like = __commonJS({
  "node_modules/core-js/internals/length-of-array-like.js"(exports, module) {
    var toLength3 = require_to_length();
    module.exports = function(obj) {
      return toLength3(obj.length);
    };
  }
});

// node_modules/core-js/internals/is-array.js
var require_is_array = __commonJS({
  "node_modules/core-js/internals/is-array.js"(exports, module) {
    var classof = require_classof_raw();
    module.exports = Array.isArray || function isArray(argument) {
      return classof(argument) == "Array";
    };
  }
});

// node_modules/core-js/internals/is-constructor.js
var require_is_constructor = __commonJS({
  "node_modules/core-js/internals/is-constructor.js"(exports, module) {
    var uncurryThis3 = require_function_uncurry_this();
    var fails2 = require_fails();
    var isCallable2 = require_is_callable();
    var classof = require_classof();
    var getBuiltIn = require_get_built_in();
    var inspectSource = require_inspect_source();
    var noop5 = function() {
    };
    var empty2 = [];
    var construct = getBuiltIn("Reflect", "construct");
    var constructorRegExp = /^\s*(?:class|function)\b/;
    var exec = uncurryThis3(constructorRegExp.exec);
    var INCORRECT_TO_STRING = !constructorRegExp.exec(noop5);
    var isConstructorModern = function isConstructor(argument) {
      if (!isCallable2(argument)) return false;
      try {
        construct(noop5, empty2, argument);
        return true;
      } catch (error) {
        return false;
      }
    };
    var isConstructorLegacy = function isConstructor(argument) {
      if (!isCallable2(argument)) return false;
      switch (classof(argument)) {
        case "AsyncFunction":
        case "GeneratorFunction":
        case "AsyncGeneratorFunction":
          return false;
      }
      try {
        return INCORRECT_TO_STRING || !!exec(constructorRegExp, inspectSource(argument));
      } catch (error) {
        return true;
      }
    };
    isConstructorLegacy.sham = true;
    module.exports = !construct || fails2(function() {
      var called;
      return isConstructorModern(isConstructorModern.call) || !isConstructorModern(Object) || !isConstructorModern(function() {
        called = true;
      }) || called;
    }) ? isConstructorLegacy : isConstructorModern;
  }
});

// node_modules/core-js/internals/array-species-constructor.js
var require_array_species_constructor = __commonJS({
  "node_modules/core-js/internals/array-species-constructor.js"(exports, module) {
    var isArray = require_is_array();
    var isConstructor = require_is_constructor();
    var isObject4 = require_is_object();
    var wellKnownSymbol3 = require_well_known_symbol();
    var SPECIES = wellKnownSymbol3("species");
    var $Array = Array;
    module.exports = function(originalArray) {
      var C2;
      if (isArray(originalArray)) {
        C2 = originalArray.constructor;
        if (isConstructor(C2) && (C2 === $Array || isArray(C2.prototype))) C2 = void 0;
        else if (isObject4(C2)) {
          C2 = C2[SPECIES];
          if (C2 === null) C2 = void 0;
        }
      }
      return C2 === void 0 ? $Array : C2;
    };
  }
});

// node_modules/core-js/internals/array-species-create.js
var require_array_species_create = __commonJS({
  "node_modules/core-js/internals/array-species-create.js"(exports, module) {
    var arraySpeciesConstructor = require_array_species_constructor();
    module.exports = function(originalArray, length) {
      return new (arraySpeciesConstructor(originalArray))(length === 0 ? 0 : length);
    };
  }
});

// node_modules/core-js/internals/array-iteration.js
var require_array_iteration = __commonJS({
  "node_modules/core-js/internals/array-iteration.js"(exports, module) {
    var bind2 = require_function_bind_context();
    var uncurryThis3 = require_function_uncurry_this();
    var IndexedObject = require_indexed_object();
    var toObject = require_to_object();
    var lengthOfArrayLike = require_length_of_array_like();
    var arraySpeciesCreate = require_array_species_create();
    var push3 = uncurryThis3([].push);
    var createMethod = function(TYPE) {
      var IS_MAP = TYPE == 1;
      var IS_FILTER = TYPE == 2;
      var IS_SOME = TYPE == 3;
      var IS_EVERY = TYPE == 4;
      var IS_FIND_INDEX = TYPE == 6;
      var IS_FILTER_REJECT = TYPE == 7;
      var NO_HOLES = TYPE == 5 || IS_FIND_INDEX;
      return function($this, callbackfn, that, specificCreate) {
        var O4 = toObject($this);
        var self2 = IndexedObject(O4);
        var boundFunction = bind2(callbackfn, that);
        var length = lengthOfArrayLike(self2);
        var index = 0;
        var create3 = specificCreate || arraySpeciesCreate;
        var target = IS_MAP ? create3($this, length) : IS_FILTER || IS_FILTER_REJECT ? create3($this, 0) : void 0;
        var value2, result2;
        for (; length > index; index++) if (NO_HOLES || index in self2) {
          value2 = self2[index];
          result2 = boundFunction(value2, index, O4);
          if (TYPE) {
            if (IS_MAP) target[index] = result2;
            else if (result2) switch (TYPE) {
              case 3:
                return true;
              // some
              case 5:
                return value2;
              // find
              case 6:
                return index;
              // findIndex
              case 2:
                push3(target, value2);
            }
            else switch (TYPE) {
              case 4:
                return false;
              // every
              case 7:
                push3(target, value2);
            }
          }
        }
        return IS_FIND_INDEX ? -1 : IS_SOME || IS_EVERY ? IS_EVERY : target;
      };
    };
    module.exports = {
      // `Array.prototype.forEach` method
      // https://tc39.es/ecma262/#sec-array.prototype.foreach
      forEach: createMethod(0),
      // `Array.prototype.map` method
      // https://tc39.es/ecma262/#sec-array.prototype.map
      map: createMethod(1),
      // `Array.prototype.filter` method
      // https://tc39.es/ecma262/#sec-array.prototype.filter
      filter: createMethod(2),
      // `Array.prototype.some` method
      // https://tc39.es/ecma262/#sec-array.prototype.some
      some: createMethod(3),
      // `Array.prototype.every` method
      // https://tc39.es/ecma262/#sec-array.prototype.every
      every: createMethod(4),
      // `Array.prototype.find` method
      // https://tc39.es/ecma262/#sec-array.prototype.find
      find: createMethod(5),
      // `Array.prototype.findIndex` method
      // https://tc39.es/ecma262/#sec-array.prototype.findIndex
      findIndex: createMethod(6),
      // `Array.prototype.filterReject` method
      // https://github.com/tc39/proposal-array-filtering
      filterReject: createMethod(7)
    };
  }
});

// node_modules/core-js/internals/array-method-is-strict.js
var require_array_method_is_strict = __commonJS({
  "node_modules/core-js/internals/array-method-is-strict.js"(exports, module) {
    "use strict";
    var fails2 = require_fails();
    module.exports = function(METHOD_NAME, argument) {
      var method = [][METHOD_NAME];
      return !!method && fails2(function() {
        method.call(null, argument || function() {
          return 1;
        }, 1);
      });
    };
  }
});

// node_modules/core-js/internals/array-for-each.js
var require_array_for_each = __commonJS({
  "node_modules/core-js/internals/array-for-each.js"(exports, module) {
    "use strict";
    var $forEach = require_array_iteration().forEach;
    var arrayMethodIsStrict2 = require_array_method_is_strict();
    var STRICT_METHOD2 = arrayMethodIsStrict2("forEach");
    module.exports = !STRICT_METHOD2 ? function forEach3(callbackfn) {
      return $forEach(this, callbackfn, arguments.length > 1 ? arguments[1] : void 0);
    } : [].forEach;
  }
});

// node_modules/can-use-dom/index.js
var require_can_use_dom = __commonJS({
  "node_modules/can-use-dom/index.js"(exports, module) {
    var canUseDOM2 = !!(typeof window !== "undefined" && window.document && window.document.createElement);
    module.exports = canUseDOM2;
  }
});

// node_modules/core-js/internals/object-property-is-enumerable.js
var require_object_property_is_enumerable = __commonJS({
  "node_modules/core-js/internals/object-property-is-enumerable.js"(exports) {
    "use strict";
    var $propertyIsEnumerable = {}.propertyIsEnumerable;
    var getOwnPropertyDescriptor = Object.getOwnPropertyDescriptor;
    var NASHORN_BUG = getOwnPropertyDescriptor && !$propertyIsEnumerable.call({ 1: 2 }, 1);
    exports.f = NASHORN_BUG ? function propertyIsEnumerable(V2) {
      var descriptor = getOwnPropertyDescriptor(this, V2);
      return !!descriptor && descriptor.enumerable;
    } : $propertyIsEnumerable;
  }
});

// node_modules/core-js/internals/to-indexed-object.js
var require_to_indexed_object = __commonJS({
  "node_modules/core-js/internals/to-indexed-object.js"(exports, module) {
    var IndexedObject = require_indexed_object();
    var requireObjectCoercible3 = require_require_object_coercible();
    module.exports = function(it2) {
      return IndexedObject(requireObjectCoercible3(it2));
    };
  }
});

// node_modules/core-js/internals/object-get-own-property-descriptor.js
var require_object_get_own_property_descriptor = __commonJS({
  "node_modules/core-js/internals/object-get-own-property-descriptor.js"(exports) {
    var DESCRIPTORS2 = require_descriptors();
    var call3 = require_function_call();
    var propertyIsEnumerableModule = require_object_property_is_enumerable();
    var createPropertyDescriptor = require_create_property_descriptor();
    var toIndexedObject = require_to_indexed_object();
    var toPropertyKey = require_to_property_key();
    var hasOwn = require_has_own_property();
    var IE8_DOM_DEFINE = require_ie8_dom_define();
    var $getOwnPropertyDescriptor = Object.getOwnPropertyDescriptor;
    exports.f = DESCRIPTORS2 ? $getOwnPropertyDescriptor : function getOwnPropertyDescriptor(O4, P3) {
      O4 = toIndexedObject(O4);
      P3 = toPropertyKey(P3);
      if (IE8_DOM_DEFINE) try {
        return $getOwnPropertyDescriptor(O4, P3);
      } catch (error) {
      }
      if (hasOwn(O4, P3)) return createPropertyDescriptor(!call3(propertyIsEnumerableModule.f, O4, P3), O4[P3]);
    };
  }
});

// node_modules/core-js/internals/to-absolute-index.js
var require_to_absolute_index = __commonJS({
  "node_modules/core-js/internals/to-absolute-index.js"(exports, module) {
    var toIntegerOrInfinity2 = require_to_integer_or_infinity();
    var max3 = Math.max;
    var min3 = Math.min;
    module.exports = function(index, length) {
      var integer = toIntegerOrInfinity2(index);
      return integer < 0 ? max3(integer + length, 0) : min3(integer, length);
    };
  }
});

// node_modules/core-js/internals/array-includes.js
var require_array_includes = __commonJS({
  "node_modules/core-js/internals/array-includes.js"(exports, module) {
    var toIndexedObject = require_to_indexed_object();
    var toAbsoluteIndex = require_to_absolute_index();
    var lengthOfArrayLike = require_length_of_array_like();
    var createMethod = function(IS_INCLUDES) {
      return function($this, el, fromIndex) {
        var O4 = toIndexedObject($this);
        var length = lengthOfArrayLike(O4);
        var index = toAbsoluteIndex(fromIndex, length);
        var value2;
        if (IS_INCLUDES && el != el) while (length > index) {
          value2 = O4[index++];
          if (value2 != value2) return true;
        }
        else for (; length > index; index++) {
          if ((IS_INCLUDES || index in O4) && O4[index] === el) return IS_INCLUDES || index || 0;
        }
        return !IS_INCLUDES && -1;
      };
    };
    module.exports = {
      // `Array.prototype.includes` method
      // https://tc39.es/ecma262/#sec-array.prototype.includes
      includes: createMethod(true),
      // `Array.prototype.indexOf` method
      // https://tc39.es/ecma262/#sec-array.prototype.indexof
      indexOf: createMethod(false)
    };
  }
});

// node_modules/core-js/internals/object-keys-internal.js
var require_object_keys_internal = __commonJS({
  "node_modules/core-js/internals/object-keys-internal.js"(exports, module) {
    var uncurryThis3 = require_function_uncurry_this();
    var hasOwn = require_has_own_property();
    var toIndexedObject = require_to_indexed_object();
    var indexOf = require_array_includes().indexOf;
    var hiddenKeys = require_hidden_keys();
    var push3 = uncurryThis3([].push);
    module.exports = function(object2, names) {
      var O4 = toIndexedObject(object2);
      var i3 = 0;
      var result2 = [];
      var key;
      for (key in O4) !hasOwn(hiddenKeys, key) && hasOwn(O4, key) && push3(result2, key);
      while (names.length > i3) if (hasOwn(O4, key = names[i3++])) {
        ~indexOf(result2, key) || push3(result2, key);
      }
      return result2;
    };
  }
});

// node_modules/core-js/internals/enum-bug-keys.js
var require_enum_bug_keys = __commonJS({
  "node_modules/core-js/internals/enum-bug-keys.js"(exports, module) {
    module.exports = [
      "constructor",
      "hasOwnProperty",
      "isPrototypeOf",
      "propertyIsEnumerable",
      "toLocaleString",
      "toString",
      "valueOf"
    ];
  }
});

// node_modules/core-js/internals/object-get-own-property-names.js
var require_object_get_own_property_names = __commonJS({
  "node_modules/core-js/internals/object-get-own-property-names.js"(exports) {
    var internalObjectKeys = require_object_keys_internal();
    var enumBugKeys = require_enum_bug_keys();
    var hiddenKeys = enumBugKeys.concat("length", "prototype");
    exports.f = Object.getOwnPropertyNames || function getOwnPropertyNames(O4) {
      return internalObjectKeys(O4, hiddenKeys);
    };
  }
});

// node_modules/core-js/internals/object-get-own-property-symbols.js
var require_object_get_own_property_symbols = __commonJS({
  "node_modules/core-js/internals/object-get-own-property-symbols.js"(exports) {
    exports.f = Object.getOwnPropertySymbols;
  }
});

// node_modules/core-js/internals/own-keys.js
var require_own_keys = __commonJS({
  "node_modules/core-js/internals/own-keys.js"(exports, module) {
    var getBuiltIn = require_get_built_in();
    var uncurryThis3 = require_function_uncurry_this();
    var getOwnPropertyNamesModule = require_object_get_own_property_names();
    var getOwnPropertySymbolsModule = require_object_get_own_property_symbols();
    var anObject3 = require_an_object();
    var concat2 = uncurryThis3([].concat);
    module.exports = getBuiltIn("Reflect", "ownKeys") || function ownKeys2(it2) {
      var keys4 = getOwnPropertyNamesModule.f(anObject3(it2));
      var getOwnPropertySymbols = getOwnPropertySymbolsModule.f;
      return getOwnPropertySymbols ? concat2(keys4, getOwnPropertySymbols(it2)) : keys4;
    };
  }
});

// node_modules/core-js/internals/copy-constructor-properties.js
var require_copy_constructor_properties = __commonJS({
  "node_modules/core-js/internals/copy-constructor-properties.js"(exports, module) {
    var hasOwn = require_has_own_property();
    var ownKeys2 = require_own_keys();
    var getOwnPropertyDescriptorModule = require_object_get_own_property_descriptor();
    var definePropertyModule = require_object_define_property();
    module.exports = function(target, source, exceptions) {
      var keys4 = ownKeys2(source);
      var defineProperty2 = definePropertyModule.f;
      var getOwnPropertyDescriptor = getOwnPropertyDescriptorModule.f;
      for (var i3 = 0; i3 < keys4.length; i3++) {
        var key = keys4[i3];
        if (!hasOwn(target, key) && !(exceptions && hasOwn(exceptions, key))) {
          defineProperty2(target, key, getOwnPropertyDescriptor(source, key));
        }
      }
    };
  }
});

// node_modules/core-js/internals/is-forced.js
var require_is_forced = __commonJS({
  "node_modules/core-js/internals/is-forced.js"(exports, module) {
    var fails2 = require_fails();
    var isCallable2 = require_is_callable();
    var replacement = /#|\.prototype\./;
    var isForced = function(feature, detection) {
      var value2 = data2[normalize2(feature)];
      return value2 == POLYFILL ? true : value2 == NATIVE ? false : isCallable2(detection) ? fails2(detection) : !!detection;
    };
    var normalize2 = isForced.normalize = function(string) {
      return String(string).replace(replacement, ".").toLowerCase();
    };
    var data2 = isForced.data = {};
    var NATIVE = isForced.NATIVE = "N";
    var POLYFILL = isForced.POLYFILL = "P";
    module.exports = isForced;
  }
});

// node_modules/core-js/internals/export.js
var require_export = __commonJS({
  "node_modules/core-js/internals/export.js"(exports, module) {
    var global5 = require_global();
    var getOwnPropertyDescriptor = require_object_get_own_property_descriptor().f;
    var createNonEnumerableProperty3 = require_create_non_enumerable_property();
    var defineBuiltIn2 = require_define_built_in();
    var defineGlobalProperty = require_define_global_property();
    var copyConstructorProperties = require_copy_constructor_properties();
    var isForced = require_is_forced();
    module.exports = function(options2, source) {
      var TARGET = options2.target;
      var GLOBAL = options2.global;
      var STATIC = options2.stat;
      var FORCED, target, key, targetProperty, sourceProperty, descriptor;
      if (GLOBAL) {
        target = global5;
      } else if (STATIC) {
        target = global5[TARGET] || defineGlobalProperty(TARGET, {});
      } else {
        target = (global5[TARGET] || {}).prototype;
      }
      if (target) for (key in source) {
        sourceProperty = source[key];
        if (options2.dontCallGetSet) {
          descriptor = getOwnPropertyDescriptor(target, key);
          targetProperty = descriptor && descriptor.value;
        } else targetProperty = target[key];
        FORCED = isForced(GLOBAL ? key : TARGET + (STATIC ? "." : "#") + key, options2.forced);
        if (!FORCED && targetProperty !== void 0) {
          if (typeof sourceProperty == typeof targetProperty) continue;
          copyConstructorProperties(sourceProperty, targetProperty);
        }
        if (options2.sham || targetProperty && targetProperty.sham) {
          createNonEnumerableProperty3(sourceProperty, "sham", true);
        }
        defineBuiltIn2(target, key, sourceProperty, options2);
      }
    };
  }
});

// node_modules/core-js/internals/to-string.js
var require_to_string = __commonJS({
  "node_modules/core-js/internals/to-string.js"(exports, module) {
    var classof = require_classof();
    var $String = String;
    module.exports = function(argument) {
      if (classof(argument) === "Symbol") throw TypeError("Cannot convert a Symbol value to a string");
      return $String(argument);
    };
  }
});

// node_modules/core-js/internals/whitespaces.js
var require_whitespaces = __commonJS({
  "node_modules/core-js/internals/whitespaces.js"(exports, module) {
    module.exports = "	\n\v\f\r \xA0\u1680\u2000\u2001\u2002\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200A\u202F\u205F\u3000\u2028\u2029\uFEFF";
  }
});

// node_modules/core-js/internals/string-trim.js
var require_string_trim = __commonJS({
  "node_modules/core-js/internals/string-trim.js"(exports, module) {
    var uncurryThis3 = require_function_uncurry_this();
    var requireObjectCoercible3 = require_require_object_coercible();
    var toString6 = require_to_string();
    var whitespaces = require_whitespaces();
    var replace2 = uncurryThis3("".replace);
    var whitespace = "[" + whitespaces + "]";
    var ltrim = RegExp("^" + whitespace + whitespace + "*");
    var rtrim2 = RegExp(whitespace + whitespace + "*$");
    var createMethod = function(TYPE) {
      return function($this) {
        var string = toString6(requireObjectCoercible3($this));
        if (TYPE & 1) string = replace2(string, ltrim, "");
        if (TYPE & 2) string = replace2(string, rtrim2, "");
        return string;
      };
    };
    module.exports = {
      // `String.prototype.{ trimLeft, trimStart }` methods
      // https://tc39.es/ecma262/#sec-string.prototype.trimstart
      start: createMethod(1),
      // `String.prototype.{ trimRight, trimEnd }` methods
      // https://tc39.es/ecma262/#sec-string.prototype.trimend
      end: createMethod(2),
      // `String.prototype.trim` method
      // https://tc39.es/ecma262/#sec-string.prototype.trim
      trim: createMethod(3)
    };
  }
});

// node_modules/core-js/internals/number-parse-int.js
var require_number_parse_int = __commonJS({
  "node_modules/core-js/internals/number-parse-int.js"(exports, module) {
    var global5 = require_global();
    var fails2 = require_fails();
    var uncurryThis3 = require_function_uncurry_this();
    var toString6 = require_to_string();
    var trim = require_string_trim().trim;
    var whitespaces = require_whitespaces();
    var $parseInt2 = global5.parseInt;
    var Symbol2 = global5.Symbol;
    var ITERATOR2 = Symbol2 && Symbol2.iterator;
    var hex = /^[+-]?0x/i;
    var exec = uncurryThis3(hex.exec);
    var FORCED = $parseInt2(whitespaces + "08") !== 8 || $parseInt2(whitespaces + "0x16") !== 22 || ITERATOR2 && !fails2(function() {
      $parseInt2(Object(ITERATOR2));
    });
    module.exports = FORCED ? function parseInt2(string, radix) {
      var S2 = trim(toString6(string));
      return $parseInt2(S2, radix >>> 0 || (exec(hex, S2) ? 16 : 10));
    } : $parseInt2;
  }
});

// node_modules/core-js/internals/object-keys.js
var require_object_keys = __commonJS({
  "node_modules/core-js/internals/object-keys.js"(exports, module) {
    var internalObjectKeys = require_object_keys_internal();
    var enumBugKeys = require_enum_bug_keys();
    module.exports = Object.keys || function keys4(O4) {
      return internalObjectKeys(O4, enumBugKeys);
    };
  }
});

// node_modules/core-js/internals/object-assign.js
var require_object_assign = __commonJS({
  "node_modules/core-js/internals/object-assign.js"(exports, module) {
    "use strict";
    var DESCRIPTORS2 = require_descriptors();
    var uncurryThis3 = require_function_uncurry_this();
    var call3 = require_function_call();
    var fails2 = require_fails();
    var objectKeys = require_object_keys();
    var getOwnPropertySymbolsModule = require_object_get_own_property_symbols();
    var propertyIsEnumerableModule = require_object_property_is_enumerable();
    var toObject = require_to_object();
    var IndexedObject = require_indexed_object();
    var $assign = Object.assign;
    var defineProperty2 = Object.defineProperty;
    var concat2 = uncurryThis3([].concat);
    module.exports = !$assign || fails2(function() {
      if (DESCRIPTORS2 && $assign({ b: 1 }, $assign(defineProperty2({}, "a", {
        enumerable: true,
        get: function() {
          defineProperty2(this, "b", {
            value: 3,
            enumerable: false
          });
        }
      }), { b: 2 })).b !== 1) return true;
      var A4 = {};
      var B = {};
      var symbol = Symbol();
      var alphabet = "abcdefghijklmnopqrst";
      A4[symbol] = 7;
      alphabet.split("").forEach(function(chr) {
        B[chr] = chr;
      });
      return $assign({}, A4)[symbol] != 7 || objectKeys($assign({}, B)).join("") != alphabet;
    }) ? function assign3(target, source) {
      var T3 = toObject(target);
      var argumentsLength = arguments.length;
      var index = 1;
      var getOwnPropertySymbols = getOwnPropertySymbolsModule.f;
      var propertyIsEnumerable = propertyIsEnumerableModule.f;
      while (argumentsLength > index) {
        var S2 = IndexedObject(arguments[index++]);
        var keys4 = getOwnPropertySymbols ? concat2(objectKeys(S2), getOwnPropertySymbols(S2)) : objectKeys(S2);
        var length = keys4.length;
        var j = 0;
        var key;
        while (length > j) {
          key = keys4[j++];
          if (!DESCRIPTORS2 || call3(propertyIsEnumerable, S2, key)) T3[key] = S2[key];
        }
      }
      return T3;
    } : $assign;
  }
});

// node_modules/core-js/internals/array-method-has-species-support.js
var require_array_method_has_species_support = __commonJS({
  "node_modules/core-js/internals/array-method-has-species-support.js"(exports, module) {
    var fails2 = require_fails();
    var wellKnownSymbol3 = require_well_known_symbol();
    var V8_VERSION = require_engine_v8_version();
    var SPECIES = wellKnownSymbol3("species");
    module.exports = function(METHOD_NAME) {
      return V8_VERSION >= 51 || !fails2(function() {
        var array = [];
        var constructor = array.constructor = {};
        constructor[SPECIES] = function() {
          return { foo: 1 };
        };
        return array[METHOD_NAME](Boolean).foo !== 1;
      });
    };
  }
});

// node_modules/core-js/internals/object-define-properties.js
var require_object_define_properties = __commonJS({
  "node_modules/core-js/internals/object-define-properties.js"(exports) {
    var DESCRIPTORS2 = require_descriptors();
    var V8_PROTOTYPE_DEFINE_BUG = require_v8_prototype_define_bug();
    var definePropertyModule = require_object_define_property();
    var anObject3 = require_an_object();
    var toIndexedObject = require_to_indexed_object();
    var objectKeys = require_object_keys();
    exports.f = DESCRIPTORS2 && !V8_PROTOTYPE_DEFINE_BUG ? Object.defineProperties : function defineProperties(O4, Properties2) {
      anObject3(O4);
      var props2 = toIndexedObject(Properties2);
      var keys4 = objectKeys(Properties2);
      var length = keys4.length;
      var index = 0;
      var key;
      while (length > index) definePropertyModule.f(O4, key = keys4[index++], props2[key]);
      return O4;
    };
  }
});

// node_modules/core-js/internals/html.js
var require_html = __commonJS({
  "node_modules/core-js/internals/html.js"(exports, module) {
    var getBuiltIn = require_get_built_in();
    module.exports = getBuiltIn("document", "documentElement");
  }
});

// node_modules/core-js/internals/object-create.js
var require_object_create = __commonJS({
  "node_modules/core-js/internals/object-create.js"(exports, module) {
    var anObject3 = require_an_object();
    var definePropertiesModule = require_object_define_properties();
    var enumBugKeys = require_enum_bug_keys();
    var hiddenKeys = require_hidden_keys();
    var html = require_html();
    var documentCreateElement = require_document_create_element();
    var sharedKey = require_shared_key();
    var GT = ">";
    var LT = "<";
    var PROTOTYPE = "prototype";
    var SCRIPT = "script";
    var IE_PROTO = sharedKey("IE_PROTO");
    var EmptyConstructor = function() {
    };
    var scriptTag = function(content) {
      return LT + SCRIPT + GT + content + LT + "/" + SCRIPT + GT;
    };
    var NullProtoObjectViaActiveX = function(activeXDocument2) {
      activeXDocument2.write(scriptTag(""));
      activeXDocument2.close();
      var temp = activeXDocument2.parentWindow.Object;
      activeXDocument2 = null;
      return temp;
    };
    var NullProtoObjectViaIFrame = function() {
      var iframe = documentCreateElement("iframe");
      var JS = "java" + SCRIPT + ":";
      var iframeDocument;
      iframe.style.display = "none";
      html.appendChild(iframe);
      iframe.src = String(JS);
      iframeDocument = iframe.contentWindow.document;
      iframeDocument.open();
      iframeDocument.write(scriptTag("document.F=Object"));
      iframeDocument.close();
      return iframeDocument.F;
    };
    var activeXDocument;
    var NullProtoObject = function() {
      try {
        activeXDocument = new ActiveXObject("htmlfile");
      } catch (error) {
      }
      NullProtoObject = typeof document != "undefined" ? document.domain && activeXDocument ? NullProtoObjectViaActiveX(activeXDocument) : NullProtoObjectViaIFrame() : NullProtoObjectViaActiveX(activeXDocument);
      var length = enumBugKeys.length;
      while (length--) delete NullProtoObject[PROTOTYPE][enumBugKeys[length]];
      return NullProtoObject();
    };
    hiddenKeys[IE_PROTO] = true;
    module.exports = Object.create || function create3(O4, Properties2) {
      var result2;
      if (O4 !== null) {
        EmptyConstructor[PROTOTYPE] = anObject3(O4);
        result2 = new EmptyConstructor();
        EmptyConstructor[PROTOTYPE] = null;
        result2[IE_PROTO] = O4;
      } else result2 = NullProtoObject();
      return Properties2 === void 0 ? result2 : definePropertiesModule.f(result2, Properties2);
    };
  }
});

// node_modules/core-js/internals/add-to-unscopables.js
var require_add_to_unscopables = __commonJS({
  "node_modules/core-js/internals/add-to-unscopables.js"(exports, module) {
    var wellKnownSymbol3 = require_well_known_symbol();
    var create3 = require_object_create();
    var defineProperty2 = require_object_define_property().f;
    var UNSCOPABLES = wellKnownSymbol3("unscopables");
    var ArrayPrototype = Array.prototype;
    if (ArrayPrototype[UNSCOPABLES] == void 0) {
      defineProperty2(ArrayPrototype, UNSCOPABLES, {
        configurable: true,
        value: create3(null)
      });
    }
    module.exports = function(key) {
      ArrayPrototype[UNSCOPABLES][key] = true;
    };
  }
});

// node_modules/core-js/internals/iterators.js
var require_iterators = __commonJS({
  "node_modules/core-js/internals/iterators.js"(exports, module) {
    module.exports = {};
  }
});

// node_modules/core-js/internals/correct-prototype-getter.js
var require_correct_prototype_getter = __commonJS({
  "node_modules/core-js/internals/correct-prototype-getter.js"(exports, module) {
    var fails2 = require_fails();
    module.exports = !fails2(function() {
      function F2() {
      }
      F2.prototype.constructor = null;
      return Object.getPrototypeOf(new F2()) !== F2.prototype;
    });
  }
});

// node_modules/core-js/internals/object-get-prototype-of.js
var require_object_get_prototype_of = __commonJS({
  "node_modules/core-js/internals/object-get-prototype-of.js"(exports, module) {
    var hasOwn = require_has_own_property();
    var isCallable2 = require_is_callable();
    var toObject = require_to_object();
    var sharedKey = require_shared_key();
    var CORRECT_PROTOTYPE_GETTER = require_correct_prototype_getter();
    var IE_PROTO = sharedKey("IE_PROTO");
    var $Object = Object;
    var ObjectPrototype = $Object.prototype;
    module.exports = CORRECT_PROTOTYPE_GETTER ? $Object.getPrototypeOf : function(O4) {
      var object2 = toObject(O4);
      if (hasOwn(object2, IE_PROTO)) return object2[IE_PROTO];
      var constructor = object2.constructor;
      if (isCallable2(constructor) && object2 instanceof constructor) {
        return constructor.prototype;
      }
      return object2 instanceof $Object ? ObjectPrototype : null;
    };
  }
});

// node_modules/core-js/internals/iterators-core.js
var require_iterators_core = __commonJS({
  "node_modules/core-js/internals/iterators-core.js"(exports, module) {
    "use strict";
    var fails2 = require_fails();
    var isCallable2 = require_is_callable();
    var isObject4 = require_is_object();
    var create3 = require_object_create();
    var getPrototypeOf = require_object_get_prototype_of();
    var defineBuiltIn2 = require_define_built_in();
    var wellKnownSymbol3 = require_well_known_symbol();
    var IS_PURE = require_is_pure();
    var ITERATOR2 = wellKnownSymbol3("iterator");
    var BUGGY_SAFARI_ITERATORS = false;
    var IteratorPrototype;
    var PrototypeOfArrayIteratorPrototype;
    var arrayIterator;
    if ([].keys) {
      arrayIterator = [].keys();
      if (!("next" in arrayIterator)) BUGGY_SAFARI_ITERATORS = true;
      else {
        PrototypeOfArrayIteratorPrototype = getPrototypeOf(getPrototypeOf(arrayIterator));
        if (PrototypeOfArrayIteratorPrototype !== Object.prototype) IteratorPrototype = PrototypeOfArrayIteratorPrototype;
      }
    }
    var NEW_ITERATOR_PROTOTYPE = !isObject4(IteratorPrototype) || fails2(function() {
      var test = {};
      return IteratorPrototype[ITERATOR2].call(test) !== test;
    });
    if (NEW_ITERATOR_PROTOTYPE) IteratorPrototype = {};
    else if (IS_PURE) IteratorPrototype = create3(IteratorPrototype);
    if (!isCallable2(IteratorPrototype[ITERATOR2])) {
      defineBuiltIn2(IteratorPrototype, ITERATOR2, function() {
        return this;
      });
    }
    module.exports = {
      IteratorPrototype,
      BUGGY_SAFARI_ITERATORS
    };
  }
});

// node_modules/core-js/internals/set-to-string-tag.js
var require_set_to_string_tag = __commonJS({
  "node_modules/core-js/internals/set-to-string-tag.js"(exports, module) {
    var defineProperty2 = require_object_define_property().f;
    var hasOwn = require_has_own_property();
    var wellKnownSymbol3 = require_well_known_symbol();
    var TO_STRING_TAG2 = wellKnownSymbol3("toStringTag");
    module.exports = function(target, TAG, STATIC) {
      if (target && !STATIC) target = target.prototype;
      if (target && !hasOwn(target, TO_STRING_TAG2)) {
        defineProperty2(target, TO_STRING_TAG2, { configurable: true, value: TAG });
      }
    };
  }
});

// node_modules/core-js/internals/iterator-create-constructor.js
var require_iterator_create_constructor = __commonJS({
  "node_modules/core-js/internals/iterator-create-constructor.js"(exports, module) {
    "use strict";
    var IteratorPrototype = require_iterators_core().IteratorPrototype;
    var create3 = require_object_create();
    var createPropertyDescriptor = require_create_property_descriptor();
    var setToStringTag = require_set_to_string_tag();
    var Iterators = require_iterators();
    var returnThis = function() {
      return this;
    };
    module.exports = function(IteratorConstructor, NAME2, next2, ENUMERABLE_NEXT) {
      var TO_STRING_TAG2 = NAME2 + " Iterator";
      IteratorConstructor.prototype = create3(IteratorPrototype, { next: createPropertyDescriptor(+!ENUMERABLE_NEXT, next2) });
      setToStringTag(IteratorConstructor, TO_STRING_TAG2, false, true);
      Iterators[TO_STRING_TAG2] = returnThis;
      return IteratorConstructor;
    };
  }
});

// node_modules/core-js/internals/a-possible-prototype.js
var require_a_possible_prototype = __commonJS({
  "node_modules/core-js/internals/a-possible-prototype.js"(exports, module) {
    var isCallable2 = require_is_callable();
    var $String = String;
    var $TypeError = TypeError;
    module.exports = function(argument) {
      if (typeof argument == "object" || isCallable2(argument)) return argument;
      throw $TypeError("Can't set " + $String(argument) + " as a prototype");
    };
  }
});

// node_modules/core-js/internals/object-set-prototype-of.js
var require_object_set_prototype_of = __commonJS({
  "node_modules/core-js/internals/object-set-prototype-of.js"(exports, module) {
    var uncurryThis3 = require_function_uncurry_this();
    var anObject3 = require_an_object();
    var aPossiblePrototype = require_a_possible_prototype();
    module.exports = Object.setPrototypeOf || ("__proto__" in {} ? function() {
      var CORRECT_SETTER = false;
      var test = {};
      var setter;
      try {
        setter = uncurryThis3(Object.getOwnPropertyDescriptor(Object.prototype, "__proto__").set);
        setter(test, []);
        CORRECT_SETTER = test instanceof Array;
      } catch (error) {
      }
      return function setPrototypeOf(O4, proto) {
        anObject3(O4);
        aPossiblePrototype(proto);
        if (CORRECT_SETTER) setter(O4, proto);
        else O4.__proto__ = proto;
        return O4;
      };
    }() : void 0);
  }
});

// node_modules/core-js/internals/iterator-define.js
var require_iterator_define = __commonJS({
  "node_modules/core-js/internals/iterator-define.js"(exports, module) {
    "use strict";
    var $6 = require_export();
    var call3 = require_function_call();
    var IS_PURE = require_is_pure();
    var FunctionName = require_function_name();
    var isCallable2 = require_is_callable();
    var createIteratorConstructor = require_iterator_create_constructor();
    var getPrototypeOf = require_object_get_prototype_of();
    var setPrototypeOf = require_object_set_prototype_of();
    var setToStringTag = require_set_to_string_tag();
    var createNonEnumerableProperty3 = require_create_non_enumerable_property();
    var defineBuiltIn2 = require_define_built_in();
    var wellKnownSymbol3 = require_well_known_symbol();
    var Iterators = require_iterators();
    var IteratorsCore = require_iterators_core();
    var PROPER_FUNCTION_NAME = FunctionName.PROPER;
    var CONFIGURABLE_FUNCTION_NAME = FunctionName.CONFIGURABLE;
    var IteratorPrototype = IteratorsCore.IteratorPrototype;
    var BUGGY_SAFARI_ITERATORS = IteratorsCore.BUGGY_SAFARI_ITERATORS;
    var ITERATOR2 = wellKnownSymbol3("iterator");
    var KEYS = "keys";
    var VALUES = "values";
    var ENTRIES = "entries";
    var returnThis = function() {
      return this;
    };
    module.exports = function(Iterable, NAME2, IteratorConstructor, next2, DEFAULT, IS_SET, FORCED) {
      createIteratorConstructor(IteratorConstructor, NAME2, next2);
      var getIterationMethod = function(KIND) {
        if (KIND === DEFAULT && defaultIterator) return defaultIterator;
        if (!BUGGY_SAFARI_ITERATORS && KIND in IterablePrototype) return IterablePrototype[KIND];
        switch (KIND) {
          case KEYS:
            return function keys4() {
              return new IteratorConstructor(this, KIND);
            };
          case VALUES:
            return function values2() {
              return new IteratorConstructor(this, KIND);
            };
          case ENTRIES:
            return function entries2() {
              return new IteratorConstructor(this, KIND);
            };
        }
        return function() {
          return new IteratorConstructor(this);
        };
      };
      var TO_STRING_TAG2 = NAME2 + " Iterator";
      var INCORRECT_VALUES_NAME = false;
      var IterablePrototype = Iterable.prototype;
      var nativeIterator = IterablePrototype[ITERATOR2] || IterablePrototype["@@iterator"] || DEFAULT && IterablePrototype[DEFAULT];
      var defaultIterator = !BUGGY_SAFARI_ITERATORS && nativeIterator || getIterationMethod(DEFAULT);
      var anyNativeIterator = NAME2 == "Array" ? IterablePrototype.entries || nativeIterator : nativeIterator;
      var CurrentIteratorPrototype, methods, KEY;
      if (anyNativeIterator) {
        CurrentIteratorPrototype = getPrototypeOf(anyNativeIterator.call(new Iterable()));
        if (CurrentIteratorPrototype !== Object.prototype && CurrentIteratorPrototype.next) {
          if (!IS_PURE && getPrototypeOf(CurrentIteratorPrototype) !== IteratorPrototype) {
            if (setPrototypeOf) {
              setPrototypeOf(CurrentIteratorPrototype, IteratorPrototype);
            } else if (!isCallable2(CurrentIteratorPrototype[ITERATOR2])) {
              defineBuiltIn2(CurrentIteratorPrototype, ITERATOR2, returnThis);
            }
          }
          setToStringTag(CurrentIteratorPrototype, TO_STRING_TAG2, true, true);
          if (IS_PURE) Iterators[TO_STRING_TAG2] = returnThis;
        }
      }
      if (PROPER_FUNCTION_NAME && DEFAULT == VALUES && nativeIterator && nativeIterator.name !== VALUES) {
        if (!IS_PURE && CONFIGURABLE_FUNCTION_NAME) {
          createNonEnumerableProperty3(IterablePrototype, "name", VALUES);
        } else {
          INCORRECT_VALUES_NAME = true;
          defaultIterator = function values2() {
            return call3(nativeIterator, this);
          };
        }
      }
      if (DEFAULT) {
        methods = {
          values: getIterationMethod(VALUES),
          keys: IS_SET ? defaultIterator : getIterationMethod(KEYS),
          entries: getIterationMethod(ENTRIES)
        };
        if (FORCED) for (KEY in methods) {
          if (BUGGY_SAFARI_ITERATORS || INCORRECT_VALUES_NAME || !(KEY in IterablePrototype)) {
            defineBuiltIn2(IterablePrototype, KEY, methods[KEY]);
          }
        }
        else $6({ target: NAME2, proto: true, forced: BUGGY_SAFARI_ITERATORS || INCORRECT_VALUES_NAME }, methods);
      }
      if ((!IS_PURE || FORCED) && IterablePrototype[ITERATOR2] !== defaultIterator) {
        defineBuiltIn2(IterablePrototype, ITERATOR2, defaultIterator, { name: DEFAULT });
      }
      Iterators[NAME2] = defaultIterator;
      return methods;
    };
  }
});

// node_modules/core-js/internals/create-iter-result-object.js
var require_create_iter_result_object = __commonJS({
  "node_modules/core-js/internals/create-iter-result-object.js"(exports, module) {
    module.exports = function(value2, done) {
      return { value: value2, done };
    };
  }
});

// node_modules/core-js/modules/es.array.iterator.js
var require_es_array_iterator = __commonJS({
  "node_modules/core-js/modules/es.array.iterator.js"(exports, module) {
    "use strict";
    var toIndexedObject = require_to_indexed_object();
    var addToUnscopables = require_add_to_unscopables();
    var Iterators = require_iterators();
    var InternalStateModule2 = require_internal_state();
    var defineProperty2 = require_object_define_property().f;
    var defineIterator2 = require_iterator_define();
    var createIterResultObject2 = require_create_iter_result_object();
    var IS_PURE = require_is_pure();
    var DESCRIPTORS2 = require_descriptors();
    var ARRAY_ITERATOR = "Array Iterator";
    var setInternalState2 = InternalStateModule2.set;
    var getInternalState2 = InternalStateModule2.getterFor(ARRAY_ITERATOR);
    module.exports = defineIterator2(Array, "Array", function(iterated, kind) {
      setInternalState2(this, {
        type: ARRAY_ITERATOR,
        target: toIndexedObject(iterated),
        // target
        index: 0,
        // next index
        kind
        // kind
      });
    }, function() {
      var state = getInternalState2(this);
      var target = state.target;
      var kind = state.kind;
      var index = state.index++;
      if (!target || index >= target.length) {
        state.target = void 0;
        return createIterResultObject2(void 0, true);
      }
      if (kind == "keys") return createIterResultObject2(index, false);
      if (kind == "values") return createIterResultObject2(target[index], false);
      return createIterResultObject2([index, target[index]], false);
    }, "values");
    var values2 = Iterators.Arguments = Iterators.Array;
    addToUnscopables("keys");
    addToUnscopables("values");
    addToUnscopables("entries");
    if (!IS_PURE && DESCRIPTORS2 && values2.name !== "values") try {
      defineProperty2(values2, "name", { value: "values" });
    } catch (error) {
    }
  }
});

// node_modules/core-js/internals/string-multibyte.js
var require_string_multibyte = __commonJS({
  "node_modules/core-js/internals/string-multibyte.js"(exports, module) {
    var uncurryThis3 = require_function_uncurry_this();
    var toIntegerOrInfinity2 = require_to_integer_or_infinity();
    var toString6 = require_to_string();
    var requireObjectCoercible3 = require_require_object_coercible();
    var charAt2 = uncurryThis3("".charAt);
    var charCodeAt = uncurryThis3("".charCodeAt);
    var stringSlice2 = uncurryThis3("".slice);
    var createMethod = function(CONVERT_TO_STRING) {
      return function($this, pos) {
        var S2 = toString6(requireObjectCoercible3($this));
        var position = toIntegerOrInfinity2(pos);
        var size4 = S2.length;
        var first2, second;
        if (position < 0 || position >= size4) return CONVERT_TO_STRING ? "" : void 0;
        first2 = charCodeAt(S2, position);
        return first2 < 55296 || first2 > 56319 || position + 1 === size4 || (second = charCodeAt(S2, position + 1)) < 56320 || second > 57343 ? CONVERT_TO_STRING ? charAt2(S2, position) : first2 : CONVERT_TO_STRING ? stringSlice2(S2, position, position + 2) : (first2 - 55296 << 10) + (second - 56320) + 65536;
      };
    };
    module.exports = {
      // `String.prototype.codePointAt` method
      // https://tc39.es/ecma262/#sec-string.prototype.codepointat
      codeAt: createMethod(false),
      // `String.prototype.at` method
      // https://github.com/mathiasbynens/String.prototype.at
      charAt: createMethod(true)
    };
  }
});

// node_modules/core-js/internals/define-built-ins.js
var require_define_built_ins = __commonJS({
  "node_modules/core-js/internals/define-built-ins.js"(exports, module) {
    var defineBuiltIn2 = require_define_built_in();
    module.exports = function(target, src, options2) {
      for (var key in src) defineBuiltIn2(target, key, src[key], options2);
      return target;
    };
  }
});

// node_modules/core-js/internals/create-property.js
var require_create_property = __commonJS({
  "node_modules/core-js/internals/create-property.js"(exports, module) {
    "use strict";
    var toPropertyKey = require_to_property_key();
    var definePropertyModule = require_object_define_property();
    var createPropertyDescriptor = require_create_property_descriptor();
    module.exports = function(object2, key, value2) {
      var propertyKey = toPropertyKey(key);
      if (propertyKey in object2) definePropertyModule.f(object2, propertyKey, createPropertyDescriptor(0, value2));
      else object2[propertyKey] = value2;
    };
  }
});

// node_modules/core-js/internals/array-slice-simple.js
var require_array_slice_simple = __commonJS({
  "node_modules/core-js/internals/array-slice-simple.js"(exports, module) {
    var toAbsoluteIndex = require_to_absolute_index();
    var lengthOfArrayLike = require_length_of_array_like();
    var createProperty = require_create_property();
    var $Array = Array;
    var max3 = Math.max;
    module.exports = function(O4, start, end) {
      var length = lengthOfArrayLike(O4);
      var k2 = toAbsoluteIndex(start, length);
      var fin = toAbsoluteIndex(end === void 0 ? length : end, length);
      var result2 = $Array(max3(fin - k2, 0));
      for (var n4 = 0; k2 < fin; k2++, n4++) createProperty(result2, n4, O4[k2]);
      result2.length = n4;
      return result2;
    };
  }
});

// node_modules/core-js/internals/object-get-own-property-names-external.js
var require_object_get_own_property_names_external = __commonJS({
  "node_modules/core-js/internals/object-get-own-property-names-external.js"(exports, module) {
    var classof = require_classof_raw();
    var toIndexedObject = require_to_indexed_object();
    var $getOwnPropertyNames = require_object_get_own_property_names().f;
    var arraySlice = require_array_slice_simple();
    var windowNames = typeof window == "object" && window && Object.getOwnPropertyNames ? Object.getOwnPropertyNames(window) : [];
    var getWindowNames = function(it2) {
      try {
        return $getOwnPropertyNames(it2);
      } catch (error) {
        return arraySlice(windowNames);
      }
    };
    module.exports.f = function getOwnPropertyNames(it2) {
      return windowNames && classof(it2) == "Window" ? getWindowNames(it2) : $getOwnPropertyNames(toIndexedObject(it2));
    };
  }
});

// node_modules/core-js/internals/array-buffer-non-extensible.js
var require_array_buffer_non_extensible = __commonJS({
  "node_modules/core-js/internals/array-buffer-non-extensible.js"(exports, module) {
    var fails2 = require_fails();
    module.exports = fails2(function() {
      if (typeof ArrayBuffer == "function") {
        var buffer = new ArrayBuffer(8);
        if (Object.isExtensible(buffer)) Object.defineProperty(buffer, "a", { value: 8 });
      }
    });
  }
});

// node_modules/core-js/internals/object-is-extensible.js
var require_object_is_extensible = __commonJS({
  "node_modules/core-js/internals/object-is-extensible.js"(exports, module) {
    var fails2 = require_fails();
    var isObject4 = require_is_object();
    var classof = require_classof_raw();
    var ARRAY_BUFFER_NON_EXTENSIBLE = require_array_buffer_non_extensible();
    var $isExtensible = Object.isExtensible;
    var FAILS_ON_PRIMITIVES = fails2(function() {
      $isExtensible(1);
    });
    module.exports = FAILS_ON_PRIMITIVES || ARRAY_BUFFER_NON_EXTENSIBLE ? function isExtensible(it2) {
      if (!isObject4(it2)) return false;
      if (ARRAY_BUFFER_NON_EXTENSIBLE && classof(it2) == "ArrayBuffer") return false;
      return $isExtensible ? $isExtensible(it2) : true;
    } : $isExtensible;
  }
});

// node_modules/core-js/internals/freezing.js
var require_freezing = __commonJS({
  "node_modules/core-js/internals/freezing.js"(exports, module) {
    var fails2 = require_fails();
    module.exports = !fails2(function() {
      return Object.isExtensible(Object.preventExtensions({}));
    });
  }
});

// node_modules/core-js/internals/internal-metadata.js
var require_internal_metadata = __commonJS({
  "node_modules/core-js/internals/internal-metadata.js"(exports, module) {
    var $6 = require_export();
    var uncurryThis3 = require_function_uncurry_this();
    var hiddenKeys = require_hidden_keys();
    var isObject4 = require_is_object();
    var hasOwn = require_has_own_property();
    var defineProperty2 = require_object_define_property().f;
    var getOwnPropertyNamesModule = require_object_get_own_property_names();
    var getOwnPropertyNamesExternalModule = require_object_get_own_property_names_external();
    var isExtensible = require_object_is_extensible();
    var uid = require_uid();
    var FREEZING = require_freezing();
    var REQUIRED = false;
    var METADATA = uid("meta");
    var id = 0;
    var setMetadata = function(it2) {
      defineProperty2(it2, METADATA, { value: {
        objectID: "O" + id++,
        // object ID
        weakData: {}
        // weak collections IDs
      } });
    };
    var fastKey = function(it2, create3) {
      if (!isObject4(it2)) return typeof it2 == "symbol" ? it2 : (typeof it2 == "string" ? "S" : "P") + it2;
      if (!hasOwn(it2, METADATA)) {
        if (!isExtensible(it2)) return "F";
        if (!create3) return "E";
        setMetadata(it2);
      }
      return it2[METADATA].objectID;
    };
    var getWeakData = function(it2, create3) {
      if (!hasOwn(it2, METADATA)) {
        if (!isExtensible(it2)) return true;
        if (!create3) return false;
        setMetadata(it2);
      }
      return it2[METADATA].weakData;
    };
    var onFreeze = function(it2) {
      if (FREEZING && REQUIRED && isExtensible(it2) && !hasOwn(it2, METADATA)) setMetadata(it2);
      return it2;
    };
    var enable = function() {
      meta.enable = function() {
      };
      REQUIRED = true;
      var getOwnPropertyNames = getOwnPropertyNamesModule.f;
      var splice = uncurryThis3([].splice);
      var test = {};
      test[METADATA] = 1;
      if (getOwnPropertyNames(test).length) {
        getOwnPropertyNamesModule.f = function(it2) {
          var result2 = getOwnPropertyNames(it2);
          for (var i3 = 0, length = result2.length; i3 < length; i3++) {
            if (result2[i3] === METADATA) {
              splice(result2, i3, 1);
              break;
            }
          }
          return result2;
        };
        $6({ target: "Object", stat: true, forced: true }, {
          getOwnPropertyNames: getOwnPropertyNamesExternalModule.f
        });
      }
    };
    var meta = module.exports = {
      enable,
      fastKey,
      getWeakData,
      onFreeze
    };
    hiddenKeys[METADATA] = true;
  }
});

// node_modules/core-js/internals/is-array-iterator-method.js
var require_is_array_iterator_method = __commonJS({
  "node_modules/core-js/internals/is-array-iterator-method.js"(exports, module) {
    var wellKnownSymbol3 = require_well_known_symbol();
    var Iterators = require_iterators();
    var ITERATOR2 = wellKnownSymbol3("iterator");
    var ArrayPrototype = Array.prototype;
    module.exports = function(it2) {
      return it2 !== void 0 && (Iterators.Array === it2 || ArrayPrototype[ITERATOR2] === it2);
    };
  }
});

// node_modules/core-js/internals/get-iterator-method.js
var require_get_iterator_method = __commonJS({
  "node_modules/core-js/internals/get-iterator-method.js"(exports, module) {
    var classof = require_classof();
    var getMethod3 = require_get_method();
    var isNullOrUndefined3 = require_is_null_or_undefined();
    var Iterators = require_iterators();
    var wellKnownSymbol3 = require_well_known_symbol();
    var ITERATOR2 = wellKnownSymbol3("iterator");
    module.exports = function(it2) {
      if (!isNullOrUndefined3(it2)) return getMethod3(it2, ITERATOR2) || getMethod3(it2, "@@iterator") || Iterators[classof(it2)];
    };
  }
});

// node_modules/core-js/internals/get-iterator.js
var require_get_iterator = __commonJS({
  "node_modules/core-js/internals/get-iterator.js"(exports, module) {
    var call3 = require_function_call();
    var aCallable = require_a_callable();
    var anObject3 = require_an_object();
    var tryToString = require_try_to_string();
    var getIteratorMethod = require_get_iterator_method();
    var $TypeError = TypeError;
    module.exports = function(argument, usingIterator) {
      var iteratorMethod = arguments.length < 2 ? getIteratorMethod(argument) : usingIterator;
      if (aCallable(iteratorMethod)) return anObject3(call3(iteratorMethod, argument));
      throw $TypeError(tryToString(argument) + " is not iterable");
    };
  }
});

// node_modules/core-js/internals/iterator-close.js
var require_iterator_close = __commonJS({
  "node_modules/core-js/internals/iterator-close.js"(exports, module) {
    var call3 = require_function_call();
    var anObject3 = require_an_object();
    var getMethod3 = require_get_method();
    module.exports = function(iterator, kind, value2) {
      var innerResult, innerError;
      anObject3(iterator);
      try {
        innerResult = getMethod3(iterator, "return");
        if (!innerResult) {
          if (kind === "throw") throw value2;
          return value2;
        }
        innerResult = call3(innerResult, iterator);
      } catch (error) {
        innerError = true;
        innerResult = error;
      }
      if (kind === "throw") throw value2;
      if (innerError) throw innerResult;
      anObject3(innerResult);
      return value2;
    };
  }
});

// node_modules/core-js/internals/iterate.js
var require_iterate = __commonJS({
  "node_modules/core-js/internals/iterate.js"(exports, module) {
    var bind2 = require_function_bind_context();
    var call3 = require_function_call();
    var anObject3 = require_an_object();
    var tryToString = require_try_to_string();
    var isArrayIteratorMethod = require_is_array_iterator_method();
    var lengthOfArrayLike = require_length_of_array_like();
    var isPrototypeOf = require_object_is_prototype_of();
    var getIterator = require_get_iterator();
    var getIteratorMethod = require_get_iterator_method();
    var iteratorClose = require_iterator_close();
    var $TypeError = TypeError;
    var Result = function(stopped, result2) {
      this.stopped = stopped;
      this.result = result2;
    };
    var ResultPrototype = Result.prototype;
    module.exports = function(iterable, unboundFunction, options2) {
      var that = options2 && options2.that;
      var AS_ENTRIES = !!(options2 && options2.AS_ENTRIES);
      var IS_RECORD = !!(options2 && options2.IS_RECORD);
      var IS_ITERATOR = !!(options2 && options2.IS_ITERATOR);
      var INTERRUPTED = !!(options2 && options2.INTERRUPTED);
      var fn = bind2(unboundFunction, that);
      var iterator, iterFn, index, length, result2, next2, step;
      var stop = function(condition) {
        if (iterator) iteratorClose(iterator, "normal", condition);
        return new Result(true, condition);
      };
      var callFn = function(value2) {
        if (AS_ENTRIES) {
          anObject3(value2);
          return INTERRUPTED ? fn(value2[0], value2[1], stop) : fn(value2[0], value2[1]);
        }
        return INTERRUPTED ? fn(value2, stop) : fn(value2);
      };
      if (IS_RECORD) {
        iterator = iterable.iterator;
      } else if (IS_ITERATOR) {
        iterator = iterable;
      } else {
        iterFn = getIteratorMethod(iterable);
        if (!iterFn) throw $TypeError(tryToString(iterable) + " is not iterable");
        if (isArrayIteratorMethod(iterFn)) {
          for (index = 0, length = lengthOfArrayLike(iterable); length > index; index++) {
            result2 = callFn(iterable[index]);
            if (result2 && isPrototypeOf(ResultPrototype, result2)) return result2;
          }
          return new Result(false);
        }
        iterator = getIterator(iterable, iterFn);
      }
      next2 = IS_RECORD ? iterable.next : iterator.next;
      while (!(step = call3(next2, iterator)).done) {
        try {
          result2 = callFn(step.value);
        } catch (error) {
          iteratorClose(iterator, "throw", error);
        }
        if (typeof result2 == "object" && result2 && isPrototypeOf(ResultPrototype, result2)) return result2;
      }
      return new Result(false);
    };
  }
});

// node_modules/core-js/internals/an-instance.js
var require_an_instance = __commonJS({
  "node_modules/core-js/internals/an-instance.js"(exports, module) {
    var isPrototypeOf = require_object_is_prototype_of();
    var $TypeError = TypeError;
    module.exports = function(it2, Prototype) {
      if (isPrototypeOf(Prototype, it2)) return it2;
      throw $TypeError("Incorrect invocation");
    };
  }
});

// node_modules/core-js/internals/check-correctness-of-iteration.js
var require_check_correctness_of_iteration = __commonJS({
  "node_modules/core-js/internals/check-correctness-of-iteration.js"(exports, module) {
    var wellKnownSymbol3 = require_well_known_symbol();
    var ITERATOR2 = wellKnownSymbol3("iterator");
    var SAFE_CLOSING = false;
    try {
      called = 0;
      iteratorWithReturn = {
        next: function() {
          return { done: !!called++ };
        },
        "return": function() {
          SAFE_CLOSING = true;
        }
      };
      iteratorWithReturn[ITERATOR2] = function() {
        return this;
      };
      Array.from(iteratorWithReturn, function() {
        throw 2;
      });
    } catch (error) {
    }
    var called;
    var iteratorWithReturn;
    module.exports = function(exec, SKIP_CLOSING) {
      if (!SKIP_CLOSING && !SAFE_CLOSING) return false;
      var ITERATION_SUPPORT = false;
      try {
        var object2 = {};
        object2[ITERATOR2] = function() {
          return {
            next: function() {
              return { done: ITERATION_SUPPORT = true };
            }
          };
        };
        exec(object2);
      } catch (error) {
      }
      return ITERATION_SUPPORT;
    };
  }
});

// node_modules/core-js/internals/inherit-if-required.js
var require_inherit_if_required = __commonJS({
  "node_modules/core-js/internals/inherit-if-required.js"(exports, module) {
    var isCallable2 = require_is_callable();
    var isObject4 = require_is_object();
    var setPrototypeOf = require_object_set_prototype_of();
    module.exports = function($this, dummy, Wrapper) {
      var NewTarget, NewTargetPrototype;
      if (
        // it can work only with native `setPrototypeOf`
        setPrototypeOf && // we haven't completely correct pre-ES6 way for getting `new.target`, so use this
        isCallable2(NewTarget = dummy.constructor) && NewTarget !== Wrapper && isObject4(NewTargetPrototype = NewTarget.prototype) && NewTargetPrototype !== Wrapper.prototype
      ) setPrototypeOf($this, NewTargetPrototype);
      return $this;
    };
  }
});

// node_modules/core-js/internals/collection.js
var require_collection = __commonJS({
  "node_modules/core-js/internals/collection.js"(exports, module) {
    "use strict";
    var $6 = require_export();
    var global5 = require_global();
    var uncurryThis3 = require_function_uncurry_this();
    var isForced = require_is_forced();
    var defineBuiltIn2 = require_define_built_in();
    var InternalMetadataModule = require_internal_metadata();
    var iterate = require_iterate();
    var anInstance = require_an_instance();
    var isCallable2 = require_is_callable();
    var isNullOrUndefined3 = require_is_null_or_undefined();
    var isObject4 = require_is_object();
    var fails2 = require_fails();
    var checkCorrectnessOfIteration = require_check_correctness_of_iteration();
    var setToStringTag = require_set_to_string_tag();
    var inheritIfRequired = require_inherit_if_required();
    module.exports = function(CONSTRUCTOR_NAME, wrapper, common) {
      var IS_MAP = CONSTRUCTOR_NAME.indexOf("Map") !== -1;
      var IS_WEAK = CONSTRUCTOR_NAME.indexOf("Weak") !== -1;
      var ADDER = IS_MAP ? "set" : "add";
      var NativeConstructor = global5[CONSTRUCTOR_NAME];
      var NativePrototype = NativeConstructor && NativeConstructor.prototype;
      var Constructor = NativeConstructor;
      var exported = {};
      var fixMethod = function(KEY) {
        var uncurriedNativeMethod = uncurryThis3(NativePrototype[KEY]);
        defineBuiltIn2(
          NativePrototype,
          KEY,
          KEY == "add" ? function add3(value2) {
            uncurriedNativeMethod(this, value2 === 0 ? 0 : value2);
            return this;
          } : KEY == "delete" ? function(key) {
            return IS_WEAK && !isObject4(key) ? false : uncurriedNativeMethod(this, key === 0 ? 0 : key);
          } : KEY == "get" ? function get3(key) {
            return IS_WEAK && !isObject4(key) ? void 0 : uncurriedNativeMethod(this, key === 0 ? 0 : key);
          } : KEY == "has" ? function has3(key) {
            return IS_WEAK && !isObject4(key) ? false : uncurriedNativeMethod(this, key === 0 ? 0 : key);
          } : function set(key, value2) {
            uncurriedNativeMethod(this, key === 0 ? 0 : key, value2);
            return this;
          }
        );
      };
      var REPLACE2 = isForced(
        CONSTRUCTOR_NAME,
        !isCallable2(NativeConstructor) || !(IS_WEAK || NativePrototype.forEach && !fails2(function() {
          new NativeConstructor().entries().next();
        }))
      );
      if (REPLACE2) {
        Constructor = common.getConstructor(wrapper, CONSTRUCTOR_NAME, IS_MAP, ADDER);
        InternalMetadataModule.enable();
      } else if (isForced(CONSTRUCTOR_NAME, true)) {
        var instance = new Constructor();
        var HASNT_CHAINING = instance[ADDER](IS_WEAK ? {} : -0, 1) != instance;
        var THROWS_ON_PRIMITIVES = fails2(function() {
          instance.has(1);
        });
        var ACCEPT_ITERABLES = checkCorrectnessOfIteration(function(iterable) {
          new NativeConstructor(iterable);
        });
        var BUGGY_ZERO = !IS_WEAK && fails2(function() {
          var $instance = new NativeConstructor();
          var index = 5;
          while (index--) $instance[ADDER](index, index);
          return !$instance.has(-0);
        });
        if (!ACCEPT_ITERABLES) {
          Constructor = wrapper(function(dummy, iterable) {
            anInstance(dummy, NativePrototype);
            var that = inheritIfRequired(new NativeConstructor(), dummy, Constructor);
            if (!isNullOrUndefined3(iterable)) iterate(iterable, that[ADDER], { that, AS_ENTRIES: IS_MAP });
            return that;
          });
          Constructor.prototype = NativePrototype;
          NativePrototype.constructor = Constructor;
        }
        if (THROWS_ON_PRIMITIVES || BUGGY_ZERO) {
          fixMethod("delete");
          fixMethod("has");
          IS_MAP && fixMethod("get");
        }
        if (BUGGY_ZERO || HASNT_CHAINING) fixMethod(ADDER);
        if (IS_WEAK && NativePrototype.clear) delete NativePrototype.clear;
      }
      exported[CONSTRUCTOR_NAME] = Constructor;
      $6({ global: true, constructor: true, forced: Constructor != NativeConstructor }, exported);
      setToStringTag(Constructor, CONSTRUCTOR_NAME);
      if (!IS_WEAK) common.setStrong(Constructor, CONSTRUCTOR_NAME, IS_MAP);
      return Constructor;
    };
  }
});

// node_modules/core-js/internals/collection-weak.js
var require_collection_weak = __commonJS({
  "node_modules/core-js/internals/collection-weak.js"(exports, module) {
    "use strict";
    var uncurryThis3 = require_function_uncurry_this();
    var defineBuiltIns = require_define_built_ins();
    var getWeakData = require_internal_metadata().getWeakData;
    var anInstance = require_an_instance();
    var anObject3 = require_an_object();
    var isNullOrUndefined3 = require_is_null_or_undefined();
    var isObject4 = require_is_object();
    var iterate = require_iterate();
    var ArrayIterationModule = require_array_iteration();
    var hasOwn = require_has_own_property();
    var InternalStateModule2 = require_internal_state();
    var setInternalState2 = InternalStateModule2.set;
    var internalStateGetterFor = InternalStateModule2.getterFor;
    var find2 = ArrayIterationModule.find;
    var findIndex = ArrayIterationModule.findIndex;
    var splice = uncurryThis3([].splice);
    var id = 0;
    var uncaughtFrozenStore = function(store2) {
      return store2.frozen || (store2.frozen = new UncaughtFrozenStore());
    };
    var UncaughtFrozenStore = function() {
      this.entries = [];
    };
    var findUncaughtFrozen = function(store2, key) {
      return find2(store2.entries, function(it2) {
        return it2[0] === key;
      });
    };
    UncaughtFrozenStore.prototype = {
      get: function(key) {
        var entry = findUncaughtFrozen(this, key);
        if (entry) return entry[1];
      },
      has: function(key) {
        return !!findUncaughtFrozen(this, key);
      },
      set: function(key, value2) {
        var entry = findUncaughtFrozen(this, key);
        if (entry) entry[1] = value2;
        else this.entries.push([key, value2]);
      },
      "delete": function(key) {
        var index = findIndex(this.entries, function(it2) {
          return it2[0] === key;
        });
        if (~index) splice(this.entries, index, 1);
        return !!~index;
      }
    };
    module.exports = {
      getConstructor: function(wrapper, CONSTRUCTOR_NAME, IS_MAP, ADDER) {
        var Constructor = wrapper(function(that, iterable) {
          anInstance(that, Prototype);
          setInternalState2(that, {
            type: CONSTRUCTOR_NAME,
            id: id++,
            frozen: void 0
          });
          if (!isNullOrUndefined3(iterable)) iterate(iterable, that[ADDER], { that, AS_ENTRIES: IS_MAP });
        });
        var Prototype = Constructor.prototype;
        var getInternalState2 = internalStateGetterFor(CONSTRUCTOR_NAME);
        var define2 = function(that, key, value2) {
          var state = getInternalState2(that);
          var data2 = getWeakData(anObject3(key), true);
          if (data2 === true) uncaughtFrozenStore(state).set(key, value2);
          else data2[state.id] = value2;
          return that;
        };
        defineBuiltIns(Prototype, {
          // `{ WeakMap, WeakSet }.prototype.delete(key)` methods
          // https://tc39.es/ecma262/#sec-weakmap.prototype.delete
          // https://tc39.es/ecma262/#sec-weakset.prototype.delete
          "delete": function(key) {
            var state = getInternalState2(this);
            if (!isObject4(key)) return false;
            var data2 = getWeakData(key);
            if (data2 === true) return uncaughtFrozenStore(state)["delete"](key);
            return data2 && hasOwn(data2, state.id) && delete data2[state.id];
          },
          // `{ WeakMap, WeakSet }.prototype.has(key)` methods
          // https://tc39.es/ecma262/#sec-weakmap.prototype.has
          // https://tc39.es/ecma262/#sec-weakset.prototype.has
          has: function has3(key) {
            var state = getInternalState2(this);
            if (!isObject4(key)) return false;
            var data2 = getWeakData(key);
            if (data2 === true) return uncaughtFrozenStore(state).has(key);
            return data2 && hasOwn(data2, state.id);
          }
        });
        defineBuiltIns(Prototype, IS_MAP ? {
          // `WeakMap.prototype.get(key)` method
          // https://tc39.es/ecma262/#sec-weakmap.prototype.get
          get: function get3(key) {
            var state = getInternalState2(this);
            if (isObject4(key)) {
              var data2 = getWeakData(key);
              if (data2 === true) return uncaughtFrozenStore(state).get(key);
              return data2 ? data2[state.id] : void 0;
            }
          },
          // `WeakMap.prototype.set(key, value)` method
          // https://tc39.es/ecma262/#sec-weakmap.prototype.set
          set: function set(key, value2) {
            return define2(this, key, value2);
          }
        } : {
          // `WeakSet.prototype.add(value)` method
          // https://tc39.es/ecma262/#sec-weakset.prototype.add
          add: function add3(value2) {
            return define2(this, value2, true);
          }
        });
        return Constructor;
      }
    };
  }
});

// node_modules/core-js/modules/es.weak-map.constructor.js
var require_es_weak_map_constructor = __commonJS({
  "node_modules/core-js/modules/es.weak-map.constructor.js"() {
    "use strict";
    var global5 = require_global();
    var uncurryThis3 = require_function_uncurry_this();
    var defineBuiltIns = require_define_built_ins();
    var InternalMetadataModule = require_internal_metadata();
    var collection = require_collection();
    var collectionWeak = require_collection_weak();
    var isObject4 = require_is_object();
    var isExtensible = require_object_is_extensible();
    var enforceInternalState = require_internal_state().enforce;
    var NATIVE_WEAK_MAP = require_weak_map_basic_detection();
    var IS_IE11 = !global5.ActiveXObject && "ActiveXObject" in global5;
    var InternalWeakMap;
    var wrapper = function(init) {
      return function WeakMap2() {
        return init(this, arguments.length ? arguments[0] : void 0);
      };
    };
    var $WeakMap = collection("WeakMap", wrapper, collectionWeak);
    if (NATIVE_WEAK_MAP && IS_IE11) {
      InternalWeakMap = collectionWeak.getConstructor(wrapper, "WeakMap", true);
      InternalMetadataModule.enable();
      WeakMapPrototype = $WeakMap.prototype;
      nativeDelete = uncurryThis3(WeakMapPrototype["delete"]);
      nativeHas = uncurryThis3(WeakMapPrototype.has);
      nativeGet = uncurryThis3(WeakMapPrototype.get);
      nativeSet = uncurryThis3(WeakMapPrototype.set);
      defineBuiltIns(WeakMapPrototype, {
        "delete": function(key) {
          if (isObject4(key) && !isExtensible(key)) {
            var state = enforceInternalState(this);
            if (!state.frozen) state.frozen = new InternalWeakMap();
            return nativeDelete(this, key) || state.frozen["delete"](key);
          }
          return nativeDelete(this, key);
        },
        has: function has3(key) {
          if (isObject4(key) && !isExtensible(key)) {
            var state = enforceInternalState(this);
            if (!state.frozen) state.frozen = new InternalWeakMap();
            return nativeHas(this, key) || state.frozen.has(key);
          }
          return nativeHas(this, key);
        },
        get: function get3(key) {
          if (isObject4(key) && !isExtensible(key)) {
            var state = enforceInternalState(this);
            if (!state.frozen) state.frozen = new InternalWeakMap();
            return nativeHas(this, key) ? nativeGet(this, key) : state.frozen.get(key);
          }
          return nativeGet(this, key);
        },
        set: function set(key, value2) {
          if (isObject4(key) && !isExtensible(key)) {
            var state = enforceInternalState(this);
            if (!state.frozen) state.frozen = new InternalWeakMap();
            nativeHas(this, key) ? nativeSet(this, key, value2) : state.frozen.set(key, value2);
          } else nativeSet(this, key, value2);
          return this;
        }
      });
    }
    var WeakMapPrototype;
    var nativeDelete;
    var nativeHas;
    var nativeGet;
    var nativeSet;
  }
});

// node_modules/lodash.throttle/index.js
var require_lodash = __commonJS({
  "node_modules/lodash.throttle/index.js"(exports, module) {
    var FUNC_ERROR_TEXT = "Expected a function";
    var NAN = 0 / 0;
    var symbolTag = "[object Symbol]";
    var reTrim = /^\s+|\s+$/g;
    var reIsBadHex = /^[-+]0x[0-9a-f]+$/i;
    var reIsBinary = /^0b[01]+$/i;
    var reIsOctal = /^0o[0-7]+$/i;
    var freeParseInt = parseInt;
    var freeGlobal = typeof global == "object" && global && global.Object === Object && global;
    var freeSelf = typeof self == "object" && self && self.Object === Object && self;
    var root2 = freeGlobal || freeSelf || Function("return this")();
    var objectProto = Object.prototype;
    var objectToString = objectProto.toString;
    var nativeMax = Math.max;
    var nativeMin = Math.min;
    var now = function() {
      return root2.Date.now();
    };
    function debounce4(func, wait, options2) {
      var lastArgs, lastThis, maxWait, result2, timerId, lastCallTime, lastInvokeTime = 0, leading = false, maxing = false, trailing = true;
      if (typeof func != "function") {
        throw new TypeError(FUNC_ERROR_TEXT);
      }
      wait = toNumber(wait) || 0;
      if (isObject4(options2)) {
        leading = !!options2.leading;
        maxing = "maxWait" in options2;
        maxWait = maxing ? nativeMax(toNumber(options2.maxWait) || 0, wait) : maxWait;
        trailing = "trailing" in options2 ? !!options2.trailing : trailing;
      }
      function invokeFunc(time3) {
        var args = lastArgs, thisArg = lastThis;
        lastArgs = lastThis = void 0;
        lastInvokeTime = time3;
        result2 = func.apply(thisArg, args);
        return result2;
      }
      function leadingEdge(time3) {
        lastInvokeTime = time3;
        timerId = setTimeout(timerExpired, wait);
        return leading ? invokeFunc(time3) : result2;
      }
      function remainingWait(time3) {
        var timeSinceLastCall = time3 - lastCallTime, timeSinceLastInvoke = time3 - lastInvokeTime, result3 = wait - timeSinceLastCall;
        return maxing ? nativeMin(result3, maxWait - timeSinceLastInvoke) : result3;
      }
      function shouldInvoke(time3) {
        var timeSinceLastCall = time3 - lastCallTime, timeSinceLastInvoke = time3 - lastInvokeTime;
        return lastCallTime === void 0 || timeSinceLastCall >= wait || timeSinceLastCall < 0 || maxing && timeSinceLastInvoke >= maxWait;
      }
      function timerExpired() {
        var time3 = now();
        if (shouldInvoke(time3)) {
          return trailingEdge(time3);
        }
        timerId = setTimeout(timerExpired, remainingWait(time3));
      }
      function trailingEdge(time3) {
        timerId = void 0;
        if (trailing && lastArgs) {
          return invokeFunc(time3);
        }
        lastArgs = lastThis = void 0;
        return result2;
      }
      function cancel() {
        if (timerId !== void 0) {
          clearTimeout(timerId);
        }
        lastInvokeTime = 0;
        lastArgs = lastCallTime = lastThis = timerId = void 0;
      }
      function flush() {
        return timerId === void 0 ? result2 : trailingEdge(now());
      }
      function debounced() {
        var time3 = now(), isInvoking = shouldInvoke(time3);
        lastArgs = arguments;
        lastThis = this;
        lastCallTime = time3;
        if (isInvoking) {
          if (timerId === void 0) {
            return leadingEdge(lastCallTime);
          }
          if (maxing) {
            timerId = setTimeout(timerExpired, wait);
            return invokeFunc(lastCallTime);
          }
        }
        if (timerId === void 0) {
          timerId = setTimeout(timerExpired, wait);
        }
        return result2;
      }
      debounced.cancel = cancel;
      debounced.flush = flush;
      return debounced;
    }
    function throttle3(func, wait, options2) {
      var leading = true, trailing = true;
      if (typeof func != "function") {
        throw new TypeError(FUNC_ERROR_TEXT);
      }
      if (isObject4(options2)) {
        leading = "leading" in options2 ? !!options2.leading : leading;
        trailing = "trailing" in options2 ? !!options2.trailing : trailing;
      }
      return debounce4(func, wait, {
        "leading": leading,
        "maxWait": wait,
        "trailing": trailing
      });
    }
    function isObject4(value2) {
      var type = typeof value2;
      return !!value2 && (type == "object" || type == "function");
    }
    function isObjectLike(value2) {
      return !!value2 && typeof value2 == "object";
    }
    function isSymbol(value2) {
      return typeof value2 == "symbol" || isObjectLike(value2) && objectToString.call(value2) == symbolTag;
    }
    function toNumber(value2) {
      if (typeof value2 == "number") {
        return value2;
      }
      if (isSymbol(value2)) {
        return NAN;
      }
      if (isObject4(value2)) {
        var other = typeof value2.valueOf == "function" ? value2.valueOf() : value2;
        value2 = isObject4(other) ? other + "" : other;
      }
      if (typeof value2 != "string") {
        return value2 === 0 ? value2 : +value2;
      }
      value2 = value2.replace(reTrim, "");
      var isBinary = reIsBinary.test(value2);
      return isBinary || reIsOctal.test(value2) ? freeParseInt(value2.slice(2), isBinary ? 2 : 8) : reIsBadHex.test(value2) ? NAN : +value2;
    }
    module.exports = throttle3;
  }
});

// node_modules/lodash.debounce/index.js
var require_lodash2 = __commonJS({
  "node_modules/lodash.debounce/index.js"(exports, module) {
    var FUNC_ERROR_TEXT = "Expected a function";
    var NAN = 0 / 0;
    var symbolTag = "[object Symbol]";
    var reTrim = /^\s+|\s+$/g;
    var reIsBadHex = /^[-+]0x[0-9a-f]+$/i;
    var reIsBinary = /^0b[01]+$/i;
    var reIsOctal = /^0o[0-7]+$/i;
    var freeParseInt = parseInt;
    var freeGlobal = typeof global == "object" && global && global.Object === Object && global;
    var freeSelf = typeof self == "object" && self && self.Object === Object && self;
    var root2 = freeGlobal || freeSelf || Function("return this")();
    var objectProto = Object.prototype;
    var objectToString = objectProto.toString;
    var nativeMax = Math.max;
    var nativeMin = Math.min;
    var now = function() {
      return root2.Date.now();
    };
    function debounce4(func, wait, options2) {
      var lastArgs, lastThis, maxWait, result2, timerId, lastCallTime, lastInvokeTime = 0, leading = false, maxing = false, trailing = true;
      if (typeof func != "function") {
        throw new TypeError(FUNC_ERROR_TEXT);
      }
      wait = toNumber(wait) || 0;
      if (isObject4(options2)) {
        leading = !!options2.leading;
        maxing = "maxWait" in options2;
        maxWait = maxing ? nativeMax(toNumber(options2.maxWait) || 0, wait) : maxWait;
        trailing = "trailing" in options2 ? !!options2.trailing : trailing;
      }
      function invokeFunc(time3) {
        var args = lastArgs, thisArg = lastThis;
        lastArgs = lastThis = void 0;
        lastInvokeTime = time3;
        result2 = func.apply(thisArg, args);
        return result2;
      }
      function leadingEdge(time3) {
        lastInvokeTime = time3;
        timerId = setTimeout(timerExpired, wait);
        return leading ? invokeFunc(time3) : result2;
      }
      function remainingWait(time3) {
        var timeSinceLastCall = time3 - lastCallTime, timeSinceLastInvoke = time3 - lastInvokeTime, result3 = wait - timeSinceLastCall;
        return maxing ? nativeMin(result3, maxWait - timeSinceLastInvoke) : result3;
      }
      function shouldInvoke(time3) {
        var timeSinceLastCall = time3 - lastCallTime, timeSinceLastInvoke = time3 - lastInvokeTime;
        return lastCallTime === void 0 || timeSinceLastCall >= wait || timeSinceLastCall < 0 || maxing && timeSinceLastInvoke >= maxWait;
      }
      function timerExpired() {
        var time3 = now();
        if (shouldInvoke(time3)) {
          return trailingEdge(time3);
        }
        timerId = setTimeout(timerExpired, remainingWait(time3));
      }
      function trailingEdge(time3) {
        timerId = void 0;
        if (trailing && lastArgs) {
          return invokeFunc(time3);
        }
        lastArgs = lastThis = void 0;
        return result2;
      }
      function cancel() {
        if (timerId !== void 0) {
          clearTimeout(timerId);
        }
        lastInvokeTime = 0;
        lastArgs = lastCallTime = lastThis = timerId = void 0;
      }
      function flush() {
        return timerId === void 0 ? result2 : trailingEdge(now());
      }
      function debounced() {
        var time3 = now(), isInvoking = shouldInvoke(time3);
        lastArgs = arguments;
        lastThis = this;
        lastCallTime = time3;
        if (isInvoking) {
          if (timerId === void 0) {
            return leadingEdge(lastCallTime);
          }
          if (maxing) {
            timerId = setTimeout(timerExpired, wait);
            return invokeFunc(lastCallTime);
          }
        }
        if (timerId === void 0) {
          timerId = setTimeout(timerExpired, wait);
        }
        return result2;
      }
      debounced.cancel = cancel;
      debounced.flush = flush;
      return debounced;
    }
    function isObject4(value2) {
      var type = typeof value2;
      return !!value2 && (type == "object" || type == "function");
    }
    function isObjectLike(value2) {
      return !!value2 && typeof value2 == "object";
    }
    function isSymbol(value2) {
      return typeof value2 == "symbol" || isObjectLike(value2) && objectToString.call(value2) == symbolTag;
    }
    function toNumber(value2) {
      if (typeof value2 == "number") {
        return value2;
      }
      if (isSymbol(value2)) {
        return NAN;
      }
      if (isObject4(value2)) {
        var other = typeof value2.valueOf == "function" ? value2.valueOf() : value2;
        value2 = isObject4(other) ? other + "" : other;
      }
      if (typeof value2 != "string") {
        return value2 === 0 ? value2 : +value2;
      }
      value2 = value2.replace(reTrim, "");
      var isBinary = reIsBinary.test(value2);
      return isBinary || reIsOctal.test(value2) ? freeParseInt(value2.slice(2), isBinary ? 2 : 8) : reIsBadHex.test(value2) ? NAN : +value2;
    }
    module.exports = debounce4;
  }
});

// node_modules/lodash.memoize/index.js
var require_lodash3 = __commonJS({
  "node_modules/lodash.memoize/index.js"(exports, module) {
    var FUNC_ERROR_TEXT = "Expected a function";
    var HASH_UNDEFINED = "__lodash_hash_undefined__";
    var funcTag = "[object Function]";
    var genTag = "[object GeneratorFunction]";
    var reRegExpChar = /[\\^$.*+?()[\]{}|]/g;
    var reIsHostCtor = /^\[object .+?Constructor\]$/;
    var freeGlobal = typeof global == "object" && global && global.Object === Object && global;
    var freeSelf = typeof self == "object" && self && self.Object === Object && self;
    var root2 = freeGlobal || freeSelf || Function("return this")();
    function getValue2(object2, key) {
      return object2 == null ? void 0 : object2[key];
    }
    function isHostObject(value2) {
      var result2 = false;
      if (value2 != null && typeof value2.toString != "function") {
        try {
          result2 = !!(value2 + "");
        } catch (e3) {
        }
      }
      return result2;
    }
    var arrayProto = Array.prototype;
    var funcProto = Function.prototype;
    var objectProto = Object.prototype;
    var coreJsData = root2["__core-js_shared__"];
    var maskSrcKey = function() {
      var uid = /[^.]+$/.exec(coreJsData && coreJsData.keys && coreJsData.keys.IE_PROTO || "");
      return uid ? "Symbol(src)_1." + uid : "";
    }();
    var funcToString = funcProto.toString;
    var hasOwnProperty2 = objectProto.hasOwnProperty;
    var objectToString = objectProto.toString;
    var reIsNative = RegExp(
      "^" + funcToString.call(hasOwnProperty2).replace(reRegExpChar, "\\$&").replace(/hasOwnProperty|(function).*?(?=\\\()| for .+?(?=\\\])/g, "$1.*?") + "$"
    );
    var splice = arrayProto.splice;
    var Map2 = getNative(root2, "Map");
    var nativeCreate2 = getNative(Object, "create");
    function Hash(entries2) {
      var index = -1, length = entries2 ? entries2.length : 0;
      this.clear();
      while (++index < length) {
        var entry = entries2[index];
        this.set(entry[0], entry[1]);
      }
    }
    function hashClear() {
      this.__data__ = nativeCreate2 ? nativeCreate2(null) : {};
    }
    function hashDelete(key) {
      return this.has(key) && delete this.__data__[key];
    }
    function hashGet(key) {
      var data2 = this.__data__;
      if (nativeCreate2) {
        var result2 = data2[key];
        return result2 === HASH_UNDEFINED ? void 0 : result2;
      }
      return hasOwnProperty2.call(data2, key) ? data2[key] : void 0;
    }
    function hashHas(key) {
      var data2 = this.__data__;
      return nativeCreate2 ? data2[key] !== void 0 : hasOwnProperty2.call(data2, key);
    }
    function hashSet(key, value2) {
      var data2 = this.__data__;
      data2[key] = nativeCreate2 && value2 === void 0 ? HASH_UNDEFINED : value2;
      return this;
    }
    Hash.prototype.clear = hashClear;
    Hash.prototype["delete"] = hashDelete;
    Hash.prototype.get = hashGet;
    Hash.prototype.has = hashHas;
    Hash.prototype.set = hashSet;
    function ListCache(entries2) {
      var index = -1, length = entries2 ? entries2.length : 0;
      this.clear();
      while (++index < length) {
        var entry = entries2[index];
        this.set(entry[0], entry[1]);
      }
    }
    function listCacheClear() {
      this.__data__ = [];
    }
    function listCacheDelete(key) {
      var data2 = this.__data__, index = assocIndexOf(data2, key);
      if (index < 0) {
        return false;
      }
      var lastIndex = data2.length - 1;
      if (index == lastIndex) {
        data2.pop();
      } else {
        splice.call(data2, index, 1);
      }
      return true;
    }
    function listCacheGet(key) {
      var data2 = this.__data__, index = assocIndexOf(data2, key);
      return index < 0 ? void 0 : data2[index][1];
    }
    function listCacheHas(key) {
      return assocIndexOf(this.__data__, key) > -1;
    }
    function listCacheSet(key, value2) {
      var data2 = this.__data__, index = assocIndexOf(data2, key);
      if (index < 0) {
        data2.push([key, value2]);
      } else {
        data2[index][1] = value2;
      }
      return this;
    }
    ListCache.prototype.clear = listCacheClear;
    ListCache.prototype["delete"] = listCacheDelete;
    ListCache.prototype.get = listCacheGet;
    ListCache.prototype.has = listCacheHas;
    ListCache.prototype.set = listCacheSet;
    function MapCache(entries2) {
      var index = -1, length = entries2 ? entries2.length : 0;
      this.clear();
      while (++index < length) {
        var entry = entries2[index];
        this.set(entry[0], entry[1]);
      }
    }
    function mapCacheClear() {
      this.__data__ = {
        "hash": new Hash(),
        "map": new (Map2 || ListCache)(),
        "string": new Hash()
      };
    }
    function mapCacheDelete(key) {
      return getMapData(this, key)["delete"](key);
    }
    function mapCacheGet(key) {
      return getMapData(this, key).get(key);
    }
    function mapCacheHas(key) {
      return getMapData(this, key).has(key);
    }
    function mapCacheSet(key, value2) {
      getMapData(this, key).set(key, value2);
      return this;
    }
    MapCache.prototype.clear = mapCacheClear;
    MapCache.prototype["delete"] = mapCacheDelete;
    MapCache.prototype.get = mapCacheGet;
    MapCache.prototype.has = mapCacheHas;
    MapCache.prototype.set = mapCacheSet;
    function assocIndexOf(array, key) {
      var length = array.length;
      while (length--) {
        if (eq2(array[length][0], key)) {
          return length;
        }
      }
      return -1;
    }
    function baseIsNative(value2) {
      if (!isObject4(value2) || isMasked(value2)) {
        return false;
      }
      var pattern = isFunction3(value2) || isHostObject(value2) ? reIsNative : reIsHostCtor;
      return pattern.test(toSource(value2));
    }
    function getMapData(map3, key) {
      var data2 = map3.__data__;
      return isKeyable(key) ? data2[typeof key == "string" ? "string" : "hash"] : data2.map;
    }
    function getNative(object2, key) {
      var value2 = getValue2(object2, key);
      return baseIsNative(value2) ? value2 : void 0;
    }
    function isKeyable(value2) {
      var type = typeof value2;
      return type == "string" || type == "number" || type == "symbol" || type == "boolean" ? value2 !== "__proto__" : value2 === null;
    }
    function isMasked(func) {
      return !!maskSrcKey && maskSrcKey in func;
    }
    function toSource(func) {
      if (func != null) {
        try {
          return funcToString.call(func);
        } catch (e3) {
        }
        try {
          return func + "";
        } catch (e3) {
        }
      }
      return "";
    }
    function memoize4(func, resolver) {
      if (typeof func != "function" || resolver && typeof resolver != "function") {
        throw new TypeError(FUNC_ERROR_TEXT);
      }
      var memoized = function() {
        var args = arguments, key = resolver ? resolver.apply(this, args) : args[0], cache3 = memoized.cache;
        if (cache3.has(key)) {
          return cache3.get(key);
        }
        var result2 = func.apply(this, args);
        memoized.cache = cache3.set(key, result2);
        return result2;
      };
      memoized.cache = new (memoize4.Cache || MapCache)();
      return memoized;
    }
    memoize4.Cache = MapCache;
    function eq2(value2, other) {
      return value2 === other || value2 !== value2 && other !== other;
    }
    function isFunction3(value2) {
      var tag = isObject4(value2) ? objectToString.call(value2) : "";
      return tag == funcTag || tag == genTag;
    }
    function isObject4(value2) {
      var type = typeof value2;
      return !!value2 && (type == "object" || type == "function");
    }
    module.exports = memoize4;
  }
});

// node_modules/core-js/internals/array-reduce.js
var require_array_reduce = __commonJS({
  "node_modules/core-js/internals/array-reduce.js"(exports, module) {
    var aCallable = require_a_callable();
    var toObject = require_to_object();
    var IndexedObject = require_indexed_object();
    var lengthOfArrayLike = require_length_of_array_like();
    var $TypeError = TypeError;
    var createMethod = function(IS_RIGHT) {
      return function(that, callbackfn, argumentsLength, memo) {
        aCallable(callbackfn);
        var O4 = toObject(that);
        var self2 = IndexedObject(O4);
        var length = lengthOfArrayLike(O4);
        var index = IS_RIGHT ? length - 1 : 0;
        var i3 = IS_RIGHT ? -1 : 1;
        if (argumentsLength < 2) while (true) {
          if (index in self2) {
            memo = self2[index];
            index += i3;
            break;
          }
          index += i3;
          if (IS_RIGHT ? index < 0 : length <= index) {
            throw $TypeError("Reduce of empty array with no initial value");
          }
        }
        for (; IS_RIGHT ? index >= 0 : length > index; index += i3) if (index in self2) {
          memo = callbackfn(memo, self2[index], index, O4);
        }
        return memo;
      };
    };
    module.exports = {
      // `Array.prototype.reduce` method
      // https://tc39.es/ecma262/#sec-array.prototype.reduce
      left: createMethod(false),
      // `Array.prototype.reduceRight` method
      // https://tc39.es/ecma262/#sec-array.prototype.reduceright
      right: createMethod(true)
    };
  }
});

// node_modules/core-js/internals/engine-is-node.js
var require_engine_is_node = __commonJS({
  "node_modules/core-js/internals/engine-is-node.js"(exports, module) {
    var classof = require_classof_raw();
    var global5 = require_global();
    module.exports = classof(global5.process) == "process";
  }
});

// node_modules/core-js/internals/regexp-flags.js
var require_regexp_flags = __commonJS({
  "node_modules/core-js/internals/regexp-flags.js"(exports, module) {
    "use strict";
    var anObject3 = require_an_object();
    module.exports = function() {
      var that = anObject3(this);
      var result2 = "";
      if (that.hasIndices) result2 += "d";
      if (that.global) result2 += "g";
      if (that.ignoreCase) result2 += "i";
      if (that.multiline) result2 += "m";
      if (that.dotAll) result2 += "s";
      if (that.unicode) result2 += "u";
      if (that.unicodeSets) result2 += "v";
      if (that.sticky) result2 += "y";
      return result2;
    };
  }
});

// node_modules/core-js/internals/regexp-sticky-helpers.js
var require_regexp_sticky_helpers = __commonJS({
  "node_modules/core-js/internals/regexp-sticky-helpers.js"(exports, module) {
    var fails2 = require_fails();
    var global5 = require_global();
    var $RegExp = global5.RegExp;
    var UNSUPPORTED_Y = fails2(function() {
      var re = $RegExp("a", "y");
      re.lastIndex = 2;
      return re.exec("abcd") != null;
    });
    var MISSED_STICKY = UNSUPPORTED_Y || fails2(function() {
      return !$RegExp("a", "y").sticky;
    });
    var BROKEN_CARET = UNSUPPORTED_Y || fails2(function() {
      var re = $RegExp("^r", "gy");
      re.lastIndex = 2;
      return re.exec("str") != null;
    });
    module.exports = {
      BROKEN_CARET,
      MISSED_STICKY,
      UNSUPPORTED_Y
    };
  }
});

// node_modules/core-js/internals/regexp-unsupported-dot-all.js
var require_regexp_unsupported_dot_all = __commonJS({
  "node_modules/core-js/internals/regexp-unsupported-dot-all.js"(exports, module) {
    var fails2 = require_fails();
    var global5 = require_global();
    var $RegExp = global5.RegExp;
    module.exports = fails2(function() {
      var re = $RegExp(".", "s");
      return !(re.dotAll && re.exec("\n") && re.flags === "s");
    });
  }
});

// node_modules/core-js/internals/regexp-unsupported-ncg.js
var require_regexp_unsupported_ncg = __commonJS({
  "node_modules/core-js/internals/regexp-unsupported-ncg.js"(exports, module) {
    var fails2 = require_fails();
    var global5 = require_global();
    var $RegExp = global5.RegExp;
    module.exports = fails2(function() {
      var re = $RegExp("(?<a>b)", "g");
      return re.exec("b").groups.a !== "b" || "b".replace(re, "$<a>c") !== "bc";
    });
  }
});

// node_modules/core-js/internals/regexp-exec.js
var require_regexp_exec = __commonJS({
  "node_modules/core-js/internals/regexp-exec.js"(exports, module) {
    "use strict";
    var call3 = require_function_call();
    var uncurryThis3 = require_function_uncurry_this();
    var toString6 = require_to_string();
    var regexpFlags = require_regexp_flags();
    var stickyHelpers = require_regexp_sticky_helpers();
    var shared = require_shared();
    var create3 = require_object_create();
    var getInternalState2 = require_internal_state().get;
    var UNSUPPORTED_DOT_ALL = require_regexp_unsupported_dot_all();
    var UNSUPPORTED_NCG = require_regexp_unsupported_ncg();
    var nativeReplace = shared("native-string-replace", String.prototype.replace);
    var nativeExec = RegExp.prototype.exec;
    var patchedExec = nativeExec;
    var charAt2 = uncurryThis3("".charAt);
    var indexOf = uncurryThis3("".indexOf);
    var replace2 = uncurryThis3("".replace);
    var stringSlice2 = uncurryThis3("".slice);
    var UPDATES_LAST_INDEX_WRONG = function() {
      var re1 = /a/;
      var re2 = /b*/g;
      call3(nativeExec, re1, "a");
      call3(nativeExec, re2, "a");
      return re1.lastIndex !== 0 || re2.lastIndex !== 0;
    }();
    var UNSUPPORTED_Y = stickyHelpers.BROKEN_CARET;
    var NPCG_INCLUDED = /()??/.exec("")[1] !== void 0;
    var PATCH = UPDATES_LAST_INDEX_WRONG || NPCG_INCLUDED || UNSUPPORTED_Y || UNSUPPORTED_DOT_ALL || UNSUPPORTED_NCG;
    if (PATCH) {
      patchedExec = function exec(string) {
        var re = this;
        var state = getInternalState2(re);
        var str = toString6(string);
        var raw = state.raw;
        var result2, reCopy, lastIndex, match, i3, object2, group2;
        if (raw) {
          raw.lastIndex = re.lastIndex;
          result2 = call3(patchedExec, raw, str);
          re.lastIndex = raw.lastIndex;
          return result2;
        }
        var groups = state.groups;
        var sticky = UNSUPPORTED_Y && re.sticky;
        var flags = call3(regexpFlags, re);
        var source = re.source;
        var charsAdded = 0;
        var strCopy = str;
        if (sticky) {
          flags = replace2(flags, "y", "");
          if (indexOf(flags, "g") === -1) {
            flags += "g";
          }
          strCopy = stringSlice2(str, re.lastIndex);
          if (re.lastIndex > 0 && (!re.multiline || re.multiline && charAt2(str, re.lastIndex - 1) !== "\n")) {
            source = "(?: " + source + ")";
            strCopy = " " + strCopy;
            charsAdded++;
          }
          reCopy = new RegExp("^(?:" + source + ")", flags);
        }
        if (NPCG_INCLUDED) {
          reCopy = new RegExp("^" + source + "$(?!\\s)", flags);
        }
        if (UPDATES_LAST_INDEX_WRONG) lastIndex = re.lastIndex;
        match = call3(nativeExec, sticky ? reCopy : re, strCopy);
        if (sticky) {
          if (match) {
            match.input = stringSlice2(match.input, charsAdded);
            match[0] = stringSlice2(match[0], charsAdded);
            match.index = re.lastIndex;
            re.lastIndex += match[0].length;
          } else re.lastIndex = 0;
        } else if (UPDATES_LAST_INDEX_WRONG && match) {
          re.lastIndex = re.global ? match.index + match[0].length : lastIndex;
        }
        if (NPCG_INCLUDED && match && match.length > 1) {
          call3(nativeReplace, match[0], reCopy, function() {
            for (i3 = 1; i3 < arguments.length - 2; i3++) {
              if (arguments[i3] === void 0) match[i3] = void 0;
            }
          });
        }
        if (match && groups) {
          match.groups = object2 = create3(null);
          for (i3 = 0; i3 < groups.length; i3++) {
            group2 = groups[i3];
            object2[group2[0]] = match[group2[1]];
          }
        }
        return match;
      };
    }
    module.exports = patchedExec;
  }
});

// node_modules/core-js/modules/es.regexp.exec.js
var require_es_regexp_exec = __commonJS({
  "node_modules/core-js/modules/es.regexp.exec.js"() {
    "use strict";
    var $6 = require_export();
    var exec = require_regexp_exec();
    $6({ target: "RegExp", proto: true, forced: /./.exec !== exec }, {
      exec
    });
  }
});

// node_modules/core-js/internals/fix-regexp-well-known-symbol-logic.js
var require_fix_regexp_well_known_symbol_logic = __commonJS({
  "node_modules/core-js/internals/fix-regexp-well-known-symbol-logic.js"(exports, module) {
    "use strict";
    require_es_regexp_exec();
    var uncurryThis3 = require_function_uncurry_this();
    var defineBuiltIn2 = require_define_built_in();
    var regexpExec = require_regexp_exec();
    var fails2 = require_fails();
    var wellKnownSymbol3 = require_well_known_symbol();
    var createNonEnumerableProperty3 = require_create_non_enumerable_property();
    var SPECIES = wellKnownSymbol3("species");
    var RegExpPrototype = RegExp.prototype;
    module.exports = function(KEY, exec, FORCED, SHAM) {
      var SYMBOL = wellKnownSymbol3(KEY);
      var DELEGATES_TO_SYMBOL = !fails2(function() {
        var O4 = {};
        O4[SYMBOL] = function() {
          return 7;
        };
        return ""[KEY](O4) != 7;
      });
      var DELEGATES_TO_EXEC = DELEGATES_TO_SYMBOL && !fails2(function() {
        var execCalled = false;
        var re = /a/;
        if (KEY === "split") {
          re = {};
          re.constructor = {};
          re.constructor[SPECIES] = function() {
            return re;
          };
          re.flags = "";
          re[SYMBOL] = /./[SYMBOL];
        }
        re.exec = function() {
          execCalled = true;
          return null;
        };
        re[SYMBOL]("");
        return !execCalled;
      });
      if (!DELEGATES_TO_SYMBOL || !DELEGATES_TO_EXEC || FORCED) {
        var uncurriedNativeRegExpMethod = uncurryThis3(/./[SYMBOL]);
        var methods = exec(SYMBOL, ""[KEY], function(nativeMethod, regexp, str, arg2, forceStringMethod) {
          var uncurriedNativeMethod = uncurryThis3(nativeMethod);
          var $exec = regexp.exec;
          if ($exec === regexpExec || $exec === RegExpPrototype.exec) {
            if (DELEGATES_TO_SYMBOL && !forceStringMethod) {
              return { done: true, value: uncurriedNativeRegExpMethod(regexp, str, arg2) };
            }
            return { done: true, value: uncurriedNativeMethod(str, regexp, arg2) };
          }
          return { done: false };
        });
        defineBuiltIn2(String.prototype, KEY, methods[0]);
        defineBuiltIn2(RegExpPrototype, SYMBOL, methods[1]);
      }
      if (SHAM) createNonEnumerableProperty3(RegExpPrototype[SYMBOL], "sham", true);
    };
  }
});

// node_modules/core-js/internals/advance-string-index.js
var require_advance_string_index = __commonJS({
  "node_modules/core-js/internals/advance-string-index.js"(exports, module) {
    "use strict";
    var charAt2 = require_string_multibyte().charAt;
    module.exports = function(S2, index, unicode) {
      return index + (unicode ? charAt2(S2, index).length : 1);
    };
  }
});

// node_modules/core-js/internals/regexp-exec-abstract.js
var require_regexp_exec_abstract = __commonJS({
  "node_modules/core-js/internals/regexp-exec-abstract.js"(exports, module) {
    var call3 = require_function_call();
    var anObject3 = require_an_object();
    var isCallable2 = require_is_callable();
    var classof = require_classof_raw();
    var regexpExec = require_regexp_exec();
    var $TypeError = TypeError;
    module.exports = function(R2, S2) {
      var exec = R2.exec;
      if (isCallable2(exec)) {
        var result2 = call3(exec, R2, S2);
        if (result2 !== null) anObject3(result2);
        return result2;
      }
      if (classof(R2) === "RegExp") return call3(regexpExec, R2, S2);
      throw $TypeError("RegExp#exec called on incompatible receiver");
    };
  }
});

// node_modules/core-js/internals/function-apply.js
var require_function_apply = __commonJS({
  "node_modules/core-js/internals/function-apply.js"(exports, module) {
    var NATIVE_BIND = require_function_bind_native();
    var FunctionPrototype2 = Function.prototype;
    var apply3 = FunctionPrototype2.apply;
    var call3 = FunctionPrototype2.call;
    module.exports = typeof Reflect == "object" && Reflect.apply || (NATIVE_BIND ? call3.bind(apply3) : function() {
      return call3.apply(apply3, arguments);
    });
  }
});

// node_modules/core-js/internals/get-substitution.js
var require_get_substitution = __commonJS({
  "node_modules/core-js/internals/get-substitution.js"(exports, module) {
    var uncurryThis3 = require_function_uncurry_this();
    var toObject = require_to_object();
    var floor = Math.floor;
    var charAt2 = uncurryThis3("".charAt);
    var replace2 = uncurryThis3("".replace);
    var stringSlice2 = uncurryThis3("".slice);
    var SUBSTITUTION_SYMBOLS = /\$([$&'`]|\d{1,2}|<[^>]*>)/g;
    var SUBSTITUTION_SYMBOLS_NO_NAMED = /\$([$&'`]|\d{1,2})/g;
    module.exports = function(matched, str, position, captures, namedCaptures, replacement) {
      var tailPos = position + matched.length;
      var m3 = captures.length;
      var symbols = SUBSTITUTION_SYMBOLS_NO_NAMED;
      if (namedCaptures !== void 0) {
        namedCaptures = toObject(namedCaptures);
        symbols = SUBSTITUTION_SYMBOLS;
      }
      return replace2(replacement, symbols, function(match, ch) {
        var capture;
        switch (charAt2(ch, 0)) {
          case "$":
            return "$";
          case "&":
            return matched;
          case "`":
            return stringSlice2(str, 0, position);
          case "'":
            return stringSlice2(str, tailPos);
          case "<":
            capture = namedCaptures[stringSlice2(ch, 1, -1)];
            break;
          default:
            var n4 = +ch;
            if (n4 === 0) return match;
            if (n4 > m3) {
              var f3 = floor(n4 / 10);
              if (f3 === 0) return match;
              if (f3 <= m3) return captures[f3 - 1] === void 0 ? charAt2(ch, 1) : captures[f3 - 1] + charAt2(ch, 1);
              return match;
            }
            capture = captures[n4 - 1];
        }
        return capture === void 0 ? "" : capture;
      });
    };
  }
});

// node_modules/dompurify/dist/purify.js
var require_purify = __commonJS({
  "node_modules/dompurify/dist/purify.js"(exports, module) {
    (function(global5, factory) {
      typeof exports === "object" && typeof module !== "undefined" ? module.exports = factory() : typeof define === "function" && define.amd ? define(factory) : (global5 = typeof globalThis !== "undefined" ? globalThis : global5 || self, global5.DOMPurify = factory());
    })(exports, function() {
      "use strict";
      function _typeof(obj) {
        "@babel/helpers - typeof";
        return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function(obj2) {
          return typeof obj2;
        } : function(obj2) {
          return obj2 && "function" == typeof Symbol && obj2.constructor === Symbol && obj2 !== Symbol.prototype ? "symbol" : typeof obj2;
        }, _typeof(obj);
      }
      function _setPrototypeOf(o3, p3) {
        _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf2(o4, p4) {
          o4.__proto__ = p4;
          return o4;
        };
        return _setPrototypeOf(o3, p3);
      }
      function _isNativeReflectConstruct() {
        if (typeof Reflect === "undefined" || !Reflect.construct) return false;
        if (Reflect.construct.sham) return false;
        if (typeof Proxy === "function") return true;
        try {
          Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function() {
          }));
          return true;
        } catch (e3) {
          return false;
        }
      }
      function _construct(Parent, args, Class) {
        if (_isNativeReflectConstruct()) {
          _construct = Reflect.construct;
        } else {
          _construct = function _construct2(Parent2, args2, Class2) {
            var a3 = [null];
            a3.push.apply(a3, args2);
            var Constructor = Function.bind.apply(Parent2, a3);
            var instance = new Constructor();
            if (Class2) _setPrototypeOf(instance, Class2.prototype);
            return instance;
          };
        }
        return _construct.apply(null, arguments);
      }
      function _toConsumableArray(arr) {
        return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread();
      }
      function _arrayWithoutHoles(arr) {
        if (Array.isArray(arr)) return _arrayLikeToArray(arr);
      }
      function _iterableToArray(iter) {
        if (typeof Symbol !== "undefined" && iter[Symbol.iterator] != null || iter["@@iterator"] != null) return Array.from(iter);
      }
      function _unsupportedIterableToArray(o3, minLen) {
        if (!o3) return;
        if (typeof o3 === "string") return _arrayLikeToArray(o3, minLen);
        var n4 = Object.prototype.toString.call(o3).slice(8, -1);
        if (n4 === "Object" && o3.constructor) n4 = o3.constructor.name;
        if (n4 === "Map" || n4 === "Set") return Array.from(o3);
        if (n4 === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n4)) return _arrayLikeToArray(o3, minLen);
      }
      function _arrayLikeToArray(arr, len) {
        if (len == null || len > arr.length) len = arr.length;
        for (var i3 = 0, arr2 = new Array(len); i3 < len; i3++) arr2[i3] = arr[i3];
        return arr2;
      }
      function _nonIterableSpread() {
        throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
      }
      var hasOwnProperty2 = Object.hasOwnProperty, setPrototypeOf = Object.setPrototypeOf, isFrozen = Object.isFrozen, getPrototypeOf = Object.getPrototypeOf, getOwnPropertyDescriptor = Object.getOwnPropertyDescriptor;
      var freeze2 = Object.freeze, seal = Object.seal, create3 = Object.create;
      var _ref = typeof Reflect !== "undefined" && Reflect, apply3 = _ref.apply, construct = _ref.construct;
      if (!apply3) {
        apply3 = function apply4(fun, thisValue, args) {
          return fun.apply(thisValue, args);
        };
      }
      if (!freeze2) {
        freeze2 = function freeze3(x3) {
          return x3;
        };
      }
      if (!seal) {
        seal = function seal2(x3) {
          return x3;
        };
      }
      if (!construct) {
        construct = function construct2(Func, args) {
          return _construct(Func, _toConsumableArray(args));
        };
      }
      var arrayForEach = unapply(Array.prototype.forEach);
      var arrayPop = unapply(Array.prototype.pop);
      var arrayPush = unapply(Array.prototype.push);
      var stringToLowerCase = unapply(String.prototype.toLowerCase);
      var stringToString = unapply(String.prototype.toString);
      var stringMatch = unapply(String.prototype.match);
      var stringReplace = unapply(String.prototype.replace);
      var stringIndexOf2 = unapply(String.prototype.indexOf);
      var stringTrim = unapply(String.prototype.trim);
      var regExpTest = unapply(RegExp.prototype.test);
      var typeErrorCreate = unconstruct(TypeError);
      function unapply(func) {
        return function(thisArg) {
          for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
            args[_key - 1] = arguments[_key];
          }
          return apply3(func, thisArg, args);
        };
      }
      function unconstruct(func) {
        return function() {
          for (var _len2 = arguments.length, args = new Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
            args[_key2] = arguments[_key2];
          }
          return construct(func, args);
        };
      }
      function addToSet(set, array, transformCaseFunc) {
        transformCaseFunc = transformCaseFunc ? transformCaseFunc : stringToLowerCase;
        if (setPrototypeOf) {
          setPrototypeOf(set, null);
        }
        var l3 = array.length;
        while (l3--) {
          var element = array[l3];
          if (typeof element === "string") {
            var lcElement = transformCaseFunc(element);
            if (lcElement !== element) {
              if (!isFrozen(array)) {
                array[l3] = lcElement;
              }
              element = lcElement;
            }
          }
          set[element] = true;
        }
        return set;
      }
      function clone2(object2) {
        var newObject = create3(null);
        var property2;
        for (property2 in object2) {
          if (apply3(hasOwnProperty2, object2, [property2]) === true) {
            newObject[property2] = object2[property2];
          }
        }
        return newObject;
      }
      function lookupGetter(object2, prop2) {
        while (object2 !== null) {
          var desc = getOwnPropertyDescriptor(object2, prop2);
          if (desc) {
            if (desc.get) {
              return unapply(desc.get);
            }
            if (typeof desc.value === "function") {
              return unapply(desc.value);
            }
          }
          object2 = getPrototypeOf(object2);
        }
        function fallbackValue(element) {
          console.warn("fallback value for", element);
          return null;
        }
        return fallbackValue;
      }
      var html$1 = freeze2(["a", "abbr", "acronym", "address", "area", "article", "aside", "audio", "b", "bdi", "bdo", "big", "blink", "blockquote", "body", "br", "button", "canvas", "caption", "center", "cite", "code", "col", "colgroup", "content", "data", "datalist", "dd", "decorator", "del", "details", "dfn", "dialog", "dir", "div", "dl", "dt", "element", "em", "fieldset", "figcaption", "figure", "font", "footer", "form", "h1", "h2", "h3", "h4", "h5", "h6", "head", "header", "hgroup", "hr", "html", "i", "img", "input", "ins", "kbd", "label", "legend", "li", "main", "map", "mark", "marquee", "menu", "menuitem", "meter", "nav", "nobr", "ol", "optgroup", "option", "output", "p", "picture", "pre", "progress", "q", "rp", "rt", "ruby", "s", "samp", "section", "select", "shadow", "small", "source", "spacer", "span", "strike", "strong", "style", "sub", "summary", "sup", "table", "tbody", "td", "template", "textarea", "tfoot", "th", "thead", "time", "tr", "track", "tt", "u", "ul", "var", "video", "wbr"]);
      var svg$1 = freeze2(["svg", "a", "altglyph", "altglyphdef", "altglyphitem", "animatecolor", "animatemotion", "animatetransform", "circle", "clippath", "defs", "desc", "ellipse", "filter", "font", "g", "glyph", "glyphref", "hkern", "image", "line", "lineargradient", "marker", "mask", "metadata", "mpath", "path", "pattern", "polygon", "polyline", "radialgradient", "rect", "stop", "style", "switch", "symbol", "text", "textpath", "title", "tref", "tspan", "view", "vkern"]);
      var svgFilters = freeze2(["feBlend", "feColorMatrix", "feComponentTransfer", "feComposite", "feConvolveMatrix", "feDiffuseLighting", "feDisplacementMap", "feDistantLight", "feFlood", "feFuncA", "feFuncB", "feFuncG", "feFuncR", "feGaussianBlur", "feImage", "feMerge", "feMergeNode", "feMorphology", "feOffset", "fePointLight", "feSpecularLighting", "feSpotLight", "feTile", "feTurbulence"]);
      var svgDisallowed = freeze2(["animate", "color-profile", "cursor", "discard", "fedropshadow", "font-face", "font-face-format", "font-face-name", "font-face-src", "font-face-uri", "foreignobject", "hatch", "hatchpath", "mesh", "meshgradient", "meshpatch", "meshrow", "missing-glyph", "script", "set", "solidcolor", "unknown", "use"]);
      var mathMl$1 = freeze2(["math", "menclose", "merror", "mfenced", "mfrac", "mglyph", "mi", "mlabeledtr", "mmultiscripts", "mn", "mo", "mover", "mpadded", "mphantom", "mroot", "mrow", "ms", "mspace", "msqrt", "mstyle", "msub", "msup", "msubsup", "mtable", "mtd", "mtext", "mtr", "munder", "munderover"]);
      var mathMlDisallowed = freeze2(["maction", "maligngroup", "malignmark", "mlongdiv", "mscarries", "mscarry", "msgroup", "mstack", "msline", "msrow", "semantics", "annotation", "annotation-xml", "mprescripts", "none"]);
      var text = freeze2(["#text"]);
      var html = freeze2(["accept", "action", "align", "alt", "autocapitalize", "autocomplete", "autopictureinpicture", "autoplay", "background", "bgcolor", "border", "capture", "cellpadding", "cellspacing", "checked", "cite", "class", "clear", "color", "cols", "colspan", "controls", "controlslist", "coords", "crossorigin", "datetime", "decoding", "default", "dir", "disabled", "disablepictureinpicture", "disableremoteplayback", "download", "draggable", "enctype", "enterkeyhint", "face", "for", "headers", "height", "hidden", "high", "href", "hreflang", "id", "inputmode", "integrity", "ismap", "kind", "label", "lang", "list", "loading", "loop", "low", "max", "maxlength", "media", "method", "min", "minlength", "multiple", "muted", "name", "nonce", "noshade", "novalidate", "nowrap", "open", "optimum", "pattern", "placeholder", "playsinline", "poster", "preload", "pubdate", "radiogroup", "readonly", "rel", "required", "rev", "reversed", "role", "rows", "rowspan", "spellcheck", "scope", "selected", "shape", "size", "sizes", "span", "srclang", "start", "src", "srcset", "step", "style", "summary", "tabindex", "title", "translate", "type", "usemap", "valign", "value", "width", "xmlns", "slot"]);
      var svg = freeze2(["accent-height", "accumulate", "additive", "alignment-baseline", "ascent", "attributename", "attributetype", "azimuth", "basefrequency", "baseline-shift", "begin", "bias", "by", "class", "clip", "clippathunits", "clip-path", "clip-rule", "color", "color-interpolation", "color-interpolation-filters", "color-profile", "color-rendering", "cx", "cy", "d", "dx", "dy", "diffuseconstant", "direction", "display", "divisor", "dur", "edgemode", "elevation", "end", "fill", "fill-opacity", "fill-rule", "filter", "filterunits", "flood-color", "flood-opacity", "font-family", "font-size", "font-size-adjust", "font-stretch", "font-style", "font-variant", "font-weight", "fx", "fy", "g1", "g2", "glyph-name", "glyphref", "gradientunits", "gradienttransform", "height", "href", "id", "image-rendering", "in", "in2", "k", "k1", "k2", "k3", "k4", "kerning", "keypoints", "keysplines", "keytimes", "lang", "lengthadjust", "letter-spacing", "kernelmatrix", "kernelunitlength", "lighting-color", "local", "marker-end", "marker-mid", "marker-start", "markerheight", "markerunits", "markerwidth", "maskcontentunits", "maskunits", "max", "mask", "media", "method", "mode", "min", "name", "numoctaves", "offset", "operator", "opacity", "order", "orient", "orientation", "origin", "overflow", "paint-order", "path", "pathlength", "patterncontentunits", "patterntransform", "patternunits", "points", "preservealpha", "preserveaspectratio", "primitiveunits", "r", "rx", "ry", "radius", "refx", "refy", "repeatcount", "repeatdur", "restart", "result", "rotate", "scale", "seed", "shape-rendering", "specularconstant", "specularexponent", "spreadmethod", "startoffset", "stddeviation", "stitchtiles", "stop-color", "stop-opacity", "stroke-dasharray", "stroke-dashoffset", "stroke-linecap", "stroke-linejoin", "stroke-miterlimit", "stroke-opacity", "stroke", "stroke-width", "style", "surfacescale", "systemlanguage", "tabindex", "targetx", "targety", "transform", "transform-origin", "text-anchor", "text-decoration", "text-rendering", "textlength", "type", "u1", "u2", "unicode", "values", "viewbox", "visibility", "version", "vert-adv-y", "vert-origin-x", "vert-origin-y", "width", "word-spacing", "wrap", "writing-mode", "xchannelselector", "ychannelselector", "x", "x1", "x2", "xmlns", "y", "y1", "y2", "z", "zoomandpan"]);
      var mathMl = freeze2(["accent", "accentunder", "align", "bevelled", "close", "columnsalign", "columnlines", "columnspan", "denomalign", "depth", "dir", "display", "displaystyle", "encoding", "fence", "frame", "height", "href", "id", "largeop", "length", "linethickness", "lspace", "lquote", "mathbackground", "mathcolor", "mathsize", "mathvariant", "maxsize", "minsize", "movablelimits", "notation", "numalign", "open", "rowalign", "rowlines", "rowspacing", "rowspan", "rspace", "rquote", "scriptlevel", "scriptminsize", "scriptsizemultiplier", "selection", "separator", "separators", "stretchy", "subscriptshift", "supscriptshift", "symmetric", "voffset", "width", "xmlns"]);
      var xml = freeze2(["xlink:href", "xml:id", "xlink:title", "xml:space", "xmlns:xlink"]);
      var MUSTACHE_EXPR = seal(/\{\{[\w\W]*|[\w\W]*\}\}/gm);
      var ERB_EXPR = seal(/<%[\w\W]*|[\w\W]*%>/gm);
      var TMPLIT_EXPR = seal(/\${[\w\W]*}/gm);
      var DATA_ATTR = seal(/^data-[\-\w.\u00B7-\uFFFF]/);
      var ARIA_ATTR = seal(/^aria-[\-\w]+$/);
      var IS_ALLOWED_URI = seal(
        /^(?:(?:(?:f|ht)tps?|mailto|tel|callto|cid|xmpp):|[^a-z]|[a-z+.\-]+(?:[^a-z+.\-:]|$))/i
        // eslint-disable-line no-useless-escape
      );
      var IS_SCRIPT_OR_DATA = seal(/^(?:\w+script|data):/i);
      var ATTR_WHITESPACE = seal(
        /[\u0000-\u0020\u00A0\u1680\u180E\u2000-\u2029\u205F\u3000]/g
        // eslint-disable-line no-control-regex
      );
      var DOCTYPE_NAME = seal(/^html$/i);
      var getGlobal = function getGlobal2() {
        return typeof window === "undefined" ? null : window;
      };
      var _createTrustedTypesPolicy = function _createTrustedTypesPolicy2(trustedTypes, document2) {
        if (_typeof(trustedTypes) !== "object" || typeof trustedTypes.createPolicy !== "function") {
          return null;
        }
        var suffix = null;
        var ATTR_NAME = "data-tt-policy-suffix";
        if (document2.currentScript && document2.currentScript.hasAttribute(ATTR_NAME)) {
          suffix = document2.currentScript.getAttribute(ATTR_NAME);
        }
        var policyName = "dompurify" + (suffix ? "#" + suffix : "");
        try {
          return trustedTypes.createPolicy(policyName, {
            createHTML: function createHTML(html2) {
              return html2;
            },
            createScriptURL: function createScriptURL(scriptUrl) {
              return scriptUrl;
            }
          });
        } catch (_6) {
          console.warn("TrustedTypes policy " + policyName + " could not be created.");
          return null;
        }
      };
      function createDOMPurify() {
        var window2 = arguments.length > 0 && arguments[0] !== void 0 ? arguments[0] : getGlobal();
        var DOMPurify2 = function DOMPurify3(root2) {
          return createDOMPurify(root2);
        };
        DOMPurify2.version = "2.4.3";
        DOMPurify2.removed = [];
        if (!window2 || !window2.document || window2.document.nodeType !== 9) {
          DOMPurify2.isSupported = false;
          return DOMPurify2;
        }
        var originalDocument = window2.document;
        var document2 = window2.document;
        var DocumentFragment2 = window2.DocumentFragment, HTMLTemplateElement = window2.HTMLTemplateElement, Node3 = window2.Node, Element2 = window2.Element, NodeFilter = window2.NodeFilter, _window$NamedNodeMap = window2.NamedNodeMap, NamedNodeMap = _window$NamedNodeMap === void 0 ? window2.NamedNodeMap || window2.MozNamedAttrMap : _window$NamedNodeMap, HTMLFormElement = window2.HTMLFormElement, DOMParser2 = window2.DOMParser, trustedTypes = window2.trustedTypes;
        var ElementPrototype = Element2.prototype;
        var cloneNode = lookupGetter(ElementPrototype, "cloneNode");
        var getNextSibling = lookupGetter(ElementPrototype, "nextSibling");
        var getChildNodes = lookupGetter(ElementPrototype, "childNodes");
        var getParentNode = lookupGetter(ElementPrototype, "parentNode");
        if (typeof HTMLTemplateElement === "function") {
          var template3 = document2.createElement("template");
          if (template3.content && template3.content.ownerDocument) {
            document2 = template3.content.ownerDocument;
          }
        }
        var trustedTypesPolicy = _createTrustedTypesPolicy(trustedTypes, originalDocument);
        var emptyHTML = trustedTypesPolicy ? trustedTypesPolicy.createHTML("") : "";
        var _document = document2, implementation = _document.implementation, createNodeIterator = _document.createNodeIterator, createDocumentFragment = _document.createDocumentFragment, getElementsByTagName = _document.getElementsByTagName;
        var importNode = originalDocument.importNode;
        var documentMode = {};
        try {
          documentMode = clone2(document2).documentMode ? document2.documentMode : {};
        } catch (_6) {
        }
        var hooks = {};
        DOMPurify2.isSupported = typeof getParentNode === "function" && implementation && typeof implementation.createHTMLDocument !== "undefined" && documentMode !== 9;
        var MUSTACHE_EXPR$1 = MUSTACHE_EXPR, ERB_EXPR$1 = ERB_EXPR, TMPLIT_EXPR$1 = TMPLIT_EXPR, DATA_ATTR$1 = DATA_ATTR, ARIA_ATTR$1 = ARIA_ATTR, IS_SCRIPT_OR_DATA$1 = IS_SCRIPT_OR_DATA, ATTR_WHITESPACE$1 = ATTR_WHITESPACE;
        var IS_ALLOWED_URI$1 = IS_ALLOWED_URI;
        var ALLOWED_TAGS = null;
        var DEFAULT_ALLOWED_TAGS = addToSet({}, [].concat(_toConsumableArray(html$1), _toConsumableArray(svg$1), _toConsumableArray(svgFilters), _toConsumableArray(mathMl$1), _toConsumableArray(text)));
        var ALLOWED_ATTR = null;
        var DEFAULT_ALLOWED_ATTR = addToSet({}, [].concat(_toConsumableArray(html), _toConsumableArray(svg), _toConsumableArray(mathMl), _toConsumableArray(xml)));
        var CUSTOM_ELEMENT_HANDLING = Object.seal(Object.create(null, {
          tagNameCheck: {
            writable: true,
            configurable: false,
            enumerable: true,
            value: null
          },
          attributeNameCheck: {
            writable: true,
            configurable: false,
            enumerable: true,
            value: null
          },
          allowCustomizedBuiltInElements: {
            writable: true,
            configurable: false,
            enumerable: true,
            value: false
          }
        }));
        var FORBID_TAGS = null;
        var FORBID_ATTR = null;
        var ALLOW_ARIA_ATTR = true;
        var ALLOW_DATA_ATTR = true;
        var ALLOW_UNKNOWN_PROTOCOLS = false;
        var SAFE_FOR_TEMPLATES = false;
        var WHOLE_DOCUMENT = false;
        var SET_CONFIG = false;
        var FORCE_BODY = false;
        var RETURN_DOM = false;
        var RETURN_DOM_FRAGMENT = false;
        var RETURN_TRUSTED_TYPE = false;
        var SANITIZE_DOM = true;
        var SANITIZE_NAMED_PROPS = false;
        var SANITIZE_NAMED_PROPS_PREFIX = "user-content-";
        var KEEP_CONTENT = true;
        var IN_PLACE = false;
        var USE_PROFILES = {};
        var FORBID_CONTENTS = null;
        var DEFAULT_FORBID_CONTENTS = addToSet({}, ["annotation-xml", "audio", "colgroup", "desc", "foreignobject", "head", "iframe", "math", "mi", "mn", "mo", "ms", "mtext", "noembed", "noframes", "noscript", "plaintext", "script", "style", "svg", "template", "thead", "title", "video", "xmp"]);
        var DATA_URI_TAGS = null;
        var DEFAULT_DATA_URI_TAGS = addToSet({}, ["audio", "video", "img", "source", "image", "track"]);
        var URI_SAFE_ATTRIBUTES = null;
        var DEFAULT_URI_SAFE_ATTRIBUTES = addToSet({}, ["alt", "class", "for", "id", "label", "name", "pattern", "placeholder", "role", "summary", "title", "value", "style", "xmlns"]);
        var MATHML_NAMESPACE = "http://www.w3.org/1998/Math/MathML";
        var SVG_NAMESPACE2 = "http://www.w3.org/2000/svg";
        var HTML_NAMESPACE = "http://www.w3.org/1999/xhtml";
        var NAMESPACE = HTML_NAMESPACE;
        var IS_EMPTY_INPUT = false;
        var ALLOWED_NAMESPACES = null;
        var DEFAULT_ALLOWED_NAMESPACES = addToSet({}, [MATHML_NAMESPACE, SVG_NAMESPACE2, HTML_NAMESPACE], stringToString);
        var PARSER_MEDIA_TYPE;
        var SUPPORTED_PARSER_MEDIA_TYPES = ["application/xhtml+xml", "text/html"];
        var DEFAULT_PARSER_MEDIA_TYPE = "text/html";
        var transformCaseFunc;
        var CONFIG = null;
        var formElement = document2.createElement("form");
        var isRegexOrFunction = function isRegexOrFunction2(testValue) {
          return testValue instanceof RegExp || testValue instanceof Function;
        };
        var _parseConfig = function _parseConfig2(cfg) {
          if (CONFIG && CONFIG === cfg) {
            return;
          }
          if (!cfg || _typeof(cfg) !== "object") {
            cfg = {};
          }
          cfg = clone2(cfg);
          PARSER_MEDIA_TYPE = // eslint-disable-next-line unicorn/prefer-includes
          SUPPORTED_PARSER_MEDIA_TYPES.indexOf(cfg.PARSER_MEDIA_TYPE) === -1 ? PARSER_MEDIA_TYPE = DEFAULT_PARSER_MEDIA_TYPE : PARSER_MEDIA_TYPE = cfg.PARSER_MEDIA_TYPE;
          transformCaseFunc = PARSER_MEDIA_TYPE === "application/xhtml+xml" ? stringToString : stringToLowerCase;
          ALLOWED_TAGS = "ALLOWED_TAGS" in cfg ? addToSet({}, cfg.ALLOWED_TAGS, transformCaseFunc) : DEFAULT_ALLOWED_TAGS;
          ALLOWED_ATTR = "ALLOWED_ATTR" in cfg ? addToSet({}, cfg.ALLOWED_ATTR, transformCaseFunc) : DEFAULT_ALLOWED_ATTR;
          ALLOWED_NAMESPACES = "ALLOWED_NAMESPACES" in cfg ? addToSet({}, cfg.ALLOWED_NAMESPACES, stringToString) : DEFAULT_ALLOWED_NAMESPACES;
          URI_SAFE_ATTRIBUTES = "ADD_URI_SAFE_ATTR" in cfg ? addToSet(
            clone2(DEFAULT_URI_SAFE_ATTRIBUTES),
            // eslint-disable-line indent
            cfg.ADD_URI_SAFE_ATTR,
            // eslint-disable-line indent
            transformCaseFunc
            // eslint-disable-line indent
          ) : DEFAULT_URI_SAFE_ATTRIBUTES;
          DATA_URI_TAGS = "ADD_DATA_URI_TAGS" in cfg ? addToSet(
            clone2(DEFAULT_DATA_URI_TAGS),
            // eslint-disable-line indent
            cfg.ADD_DATA_URI_TAGS,
            // eslint-disable-line indent
            transformCaseFunc
            // eslint-disable-line indent
          ) : DEFAULT_DATA_URI_TAGS;
          FORBID_CONTENTS = "FORBID_CONTENTS" in cfg ? addToSet({}, cfg.FORBID_CONTENTS, transformCaseFunc) : DEFAULT_FORBID_CONTENTS;
          FORBID_TAGS = "FORBID_TAGS" in cfg ? addToSet({}, cfg.FORBID_TAGS, transformCaseFunc) : {};
          FORBID_ATTR = "FORBID_ATTR" in cfg ? addToSet({}, cfg.FORBID_ATTR, transformCaseFunc) : {};
          USE_PROFILES = "USE_PROFILES" in cfg ? cfg.USE_PROFILES : false;
          ALLOW_ARIA_ATTR = cfg.ALLOW_ARIA_ATTR !== false;
          ALLOW_DATA_ATTR = cfg.ALLOW_DATA_ATTR !== false;
          ALLOW_UNKNOWN_PROTOCOLS = cfg.ALLOW_UNKNOWN_PROTOCOLS || false;
          SAFE_FOR_TEMPLATES = cfg.SAFE_FOR_TEMPLATES || false;
          WHOLE_DOCUMENT = cfg.WHOLE_DOCUMENT || false;
          RETURN_DOM = cfg.RETURN_DOM || false;
          RETURN_DOM_FRAGMENT = cfg.RETURN_DOM_FRAGMENT || false;
          RETURN_TRUSTED_TYPE = cfg.RETURN_TRUSTED_TYPE || false;
          FORCE_BODY = cfg.FORCE_BODY || false;
          SANITIZE_DOM = cfg.SANITIZE_DOM !== false;
          SANITIZE_NAMED_PROPS = cfg.SANITIZE_NAMED_PROPS || false;
          KEEP_CONTENT = cfg.KEEP_CONTENT !== false;
          IN_PLACE = cfg.IN_PLACE || false;
          IS_ALLOWED_URI$1 = cfg.ALLOWED_URI_REGEXP || IS_ALLOWED_URI$1;
          NAMESPACE = cfg.NAMESPACE || HTML_NAMESPACE;
          if (cfg.CUSTOM_ELEMENT_HANDLING && isRegexOrFunction(cfg.CUSTOM_ELEMENT_HANDLING.tagNameCheck)) {
            CUSTOM_ELEMENT_HANDLING.tagNameCheck = cfg.CUSTOM_ELEMENT_HANDLING.tagNameCheck;
          }
          if (cfg.CUSTOM_ELEMENT_HANDLING && isRegexOrFunction(cfg.CUSTOM_ELEMENT_HANDLING.attributeNameCheck)) {
            CUSTOM_ELEMENT_HANDLING.attributeNameCheck = cfg.CUSTOM_ELEMENT_HANDLING.attributeNameCheck;
          }
          if (cfg.CUSTOM_ELEMENT_HANDLING && typeof cfg.CUSTOM_ELEMENT_HANDLING.allowCustomizedBuiltInElements === "boolean") {
            CUSTOM_ELEMENT_HANDLING.allowCustomizedBuiltInElements = cfg.CUSTOM_ELEMENT_HANDLING.allowCustomizedBuiltInElements;
          }
          if (SAFE_FOR_TEMPLATES) {
            ALLOW_DATA_ATTR = false;
          }
          if (RETURN_DOM_FRAGMENT) {
            RETURN_DOM = true;
          }
          if (USE_PROFILES) {
            ALLOWED_TAGS = addToSet({}, _toConsumableArray(text));
            ALLOWED_ATTR = [];
            if (USE_PROFILES.html === true) {
              addToSet(ALLOWED_TAGS, html$1);
              addToSet(ALLOWED_ATTR, html);
            }
            if (USE_PROFILES.svg === true) {
              addToSet(ALLOWED_TAGS, svg$1);
              addToSet(ALLOWED_ATTR, svg);
              addToSet(ALLOWED_ATTR, xml);
            }
            if (USE_PROFILES.svgFilters === true) {
              addToSet(ALLOWED_TAGS, svgFilters);
              addToSet(ALLOWED_ATTR, svg);
              addToSet(ALLOWED_ATTR, xml);
            }
            if (USE_PROFILES.mathMl === true) {
              addToSet(ALLOWED_TAGS, mathMl$1);
              addToSet(ALLOWED_ATTR, mathMl);
              addToSet(ALLOWED_ATTR, xml);
            }
          }
          if (cfg.ADD_TAGS) {
            if (ALLOWED_TAGS === DEFAULT_ALLOWED_TAGS) {
              ALLOWED_TAGS = clone2(ALLOWED_TAGS);
            }
            addToSet(ALLOWED_TAGS, cfg.ADD_TAGS, transformCaseFunc);
          }
          if (cfg.ADD_ATTR) {
            if (ALLOWED_ATTR === DEFAULT_ALLOWED_ATTR) {
              ALLOWED_ATTR = clone2(ALLOWED_ATTR);
            }
            addToSet(ALLOWED_ATTR, cfg.ADD_ATTR, transformCaseFunc);
          }
          if (cfg.ADD_URI_SAFE_ATTR) {
            addToSet(URI_SAFE_ATTRIBUTES, cfg.ADD_URI_SAFE_ATTR, transformCaseFunc);
          }
          if (cfg.FORBID_CONTENTS) {
            if (FORBID_CONTENTS === DEFAULT_FORBID_CONTENTS) {
              FORBID_CONTENTS = clone2(FORBID_CONTENTS);
            }
            addToSet(FORBID_CONTENTS, cfg.FORBID_CONTENTS, transformCaseFunc);
          }
          if (KEEP_CONTENT) {
            ALLOWED_TAGS["#text"] = true;
          }
          if (WHOLE_DOCUMENT) {
            addToSet(ALLOWED_TAGS, ["html", "head", "body"]);
          }
          if (ALLOWED_TAGS.table) {
            addToSet(ALLOWED_TAGS, ["tbody"]);
            delete FORBID_TAGS.tbody;
          }
          if (freeze2) {
            freeze2(cfg);
          }
          CONFIG = cfg;
        };
        var MATHML_TEXT_INTEGRATION_POINTS = addToSet({}, ["mi", "mo", "mn", "ms", "mtext"]);
        var HTML_INTEGRATION_POINTS = addToSet({}, ["foreignobject", "desc", "title", "annotation-xml"]);
        var COMMON_SVG_AND_HTML_ELEMENTS = addToSet({}, ["title", "style", "font", "a", "script"]);
        var ALL_SVG_TAGS = addToSet({}, svg$1);
        addToSet(ALL_SVG_TAGS, svgFilters);
        addToSet(ALL_SVG_TAGS, svgDisallowed);
        var ALL_MATHML_TAGS = addToSet({}, mathMl$1);
        addToSet(ALL_MATHML_TAGS, mathMlDisallowed);
        var _checkValidNamespace = function _checkValidNamespace2(element) {
          var parent = getParentNode(element);
          if (!parent || !parent.tagName) {
            parent = {
              namespaceURI: NAMESPACE,
              tagName: "template"
            };
          }
          var tagName = stringToLowerCase(element.tagName);
          var parentTagName = stringToLowerCase(parent.tagName);
          if (!ALLOWED_NAMESPACES[element.namespaceURI]) {
            return false;
          }
          if (element.namespaceURI === SVG_NAMESPACE2) {
            if (parent.namespaceURI === HTML_NAMESPACE) {
              return tagName === "svg";
            }
            if (parent.namespaceURI === MATHML_NAMESPACE) {
              return tagName === "svg" && (parentTagName === "annotation-xml" || MATHML_TEXT_INTEGRATION_POINTS[parentTagName]);
            }
            return Boolean(ALL_SVG_TAGS[tagName]);
          }
          if (element.namespaceURI === MATHML_NAMESPACE) {
            if (parent.namespaceURI === HTML_NAMESPACE) {
              return tagName === "math";
            }
            if (parent.namespaceURI === SVG_NAMESPACE2) {
              return tagName === "math" && HTML_INTEGRATION_POINTS[parentTagName];
            }
            return Boolean(ALL_MATHML_TAGS[tagName]);
          }
          if (element.namespaceURI === HTML_NAMESPACE) {
            if (parent.namespaceURI === SVG_NAMESPACE2 && !HTML_INTEGRATION_POINTS[parentTagName]) {
              return false;
            }
            if (parent.namespaceURI === MATHML_NAMESPACE && !MATHML_TEXT_INTEGRATION_POINTS[parentTagName]) {
              return false;
            }
            return !ALL_MATHML_TAGS[tagName] && (COMMON_SVG_AND_HTML_ELEMENTS[tagName] || !ALL_SVG_TAGS[tagName]);
          }
          if (PARSER_MEDIA_TYPE === "application/xhtml+xml" && ALLOWED_NAMESPACES[element.namespaceURI]) {
            return true;
          }
          return false;
        };
        var _forceRemove = function _forceRemove2(node) {
          arrayPush(DOMPurify2.removed, {
            element: node
          });
          try {
            node.parentNode.removeChild(node);
          } catch (_6) {
            try {
              node.outerHTML = emptyHTML;
            } catch (_7) {
              node.remove();
            }
          }
        };
        var _removeAttribute = function _removeAttribute2(name, node) {
          try {
            arrayPush(DOMPurify2.removed, {
              attribute: node.getAttributeNode(name),
              from: node
            });
          } catch (_6) {
            arrayPush(DOMPurify2.removed, {
              attribute: null,
              from: node
            });
          }
          node.removeAttribute(name);
          if (name === "is" && !ALLOWED_ATTR[name]) {
            if (RETURN_DOM || RETURN_DOM_FRAGMENT) {
              try {
                _forceRemove(node);
              } catch (_6) {
              }
            } else {
              try {
                node.setAttribute(name, "");
              } catch (_6) {
              }
            }
          }
        };
        var _initDocument = function _initDocument2(dirty) {
          var doc3;
          var leadingWhitespace;
          if (FORCE_BODY) {
            dirty = "<remove></remove>" + dirty;
          } else {
            var matches2 = stringMatch(dirty, /^[\r\n\t ]+/);
            leadingWhitespace = matches2 && matches2[0];
          }
          if (PARSER_MEDIA_TYPE === "application/xhtml+xml" && NAMESPACE === HTML_NAMESPACE) {
            dirty = '<html xmlns="http://www.w3.org/1999/xhtml"><head></head><body>' + dirty + "</body></html>";
          }
          var dirtyPayload = trustedTypesPolicy ? trustedTypesPolicy.createHTML(dirty) : dirty;
          if (NAMESPACE === HTML_NAMESPACE) {
            try {
              doc3 = new DOMParser2().parseFromString(dirtyPayload, PARSER_MEDIA_TYPE);
            } catch (_6) {
            }
          }
          if (!doc3 || !doc3.documentElement) {
            doc3 = implementation.createDocument(NAMESPACE, "template", null);
            try {
              doc3.documentElement.innerHTML = IS_EMPTY_INPUT ? emptyHTML : dirtyPayload;
            } catch (_6) {
            }
          }
          var body = doc3.body || doc3.documentElement;
          if (dirty && leadingWhitespace) {
            body.insertBefore(document2.createTextNode(leadingWhitespace), body.childNodes[0] || null);
          }
          if (NAMESPACE === HTML_NAMESPACE) {
            return getElementsByTagName.call(doc3, WHOLE_DOCUMENT ? "html" : "body")[0];
          }
          return WHOLE_DOCUMENT ? doc3.documentElement : body;
        };
        var _createIterator = function _createIterator2(root2) {
          return createNodeIterator.call(
            root2.ownerDocument || root2,
            root2,
            // eslint-disable-next-line no-bitwise
            NodeFilter.SHOW_ELEMENT | NodeFilter.SHOW_COMMENT | NodeFilter.SHOW_TEXT,
            null,
            false
          );
        };
        var _isClobbered = function _isClobbered2(elm) {
          return elm instanceof HTMLFormElement && (typeof elm.nodeName !== "string" || typeof elm.textContent !== "string" || typeof elm.removeChild !== "function" || !(elm.attributes instanceof NamedNodeMap) || typeof elm.removeAttribute !== "function" || typeof elm.setAttribute !== "function" || typeof elm.namespaceURI !== "string" || typeof elm.insertBefore !== "function" || typeof elm.hasChildNodes !== "function");
        };
        var _isNode = function _isNode2(object2) {
          return _typeof(Node3) === "object" ? object2 instanceof Node3 : object2 && _typeof(object2) === "object" && typeof object2.nodeType === "number" && typeof object2.nodeName === "string";
        };
        var _executeHook = function _executeHook2(entryPoint, currentNode, data2) {
          if (!hooks[entryPoint]) {
            return;
          }
          arrayForEach(hooks[entryPoint], function(hook) {
            hook.call(DOMPurify2, currentNode, data2, CONFIG);
          });
        };
        var _sanitizeElements = function _sanitizeElements2(currentNode) {
          var content;
          _executeHook("beforeSanitizeElements", currentNode, null);
          if (_isClobbered(currentNode)) {
            _forceRemove(currentNode);
            return true;
          }
          if (regExpTest(/[\u0080-\uFFFF]/, currentNode.nodeName)) {
            _forceRemove(currentNode);
            return true;
          }
          var tagName = transformCaseFunc(currentNode.nodeName);
          _executeHook("uponSanitizeElement", currentNode, {
            tagName,
            allowedTags: ALLOWED_TAGS
          });
          if (currentNode.hasChildNodes() && !_isNode(currentNode.firstElementChild) && (!_isNode(currentNode.content) || !_isNode(currentNode.content.firstElementChild)) && regExpTest(/<[/\w]/g, currentNode.innerHTML) && regExpTest(/<[/\w]/g, currentNode.textContent)) {
            _forceRemove(currentNode);
            return true;
          }
          if (tagName === "select" && regExpTest(/<template/i, currentNode.innerHTML)) {
            _forceRemove(currentNode);
            return true;
          }
          if (!ALLOWED_TAGS[tagName] || FORBID_TAGS[tagName]) {
            if (!FORBID_TAGS[tagName] && _basicCustomElementTest(tagName)) {
              if (CUSTOM_ELEMENT_HANDLING.tagNameCheck instanceof RegExp && regExpTest(CUSTOM_ELEMENT_HANDLING.tagNameCheck, tagName)) return false;
              if (CUSTOM_ELEMENT_HANDLING.tagNameCheck instanceof Function && CUSTOM_ELEMENT_HANDLING.tagNameCheck(tagName)) return false;
            }
            if (KEEP_CONTENT && !FORBID_CONTENTS[tagName]) {
              var parentNode2 = getParentNode(currentNode) || currentNode.parentNode;
              var childNodes = getChildNodes(currentNode) || currentNode.childNodes;
              if (childNodes && parentNode2) {
                var childCount = childNodes.length;
                for (var i3 = childCount - 1; i3 >= 0; --i3) {
                  parentNode2.insertBefore(cloneNode(childNodes[i3], true), getNextSibling(currentNode));
                }
              }
            }
            _forceRemove(currentNode);
            return true;
          }
          if (currentNode instanceof Element2 && !_checkValidNamespace(currentNode)) {
            _forceRemove(currentNode);
            return true;
          }
          if ((tagName === "noscript" || tagName === "noembed") && regExpTest(/<\/no(script|embed)/i, currentNode.innerHTML)) {
            _forceRemove(currentNode);
            return true;
          }
          if (SAFE_FOR_TEMPLATES && currentNode.nodeType === 3) {
            content = currentNode.textContent;
            content = stringReplace(content, MUSTACHE_EXPR$1, " ");
            content = stringReplace(content, ERB_EXPR$1, " ");
            content = stringReplace(content, TMPLIT_EXPR$1, " ");
            if (currentNode.textContent !== content) {
              arrayPush(DOMPurify2.removed, {
                element: currentNode.cloneNode()
              });
              currentNode.textContent = content;
            }
          }
          _executeHook("afterSanitizeElements", currentNode, null);
          return false;
        };
        var _isValidAttribute = function _isValidAttribute2(lcTag, lcName, value2) {
          if (SANITIZE_DOM && (lcName === "id" || lcName === "name") && (value2 in document2 || value2 in formElement)) {
            return false;
          }
          if (ALLOW_DATA_ATTR && !FORBID_ATTR[lcName] && regExpTest(DATA_ATTR$1, lcName)) ;
          else if (ALLOW_ARIA_ATTR && regExpTest(ARIA_ATTR$1, lcName)) ;
          else if (!ALLOWED_ATTR[lcName] || FORBID_ATTR[lcName]) {
            if (
              // First condition does a very basic check if a) it's basically a valid custom element tagname AND
              // b) if the tagName passes whatever the user has configured for CUSTOM_ELEMENT_HANDLING.tagNameCheck
              // and c) if the attribute name passes whatever the user has configured for CUSTOM_ELEMENT_HANDLING.attributeNameCheck
              _basicCustomElementTest(lcTag) && (CUSTOM_ELEMENT_HANDLING.tagNameCheck instanceof RegExp && regExpTest(CUSTOM_ELEMENT_HANDLING.tagNameCheck, lcTag) || CUSTOM_ELEMENT_HANDLING.tagNameCheck instanceof Function && CUSTOM_ELEMENT_HANDLING.tagNameCheck(lcTag)) && (CUSTOM_ELEMENT_HANDLING.attributeNameCheck instanceof RegExp && regExpTest(CUSTOM_ELEMENT_HANDLING.attributeNameCheck, lcName) || CUSTOM_ELEMENT_HANDLING.attributeNameCheck instanceof Function && CUSTOM_ELEMENT_HANDLING.attributeNameCheck(lcName)) || // Alternative, second condition checks if it's an `is`-attribute, AND
              // the value passes whatever the user has configured for CUSTOM_ELEMENT_HANDLING.tagNameCheck
              lcName === "is" && CUSTOM_ELEMENT_HANDLING.allowCustomizedBuiltInElements && (CUSTOM_ELEMENT_HANDLING.tagNameCheck instanceof RegExp && regExpTest(CUSTOM_ELEMENT_HANDLING.tagNameCheck, value2) || CUSTOM_ELEMENT_HANDLING.tagNameCheck instanceof Function && CUSTOM_ELEMENT_HANDLING.tagNameCheck(value2))
            ) ;
            else {
              return false;
            }
          } else if (URI_SAFE_ATTRIBUTES[lcName]) ;
          else if (regExpTest(IS_ALLOWED_URI$1, stringReplace(value2, ATTR_WHITESPACE$1, ""))) ;
          else if ((lcName === "src" || lcName === "xlink:href" || lcName === "href") && lcTag !== "script" && stringIndexOf2(value2, "data:") === 0 && DATA_URI_TAGS[lcTag]) ;
          else if (ALLOW_UNKNOWN_PROTOCOLS && !regExpTest(IS_SCRIPT_OR_DATA$1, stringReplace(value2, ATTR_WHITESPACE$1, ""))) ;
          else if (!value2) ;
          else {
            return false;
          }
          return true;
        };
        var _basicCustomElementTest = function _basicCustomElementTest2(tagName) {
          return tagName.indexOf("-") > 0;
        };
        var _sanitizeAttributes = function _sanitizeAttributes2(currentNode) {
          var attr;
          var value2;
          var lcName;
          var l3;
          _executeHook("beforeSanitizeAttributes", currentNode, null);
          var attributes = currentNode.attributes;
          if (!attributes) {
            return;
          }
          var hookEvent = {
            attrName: "",
            attrValue: "",
            keepAttr: true,
            allowedAttributes: ALLOWED_ATTR
          };
          l3 = attributes.length;
          while (l3--) {
            attr = attributes[l3];
            var _attr = attr, name = _attr.name, namespaceURI = _attr.namespaceURI;
            value2 = name === "value" ? attr.value : stringTrim(attr.value);
            lcName = transformCaseFunc(name);
            hookEvent.attrName = lcName;
            hookEvent.attrValue = value2;
            hookEvent.keepAttr = true;
            hookEvent.forceKeepAttr = void 0;
            _executeHook("uponSanitizeAttribute", currentNode, hookEvent);
            value2 = hookEvent.attrValue;
            if (hookEvent.forceKeepAttr) {
              continue;
            }
            _removeAttribute(name, currentNode);
            if (!hookEvent.keepAttr) {
              continue;
            }
            if (regExpTest(/\/>/i, value2)) {
              _removeAttribute(name, currentNode);
              continue;
            }
            if (SAFE_FOR_TEMPLATES) {
              value2 = stringReplace(value2, MUSTACHE_EXPR$1, " ");
              value2 = stringReplace(value2, ERB_EXPR$1, " ");
              value2 = stringReplace(value2, TMPLIT_EXPR$1, " ");
            }
            var lcTag = transformCaseFunc(currentNode.nodeName);
            if (!_isValidAttribute(lcTag, lcName, value2)) {
              continue;
            }
            if (SANITIZE_NAMED_PROPS && (lcName === "id" || lcName === "name")) {
              _removeAttribute(name, currentNode);
              value2 = SANITIZE_NAMED_PROPS_PREFIX + value2;
            }
            if (trustedTypesPolicy && _typeof(trustedTypes) === "object" && typeof trustedTypes.getAttributeType === "function") {
              if (namespaceURI) ;
              else {
                switch (trustedTypes.getAttributeType(lcTag, lcName)) {
                  case "TrustedHTML":
                    value2 = trustedTypesPolicy.createHTML(value2);
                    break;
                  case "TrustedScriptURL":
                    value2 = trustedTypesPolicy.createScriptURL(value2);
                    break;
                }
              }
            }
            try {
              if (namespaceURI) {
                currentNode.setAttributeNS(namespaceURI, name, value2);
              } else {
                currentNode.setAttribute(name, value2);
              }
              arrayPop(DOMPurify2.removed);
            } catch (_6) {
            }
          }
          _executeHook("afterSanitizeAttributes", currentNode, null);
        };
        var _sanitizeShadowDOM = function _sanitizeShadowDOM2(fragment) {
          var shadowNode;
          var shadowIterator = _createIterator(fragment);
          _executeHook("beforeSanitizeShadowDOM", fragment, null);
          while (shadowNode = shadowIterator.nextNode()) {
            _executeHook("uponSanitizeShadowNode", shadowNode, null);
            if (_sanitizeElements(shadowNode)) {
              continue;
            }
            if (shadowNode.content instanceof DocumentFragment2) {
              _sanitizeShadowDOM2(shadowNode.content);
            }
            _sanitizeAttributes(shadowNode);
          }
          _executeHook("afterSanitizeShadowDOM", fragment, null);
        };
        DOMPurify2.sanitize = function(dirty) {
          var cfg = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
          var body;
          var importedNode;
          var currentNode;
          var oldNode;
          var returnNode;
          IS_EMPTY_INPUT = !dirty;
          if (IS_EMPTY_INPUT) {
            dirty = "<!-->";
          }
          if (typeof dirty !== "string" && !_isNode(dirty)) {
            if (typeof dirty.toString !== "function") {
              throw typeErrorCreate("toString is not a function");
            } else {
              dirty = dirty.toString();
              if (typeof dirty !== "string") {
                throw typeErrorCreate("dirty is not a string, aborting");
              }
            }
          }
          if (!DOMPurify2.isSupported) {
            if (_typeof(window2.toStaticHTML) === "object" || typeof window2.toStaticHTML === "function") {
              if (typeof dirty === "string") {
                return window2.toStaticHTML(dirty);
              }
              if (_isNode(dirty)) {
                return window2.toStaticHTML(dirty.outerHTML);
              }
            }
            return dirty;
          }
          if (!SET_CONFIG) {
            _parseConfig(cfg);
          }
          DOMPurify2.removed = [];
          if (typeof dirty === "string") {
            IN_PLACE = false;
          }
          if (IN_PLACE) {
            if (dirty.nodeName) {
              var tagName = transformCaseFunc(dirty.nodeName);
              if (!ALLOWED_TAGS[tagName] || FORBID_TAGS[tagName]) {
                throw typeErrorCreate("root node is forbidden and cannot be sanitized in-place");
              }
            }
          } else if (dirty instanceof Node3) {
            body = _initDocument("<!---->");
            importedNode = body.ownerDocument.importNode(dirty, true);
            if (importedNode.nodeType === 1 && importedNode.nodeName === "BODY") {
              body = importedNode;
            } else if (importedNode.nodeName === "HTML") {
              body = importedNode;
            } else {
              body.appendChild(importedNode);
            }
          } else {
            if (!RETURN_DOM && !SAFE_FOR_TEMPLATES && !WHOLE_DOCUMENT && // eslint-disable-next-line unicorn/prefer-includes
            dirty.indexOf("<") === -1) {
              return trustedTypesPolicy && RETURN_TRUSTED_TYPE ? trustedTypesPolicy.createHTML(dirty) : dirty;
            }
            body = _initDocument(dirty);
            if (!body) {
              return RETURN_DOM ? null : RETURN_TRUSTED_TYPE ? emptyHTML : "";
            }
          }
          if (body && FORCE_BODY) {
            _forceRemove(body.firstChild);
          }
          var nodeIterator = _createIterator(IN_PLACE ? dirty : body);
          while (currentNode = nodeIterator.nextNode()) {
            if (currentNode.nodeType === 3 && currentNode === oldNode) {
              continue;
            }
            if (_sanitizeElements(currentNode)) {
              continue;
            }
            if (currentNode.content instanceof DocumentFragment2) {
              _sanitizeShadowDOM(currentNode.content);
            }
            _sanitizeAttributes(currentNode);
            oldNode = currentNode;
          }
          oldNode = null;
          if (IN_PLACE) {
            return dirty;
          }
          if (RETURN_DOM) {
            if (RETURN_DOM_FRAGMENT) {
              returnNode = createDocumentFragment.call(body.ownerDocument);
              while (body.firstChild) {
                returnNode.appendChild(body.firstChild);
              }
            } else {
              returnNode = body;
            }
            if (ALLOWED_ATTR.shadowroot) {
              returnNode = importNode.call(originalDocument, returnNode, true);
            }
            return returnNode;
          }
          var serializedHTML = WHOLE_DOCUMENT ? body.outerHTML : body.innerHTML;
          if (WHOLE_DOCUMENT && ALLOWED_TAGS["!doctype"] && body.ownerDocument && body.ownerDocument.doctype && body.ownerDocument.doctype.name && regExpTest(DOCTYPE_NAME, body.ownerDocument.doctype.name)) {
            serializedHTML = "<!DOCTYPE " + body.ownerDocument.doctype.name + ">\n" + serializedHTML;
          }
          if (SAFE_FOR_TEMPLATES) {
            serializedHTML = stringReplace(serializedHTML, MUSTACHE_EXPR$1, " ");
            serializedHTML = stringReplace(serializedHTML, ERB_EXPR$1, " ");
            serializedHTML = stringReplace(serializedHTML, TMPLIT_EXPR$1, " ");
          }
          return trustedTypesPolicy && RETURN_TRUSTED_TYPE ? trustedTypesPolicy.createHTML(serializedHTML) : serializedHTML;
        };
        DOMPurify2.setConfig = function(cfg) {
          _parseConfig(cfg);
          SET_CONFIG = true;
        };
        DOMPurify2.clearConfig = function() {
          CONFIG = null;
          SET_CONFIG = false;
        };
        DOMPurify2.isValidAttribute = function(tag, attr, value2) {
          if (!CONFIG) {
            _parseConfig({});
          }
          var lcTag = transformCaseFunc(tag);
          var lcName = transformCaseFunc(attr);
          return _isValidAttribute(lcTag, lcName, value2);
        };
        DOMPurify2.addHook = function(entryPoint, hookFunction) {
          if (typeof hookFunction !== "function") {
            return;
          }
          hooks[entryPoint] = hooks[entryPoint] || [];
          arrayPush(hooks[entryPoint], hookFunction);
        };
        DOMPurify2.removeHook = function(entryPoint) {
          if (hooks[entryPoint]) {
            return arrayPop(hooks[entryPoint]);
          }
        };
        DOMPurify2.removeHooks = function(entryPoint) {
          if (hooks[entryPoint]) {
            hooks[entryPoint] = [];
          }
        };
        DOMPurify2.removeAllHooks = function() {
          hooks = {};
        };
        return DOMPurify2;
      }
      var purify = createDOMPurify();
      return purify;
    });
  }
});

// node_modules/html2canvas/dist/html2canvas.js
var require_html2canvas = __commonJS({
  "node_modules/html2canvas/dist/html2canvas.js"(exports, module) {
    (function(global5, factory) {
      typeof exports === "object" && typeof module !== "undefined" ? module.exports = factory() : typeof define === "function" && define.amd ? define(factory) : (global5 = typeof globalThis !== "undefined" ? globalThis : global5 || self, global5.html2canvas = factory());
    })(exports, function() {
      "use strict";
      var extendStatics = function(d3, b3) {
        extendStatics = Object.setPrototypeOf || { __proto__: [] } instanceof Array && function(d4, b4) {
          d4.__proto__ = b4;
        } || function(d4, b4) {
          for (var p3 in b4) if (Object.prototype.hasOwnProperty.call(b4, p3)) d4[p3] = b4[p3];
        };
        return extendStatics(d3, b3);
      };
      function __extends(d3, b3) {
        if (typeof b3 !== "function" && b3 !== null)
          throw new TypeError("Class extends value " + String(b3) + " is not a constructor or null");
        extendStatics(d3, b3);
        function __() {
          this.constructor = d3;
        }
        d3.prototype = b3 === null ? Object.create(b3) : (__.prototype = b3.prototype, new __());
      }
      var __assign = function() {
        __assign = Object.assign || function __assign2(t2) {
          for (var s3, i4 = 1, n4 = arguments.length; i4 < n4; i4++) {
            s3 = arguments[i4];
            for (var p3 in s3) if (Object.prototype.hasOwnProperty.call(s3, p3)) t2[p3] = s3[p3];
          }
          return t2;
        };
        return __assign.apply(this, arguments);
      };
      function __awaiter(thisArg, _arguments, P3, generator) {
        function adopt(value2) {
          return value2 instanceof P3 ? value2 : new P3(function(resolve2) {
            resolve2(value2);
          });
        }
        return new (P3 || (P3 = Promise))(function(resolve2, reject2) {
          function fulfilled(value2) {
            try {
              step(generator.next(value2));
            } catch (e4) {
              reject2(e4);
            }
          }
          function rejected(value2) {
            try {
              step(generator["throw"](value2));
            } catch (e4) {
              reject2(e4);
            }
          }
          function step(result2) {
            result2.done ? resolve2(result2.value) : adopt(result2.value).then(fulfilled, rejected);
          }
          step((generator = generator.apply(thisArg, _arguments || [])).next());
        });
      }
      function __generator(thisArg, body) {
        var _6 = { label: 0, sent: function() {
          if (t2[0] & 1) throw t2[1];
          return t2[1];
        }, trys: [], ops: [] }, f4, y3, t2, g3;
        return g3 = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g3[Symbol.iterator] = function() {
          return this;
        }), g3;
        function verb(n4) {
          return function(v3) {
            return step([n4, v3]);
          };
        }
        function step(op) {
          if (f4) throw new TypeError("Generator is already executing.");
          while (_6) try {
            if (f4 = 1, y3 && (t2 = op[0] & 2 ? y3["return"] : op[0] ? y3["throw"] || ((t2 = y3["return"]) && t2.call(y3), 0) : y3.next) && !(t2 = t2.call(y3, op[1])).done) return t2;
            if (y3 = 0, t2) op = [op[0] & 2, t2.value];
            switch (op[0]) {
              case 0:
              case 1:
                t2 = op;
                break;
              case 4:
                _6.label++;
                return { value: op[1], done: false };
              case 5:
                _6.label++;
                y3 = op[1];
                op = [0];
                continue;
              case 7:
                op = _6.ops.pop();
                _6.trys.pop();
                continue;
              default:
                if (!(t2 = _6.trys, t2 = t2.length > 0 && t2[t2.length - 1]) && (op[0] === 6 || op[0] === 2)) {
                  _6 = 0;
                  continue;
                }
                if (op[0] === 3 && (!t2 || op[1] > t2[0] && op[1] < t2[3])) {
                  _6.label = op[1];
                  break;
                }
                if (op[0] === 6 && _6.label < t2[1]) {
                  _6.label = t2[1];
                  t2 = op;
                  break;
                }
                if (t2 && _6.label < t2[2]) {
                  _6.label = t2[2];
                  _6.ops.push(op);
                  break;
                }
                if (t2[2]) _6.ops.pop();
                _6.trys.pop();
                continue;
            }
            op = body.call(thisArg, _6);
          } catch (e4) {
            op = [6, e4];
            y3 = 0;
          } finally {
            f4 = t2 = 0;
          }
          if (op[0] & 5) throw op[1];
          return { value: op[0] ? op[1] : void 0, done: true };
        }
      }
      function __spreadArray(to, from2, pack2) {
        if (pack2 || arguments.length === 2) for (var i4 = 0, l3 = from2.length, ar; i4 < l3; i4++) {
          if (ar || !(i4 in from2)) {
            if (!ar) ar = Array.prototype.slice.call(from2, 0, i4);
            ar[i4] = from2[i4];
          }
        }
        return to.concat(ar || from2);
      }
      var Bounds = (
        /** @class */
        function() {
          function Bounds2(left, top, width, height) {
            this.left = left;
            this.top = top;
            this.width = width;
            this.height = height;
          }
          Bounds2.prototype.add = function(x3, y3, w3, h3) {
            return new Bounds2(this.left + x3, this.top + y3, this.width + w3, this.height + h3);
          };
          Bounds2.fromClientRect = function(context, clientRect2) {
            return new Bounds2(clientRect2.left + context.windowBounds.left, clientRect2.top + context.windowBounds.top, clientRect2.width, clientRect2.height);
          };
          Bounds2.fromDOMRectList = function(context, domRectList) {
            var domRect = Array.from(domRectList).find(function(rect) {
              return rect.width !== 0;
            });
            return domRect ? new Bounds2(domRect.left + context.windowBounds.left, domRect.top + context.windowBounds.top, domRect.width, domRect.height) : Bounds2.EMPTY;
          };
          Bounds2.EMPTY = new Bounds2(0, 0, 0, 0);
          return Bounds2;
        }()
      );
      var parseBounds = function(context, node) {
        return Bounds.fromClientRect(context, node.getBoundingClientRect());
      };
      var parseDocumentSize = function(document2) {
        var body = document2.body;
        var documentElement = document2.documentElement;
        if (!body || !documentElement) {
          throw new Error("Unable to get document size");
        }
        var width = Math.max(Math.max(body.scrollWidth, documentElement.scrollWidth), Math.max(body.offsetWidth, documentElement.offsetWidth), Math.max(body.clientWidth, documentElement.clientWidth));
        var height = Math.max(Math.max(body.scrollHeight, documentElement.scrollHeight), Math.max(body.offsetHeight, documentElement.offsetHeight), Math.max(body.clientHeight, documentElement.clientHeight));
        return new Bounds(0, 0, width, height);
      };
      var toCodePoints$1 = function(str) {
        var codePoints = [];
        var i4 = 0;
        var length = str.length;
        while (i4 < length) {
          var value2 = str.charCodeAt(i4++);
          if (value2 >= 55296 && value2 <= 56319 && i4 < length) {
            var extra = str.charCodeAt(i4++);
            if ((extra & 64512) === 56320) {
              codePoints.push(((value2 & 1023) << 10) + (extra & 1023) + 65536);
            } else {
              codePoints.push(value2);
              i4--;
            }
          } else {
            codePoints.push(value2);
          }
        }
        return codePoints;
      };
      var fromCodePoint$1 = function() {
        var codePoints = [];
        for (var _i = 0; _i < arguments.length; _i++) {
          codePoints[_i] = arguments[_i];
        }
        if (String.fromCodePoint) {
          return String.fromCodePoint.apply(String, codePoints);
        }
        var length = codePoints.length;
        if (!length) {
          return "";
        }
        var codeUnits = [];
        var index = -1;
        var result2 = "";
        while (++index < length) {
          var codePoint = codePoints[index];
          if (codePoint <= 65535) {
            codeUnits.push(codePoint);
          } else {
            codePoint -= 65536;
            codeUnits.push((codePoint >> 10) + 55296, codePoint % 1024 + 56320);
          }
          if (index + 1 === length || codeUnits.length > 16384) {
            result2 += String.fromCharCode.apply(String, codeUnits);
            codeUnits.length = 0;
          }
        }
        return result2;
      };
      var chars$2 = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
      var lookup$2 = typeof Uint8Array === "undefined" ? [] : new Uint8Array(256);
      for (var i$2 = 0; i$2 < chars$2.length; i$2++) {
        lookup$2[chars$2.charCodeAt(i$2)] = i$2;
      }
      var chars$1$1 = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
      var lookup$1$1 = typeof Uint8Array === "undefined" ? [] : new Uint8Array(256);
      for (var i$1$1 = 0; i$1$1 < chars$1$1.length; i$1$1++) {
        lookup$1$1[chars$1$1.charCodeAt(i$1$1)] = i$1$1;
      }
      var decode$1 = function(base642) {
        var bufferLength = base642.length * 0.75, len = base642.length, i4, p3 = 0, encoded1, encoded2, encoded3, encoded4;
        if (base642[base642.length - 1] === "=") {
          bufferLength--;
          if (base642[base642.length - 2] === "=") {
            bufferLength--;
          }
        }
        var buffer = typeof ArrayBuffer !== "undefined" && typeof Uint8Array !== "undefined" && typeof Uint8Array.prototype.slice !== "undefined" ? new ArrayBuffer(bufferLength) : new Array(bufferLength);
        var bytes = Array.isArray(buffer) ? buffer : new Uint8Array(buffer);
        for (i4 = 0; i4 < len; i4 += 4) {
          encoded1 = lookup$1$1[base642.charCodeAt(i4)];
          encoded2 = lookup$1$1[base642.charCodeAt(i4 + 1)];
          encoded3 = lookup$1$1[base642.charCodeAt(i4 + 2)];
          encoded4 = lookup$1$1[base642.charCodeAt(i4 + 3)];
          bytes[p3++] = encoded1 << 2 | encoded2 >> 4;
          bytes[p3++] = (encoded2 & 15) << 4 | encoded3 >> 2;
          bytes[p3++] = (encoded3 & 3) << 6 | encoded4 & 63;
        }
        return buffer;
      };
      var polyUint16Array$1 = function(buffer) {
        var length = buffer.length;
        var bytes = [];
        for (var i4 = 0; i4 < length; i4 += 2) {
          bytes.push(buffer[i4 + 1] << 8 | buffer[i4]);
        }
        return bytes;
      };
      var polyUint32Array$1 = function(buffer) {
        var length = buffer.length;
        var bytes = [];
        for (var i4 = 0; i4 < length; i4 += 4) {
          bytes.push(buffer[i4 + 3] << 24 | buffer[i4 + 2] << 16 | buffer[i4 + 1] << 8 | buffer[i4]);
        }
        return bytes;
      };
      var UTRIE2_SHIFT_2$1 = 5;
      var UTRIE2_SHIFT_1$1 = 6 + 5;
      var UTRIE2_INDEX_SHIFT$1 = 2;
      var UTRIE2_SHIFT_1_2$1 = UTRIE2_SHIFT_1$1 - UTRIE2_SHIFT_2$1;
      var UTRIE2_LSCP_INDEX_2_OFFSET$1 = 65536 >> UTRIE2_SHIFT_2$1;
      var UTRIE2_DATA_BLOCK_LENGTH$1 = 1 << UTRIE2_SHIFT_2$1;
      var UTRIE2_DATA_MASK$1 = UTRIE2_DATA_BLOCK_LENGTH$1 - 1;
      var UTRIE2_LSCP_INDEX_2_LENGTH$1 = 1024 >> UTRIE2_SHIFT_2$1;
      var UTRIE2_INDEX_2_BMP_LENGTH$1 = UTRIE2_LSCP_INDEX_2_OFFSET$1 + UTRIE2_LSCP_INDEX_2_LENGTH$1;
      var UTRIE2_UTF8_2B_INDEX_2_OFFSET$1 = UTRIE2_INDEX_2_BMP_LENGTH$1;
      var UTRIE2_UTF8_2B_INDEX_2_LENGTH$1 = 2048 >> 6;
      var UTRIE2_INDEX_1_OFFSET$1 = UTRIE2_UTF8_2B_INDEX_2_OFFSET$1 + UTRIE2_UTF8_2B_INDEX_2_LENGTH$1;
      var UTRIE2_OMITTED_BMP_INDEX_1_LENGTH$1 = 65536 >> UTRIE2_SHIFT_1$1;
      var UTRIE2_INDEX_2_BLOCK_LENGTH$1 = 1 << UTRIE2_SHIFT_1_2$1;
      var UTRIE2_INDEX_2_MASK$1 = UTRIE2_INDEX_2_BLOCK_LENGTH$1 - 1;
      var slice16$1 = function(view, start, end) {
        if (view.slice) {
          return view.slice(start, end);
        }
        return new Uint16Array(Array.prototype.slice.call(view, start, end));
      };
      var slice32$1 = function(view, start, end) {
        if (view.slice) {
          return view.slice(start, end);
        }
        return new Uint32Array(Array.prototype.slice.call(view, start, end));
      };
      var createTrieFromBase64$1 = function(base642, _byteLength) {
        var buffer = decode$1(base642);
        var view32 = Array.isArray(buffer) ? polyUint32Array$1(buffer) : new Uint32Array(buffer);
        var view16 = Array.isArray(buffer) ? polyUint16Array$1(buffer) : new Uint16Array(buffer);
        var headerLength = 24;
        var index = slice16$1(view16, headerLength / 2, view32[4] / 2);
        var data2 = view32[5] === 2 ? slice16$1(view16, (headerLength + view32[4]) / 2) : slice32$1(view32, Math.ceil((headerLength + view32[4]) / 4));
        return new Trie$1(view32[0], view32[1], view32[2], view32[3], index, data2);
      };
      var Trie$1 = (
        /** @class */
        function() {
          function Trie2(initialValue, errorValue, highStart, highValueIndex, index, data2) {
            this.initialValue = initialValue;
            this.errorValue = errorValue;
            this.highStart = highStart;
            this.highValueIndex = highValueIndex;
            this.index = index;
            this.data = data2;
          }
          Trie2.prototype.get = function(codePoint) {
            var ix;
            if (codePoint >= 0) {
              if (codePoint < 55296 || codePoint > 56319 && codePoint <= 65535) {
                ix = this.index[codePoint >> UTRIE2_SHIFT_2$1];
                ix = (ix << UTRIE2_INDEX_SHIFT$1) + (codePoint & UTRIE2_DATA_MASK$1);
                return this.data[ix];
              }
              if (codePoint <= 65535) {
                ix = this.index[UTRIE2_LSCP_INDEX_2_OFFSET$1 + (codePoint - 55296 >> UTRIE2_SHIFT_2$1)];
                ix = (ix << UTRIE2_INDEX_SHIFT$1) + (codePoint & UTRIE2_DATA_MASK$1);
                return this.data[ix];
              }
              if (codePoint < this.highStart) {
                ix = UTRIE2_INDEX_1_OFFSET$1 - UTRIE2_OMITTED_BMP_INDEX_1_LENGTH$1 + (codePoint >> UTRIE2_SHIFT_1$1);
                ix = this.index[ix];
                ix += codePoint >> UTRIE2_SHIFT_2$1 & UTRIE2_INDEX_2_MASK$1;
                ix = this.index[ix];
                ix = (ix << UTRIE2_INDEX_SHIFT$1) + (codePoint & UTRIE2_DATA_MASK$1);
                return this.data[ix];
              }
              if (codePoint <= 1114111) {
                return this.data[this.highValueIndex];
              }
            }
            return this.errorValue;
          };
          return Trie2;
        }()
      );
      var chars$3 = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
      var lookup$3 = typeof Uint8Array === "undefined" ? [] : new Uint8Array(256);
      for (var i$3 = 0; i$3 < chars$3.length; i$3++) {
        lookup$3[chars$3.charCodeAt(i$3)] = i$3;
      }
      var base64$1 = "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";
      var LETTER_NUMBER_MODIFIER = 50;
      var BK = 1;
      var CR$1 = 2;
      var LF$1 = 3;
      var CM = 4;
      var NL = 5;
      var WJ = 7;
      var ZW = 8;
      var GL = 9;
      var SP = 10;
      var ZWJ$1 = 11;
      var B2 = 12;
      var BA = 13;
      var BB = 14;
      var HY = 15;
      var CB = 16;
      var CL = 17;
      var CP = 18;
      var EX = 19;
      var IN = 20;
      var NS = 21;
      var OP = 22;
      var QU = 23;
      var IS = 24;
      var NU = 25;
      var PO = 26;
      var PR = 27;
      var SY = 28;
      var AI = 29;
      var AL = 30;
      var CJ = 31;
      var EB = 32;
      var EM = 33;
      var H2 = 34;
      var H3 = 35;
      var HL = 36;
      var ID = 37;
      var JL = 38;
      var JV = 39;
      var JT = 40;
      var RI$1 = 41;
      var SA = 42;
      var XX = 43;
      var ea_OP = [9001, 65288];
      var BREAK_MANDATORY = "!";
      var BREAK_NOT_ALLOWED$1 = "\xD7";
      var BREAK_ALLOWED$1 = "\xF7";
      var UnicodeTrie$1 = createTrieFromBase64$1(base64$1);
      var ALPHABETICS = [AL, HL];
      var HARD_LINE_BREAKS = [BK, CR$1, LF$1, NL];
      var SPACE$1 = [SP, ZW];
      var PREFIX_POSTFIX = [PR, PO];
      var LINE_BREAKS = HARD_LINE_BREAKS.concat(SPACE$1);
      var KOREAN_SYLLABLE_BLOCK = [JL, JV, JT, H2, H3];
      var HYPHEN = [HY, BA];
      var codePointsToCharacterClasses = function(codePoints, lineBreak2) {
        if (lineBreak2 === void 0) {
          lineBreak2 = "strict";
        }
        var types = [];
        var indices = [];
        var categories = [];
        codePoints.forEach(function(codePoint, index) {
          var classType = UnicodeTrie$1.get(codePoint);
          if (classType > LETTER_NUMBER_MODIFIER) {
            categories.push(true);
            classType -= LETTER_NUMBER_MODIFIER;
          } else {
            categories.push(false);
          }
          if (["normal", "auto", "loose"].indexOf(lineBreak2) !== -1) {
            if ([8208, 8211, 12316, 12448].indexOf(codePoint) !== -1) {
              indices.push(index);
              return types.push(CB);
            }
          }
          if (classType === CM || classType === ZWJ$1) {
            if (index === 0) {
              indices.push(index);
              return types.push(AL);
            }
            var prev = types[index - 1];
            if (LINE_BREAKS.indexOf(prev) === -1) {
              indices.push(indices[index - 1]);
              return types.push(prev);
            }
            indices.push(index);
            return types.push(AL);
          }
          indices.push(index);
          if (classType === CJ) {
            return types.push(lineBreak2 === "strict" ? NS : ID);
          }
          if (classType === SA) {
            return types.push(AL);
          }
          if (classType === AI) {
            return types.push(AL);
          }
          if (classType === XX) {
            if (codePoint >= 131072 && codePoint <= 196605 || codePoint >= 196608 && codePoint <= 262141) {
              return types.push(ID);
            } else {
              return types.push(AL);
            }
          }
          types.push(classType);
        });
        return [indices, types, categories];
      };
      var isAdjacentWithSpaceIgnored = function(a4, b3, currentIndex, classTypes) {
        var current = classTypes[currentIndex];
        if (Array.isArray(a4) ? a4.indexOf(current) !== -1 : a4 === current) {
          var i4 = currentIndex;
          while (i4 <= classTypes.length) {
            i4++;
            var next2 = classTypes[i4];
            if (next2 === b3) {
              return true;
            }
            if (next2 !== SP) {
              break;
            }
          }
        }
        if (current === SP) {
          var i4 = currentIndex;
          while (i4 > 0) {
            i4--;
            var prev = classTypes[i4];
            if (Array.isArray(a4) ? a4.indexOf(prev) !== -1 : a4 === prev) {
              var n4 = currentIndex;
              while (n4 <= classTypes.length) {
                n4++;
                var next2 = classTypes[n4];
                if (next2 === b3) {
                  return true;
                }
                if (next2 !== SP) {
                  break;
                }
              }
            }
            if (prev !== SP) {
              break;
            }
          }
        }
        return false;
      };
      var previousNonSpaceClassType = function(currentIndex, classTypes) {
        var i4 = currentIndex;
        while (i4 >= 0) {
          var type = classTypes[i4];
          if (type === SP) {
            i4--;
          } else {
            return type;
          }
        }
        return 0;
      };
      var _lineBreakAtIndex = function(codePoints, classTypes, indicies, index, forbiddenBreaks) {
        if (indicies[index] === 0) {
          return BREAK_NOT_ALLOWED$1;
        }
        var currentIndex = index - 1;
        if (Array.isArray(forbiddenBreaks) && forbiddenBreaks[currentIndex] === true) {
          return BREAK_NOT_ALLOWED$1;
        }
        var beforeIndex = currentIndex - 1;
        var afterIndex = currentIndex + 1;
        var current = classTypes[currentIndex];
        var before2 = beforeIndex >= 0 ? classTypes[beforeIndex] : 0;
        var next2 = classTypes[afterIndex];
        if (current === CR$1 && next2 === LF$1) {
          return BREAK_NOT_ALLOWED$1;
        }
        if (HARD_LINE_BREAKS.indexOf(current) !== -1) {
          return BREAK_MANDATORY;
        }
        if (HARD_LINE_BREAKS.indexOf(next2) !== -1) {
          return BREAK_NOT_ALLOWED$1;
        }
        if (SPACE$1.indexOf(next2) !== -1) {
          return BREAK_NOT_ALLOWED$1;
        }
        if (previousNonSpaceClassType(currentIndex, classTypes) === ZW) {
          return BREAK_ALLOWED$1;
        }
        if (UnicodeTrie$1.get(codePoints[currentIndex]) === ZWJ$1) {
          return BREAK_NOT_ALLOWED$1;
        }
        if ((current === EB || current === EM) && UnicodeTrie$1.get(codePoints[afterIndex]) === ZWJ$1) {
          return BREAK_NOT_ALLOWED$1;
        }
        if (current === WJ || next2 === WJ) {
          return BREAK_NOT_ALLOWED$1;
        }
        if (current === GL) {
          return BREAK_NOT_ALLOWED$1;
        }
        if ([SP, BA, HY].indexOf(current) === -1 && next2 === GL) {
          return BREAK_NOT_ALLOWED$1;
        }
        if ([CL, CP, EX, IS, SY].indexOf(next2) !== -1) {
          return BREAK_NOT_ALLOWED$1;
        }
        if (previousNonSpaceClassType(currentIndex, classTypes) === OP) {
          return BREAK_NOT_ALLOWED$1;
        }
        if (isAdjacentWithSpaceIgnored(QU, OP, currentIndex, classTypes)) {
          return BREAK_NOT_ALLOWED$1;
        }
        if (isAdjacentWithSpaceIgnored([CL, CP], NS, currentIndex, classTypes)) {
          return BREAK_NOT_ALLOWED$1;
        }
        if (isAdjacentWithSpaceIgnored(B2, B2, currentIndex, classTypes)) {
          return BREAK_NOT_ALLOWED$1;
        }
        if (current === SP) {
          return BREAK_ALLOWED$1;
        }
        if (current === QU || next2 === QU) {
          return BREAK_NOT_ALLOWED$1;
        }
        if (next2 === CB || current === CB) {
          return BREAK_ALLOWED$1;
        }
        if ([BA, HY, NS].indexOf(next2) !== -1 || current === BB) {
          return BREAK_NOT_ALLOWED$1;
        }
        if (before2 === HL && HYPHEN.indexOf(current) !== -1) {
          return BREAK_NOT_ALLOWED$1;
        }
        if (current === SY && next2 === HL) {
          return BREAK_NOT_ALLOWED$1;
        }
        if (next2 === IN) {
          return BREAK_NOT_ALLOWED$1;
        }
        if (ALPHABETICS.indexOf(next2) !== -1 && current === NU || ALPHABETICS.indexOf(current) !== -1 && next2 === NU) {
          return BREAK_NOT_ALLOWED$1;
        }
        if (current === PR && [ID, EB, EM].indexOf(next2) !== -1 || [ID, EB, EM].indexOf(current) !== -1 && next2 === PO) {
          return BREAK_NOT_ALLOWED$1;
        }
        if (ALPHABETICS.indexOf(current) !== -1 && PREFIX_POSTFIX.indexOf(next2) !== -1 || PREFIX_POSTFIX.indexOf(current) !== -1 && ALPHABETICS.indexOf(next2) !== -1) {
          return BREAK_NOT_ALLOWED$1;
        }
        if (
          // (PR | PO) × ( OP | HY )? NU
          [PR, PO].indexOf(current) !== -1 && (next2 === NU || [OP, HY].indexOf(next2) !== -1 && classTypes[afterIndex + 1] === NU) || // ( OP | HY ) × NU
          [OP, HY].indexOf(current) !== -1 && next2 === NU || // NU ×	(NU | SY | IS)
          current === NU && [NU, SY, IS].indexOf(next2) !== -1
        ) {
          return BREAK_NOT_ALLOWED$1;
        }
        if ([NU, SY, IS, CL, CP].indexOf(next2) !== -1) {
          var prevIndex = currentIndex;
          while (prevIndex >= 0) {
            var type = classTypes[prevIndex];
            if (type === NU) {
              return BREAK_NOT_ALLOWED$1;
            } else if ([SY, IS].indexOf(type) !== -1) {
              prevIndex--;
            } else {
              break;
            }
          }
        }
        if ([PR, PO].indexOf(next2) !== -1) {
          var prevIndex = [CL, CP].indexOf(current) !== -1 ? beforeIndex : currentIndex;
          while (prevIndex >= 0) {
            var type = classTypes[prevIndex];
            if (type === NU) {
              return BREAK_NOT_ALLOWED$1;
            } else if ([SY, IS].indexOf(type) !== -1) {
              prevIndex--;
            } else {
              break;
            }
          }
        }
        if (JL === current && [JL, JV, H2, H3].indexOf(next2) !== -1 || [JV, H2].indexOf(current) !== -1 && [JV, JT].indexOf(next2) !== -1 || [JT, H3].indexOf(current) !== -1 && next2 === JT) {
          return BREAK_NOT_ALLOWED$1;
        }
        if (KOREAN_SYLLABLE_BLOCK.indexOf(current) !== -1 && [IN, PO].indexOf(next2) !== -1 || KOREAN_SYLLABLE_BLOCK.indexOf(next2) !== -1 && current === PR) {
          return BREAK_NOT_ALLOWED$1;
        }
        if (ALPHABETICS.indexOf(current) !== -1 && ALPHABETICS.indexOf(next2) !== -1) {
          return BREAK_NOT_ALLOWED$1;
        }
        if (current === IS && ALPHABETICS.indexOf(next2) !== -1) {
          return BREAK_NOT_ALLOWED$1;
        }
        if (ALPHABETICS.concat(NU).indexOf(current) !== -1 && next2 === OP && ea_OP.indexOf(codePoints[afterIndex]) === -1 || ALPHABETICS.concat(NU).indexOf(next2) !== -1 && current === CP) {
          return BREAK_NOT_ALLOWED$1;
        }
        if (current === RI$1 && next2 === RI$1) {
          var i4 = indicies[currentIndex];
          var count = 1;
          while (i4 > 0) {
            i4--;
            if (classTypes[i4] === RI$1) {
              count++;
            } else {
              break;
            }
          }
          if (count % 2 !== 0) {
            return BREAK_NOT_ALLOWED$1;
          }
        }
        if (current === EB && next2 === EM) {
          return BREAK_NOT_ALLOWED$1;
        }
        return BREAK_ALLOWED$1;
      };
      var cssFormattedClasses = function(codePoints, options2) {
        if (!options2) {
          options2 = { lineBreak: "normal", wordBreak: "normal" };
        }
        var _a = codePointsToCharacterClasses(codePoints, options2.lineBreak), indicies = _a[0], classTypes = _a[1], isLetterNumber = _a[2];
        if (options2.wordBreak === "break-all" || options2.wordBreak === "break-word") {
          classTypes = classTypes.map(function(type) {
            return [NU, AL, SA].indexOf(type) !== -1 ? ID : type;
          });
        }
        var forbiddenBreakpoints = options2.wordBreak === "keep-all" ? isLetterNumber.map(function(letterNumber, i4) {
          return letterNumber && codePoints[i4] >= 19968 && codePoints[i4] <= 40959;
        }) : void 0;
        return [indicies, classTypes, forbiddenBreakpoints];
      };
      var Break = (
        /** @class */
        function() {
          function Break2(codePoints, lineBreak2, start, end) {
            this.codePoints = codePoints;
            this.required = lineBreak2 === BREAK_MANDATORY;
            this.start = start;
            this.end = end;
          }
          Break2.prototype.slice = function() {
            return fromCodePoint$1.apply(void 0, this.codePoints.slice(this.start, this.end));
          };
          return Break2;
        }()
      );
      var LineBreaker = function(str, options2) {
        var codePoints = toCodePoints$1(str);
        var _a = cssFormattedClasses(codePoints, options2), indicies = _a[0], classTypes = _a[1], forbiddenBreakpoints = _a[2];
        var length = codePoints.length;
        var lastEnd = 0;
        var nextIndex = 0;
        return {
          next: function() {
            if (nextIndex >= length) {
              return { done: true, value: null };
            }
            var lineBreak2 = BREAK_NOT_ALLOWED$1;
            while (nextIndex < length && (lineBreak2 = _lineBreakAtIndex(codePoints, classTypes, indicies, ++nextIndex, forbiddenBreakpoints)) === BREAK_NOT_ALLOWED$1) {
            }
            if (lineBreak2 !== BREAK_NOT_ALLOWED$1 || nextIndex === length) {
              var value2 = new Break(codePoints, lineBreak2, lastEnd, nextIndex);
              lastEnd = nextIndex;
              return { value: value2, done: false };
            }
            return { done: true, value: null };
          }
        };
      };
      var FLAG_UNRESTRICTED = 1 << 0;
      var FLAG_ID = 1 << 1;
      var FLAG_INTEGER = 1 << 2;
      var FLAG_NUMBER = 1 << 3;
      var LINE_FEED = 10;
      var SOLIDUS = 47;
      var REVERSE_SOLIDUS = 92;
      var CHARACTER_TABULATION = 9;
      var SPACE = 32;
      var QUOTATION_MARK = 34;
      var EQUALS_SIGN = 61;
      var NUMBER_SIGN = 35;
      var DOLLAR_SIGN = 36;
      var PERCENTAGE_SIGN = 37;
      var APOSTROPHE = 39;
      var LEFT_PARENTHESIS = 40;
      var RIGHT_PARENTHESIS = 41;
      var LOW_LINE = 95;
      var HYPHEN_MINUS = 45;
      var EXCLAMATION_MARK = 33;
      var LESS_THAN_SIGN = 60;
      var GREATER_THAN_SIGN = 62;
      var COMMERCIAL_AT = 64;
      var LEFT_SQUARE_BRACKET = 91;
      var RIGHT_SQUARE_BRACKET = 93;
      var CIRCUMFLEX_ACCENT = 61;
      var LEFT_CURLY_BRACKET = 123;
      var QUESTION_MARK = 63;
      var RIGHT_CURLY_BRACKET = 125;
      var VERTICAL_LINE = 124;
      var TILDE = 126;
      var CONTROL = 128;
      var REPLACEMENT_CHARACTER = 65533;
      var ASTERISK = 42;
      var PLUS_SIGN = 43;
      var COMMA = 44;
      var COLON = 58;
      var SEMICOLON = 59;
      var FULL_STOP = 46;
      var NULL = 0;
      var BACKSPACE = 8;
      var LINE_TABULATION = 11;
      var SHIFT_OUT = 14;
      var INFORMATION_SEPARATOR_ONE = 31;
      var DELETE = 127;
      var EOF = -1;
      var ZERO = 48;
      var a3 = 97;
      var e3 = 101;
      var f3 = 102;
      var u3 = 117;
      var z2 = 122;
      var A4 = 65;
      var E3 = 69;
      var F2 = 70;
      var U = 85;
      var Z = 90;
      var isDigit = function(codePoint) {
        return codePoint >= ZERO && codePoint <= 57;
      };
      var isSurrogateCodePoint = function(codePoint) {
        return codePoint >= 55296 && codePoint <= 57343;
      };
      var isHex = function(codePoint) {
        return isDigit(codePoint) || codePoint >= A4 && codePoint <= F2 || codePoint >= a3 && codePoint <= f3;
      };
      var isLowerCaseLetter = function(codePoint) {
        return codePoint >= a3 && codePoint <= z2;
      };
      var isUpperCaseLetter = function(codePoint) {
        return codePoint >= A4 && codePoint <= Z;
      };
      var isLetter = function(codePoint) {
        return isLowerCaseLetter(codePoint) || isUpperCaseLetter(codePoint);
      };
      var isNonASCIICodePoint = function(codePoint) {
        return codePoint >= CONTROL;
      };
      var isWhiteSpace = function(codePoint) {
        return codePoint === LINE_FEED || codePoint === CHARACTER_TABULATION || codePoint === SPACE;
      };
      var isNameStartCodePoint = function(codePoint) {
        return isLetter(codePoint) || isNonASCIICodePoint(codePoint) || codePoint === LOW_LINE;
      };
      var isNameCodePoint = function(codePoint) {
        return isNameStartCodePoint(codePoint) || isDigit(codePoint) || codePoint === HYPHEN_MINUS;
      };
      var isNonPrintableCodePoint = function(codePoint) {
        return codePoint >= NULL && codePoint <= BACKSPACE || codePoint === LINE_TABULATION || codePoint >= SHIFT_OUT && codePoint <= INFORMATION_SEPARATOR_ONE || codePoint === DELETE;
      };
      var isValidEscape = function(c1, c22) {
        if (c1 !== REVERSE_SOLIDUS) {
          return false;
        }
        return c22 !== LINE_FEED;
      };
      var isIdentifierStart = function(c1, c22, c3) {
        if (c1 === HYPHEN_MINUS) {
          return isNameStartCodePoint(c22) || isValidEscape(c22, c3);
        } else if (isNameStartCodePoint(c1)) {
          return true;
        } else if (c1 === REVERSE_SOLIDUS && isValidEscape(c1, c22)) {
          return true;
        }
        return false;
      };
      var isNumberStart = function(c1, c22, c3) {
        if (c1 === PLUS_SIGN || c1 === HYPHEN_MINUS) {
          if (isDigit(c22)) {
            return true;
          }
          return c22 === FULL_STOP && isDigit(c3);
        }
        if (c1 === FULL_STOP) {
          return isDigit(c22);
        }
        return isDigit(c1);
      };
      var stringToNumber = function(codePoints) {
        var c3 = 0;
        var sign = 1;
        if (codePoints[c3] === PLUS_SIGN || codePoints[c3] === HYPHEN_MINUS) {
          if (codePoints[c3] === HYPHEN_MINUS) {
            sign = -1;
          }
          c3++;
        }
        var integers = [];
        while (isDigit(codePoints[c3])) {
          integers.push(codePoints[c3++]);
        }
        var int = integers.length ? parseInt(fromCodePoint$1.apply(void 0, integers), 10) : 0;
        if (codePoints[c3] === FULL_STOP) {
          c3++;
        }
        var fraction = [];
        while (isDigit(codePoints[c3])) {
          fraction.push(codePoints[c3++]);
        }
        var fracd = fraction.length;
        var frac = fracd ? parseInt(fromCodePoint$1.apply(void 0, fraction), 10) : 0;
        if (codePoints[c3] === E3 || codePoints[c3] === e3) {
          c3++;
        }
        var expsign = 1;
        if (codePoints[c3] === PLUS_SIGN || codePoints[c3] === HYPHEN_MINUS) {
          if (codePoints[c3] === HYPHEN_MINUS) {
            expsign = -1;
          }
          c3++;
        }
        var exponent = [];
        while (isDigit(codePoints[c3])) {
          exponent.push(codePoints[c3++]);
        }
        var exp = exponent.length ? parseInt(fromCodePoint$1.apply(void 0, exponent), 10) : 0;
        return sign * (int + frac * Math.pow(10, -fracd)) * Math.pow(10, expsign * exp);
      };
      var LEFT_PARENTHESIS_TOKEN = {
        type: 2
        /* LEFT_PARENTHESIS_TOKEN */
      };
      var RIGHT_PARENTHESIS_TOKEN = {
        type: 3
        /* RIGHT_PARENTHESIS_TOKEN */
      };
      var COMMA_TOKEN = {
        type: 4
        /* COMMA_TOKEN */
      };
      var SUFFIX_MATCH_TOKEN = {
        type: 13
        /* SUFFIX_MATCH_TOKEN */
      };
      var PREFIX_MATCH_TOKEN = {
        type: 8
        /* PREFIX_MATCH_TOKEN */
      };
      var COLUMN_TOKEN = {
        type: 21
        /* COLUMN_TOKEN */
      };
      var DASH_MATCH_TOKEN = {
        type: 9
        /* DASH_MATCH_TOKEN */
      };
      var INCLUDE_MATCH_TOKEN = {
        type: 10
        /* INCLUDE_MATCH_TOKEN */
      };
      var LEFT_CURLY_BRACKET_TOKEN = {
        type: 11
        /* LEFT_CURLY_BRACKET_TOKEN */
      };
      var RIGHT_CURLY_BRACKET_TOKEN = {
        type: 12
        /* RIGHT_CURLY_BRACKET_TOKEN */
      };
      var SUBSTRING_MATCH_TOKEN = {
        type: 14
        /* SUBSTRING_MATCH_TOKEN */
      };
      var BAD_URL_TOKEN = {
        type: 23
        /* BAD_URL_TOKEN */
      };
      var BAD_STRING_TOKEN = {
        type: 1
        /* BAD_STRING_TOKEN */
      };
      var CDO_TOKEN = {
        type: 25
        /* CDO_TOKEN */
      };
      var CDC_TOKEN = {
        type: 24
        /* CDC_TOKEN */
      };
      var COLON_TOKEN = {
        type: 26
        /* COLON_TOKEN */
      };
      var SEMICOLON_TOKEN = {
        type: 27
        /* SEMICOLON_TOKEN */
      };
      var LEFT_SQUARE_BRACKET_TOKEN = {
        type: 28
        /* LEFT_SQUARE_BRACKET_TOKEN */
      };
      var RIGHT_SQUARE_BRACKET_TOKEN = {
        type: 29
        /* RIGHT_SQUARE_BRACKET_TOKEN */
      };
      var WHITESPACE_TOKEN = {
        type: 31
        /* WHITESPACE_TOKEN */
      };
      var EOF_TOKEN = {
        type: 32
        /* EOF_TOKEN */
      };
      var Tokenizer2 = (
        /** @class */
        function() {
          function Tokenizer3() {
            this._value = [];
          }
          Tokenizer3.prototype.write = function(chunk2) {
            this._value = this._value.concat(toCodePoints$1(chunk2));
          };
          Tokenizer3.prototype.read = function() {
            var tokens = [];
            var token = this.consumeToken();
            while (token !== EOF_TOKEN) {
              tokens.push(token);
              token = this.consumeToken();
            }
            return tokens;
          };
          Tokenizer3.prototype.consumeToken = function() {
            var codePoint = this.consumeCodePoint();
            switch (codePoint) {
              case QUOTATION_MARK:
                return this.consumeStringToken(QUOTATION_MARK);
              case NUMBER_SIGN:
                var c1 = this.peekCodePoint(0);
                var c22 = this.peekCodePoint(1);
                var c3 = this.peekCodePoint(2);
                if (isNameCodePoint(c1) || isValidEscape(c22, c3)) {
                  var flags = isIdentifierStart(c1, c22, c3) ? FLAG_ID : FLAG_UNRESTRICTED;
                  var value2 = this.consumeName();
                  return { type: 5, value: value2, flags };
                }
                break;
              case DOLLAR_SIGN:
                if (this.peekCodePoint(0) === EQUALS_SIGN) {
                  this.consumeCodePoint();
                  return SUFFIX_MATCH_TOKEN;
                }
                break;
              case APOSTROPHE:
                return this.consumeStringToken(APOSTROPHE);
              case LEFT_PARENTHESIS:
                return LEFT_PARENTHESIS_TOKEN;
              case RIGHT_PARENTHESIS:
                return RIGHT_PARENTHESIS_TOKEN;
              case ASTERISK:
                if (this.peekCodePoint(0) === EQUALS_SIGN) {
                  this.consumeCodePoint();
                  return SUBSTRING_MATCH_TOKEN;
                }
                break;
              case PLUS_SIGN:
                if (isNumberStart(codePoint, this.peekCodePoint(0), this.peekCodePoint(1))) {
                  this.reconsumeCodePoint(codePoint);
                  return this.consumeNumericToken();
                }
                break;
              case COMMA:
                return COMMA_TOKEN;
              case HYPHEN_MINUS:
                var e1 = codePoint;
                var e22 = this.peekCodePoint(0);
                var e32 = this.peekCodePoint(1);
                if (isNumberStart(e1, e22, e32)) {
                  this.reconsumeCodePoint(codePoint);
                  return this.consumeNumericToken();
                }
                if (isIdentifierStart(e1, e22, e32)) {
                  this.reconsumeCodePoint(codePoint);
                  return this.consumeIdentLikeToken();
                }
                if (e22 === HYPHEN_MINUS && e32 === GREATER_THAN_SIGN) {
                  this.consumeCodePoint();
                  this.consumeCodePoint();
                  return CDC_TOKEN;
                }
                break;
              case FULL_STOP:
                if (isNumberStart(codePoint, this.peekCodePoint(0), this.peekCodePoint(1))) {
                  this.reconsumeCodePoint(codePoint);
                  return this.consumeNumericToken();
                }
                break;
              case SOLIDUS:
                if (this.peekCodePoint(0) === ASTERISK) {
                  this.consumeCodePoint();
                  while (true) {
                    var c4 = this.consumeCodePoint();
                    if (c4 === ASTERISK) {
                      c4 = this.consumeCodePoint();
                      if (c4 === SOLIDUS) {
                        return this.consumeToken();
                      }
                    }
                    if (c4 === EOF) {
                      return this.consumeToken();
                    }
                  }
                }
                break;
              case COLON:
                return COLON_TOKEN;
              case SEMICOLON:
                return SEMICOLON_TOKEN;
              case LESS_THAN_SIGN:
                if (this.peekCodePoint(0) === EXCLAMATION_MARK && this.peekCodePoint(1) === HYPHEN_MINUS && this.peekCodePoint(2) === HYPHEN_MINUS) {
                  this.consumeCodePoint();
                  this.consumeCodePoint();
                  return CDO_TOKEN;
                }
                break;
              case COMMERCIAL_AT:
                var a1 = this.peekCodePoint(0);
                var a22 = this.peekCodePoint(1);
                var a32 = this.peekCodePoint(2);
                if (isIdentifierStart(a1, a22, a32)) {
                  var value2 = this.consumeName();
                  return { type: 7, value: value2 };
                }
                break;
              case LEFT_SQUARE_BRACKET:
                return LEFT_SQUARE_BRACKET_TOKEN;
              case REVERSE_SOLIDUS:
                if (isValidEscape(codePoint, this.peekCodePoint(0))) {
                  this.reconsumeCodePoint(codePoint);
                  return this.consumeIdentLikeToken();
                }
                break;
              case RIGHT_SQUARE_BRACKET:
                return RIGHT_SQUARE_BRACKET_TOKEN;
              case CIRCUMFLEX_ACCENT:
                if (this.peekCodePoint(0) === EQUALS_SIGN) {
                  this.consumeCodePoint();
                  return PREFIX_MATCH_TOKEN;
                }
                break;
              case LEFT_CURLY_BRACKET:
                return LEFT_CURLY_BRACKET_TOKEN;
              case RIGHT_CURLY_BRACKET:
                return RIGHT_CURLY_BRACKET_TOKEN;
              case u3:
              case U:
                var u1 = this.peekCodePoint(0);
                var u22 = this.peekCodePoint(1);
                if (u1 === PLUS_SIGN && (isHex(u22) || u22 === QUESTION_MARK)) {
                  this.consumeCodePoint();
                  this.consumeUnicodeRangeToken();
                }
                this.reconsumeCodePoint(codePoint);
                return this.consumeIdentLikeToken();
              case VERTICAL_LINE:
                if (this.peekCodePoint(0) === EQUALS_SIGN) {
                  this.consumeCodePoint();
                  return DASH_MATCH_TOKEN;
                }
                if (this.peekCodePoint(0) === VERTICAL_LINE) {
                  this.consumeCodePoint();
                  return COLUMN_TOKEN;
                }
                break;
              case TILDE:
                if (this.peekCodePoint(0) === EQUALS_SIGN) {
                  this.consumeCodePoint();
                  return INCLUDE_MATCH_TOKEN;
                }
                break;
              case EOF:
                return EOF_TOKEN;
            }
            if (isWhiteSpace(codePoint)) {
              this.consumeWhiteSpace();
              return WHITESPACE_TOKEN;
            }
            if (isDigit(codePoint)) {
              this.reconsumeCodePoint(codePoint);
              return this.consumeNumericToken();
            }
            if (isNameStartCodePoint(codePoint)) {
              this.reconsumeCodePoint(codePoint);
              return this.consumeIdentLikeToken();
            }
            return { type: 6, value: fromCodePoint$1(codePoint) };
          };
          Tokenizer3.prototype.consumeCodePoint = function() {
            var value2 = this._value.shift();
            return typeof value2 === "undefined" ? -1 : value2;
          };
          Tokenizer3.prototype.reconsumeCodePoint = function(codePoint) {
            this._value.unshift(codePoint);
          };
          Tokenizer3.prototype.peekCodePoint = function(delta) {
            if (delta >= this._value.length) {
              return -1;
            }
            return this._value[delta];
          };
          Tokenizer3.prototype.consumeUnicodeRangeToken = function() {
            var digits = [];
            var codePoint = this.consumeCodePoint();
            while (isHex(codePoint) && digits.length < 6) {
              digits.push(codePoint);
              codePoint = this.consumeCodePoint();
            }
            var questionMarks = false;
            while (codePoint === QUESTION_MARK && digits.length < 6) {
              digits.push(codePoint);
              codePoint = this.consumeCodePoint();
              questionMarks = true;
            }
            if (questionMarks) {
              var start_1 = parseInt(fromCodePoint$1.apply(void 0, digits.map(function(digit) {
                return digit === QUESTION_MARK ? ZERO : digit;
              })), 16);
              var end = parseInt(fromCodePoint$1.apply(void 0, digits.map(function(digit) {
                return digit === QUESTION_MARK ? F2 : digit;
              })), 16);
              return { type: 30, start: start_1, end };
            }
            var start = parseInt(fromCodePoint$1.apply(void 0, digits), 16);
            if (this.peekCodePoint(0) === HYPHEN_MINUS && isHex(this.peekCodePoint(1))) {
              this.consumeCodePoint();
              codePoint = this.consumeCodePoint();
              var endDigits = [];
              while (isHex(codePoint) && endDigits.length < 6) {
                endDigits.push(codePoint);
                codePoint = this.consumeCodePoint();
              }
              var end = parseInt(fromCodePoint$1.apply(void 0, endDigits), 16);
              return { type: 30, start, end };
            } else {
              return { type: 30, start, end: start };
            }
          };
          Tokenizer3.prototype.consumeIdentLikeToken = function() {
            var value2 = this.consumeName();
            if (value2.toLowerCase() === "url" && this.peekCodePoint(0) === LEFT_PARENTHESIS) {
              this.consumeCodePoint();
              return this.consumeUrlToken();
            } else if (this.peekCodePoint(0) === LEFT_PARENTHESIS) {
              this.consumeCodePoint();
              return { type: 19, value: value2 };
            }
            return { type: 20, value: value2 };
          };
          Tokenizer3.prototype.consumeUrlToken = function() {
            var value2 = [];
            this.consumeWhiteSpace();
            if (this.peekCodePoint(0) === EOF) {
              return { type: 22, value: "" };
            }
            var next2 = this.peekCodePoint(0);
            if (next2 === APOSTROPHE || next2 === QUOTATION_MARK) {
              var stringToken = this.consumeStringToken(this.consumeCodePoint());
              if (stringToken.type === 0) {
                this.consumeWhiteSpace();
                if (this.peekCodePoint(0) === EOF || this.peekCodePoint(0) === RIGHT_PARENTHESIS) {
                  this.consumeCodePoint();
                  return { type: 22, value: stringToken.value };
                }
              }
              this.consumeBadUrlRemnants();
              return BAD_URL_TOKEN;
            }
            while (true) {
              var codePoint = this.consumeCodePoint();
              if (codePoint === EOF || codePoint === RIGHT_PARENTHESIS) {
                return { type: 22, value: fromCodePoint$1.apply(void 0, value2) };
              } else if (isWhiteSpace(codePoint)) {
                this.consumeWhiteSpace();
                if (this.peekCodePoint(0) === EOF || this.peekCodePoint(0) === RIGHT_PARENTHESIS) {
                  this.consumeCodePoint();
                  return { type: 22, value: fromCodePoint$1.apply(void 0, value2) };
                }
                this.consumeBadUrlRemnants();
                return BAD_URL_TOKEN;
              } else if (codePoint === QUOTATION_MARK || codePoint === APOSTROPHE || codePoint === LEFT_PARENTHESIS || isNonPrintableCodePoint(codePoint)) {
                this.consumeBadUrlRemnants();
                return BAD_URL_TOKEN;
              } else if (codePoint === REVERSE_SOLIDUS) {
                if (isValidEscape(codePoint, this.peekCodePoint(0))) {
                  value2.push(this.consumeEscapedCodePoint());
                } else {
                  this.consumeBadUrlRemnants();
                  return BAD_URL_TOKEN;
                }
              } else {
                value2.push(codePoint);
              }
            }
          };
          Tokenizer3.prototype.consumeWhiteSpace = function() {
            while (isWhiteSpace(this.peekCodePoint(0))) {
              this.consumeCodePoint();
            }
          };
          Tokenizer3.prototype.consumeBadUrlRemnants = function() {
            while (true) {
              var codePoint = this.consumeCodePoint();
              if (codePoint === RIGHT_PARENTHESIS || codePoint === EOF) {
                return;
              }
              if (isValidEscape(codePoint, this.peekCodePoint(0))) {
                this.consumeEscapedCodePoint();
              }
            }
          };
          Tokenizer3.prototype.consumeStringSlice = function(count) {
            var SLICE_STACK_SIZE = 5e4;
            var value2 = "";
            while (count > 0) {
              var amount = Math.min(SLICE_STACK_SIZE, count);
              value2 += fromCodePoint$1.apply(void 0, this._value.splice(0, amount));
              count -= amount;
            }
            this._value.shift();
            return value2;
          };
          Tokenizer3.prototype.consumeStringToken = function(endingCodePoint) {
            var value2 = "";
            var i4 = 0;
            do {
              var codePoint = this._value[i4];
              if (codePoint === EOF || codePoint === void 0 || codePoint === endingCodePoint) {
                value2 += this.consumeStringSlice(i4);
                return { type: 0, value: value2 };
              }
              if (codePoint === LINE_FEED) {
                this._value.splice(0, i4);
                return BAD_STRING_TOKEN;
              }
              if (codePoint === REVERSE_SOLIDUS) {
                var next2 = this._value[i4 + 1];
                if (next2 !== EOF && next2 !== void 0) {
                  if (next2 === LINE_FEED) {
                    value2 += this.consumeStringSlice(i4);
                    i4 = -1;
                    this._value.shift();
                  } else if (isValidEscape(codePoint, next2)) {
                    value2 += this.consumeStringSlice(i4);
                    value2 += fromCodePoint$1(this.consumeEscapedCodePoint());
                    i4 = -1;
                  }
                }
              }
              i4++;
            } while (true);
          };
          Tokenizer3.prototype.consumeNumber = function() {
            var repr = [];
            var type = FLAG_INTEGER;
            var c1 = this.peekCodePoint(0);
            if (c1 === PLUS_SIGN || c1 === HYPHEN_MINUS) {
              repr.push(this.consumeCodePoint());
            }
            while (isDigit(this.peekCodePoint(0))) {
              repr.push(this.consumeCodePoint());
            }
            c1 = this.peekCodePoint(0);
            var c22 = this.peekCodePoint(1);
            if (c1 === FULL_STOP && isDigit(c22)) {
              repr.push(this.consumeCodePoint(), this.consumeCodePoint());
              type = FLAG_NUMBER;
              while (isDigit(this.peekCodePoint(0))) {
                repr.push(this.consumeCodePoint());
              }
            }
            c1 = this.peekCodePoint(0);
            c22 = this.peekCodePoint(1);
            var c3 = this.peekCodePoint(2);
            if ((c1 === E3 || c1 === e3) && ((c22 === PLUS_SIGN || c22 === HYPHEN_MINUS) && isDigit(c3) || isDigit(c22))) {
              repr.push(this.consumeCodePoint(), this.consumeCodePoint());
              type = FLAG_NUMBER;
              while (isDigit(this.peekCodePoint(0))) {
                repr.push(this.consumeCodePoint());
              }
            }
            return [stringToNumber(repr), type];
          };
          Tokenizer3.prototype.consumeNumericToken = function() {
            var _a = this.consumeNumber(), number = _a[0], flags = _a[1];
            var c1 = this.peekCodePoint(0);
            var c22 = this.peekCodePoint(1);
            var c3 = this.peekCodePoint(2);
            if (isIdentifierStart(c1, c22, c3)) {
              var unit = this.consumeName();
              return { type: 15, number, flags, unit };
            }
            if (c1 === PERCENTAGE_SIGN) {
              this.consumeCodePoint();
              return { type: 16, number, flags };
            }
            return { type: 17, number, flags };
          };
          Tokenizer3.prototype.consumeEscapedCodePoint = function() {
            var codePoint = this.consumeCodePoint();
            if (isHex(codePoint)) {
              var hex = fromCodePoint$1(codePoint);
              while (isHex(this.peekCodePoint(0)) && hex.length < 6) {
                hex += fromCodePoint$1(this.consumeCodePoint());
              }
              if (isWhiteSpace(this.peekCodePoint(0))) {
                this.consumeCodePoint();
              }
              var hexCodePoint = parseInt(hex, 16);
              if (hexCodePoint === 0 || isSurrogateCodePoint(hexCodePoint) || hexCodePoint > 1114111) {
                return REPLACEMENT_CHARACTER;
              }
              return hexCodePoint;
            }
            if (codePoint === EOF) {
              return REPLACEMENT_CHARACTER;
            }
            return codePoint;
          };
          Tokenizer3.prototype.consumeName = function() {
            var result2 = "";
            while (true) {
              var codePoint = this.consumeCodePoint();
              if (isNameCodePoint(codePoint)) {
                result2 += fromCodePoint$1(codePoint);
              } else if (isValidEscape(codePoint, this.peekCodePoint(0))) {
                result2 += fromCodePoint$1(this.consumeEscapedCodePoint());
              } else {
                this.reconsumeCodePoint(codePoint);
                return result2;
              }
            }
          };
          return Tokenizer3;
        }()
      );
      var Parser2 = (
        /** @class */
        function() {
          function Parser3(tokens) {
            this._tokens = tokens;
          }
          Parser3.create = function(value2) {
            var tokenizer = new Tokenizer2();
            tokenizer.write(value2);
            return new Parser3(tokenizer.read());
          };
          Parser3.parseValue = function(value2) {
            return Parser3.create(value2).parseComponentValue();
          };
          Parser3.parseValues = function(value2) {
            return Parser3.create(value2).parseComponentValues();
          };
          Parser3.prototype.parseComponentValue = function() {
            var token = this.consumeToken();
            while (token.type === 31) {
              token = this.consumeToken();
            }
            if (token.type === 32) {
              throw new SyntaxError("Error parsing CSS component value, unexpected EOF");
            }
            this.reconsumeToken(token);
            var value2 = this.consumeComponentValue();
            do {
              token = this.consumeToken();
            } while (token.type === 31);
            if (token.type === 32) {
              return value2;
            }
            throw new SyntaxError("Error parsing CSS component value, multiple values found when expecting only one");
          };
          Parser3.prototype.parseComponentValues = function() {
            var values2 = [];
            while (true) {
              var value2 = this.consumeComponentValue();
              if (value2.type === 32) {
                return values2;
              }
              values2.push(value2);
              values2.push();
            }
          };
          Parser3.prototype.consumeComponentValue = function() {
            var token = this.consumeToken();
            switch (token.type) {
              case 11:
              case 28:
              case 2:
                return this.consumeSimpleBlock(token.type);
              case 19:
                return this.consumeFunction(token);
            }
            return token;
          };
          Parser3.prototype.consumeSimpleBlock = function(type) {
            var block2 = { type, values: [] };
            var token = this.consumeToken();
            while (true) {
              if (token.type === 32 || isEndingTokenFor(token, type)) {
                return block2;
              }
              this.reconsumeToken(token);
              block2.values.push(this.consumeComponentValue());
              token = this.consumeToken();
            }
          };
          Parser3.prototype.consumeFunction = function(functionToken) {
            var cssFunction = {
              name: functionToken.value,
              values: [],
              type: 18
              /* FUNCTION */
            };
            while (true) {
              var token = this.consumeToken();
              if (token.type === 32 || token.type === 3) {
                return cssFunction;
              }
              this.reconsumeToken(token);
              cssFunction.values.push(this.consumeComponentValue());
            }
          };
          Parser3.prototype.consumeToken = function() {
            var token = this._tokens.shift();
            return typeof token === "undefined" ? EOF_TOKEN : token;
          };
          Parser3.prototype.reconsumeToken = function(token) {
            this._tokens.unshift(token);
          };
          return Parser3;
        }()
      );
      var isDimensionToken = function(token) {
        return token.type === 15;
      };
      var isNumberToken = function(token) {
        return token.type === 17;
      };
      var isIdentToken = function(token) {
        return token.type === 20;
      };
      var isStringToken = function(token) {
        return token.type === 0;
      };
      var isIdentWithValue = function(token, value2) {
        return isIdentToken(token) && token.value === value2;
      };
      var nonWhiteSpace = function(token) {
        return token.type !== 31;
      };
      var nonFunctionArgSeparator = function(token) {
        return token.type !== 31 && token.type !== 4;
      };
      var parseFunctionArgs = function(tokens) {
        var args = [];
        var arg = [];
        tokens.forEach(function(token) {
          if (token.type === 4) {
            if (arg.length === 0) {
              throw new Error("Error parsing function args, zero tokens for arg");
            }
            args.push(arg);
            arg = [];
            return;
          }
          if (token.type !== 31) {
            arg.push(token);
          }
        });
        if (arg.length) {
          args.push(arg);
        }
        return args;
      };
      var isEndingTokenFor = function(token, type) {
        if (type === 11 && token.type === 12) {
          return true;
        }
        if (type === 28 && token.type === 29) {
          return true;
        }
        return type === 2 && token.type === 3;
      };
      var isLength = function(token) {
        return token.type === 17 || token.type === 15;
      };
      var isLengthPercentage = function(token) {
        return token.type === 16 || isLength(token);
      };
      var parseLengthPercentageTuple = function(tokens) {
        return tokens.length > 1 ? [tokens[0], tokens[1]] : [tokens[0]];
      };
      var ZERO_LENGTH = {
        type: 17,
        number: 0,
        flags: FLAG_INTEGER
      };
      var FIFTY_PERCENT = {
        type: 16,
        number: 50,
        flags: FLAG_INTEGER
      };
      var HUNDRED_PERCENT = {
        type: 16,
        number: 100,
        flags: FLAG_INTEGER
      };
      var getAbsoluteValueForTuple = function(tuple, width, height) {
        var x3 = tuple[0], y3 = tuple[1];
        return [getAbsoluteValue(x3, width), getAbsoluteValue(typeof y3 !== "undefined" ? y3 : x3, height)];
      };
      var getAbsoluteValue = function(token, parent) {
        if (token.type === 16) {
          return token.number / 100 * parent;
        }
        if (isDimensionToken(token)) {
          switch (token.unit) {
            case "rem":
            case "em":
              return 16 * token.number;
            // TODO use correct font-size
            case "px":
            default:
              return token.number;
          }
        }
        return token.number;
      };
      var DEG = "deg";
      var GRAD = "grad";
      var RAD = "rad";
      var TURN = "turn";
      var angle = {
        name: "angle",
        parse: function(_context, value2) {
          if (value2.type === 15) {
            switch (value2.unit) {
              case DEG:
                return Math.PI * value2.number / 180;
              case GRAD:
                return Math.PI / 200 * value2.number;
              case RAD:
                return value2.number;
              case TURN:
                return Math.PI * 2 * value2.number;
            }
          }
          throw new Error("Unsupported angle type");
        }
      };
      var isAngle = function(value2) {
        if (value2.type === 15) {
          if (value2.unit === DEG || value2.unit === GRAD || value2.unit === RAD || value2.unit === TURN) {
            return true;
          }
        }
        return false;
      };
      var parseNamedSide = function(tokens) {
        var sideOrCorner = tokens.filter(isIdentToken).map(function(ident) {
          return ident.value;
        }).join(" ");
        switch (sideOrCorner) {
          case "to bottom right":
          case "to right bottom":
          case "left top":
          case "top left":
            return [ZERO_LENGTH, ZERO_LENGTH];
          case "to top":
          case "bottom":
            return deg(0);
          case "to bottom left":
          case "to left bottom":
          case "right top":
          case "top right":
            return [ZERO_LENGTH, HUNDRED_PERCENT];
          case "to right":
          case "left":
            return deg(90);
          case "to top left":
          case "to left top":
          case "right bottom":
          case "bottom right":
            return [HUNDRED_PERCENT, HUNDRED_PERCENT];
          case "to bottom":
          case "top":
            return deg(180);
          case "to top right":
          case "to right top":
          case "left bottom":
          case "bottom left":
            return [HUNDRED_PERCENT, ZERO_LENGTH];
          case "to left":
          case "right":
            return deg(270);
        }
        return 0;
      };
      var deg = function(deg2) {
        return Math.PI * deg2 / 180;
      };
      var color$1 = {
        name: "color",
        parse: function(context, value2) {
          if (value2.type === 18) {
            var colorFunction = SUPPORTED_COLOR_FUNCTIONS[value2.name];
            if (typeof colorFunction === "undefined") {
              throw new Error('Attempting to parse an unsupported color function "' + value2.name + '"');
            }
            return colorFunction(context, value2.values);
          }
          if (value2.type === 5) {
            if (value2.value.length === 3) {
              var r3 = value2.value.substring(0, 1);
              var g3 = value2.value.substring(1, 2);
              var b3 = value2.value.substring(2, 3);
              return pack(parseInt(r3 + r3, 16), parseInt(g3 + g3, 16), parseInt(b3 + b3, 16), 1);
            }
            if (value2.value.length === 4) {
              var r3 = value2.value.substring(0, 1);
              var g3 = value2.value.substring(1, 2);
              var b3 = value2.value.substring(2, 3);
              var a4 = value2.value.substring(3, 4);
              return pack(parseInt(r3 + r3, 16), parseInt(g3 + g3, 16), parseInt(b3 + b3, 16), parseInt(a4 + a4, 16) / 255);
            }
            if (value2.value.length === 6) {
              var r3 = value2.value.substring(0, 2);
              var g3 = value2.value.substring(2, 4);
              var b3 = value2.value.substring(4, 6);
              return pack(parseInt(r3, 16), parseInt(g3, 16), parseInt(b3, 16), 1);
            }
            if (value2.value.length === 8) {
              var r3 = value2.value.substring(0, 2);
              var g3 = value2.value.substring(2, 4);
              var b3 = value2.value.substring(4, 6);
              var a4 = value2.value.substring(6, 8);
              return pack(parseInt(r3, 16), parseInt(g3, 16), parseInt(b3, 16), parseInt(a4, 16) / 255);
            }
          }
          if (value2.type === 20) {
            var namedColor = COLORS[value2.value.toUpperCase()];
            if (typeof namedColor !== "undefined") {
              return namedColor;
            }
          }
          return COLORS.TRANSPARENT;
        }
      };
      var isTransparent = function(color2) {
        return (255 & color2) === 0;
      };
      var asString = function(color2) {
        var alpha = 255 & color2;
        var blue = 255 & color2 >> 8;
        var green = 255 & color2 >> 16;
        var red = 255 & color2 >> 24;
        return alpha < 255 ? "rgba(" + red + "," + green + "," + blue + "," + alpha / 255 + ")" : "rgb(" + red + "," + green + "," + blue + ")";
      };
      var pack = function(r3, g3, b3, a4) {
        return (r3 << 24 | g3 << 16 | b3 << 8 | Math.round(a4 * 255) << 0) >>> 0;
      };
      var getTokenColorValue = function(token, i4) {
        if (token.type === 17) {
          return token.number;
        }
        if (token.type === 16) {
          var max3 = i4 === 3 ? 1 : 255;
          return i4 === 3 ? token.number / 100 * max3 : Math.round(token.number / 100 * max3);
        }
        return 0;
      };
      var rgb = function(_context, args) {
        var tokens = args.filter(nonFunctionArgSeparator);
        if (tokens.length === 3) {
          var _a = tokens.map(getTokenColorValue), r3 = _a[0], g3 = _a[1], b3 = _a[2];
          return pack(r3, g3, b3, 1);
        }
        if (tokens.length === 4) {
          var _b = tokens.map(getTokenColorValue), r3 = _b[0], g3 = _b[1], b3 = _b[2], a4 = _b[3];
          return pack(r3, g3, b3, a4);
        }
        return 0;
      };
      function hue2rgb(t1, t2, hue) {
        if (hue < 0) {
          hue += 1;
        }
        if (hue >= 1) {
          hue -= 1;
        }
        if (hue < 1 / 6) {
          return (t2 - t1) * hue * 6 + t1;
        } else if (hue < 1 / 2) {
          return t2;
        } else if (hue < 2 / 3) {
          return (t2 - t1) * 6 * (2 / 3 - hue) + t1;
        } else {
          return t1;
        }
      }
      var hsl = function(context, args) {
        var tokens = args.filter(nonFunctionArgSeparator);
        var hue = tokens[0], saturation = tokens[1], lightness = tokens[2], alpha = tokens[3];
        var h3 = (hue.type === 17 ? deg(hue.number) : angle.parse(context, hue)) / (Math.PI * 2);
        var s3 = isLengthPercentage(saturation) ? saturation.number / 100 : 0;
        var l3 = isLengthPercentage(lightness) ? lightness.number / 100 : 0;
        var a4 = typeof alpha !== "undefined" && isLengthPercentage(alpha) ? getAbsoluteValue(alpha, 1) : 1;
        if (s3 === 0) {
          return pack(l3 * 255, l3 * 255, l3 * 255, 1);
        }
        var t2 = l3 <= 0.5 ? l3 * (s3 + 1) : l3 + s3 - l3 * s3;
        var t1 = l3 * 2 - t2;
        var r3 = hue2rgb(t1, t2, h3 + 1 / 3);
        var g3 = hue2rgb(t1, t2, h3);
        var b3 = hue2rgb(t1, t2, h3 - 1 / 3);
        return pack(r3 * 255, g3 * 255, b3 * 255, a4);
      };
      var SUPPORTED_COLOR_FUNCTIONS = {
        hsl,
        hsla: hsl,
        rgb,
        rgba: rgb
      };
      var parseColor = function(context, value2) {
        return color$1.parse(context, Parser2.create(value2).parseComponentValue());
      };
      var COLORS = {
        ALICEBLUE: 4042850303,
        ANTIQUEWHITE: 4209760255,
        AQUA: 16777215,
        AQUAMARINE: 2147472639,
        AZURE: 4043309055,
        BEIGE: 4126530815,
        BISQUE: 4293182719,
        BLACK: 255,
        BLANCHEDALMOND: 4293643775,
        BLUE: 65535,
        BLUEVIOLET: 2318131967,
        BROWN: 2771004159,
        BURLYWOOD: 3736635391,
        CADETBLUE: 1604231423,
        CHARTREUSE: 2147418367,
        CHOCOLATE: 3530104575,
        CORAL: 4286533887,
        CORNFLOWERBLUE: 1687547391,
        CORNSILK: 4294499583,
        CRIMSON: 3692313855,
        CYAN: 16777215,
        DARKBLUE: 35839,
        DARKCYAN: 9145343,
        DARKGOLDENROD: 3095837695,
        DARKGRAY: 2846468607,
        DARKGREEN: 6553855,
        DARKGREY: 2846468607,
        DARKKHAKI: 3182914559,
        DARKMAGENTA: 2332068863,
        DARKOLIVEGREEN: 1433087999,
        DARKORANGE: 4287365375,
        DARKORCHID: 2570243327,
        DARKRED: 2332033279,
        DARKSALMON: 3918953215,
        DARKSEAGREEN: 2411499519,
        DARKSLATEBLUE: 1211993087,
        DARKSLATEGRAY: 793726975,
        DARKSLATEGREY: 793726975,
        DARKTURQUOISE: 13554175,
        DARKVIOLET: 2483082239,
        DEEPPINK: 4279538687,
        DEEPSKYBLUE: 12582911,
        DIMGRAY: 1768516095,
        DIMGREY: 1768516095,
        DODGERBLUE: 512819199,
        FIREBRICK: 2988581631,
        FLORALWHITE: 4294635775,
        FORESTGREEN: 579543807,
        FUCHSIA: 4278255615,
        GAINSBORO: 3705462015,
        GHOSTWHITE: 4177068031,
        GOLD: 4292280575,
        GOLDENROD: 3668254975,
        GRAY: 2155905279,
        GREEN: 8388863,
        GREENYELLOW: 2919182335,
        GREY: 2155905279,
        HONEYDEW: 4043305215,
        HOTPINK: 4285117695,
        INDIANRED: 3445382399,
        INDIGO: 1258324735,
        IVORY: 4294963455,
        KHAKI: 4041641215,
        LAVENDER: 3873897215,
        LAVENDERBLUSH: 4293981695,
        LAWNGREEN: 2096890111,
        LEMONCHIFFON: 4294626815,
        LIGHTBLUE: 2916673279,
        LIGHTCORAL: 4034953471,
        LIGHTCYAN: 3774873599,
        LIGHTGOLDENRODYELLOW: 4210742015,
        LIGHTGRAY: 3553874943,
        LIGHTGREEN: 2431553791,
        LIGHTGREY: 3553874943,
        LIGHTPINK: 4290167295,
        LIGHTSALMON: 4288707327,
        LIGHTSEAGREEN: 548580095,
        LIGHTSKYBLUE: 2278488831,
        LIGHTSLATEGRAY: 2005441023,
        LIGHTSLATEGREY: 2005441023,
        LIGHTSTEELBLUE: 2965692159,
        LIGHTYELLOW: 4294959359,
        LIME: 16711935,
        LIMEGREEN: 852308735,
        LINEN: 4210091775,
        MAGENTA: 4278255615,
        MAROON: 2147483903,
        MEDIUMAQUAMARINE: 1724754687,
        MEDIUMBLUE: 52735,
        MEDIUMORCHID: 3126187007,
        MEDIUMPURPLE: 2473647103,
        MEDIUMSEAGREEN: 1018393087,
        MEDIUMSLATEBLUE: 2070474495,
        MEDIUMSPRINGGREEN: 16423679,
        MEDIUMTURQUOISE: 1221709055,
        MEDIUMVIOLETRED: 3340076543,
        MIDNIGHTBLUE: 421097727,
        MINTCREAM: 4127193855,
        MISTYROSE: 4293190143,
        MOCCASIN: 4293178879,
        NAVAJOWHITE: 4292783615,
        NAVY: 33023,
        OLDLACE: 4260751103,
        OLIVE: 2155872511,
        OLIVEDRAB: 1804477439,
        ORANGE: 4289003775,
        ORANGERED: 4282712319,
        ORCHID: 3664828159,
        PALEGOLDENROD: 4008225535,
        PALEGREEN: 2566625535,
        PALETURQUOISE: 2951671551,
        PALEVIOLETRED: 3681588223,
        PAPAYAWHIP: 4293907967,
        PEACHPUFF: 4292524543,
        PERU: 3448061951,
        PINK: 4290825215,
        PLUM: 3718307327,
        POWDERBLUE: 2967529215,
        PURPLE: 2147516671,
        REBECCAPURPLE: 1714657791,
        RED: 4278190335,
        ROSYBROWN: 3163525119,
        ROYALBLUE: 1097458175,
        SADDLEBROWN: 2336560127,
        SALMON: 4202722047,
        SANDYBROWN: 4104413439,
        SEAGREEN: 780883967,
        SEASHELL: 4294307583,
        SIENNA: 2689740287,
        SILVER: 3233857791,
        SKYBLUE: 2278484991,
        SLATEBLUE: 1784335871,
        SLATEGRAY: 1887473919,
        SLATEGREY: 1887473919,
        SNOW: 4294638335,
        SPRINGGREEN: 16744447,
        STEELBLUE: 1182971135,
        TAN: 3535047935,
        TEAL: 8421631,
        THISTLE: 3636451583,
        TOMATO: 4284696575,
        TRANSPARENT: 0,
        TURQUOISE: 1088475391,
        VIOLET: 4001558271,
        WHEAT: 4125012991,
        WHITE: 4294967295,
        WHITESMOKE: 4126537215,
        YELLOW: 4294902015,
        YELLOWGREEN: 2597139199
      };
      var backgroundClip = {
        name: "background-clip",
        initialValue: "border-box",
        prefix: false,
        type: 1,
        parse: function(_context, tokens) {
          return tokens.map(function(token) {
            if (isIdentToken(token)) {
              switch (token.value) {
                case "padding-box":
                  return 1;
                case "content-box":
                  return 2;
              }
            }
            return 0;
          });
        }
      };
      var backgroundColor = {
        name: "background-color",
        initialValue: "transparent",
        prefix: false,
        type: 3,
        format: "color"
      };
      var parseColorStop = function(context, args) {
        var color2 = color$1.parse(context, args[0]);
        var stop = args[1];
        return stop && isLengthPercentage(stop) ? { color: color2, stop } : { color: color2, stop: null };
      };
      var processColorStops = function(stops, lineLength) {
        var first2 = stops[0];
        var last3 = stops[stops.length - 1];
        if (first2.stop === null) {
          first2.stop = ZERO_LENGTH;
        }
        if (last3.stop === null) {
          last3.stop = HUNDRED_PERCENT;
        }
        var processStops = [];
        var previous = 0;
        for (var i4 = 0; i4 < stops.length; i4++) {
          var stop_1 = stops[i4].stop;
          if (stop_1 !== null) {
            var absoluteValue = getAbsoluteValue(stop_1, lineLength);
            if (absoluteValue > previous) {
              processStops.push(absoluteValue);
            } else {
              processStops.push(previous);
            }
            previous = absoluteValue;
          } else {
            processStops.push(null);
          }
        }
        var gapBegin = null;
        for (var i4 = 0; i4 < processStops.length; i4++) {
          var stop_2 = processStops[i4];
          if (stop_2 === null) {
            if (gapBegin === null) {
              gapBegin = i4;
            }
          } else if (gapBegin !== null) {
            var gapLength = i4 - gapBegin;
            var beforeGap = processStops[gapBegin - 1];
            var gapValue = (stop_2 - beforeGap) / (gapLength + 1);
            for (var g3 = 1; g3 <= gapLength; g3++) {
              processStops[gapBegin + g3 - 1] = gapValue * g3;
            }
            gapBegin = null;
          }
        }
        return stops.map(function(_a, i5) {
          var color2 = _a.color;
          return { color: color2, stop: Math.max(Math.min(1, processStops[i5] / lineLength), 0) };
        });
      };
      var getAngleFromCorner = function(corner, width, height) {
        var centerX = width / 2;
        var centerY = height / 2;
        var x3 = getAbsoluteValue(corner[0], width) - centerX;
        var y3 = centerY - getAbsoluteValue(corner[1], height);
        return (Math.atan2(y3, x3) + Math.PI * 2) % (Math.PI * 2);
      };
      var calculateGradientDirection = function(angle2, width, height) {
        var radian = typeof angle2 === "number" ? angle2 : getAngleFromCorner(angle2, width, height);
        var lineLength = Math.abs(width * Math.sin(radian)) + Math.abs(height * Math.cos(radian));
        var halfWidth = width / 2;
        var halfHeight = height / 2;
        var halfLineLength = lineLength / 2;
        var yDiff = Math.sin(radian - Math.PI / 2) * halfLineLength;
        var xDiff = Math.cos(radian - Math.PI / 2) * halfLineLength;
        return [lineLength, halfWidth - xDiff, halfWidth + xDiff, halfHeight - yDiff, halfHeight + yDiff];
      };
      var distance = function(a4, b3) {
        return Math.sqrt(a4 * a4 + b3 * b3);
      };
      var findCorner = function(width, height, x3, y3, closest) {
        var corners = [
          [0, 0],
          [0, height],
          [width, 0],
          [width, height]
        ];
        return corners.reduce(function(stat, corner) {
          var cx = corner[0], cy = corner[1];
          var d3 = distance(x3 - cx, y3 - cy);
          if (closest ? d3 < stat.optimumDistance : d3 > stat.optimumDistance) {
            return {
              optimumCorner: corner,
              optimumDistance: d3
            };
          }
          return stat;
        }, {
          optimumDistance: closest ? Infinity : -Infinity,
          optimumCorner: null
        }).optimumCorner;
      };
      var calculateRadius = function(gradient, x3, y3, width, height) {
        var rx = 0;
        var ry = 0;
        switch (gradient.size) {
          case 0:
            if (gradient.shape === 0) {
              rx = ry = Math.min(Math.abs(x3), Math.abs(x3 - width), Math.abs(y3), Math.abs(y3 - height));
            } else if (gradient.shape === 1) {
              rx = Math.min(Math.abs(x3), Math.abs(x3 - width));
              ry = Math.min(Math.abs(y3), Math.abs(y3 - height));
            }
            break;
          case 2:
            if (gradient.shape === 0) {
              rx = ry = Math.min(distance(x3, y3), distance(x3, y3 - height), distance(x3 - width, y3), distance(x3 - width, y3 - height));
            } else if (gradient.shape === 1) {
              var c3 = Math.min(Math.abs(y3), Math.abs(y3 - height)) / Math.min(Math.abs(x3), Math.abs(x3 - width));
              var _a = findCorner(width, height, x3, y3, true), cx = _a[0], cy = _a[1];
              rx = distance(cx - x3, (cy - y3) / c3);
              ry = c3 * rx;
            }
            break;
          case 1:
            if (gradient.shape === 0) {
              rx = ry = Math.max(Math.abs(x3), Math.abs(x3 - width), Math.abs(y3), Math.abs(y3 - height));
            } else if (gradient.shape === 1) {
              rx = Math.max(Math.abs(x3), Math.abs(x3 - width));
              ry = Math.max(Math.abs(y3), Math.abs(y3 - height));
            }
            break;
          case 3:
            if (gradient.shape === 0) {
              rx = ry = Math.max(distance(x3, y3), distance(x3, y3 - height), distance(x3 - width, y3), distance(x3 - width, y3 - height));
            } else if (gradient.shape === 1) {
              var c3 = Math.max(Math.abs(y3), Math.abs(y3 - height)) / Math.max(Math.abs(x3), Math.abs(x3 - width));
              var _b = findCorner(width, height, x3, y3, false), cx = _b[0], cy = _b[1];
              rx = distance(cx - x3, (cy - y3) / c3);
              ry = c3 * rx;
            }
            break;
        }
        if (Array.isArray(gradient.size)) {
          rx = getAbsoluteValue(gradient.size[0], width);
          ry = gradient.size.length === 2 ? getAbsoluteValue(gradient.size[1], height) : rx;
        }
        return [rx, ry];
      };
      var linearGradient = function(context, tokens) {
        var angle$1 = deg(180);
        var stops = [];
        parseFunctionArgs(tokens).forEach(function(arg, i4) {
          if (i4 === 0) {
            var firstToken = arg[0];
            if (firstToken.type === 20 && firstToken.value === "to") {
              angle$1 = parseNamedSide(arg);
              return;
            } else if (isAngle(firstToken)) {
              angle$1 = angle.parse(context, firstToken);
              return;
            }
          }
          var colorStop = parseColorStop(context, arg);
          stops.push(colorStop);
        });
        return {
          angle: angle$1,
          stops,
          type: 1
          /* LINEAR_GRADIENT */
        };
      };
      var prefixLinearGradient = function(context, tokens) {
        var angle$1 = deg(180);
        var stops = [];
        parseFunctionArgs(tokens).forEach(function(arg, i4) {
          if (i4 === 0) {
            var firstToken = arg[0];
            if (firstToken.type === 20 && ["top", "left", "right", "bottom"].indexOf(firstToken.value) !== -1) {
              angle$1 = parseNamedSide(arg);
              return;
            } else if (isAngle(firstToken)) {
              angle$1 = (angle.parse(context, firstToken) + deg(270)) % deg(360);
              return;
            }
          }
          var colorStop = parseColorStop(context, arg);
          stops.push(colorStop);
        });
        return {
          angle: angle$1,
          stops,
          type: 1
          /* LINEAR_GRADIENT */
        };
      };
      var webkitGradient = function(context, tokens) {
        var angle2 = deg(180);
        var stops = [];
        var type = 1;
        var shape = 0;
        var size4 = 3;
        var position2 = [];
        parseFunctionArgs(tokens).forEach(function(arg, i4) {
          var firstToken = arg[0];
          if (i4 === 0) {
            if (isIdentToken(firstToken) && firstToken.value === "linear") {
              type = 1;
              return;
            } else if (isIdentToken(firstToken) && firstToken.value === "radial") {
              type = 2;
              return;
            }
          }
          if (firstToken.type === 18) {
            if (firstToken.name === "from") {
              var color2 = color$1.parse(context, firstToken.values[0]);
              stops.push({ stop: ZERO_LENGTH, color: color2 });
            } else if (firstToken.name === "to") {
              var color2 = color$1.parse(context, firstToken.values[0]);
              stops.push({ stop: HUNDRED_PERCENT, color: color2 });
            } else if (firstToken.name === "color-stop") {
              var values2 = firstToken.values.filter(nonFunctionArgSeparator);
              if (values2.length === 2) {
                var color2 = color$1.parse(context, values2[1]);
                var stop_1 = values2[0];
                if (isNumberToken(stop_1)) {
                  stops.push({
                    stop: { type: 16, number: stop_1.number * 100, flags: stop_1.flags },
                    color: color2
                  });
                }
              }
            }
          }
        });
        return type === 1 ? {
          angle: (angle2 + deg(180)) % deg(360),
          stops,
          type
        } : { size: size4, shape, stops, position: position2, type };
      };
      var CLOSEST_SIDE = "closest-side";
      var FARTHEST_SIDE = "farthest-side";
      var CLOSEST_CORNER = "closest-corner";
      var FARTHEST_CORNER = "farthest-corner";
      var CIRCLE = "circle";
      var ELLIPSE = "ellipse";
      var COVER = "cover";
      var CONTAIN = "contain";
      var radialGradient = function(context, tokens) {
        var shape = 0;
        var size4 = 3;
        var stops = [];
        var position2 = [];
        parseFunctionArgs(tokens).forEach(function(arg, i4) {
          var isColorStop = true;
          if (i4 === 0) {
            var isAtPosition_1 = false;
            isColorStop = arg.reduce(function(acc, token) {
              if (isAtPosition_1) {
                if (isIdentToken(token)) {
                  switch (token.value) {
                    case "center":
                      position2.push(FIFTY_PERCENT);
                      return acc;
                    case "top":
                    case "left":
                      position2.push(ZERO_LENGTH);
                      return acc;
                    case "right":
                    case "bottom":
                      position2.push(HUNDRED_PERCENT);
                      return acc;
                  }
                } else if (isLengthPercentage(token) || isLength(token)) {
                  position2.push(token);
                }
              } else if (isIdentToken(token)) {
                switch (token.value) {
                  case CIRCLE:
                    shape = 0;
                    return false;
                  case ELLIPSE:
                    shape = 1;
                    return false;
                  case "at":
                    isAtPosition_1 = true;
                    return false;
                  case CLOSEST_SIDE:
                    size4 = 0;
                    return false;
                  case COVER:
                  case FARTHEST_SIDE:
                    size4 = 1;
                    return false;
                  case CONTAIN:
                  case CLOSEST_CORNER:
                    size4 = 2;
                    return false;
                  case FARTHEST_CORNER:
                    size4 = 3;
                    return false;
                }
              } else if (isLength(token) || isLengthPercentage(token)) {
                if (!Array.isArray(size4)) {
                  size4 = [];
                }
                size4.push(token);
                return false;
              }
              return acc;
            }, isColorStop);
          }
          if (isColorStop) {
            var colorStop = parseColorStop(context, arg);
            stops.push(colorStop);
          }
        });
        return {
          size: size4,
          shape,
          stops,
          position: position2,
          type: 2
          /* RADIAL_GRADIENT */
        };
      };
      var prefixRadialGradient = function(context, tokens) {
        var shape = 0;
        var size4 = 3;
        var stops = [];
        var position2 = [];
        parseFunctionArgs(tokens).forEach(function(arg, i4) {
          var isColorStop = true;
          if (i4 === 0) {
            isColorStop = arg.reduce(function(acc, token) {
              if (isIdentToken(token)) {
                switch (token.value) {
                  case "center":
                    position2.push(FIFTY_PERCENT);
                    return false;
                  case "top":
                  case "left":
                    position2.push(ZERO_LENGTH);
                    return false;
                  case "right":
                  case "bottom":
                    position2.push(HUNDRED_PERCENT);
                    return false;
                }
              } else if (isLengthPercentage(token) || isLength(token)) {
                position2.push(token);
                return false;
              }
              return acc;
            }, isColorStop);
          } else if (i4 === 1) {
            isColorStop = arg.reduce(function(acc, token) {
              if (isIdentToken(token)) {
                switch (token.value) {
                  case CIRCLE:
                    shape = 0;
                    return false;
                  case ELLIPSE:
                    shape = 1;
                    return false;
                  case CONTAIN:
                  case CLOSEST_SIDE:
                    size4 = 0;
                    return false;
                  case FARTHEST_SIDE:
                    size4 = 1;
                    return false;
                  case CLOSEST_CORNER:
                    size4 = 2;
                    return false;
                  case COVER:
                  case FARTHEST_CORNER:
                    size4 = 3;
                    return false;
                }
              } else if (isLength(token) || isLengthPercentage(token)) {
                if (!Array.isArray(size4)) {
                  size4 = [];
                }
                size4.push(token);
                return false;
              }
              return acc;
            }, isColorStop);
          }
          if (isColorStop) {
            var colorStop = parseColorStop(context, arg);
            stops.push(colorStop);
          }
        });
        return {
          size: size4,
          shape,
          stops,
          position: position2,
          type: 2
          /* RADIAL_GRADIENT */
        };
      };
      var isLinearGradient = function(background) {
        return background.type === 1;
      };
      var isRadialGradient = function(background) {
        return background.type === 2;
      };
      var image = {
        name: "image",
        parse: function(context, value2) {
          if (value2.type === 22) {
            var image_1 = {
              url: value2.value,
              type: 0
              /* URL */
            };
            context.cache.addImage(value2.value);
            return image_1;
          }
          if (value2.type === 18) {
            var imageFunction = SUPPORTED_IMAGE_FUNCTIONS[value2.name];
            if (typeof imageFunction === "undefined") {
              throw new Error('Attempting to parse an unsupported image function "' + value2.name + '"');
            }
            return imageFunction(context, value2.values);
          }
          throw new Error("Unsupported image type " + value2.type);
        }
      };
      function isSupportedImage(value2) {
        return !(value2.type === 20 && value2.value === "none") && (value2.type !== 18 || !!SUPPORTED_IMAGE_FUNCTIONS[value2.name]);
      }
      var SUPPORTED_IMAGE_FUNCTIONS = {
        "linear-gradient": linearGradient,
        "-moz-linear-gradient": prefixLinearGradient,
        "-ms-linear-gradient": prefixLinearGradient,
        "-o-linear-gradient": prefixLinearGradient,
        "-webkit-linear-gradient": prefixLinearGradient,
        "radial-gradient": radialGradient,
        "-moz-radial-gradient": prefixRadialGradient,
        "-ms-radial-gradient": prefixRadialGradient,
        "-o-radial-gradient": prefixRadialGradient,
        "-webkit-radial-gradient": prefixRadialGradient,
        "-webkit-gradient": webkitGradient
      };
      var backgroundImage = {
        name: "background-image",
        initialValue: "none",
        type: 1,
        prefix: false,
        parse: function(context, tokens) {
          if (tokens.length === 0) {
            return [];
          }
          var first2 = tokens[0];
          if (first2.type === 20 && first2.value === "none") {
            return [];
          }
          return tokens.filter(function(value2) {
            return nonFunctionArgSeparator(value2) && isSupportedImage(value2);
          }).map(function(value2) {
            return image.parse(context, value2);
          });
        }
      };
      var backgroundOrigin = {
        name: "background-origin",
        initialValue: "border-box",
        prefix: false,
        type: 1,
        parse: function(_context, tokens) {
          return tokens.map(function(token) {
            if (isIdentToken(token)) {
              switch (token.value) {
                case "padding-box":
                  return 1;
                case "content-box":
                  return 2;
              }
            }
            return 0;
          });
        }
      };
      var backgroundPosition = {
        name: "background-position",
        initialValue: "0% 0%",
        type: 1,
        prefix: false,
        parse: function(_context, tokens) {
          return parseFunctionArgs(tokens).map(function(values2) {
            return values2.filter(isLengthPercentage);
          }).map(parseLengthPercentageTuple);
        }
      };
      var backgroundRepeat = {
        name: "background-repeat",
        initialValue: "repeat",
        prefix: false,
        type: 1,
        parse: function(_context, tokens) {
          return parseFunctionArgs(tokens).map(function(values2) {
            return values2.filter(isIdentToken).map(function(token) {
              return token.value;
            }).join(" ");
          }).map(parseBackgroundRepeat);
        }
      };
      var parseBackgroundRepeat = function(value2) {
        switch (value2) {
          case "no-repeat":
            return 1;
          case "repeat-x":
          case "repeat no-repeat":
            return 2;
          case "repeat-y":
          case "no-repeat repeat":
            return 3;
          case "repeat":
          default:
            return 0;
        }
      };
      var BACKGROUND_SIZE;
      (function(BACKGROUND_SIZE2) {
        BACKGROUND_SIZE2["AUTO"] = "auto";
        BACKGROUND_SIZE2["CONTAIN"] = "contain";
        BACKGROUND_SIZE2["COVER"] = "cover";
      })(BACKGROUND_SIZE || (BACKGROUND_SIZE = {}));
      var backgroundSize = {
        name: "background-size",
        initialValue: "0",
        prefix: false,
        type: 1,
        parse: function(_context, tokens) {
          return parseFunctionArgs(tokens).map(function(values2) {
            return values2.filter(isBackgroundSizeInfoToken);
          });
        }
      };
      var isBackgroundSizeInfoToken = function(value2) {
        return isIdentToken(value2) || isLengthPercentage(value2);
      };
      var borderColorForSide = function(side) {
        return {
          name: "border-" + side + "-color",
          initialValue: "transparent",
          prefix: false,
          type: 3,
          format: "color"
        };
      };
      var borderTopColor = borderColorForSide("top");
      var borderRightColor = borderColorForSide("right");
      var borderBottomColor = borderColorForSide("bottom");
      var borderLeftColor = borderColorForSide("left");
      var borderRadiusForSide = function(side) {
        return {
          name: "border-radius-" + side,
          initialValue: "0 0",
          prefix: false,
          type: 1,
          parse: function(_context, tokens) {
            return parseLengthPercentageTuple(tokens.filter(isLengthPercentage));
          }
        };
      };
      var borderTopLeftRadius = borderRadiusForSide("top-left");
      var borderTopRightRadius = borderRadiusForSide("top-right");
      var borderBottomRightRadius = borderRadiusForSide("bottom-right");
      var borderBottomLeftRadius = borderRadiusForSide("bottom-left");
      var borderStyleForSide = function(side) {
        return {
          name: "border-" + side + "-style",
          initialValue: "solid",
          prefix: false,
          type: 2,
          parse: function(_context, style3) {
            switch (style3) {
              case "none":
                return 0;
              case "dashed":
                return 2;
              case "dotted":
                return 3;
              case "double":
                return 4;
            }
            return 1;
          }
        };
      };
      var borderTopStyle = borderStyleForSide("top");
      var borderRightStyle = borderStyleForSide("right");
      var borderBottomStyle = borderStyleForSide("bottom");
      var borderLeftStyle = borderStyleForSide("left");
      var borderWidthForSide = function(side) {
        return {
          name: "border-" + side + "-width",
          initialValue: "0",
          type: 0,
          prefix: false,
          parse: function(_context, token) {
            if (isDimensionToken(token)) {
              return token.number;
            }
            return 0;
          }
        };
      };
      var borderTopWidth = borderWidthForSide("top");
      var borderRightWidth = borderWidthForSide("right");
      var borderBottomWidth = borderWidthForSide("bottom");
      var borderLeftWidth = borderWidthForSide("left");
      var color = {
        name: "color",
        initialValue: "transparent",
        prefix: false,
        type: 3,
        format: "color"
      };
      var direction = {
        name: "direction",
        initialValue: "ltr",
        prefix: false,
        type: 2,
        parse: function(_context, direction2) {
          switch (direction2) {
            case "rtl":
              return 1;
            case "ltr":
            default:
              return 0;
          }
        }
      };
      var display = {
        name: "display",
        initialValue: "inline-block",
        prefix: false,
        type: 1,
        parse: function(_context, tokens) {
          return tokens.filter(isIdentToken).reduce(
            function(bit, token) {
              return bit | parseDisplayValue(token.value);
            },
            0
            /* NONE */
          );
        }
      };
      var parseDisplayValue = function(display2) {
        switch (display2) {
          case "block":
          case "-webkit-box":
            return 2;
          case "inline":
            return 4;
          case "run-in":
            return 8;
          case "flow":
            return 16;
          case "flow-root":
            return 32;
          case "table":
            return 64;
          case "flex":
          case "-webkit-flex":
            return 128;
          case "grid":
          case "-ms-grid":
            return 256;
          case "ruby":
            return 512;
          case "subgrid":
            return 1024;
          case "list-item":
            return 2048;
          case "table-row-group":
            return 4096;
          case "table-header-group":
            return 8192;
          case "table-footer-group":
            return 16384;
          case "table-row":
            return 32768;
          case "table-cell":
            return 65536;
          case "table-column-group":
            return 131072;
          case "table-column":
            return 262144;
          case "table-caption":
            return 524288;
          case "ruby-base":
            return 1048576;
          case "ruby-text":
            return 2097152;
          case "ruby-base-container":
            return 4194304;
          case "ruby-text-container":
            return 8388608;
          case "contents":
            return 16777216;
          case "inline-block":
            return 33554432;
          case "inline-list-item":
            return 67108864;
          case "inline-table":
            return 134217728;
          case "inline-flex":
            return 268435456;
          case "inline-grid":
            return 536870912;
        }
        return 0;
      };
      var float = {
        name: "float",
        initialValue: "none",
        prefix: false,
        type: 2,
        parse: function(_context, float2) {
          switch (float2) {
            case "left":
              return 1;
            case "right":
              return 2;
            case "inline-start":
              return 3;
            case "inline-end":
              return 4;
          }
          return 0;
        }
      };
      var letterSpacing = {
        name: "letter-spacing",
        initialValue: "0",
        prefix: false,
        type: 0,
        parse: function(_context, token) {
          if (token.type === 20 && token.value === "normal") {
            return 0;
          }
          if (token.type === 17) {
            return token.number;
          }
          if (token.type === 15) {
            return token.number;
          }
          return 0;
        }
      };
      var LINE_BREAK;
      (function(LINE_BREAK2) {
        LINE_BREAK2["NORMAL"] = "normal";
        LINE_BREAK2["STRICT"] = "strict";
      })(LINE_BREAK || (LINE_BREAK = {}));
      var lineBreak = {
        name: "line-break",
        initialValue: "normal",
        prefix: false,
        type: 2,
        parse: function(_context, lineBreak2) {
          switch (lineBreak2) {
            case "strict":
              return LINE_BREAK.STRICT;
            case "normal":
            default:
              return LINE_BREAK.NORMAL;
          }
        }
      };
      var lineHeight = {
        name: "line-height",
        initialValue: "normal",
        prefix: false,
        type: 4
        /* TOKEN_VALUE */
      };
      var computeLineHeight = function(token, fontSize2) {
        if (isIdentToken(token) && token.value === "normal") {
          return 1.2 * fontSize2;
        } else if (token.type === 17) {
          return fontSize2 * token.number;
        } else if (isLengthPercentage(token)) {
          return getAbsoluteValue(token, fontSize2);
        }
        return fontSize2;
      };
      var listStyleImage = {
        name: "list-style-image",
        initialValue: "none",
        type: 0,
        prefix: false,
        parse: function(context, token) {
          if (token.type === 20 && token.value === "none") {
            return null;
          }
          return image.parse(context, token);
        }
      };
      var listStylePosition = {
        name: "list-style-position",
        initialValue: "outside",
        prefix: false,
        type: 2,
        parse: function(_context, position2) {
          switch (position2) {
            case "inside":
              return 0;
            case "outside":
            default:
              return 1;
          }
        }
      };
      var listStyleType = {
        name: "list-style-type",
        initialValue: "none",
        prefix: false,
        type: 2,
        parse: function(_context, type) {
          switch (type) {
            case "disc":
              return 0;
            case "circle":
              return 1;
            case "square":
              return 2;
            case "decimal":
              return 3;
            case "cjk-decimal":
              return 4;
            case "decimal-leading-zero":
              return 5;
            case "lower-roman":
              return 6;
            case "upper-roman":
              return 7;
            case "lower-greek":
              return 8;
            case "lower-alpha":
              return 9;
            case "upper-alpha":
              return 10;
            case "arabic-indic":
              return 11;
            case "armenian":
              return 12;
            case "bengali":
              return 13;
            case "cambodian":
              return 14;
            case "cjk-earthly-branch":
              return 15;
            case "cjk-heavenly-stem":
              return 16;
            case "cjk-ideographic":
              return 17;
            case "devanagari":
              return 18;
            case "ethiopic-numeric":
              return 19;
            case "georgian":
              return 20;
            case "gujarati":
              return 21;
            case "gurmukhi":
              return 22;
            case "hebrew":
              return 22;
            case "hiragana":
              return 23;
            case "hiragana-iroha":
              return 24;
            case "japanese-formal":
              return 25;
            case "japanese-informal":
              return 26;
            case "kannada":
              return 27;
            case "katakana":
              return 28;
            case "katakana-iroha":
              return 29;
            case "khmer":
              return 30;
            case "korean-hangul-formal":
              return 31;
            case "korean-hanja-formal":
              return 32;
            case "korean-hanja-informal":
              return 33;
            case "lao":
              return 34;
            case "lower-armenian":
              return 35;
            case "malayalam":
              return 36;
            case "mongolian":
              return 37;
            case "myanmar":
              return 38;
            case "oriya":
              return 39;
            case "persian":
              return 40;
            case "simp-chinese-formal":
              return 41;
            case "simp-chinese-informal":
              return 42;
            case "tamil":
              return 43;
            case "telugu":
              return 44;
            case "thai":
              return 45;
            case "tibetan":
              return 46;
            case "trad-chinese-formal":
              return 47;
            case "trad-chinese-informal":
              return 48;
            case "upper-armenian":
              return 49;
            case "disclosure-open":
              return 50;
            case "disclosure-closed":
              return 51;
            case "none":
            default:
              return -1;
          }
        }
      };
      var marginForSide = function(side) {
        return {
          name: "margin-" + side,
          initialValue: "0",
          prefix: false,
          type: 4
          /* TOKEN_VALUE */
        };
      };
      var marginTop = marginForSide("top");
      var marginRight = marginForSide("right");
      var marginBottom = marginForSide("bottom");
      var marginLeft = marginForSide("left");
      var overflow = {
        name: "overflow",
        initialValue: "visible",
        prefix: false,
        type: 1,
        parse: function(_context, tokens) {
          return tokens.filter(isIdentToken).map(function(overflow2) {
            switch (overflow2.value) {
              case "hidden":
                return 1;
              case "scroll":
                return 2;
              case "clip":
                return 3;
              case "auto":
                return 4;
              case "visible":
              default:
                return 0;
            }
          });
        }
      };
      var overflowWrap = {
        name: "overflow-wrap",
        initialValue: "normal",
        prefix: false,
        type: 2,
        parse: function(_context, overflow2) {
          switch (overflow2) {
            case "break-word":
              return "break-word";
            case "normal":
            default:
              return "normal";
          }
        }
      };
      var paddingForSide = function(side) {
        return {
          name: "padding-" + side,
          initialValue: "0",
          prefix: false,
          type: 3,
          format: "length-percentage"
        };
      };
      var paddingTop = paddingForSide("top");
      var paddingRight = paddingForSide("right");
      var paddingBottom = paddingForSide("bottom");
      var paddingLeft = paddingForSide("left");
      var textAlign = {
        name: "text-align",
        initialValue: "left",
        prefix: false,
        type: 2,
        parse: function(_context, textAlign2) {
          switch (textAlign2) {
            case "right":
              return 2;
            case "center":
            case "justify":
              return 1;
            case "left":
            default:
              return 0;
          }
        }
      };
      var position = {
        name: "position",
        initialValue: "static",
        prefix: false,
        type: 2,
        parse: function(_context, position2) {
          switch (position2) {
            case "relative":
              return 1;
            case "absolute":
              return 2;
            case "fixed":
              return 3;
            case "sticky":
              return 4;
          }
          return 0;
        }
      };
      var textShadow = {
        name: "text-shadow",
        initialValue: "none",
        type: 1,
        prefix: false,
        parse: function(context, tokens) {
          if (tokens.length === 1 && isIdentWithValue(tokens[0], "none")) {
            return [];
          }
          return parseFunctionArgs(tokens).map(function(values2) {
            var shadow = {
              color: COLORS.TRANSPARENT,
              offsetX: ZERO_LENGTH,
              offsetY: ZERO_LENGTH,
              blur: ZERO_LENGTH
            };
            var c3 = 0;
            for (var i4 = 0; i4 < values2.length; i4++) {
              var token = values2[i4];
              if (isLength(token)) {
                if (c3 === 0) {
                  shadow.offsetX = token;
                } else if (c3 === 1) {
                  shadow.offsetY = token;
                } else {
                  shadow.blur = token;
                }
                c3++;
              } else {
                shadow.color = color$1.parse(context, token);
              }
            }
            return shadow;
          });
        }
      };
      var textTransform = {
        name: "text-transform",
        initialValue: "none",
        prefix: false,
        type: 2,
        parse: function(_context, textTransform2) {
          switch (textTransform2) {
            case "uppercase":
              return 2;
            case "lowercase":
              return 1;
            case "capitalize":
              return 3;
          }
          return 0;
        }
      };
      var transform$1 = {
        name: "transform",
        initialValue: "none",
        prefix: true,
        type: 0,
        parse: function(_context, token) {
          if (token.type === 20 && token.value === "none") {
            return null;
          }
          if (token.type === 18) {
            var transformFunction = SUPPORTED_TRANSFORM_FUNCTIONS[token.name];
            if (typeof transformFunction === "undefined") {
              throw new Error('Attempting to parse an unsupported transform function "' + token.name + '"');
            }
            return transformFunction(token.values);
          }
          return null;
        }
      };
      var matrix = function(args) {
        var values2 = args.filter(function(arg) {
          return arg.type === 17;
        }).map(function(arg) {
          return arg.number;
        });
        return values2.length === 6 ? values2 : null;
      };
      var matrix3d = function(args) {
        var values2 = args.filter(function(arg) {
          return arg.type === 17;
        }).map(function(arg) {
          return arg.number;
        });
        var a1 = values2[0], b1 = values2[1];
        values2[2];
        values2[3];
        var a22 = values2[4], b22 = values2[5];
        values2[6];
        values2[7];
        values2[8];
        values2[9];
        values2[10];
        values2[11];
        var a4 = values2[12], b4 = values2[13];
        values2[14];
        values2[15];
        return values2.length === 16 ? [a1, b1, a22, b22, a4, b4] : null;
      };
      var SUPPORTED_TRANSFORM_FUNCTIONS = {
        matrix,
        matrix3d
      };
      var DEFAULT_VALUE = {
        type: 16,
        number: 50,
        flags: FLAG_INTEGER
      };
      var DEFAULT = [DEFAULT_VALUE, DEFAULT_VALUE];
      var transformOrigin = {
        name: "transform-origin",
        initialValue: "50% 50%",
        prefix: true,
        type: 1,
        parse: function(_context, tokens) {
          var origins = tokens.filter(isLengthPercentage);
          if (origins.length !== 2) {
            return DEFAULT;
          }
          return [origins[0], origins[1]];
        }
      };
      var visibility = {
        name: "visible",
        initialValue: "none",
        prefix: false,
        type: 2,
        parse: function(_context, visibility2) {
          switch (visibility2) {
            case "hidden":
              return 1;
            case "collapse":
              return 2;
            case "visible":
            default:
              return 0;
          }
        }
      };
      var WORD_BREAK;
      (function(WORD_BREAK2) {
        WORD_BREAK2["NORMAL"] = "normal";
        WORD_BREAK2["BREAK_ALL"] = "break-all";
        WORD_BREAK2["KEEP_ALL"] = "keep-all";
      })(WORD_BREAK || (WORD_BREAK = {}));
      var wordBreak = {
        name: "word-break",
        initialValue: "normal",
        prefix: false,
        type: 2,
        parse: function(_context, wordBreak2) {
          switch (wordBreak2) {
            case "break-all":
              return WORD_BREAK.BREAK_ALL;
            case "keep-all":
              return WORD_BREAK.KEEP_ALL;
            case "normal":
            default:
              return WORD_BREAK.NORMAL;
          }
        }
      };
      var zIndex = {
        name: "z-index",
        initialValue: "auto",
        prefix: false,
        type: 0,
        parse: function(_context, token) {
          if (token.type === 20) {
            return { auto: true, order: 0 };
          }
          if (isNumberToken(token)) {
            return { auto: false, order: token.number };
          }
          throw new Error("Invalid z-index number parsed");
        }
      };
      var time3 = {
        name: "time",
        parse: function(_context, value2) {
          if (value2.type === 15) {
            switch (value2.unit.toLowerCase()) {
              case "s":
                return 1e3 * value2.number;
              case "ms":
                return value2.number;
            }
          }
          throw new Error("Unsupported time type");
        }
      };
      var opacity = {
        name: "opacity",
        initialValue: "1",
        type: 0,
        prefix: false,
        parse: function(_context, token) {
          if (isNumberToken(token)) {
            return token.number;
          }
          return 1;
        }
      };
      var textDecorationColor = {
        name: "text-decoration-color",
        initialValue: "transparent",
        prefix: false,
        type: 3,
        format: "color"
      };
      var textDecorationLine = {
        name: "text-decoration-line",
        initialValue: "none",
        prefix: false,
        type: 1,
        parse: function(_context, tokens) {
          return tokens.filter(isIdentToken).map(function(token) {
            switch (token.value) {
              case "underline":
                return 1;
              case "overline":
                return 2;
              case "line-through":
                return 3;
              case "none":
                return 4;
            }
            return 0;
          }).filter(function(line) {
            return line !== 0;
          });
        }
      };
      var fontFamily = {
        name: "font-family",
        initialValue: "",
        prefix: false,
        type: 1,
        parse: function(_context, tokens) {
          var accumulator = [];
          var results2 = [];
          tokens.forEach(function(token) {
            switch (token.type) {
              case 20:
              case 0:
                accumulator.push(token.value);
                break;
              case 17:
                accumulator.push(token.number.toString());
                break;
              case 4:
                results2.push(accumulator.join(" "));
                accumulator.length = 0;
                break;
            }
          });
          if (accumulator.length) {
            results2.push(accumulator.join(" "));
          }
          return results2.map(function(result2) {
            return result2.indexOf(" ") === -1 ? result2 : "'" + result2 + "'";
          });
        }
      };
      var fontSize = {
        name: "font-size",
        initialValue: "0",
        prefix: false,
        type: 3,
        format: "length"
      };
      var fontWeight = {
        name: "font-weight",
        initialValue: "normal",
        type: 0,
        prefix: false,
        parse: function(_context, token) {
          if (isNumberToken(token)) {
            return token.number;
          }
          if (isIdentToken(token)) {
            switch (token.value) {
              case "bold":
                return 700;
              case "normal":
              default:
                return 400;
            }
          }
          return 400;
        }
      };
      var fontVariant = {
        name: "font-variant",
        initialValue: "none",
        type: 1,
        prefix: false,
        parse: function(_context, tokens) {
          return tokens.filter(isIdentToken).map(function(token) {
            return token.value;
          });
        }
      };
      var fontStyle = {
        name: "font-style",
        initialValue: "normal",
        prefix: false,
        type: 2,
        parse: function(_context, overflow2) {
          switch (overflow2) {
            case "oblique":
              return "oblique";
            case "italic":
              return "italic";
            case "normal":
            default:
              return "normal";
          }
        }
      };
      var contains3 = function(bit, value2) {
        return (bit & value2) !== 0;
      };
      var content = {
        name: "content",
        initialValue: "none",
        type: 1,
        prefix: false,
        parse: function(_context, tokens) {
          if (tokens.length === 0) {
            return [];
          }
          var first2 = tokens[0];
          if (first2.type === 20 && first2.value === "none") {
            return [];
          }
          return tokens;
        }
      };
      var counterIncrement = {
        name: "counter-increment",
        initialValue: "none",
        prefix: true,
        type: 1,
        parse: function(_context, tokens) {
          if (tokens.length === 0) {
            return null;
          }
          var first2 = tokens[0];
          if (first2.type === 20 && first2.value === "none") {
            return null;
          }
          var increments = [];
          var filtered = tokens.filter(nonWhiteSpace);
          for (var i4 = 0; i4 < filtered.length; i4++) {
            var counter2 = filtered[i4];
            var next2 = filtered[i4 + 1];
            if (counter2.type === 20) {
              var increment = next2 && isNumberToken(next2) ? next2.number : 1;
              increments.push({ counter: counter2.value, increment });
            }
          }
          return increments;
        }
      };
      var counterReset = {
        name: "counter-reset",
        initialValue: "none",
        prefix: true,
        type: 1,
        parse: function(_context, tokens) {
          if (tokens.length === 0) {
            return [];
          }
          var resets = [];
          var filtered = tokens.filter(nonWhiteSpace);
          for (var i4 = 0; i4 < filtered.length; i4++) {
            var counter2 = filtered[i4];
            var next2 = filtered[i4 + 1];
            if (isIdentToken(counter2) && counter2.value !== "none") {
              var reset3 = next2 && isNumberToken(next2) ? next2.number : 0;
              resets.push({ counter: counter2.value, reset: reset3 });
            }
          }
          return resets;
        }
      };
      var duration = {
        name: "duration",
        initialValue: "0s",
        prefix: false,
        type: 1,
        parse: function(context, tokens) {
          return tokens.filter(isDimensionToken).map(function(token) {
            return time3.parse(context, token);
          });
        }
      };
      var quotes = {
        name: "quotes",
        initialValue: "none",
        prefix: true,
        type: 1,
        parse: function(_context, tokens) {
          if (tokens.length === 0) {
            return null;
          }
          var first2 = tokens[0];
          if (first2.type === 20 && first2.value === "none") {
            return null;
          }
          var quotes2 = [];
          var filtered = tokens.filter(isStringToken);
          if (filtered.length % 2 !== 0) {
            return null;
          }
          for (var i4 = 0; i4 < filtered.length; i4 += 2) {
            var open_1 = filtered[i4].value;
            var close_1 = filtered[i4 + 1].value;
            quotes2.push({ open: open_1, close: close_1 });
          }
          return quotes2;
        }
      };
      var getQuote = function(quotes2, depth2, open) {
        if (!quotes2) {
          return "";
        }
        var quote = quotes2[Math.min(depth2, quotes2.length - 1)];
        if (!quote) {
          return "";
        }
        return open ? quote.open : quote.close;
      };
      var boxShadow = {
        name: "box-shadow",
        initialValue: "none",
        type: 1,
        prefix: false,
        parse: function(context, tokens) {
          if (tokens.length === 1 && isIdentWithValue(tokens[0], "none")) {
            return [];
          }
          return parseFunctionArgs(tokens).map(function(values2) {
            var shadow = {
              color: 255,
              offsetX: ZERO_LENGTH,
              offsetY: ZERO_LENGTH,
              blur: ZERO_LENGTH,
              spread: ZERO_LENGTH,
              inset: false
            };
            var c3 = 0;
            for (var i4 = 0; i4 < values2.length; i4++) {
              var token = values2[i4];
              if (isIdentWithValue(token, "inset")) {
                shadow.inset = true;
              } else if (isLength(token)) {
                if (c3 === 0) {
                  shadow.offsetX = token;
                } else if (c3 === 1) {
                  shadow.offsetY = token;
                } else if (c3 === 2) {
                  shadow.blur = token;
                } else {
                  shadow.spread = token;
                }
                c3++;
              } else {
                shadow.color = color$1.parse(context, token);
              }
            }
            return shadow;
          });
        }
      };
      var paintOrder = {
        name: "paint-order",
        initialValue: "normal",
        prefix: false,
        type: 1,
        parse: function(_context, tokens) {
          var DEFAULT_VALUE2 = [
            0,
            1,
            2
            /* MARKERS */
          ];
          var layers = [];
          tokens.filter(isIdentToken).forEach(function(token) {
            switch (token.value) {
              case "stroke":
                layers.push(
                  1
                  /* STROKE */
                );
                break;
              case "fill":
                layers.push(
                  0
                  /* FILL */
                );
                break;
              case "markers":
                layers.push(
                  2
                  /* MARKERS */
                );
                break;
            }
          });
          DEFAULT_VALUE2.forEach(function(value2) {
            if (layers.indexOf(value2) === -1) {
              layers.push(value2);
            }
          });
          return layers;
        }
      };
      var webkitTextStrokeColor = {
        name: "-webkit-text-stroke-color",
        initialValue: "currentcolor",
        prefix: false,
        type: 3,
        format: "color"
      };
      var webkitTextStrokeWidth = {
        name: "-webkit-text-stroke-width",
        initialValue: "0",
        type: 0,
        prefix: false,
        parse: function(_context, token) {
          if (isDimensionToken(token)) {
            return token.number;
          }
          return 0;
        }
      };
      var CSSParsedDeclaration = (
        /** @class */
        function() {
          function CSSParsedDeclaration2(context, declaration) {
            var _a, _b;
            this.animationDuration = parse(context, duration, declaration.animationDuration);
            this.backgroundClip = parse(context, backgroundClip, declaration.backgroundClip);
            this.backgroundColor = parse(context, backgroundColor, declaration.backgroundColor);
            this.backgroundImage = parse(context, backgroundImage, declaration.backgroundImage);
            this.backgroundOrigin = parse(context, backgroundOrigin, declaration.backgroundOrigin);
            this.backgroundPosition = parse(context, backgroundPosition, declaration.backgroundPosition);
            this.backgroundRepeat = parse(context, backgroundRepeat, declaration.backgroundRepeat);
            this.backgroundSize = parse(context, backgroundSize, declaration.backgroundSize);
            this.borderTopColor = parse(context, borderTopColor, declaration.borderTopColor);
            this.borderRightColor = parse(context, borderRightColor, declaration.borderRightColor);
            this.borderBottomColor = parse(context, borderBottomColor, declaration.borderBottomColor);
            this.borderLeftColor = parse(context, borderLeftColor, declaration.borderLeftColor);
            this.borderTopLeftRadius = parse(context, borderTopLeftRadius, declaration.borderTopLeftRadius);
            this.borderTopRightRadius = parse(context, borderTopRightRadius, declaration.borderTopRightRadius);
            this.borderBottomRightRadius = parse(context, borderBottomRightRadius, declaration.borderBottomRightRadius);
            this.borderBottomLeftRadius = parse(context, borderBottomLeftRadius, declaration.borderBottomLeftRadius);
            this.borderTopStyle = parse(context, borderTopStyle, declaration.borderTopStyle);
            this.borderRightStyle = parse(context, borderRightStyle, declaration.borderRightStyle);
            this.borderBottomStyle = parse(context, borderBottomStyle, declaration.borderBottomStyle);
            this.borderLeftStyle = parse(context, borderLeftStyle, declaration.borderLeftStyle);
            this.borderTopWidth = parse(context, borderTopWidth, declaration.borderTopWidth);
            this.borderRightWidth = parse(context, borderRightWidth, declaration.borderRightWidth);
            this.borderBottomWidth = parse(context, borderBottomWidth, declaration.borderBottomWidth);
            this.borderLeftWidth = parse(context, borderLeftWidth, declaration.borderLeftWidth);
            this.boxShadow = parse(context, boxShadow, declaration.boxShadow);
            this.color = parse(context, color, declaration.color);
            this.direction = parse(context, direction, declaration.direction);
            this.display = parse(context, display, declaration.display);
            this.float = parse(context, float, declaration.cssFloat);
            this.fontFamily = parse(context, fontFamily, declaration.fontFamily);
            this.fontSize = parse(context, fontSize, declaration.fontSize);
            this.fontStyle = parse(context, fontStyle, declaration.fontStyle);
            this.fontVariant = parse(context, fontVariant, declaration.fontVariant);
            this.fontWeight = parse(context, fontWeight, declaration.fontWeight);
            this.letterSpacing = parse(context, letterSpacing, declaration.letterSpacing);
            this.lineBreak = parse(context, lineBreak, declaration.lineBreak);
            this.lineHeight = parse(context, lineHeight, declaration.lineHeight);
            this.listStyleImage = parse(context, listStyleImage, declaration.listStyleImage);
            this.listStylePosition = parse(context, listStylePosition, declaration.listStylePosition);
            this.listStyleType = parse(context, listStyleType, declaration.listStyleType);
            this.marginTop = parse(context, marginTop, declaration.marginTop);
            this.marginRight = parse(context, marginRight, declaration.marginRight);
            this.marginBottom = parse(context, marginBottom, declaration.marginBottom);
            this.marginLeft = parse(context, marginLeft, declaration.marginLeft);
            this.opacity = parse(context, opacity, declaration.opacity);
            var overflowTuple = parse(context, overflow, declaration.overflow);
            this.overflowX = overflowTuple[0];
            this.overflowY = overflowTuple[overflowTuple.length > 1 ? 1 : 0];
            this.overflowWrap = parse(context, overflowWrap, declaration.overflowWrap);
            this.paddingTop = parse(context, paddingTop, declaration.paddingTop);
            this.paddingRight = parse(context, paddingRight, declaration.paddingRight);
            this.paddingBottom = parse(context, paddingBottom, declaration.paddingBottom);
            this.paddingLeft = parse(context, paddingLeft, declaration.paddingLeft);
            this.paintOrder = parse(context, paintOrder, declaration.paintOrder);
            this.position = parse(context, position, declaration.position);
            this.textAlign = parse(context, textAlign, declaration.textAlign);
            this.textDecorationColor = parse(context, textDecorationColor, (_a = declaration.textDecorationColor) !== null && _a !== void 0 ? _a : declaration.color);
            this.textDecorationLine = parse(context, textDecorationLine, (_b = declaration.textDecorationLine) !== null && _b !== void 0 ? _b : declaration.textDecoration);
            this.textShadow = parse(context, textShadow, declaration.textShadow);
            this.textTransform = parse(context, textTransform, declaration.textTransform);
            this.transform = parse(context, transform$1, declaration.transform);
            this.transformOrigin = parse(context, transformOrigin, declaration.transformOrigin);
            this.visibility = parse(context, visibility, declaration.visibility);
            this.webkitTextStrokeColor = parse(context, webkitTextStrokeColor, declaration.webkitTextStrokeColor);
            this.webkitTextStrokeWidth = parse(context, webkitTextStrokeWidth, declaration.webkitTextStrokeWidth);
            this.wordBreak = parse(context, wordBreak, declaration.wordBreak);
            this.zIndex = parse(context, zIndex, declaration.zIndex);
          }
          CSSParsedDeclaration2.prototype.isVisible = function() {
            return this.display > 0 && this.opacity > 0 && this.visibility === 0;
          };
          CSSParsedDeclaration2.prototype.isTransparent = function() {
            return isTransparent(this.backgroundColor);
          };
          CSSParsedDeclaration2.prototype.isTransformed = function() {
            return this.transform !== null;
          };
          CSSParsedDeclaration2.prototype.isPositioned = function() {
            return this.position !== 0;
          };
          CSSParsedDeclaration2.prototype.isPositionedWithZIndex = function() {
            return this.isPositioned() && !this.zIndex.auto;
          };
          CSSParsedDeclaration2.prototype.isFloating = function() {
            return this.float !== 0;
          };
          CSSParsedDeclaration2.prototype.isInlineLevel = function() {
            return contains3(
              this.display,
              4
              /* INLINE */
            ) || contains3(
              this.display,
              33554432
              /* INLINE_BLOCK */
            ) || contains3(
              this.display,
              268435456
              /* INLINE_FLEX */
            ) || contains3(
              this.display,
              536870912
              /* INLINE_GRID */
            ) || contains3(
              this.display,
              67108864
              /* INLINE_LIST_ITEM */
            ) || contains3(
              this.display,
              134217728
              /* INLINE_TABLE */
            );
          };
          return CSSParsedDeclaration2;
        }()
      );
      var CSSParsedPseudoDeclaration = (
        /** @class */
        /* @__PURE__ */ function() {
          function CSSParsedPseudoDeclaration2(context, declaration) {
            this.content = parse(context, content, declaration.content);
            this.quotes = parse(context, quotes, declaration.quotes);
          }
          return CSSParsedPseudoDeclaration2;
        }()
      );
      var CSSParsedCounterDeclaration = (
        /** @class */
        /* @__PURE__ */ function() {
          function CSSParsedCounterDeclaration2(context, declaration) {
            this.counterIncrement = parse(context, counterIncrement, declaration.counterIncrement);
            this.counterReset = parse(context, counterReset, declaration.counterReset);
          }
          return CSSParsedCounterDeclaration2;
        }()
      );
      var parse = function(context, descriptor, style3) {
        var tokenizer = new Tokenizer2();
        var value2 = style3 !== null && typeof style3 !== "undefined" ? style3.toString() : descriptor.initialValue;
        tokenizer.write(value2);
        var parser2 = new Parser2(tokenizer.read());
        switch (descriptor.type) {
          case 2:
            var token = parser2.parseComponentValue();
            return descriptor.parse(context, isIdentToken(token) ? token.value : descriptor.initialValue);
          case 0:
            return descriptor.parse(context, parser2.parseComponentValue());
          case 1:
            return descriptor.parse(context, parser2.parseComponentValues());
          case 4:
            return parser2.parseComponentValue();
          case 3:
            switch (descriptor.format) {
              case "angle":
                return angle.parse(context, parser2.parseComponentValue());
              case "color":
                return color$1.parse(context, parser2.parseComponentValue());
              case "image":
                return image.parse(context, parser2.parseComponentValue());
              case "length":
                var length_1 = parser2.parseComponentValue();
                return isLength(length_1) ? length_1 : ZERO_LENGTH;
              case "length-percentage":
                var value_1 = parser2.parseComponentValue();
                return isLengthPercentage(value_1) ? value_1 : ZERO_LENGTH;
              case "time":
                return time3.parse(context, parser2.parseComponentValue());
            }
            break;
        }
      };
      var elementDebuggerAttribute = "data-html2canvas-debug";
      var getElementDebugType = function(element) {
        var attribute = element.getAttribute(elementDebuggerAttribute);
        switch (attribute) {
          case "all":
            return 1;
          case "clone":
            return 2;
          case "parse":
            return 3;
          case "render":
            return 4;
          default:
            return 0;
        }
      };
      var isDebugging = function(element, type) {
        var elementType = getElementDebugType(element);
        return elementType === 1 || type === elementType;
      };
      var ElementContainer = (
        /** @class */
        /* @__PURE__ */ function() {
          function ElementContainer2(context, element) {
            this.context = context;
            this.textNodes = [];
            this.elements = [];
            this.flags = 0;
            if (isDebugging(
              element,
              3
              /* PARSE */
            )) {
              debugger;
            }
            this.styles = new CSSParsedDeclaration(context, window.getComputedStyle(element, null));
            if (isHTMLElementNode(element)) {
              if (this.styles.animationDuration.some(function(duration2) {
                return duration2 > 0;
              })) {
                element.style.animationDuration = "0s";
              }
              if (this.styles.transform !== null) {
                element.style.transform = "none";
              }
            }
            this.bounds = parseBounds(this.context, element);
            if (isDebugging(
              element,
              4
              /* RENDER */
            )) {
              this.flags |= 16;
            }
          }
          return ElementContainer2;
        }()
      );
      var base64 = "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";
      var chars$1 = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
      var lookup$1 = typeof Uint8Array === "undefined" ? [] : new Uint8Array(256);
      for (var i$1 = 0; i$1 < chars$1.length; i$1++) {
        lookup$1[chars$1.charCodeAt(i$1)] = i$1;
      }
      var decode = function(base642) {
        var bufferLength = base642.length * 0.75, len = base642.length, i4, p3 = 0, encoded1, encoded2, encoded3, encoded4;
        if (base642[base642.length - 1] === "=") {
          bufferLength--;
          if (base642[base642.length - 2] === "=") {
            bufferLength--;
          }
        }
        var buffer = typeof ArrayBuffer !== "undefined" && typeof Uint8Array !== "undefined" && typeof Uint8Array.prototype.slice !== "undefined" ? new ArrayBuffer(bufferLength) : new Array(bufferLength);
        var bytes = Array.isArray(buffer) ? buffer : new Uint8Array(buffer);
        for (i4 = 0; i4 < len; i4 += 4) {
          encoded1 = lookup$1[base642.charCodeAt(i4)];
          encoded2 = lookup$1[base642.charCodeAt(i4 + 1)];
          encoded3 = lookup$1[base642.charCodeAt(i4 + 2)];
          encoded4 = lookup$1[base642.charCodeAt(i4 + 3)];
          bytes[p3++] = encoded1 << 2 | encoded2 >> 4;
          bytes[p3++] = (encoded2 & 15) << 4 | encoded3 >> 2;
          bytes[p3++] = (encoded3 & 3) << 6 | encoded4 & 63;
        }
        return buffer;
      };
      var polyUint16Array = function(buffer) {
        var length = buffer.length;
        var bytes = [];
        for (var i4 = 0; i4 < length; i4 += 2) {
          bytes.push(buffer[i4 + 1] << 8 | buffer[i4]);
        }
        return bytes;
      };
      var polyUint32Array = function(buffer) {
        var length = buffer.length;
        var bytes = [];
        for (var i4 = 0; i4 < length; i4 += 4) {
          bytes.push(buffer[i4 + 3] << 24 | buffer[i4 + 2] << 16 | buffer[i4 + 1] << 8 | buffer[i4]);
        }
        return bytes;
      };
      var UTRIE2_SHIFT_2 = 5;
      var UTRIE2_SHIFT_1 = 6 + 5;
      var UTRIE2_INDEX_SHIFT = 2;
      var UTRIE2_SHIFT_1_2 = UTRIE2_SHIFT_1 - UTRIE2_SHIFT_2;
      var UTRIE2_LSCP_INDEX_2_OFFSET = 65536 >> UTRIE2_SHIFT_2;
      var UTRIE2_DATA_BLOCK_LENGTH = 1 << UTRIE2_SHIFT_2;
      var UTRIE2_DATA_MASK = UTRIE2_DATA_BLOCK_LENGTH - 1;
      var UTRIE2_LSCP_INDEX_2_LENGTH = 1024 >> UTRIE2_SHIFT_2;
      var UTRIE2_INDEX_2_BMP_LENGTH = UTRIE2_LSCP_INDEX_2_OFFSET + UTRIE2_LSCP_INDEX_2_LENGTH;
      var UTRIE2_UTF8_2B_INDEX_2_OFFSET = UTRIE2_INDEX_2_BMP_LENGTH;
      var UTRIE2_UTF8_2B_INDEX_2_LENGTH = 2048 >> 6;
      var UTRIE2_INDEX_1_OFFSET = UTRIE2_UTF8_2B_INDEX_2_OFFSET + UTRIE2_UTF8_2B_INDEX_2_LENGTH;
      var UTRIE2_OMITTED_BMP_INDEX_1_LENGTH = 65536 >> UTRIE2_SHIFT_1;
      var UTRIE2_INDEX_2_BLOCK_LENGTH = 1 << UTRIE2_SHIFT_1_2;
      var UTRIE2_INDEX_2_MASK = UTRIE2_INDEX_2_BLOCK_LENGTH - 1;
      var slice16 = function(view, start, end) {
        if (view.slice) {
          return view.slice(start, end);
        }
        return new Uint16Array(Array.prototype.slice.call(view, start, end));
      };
      var slice32 = function(view, start, end) {
        if (view.slice) {
          return view.slice(start, end);
        }
        return new Uint32Array(Array.prototype.slice.call(view, start, end));
      };
      var createTrieFromBase64 = function(base642, _byteLength) {
        var buffer = decode(base642);
        var view32 = Array.isArray(buffer) ? polyUint32Array(buffer) : new Uint32Array(buffer);
        var view16 = Array.isArray(buffer) ? polyUint16Array(buffer) : new Uint16Array(buffer);
        var headerLength = 24;
        var index = slice16(view16, headerLength / 2, view32[4] / 2);
        var data2 = view32[5] === 2 ? slice16(view16, (headerLength + view32[4]) / 2) : slice32(view32, Math.ceil((headerLength + view32[4]) / 4));
        return new Trie(view32[0], view32[1], view32[2], view32[3], index, data2);
      };
      var Trie = (
        /** @class */
        function() {
          function Trie2(initialValue, errorValue, highStart, highValueIndex, index, data2) {
            this.initialValue = initialValue;
            this.errorValue = errorValue;
            this.highStart = highStart;
            this.highValueIndex = highValueIndex;
            this.index = index;
            this.data = data2;
          }
          Trie2.prototype.get = function(codePoint) {
            var ix;
            if (codePoint >= 0) {
              if (codePoint < 55296 || codePoint > 56319 && codePoint <= 65535) {
                ix = this.index[codePoint >> UTRIE2_SHIFT_2];
                ix = (ix << UTRIE2_INDEX_SHIFT) + (codePoint & UTRIE2_DATA_MASK);
                return this.data[ix];
              }
              if (codePoint <= 65535) {
                ix = this.index[UTRIE2_LSCP_INDEX_2_OFFSET + (codePoint - 55296 >> UTRIE2_SHIFT_2)];
                ix = (ix << UTRIE2_INDEX_SHIFT) + (codePoint & UTRIE2_DATA_MASK);
                return this.data[ix];
              }
              if (codePoint < this.highStart) {
                ix = UTRIE2_INDEX_1_OFFSET - UTRIE2_OMITTED_BMP_INDEX_1_LENGTH + (codePoint >> UTRIE2_SHIFT_1);
                ix = this.index[ix];
                ix += codePoint >> UTRIE2_SHIFT_2 & UTRIE2_INDEX_2_MASK;
                ix = this.index[ix];
                ix = (ix << UTRIE2_INDEX_SHIFT) + (codePoint & UTRIE2_DATA_MASK);
                return this.data[ix];
              }
              if (codePoint <= 1114111) {
                return this.data[this.highValueIndex];
              }
            }
            return this.errorValue;
          };
          return Trie2;
        }()
      );
      var chars = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
      var lookup = typeof Uint8Array === "undefined" ? [] : new Uint8Array(256);
      for (var i3 = 0; i3 < chars.length; i3++) {
        lookup[chars.charCodeAt(i3)] = i3;
      }
      var Prepend = 1;
      var CR = 2;
      var LF = 3;
      var Control = 4;
      var Extend = 5;
      var SpacingMark = 7;
      var L3 = 8;
      var V2 = 9;
      var T3 = 10;
      var LV = 11;
      var LVT = 12;
      var ZWJ = 13;
      var Extended_Pictographic = 14;
      var RI = 15;
      var toCodePoints = function(str) {
        var codePoints = [];
        var i4 = 0;
        var length = str.length;
        while (i4 < length) {
          var value2 = str.charCodeAt(i4++);
          if (value2 >= 55296 && value2 <= 56319 && i4 < length) {
            var extra = str.charCodeAt(i4++);
            if ((extra & 64512) === 56320) {
              codePoints.push(((value2 & 1023) << 10) + (extra & 1023) + 65536);
            } else {
              codePoints.push(value2);
              i4--;
            }
          } else {
            codePoints.push(value2);
          }
        }
        return codePoints;
      };
      var fromCodePoint = function() {
        var codePoints = [];
        for (var _i = 0; _i < arguments.length; _i++) {
          codePoints[_i] = arguments[_i];
        }
        if (String.fromCodePoint) {
          return String.fromCodePoint.apply(String, codePoints);
        }
        var length = codePoints.length;
        if (!length) {
          return "";
        }
        var codeUnits = [];
        var index = -1;
        var result2 = "";
        while (++index < length) {
          var codePoint = codePoints[index];
          if (codePoint <= 65535) {
            codeUnits.push(codePoint);
          } else {
            codePoint -= 65536;
            codeUnits.push((codePoint >> 10) + 55296, codePoint % 1024 + 56320);
          }
          if (index + 1 === length || codeUnits.length > 16384) {
            result2 += String.fromCharCode.apply(String, codeUnits);
            codeUnits.length = 0;
          }
        }
        return result2;
      };
      var UnicodeTrie = createTrieFromBase64(base64);
      var BREAK_NOT_ALLOWED = "\xD7";
      var BREAK_ALLOWED = "\xF7";
      var codePointToClass = function(codePoint) {
        return UnicodeTrie.get(codePoint);
      };
      var _graphemeBreakAtIndex = function(_codePoints, classTypes, index) {
        var prevIndex = index - 2;
        var prev = classTypes[prevIndex];
        var current = classTypes[index - 1];
        var next2 = classTypes[index];
        if (current === CR && next2 === LF) {
          return BREAK_NOT_ALLOWED;
        }
        if (current === CR || current === LF || current === Control) {
          return BREAK_ALLOWED;
        }
        if (next2 === CR || next2 === LF || next2 === Control) {
          return BREAK_ALLOWED;
        }
        if (current === L3 && [L3, V2, LV, LVT].indexOf(next2) !== -1) {
          return BREAK_NOT_ALLOWED;
        }
        if ((current === LV || current === V2) && (next2 === V2 || next2 === T3)) {
          return BREAK_NOT_ALLOWED;
        }
        if ((current === LVT || current === T3) && next2 === T3) {
          return BREAK_NOT_ALLOWED;
        }
        if (next2 === ZWJ || next2 === Extend) {
          return BREAK_NOT_ALLOWED;
        }
        if (next2 === SpacingMark) {
          return BREAK_NOT_ALLOWED;
        }
        if (current === Prepend) {
          return BREAK_NOT_ALLOWED;
        }
        if (current === ZWJ && next2 === Extended_Pictographic) {
          while (prev === Extend) {
            prev = classTypes[--prevIndex];
          }
          if (prev === Extended_Pictographic) {
            return BREAK_NOT_ALLOWED;
          }
        }
        if (current === RI && next2 === RI) {
          var countRI = 0;
          while (prev === RI) {
            countRI++;
            prev = classTypes[--prevIndex];
          }
          if (countRI % 2 === 0) {
            return BREAK_NOT_ALLOWED;
          }
        }
        return BREAK_ALLOWED;
      };
      var GraphemeBreaker = function(str) {
        var codePoints = toCodePoints(str);
        var length = codePoints.length;
        var index = 0;
        var lastEnd = 0;
        var classTypes = codePoints.map(codePointToClass);
        return {
          next: function() {
            if (index >= length) {
              return { done: true, value: null };
            }
            var graphemeBreak = BREAK_NOT_ALLOWED;
            while (index < length && (graphemeBreak = _graphemeBreakAtIndex(codePoints, classTypes, ++index)) === BREAK_NOT_ALLOWED) {
            }
            if (graphemeBreak !== BREAK_NOT_ALLOWED || index === length) {
              var value2 = fromCodePoint.apply(null, codePoints.slice(lastEnd, index));
              lastEnd = index;
              return { value: value2, done: false };
            }
            return { done: true, value: null };
          }
        };
      };
      var splitGraphemes = function(str) {
        var breaker = GraphemeBreaker(str);
        var graphemes = [];
        var bk;
        while (!(bk = breaker.next()).done) {
          if (bk.value) {
            graphemes.push(bk.value.slice());
          }
        }
        return graphemes;
      };
      var testRangeBounds = function(document2) {
        var TEST_HEIGHT = 123;
        if (document2.createRange) {
          var range2 = document2.createRange();
          if (range2.getBoundingClientRect) {
            var testElement = document2.createElement("boundtest");
            testElement.style.height = TEST_HEIGHT + "px";
            testElement.style.display = "block";
            document2.body.appendChild(testElement);
            range2.selectNode(testElement);
            var rangeBounds = range2.getBoundingClientRect();
            var rangeHeight = Math.round(rangeBounds.height);
            document2.body.removeChild(testElement);
            if (rangeHeight === TEST_HEIGHT) {
              return true;
            }
          }
        }
        return false;
      };
      var testIOSLineBreak = function(document2) {
        var testElement = document2.createElement("boundtest");
        testElement.style.width = "50px";
        testElement.style.display = "block";
        testElement.style.fontSize = "12px";
        testElement.style.letterSpacing = "0px";
        testElement.style.wordSpacing = "0px";
        document2.body.appendChild(testElement);
        var range2 = document2.createRange();
        testElement.innerHTML = typeof "".repeat === "function" ? "&#128104;".repeat(10) : "";
        var node = testElement.firstChild;
        var textList = toCodePoints$1(node.data).map(function(i4) {
          return fromCodePoint$1(i4);
        });
        var offset = 0;
        var prev = {};
        var supports2 = textList.every(function(text, i4) {
          range2.setStart(node, offset);
          range2.setEnd(node, offset + text.length);
          var rect = range2.getBoundingClientRect();
          offset += text.length;
          var boundAhead = rect.x > prev.x || rect.y > prev.y;
          prev = rect;
          if (i4 === 0) {
            return true;
          }
          return boundAhead;
        });
        document2.body.removeChild(testElement);
        return supports2;
      };
      var testCORS = function() {
        return typeof new Image().crossOrigin !== "undefined";
      };
      var testResponseType = function() {
        return typeof new XMLHttpRequest().responseType === "string";
      };
      var testSVG = function(document2) {
        var img = new Image();
        var canvas = document2.createElement("canvas");
        var ctx = canvas.getContext("2d");
        if (!ctx) {
          return false;
        }
        img.src = "data:image/svg+xml,<svg xmlns='http://www.w3.org/2000/svg'></svg>";
        try {
          ctx.drawImage(img, 0, 0);
          canvas.toDataURL();
        } catch (e4) {
          return false;
        }
        return true;
      };
      var isGreenPixel = function(data2) {
        return data2[0] === 0 && data2[1] === 255 && data2[2] === 0 && data2[3] === 255;
      };
      var testForeignObject = function(document2) {
        var canvas = document2.createElement("canvas");
        var size4 = 100;
        canvas.width = size4;
        canvas.height = size4;
        var ctx = canvas.getContext("2d");
        if (!ctx) {
          return Promise.reject(false);
        }
        ctx.fillStyle = "rgb(0, 255, 0)";
        ctx.fillRect(0, 0, size4, size4);
        var img = new Image();
        var greenImageSrc = canvas.toDataURL();
        img.src = greenImageSrc;
        var svg = createForeignObjectSVG(size4, size4, 0, 0, img);
        ctx.fillStyle = "red";
        ctx.fillRect(0, 0, size4, size4);
        return loadSerializedSVG$1(svg).then(function(img2) {
          ctx.drawImage(img2, 0, 0);
          var data2 = ctx.getImageData(0, 0, size4, size4).data;
          ctx.fillStyle = "red";
          ctx.fillRect(0, 0, size4, size4);
          var node = document2.createElement("div");
          node.style.backgroundImage = "url(" + greenImageSrc + ")";
          node.style.height = size4 + "px";
          return isGreenPixel(data2) ? loadSerializedSVG$1(createForeignObjectSVG(size4, size4, 0, 0, node)) : Promise.reject(false);
        }).then(function(img2) {
          ctx.drawImage(img2, 0, 0);
          return isGreenPixel(ctx.getImageData(0, 0, size4, size4).data);
        }).catch(function() {
          return false;
        });
      };
      var createForeignObjectSVG = function(width, height, x3, y3, node) {
        var xmlns = "http://www.w3.org/2000/svg";
        var svg = document.createElementNS(xmlns, "svg");
        var foreignObject = document.createElementNS(xmlns, "foreignObject");
        svg.setAttributeNS(null, "width", width.toString());
        svg.setAttributeNS(null, "height", height.toString());
        foreignObject.setAttributeNS(null, "width", "100%");
        foreignObject.setAttributeNS(null, "height", "100%");
        foreignObject.setAttributeNS(null, "x", x3.toString());
        foreignObject.setAttributeNS(null, "y", y3.toString());
        foreignObject.setAttributeNS(null, "externalResourcesRequired", "true");
        svg.appendChild(foreignObject);
        foreignObject.appendChild(node);
        return svg;
      };
      var loadSerializedSVG$1 = function(svg) {
        return new Promise(function(resolve2, reject2) {
          var img = new Image();
          img.onload = function() {
            return resolve2(img);
          };
          img.onerror = reject2;
          img.src = "data:image/svg+xml;charset=utf-8," + encodeURIComponent(new XMLSerializer().serializeToString(svg));
        });
      };
      var FEATURES = {
        get SUPPORT_RANGE_BOUNDS() {
          var value2 = testRangeBounds(document);
          Object.defineProperty(FEATURES, "SUPPORT_RANGE_BOUNDS", { value: value2 });
          return value2;
        },
        get SUPPORT_WORD_BREAKING() {
          var value2 = FEATURES.SUPPORT_RANGE_BOUNDS && testIOSLineBreak(document);
          Object.defineProperty(FEATURES, "SUPPORT_WORD_BREAKING", { value: value2 });
          return value2;
        },
        get SUPPORT_SVG_DRAWING() {
          var value2 = testSVG(document);
          Object.defineProperty(FEATURES, "SUPPORT_SVG_DRAWING", { value: value2 });
          return value2;
        },
        get SUPPORT_FOREIGNOBJECT_DRAWING() {
          var value2 = typeof Array.from === "function" && typeof window.fetch === "function" ? testForeignObject(document) : Promise.resolve(false);
          Object.defineProperty(FEATURES, "SUPPORT_FOREIGNOBJECT_DRAWING", { value: value2 });
          return value2;
        },
        get SUPPORT_CORS_IMAGES() {
          var value2 = testCORS();
          Object.defineProperty(FEATURES, "SUPPORT_CORS_IMAGES", { value: value2 });
          return value2;
        },
        get SUPPORT_RESPONSE_TYPE() {
          var value2 = testResponseType();
          Object.defineProperty(FEATURES, "SUPPORT_RESPONSE_TYPE", { value: value2 });
          return value2;
        },
        get SUPPORT_CORS_XHR() {
          var value2 = "withCredentials" in new XMLHttpRequest();
          Object.defineProperty(FEATURES, "SUPPORT_CORS_XHR", { value: value2 });
          return value2;
        },
        get SUPPORT_NATIVE_TEXT_SEGMENTATION() {
          var value2 = !!(typeof Intl !== "undefined" && Intl.Segmenter);
          Object.defineProperty(FEATURES, "SUPPORT_NATIVE_TEXT_SEGMENTATION", { value: value2 });
          return value2;
        }
      };
      var TextBounds = (
        /** @class */
        /* @__PURE__ */ function() {
          function TextBounds2(text, bounds) {
            this.text = text;
            this.bounds = bounds;
          }
          return TextBounds2;
        }()
      );
      var parseTextBounds = function(context, value2, styles, node) {
        var textList = breakText(value2, styles);
        var textBounds = [];
        var offset = 0;
        textList.forEach(function(text) {
          if (styles.textDecorationLine.length || text.trim().length > 0) {
            if (FEATURES.SUPPORT_RANGE_BOUNDS) {
              var clientRects = createRange(node, offset, text.length).getClientRects();
              if (clientRects.length > 1) {
                var subSegments = segmentGraphemes(text);
                var subOffset_1 = 0;
                subSegments.forEach(function(subSegment) {
                  textBounds.push(new TextBounds(subSegment, Bounds.fromDOMRectList(context, createRange(node, subOffset_1 + offset, subSegment.length).getClientRects())));
                  subOffset_1 += subSegment.length;
                });
              } else {
                textBounds.push(new TextBounds(text, Bounds.fromDOMRectList(context, clientRects)));
              }
            } else {
              var replacementNode = node.splitText(text.length);
              textBounds.push(new TextBounds(text, getWrapperBounds(context, node)));
              node = replacementNode;
            }
          } else if (!FEATURES.SUPPORT_RANGE_BOUNDS) {
            node = node.splitText(text.length);
          }
          offset += text.length;
        });
        return textBounds;
      };
      var getWrapperBounds = function(context, node) {
        var ownerDocument2 = node.ownerDocument;
        if (ownerDocument2) {
          var wrapper = ownerDocument2.createElement("html2canvaswrapper");
          wrapper.appendChild(node.cloneNode(true));
          var parentNode2 = node.parentNode;
          if (parentNode2) {
            parentNode2.replaceChild(wrapper, node);
            var bounds = parseBounds(context, wrapper);
            if (wrapper.firstChild) {
              parentNode2.replaceChild(wrapper.firstChild, wrapper);
            }
            return bounds;
          }
        }
        return Bounds.EMPTY;
      };
      var createRange = function(node, offset, length) {
        var ownerDocument2 = node.ownerDocument;
        if (!ownerDocument2) {
          throw new Error("Node has no owner document");
        }
        var range2 = ownerDocument2.createRange();
        range2.setStart(node, offset);
        range2.setEnd(node, offset + length);
        return range2;
      };
      var segmentGraphemes = function(value2) {
        if (FEATURES.SUPPORT_NATIVE_TEXT_SEGMENTATION) {
          var segmenter = new Intl.Segmenter(void 0, { granularity: "grapheme" });
          return Array.from(segmenter.segment(value2)).map(function(segment) {
            return segment.segment;
          });
        }
        return splitGraphemes(value2);
      };
      var segmentWords = function(value2, styles) {
        if (FEATURES.SUPPORT_NATIVE_TEXT_SEGMENTATION) {
          var segmenter = new Intl.Segmenter(void 0, {
            granularity: "word"
          });
          return Array.from(segmenter.segment(value2)).map(function(segment) {
            return segment.segment;
          });
        }
        return breakWords(value2, styles);
      };
      var breakText = function(value2, styles) {
        return styles.letterSpacing !== 0 ? segmentGraphemes(value2) : segmentWords(value2, styles);
      };
      var wordSeparators = [32, 160, 4961, 65792, 65793, 4153, 4241];
      var breakWords = function(str, styles) {
        var breaker = LineBreaker(str, {
          lineBreak: styles.lineBreak,
          wordBreak: styles.overflowWrap === "break-word" ? "break-word" : styles.wordBreak
        });
        var words = [];
        var bk;
        var _loop_1 = function() {
          if (bk.value) {
            var value2 = bk.value.slice();
            var codePoints = toCodePoints$1(value2);
            var word_1 = "";
            codePoints.forEach(function(codePoint) {
              if (wordSeparators.indexOf(codePoint) === -1) {
                word_1 += fromCodePoint$1(codePoint);
              } else {
                if (word_1.length) {
                  words.push(word_1);
                }
                words.push(fromCodePoint$1(codePoint));
                word_1 = "";
              }
            });
            if (word_1.length) {
              words.push(word_1);
            }
          }
        };
        while (!(bk = breaker.next()).done) {
          _loop_1();
        }
        return words;
      };
      var TextContainer = (
        /** @class */
        /* @__PURE__ */ function() {
          function TextContainer2(context, node, styles) {
            this.text = transform(node.data, styles.textTransform);
            this.textBounds = parseTextBounds(context, this.text, styles, node);
          }
          return TextContainer2;
        }()
      );
      var transform = function(text, transform2) {
        switch (transform2) {
          case 1:
            return text.toLowerCase();
          case 3:
            return text.replace(CAPITALIZE, capitalize2);
          case 2:
            return text.toUpperCase();
          default:
            return text;
        }
      };
      var CAPITALIZE = /(^|\s|:|-|\(|\))([a-z])/g;
      var capitalize2 = function(m3, p1, p22) {
        if (m3.length > 0) {
          return p1 + p22.toUpperCase();
        }
        return m3;
      };
      var ImageElementContainer = (
        /** @class */
        function(_super) {
          __extends(ImageElementContainer2, _super);
          function ImageElementContainer2(context, img) {
            var _this = _super.call(this, context, img) || this;
            _this.src = img.currentSrc || img.src;
            _this.intrinsicWidth = img.naturalWidth;
            _this.intrinsicHeight = img.naturalHeight;
            _this.context.cache.addImage(_this.src);
            return _this;
          }
          return ImageElementContainer2;
        }(ElementContainer)
      );
      var CanvasElementContainer = (
        /** @class */
        function(_super) {
          __extends(CanvasElementContainer2, _super);
          function CanvasElementContainer2(context, canvas) {
            var _this = _super.call(this, context, canvas) || this;
            _this.canvas = canvas;
            _this.intrinsicWidth = canvas.width;
            _this.intrinsicHeight = canvas.height;
            return _this;
          }
          return CanvasElementContainer2;
        }(ElementContainer)
      );
      var SVGElementContainer = (
        /** @class */
        function(_super) {
          __extends(SVGElementContainer2, _super);
          function SVGElementContainer2(context, img) {
            var _this = _super.call(this, context, img) || this;
            var s3 = new XMLSerializer();
            var bounds = parseBounds(context, img);
            img.setAttribute("width", bounds.width + "px");
            img.setAttribute("height", bounds.height + "px");
            _this.svg = "data:image/svg+xml," + encodeURIComponent(s3.serializeToString(img));
            _this.intrinsicWidth = img.width.baseVal.value;
            _this.intrinsicHeight = img.height.baseVal.value;
            _this.context.cache.addImage(_this.svg);
            return _this;
          }
          return SVGElementContainer2;
        }(ElementContainer)
      );
      var LIElementContainer = (
        /** @class */
        function(_super) {
          __extends(LIElementContainer2, _super);
          function LIElementContainer2(context, element) {
            var _this = _super.call(this, context, element) || this;
            _this.value = element.value;
            return _this;
          }
          return LIElementContainer2;
        }(ElementContainer)
      );
      var OLElementContainer = (
        /** @class */
        function(_super) {
          __extends(OLElementContainer2, _super);
          function OLElementContainer2(context, element) {
            var _this = _super.call(this, context, element) || this;
            _this.start = element.start;
            _this.reversed = typeof element.reversed === "boolean" && element.reversed === true;
            return _this;
          }
          return OLElementContainer2;
        }(ElementContainer)
      );
      var CHECKBOX_BORDER_RADIUS = [
        {
          type: 15,
          flags: 0,
          unit: "px",
          number: 3
        }
      ];
      var RADIO_BORDER_RADIUS = [
        {
          type: 16,
          flags: 0,
          number: 50
        }
      ];
      var reformatInputBounds = function(bounds) {
        if (bounds.width > bounds.height) {
          return new Bounds(bounds.left + (bounds.width - bounds.height) / 2, bounds.top, bounds.height, bounds.height);
        } else if (bounds.width < bounds.height) {
          return new Bounds(bounds.left, bounds.top + (bounds.height - bounds.width) / 2, bounds.width, bounds.width);
        }
        return bounds;
      };
      var getInputValue = function(node) {
        var value2 = node.type === PASSWORD ? new Array(node.value.length + 1).join("\u2022") : node.value;
        return value2.length === 0 ? node.placeholder || "" : value2;
      };
      var CHECKBOX = "checkbox";
      var RADIO = "radio";
      var PASSWORD = "password";
      var INPUT_COLOR = 707406591;
      var InputElementContainer = (
        /** @class */
        function(_super) {
          __extends(InputElementContainer2, _super);
          function InputElementContainer2(context, input) {
            var _this = _super.call(this, context, input) || this;
            _this.type = input.type.toLowerCase();
            _this.checked = input.checked;
            _this.value = getInputValue(input);
            if (_this.type === CHECKBOX || _this.type === RADIO) {
              _this.styles.backgroundColor = 3739148031;
              _this.styles.borderTopColor = _this.styles.borderRightColor = _this.styles.borderBottomColor = _this.styles.borderLeftColor = 2779096575;
              _this.styles.borderTopWidth = _this.styles.borderRightWidth = _this.styles.borderBottomWidth = _this.styles.borderLeftWidth = 1;
              _this.styles.borderTopStyle = _this.styles.borderRightStyle = _this.styles.borderBottomStyle = _this.styles.borderLeftStyle = 1;
              _this.styles.backgroundClip = [
                0
                /* BORDER_BOX */
              ];
              _this.styles.backgroundOrigin = [
                0
                /* BORDER_BOX */
              ];
              _this.bounds = reformatInputBounds(_this.bounds);
            }
            switch (_this.type) {
              case CHECKBOX:
                _this.styles.borderTopRightRadius = _this.styles.borderTopLeftRadius = _this.styles.borderBottomRightRadius = _this.styles.borderBottomLeftRadius = CHECKBOX_BORDER_RADIUS;
                break;
              case RADIO:
                _this.styles.borderTopRightRadius = _this.styles.borderTopLeftRadius = _this.styles.borderBottomRightRadius = _this.styles.borderBottomLeftRadius = RADIO_BORDER_RADIUS;
                break;
            }
            return _this;
          }
          return InputElementContainer2;
        }(ElementContainer)
      );
      var SelectElementContainer = (
        /** @class */
        function(_super) {
          __extends(SelectElementContainer2, _super);
          function SelectElementContainer2(context, element) {
            var _this = _super.call(this, context, element) || this;
            var option = element.options[element.selectedIndex || 0];
            _this.value = option ? option.text || "" : "";
            return _this;
          }
          return SelectElementContainer2;
        }(ElementContainer)
      );
      var TextareaElementContainer = (
        /** @class */
        function(_super) {
          __extends(TextareaElementContainer2, _super);
          function TextareaElementContainer2(context, element) {
            var _this = _super.call(this, context, element) || this;
            _this.value = element.value;
            return _this;
          }
          return TextareaElementContainer2;
        }(ElementContainer)
      );
      var IFrameElementContainer = (
        /** @class */
        function(_super) {
          __extends(IFrameElementContainer2, _super);
          function IFrameElementContainer2(context, iframe) {
            var _this = _super.call(this, context, iframe) || this;
            _this.src = iframe.src;
            _this.width = parseInt(iframe.width, 10) || 0;
            _this.height = parseInt(iframe.height, 10) || 0;
            _this.backgroundColor = _this.styles.backgroundColor;
            try {
              if (iframe.contentWindow && iframe.contentWindow.document && iframe.contentWindow.document.documentElement) {
                _this.tree = parseTree(context, iframe.contentWindow.document.documentElement);
                var documentBackgroundColor = iframe.contentWindow.document.documentElement ? parseColor(context, getComputedStyle(iframe.contentWindow.document.documentElement).backgroundColor) : COLORS.TRANSPARENT;
                var bodyBackgroundColor = iframe.contentWindow.document.body ? parseColor(context, getComputedStyle(iframe.contentWindow.document.body).backgroundColor) : COLORS.TRANSPARENT;
                _this.backgroundColor = isTransparent(documentBackgroundColor) ? isTransparent(bodyBackgroundColor) ? _this.styles.backgroundColor : bodyBackgroundColor : documentBackgroundColor;
              }
            } catch (e4) {
            }
            return _this;
          }
          return IFrameElementContainer2;
        }(ElementContainer)
      );
      var LIST_OWNERS = ["OL", "UL", "MENU"];
      var parseNodeTree = function(context, node, parent, root2) {
        for (var childNode = node.firstChild, nextNode = void 0; childNode; childNode = nextNode) {
          nextNode = childNode.nextSibling;
          if (isTextNode(childNode) && childNode.data.trim().length > 0) {
            parent.textNodes.push(new TextContainer(context, childNode, parent.styles));
          } else if (isElementNode(childNode)) {
            if (isSlotElement(childNode) && childNode.assignedNodes) {
              childNode.assignedNodes().forEach(function(childNode2) {
                return parseNodeTree(context, childNode2, parent, root2);
              });
            } else {
              var container = createContainer(context, childNode);
              if (container.styles.isVisible()) {
                if (createsRealStackingContext(childNode, container, root2)) {
                  container.flags |= 4;
                } else if (createsStackingContext(container.styles)) {
                  container.flags |= 2;
                }
                if (LIST_OWNERS.indexOf(childNode.tagName) !== -1) {
                  container.flags |= 8;
                }
                parent.elements.push(container);
                childNode.slot;
                if (childNode.shadowRoot) {
                  parseNodeTree(context, childNode.shadowRoot, container, root2);
                } else if (!isTextareaElement(childNode) && !isSVGElement(childNode) && !isSelectElement(childNode)) {
                  parseNodeTree(context, childNode, container, root2);
                }
              }
            }
          }
        }
      };
      var createContainer = function(context, element) {
        if (isImageElement(element)) {
          return new ImageElementContainer(context, element);
        }
        if (isCanvasElement(element)) {
          return new CanvasElementContainer(context, element);
        }
        if (isSVGElement(element)) {
          return new SVGElementContainer(context, element);
        }
        if (isLIElement(element)) {
          return new LIElementContainer(context, element);
        }
        if (isOLElement(element)) {
          return new OLElementContainer(context, element);
        }
        if (isInputElement(element)) {
          return new InputElementContainer(context, element);
        }
        if (isSelectElement(element)) {
          return new SelectElementContainer(context, element);
        }
        if (isTextareaElement(element)) {
          return new TextareaElementContainer(context, element);
        }
        if (isIFrameElement(element)) {
          return new IFrameElementContainer(context, element);
        }
        return new ElementContainer(context, element);
      };
      var parseTree = function(context, element) {
        var container = createContainer(context, element);
        container.flags |= 4;
        parseNodeTree(context, element, container, container);
        return container;
      };
      var createsRealStackingContext = function(node, container, root2) {
        return container.styles.isPositionedWithZIndex() || container.styles.opacity < 1 || container.styles.isTransformed() || isBodyElement(node) && root2.styles.isTransparent();
      };
      var createsStackingContext = function(styles) {
        return styles.isPositioned() || styles.isFloating();
      };
      var isTextNode = function(node) {
        return node.nodeType === Node.TEXT_NODE;
      };
      var isElementNode = function(node) {
        return node.nodeType === Node.ELEMENT_NODE;
      };
      var isHTMLElementNode = function(node) {
        return isElementNode(node) && typeof node.style !== "undefined" && !isSVGElementNode(node);
      };
      var isSVGElementNode = function(element) {
        return typeof element.className === "object";
      };
      var isLIElement = function(node) {
        return node.tagName === "LI";
      };
      var isOLElement = function(node) {
        return node.tagName === "OL";
      };
      var isInputElement = function(node) {
        return node.tagName === "INPUT";
      };
      var isHTMLElement = function(node) {
        return node.tagName === "HTML";
      };
      var isSVGElement = function(node) {
        return node.tagName === "svg";
      };
      var isBodyElement = function(node) {
        return node.tagName === "BODY";
      };
      var isCanvasElement = function(node) {
        return node.tagName === "CANVAS";
      };
      var isVideoElement = function(node) {
        return node.tagName === "VIDEO";
      };
      var isImageElement = function(node) {
        return node.tagName === "IMG";
      };
      var isIFrameElement = function(node) {
        return node.tagName === "IFRAME";
      };
      var isStyleElement = function(node) {
        return node.tagName === "STYLE";
      };
      var isScriptElement = function(node) {
        return node.tagName === "SCRIPT";
      };
      var isTextareaElement = function(node) {
        return node.tagName === "TEXTAREA";
      };
      var isSelectElement = function(node) {
        return node.tagName === "SELECT";
      };
      var isSlotElement = function(node) {
        return node.tagName === "SLOT";
      };
      var isCustomElement = function(node) {
        return node.tagName.indexOf("-") > 0;
      };
      var CounterState = (
        /** @class */
        function() {
          function CounterState2() {
            this.counters = {};
          }
          CounterState2.prototype.getCounterValue = function(name) {
            var counter2 = this.counters[name];
            if (counter2 && counter2.length) {
              return counter2[counter2.length - 1];
            }
            return 1;
          };
          CounterState2.prototype.getCounterValues = function(name) {
            var counter2 = this.counters[name];
            return counter2 ? counter2 : [];
          };
          CounterState2.prototype.pop = function(counters) {
            var _this = this;
            counters.forEach(function(counter2) {
              return _this.counters[counter2].pop();
            });
          };
          CounterState2.prototype.parse = function(style3) {
            var _this = this;
            var counterIncrement2 = style3.counterIncrement;
            var counterReset2 = style3.counterReset;
            var canReset = true;
            if (counterIncrement2 !== null) {
              counterIncrement2.forEach(function(entry) {
                var counter2 = _this.counters[entry.counter];
                if (counter2 && entry.increment !== 0) {
                  canReset = false;
                  if (!counter2.length) {
                    counter2.push(1);
                  }
                  counter2[Math.max(0, counter2.length - 1)] += entry.increment;
                }
              });
            }
            var counterNames = [];
            if (canReset) {
              counterReset2.forEach(function(entry) {
                var counter2 = _this.counters[entry.counter];
                counterNames.push(entry.counter);
                if (!counter2) {
                  counter2 = _this.counters[entry.counter] = [];
                }
                counter2.push(entry.reset);
              });
            }
            return counterNames;
          };
          return CounterState2;
        }()
      );
      var ROMAN_UPPER = {
        integers: [1e3, 900, 500, 400, 100, 90, 50, 40, 10, 9, 5, 4, 1],
        values: ["M", "CM", "D", "CD", "C", "XC", "L", "XL", "X", "IX", "V", "IV", "I"]
      };
      var ARMENIAN = {
        integers: [
          9e3,
          8e3,
          7e3,
          6e3,
          5e3,
          4e3,
          3e3,
          2e3,
          1e3,
          900,
          800,
          700,
          600,
          500,
          400,
          300,
          200,
          100,
          90,
          80,
          70,
          60,
          50,
          40,
          30,
          20,
          10,
          9,
          8,
          7,
          6,
          5,
          4,
          3,
          2,
          1
        ],
        values: [
          "\u0554",
          "\u0553",
          "\u0552",
          "\u0551",
          "\u0550",
          "\u054F",
          "\u054E",
          "\u054D",
          "\u054C",
          "\u054B",
          "\u054A",
          "\u0549",
          "\u0548",
          "\u0547",
          "\u0546",
          "\u0545",
          "\u0544",
          "\u0543",
          "\u0542",
          "\u0541",
          "\u0540",
          "\u053F",
          "\u053E",
          "\u053D",
          "\u053C",
          "\u053B",
          "\u053A",
          "\u0539",
          "\u0538",
          "\u0537",
          "\u0536",
          "\u0535",
          "\u0534",
          "\u0533",
          "\u0532",
          "\u0531"
        ]
      };
      var HEBREW = {
        integers: [
          1e4,
          9e3,
          8e3,
          7e3,
          6e3,
          5e3,
          4e3,
          3e3,
          2e3,
          1e3,
          400,
          300,
          200,
          100,
          90,
          80,
          70,
          60,
          50,
          40,
          30,
          20,
          19,
          18,
          17,
          16,
          15,
          10,
          9,
          8,
          7,
          6,
          5,
          4,
          3,
          2,
          1
        ],
        values: [
          "\u05D9\u05F3",
          "\u05D8\u05F3",
          "\u05D7\u05F3",
          "\u05D6\u05F3",
          "\u05D5\u05F3",
          "\u05D4\u05F3",
          "\u05D3\u05F3",
          "\u05D2\u05F3",
          "\u05D1\u05F3",
          "\u05D0\u05F3",
          "\u05EA",
          "\u05E9",
          "\u05E8",
          "\u05E7",
          "\u05E6",
          "\u05E4",
          "\u05E2",
          "\u05E1",
          "\u05E0",
          "\u05DE",
          "\u05DC",
          "\u05DB",
          "\u05D9\u05D8",
          "\u05D9\u05D7",
          "\u05D9\u05D6",
          "\u05D8\u05D6",
          "\u05D8\u05D5",
          "\u05D9",
          "\u05D8",
          "\u05D7",
          "\u05D6",
          "\u05D5",
          "\u05D4",
          "\u05D3",
          "\u05D2",
          "\u05D1",
          "\u05D0"
        ]
      };
      var GEORGIAN = {
        integers: [
          1e4,
          9e3,
          8e3,
          7e3,
          6e3,
          5e3,
          4e3,
          3e3,
          2e3,
          1e3,
          900,
          800,
          700,
          600,
          500,
          400,
          300,
          200,
          100,
          90,
          80,
          70,
          60,
          50,
          40,
          30,
          20,
          10,
          9,
          8,
          7,
          6,
          5,
          4,
          3,
          2,
          1
        ],
        values: [
          "\u10F5",
          "\u10F0",
          "\u10EF",
          "\u10F4",
          "\u10EE",
          "\u10ED",
          "\u10EC",
          "\u10EB",
          "\u10EA",
          "\u10E9",
          "\u10E8",
          "\u10E7",
          "\u10E6",
          "\u10E5",
          "\u10E4",
          "\u10F3",
          "\u10E2",
          "\u10E1",
          "\u10E0",
          "\u10DF",
          "\u10DE",
          "\u10DD",
          "\u10F2",
          "\u10DC",
          "\u10DB",
          "\u10DA",
          "\u10D9",
          "\u10D8",
          "\u10D7",
          "\u10F1",
          "\u10D6",
          "\u10D5",
          "\u10D4",
          "\u10D3",
          "\u10D2",
          "\u10D1",
          "\u10D0"
        ]
      };
      var createAdditiveCounter = function(value2, min3, max3, symbols, fallback, suffix) {
        if (value2 < min3 || value2 > max3) {
          return createCounterText(value2, fallback, suffix.length > 0);
        }
        return symbols.integers.reduce(function(string, integer, index) {
          while (value2 >= integer) {
            value2 -= integer;
            string += symbols.values[index];
          }
          return string;
        }, "") + suffix;
      };
      var createCounterStyleWithSymbolResolver = function(value2, codePointRangeLength, isNumeric, resolver) {
        var string = "";
        do {
          if (!isNumeric) {
            value2--;
          }
          string = resolver(value2) + string;
          value2 /= codePointRangeLength;
        } while (value2 * codePointRangeLength >= codePointRangeLength);
        return string;
      };
      var createCounterStyleFromRange = function(value2, codePointRangeStart, codePointRangeEnd, isNumeric, suffix) {
        var codePointRangeLength = codePointRangeEnd - codePointRangeStart + 1;
        return (value2 < 0 ? "-" : "") + (createCounterStyleWithSymbolResolver(Math.abs(value2), codePointRangeLength, isNumeric, function(codePoint) {
          return fromCodePoint$1(Math.floor(codePoint % codePointRangeLength) + codePointRangeStart);
        }) + suffix);
      };
      var createCounterStyleFromSymbols = function(value2, symbols, suffix) {
        if (suffix === void 0) {
          suffix = ". ";
        }
        var codePointRangeLength = symbols.length;
        return createCounterStyleWithSymbolResolver(Math.abs(value2), codePointRangeLength, false, function(codePoint) {
          return symbols[Math.floor(codePoint % codePointRangeLength)];
        }) + suffix;
      };
      var CJK_ZEROS = 1 << 0;
      var CJK_TEN_COEFFICIENTS = 1 << 1;
      var CJK_TEN_HIGH_COEFFICIENTS = 1 << 2;
      var CJK_HUNDRED_COEFFICIENTS = 1 << 3;
      var createCJKCounter = function(value2, numbers, multipliers, negativeSign, suffix, flags) {
        if (value2 < -9999 || value2 > 9999) {
          return createCounterText(value2, 4, suffix.length > 0);
        }
        var tmp = Math.abs(value2);
        var string = suffix;
        if (tmp === 0) {
          return numbers[0] + string;
        }
        for (var digit = 0; tmp > 0 && digit <= 4; digit++) {
          var coefficient = tmp % 10;
          if (coefficient === 0 && contains3(flags, CJK_ZEROS) && string !== "") {
            string = numbers[coefficient] + string;
          } else if (coefficient > 1 || coefficient === 1 && digit === 0 || coefficient === 1 && digit === 1 && contains3(flags, CJK_TEN_COEFFICIENTS) || coefficient === 1 && digit === 1 && contains3(flags, CJK_TEN_HIGH_COEFFICIENTS) && value2 > 100 || coefficient === 1 && digit > 1 && contains3(flags, CJK_HUNDRED_COEFFICIENTS)) {
            string = numbers[coefficient] + (digit > 0 ? multipliers[digit - 1] : "") + string;
          } else if (coefficient === 1 && digit > 0) {
            string = multipliers[digit - 1] + string;
          }
          tmp = Math.floor(tmp / 10);
        }
        return (value2 < 0 ? negativeSign : "") + string;
      };
      var CHINESE_INFORMAL_MULTIPLIERS = "\u5341\u767E\u5343\u842C";
      var CHINESE_FORMAL_MULTIPLIERS = "\u62FE\u4F70\u4EDF\u842C";
      var JAPANESE_NEGATIVE = "\u30DE\u30A4\u30CA\u30B9";
      var KOREAN_NEGATIVE = "\uB9C8\uC774\uB108\uC2A4";
      var createCounterText = function(value2, type, appendSuffix) {
        var defaultSuffix = appendSuffix ? ". " : "";
        var cjkSuffix = appendSuffix ? "\u3001" : "";
        var koreanSuffix = appendSuffix ? ", " : "";
        var spaceSuffix = appendSuffix ? " " : "";
        switch (type) {
          case 0:
            return "\u2022" + spaceSuffix;
          case 1:
            return "\u25E6" + spaceSuffix;
          case 2:
            return "\u25FE" + spaceSuffix;
          case 5:
            var string = createCounterStyleFromRange(value2, 48, 57, true, defaultSuffix);
            return string.length < 4 ? "0" + string : string;
          case 4:
            return createCounterStyleFromSymbols(value2, "\u3007\u4E00\u4E8C\u4E09\u56DB\u4E94\u516D\u4E03\u516B\u4E5D", cjkSuffix);
          case 6:
            return createAdditiveCounter(value2, 1, 3999, ROMAN_UPPER, 3, defaultSuffix).toLowerCase();
          case 7:
            return createAdditiveCounter(value2, 1, 3999, ROMAN_UPPER, 3, defaultSuffix);
          case 8:
            return createCounterStyleFromRange(value2, 945, 969, false, defaultSuffix);
          case 9:
            return createCounterStyleFromRange(value2, 97, 122, false, defaultSuffix);
          case 10:
            return createCounterStyleFromRange(value2, 65, 90, false, defaultSuffix);
          case 11:
            return createCounterStyleFromRange(value2, 1632, 1641, true, defaultSuffix);
          case 12:
          case 49:
            return createAdditiveCounter(value2, 1, 9999, ARMENIAN, 3, defaultSuffix);
          case 35:
            return createAdditiveCounter(value2, 1, 9999, ARMENIAN, 3, defaultSuffix).toLowerCase();
          case 13:
            return createCounterStyleFromRange(value2, 2534, 2543, true, defaultSuffix);
          case 14:
          case 30:
            return createCounterStyleFromRange(value2, 6112, 6121, true, defaultSuffix);
          case 15:
            return createCounterStyleFromSymbols(value2, "\u5B50\u4E11\u5BC5\u536F\u8FB0\u5DF3\u5348\u672A\u7533\u9149\u620C\u4EA5", cjkSuffix);
          case 16:
            return createCounterStyleFromSymbols(value2, "\u7532\u4E59\u4E19\u4E01\u620A\u5DF1\u5E9A\u8F9B\u58EC\u7678", cjkSuffix);
          case 17:
          case 48:
            return createCJKCounter(value2, "\u96F6\u4E00\u4E8C\u4E09\u56DB\u4E94\u516D\u4E03\u516B\u4E5D", CHINESE_INFORMAL_MULTIPLIERS, "\u8CA0", cjkSuffix, CJK_TEN_COEFFICIENTS | CJK_TEN_HIGH_COEFFICIENTS | CJK_HUNDRED_COEFFICIENTS);
          case 47:
            return createCJKCounter(value2, "\u96F6\u58F9\u8CB3\u53C3\u8086\u4F0D\u9678\u67D2\u634C\u7396", CHINESE_FORMAL_MULTIPLIERS, "\u8CA0", cjkSuffix, CJK_ZEROS | CJK_TEN_COEFFICIENTS | CJK_TEN_HIGH_COEFFICIENTS | CJK_HUNDRED_COEFFICIENTS);
          case 42:
            return createCJKCounter(value2, "\u96F6\u4E00\u4E8C\u4E09\u56DB\u4E94\u516D\u4E03\u516B\u4E5D", CHINESE_INFORMAL_MULTIPLIERS, "\u8D1F", cjkSuffix, CJK_TEN_COEFFICIENTS | CJK_TEN_HIGH_COEFFICIENTS | CJK_HUNDRED_COEFFICIENTS);
          case 41:
            return createCJKCounter(value2, "\u96F6\u58F9\u8D30\u53C1\u8086\u4F0D\u9646\u67D2\u634C\u7396", CHINESE_FORMAL_MULTIPLIERS, "\u8D1F", cjkSuffix, CJK_ZEROS | CJK_TEN_COEFFICIENTS | CJK_TEN_HIGH_COEFFICIENTS | CJK_HUNDRED_COEFFICIENTS);
          case 26:
            return createCJKCounter(value2, "\u3007\u4E00\u4E8C\u4E09\u56DB\u4E94\u516D\u4E03\u516B\u4E5D", "\u5341\u767E\u5343\u4E07", JAPANESE_NEGATIVE, cjkSuffix, 0);
          case 25:
            return createCJKCounter(value2, "\u96F6\u58F1\u5F10\u53C2\u56DB\u4F0D\u516D\u4E03\u516B\u4E5D", "\u62FE\u767E\u5343\u4E07", JAPANESE_NEGATIVE, cjkSuffix, CJK_ZEROS | CJK_TEN_COEFFICIENTS | CJK_TEN_HIGH_COEFFICIENTS);
          case 31:
            return createCJKCounter(value2, "\uC601\uC77C\uC774\uC0BC\uC0AC\uC624\uC721\uCE60\uD314\uAD6C", "\uC2ED\uBC31\uCC9C\uB9CC", KOREAN_NEGATIVE, koreanSuffix, CJK_ZEROS | CJK_TEN_COEFFICIENTS | CJK_TEN_HIGH_COEFFICIENTS);
          case 33:
            return createCJKCounter(value2, "\u96F6\u4E00\u4E8C\u4E09\u56DB\u4E94\u516D\u4E03\u516B\u4E5D", "\u5341\u767E\u5343\u842C", KOREAN_NEGATIVE, koreanSuffix, 0);
          case 32:
            return createCJKCounter(value2, "\u96F6\u58F9\u8CB3\u53C3\u56DB\u4E94\u516D\u4E03\u516B\u4E5D", "\u62FE\u767E\u5343", KOREAN_NEGATIVE, koreanSuffix, CJK_ZEROS | CJK_TEN_COEFFICIENTS | CJK_TEN_HIGH_COEFFICIENTS);
          case 18:
            return createCounterStyleFromRange(value2, 2406, 2415, true, defaultSuffix);
          case 20:
            return createAdditiveCounter(value2, 1, 19999, GEORGIAN, 3, defaultSuffix);
          case 21:
            return createCounterStyleFromRange(value2, 2790, 2799, true, defaultSuffix);
          case 22:
            return createCounterStyleFromRange(value2, 2662, 2671, true, defaultSuffix);
          case 22:
            return createAdditiveCounter(value2, 1, 10999, HEBREW, 3, defaultSuffix);
          case 23:
            return createCounterStyleFromSymbols(value2, "\u3042\u3044\u3046\u3048\u304A\u304B\u304D\u304F\u3051\u3053\u3055\u3057\u3059\u305B\u305D\u305F\u3061\u3064\u3066\u3068\u306A\u306B\u306C\u306D\u306E\u306F\u3072\u3075\u3078\u307B\u307E\u307F\u3080\u3081\u3082\u3084\u3086\u3088\u3089\u308A\u308B\u308C\u308D\u308F\u3090\u3091\u3092\u3093");
          case 24:
            return createCounterStyleFromSymbols(value2, "\u3044\u308D\u306F\u306B\u307B\u3078\u3068\u3061\u308A\u306C\u308B\u3092\u308F\u304B\u3088\u305F\u308C\u305D\u3064\u306D\u306A\u3089\u3080\u3046\u3090\u306E\u304A\u304F\u3084\u307E\u3051\u3075\u3053\u3048\u3066\u3042\u3055\u304D\u3086\u3081\u307F\u3057\u3091\u3072\u3082\u305B\u3059");
          case 27:
            return createCounterStyleFromRange(value2, 3302, 3311, true, defaultSuffix);
          case 28:
            return createCounterStyleFromSymbols(value2, "\u30A2\u30A4\u30A6\u30A8\u30AA\u30AB\u30AD\u30AF\u30B1\u30B3\u30B5\u30B7\u30B9\u30BB\u30BD\u30BF\u30C1\u30C4\u30C6\u30C8\u30CA\u30CB\u30CC\u30CD\u30CE\u30CF\u30D2\u30D5\u30D8\u30DB\u30DE\u30DF\u30E0\u30E1\u30E2\u30E4\u30E6\u30E8\u30E9\u30EA\u30EB\u30EC\u30ED\u30EF\u30F0\u30F1\u30F2\u30F3", cjkSuffix);
          case 29:
            return createCounterStyleFromSymbols(value2, "\u30A4\u30ED\u30CF\u30CB\u30DB\u30D8\u30C8\u30C1\u30EA\u30CC\u30EB\u30F2\u30EF\u30AB\u30E8\u30BF\u30EC\u30BD\u30C4\u30CD\u30CA\u30E9\u30E0\u30A6\u30F0\u30CE\u30AA\u30AF\u30E4\u30DE\u30B1\u30D5\u30B3\u30A8\u30C6\u30A2\u30B5\u30AD\u30E6\u30E1\u30DF\u30B7\u30F1\u30D2\u30E2\u30BB\u30B9", cjkSuffix);
          case 34:
            return createCounterStyleFromRange(value2, 3792, 3801, true, defaultSuffix);
          case 37:
            return createCounterStyleFromRange(value2, 6160, 6169, true, defaultSuffix);
          case 38:
            return createCounterStyleFromRange(value2, 4160, 4169, true, defaultSuffix);
          case 39:
            return createCounterStyleFromRange(value2, 2918, 2927, true, defaultSuffix);
          case 40:
            return createCounterStyleFromRange(value2, 1776, 1785, true, defaultSuffix);
          case 43:
            return createCounterStyleFromRange(value2, 3046, 3055, true, defaultSuffix);
          case 44:
            return createCounterStyleFromRange(value2, 3174, 3183, true, defaultSuffix);
          case 45:
            return createCounterStyleFromRange(value2, 3664, 3673, true, defaultSuffix);
          case 46:
            return createCounterStyleFromRange(value2, 3872, 3881, true, defaultSuffix);
          case 3:
          default:
            return createCounterStyleFromRange(value2, 48, 57, true, defaultSuffix);
        }
      };
      var IGNORE_ATTRIBUTE = "data-html2canvas-ignore";
      var DocumentCloner = (
        /** @class */
        function() {
          function DocumentCloner2(context, element, options2) {
            this.context = context;
            this.options = options2;
            this.scrolledElements = [];
            this.referenceElement = element;
            this.counters = new CounterState();
            this.quoteDepth = 0;
            if (!element.ownerDocument) {
              throw new Error("Cloned element does not have an owner document");
            }
            this.documentElement = this.cloneNode(element.ownerDocument.documentElement, false);
          }
          DocumentCloner2.prototype.toIFrame = function(ownerDocument2, windowSize) {
            var _this = this;
            var iframe = createIFrameContainer(ownerDocument2, windowSize);
            if (!iframe.contentWindow) {
              return Promise.reject("Unable to find iframe window");
            }
            var scrollX = ownerDocument2.defaultView.pageXOffset;
            var scrollY = ownerDocument2.defaultView.pageYOffset;
            var cloneWindow = iframe.contentWindow;
            var documentClone = cloneWindow.document;
            var iframeLoad = iframeLoader(iframe).then(function() {
              return __awaiter(_this, void 0, void 0, function() {
                var onclone, referenceElement;
                return __generator(this, function(_a) {
                  switch (_a.label) {
                    case 0:
                      this.scrolledElements.forEach(restoreNodeScroll);
                      if (cloneWindow) {
                        cloneWindow.scrollTo(windowSize.left, windowSize.top);
                        if (/(iPad|iPhone|iPod)/g.test(navigator.userAgent) && (cloneWindow.scrollY !== windowSize.top || cloneWindow.scrollX !== windowSize.left)) {
                          this.context.logger.warn("Unable to restore scroll position for cloned document");
                          this.context.windowBounds = this.context.windowBounds.add(cloneWindow.scrollX - windowSize.left, cloneWindow.scrollY - windowSize.top, 0, 0);
                        }
                      }
                      onclone = this.options.onclone;
                      referenceElement = this.clonedReferenceElement;
                      if (typeof referenceElement === "undefined") {
                        return [2, Promise.reject("Error finding the " + this.referenceElement.nodeName + " in the cloned document")];
                      }
                      if (!(documentClone.fonts && documentClone.fonts.ready)) return [3, 2];
                      return [4, documentClone.fonts.ready];
                    case 1:
                      _a.sent();
                      _a.label = 2;
                    case 2:
                      if (!/(AppleWebKit)/g.test(navigator.userAgent)) return [3, 4];
                      return [4, imagesReady(documentClone)];
                    case 3:
                      _a.sent();
                      _a.label = 4;
                    case 4:
                      if (typeof onclone === "function") {
                        return [2, Promise.resolve().then(function() {
                          return onclone(documentClone, referenceElement);
                        }).then(function() {
                          return iframe;
                        })];
                      }
                      return [2, iframe];
                  }
                });
              });
            });
            documentClone.open();
            documentClone.write(serializeDoctype(document.doctype) + "<html></html>");
            restoreOwnerScroll(this.referenceElement.ownerDocument, scrollX, scrollY);
            documentClone.replaceChild(documentClone.adoptNode(this.documentElement), documentClone.documentElement);
            documentClone.close();
            return iframeLoad;
          };
          DocumentCloner2.prototype.createElementClone = function(node) {
            if (isDebugging(
              node,
              2
              /* CLONE */
            )) {
              debugger;
            }
            if (isCanvasElement(node)) {
              return this.createCanvasClone(node);
            }
            if (isVideoElement(node)) {
              return this.createVideoClone(node);
            }
            if (isStyleElement(node)) {
              return this.createStyleClone(node);
            }
            var clone2 = node.cloneNode(false);
            if (isImageElement(clone2)) {
              if (isImageElement(node) && node.currentSrc && node.currentSrc !== node.src) {
                clone2.src = node.currentSrc;
                clone2.srcset = "";
              }
              if (clone2.loading === "lazy") {
                clone2.loading = "eager";
              }
            }
            if (isCustomElement(clone2)) {
              return this.createCustomElementClone(clone2);
            }
            return clone2;
          };
          DocumentCloner2.prototype.createCustomElementClone = function(node) {
            var clone2 = document.createElement("html2canvascustomelement");
            copyCSSStyles(node.style, clone2);
            return clone2;
          };
          DocumentCloner2.prototype.createStyleClone = function(node) {
            try {
              var sheet = node.sheet;
              if (sheet && sheet.cssRules) {
                var css = [].slice.call(sheet.cssRules, 0).reduce(function(css2, rule) {
                  if (rule && typeof rule.cssText === "string") {
                    return css2 + rule.cssText;
                  }
                  return css2;
                }, "");
                var style3 = node.cloneNode(false);
                style3.textContent = css;
                return style3;
              }
            } catch (e4) {
              this.context.logger.error("Unable to access cssRules property", e4);
              if (e4.name !== "SecurityError") {
                throw e4;
              }
            }
            return node.cloneNode(false);
          };
          DocumentCloner2.prototype.createCanvasClone = function(canvas) {
            var _a;
            if (this.options.inlineImages && canvas.ownerDocument) {
              var img = canvas.ownerDocument.createElement("img");
              try {
                img.src = canvas.toDataURL();
                return img;
              } catch (e4) {
                this.context.logger.info("Unable to inline canvas contents, canvas is tainted", canvas);
              }
            }
            var clonedCanvas = canvas.cloneNode(false);
            try {
              clonedCanvas.width = canvas.width;
              clonedCanvas.height = canvas.height;
              var ctx = canvas.getContext("2d");
              var clonedCtx = clonedCanvas.getContext("2d");
              if (clonedCtx) {
                if (!this.options.allowTaint && ctx) {
                  clonedCtx.putImageData(ctx.getImageData(0, 0, canvas.width, canvas.height), 0, 0);
                } else {
                  var gl = (_a = canvas.getContext("webgl2")) !== null && _a !== void 0 ? _a : canvas.getContext("webgl");
                  if (gl) {
                    var attribs = gl.getContextAttributes();
                    if ((attribs === null || attribs === void 0 ? void 0 : attribs.preserveDrawingBuffer) === false) {
                      this.context.logger.warn("Unable to clone WebGL context as it has preserveDrawingBuffer=false", canvas);
                    }
                  }
                  clonedCtx.drawImage(canvas, 0, 0);
                }
              }
              return clonedCanvas;
            } catch (e4) {
              this.context.logger.info("Unable to clone canvas as it is tainted", canvas);
            }
            return clonedCanvas;
          };
          DocumentCloner2.prototype.createVideoClone = function(video) {
            var canvas = video.ownerDocument.createElement("canvas");
            canvas.width = video.offsetWidth;
            canvas.height = video.offsetHeight;
            var ctx = canvas.getContext("2d");
            try {
              if (ctx) {
                ctx.drawImage(video, 0, 0, canvas.width, canvas.height);
                if (!this.options.allowTaint) {
                  ctx.getImageData(0, 0, canvas.width, canvas.height);
                }
              }
              return canvas;
            } catch (e4) {
              this.context.logger.info("Unable to clone video as it is tainted", video);
            }
            var blankCanvas = video.ownerDocument.createElement("canvas");
            blankCanvas.width = video.offsetWidth;
            blankCanvas.height = video.offsetHeight;
            return blankCanvas;
          };
          DocumentCloner2.prototype.appendChildNode = function(clone2, child, copyStyles2) {
            if (!isElementNode(child) || !isScriptElement(child) && !child.hasAttribute(IGNORE_ATTRIBUTE) && (typeof this.options.ignoreElements !== "function" || !this.options.ignoreElements(child))) {
              if (!this.options.copyStyles || !isElementNode(child) || !isStyleElement(child)) {
                clone2.appendChild(this.cloneNode(child, copyStyles2));
              }
            }
          };
          DocumentCloner2.prototype.cloneChildNodes = function(node, clone2, copyStyles2) {
            var _this = this;
            for (var child = node.shadowRoot ? node.shadowRoot.firstChild : node.firstChild; child; child = child.nextSibling) {
              if (isElementNode(child) && isSlotElement(child) && typeof child.assignedNodes === "function") {
                var assignedNodes = child.assignedNodes();
                if (assignedNodes.length) {
                  assignedNodes.forEach(function(assignedNode) {
                    return _this.appendChildNode(clone2, assignedNode, copyStyles2);
                  });
                }
              } else {
                this.appendChildNode(clone2, child, copyStyles2);
              }
            }
          };
          DocumentCloner2.prototype.cloneNode = function(node, copyStyles2) {
            if (isTextNode(node)) {
              return document.createTextNode(node.data);
            }
            if (!node.ownerDocument) {
              return node.cloneNode(false);
            }
            var window2 = node.ownerDocument.defaultView;
            if (window2 && isElementNode(node) && (isHTMLElementNode(node) || isSVGElementNode(node))) {
              var clone2 = this.createElementClone(node);
              clone2.style.transitionProperty = "none";
              var style3 = window2.getComputedStyle(node);
              var styleBefore = window2.getComputedStyle(node, ":before");
              var styleAfter = window2.getComputedStyle(node, ":after");
              if (this.referenceElement === node && isHTMLElementNode(clone2)) {
                this.clonedReferenceElement = clone2;
              }
              if (isBodyElement(clone2)) {
                createPseudoHideStyles(clone2);
              }
              var counters = this.counters.parse(new CSSParsedCounterDeclaration(this.context, style3));
              var before2 = this.resolvePseudoContent(node, clone2, styleBefore, PseudoElementType.BEFORE);
              if (isCustomElement(node)) {
                copyStyles2 = true;
              }
              if (!isVideoElement(node)) {
                this.cloneChildNodes(node, clone2, copyStyles2);
              }
              if (before2) {
                clone2.insertBefore(before2, clone2.firstChild);
              }
              var after2 = this.resolvePseudoContent(node, clone2, styleAfter, PseudoElementType.AFTER);
              if (after2) {
                clone2.appendChild(after2);
              }
              this.counters.pop(counters);
              if (style3 && (this.options.copyStyles || isSVGElementNode(node)) && !isIFrameElement(node) || copyStyles2) {
                copyCSSStyles(style3, clone2);
              }
              if (node.scrollTop !== 0 || node.scrollLeft !== 0) {
                this.scrolledElements.push([clone2, node.scrollLeft, node.scrollTop]);
              }
              if ((isTextareaElement(node) || isSelectElement(node)) && (isTextareaElement(clone2) || isSelectElement(clone2))) {
                clone2.value = node.value;
              }
              return clone2;
            }
            return node.cloneNode(false);
          };
          DocumentCloner2.prototype.resolvePseudoContent = function(node, clone2, style3, pseudoElt) {
            var _this = this;
            if (!style3) {
              return;
            }
            var value2 = style3.content;
            var document2 = clone2.ownerDocument;
            if (!document2 || !value2 || value2 === "none" || value2 === "-moz-alt-content" || style3.display === "none") {
              return;
            }
            this.counters.parse(new CSSParsedCounterDeclaration(this.context, style3));
            var declaration = new CSSParsedPseudoDeclaration(this.context, style3);
            var anonymousReplacedElement = document2.createElement("html2canvaspseudoelement");
            copyCSSStyles(style3, anonymousReplacedElement);
            declaration.content.forEach(function(token) {
              if (token.type === 0) {
                anonymousReplacedElement.appendChild(document2.createTextNode(token.value));
              } else if (token.type === 22) {
                var img = document2.createElement("img");
                img.src = token.value;
                img.style.opacity = "1";
                anonymousReplacedElement.appendChild(img);
              } else if (token.type === 18) {
                if (token.name === "attr") {
                  var attr = token.values.filter(isIdentToken);
                  if (attr.length) {
                    anonymousReplacedElement.appendChild(document2.createTextNode(node.getAttribute(attr[0].value) || ""));
                  }
                } else if (token.name === "counter") {
                  var _a = token.values.filter(nonFunctionArgSeparator), counter2 = _a[0], counterStyle = _a[1];
                  if (counter2 && isIdentToken(counter2)) {
                    var counterState = _this.counters.getCounterValue(counter2.value);
                    var counterType = counterStyle && isIdentToken(counterStyle) ? listStyleType.parse(_this.context, counterStyle.value) : 3;
                    anonymousReplacedElement.appendChild(document2.createTextNode(createCounterText(counterState, counterType, false)));
                  }
                } else if (token.name === "counters") {
                  var _b = token.values.filter(nonFunctionArgSeparator), counter2 = _b[0], delim = _b[1], counterStyle = _b[2];
                  if (counter2 && isIdentToken(counter2)) {
                    var counterStates = _this.counters.getCounterValues(counter2.value);
                    var counterType_1 = counterStyle && isIdentToken(counterStyle) ? listStyleType.parse(_this.context, counterStyle.value) : 3;
                    var separator3 = delim && delim.type === 0 ? delim.value : "";
                    var text = counterStates.map(function(value3) {
                      return createCounterText(value3, counterType_1, false);
                    }).join(separator3);
                    anonymousReplacedElement.appendChild(document2.createTextNode(text));
                  }
                } else ;
              } else if (token.type === 20) {
                switch (token.value) {
                  case "open-quote":
                    anonymousReplacedElement.appendChild(document2.createTextNode(getQuote(declaration.quotes, _this.quoteDepth++, true)));
                    break;
                  case "close-quote":
                    anonymousReplacedElement.appendChild(document2.createTextNode(getQuote(declaration.quotes, --_this.quoteDepth, false)));
                    break;
                  default:
                    anonymousReplacedElement.appendChild(document2.createTextNode(token.value));
                }
              }
            });
            anonymousReplacedElement.className = PSEUDO_HIDE_ELEMENT_CLASS_BEFORE + " " + PSEUDO_HIDE_ELEMENT_CLASS_AFTER;
            var newClassName = pseudoElt === PseudoElementType.BEFORE ? " " + PSEUDO_HIDE_ELEMENT_CLASS_BEFORE : " " + PSEUDO_HIDE_ELEMENT_CLASS_AFTER;
            if (isSVGElementNode(clone2)) {
              clone2.className.baseValue += newClassName;
            } else {
              clone2.className += newClassName;
            }
            return anonymousReplacedElement;
          };
          DocumentCloner2.destroy = function(container) {
            if (container.parentNode) {
              container.parentNode.removeChild(container);
              return true;
            }
            return false;
          };
          return DocumentCloner2;
        }()
      );
      var PseudoElementType;
      (function(PseudoElementType2) {
        PseudoElementType2[PseudoElementType2["BEFORE"] = 0] = "BEFORE";
        PseudoElementType2[PseudoElementType2["AFTER"] = 1] = "AFTER";
      })(PseudoElementType || (PseudoElementType = {}));
      var createIFrameContainer = function(ownerDocument2, bounds) {
        var cloneIframeContainer = ownerDocument2.createElement("iframe");
        cloneIframeContainer.className = "html2canvas-container";
        cloneIframeContainer.style.visibility = "hidden";
        cloneIframeContainer.style.position = "fixed";
        cloneIframeContainer.style.left = "-10000px";
        cloneIframeContainer.style.top = "0px";
        cloneIframeContainer.style.border = "0";
        cloneIframeContainer.width = bounds.width.toString();
        cloneIframeContainer.height = bounds.height.toString();
        cloneIframeContainer.scrolling = "no";
        cloneIframeContainer.setAttribute(IGNORE_ATTRIBUTE, "true");
        ownerDocument2.body.appendChild(cloneIframeContainer);
        return cloneIframeContainer;
      };
      var imageReady = function(img) {
        return new Promise(function(resolve2) {
          if (img.complete) {
            resolve2();
            return;
          }
          if (!img.src) {
            resolve2();
            return;
          }
          img.onload = resolve2;
          img.onerror = resolve2;
        });
      };
      var imagesReady = function(document2) {
        return Promise.all([].slice.call(document2.images, 0).map(imageReady));
      };
      var iframeLoader = function(iframe) {
        return new Promise(function(resolve2, reject2) {
          var cloneWindow = iframe.contentWindow;
          if (!cloneWindow) {
            return reject2("No window assigned for iframe");
          }
          var documentClone = cloneWindow.document;
          cloneWindow.onload = iframe.onload = function() {
            cloneWindow.onload = iframe.onload = null;
            var interval = setInterval(function() {
              if (documentClone.body.childNodes.length > 0 && documentClone.readyState === "complete") {
                clearInterval(interval);
                resolve2(iframe);
              }
            }, 50);
          };
        });
      };
      var ignoredStyleProperties = [
        "all",
        "d",
        "content"
        // Safari shows pseudoelements if content is set
      ];
      var copyCSSStyles = function(style3, target) {
        for (var i4 = style3.length - 1; i4 >= 0; i4--) {
          var property2 = style3.item(i4);
          if (ignoredStyleProperties.indexOf(property2) === -1) {
            target.style.setProperty(property2, style3.getPropertyValue(property2));
          }
        }
        return target;
      };
      var serializeDoctype = function(doctype) {
        var str = "";
        if (doctype) {
          str += "<!DOCTYPE ";
          if (doctype.name) {
            str += doctype.name;
          }
          if (doctype.internalSubset) {
            str += doctype.internalSubset;
          }
          if (doctype.publicId) {
            str += '"' + doctype.publicId + '"';
          }
          if (doctype.systemId) {
            str += '"' + doctype.systemId + '"';
          }
          str += ">";
        }
        return str;
      };
      var restoreOwnerScroll = function(ownerDocument2, x3, y3) {
        if (ownerDocument2 && ownerDocument2.defaultView && (x3 !== ownerDocument2.defaultView.pageXOffset || y3 !== ownerDocument2.defaultView.pageYOffset)) {
          ownerDocument2.defaultView.scrollTo(x3, y3);
        }
      };
      var restoreNodeScroll = function(_a) {
        var element = _a[0], x3 = _a[1], y3 = _a[2];
        element.scrollLeft = x3;
        element.scrollTop = y3;
      };
      var PSEUDO_BEFORE = ":before";
      var PSEUDO_AFTER = ":after";
      var PSEUDO_HIDE_ELEMENT_CLASS_BEFORE = "___html2canvas___pseudoelement_before";
      var PSEUDO_HIDE_ELEMENT_CLASS_AFTER = "___html2canvas___pseudoelement_after";
      var PSEUDO_HIDE_ELEMENT_STYLE = '{\n    content: "" !important;\n    display: none !important;\n}';
      var createPseudoHideStyles = function(body) {
        createStyles2(body, "." + PSEUDO_HIDE_ELEMENT_CLASS_BEFORE + PSEUDO_BEFORE + PSEUDO_HIDE_ELEMENT_STYLE + "\n         ." + PSEUDO_HIDE_ELEMENT_CLASS_AFTER + PSEUDO_AFTER + PSEUDO_HIDE_ELEMENT_STYLE);
      };
      var createStyles2 = function(body, styles) {
        var document2 = body.ownerDocument;
        if (document2) {
          var style3 = document2.createElement("style");
          style3.textContent = styles;
          body.appendChild(style3);
        }
      };
      var CacheStorage = (
        /** @class */
        function() {
          function CacheStorage2() {
          }
          CacheStorage2.getOrigin = function(url2) {
            var link = CacheStorage2._link;
            if (!link) {
              return "about:blank";
            }
            link.href = url2;
            link.href = link.href;
            return link.protocol + link.hostname + link.port;
          };
          CacheStorage2.isSameOrigin = function(src) {
            return CacheStorage2.getOrigin(src) === CacheStorage2._origin;
          };
          CacheStorage2.setContext = function(window2) {
            CacheStorage2._link = window2.document.createElement("a");
            CacheStorage2._origin = CacheStorage2.getOrigin(window2.location.href);
          };
          CacheStorage2._origin = "about:blank";
          return CacheStorage2;
        }()
      );
      var Cache = (
        /** @class */
        function() {
          function Cache2(context, _options) {
            this.context = context;
            this._options = _options;
            this._cache = {};
          }
          Cache2.prototype.addImage = function(src) {
            var result2 = Promise.resolve();
            if (this.has(src)) {
              return result2;
            }
            if (isBlobImage(src) || isRenderable(src)) {
              (this._cache[src] = this.loadImage(src)).catch(function() {
              });
              return result2;
            }
            return result2;
          };
          Cache2.prototype.match = function(src) {
            return this._cache[src];
          };
          Cache2.prototype.loadImage = function(key) {
            return __awaiter(this, void 0, void 0, function() {
              var isSameOrigin, useCORS, useProxy, src;
              var _this = this;
              return __generator(this, function(_a) {
                switch (_a.label) {
                  case 0:
                    isSameOrigin = CacheStorage.isSameOrigin(key);
                    useCORS = !isInlineImage(key) && this._options.useCORS === true && FEATURES.SUPPORT_CORS_IMAGES && !isSameOrigin;
                    useProxy = !isInlineImage(key) && !isSameOrigin && !isBlobImage(key) && typeof this._options.proxy === "string" && FEATURES.SUPPORT_CORS_XHR && !useCORS;
                    if (!isSameOrigin && this._options.allowTaint === false && !isInlineImage(key) && !isBlobImage(key) && !useProxy && !useCORS) {
                      return [
                        2
                        /*return*/
                      ];
                    }
                    src = key;
                    if (!useProxy) return [3, 2];
                    return [4, this.proxy(src)];
                  case 1:
                    src = _a.sent();
                    _a.label = 2;
                  case 2:
                    this.context.logger.debug("Added image " + key.substring(0, 256));
                    return [4, new Promise(function(resolve2, reject2) {
                      var img = new Image();
                      img.onload = function() {
                        return resolve2(img);
                      };
                      img.onerror = reject2;
                      if (isInlineBase64Image(src) || useCORS) {
                        img.crossOrigin = "anonymous";
                      }
                      img.src = src;
                      if (img.complete === true) {
                        setTimeout(function() {
                          return resolve2(img);
                        }, 500);
                      }
                      if (_this._options.imageTimeout > 0) {
                        setTimeout(function() {
                          return reject2("Timed out (" + _this._options.imageTimeout + "ms) loading image");
                        }, _this._options.imageTimeout);
                      }
                    })];
                  case 3:
                    return [2, _a.sent()];
                }
              });
            });
          };
          Cache2.prototype.has = function(key) {
            return typeof this._cache[key] !== "undefined";
          };
          Cache2.prototype.keys = function() {
            return Promise.resolve(Object.keys(this._cache));
          };
          Cache2.prototype.proxy = function(src) {
            var _this = this;
            var proxy = this._options.proxy;
            if (!proxy) {
              throw new Error("No proxy defined");
            }
            var key = src.substring(0, 256);
            return new Promise(function(resolve2, reject2) {
              var responseType = FEATURES.SUPPORT_RESPONSE_TYPE ? "blob" : "text";
              var xhr = new XMLHttpRequest();
              xhr.onload = function() {
                if (xhr.status === 200) {
                  if (responseType === "text") {
                    resolve2(xhr.response);
                  } else {
                    var reader_1 = new FileReader();
                    reader_1.addEventListener("load", function() {
                      return resolve2(reader_1.result);
                    }, false);
                    reader_1.addEventListener("error", function(e4) {
                      return reject2(e4);
                    }, false);
                    reader_1.readAsDataURL(xhr.response);
                  }
                } else {
                  reject2("Failed to proxy resource " + key + " with status code " + xhr.status);
                }
              };
              xhr.onerror = reject2;
              var queryString = proxy.indexOf("?") > -1 ? "&" : "?";
              xhr.open("GET", "" + proxy + queryString + "url=" + encodeURIComponent(src) + "&responseType=" + responseType);
              if (responseType !== "text" && xhr instanceof XMLHttpRequest) {
                xhr.responseType = responseType;
              }
              if (_this._options.imageTimeout) {
                var timeout_1 = _this._options.imageTimeout;
                xhr.timeout = timeout_1;
                xhr.ontimeout = function() {
                  return reject2("Timed out (" + timeout_1 + "ms) proxying " + key);
                };
              }
              xhr.send();
            });
          };
          return Cache2;
        }()
      );
      var INLINE_SVG = /^data:image\/svg\+xml/i;
      var INLINE_BASE64 = /^data:image\/.*;base64,/i;
      var INLINE_IMG = /^data:image\/.*/i;
      var isRenderable = function(src) {
        return FEATURES.SUPPORT_SVG_DRAWING || !isSVG2(src);
      };
      var isInlineImage = function(src) {
        return INLINE_IMG.test(src);
      };
      var isInlineBase64Image = function(src) {
        return INLINE_BASE64.test(src);
      };
      var isBlobImage = function(src) {
        return src.substr(0, 4) === "blob";
      };
      var isSVG2 = function(src) {
        return src.substr(-3).toLowerCase() === "svg" || INLINE_SVG.test(src);
      };
      var Vector = (
        /** @class */
        function() {
          function Vector2(x3, y3) {
            this.type = 0;
            this.x = x3;
            this.y = y3;
          }
          Vector2.prototype.add = function(deltaX, deltaY) {
            return new Vector2(this.x + deltaX, this.y + deltaY);
          };
          return Vector2;
        }()
      );
      var lerp = function(a4, b3, t2) {
        return new Vector(a4.x + (b3.x - a4.x) * t2, a4.y + (b3.y - a4.y) * t2);
      };
      var BezierCurve = (
        /** @class */
        function() {
          function BezierCurve2(start, startControl, endControl, end) {
            this.type = 1;
            this.start = start;
            this.startControl = startControl;
            this.endControl = endControl;
            this.end = end;
          }
          BezierCurve2.prototype.subdivide = function(t2, firstHalf) {
            var ab = lerp(this.start, this.startControl, t2);
            var bc = lerp(this.startControl, this.endControl, t2);
            var cd = lerp(this.endControl, this.end, t2);
            var abbc = lerp(ab, bc, t2);
            var bccd = lerp(bc, cd, t2);
            var dest = lerp(abbc, bccd, t2);
            return firstHalf ? new BezierCurve2(this.start, ab, abbc, dest) : new BezierCurve2(dest, bccd, cd, this.end);
          };
          BezierCurve2.prototype.add = function(deltaX, deltaY) {
            return new BezierCurve2(this.start.add(deltaX, deltaY), this.startControl.add(deltaX, deltaY), this.endControl.add(deltaX, deltaY), this.end.add(deltaX, deltaY));
          };
          BezierCurve2.prototype.reverse = function() {
            return new BezierCurve2(this.end, this.endControl, this.startControl, this.start);
          };
          return BezierCurve2;
        }()
      );
      var isBezierCurve = function(path) {
        return path.type === 1;
      };
      var BoundCurves = (
        /** @class */
        /* @__PURE__ */ function() {
          function BoundCurves2(element) {
            var styles = element.styles;
            var bounds = element.bounds;
            var _a = getAbsoluteValueForTuple(styles.borderTopLeftRadius, bounds.width, bounds.height), tlh = _a[0], tlv = _a[1];
            var _b = getAbsoluteValueForTuple(styles.borderTopRightRadius, bounds.width, bounds.height), trh = _b[0], trv = _b[1];
            var _c = getAbsoluteValueForTuple(styles.borderBottomRightRadius, bounds.width, bounds.height), brh = _c[0], brv = _c[1];
            var _d = getAbsoluteValueForTuple(styles.borderBottomLeftRadius, bounds.width, bounds.height), blh = _d[0], blv = _d[1];
            var factors = [];
            factors.push((tlh + trh) / bounds.width);
            factors.push((blh + brh) / bounds.width);
            factors.push((tlv + blv) / bounds.height);
            factors.push((trv + brv) / bounds.height);
            var maxFactor = Math.max.apply(Math, factors);
            if (maxFactor > 1) {
              tlh /= maxFactor;
              tlv /= maxFactor;
              trh /= maxFactor;
              trv /= maxFactor;
              brh /= maxFactor;
              brv /= maxFactor;
              blh /= maxFactor;
              blv /= maxFactor;
            }
            var topWidth = bounds.width - trh;
            var rightHeight = bounds.height - brv;
            var bottomWidth = bounds.width - brh;
            var leftHeight = bounds.height - blv;
            var borderTopWidth2 = styles.borderTopWidth;
            var borderRightWidth2 = styles.borderRightWidth;
            var borderBottomWidth2 = styles.borderBottomWidth;
            var borderLeftWidth2 = styles.borderLeftWidth;
            var paddingTop2 = getAbsoluteValue(styles.paddingTop, element.bounds.width);
            var paddingRight2 = getAbsoluteValue(styles.paddingRight, element.bounds.width);
            var paddingBottom2 = getAbsoluteValue(styles.paddingBottom, element.bounds.width);
            var paddingLeft2 = getAbsoluteValue(styles.paddingLeft, element.bounds.width);
            this.topLeftBorderDoubleOuterBox = tlh > 0 || tlv > 0 ? getCurvePoints(bounds.left + borderLeftWidth2 / 3, bounds.top + borderTopWidth2 / 3, tlh - borderLeftWidth2 / 3, tlv - borderTopWidth2 / 3, CORNER.TOP_LEFT) : new Vector(bounds.left + borderLeftWidth2 / 3, bounds.top + borderTopWidth2 / 3);
            this.topRightBorderDoubleOuterBox = tlh > 0 || tlv > 0 ? getCurvePoints(bounds.left + topWidth, bounds.top + borderTopWidth2 / 3, trh - borderRightWidth2 / 3, trv - borderTopWidth2 / 3, CORNER.TOP_RIGHT) : new Vector(bounds.left + bounds.width - borderRightWidth2 / 3, bounds.top + borderTopWidth2 / 3);
            this.bottomRightBorderDoubleOuterBox = brh > 0 || brv > 0 ? getCurvePoints(bounds.left + bottomWidth, bounds.top + rightHeight, brh - borderRightWidth2 / 3, brv - borderBottomWidth2 / 3, CORNER.BOTTOM_RIGHT) : new Vector(bounds.left + bounds.width - borderRightWidth2 / 3, bounds.top + bounds.height - borderBottomWidth2 / 3);
            this.bottomLeftBorderDoubleOuterBox = blh > 0 || blv > 0 ? getCurvePoints(bounds.left + borderLeftWidth2 / 3, bounds.top + leftHeight, blh - borderLeftWidth2 / 3, blv - borderBottomWidth2 / 3, CORNER.BOTTOM_LEFT) : new Vector(bounds.left + borderLeftWidth2 / 3, bounds.top + bounds.height - borderBottomWidth2 / 3);
            this.topLeftBorderDoubleInnerBox = tlh > 0 || tlv > 0 ? getCurvePoints(bounds.left + borderLeftWidth2 * 2 / 3, bounds.top + borderTopWidth2 * 2 / 3, tlh - borderLeftWidth2 * 2 / 3, tlv - borderTopWidth2 * 2 / 3, CORNER.TOP_LEFT) : new Vector(bounds.left + borderLeftWidth2 * 2 / 3, bounds.top + borderTopWidth2 * 2 / 3);
            this.topRightBorderDoubleInnerBox = tlh > 0 || tlv > 0 ? getCurvePoints(bounds.left + topWidth, bounds.top + borderTopWidth2 * 2 / 3, trh - borderRightWidth2 * 2 / 3, trv - borderTopWidth2 * 2 / 3, CORNER.TOP_RIGHT) : new Vector(bounds.left + bounds.width - borderRightWidth2 * 2 / 3, bounds.top + borderTopWidth2 * 2 / 3);
            this.bottomRightBorderDoubleInnerBox = brh > 0 || brv > 0 ? getCurvePoints(bounds.left + bottomWidth, bounds.top + rightHeight, brh - borderRightWidth2 * 2 / 3, brv - borderBottomWidth2 * 2 / 3, CORNER.BOTTOM_RIGHT) : new Vector(bounds.left + bounds.width - borderRightWidth2 * 2 / 3, bounds.top + bounds.height - borderBottomWidth2 * 2 / 3);
            this.bottomLeftBorderDoubleInnerBox = blh > 0 || blv > 0 ? getCurvePoints(bounds.left + borderLeftWidth2 * 2 / 3, bounds.top + leftHeight, blh - borderLeftWidth2 * 2 / 3, blv - borderBottomWidth2 * 2 / 3, CORNER.BOTTOM_LEFT) : new Vector(bounds.left + borderLeftWidth2 * 2 / 3, bounds.top + bounds.height - borderBottomWidth2 * 2 / 3);
            this.topLeftBorderStroke = tlh > 0 || tlv > 0 ? getCurvePoints(bounds.left + borderLeftWidth2 / 2, bounds.top + borderTopWidth2 / 2, tlh - borderLeftWidth2 / 2, tlv - borderTopWidth2 / 2, CORNER.TOP_LEFT) : new Vector(bounds.left + borderLeftWidth2 / 2, bounds.top + borderTopWidth2 / 2);
            this.topRightBorderStroke = tlh > 0 || tlv > 0 ? getCurvePoints(bounds.left + topWidth, bounds.top + borderTopWidth2 / 2, trh - borderRightWidth2 / 2, trv - borderTopWidth2 / 2, CORNER.TOP_RIGHT) : new Vector(bounds.left + bounds.width - borderRightWidth2 / 2, bounds.top + borderTopWidth2 / 2);
            this.bottomRightBorderStroke = brh > 0 || brv > 0 ? getCurvePoints(bounds.left + bottomWidth, bounds.top + rightHeight, brh - borderRightWidth2 / 2, brv - borderBottomWidth2 / 2, CORNER.BOTTOM_RIGHT) : new Vector(bounds.left + bounds.width - borderRightWidth2 / 2, bounds.top + bounds.height - borderBottomWidth2 / 2);
            this.bottomLeftBorderStroke = blh > 0 || blv > 0 ? getCurvePoints(bounds.left + borderLeftWidth2 / 2, bounds.top + leftHeight, blh - borderLeftWidth2 / 2, blv - borderBottomWidth2 / 2, CORNER.BOTTOM_LEFT) : new Vector(bounds.left + borderLeftWidth2 / 2, bounds.top + bounds.height - borderBottomWidth2 / 2);
            this.topLeftBorderBox = tlh > 0 || tlv > 0 ? getCurvePoints(bounds.left, bounds.top, tlh, tlv, CORNER.TOP_LEFT) : new Vector(bounds.left, bounds.top);
            this.topRightBorderBox = trh > 0 || trv > 0 ? getCurvePoints(bounds.left + topWidth, bounds.top, trh, trv, CORNER.TOP_RIGHT) : new Vector(bounds.left + bounds.width, bounds.top);
            this.bottomRightBorderBox = brh > 0 || brv > 0 ? getCurvePoints(bounds.left + bottomWidth, bounds.top + rightHeight, brh, brv, CORNER.BOTTOM_RIGHT) : new Vector(bounds.left + bounds.width, bounds.top + bounds.height);
            this.bottomLeftBorderBox = blh > 0 || blv > 0 ? getCurvePoints(bounds.left, bounds.top + leftHeight, blh, blv, CORNER.BOTTOM_LEFT) : new Vector(bounds.left, bounds.top + bounds.height);
            this.topLeftPaddingBox = tlh > 0 || tlv > 0 ? getCurvePoints(bounds.left + borderLeftWidth2, bounds.top + borderTopWidth2, Math.max(0, tlh - borderLeftWidth2), Math.max(0, tlv - borderTopWidth2), CORNER.TOP_LEFT) : new Vector(bounds.left + borderLeftWidth2, bounds.top + borderTopWidth2);
            this.topRightPaddingBox = trh > 0 || trv > 0 ? getCurvePoints(bounds.left + Math.min(topWidth, bounds.width - borderRightWidth2), bounds.top + borderTopWidth2, topWidth > bounds.width + borderRightWidth2 ? 0 : Math.max(0, trh - borderRightWidth2), Math.max(0, trv - borderTopWidth2), CORNER.TOP_RIGHT) : new Vector(bounds.left + bounds.width - borderRightWidth2, bounds.top + borderTopWidth2);
            this.bottomRightPaddingBox = brh > 0 || brv > 0 ? getCurvePoints(bounds.left + Math.min(bottomWidth, bounds.width - borderLeftWidth2), bounds.top + Math.min(rightHeight, bounds.height - borderBottomWidth2), Math.max(0, brh - borderRightWidth2), Math.max(0, brv - borderBottomWidth2), CORNER.BOTTOM_RIGHT) : new Vector(bounds.left + bounds.width - borderRightWidth2, bounds.top + bounds.height - borderBottomWidth2);
            this.bottomLeftPaddingBox = blh > 0 || blv > 0 ? getCurvePoints(bounds.left + borderLeftWidth2, bounds.top + Math.min(leftHeight, bounds.height - borderBottomWidth2), Math.max(0, blh - borderLeftWidth2), Math.max(0, blv - borderBottomWidth2), CORNER.BOTTOM_LEFT) : new Vector(bounds.left + borderLeftWidth2, bounds.top + bounds.height - borderBottomWidth2);
            this.topLeftContentBox = tlh > 0 || tlv > 0 ? getCurvePoints(bounds.left + borderLeftWidth2 + paddingLeft2, bounds.top + borderTopWidth2 + paddingTop2, Math.max(0, tlh - (borderLeftWidth2 + paddingLeft2)), Math.max(0, tlv - (borderTopWidth2 + paddingTop2)), CORNER.TOP_LEFT) : new Vector(bounds.left + borderLeftWidth2 + paddingLeft2, bounds.top + borderTopWidth2 + paddingTop2);
            this.topRightContentBox = trh > 0 || trv > 0 ? getCurvePoints(bounds.left + Math.min(topWidth, bounds.width + borderLeftWidth2 + paddingLeft2), bounds.top + borderTopWidth2 + paddingTop2, topWidth > bounds.width + borderLeftWidth2 + paddingLeft2 ? 0 : trh - borderLeftWidth2 + paddingLeft2, trv - (borderTopWidth2 + paddingTop2), CORNER.TOP_RIGHT) : new Vector(bounds.left + bounds.width - (borderRightWidth2 + paddingRight2), bounds.top + borderTopWidth2 + paddingTop2);
            this.bottomRightContentBox = brh > 0 || brv > 0 ? getCurvePoints(bounds.left + Math.min(bottomWidth, bounds.width - (borderLeftWidth2 + paddingLeft2)), bounds.top + Math.min(rightHeight, bounds.height + borderTopWidth2 + paddingTop2), Math.max(0, brh - (borderRightWidth2 + paddingRight2)), brv - (borderBottomWidth2 + paddingBottom2), CORNER.BOTTOM_RIGHT) : new Vector(bounds.left + bounds.width - (borderRightWidth2 + paddingRight2), bounds.top + bounds.height - (borderBottomWidth2 + paddingBottom2));
            this.bottomLeftContentBox = blh > 0 || blv > 0 ? getCurvePoints(bounds.left + borderLeftWidth2 + paddingLeft2, bounds.top + leftHeight, Math.max(0, blh - (borderLeftWidth2 + paddingLeft2)), blv - (borderBottomWidth2 + paddingBottom2), CORNER.BOTTOM_LEFT) : new Vector(bounds.left + borderLeftWidth2 + paddingLeft2, bounds.top + bounds.height - (borderBottomWidth2 + paddingBottom2));
          }
          return BoundCurves2;
        }()
      );
      var CORNER;
      (function(CORNER2) {
        CORNER2[CORNER2["TOP_LEFT"] = 0] = "TOP_LEFT";
        CORNER2[CORNER2["TOP_RIGHT"] = 1] = "TOP_RIGHT";
        CORNER2[CORNER2["BOTTOM_RIGHT"] = 2] = "BOTTOM_RIGHT";
        CORNER2[CORNER2["BOTTOM_LEFT"] = 3] = "BOTTOM_LEFT";
      })(CORNER || (CORNER = {}));
      var getCurvePoints = function(x3, y3, r1, r22, position2) {
        var kappa = 4 * ((Math.sqrt(2) - 1) / 3);
        var ox = r1 * kappa;
        var oy = r22 * kappa;
        var xm = x3 + r1;
        var ym = y3 + r22;
        switch (position2) {
          case CORNER.TOP_LEFT:
            return new BezierCurve(new Vector(x3, ym), new Vector(x3, ym - oy), new Vector(xm - ox, y3), new Vector(xm, y3));
          case CORNER.TOP_RIGHT:
            return new BezierCurve(new Vector(x3, y3), new Vector(x3 + ox, y3), new Vector(xm, ym - oy), new Vector(xm, ym));
          case CORNER.BOTTOM_RIGHT:
            return new BezierCurve(new Vector(xm, y3), new Vector(xm, y3 + oy), new Vector(x3 + ox, ym), new Vector(x3, ym));
          case CORNER.BOTTOM_LEFT:
          default:
            return new BezierCurve(new Vector(xm, ym), new Vector(xm - ox, ym), new Vector(x3, y3 + oy), new Vector(x3, y3));
        }
      };
      var calculateBorderBoxPath = function(curves) {
        return [curves.topLeftBorderBox, curves.topRightBorderBox, curves.bottomRightBorderBox, curves.bottomLeftBorderBox];
      };
      var calculateContentBoxPath = function(curves) {
        return [
          curves.topLeftContentBox,
          curves.topRightContentBox,
          curves.bottomRightContentBox,
          curves.bottomLeftContentBox
        ];
      };
      var calculatePaddingBoxPath = function(curves) {
        return [
          curves.topLeftPaddingBox,
          curves.topRightPaddingBox,
          curves.bottomRightPaddingBox,
          curves.bottomLeftPaddingBox
        ];
      };
      var TransformEffect = (
        /** @class */
        /* @__PURE__ */ function() {
          function TransformEffect2(offsetX, offsetY, matrix2) {
            this.offsetX = offsetX;
            this.offsetY = offsetY;
            this.matrix = matrix2;
            this.type = 0;
            this.target = 2 | 4;
          }
          return TransformEffect2;
        }()
      );
      var ClipEffect = (
        /** @class */
        /* @__PURE__ */ function() {
          function ClipEffect2(path, target) {
            this.path = path;
            this.target = target;
            this.type = 1;
          }
          return ClipEffect2;
        }()
      );
      var OpacityEffect = (
        /** @class */
        /* @__PURE__ */ function() {
          function OpacityEffect2(opacity2) {
            this.opacity = opacity2;
            this.type = 2;
            this.target = 2 | 4;
          }
          return OpacityEffect2;
        }()
      );
      var isTransformEffect = function(effect2) {
        return effect2.type === 0;
      };
      var isClipEffect = function(effect2) {
        return effect2.type === 1;
      };
      var isOpacityEffect = function(effect2) {
        return effect2.type === 2;
      };
      var equalPath = function(a4, b3) {
        if (a4.length === b3.length) {
          return a4.some(function(v3, i4) {
            return v3 === b3[i4];
          });
        }
        return false;
      };
      var transformPath = function(path, deltaX, deltaY, deltaW, deltaH) {
        return path.map(function(point, index) {
          switch (index) {
            case 0:
              return point.add(deltaX, deltaY);
            case 1:
              return point.add(deltaX + deltaW, deltaY);
            case 2:
              return point.add(deltaX + deltaW, deltaY + deltaH);
            case 3:
              return point.add(deltaX, deltaY + deltaH);
          }
          return point;
        });
      };
      var StackingContext = (
        /** @class */
        /* @__PURE__ */ function() {
          function StackingContext2(container) {
            this.element = container;
            this.inlineLevel = [];
            this.nonInlineLevel = [];
            this.negativeZIndex = [];
            this.zeroOrAutoZIndexOrTransformedOrOpacity = [];
            this.positiveZIndex = [];
            this.nonPositionedFloats = [];
            this.nonPositionedInlineLevel = [];
          }
          return StackingContext2;
        }()
      );
      var ElementPaint = (
        /** @class */
        function() {
          function ElementPaint2(container, parent) {
            this.container = container;
            this.parent = parent;
            this.effects = [];
            this.curves = new BoundCurves(this.container);
            if (this.container.styles.opacity < 1) {
              this.effects.push(new OpacityEffect(this.container.styles.opacity));
            }
            if (this.container.styles.transform !== null) {
              var offsetX = this.container.bounds.left + this.container.styles.transformOrigin[0].number;
              var offsetY = this.container.bounds.top + this.container.styles.transformOrigin[1].number;
              var matrix2 = this.container.styles.transform;
              this.effects.push(new TransformEffect(offsetX, offsetY, matrix2));
            }
            if (this.container.styles.overflowX !== 0) {
              var borderBox = calculateBorderBoxPath(this.curves);
              var paddingBox2 = calculatePaddingBoxPath(this.curves);
              if (equalPath(borderBox, paddingBox2)) {
                this.effects.push(new ClipEffect(
                  borderBox,
                  2 | 4
                  /* CONTENT */
                ));
              } else {
                this.effects.push(new ClipEffect(
                  borderBox,
                  2
                  /* BACKGROUND_BORDERS */
                ));
                this.effects.push(new ClipEffect(
                  paddingBox2,
                  4
                  /* CONTENT */
                ));
              }
            }
          }
          ElementPaint2.prototype.getEffects = function(target) {
            var inFlow = [
              2,
              3
              /* FIXED */
            ].indexOf(this.container.styles.position) === -1;
            var parent = this.parent;
            var effects = this.effects.slice(0);
            while (parent) {
              var croplessEffects = parent.effects.filter(function(effect2) {
                return !isClipEffect(effect2);
              });
              if (inFlow || parent.container.styles.position !== 0 || !parent.parent) {
                effects.unshift.apply(effects, croplessEffects);
                inFlow = [
                  2,
                  3
                  /* FIXED */
                ].indexOf(parent.container.styles.position) === -1;
                if (parent.container.styles.overflowX !== 0) {
                  var borderBox = calculateBorderBoxPath(parent.curves);
                  var paddingBox2 = calculatePaddingBoxPath(parent.curves);
                  if (!equalPath(borderBox, paddingBox2)) {
                    effects.unshift(new ClipEffect(
                      paddingBox2,
                      2 | 4
                      /* CONTENT */
                    ));
                  }
                }
              } else {
                effects.unshift.apply(effects, croplessEffects);
              }
              parent = parent.parent;
            }
            return effects.filter(function(effect2) {
              return contains3(effect2.target, target);
            });
          };
          return ElementPaint2;
        }()
      );
      var parseStackTree = function(parent, stackingContext, realStackingContext, listItems) {
        parent.container.elements.forEach(function(child) {
          var treatAsRealStackingContext = contains3(
            child.flags,
            4
            /* CREATES_REAL_STACKING_CONTEXT */
          );
          var createsStackingContext2 = contains3(
            child.flags,
            2
            /* CREATES_STACKING_CONTEXT */
          );
          var paintContainer = new ElementPaint(child, parent);
          if (contains3(
            child.styles.display,
            2048
            /* LIST_ITEM */
          )) {
            listItems.push(paintContainer);
          }
          var listOwnerItems = contains3(
            child.flags,
            8
            /* IS_LIST_OWNER */
          ) ? [] : listItems;
          if (treatAsRealStackingContext || createsStackingContext2) {
            var parentStack = treatAsRealStackingContext || child.styles.isPositioned() ? realStackingContext : stackingContext;
            var stack = new StackingContext(paintContainer);
            if (child.styles.isPositioned() || child.styles.opacity < 1 || child.styles.isTransformed()) {
              var order_1 = child.styles.zIndex.order;
              if (order_1 < 0) {
                var index_1 = 0;
                parentStack.negativeZIndex.some(function(current, i4) {
                  if (order_1 > current.element.container.styles.zIndex.order) {
                    index_1 = i4;
                    return false;
                  } else if (index_1 > 0) {
                    return true;
                  }
                  return false;
                });
                parentStack.negativeZIndex.splice(index_1, 0, stack);
              } else if (order_1 > 0) {
                var index_2 = 0;
                parentStack.positiveZIndex.some(function(current, i4) {
                  if (order_1 >= current.element.container.styles.zIndex.order) {
                    index_2 = i4 + 1;
                    return false;
                  } else if (index_2 > 0) {
                    return true;
                  }
                  return false;
                });
                parentStack.positiveZIndex.splice(index_2, 0, stack);
              } else {
                parentStack.zeroOrAutoZIndexOrTransformedOrOpacity.push(stack);
              }
            } else {
              if (child.styles.isFloating()) {
                parentStack.nonPositionedFloats.push(stack);
              } else {
                parentStack.nonPositionedInlineLevel.push(stack);
              }
            }
            parseStackTree(paintContainer, stack, treatAsRealStackingContext ? stack : realStackingContext, listOwnerItems);
          } else {
            if (child.styles.isInlineLevel()) {
              stackingContext.inlineLevel.push(paintContainer);
            } else {
              stackingContext.nonInlineLevel.push(paintContainer);
            }
            parseStackTree(paintContainer, stackingContext, realStackingContext, listOwnerItems);
          }
          if (contains3(
            child.flags,
            8
            /* IS_LIST_OWNER */
          )) {
            processListItems(child, listOwnerItems);
          }
        });
      };
      var processListItems = function(owner, elements) {
        var numbering = owner instanceof OLElementContainer ? owner.start : 1;
        var reversed = owner instanceof OLElementContainer ? owner.reversed : false;
        for (var i4 = 0; i4 < elements.length; i4++) {
          var item = elements[i4];
          if (item.container instanceof LIElementContainer && typeof item.container.value === "number" && item.container.value !== 0) {
            numbering = item.container.value;
          }
          item.listValue = createCounterText(numbering, item.container.styles.listStyleType, true);
          numbering += reversed ? -1 : 1;
        }
      };
      var parseStackingContexts = function(container) {
        var paintContainer = new ElementPaint(container, null);
        var root2 = new StackingContext(paintContainer);
        var listItems = [];
        parseStackTree(paintContainer, root2, root2, listItems);
        processListItems(paintContainer.container, listItems);
        return root2;
      };
      var parsePathForBorder = function(curves, borderSide) {
        switch (borderSide) {
          case 0:
            return createPathFromCurves(curves.topLeftBorderBox, curves.topLeftPaddingBox, curves.topRightBorderBox, curves.topRightPaddingBox);
          case 1:
            return createPathFromCurves(curves.topRightBorderBox, curves.topRightPaddingBox, curves.bottomRightBorderBox, curves.bottomRightPaddingBox);
          case 2:
            return createPathFromCurves(curves.bottomRightBorderBox, curves.bottomRightPaddingBox, curves.bottomLeftBorderBox, curves.bottomLeftPaddingBox);
          case 3:
          default:
            return createPathFromCurves(curves.bottomLeftBorderBox, curves.bottomLeftPaddingBox, curves.topLeftBorderBox, curves.topLeftPaddingBox);
        }
      };
      var parsePathForBorderDoubleOuter = function(curves, borderSide) {
        switch (borderSide) {
          case 0:
            return createPathFromCurves(curves.topLeftBorderBox, curves.topLeftBorderDoubleOuterBox, curves.topRightBorderBox, curves.topRightBorderDoubleOuterBox);
          case 1:
            return createPathFromCurves(curves.topRightBorderBox, curves.topRightBorderDoubleOuterBox, curves.bottomRightBorderBox, curves.bottomRightBorderDoubleOuterBox);
          case 2:
            return createPathFromCurves(curves.bottomRightBorderBox, curves.bottomRightBorderDoubleOuterBox, curves.bottomLeftBorderBox, curves.bottomLeftBorderDoubleOuterBox);
          case 3:
          default:
            return createPathFromCurves(curves.bottomLeftBorderBox, curves.bottomLeftBorderDoubleOuterBox, curves.topLeftBorderBox, curves.topLeftBorderDoubleOuterBox);
        }
      };
      var parsePathForBorderDoubleInner = function(curves, borderSide) {
        switch (borderSide) {
          case 0:
            return createPathFromCurves(curves.topLeftBorderDoubleInnerBox, curves.topLeftPaddingBox, curves.topRightBorderDoubleInnerBox, curves.topRightPaddingBox);
          case 1:
            return createPathFromCurves(curves.topRightBorderDoubleInnerBox, curves.topRightPaddingBox, curves.bottomRightBorderDoubleInnerBox, curves.bottomRightPaddingBox);
          case 2:
            return createPathFromCurves(curves.bottomRightBorderDoubleInnerBox, curves.bottomRightPaddingBox, curves.bottomLeftBorderDoubleInnerBox, curves.bottomLeftPaddingBox);
          case 3:
          default:
            return createPathFromCurves(curves.bottomLeftBorderDoubleInnerBox, curves.bottomLeftPaddingBox, curves.topLeftBorderDoubleInnerBox, curves.topLeftPaddingBox);
        }
      };
      var parsePathForBorderStroke = function(curves, borderSide) {
        switch (borderSide) {
          case 0:
            return createStrokePathFromCurves(curves.topLeftBorderStroke, curves.topRightBorderStroke);
          case 1:
            return createStrokePathFromCurves(curves.topRightBorderStroke, curves.bottomRightBorderStroke);
          case 2:
            return createStrokePathFromCurves(curves.bottomRightBorderStroke, curves.bottomLeftBorderStroke);
          case 3:
          default:
            return createStrokePathFromCurves(curves.bottomLeftBorderStroke, curves.topLeftBorderStroke);
        }
      };
      var createStrokePathFromCurves = function(outer1, outer2) {
        var path = [];
        if (isBezierCurve(outer1)) {
          path.push(outer1.subdivide(0.5, false));
        } else {
          path.push(outer1);
        }
        if (isBezierCurve(outer2)) {
          path.push(outer2.subdivide(0.5, true));
        } else {
          path.push(outer2);
        }
        return path;
      };
      var createPathFromCurves = function(outer1, inner1, outer2, inner2) {
        var path = [];
        if (isBezierCurve(outer1)) {
          path.push(outer1.subdivide(0.5, false));
        } else {
          path.push(outer1);
        }
        if (isBezierCurve(outer2)) {
          path.push(outer2.subdivide(0.5, true));
        } else {
          path.push(outer2);
        }
        if (isBezierCurve(inner2)) {
          path.push(inner2.subdivide(0.5, true).reverse());
        } else {
          path.push(inner2);
        }
        if (isBezierCurve(inner1)) {
          path.push(inner1.subdivide(0.5, false).reverse());
        } else {
          path.push(inner1);
        }
        return path;
      };
      var paddingBox = function(element) {
        var bounds = element.bounds;
        var styles = element.styles;
        return bounds.add(styles.borderLeftWidth, styles.borderTopWidth, -(styles.borderRightWidth + styles.borderLeftWidth), -(styles.borderTopWidth + styles.borderBottomWidth));
      };
      var contentBox = function(element) {
        var styles = element.styles;
        var bounds = element.bounds;
        var paddingLeft2 = getAbsoluteValue(styles.paddingLeft, bounds.width);
        var paddingRight2 = getAbsoluteValue(styles.paddingRight, bounds.width);
        var paddingTop2 = getAbsoluteValue(styles.paddingTop, bounds.width);
        var paddingBottom2 = getAbsoluteValue(styles.paddingBottom, bounds.width);
        return bounds.add(paddingLeft2 + styles.borderLeftWidth, paddingTop2 + styles.borderTopWidth, -(styles.borderRightWidth + styles.borderLeftWidth + paddingLeft2 + paddingRight2), -(styles.borderTopWidth + styles.borderBottomWidth + paddingTop2 + paddingBottom2));
      };
      var calculateBackgroundPositioningArea = function(backgroundOrigin2, element) {
        if (backgroundOrigin2 === 0) {
          return element.bounds;
        }
        if (backgroundOrigin2 === 2) {
          return contentBox(element);
        }
        return paddingBox(element);
      };
      var calculateBackgroundPaintingArea = function(backgroundClip2, element) {
        if (backgroundClip2 === 0) {
          return element.bounds;
        }
        if (backgroundClip2 === 2) {
          return contentBox(element);
        }
        return paddingBox(element);
      };
      var calculateBackgroundRendering = function(container, index, intrinsicSize) {
        var backgroundPositioningArea = calculateBackgroundPositioningArea(getBackgroundValueForIndex(container.styles.backgroundOrigin, index), container);
        var backgroundPaintingArea = calculateBackgroundPaintingArea(getBackgroundValueForIndex(container.styles.backgroundClip, index), container);
        var backgroundImageSize = calculateBackgroundSize(getBackgroundValueForIndex(container.styles.backgroundSize, index), intrinsicSize, backgroundPositioningArea);
        var sizeWidth = backgroundImageSize[0], sizeHeight = backgroundImageSize[1];
        var position2 = getAbsoluteValueForTuple(getBackgroundValueForIndex(container.styles.backgroundPosition, index), backgroundPositioningArea.width - sizeWidth, backgroundPositioningArea.height - sizeHeight);
        var path = calculateBackgroundRepeatPath(getBackgroundValueForIndex(container.styles.backgroundRepeat, index), position2, backgroundImageSize, backgroundPositioningArea, backgroundPaintingArea);
        var offsetX = Math.round(backgroundPositioningArea.left + position2[0]);
        var offsetY = Math.round(backgroundPositioningArea.top + position2[1]);
        return [path, offsetX, offsetY, sizeWidth, sizeHeight];
      };
      var isAuto = function(token) {
        return isIdentToken(token) && token.value === BACKGROUND_SIZE.AUTO;
      };
      var hasIntrinsicValue = function(value2) {
        return typeof value2 === "number";
      };
      var calculateBackgroundSize = function(size4, _a, bounds) {
        var intrinsicWidth = _a[0], intrinsicHeight = _a[1], intrinsicProportion = _a[2];
        var first2 = size4[0], second = size4[1];
        if (!first2) {
          return [0, 0];
        }
        if (isLengthPercentage(first2) && second && isLengthPercentage(second)) {
          return [getAbsoluteValue(first2, bounds.width), getAbsoluteValue(second, bounds.height)];
        }
        var hasIntrinsicProportion = hasIntrinsicValue(intrinsicProportion);
        if (isIdentToken(first2) && (first2.value === BACKGROUND_SIZE.CONTAIN || first2.value === BACKGROUND_SIZE.COVER)) {
          if (hasIntrinsicValue(intrinsicProportion)) {
            var targetRatio = bounds.width / bounds.height;
            return targetRatio < intrinsicProportion !== (first2.value === BACKGROUND_SIZE.COVER) ? [bounds.width, bounds.width / intrinsicProportion] : [bounds.height * intrinsicProportion, bounds.height];
          }
          return [bounds.width, bounds.height];
        }
        var hasIntrinsicWidth = hasIntrinsicValue(intrinsicWidth);
        var hasIntrinsicHeight = hasIntrinsicValue(intrinsicHeight);
        var hasIntrinsicDimensions = hasIntrinsicWidth || hasIntrinsicHeight;
        if (isAuto(first2) && (!second || isAuto(second))) {
          if (hasIntrinsicWidth && hasIntrinsicHeight) {
            return [intrinsicWidth, intrinsicHeight];
          }
          if (!hasIntrinsicProportion && !hasIntrinsicDimensions) {
            return [bounds.width, bounds.height];
          }
          if (hasIntrinsicDimensions && hasIntrinsicProportion) {
            var width_1 = hasIntrinsicWidth ? intrinsicWidth : intrinsicHeight * intrinsicProportion;
            var height_1 = hasIntrinsicHeight ? intrinsicHeight : intrinsicWidth / intrinsicProportion;
            return [width_1, height_1];
          }
          var width_2 = hasIntrinsicWidth ? intrinsicWidth : bounds.width;
          var height_2 = hasIntrinsicHeight ? intrinsicHeight : bounds.height;
          return [width_2, height_2];
        }
        if (hasIntrinsicProportion) {
          var width_3 = 0;
          var height_3 = 0;
          if (isLengthPercentage(first2)) {
            width_3 = getAbsoluteValue(first2, bounds.width);
          } else if (isLengthPercentage(second)) {
            height_3 = getAbsoluteValue(second, bounds.height);
          }
          if (isAuto(first2)) {
            width_3 = height_3 * intrinsicProportion;
          } else if (!second || isAuto(second)) {
            height_3 = width_3 / intrinsicProportion;
          }
          return [width_3, height_3];
        }
        var width = null;
        var height = null;
        if (isLengthPercentage(first2)) {
          width = getAbsoluteValue(first2, bounds.width);
        } else if (second && isLengthPercentage(second)) {
          height = getAbsoluteValue(second, bounds.height);
        }
        if (width !== null && (!second || isAuto(second))) {
          height = hasIntrinsicWidth && hasIntrinsicHeight ? width / intrinsicWidth * intrinsicHeight : bounds.height;
        }
        if (height !== null && isAuto(first2)) {
          width = hasIntrinsicWidth && hasIntrinsicHeight ? height / intrinsicHeight * intrinsicWidth : bounds.width;
        }
        if (width !== null && height !== null) {
          return [width, height];
        }
        throw new Error("Unable to calculate background-size for element");
      };
      var getBackgroundValueForIndex = function(values2, index) {
        var value2 = values2[index];
        if (typeof value2 === "undefined") {
          return values2[0];
        }
        return value2;
      };
      var calculateBackgroundRepeatPath = function(repeat, _a, _b, backgroundPositioningArea, backgroundPaintingArea) {
        var x3 = _a[0], y3 = _a[1];
        var width = _b[0], height = _b[1];
        switch (repeat) {
          case 2:
            return [
              new Vector(Math.round(backgroundPositioningArea.left), Math.round(backgroundPositioningArea.top + y3)),
              new Vector(Math.round(backgroundPositioningArea.left + backgroundPositioningArea.width), Math.round(backgroundPositioningArea.top + y3)),
              new Vector(Math.round(backgroundPositioningArea.left + backgroundPositioningArea.width), Math.round(height + backgroundPositioningArea.top + y3)),
              new Vector(Math.round(backgroundPositioningArea.left), Math.round(height + backgroundPositioningArea.top + y3))
            ];
          case 3:
            return [
              new Vector(Math.round(backgroundPositioningArea.left + x3), Math.round(backgroundPositioningArea.top)),
              new Vector(Math.round(backgroundPositioningArea.left + x3 + width), Math.round(backgroundPositioningArea.top)),
              new Vector(Math.round(backgroundPositioningArea.left + x3 + width), Math.round(backgroundPositioningArea.height + backgroundPositioningArea.top)),
              new Vector(Math.round(backgroundPositioningArea.left + x3), Math.round(backgroundPositioningArea.height + backgroundPositioningArea.top))
            ];
          case 1:
            return [
              new Vector(Math.round(backgroundPositioningArea.left + x3), Math.round(backgroundPositioningArea.top + y3)),
              new Vector(Math.round(backgroundPositioningArea.left + x3 + width), Math.round(backgroundPositioningArea.top + y3)),
              new Vector(Math.round(backgroundPositioningArea.left + x3 + width), Math.round(backgroundPositioningArea.top + y3 + height)),
              new Vector(Math.round(backgroundPositioningArea.left + x3), Math.round(backgroundPositioningArea.top + y3 + height))
            ];
          default:
            return [
              new Vector(Math.round(backgroundPaintingArea.left), Math.round(backgroundPaintingArea.top)),
              new Vector(Math.round(backgroundPaintingArea.left + backgroundPaintingArea.width), Math.round(backgroundPaintingArea.top)),
              new Vector(Math.round(backgroundPaintingArea.left + backgroundPaintingArea.width), Math.round(backgroundPaintingArea.height + backgroundPaintingArea.top)),
              new Vector(Math.round(backgroundPaintingArea.left), Math.round(backgroundPaintingArea.height + backgroundPaintingArea.top))
            ];
        }
      };
      var SMALL_IMAGE = "data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///yH5BAEAAAAALAAAAAABAAEAAAIBRAA7";
      var SAMPLE_TEXT = "Hidden Text";
      var FontMetrics = (
        /** @class */
        function() {
          function FontMetrics2(document2) {
            this._data = {};
            this._document = document2;
          }
          FontMetrics2.prototype.parseMetrics = function(fontFamily2, fontSize2) {
            var container = this._document.createElement("div");
            var img = this._document.createElement("img");
            var span = this._document.createElement("span");
            var body = this._document.body;
            container.style.visibility = "hidden";
            container.style.fontFamily = fontFamily2;
            container.style.fontSize = fontSize2;
            container.style.margin = "0";
            container.style.padding = "0";
            container.style.whiteSpace = "nowrap";
            body.appendChild(container);
            img.src = SMALL_IMAGE;
            img.width = 1;
            img.height = 1;
            img.style.margin = "0";
            img.style.padding = "0";
            img.style.verticalAlign = "baseline";
            span.style.fontFamily = fontFamily2;
            span.style.fontSize = fontSize2;
            span.style.margin = "0";
            span.style.padding = "0";
            span.appendChild(this._document.createTextNode(SAMPLE_TEXT));
            container.appendChild(span);
            container.appendChild(img);
            var baseline = img.offsetTop - span.offsetTop + 2;
            container.removeChild(span);
            container.appendChild(this._document.createTextNode(SAMPLE_TEXT));
            container.style.lineHeight = "normal";
            img.style.verticalAlign = "super";
            var middle = img.offsetTop - container.offsetTop + 2;
            body.removeChild(container);
            return { baseline, middle };
          };
          FontMetrics2.prototype.getMetrics = function(fontFamily2, fontSize2) {
            var key = fontFamily2 + " " + fontSize2;
            if (typeof this._data[key] === "undefined") {
              this._data[key] = this.parseMetrics(fontFamily2, fontSize2);
            }
            return this._data[key];
          };
          return FontMetrics2;
        }()
      );
      var Renderer2 = (
        /** @class */
        /* @__PURE__ */ function() {
          function Renderer3(context, options2) {
            this.context = context;
            this.options = options2;
          }
          return Renderer3;
        }()
      );
      var MASK_OFFSET = 1e4;
      var CanvasRenderer = (
        /** @class */
        function(_super) {
          __extends(CanvasRenderer2, _super);
          function CanvasRenderer2(context, options2) {
            var _this = _super.call(this, context, options2) || this;
            _this._activeEffects = [];
            _this.canvas = options2.canvas ? options2.canvas : document.createElement("canvas");
            _this.ctx = _this.canvas.getContext("2d");
            if (!options2.canvas) {
              _this.canvas.width = Math.floor(options2.width * options2.scale);
              _this.canvas.height = Math.floor(options2.height * options2.scale);
              _this.canvas.style.width = options2.width + "px";
              _this.canvas.style.height = options2.height + "px";
            }
            _this.fontMetrics = new FontMetrics(document);
            _this.ctx.scale(_this.options.scale, _this.options.scale);
            _this.ctx.translate(-options2.x, -options2.y);
            _this.ctx.textBaseline = "bottom";
            _this._activeEffects = [];
            _this.context.logger.debug("Canvas renderer initialized (" + options2.width + "x" + options2.height + ") with scale " + options2.scale);
            return _this;
          }
          CanvasRenderer2.prototype.applyEffects = function(effects) {
            var _this = this;
            while (this._activeEffects.length) {
              this.popEffect();
            }
            effects.forEach(function(effect2) {
              return _this.applyEffect(effect2);
            });
          };
          CanvasRenderer2.prototype.applyEffect = function(effect2) {
            this.ctx.save();
            if (isOpacityEffect(effect2)) {
              this.ctx.globalAlpha = effect2.opacity;
            }
            if (isTransformEffect(effect2)) {
              this.ctx.translate(effect2.offsetX, effect2.offsetY);
              this.ctx.transform(effect2.matrix[0], effect2.matrix[1], effect2.matrix[2], effect2.matrix[3], effect2.matrix[4], effect2.matrix[5]);
              this.ctx.translate(-effect2.offsetX, -effect2.offsetY);
            }
            if (isClipEffect(effect2)) {
              this.path(effect2.path);
              this.ctx.clip();
            }
            this._activeEffects.push(effect2);
          };
          CanvasRenderer2.prototype.popEffect = function() {
            this._activeEffects.pop();
            this.ctx.restore();
          };
          CanvasRenderer2.prototype.renderStack = function(stack) {
            return __awaiter(this, void 0, void 0, function() {
              var styles;
              return __generator(this, function(_a) {
                switch (_a.label) {
                  case 0:
                    styles = stack.element.container.styles;
                    if (!styles.isVisible()) return [3, 2];
                    return [4, this.renderStackContent(stack)];
                  case 1:
                    _a.sent();
                    _a.label = 2;
                  case 2:
                    return [
                      2
                      /*return*/
                    ];
                }
              });
            });
          };
          CanvasRenderer2.prototype.renderNode = function(paint) {
            return __awaiter(this, void 0, void 0, function() {
              return __generator(this, function(_a) {
                switch (_a.label) {
                  case 0:
                    if (contains3(
                      paint.container.flags,
                      16
                      /* DEBUG_RENDER */
                    )) {
                      debugger;
                    }
                    if (!paint.container.styles.isVisible()) return [3, 3];
                    return [4, this.renderNodeBackgroundAndBorders(paint)];
                  case 1:
                    _a.sent();
                    return [4, this.renderNodeContent(paint)];
                  case 2:
                    _a.sent();
                    _a.label = 3;
                  case 3:
                    return [
                      2
                      /*return*/
                    ];
                }
              });
            });
          };
          CanvasRenderer2.prototype.renderTextWithLetterSpacing = function(text, letterSpacing2, baseline) {
            var _this = this;
            if (letterSpacing2 === 0) {
              this.ctx.fillText(text.text, text.bounds.left, text.bounds.top + baseline);
            } else {
              var letters = segmentGraphemes(text.text);
              letters.reduce(function(left, letter) {
                _this.ctx.fillText(letter, left, text.bounds.top + baseline);
                return left + _this.ctx.measureText(letter).width;
              }, text.bounds.left);
            }
          };
          CanvasRenderer2.prototype.createFontStyle = function(styles) {
            var fontVariant2 = styles.fontVariant.filter(function(variant) {
              return variant === "normal" || variant === "small-caps";
            }).join("");
            var fontFamily2 = fixIOSSystemFonts(styles.fontFamily).join(", ");
            var fontSize2 = isDimensionToken(styles.fontSize) ? "" + styles.fontSize.number + styles.fontSize.unit : styles.fontSize.number + "px";
            return [
              [styles.fontStyle, fontVariant2, styles.fontWeight, fontSize2, fontFamily2].join(" "),
              fontFamily2,
              fontSize2
            ];
          };
          CanvasRenderer2.prototype.renderTextNode = function(text, styles) {
            return __awaiter(this, void 0, void 0, function() {
              var _a, font, fontFamily2, fontSize2, _b, baseline, middle, paintOrder2;
              var _this = this;
              return __generator(this, function(_c) {
                _a = this.createFontStyle(styles), font = _a[0], fontFamily2 = _a[1], fontSize2 = _a[2];
                this.ctx.font = font;
                this.ctx.direction = styles.direction === 1 ? "rtl" : "ltr";
                this.ctx.textAlign = "left";
                this.ctx.textBaseline = "alphabetic";
                _b = this.fontMetrics.getMetrics(fontFamily2, fontSize2), baseline = _b.baseline, middle = _b.middle;
                paintOrder2 = styles.paintOrder;
                text.textBounds.forEach(function(text2) {
                  paintOrder2.forEach(function(paintOrderLayer) {
                    switch (paintOrderLayer) {
                      case 0:
                        _this.ctx.fillStyle = asString(styles.color);
                        _this.renderTextWithLetterSpacing(text2, styles.letterSpacing, baseline);
                        var textShadows = styles.textShadow;
                        if (textShadows.length && text2.text.trim().length) {
                          textShadows.slice(0).reverse().forEach(function(textShadow2) {
                            _this.ctx.shadowColor = asString(textShadow2.color);
                            _this.ctx.shadowOffsetX = textShadow2.offsetX.number * _this.options.scale;
                            _this.ctx.shadowOffsetY = textShadow2.offsetY.number * _this.options.scale;
                            _this.ctx.shadowBlur = textShadow2.blur.number;
                            _this.renderTextWithLetterSpacing(text2, styles.letterSpacing, baseline);
                          });
                          _this.ctx.shadowColor = "";
                          _this.ctx.shadowOffsetX = 0;
                          _this.ctx.shadowOffsetY = 0;
                          _this.ctx.shadowBlur = 0;
                        }
                        if (styles.textDecorationLine.length) {
                          _this.ctx.fillStyle = asString(styles.textDecorationColor || styles.color);
                          styles.textDecorationLine.forEach(function(textDecorationLine2) {
                            switch (textDecorationLine2) {
                              case 1:
                                _this.ctx.fillRect(text2.bounds.left, Math.round(text2.bounds.top + baseline), text2.bounds.width, 1);
                                break;
                              case 2:
                                _this.ctx.fillRect(text2.bounds.left, Math.round(text2.bounds.top), text2.bounds.width, 1);
                                break;
                              case 3:
                                _this.ctx.fillRect(text2.bounds.left, Math.ceil(text2.bounds.top + middle), text2.bounds.width, 1);
                                break;
                            }
                          });
                        }
                        break;
                      case 1:
                        if (styles.webkitTextStrokeWidth && text2.text.trim().length) {
                          _this.ctx.strokeStyle = asString(styles.webkitTextStrokeColor);
                          _this.ctx.lineWidth = styles.webkitTextStrokeWidth;
                          _this.ctx.lineJoin = !!window.chrome ? "miter" : "round";
                          _this.ctx.strokeText(text2.text, text2.bounds.left, text2.bounds.top + baseline);
                        }
                        _this.ctx.strokeStyle = "";
                        _this.ctx.lineWidth = 0;
                        _this.ctx.lineJoin = "miter";
                        break;
                    }
                  });
                });
                return [
                  2
                  /*return*/
                ];
              });
            });
          };
          CanvasRenderer2.prototype.renderReplacedElement = function(container, curves, image2) {
            if (image2 && container.intrinsicWidth > 0 && container.intrinsicHeight > 0) {
              var box = contentBox(container);
              var path = calculatePaddingBoxPath(curves);
              this.path(path);
              this.ctx.save();
              this.ctx.clip();
              this.ctx.drawImage(image2, 0, 0, container.intrinsicWidth, container.intrinsicHeight, box.left, box.top, box.width, box.height);
              this.ctx.restore();
            }
          };
          CanvasRenderer2.prototype.renderNodeContent = function(paint) {
            return __awaiter(this, void 0, void 0, function() {
              var container, curves, styles, _i, _a, child, image2, image2, iframeRenderer, canvas, size4, _b, fontFamily2, fontSize2, baseline, bounds, x3, textBounds, img, image2, url2, fontFamily2, bounds;
              return __generator(this, function(_c) {
                switch (_c.label) {
                  case 0:
                    this.applyEffects(paint.getEffects(
                      4
                      /* CONTENT */
                    ));
                    container = paint.container;
                    curves = paint.curves;
                    styles = container.styles;
                    _i = 0, _a = container.textNodes;
                    _c.label = 1;
                  case 1:
                    if (!(_i < _a.length)) return [3, 4];
                    child = _a[_i];
                    return [4, this.renderTextNode(child, styles)];
                  case 2:
                    _c.sent();
                    _c.label = 3;
                  case 3:
                    _i++;
                    return [3, 1];
                  case 4:
                    if (!(container instanceof ImageElementContainer)) return [3, 8];
                    _c.label = 5;
                  case 5:
                    _c.trys.push([5, 7, , 8]);
                    return [4, this.context.cache.match(container.src)];
                  case 6:
                    image2 = _c.sent();
                    this.renderReplacedElement(container, curves, image2);
                    return [3, 8];
                  case 7:
                    _c.sent();
                    this.context.logger.error("Error loading image " + container.src);
                    return [3, 8];
                  case 8:
                    if (container instanceof CanvasElementContainer) {
                      this.renderReplacedElement(container, curves, container.canvas);
                    }
                    if (!(container instanceof SVGElementContainer)) return [3, 12];
                    _c.label = 9;
                  case 9:
                    _c.trys.push([9, 11, , 12]);
                    return [4, this.context.cache.match(container.svg)];
                  case 10:
                    image2 = _c.sent();
                    this.renderReplacedElement(container, curves, image2);
                    return [3, 12];
                  case 11:
                    _c.sent();
                    this.context.logger.error("Error loading svg " + container.svg.substring(0, 255));
                    return [3, 12];
                  case 12:
                    if (!(container instanceof IFrameElementContainer && container.tree)) return [3, 14];
                    iframeRenderer = new CanvasRenderer2(this.context, {
                      scale: this.options.scale,
                      backgroundColor: container.backgroundColor,
                      x: 0,
                      y: 0,
                      width: container.width,
                      height: container.height
                    });
                    return [4, iframeRenderer.render(container.tree)];
                  case 13:
                    canvas = _c.sent();
                    if (container.width && container.height) {
                      this.ctx.drawImage(canvas, 0, 0, container.width, container.height, container.bounds.left, container.bounds.top, container.bounds.width, container.bounds.height);
                    }
                    _c.label = 14;
                  case 14:
                    if (container instanceof InputElementContainer) {
                      size4 = Math.min(container.bounds.width, container.bounds.height);
                      if (container.type === CHECKBOX) {
                        if (container.checked) {
                          this.ctx.save();
                          this.path([
                            new Vector(container.bounds.left + size4 * 0.39363, container.bounds.top + size4 * 0.79),
                            new Vector(container.bounds.left + size4 * 0.16, container.bounds.top + size4 * 0.5549),
                            new Vector(container.bounds.left + size4 * 0.27347, container.bounds.top + size4 * 0.44071),
                            new Vector(container.bounds.left + size4 * 0.39694, container.bounds.top + size4 * 0.5649),
                            new Vector(container.bounds.left + size4 * 0.72983, container.bounds.top + size4 * 0.23),
                            new Vector(container.bounds.left + size4 * 0.84, container.bounds.top + size4 * 0.34085),
                            new Vector(container.bounds.left + size4 * 0.39363, container.bounds.top + size4 * 0.79)
                          ]);
                          this.ctx.fillStyle = asString(INPUT_COLOR);
                          this.ctx.fill();
                          this.ctx.restore();
                        }
                      } else if (container.type === RADIO) {
                        if (container.checked) {
                          this.ctx.save();
                          this.ctx.beginPath();
                          this.ctx.arc(container.bounds.left + size4 / 2, container.bounds.top + size4 / 2, size4 / 4, 0, Math.PI * 2, true);
                          this.ctx.fillStyle = asString(INPUT_COLOR);
                          this.ctx.fill();
                          this.ctx.restore();
                        }
                      }
                    }
                    if (isTextInputElement(container) && container.value.length) {
                      _b = this.createFontStyle(styles), fontFamily2 = _b[0], fontSize2 = _b[1];
                      baseline = this.fontMetrics.getMetrics(fontFamily2, fontSize2).baseline;
                      this.ctx.font = fontFamily2;
                      this.ctx.fillStyle = asString(styles.color);
                      this.ctx.textBaseline = "alphabetic";
                      this.ctx.textAlign = canvasTextAlign(container.styles.textAlign);
                      bounds = contentBox(container);
                      x3 = 0;
                      switch (container.styles.textAlign) {
                        case 1:
                          x3 += bounds.width / 2;
                          break;
                        case 2:
                          x3 += bounds.width;
                          break;
                      }
                      textBounds = bounds.add(x3, 0, 0, -bounds.height / 2 + 1);
                      this.ctx.save();
                      this.path([
                        new Vector(bounds.left, bounds.top),
                        new Vector(bounds.left + bounds.width, bounds.top),
                        new Vector(bounds.left + bounds.width, bounds.top + bounds.height),
                        new Vector(bounds.left, bounds.top + bounds.height)
                      ]);
                      this.ctx.clip();
                      this.renderTextWithLetterSpacing(new TextBounds(container.value, textBounds), styles.letterSpacing, baseline);
                      this.ctx.restore();
                      this.ctx.textBaseline = "alphabetic";
                      this.ctx.textAlign = "left";
                    }
                    if (!contains3(
                      container.styles.display,
                      2048
                      /* LIST_ITEM */
                    )) return [3, 20];
                    if (!(container.styles.listStyleImage !== null)) return [3, 19];
                    img = container.styles.listStyleImage;
                    if (!(img.type === 0)) return [3, 18];
                    image2 = void 0;
                    url2 = img.url;
                    _c.label = 15;
                  case 15:
                    _c.trys.push([15, 17, , 18]);
                    return [4, this.context.cache.match(url2)];
                  case 16:
                    image2 = _c.sent();
                    this.ctx.drawImage(image2, container.bounds.left - (image2.width + 10), container.bounds.top);
                    return [3, 18];
                  case 17:
                    _c.sent();
                    this.context.logger.error("Error loading list-style-image " + url2);
                    return [3, 18];
                  case 18:
                    return [3, 20];
                  case 19:
                    if (paint.listValue && container.styles.listStyleType !== -1) {
                      fontFamily2 = this.createFontStyle(styles)[0];
                      this.ctx.font = fontFamily2;
                      this.ctx.fillStyle = asString(styles.color);
                      this.ctx.textBaseline = "middle";
                      this.ctx.textAlign = "right";
                      bounds = new Bounds(container.bounds.left, container.bounds.top + getAbsoluteValue(container.styles.paddingTop, container.bounds.width), container.bounds.width, computeLineHeight(styles.lineHeight, styles.fontSize.number) / 2 + 1);
                      this.renderTextWithLetterSpacing(new TextBounds(paint.listValue, bounds), styles.letterSpacing, computeLineHeight(styles.lineHeight, styles.fontSize.number) / 2 + 2);
                      this.ctx.textBaseline = "bottom";
                      this.ctx.textAlign = "left";
                    }
                    _c.label = 20;
                  case 20:
                    return [
                      2
                      /*return*/
                    ];
                }
              });
            });
          };
          CanvasRenderer2.prototype.renderStackContent = function(stack) {
            return __awaiter(this, void 0, void 0, function() {
              var _i, _a, child, _b, _c, child, _d, _e, child, _f, _g, child, _h, _j, child, _k, _l, child, _m, _o, child;
              return __generator(this, function(_p2) {
                switch (_p2.label) {
                  case 0:
                    if (contains3(
                      stack.element.container.flags,
                      16
                      /* DEBUG_RENDER */
                    )) {
                      debugger;
                    }
                    return [4, this.renderNodeBackgroundAndBorders(stack.element)];
                  case 1:
                    _p2.sent();
                    _i = 0, _a = stack.negativeZIndex;
                    _p2.label = 2;
                  case 2:
                    if (!(_i < _a.length)) return [3, 5];
                    child = _a[_i];
                    return [4, this.renderStack(child)];
                  case 3:
                    _p2.sent();
                    _p2.label = 4;
                  case 4:
                    _i++;
                    return [3, 2];
                  case 5:
                    return [4, this.renderNodeContent(stack.element)];
                  case 6:
                    _p2.sent();
                    _b = 0, _c = stack.nonInlineLevel;
                    _p2.label = 7;
                  case 7:
                    if (!(_b < _c.length)) return [3, 10];
                    child = _c[_b];
                    return [4, this.renderNode(child)];
                  case 8:
                    _p2.sent();
                    _p2.label = 9;
                  case 9:
                    _b++;
                    return [3, 7];
                  case 10:
                    _d = 0, _e = stack.nonPositionedFloats;
                    _p2.label = 11;
                  case 11:
                    if (!(_d < _e.length)) return [3, 14];
                    child = _e[_d];
                    return [4, this.renderStack(child)];
                  case 12:
                    _p2.sent();
                    _p2.label = 13;
                  case 13:
                    _d++;
                    return [3, 11];
                  case 14:
                    _f = 0, _g = stack.nonPositionedInlineLevel;
                    _p2.label = 15;
                  case 15:
                    if (!(_f < _g.length)) return [3, 18];
                    child = _g[_f];
                    return [4, this.renderStack(child)];
                  case 16:
                    _p2.sent();
                    _p2.label = 17;
                  case 17:
                    _f++;
                    return [3, 15];
                  case 18:
                    _h = 0, _j = stack.inlineLevel;
                    _p2.label = 19;
                  case 19:
                    if (!(_h < _j.length)) return [3, 22];
                    child = _j[_h];
                    return [4, this.renderNode(child)];
                  case 20:
                    _p2.sent();
                    _p2.label = 21;
                  case 21:
                    _h++;
                    return [3, 19];
                  case 22:
                    _k = 0, _l = stack.zeroOrAutoZIndexOrTransformedOrOpacity;
                    _p2.label = 23;
                  case 23:
                    if (!(_k < _l.length)) return [3, 26];
                    child = _l[_k];
                    return [4, this.renderStack(child)];
                  case 24:
                    _p2.sent();
                    _p2.label = 25;
                  case 25:
                    _k++;
                    return [3, 23];
                  case 26:
                    _m = 0, _o = stack.positiveZIndex;
                    _p2.label = 27;
                  case 27:
                    if (!(_m < _o.length)) return [3, 30];
                    child = _o[_m];
                    return [4, this.renderStack(child)];
                  case 28:
                    _p2.sent();
                    _p2.label = 29;
                  case 29:
                    _m++;
                    return [3, 27];
                  case 30:
                    return [
                      2
                      /*return*/
                    ];
                }
              });
            });
          };
          CanvasRenderer2.prototype.mask = function(paths) {
            this.ctx.beginPath();
            this.ctx.moveTo(0, 0);
            this.ctx.lineTo(this.canvas.width, 0);
            this.ctx.lineTo(this.canvas.width, this.canvas.height);
            this.ctx.lineTo(0, this.canvas.height);
            this.ctx.lineTo(0, 0);
            this.formatPath(paths.slice(0).reverse());
            this.ctx.closePath();
          };
          CanvasRenderer2.prototype.path = function(paths) {
            this.ctx.beginPath();
            this.formatPath(paths);
            this.ctx.closePath();
          };
          CanvasRenderer2.prototype.formatPath = function(paths) {
            var _this = this;
            paths.forEach(function(point, index) {
              var start = isBezierCurve(point) ? point.start : point;
              if (index === 0) {
                _this.ctx.moveTo(start.x, start.y);
              } else {
                _this.ctx.lineTo(start.x, start.y);
              }
              if (isBezierCurve(point)) {
                _this.ctx.bezierCurveTo(point.startControl.x, point.startControl.y, point.endControl.x, point.endControl.y, point.end.x, point.end.y);
              }
            });
          };
          CanvasRenderer2.prototype.renderRepeat = function(path, pattern, offsetX, offsetY) {
            this.path(path);
            this.ctx.fillStyle = pattern;
            this.ctx.translate(offsetX, offsetY);
            this.ctx.fill();
            this.ctx.translate(-offsetX, -offsetY);
          };
          CanvasRenderer2.prototype.resizeImage = function(image2, width, height) {
            var _a;
            if (image2.width === width && image2.height === height) {
              return image2;
            }
            var ownerDocument2 = (_a = this.canvas.ownerDocument) !== null && _a !== void 0 ? _a : document;
            var canvas = ownerDocument2.createElement("canvas");
            canvas.width = Math.max(1, width);
            canvas.height = Math.max(1, height);
            var ctx = canvas.getContext("2d");
            ctx.drawImage(image2, 0, 0, image2.width, image2.height, 0, 0, width, height);
            return canvas;
          };
          CanvasRenderer2.prototype.renderBackgroundImage = function(container) {
            return __awaiter(this, void 0, void 0, function() {
              var index, _loop_1, this_1, _i, _a, backgroundImage2;
              return __generator(this, function(_b) {
                switch (_b.label) {
                  case 0:
                    index = container.styles.backgroundImage.length - 1;
                    _loop_1 = function(backgroundImage3) {
                      var image2, url2, _c, path, x3, y3, width, height, pattern, _d, path, x3, y3, width, height, _e, lineLength, x0, x1, y0, y1, canvas, ctx, gradient_1, pattern, _f, path, left, top_1, width, height, position2, x3, y3, _g, rx, ry, radialGradient_1, midX, midY, f4, invF;
                      return __generator(this, function(_h) {
                        switch (_h.label) {
                          case 0:
                            if (!(backgroundImage3.type === 0)) return [3, 5];
                            image2 = void 0;
                            url2 = backgroundImage3.url;
                            _h.label = 1;
                          case 1:
                            _h.trys.push([1, 3, , 4]);
                            return [4, this_1.context.cache.match(url2)];
                          case 2:
                            image2 = _h.sent();
                            return [3, 4];
                          case 3:
                            _h.sent();
                            this_1.context.logger.error("Error loading background-image " + url2);
                            return [3, 4];
                          case 4:
                            if (image2) {
                              _c = calculateBackgroundRendering(container, index, [
                                image2.width,
                                image2.height,
                                image2.width / image2.height
                              ]), path = _c[0], x3 = _c[1], y3 = _c[2], width = _c[3], height = _c[4];
                              pattern = this_1.ctx.createPattern(this_1.resizeImage(image2, width, height), "repeat");
                              this_1.renderRepeat(path, pattern, x3, y3);
                            }
                            return [3, 6];
                          case 5:
                            if (isLinearGradient(backgroundImage3)) {
                              _d = calculateBackgroundRendering(container, index, [null, null, null]), path = _d[0], x3 = _d[1], y3 = _d[2], width = _d[3], height = _d[4];
                              _e = calculateGradientDirection(backgroundImage3.angle, width, height), lineLength = _e[0], x0 = _e[1], x1 = _e[2], y0 = _e[3], y1 = _e[4];
                              canvas = document.createElement("canvas");
                              canvas.width = width;
                              canvas.height = height;
                              ctx = canvas.getContext("2d");
                              gradient_1 = ctx.createLinearGradient(x0, y0, x1, y1);
                              processColorStops(backgroundImage3.stops, lineLength).forEach(function(colorStop) {
                                return gradient_1.addColorStop(colorStop.stop, asString(colorStop.color));
                              });
                              ctx.fillStyle = gradient_1;
                              ctx.fillRect(0, 0, width, height);
                              if (width > 0 && height > 0) {
                                pattern = this_1.ctx.createPattern(canvas, "repeat");
                                this_1.renderRepeat(path, pattern, x3, y3);
                              }
                            } else if (isRadialGradient(backgroundImage3)) {
                              _f = calculateBackgroundRendering(container, index, [
                                null,
                                null,
                                null
                              ]), path = _f[0], left = _f[1], top_1 = _f[2], width = _f[3], height = _f[4];
                              position2 = backgroundImage3.position.length === 0 ? [FIFTY_PERCENT] : backgroundImage3.position;
                              x3 = getAbsoluteValue(position2[0], width);
                              y3 = getAbsoluteValue(position2[position2.length - 1], height);
                              _g = calculateRadius(backgroundImage3, x3, y3, width, height), rx = _g[0], ry = _g[1];
                              if (rx > 0 && ry > 0) {
                                radialGradient_1 = this_1.ctx.createRadialGradient(left + x3, top_1 + y3, 0, left + x3, top_1 + y3, rx);
                                processColorStops(backgroundImage3.stops, rx * 2).forEach(function(colorStop) {
                                  return radialGradient_1.addColorStop(colorStop.stop, asString(colorStop.color));
                                });
                                this_1.path(path);
                                this_1.ctx.fillStyle = radialGradient_1;
                                if (rx !== ry) {
                                  midX = container.bounds.left + 0.5 * container.bounds.width;
                                  midY = container.bounds.top + 0.5 * container.bounds.height;
                                  f4 = ry / rx;
                                  invF = 1 / f4;
                                  this_1.ctx.save();
                                  this_1.ctx.translate(midX, midY);
                                  this_1.ctx.transform(1, 0, 0, f4, 0, 0);
                                  this_1.ctx.translate(-midX, -midY);
                                  this_1.ctx.fillRect(left, invF * (top_1 - midY) + midY, width, height * invF);
                                  this_1.ctx.restore();
                                } else {
                                  this_1.ctx.fill();
                                }
                              }
                            }
                            _h.label = 6;
                          case 6:
                            index--;
                            return [
                              2
                              /*return*/
                            ];
                        }
                      });
                    };
                    this_1 = this;
                    _i = 0, _a = container.styles.backgroundImage.slice(0).reverse();
                    _b.label = 1;
                  case 1:
                    if (!(_i < _a.length)) return [3, 4];
                    backgroundImage2 = _a[_i];
                    return [5, _loop_1(backgroundImage2)];
                  case 2:
                    _b.sent();
                    _b.label = 3;
                  case 3:
                    _i++;
                    return [3, 1];
                  case 4:
                    return [
                      2
                      /*return*/
                    ];
                }
              });
            });
          };
          CanvasRenderer2.prototype.renderSolidBorder = function(color2, side, curvePoints) {
            return __awaiter(this, void 0, void 0, function() {
              return __generator(this, function(_a) {
                this.path(parsePathForBorder(curvePoints, side));
                this.ctx.fillStyle = asString(color2);
                this.ctx.fill();
                return [
                  2
                  /*return*/
                ];
              });
            });
          };
          CanvasRenderer2.prototype.renderDoubleBorder = function(color2, width, side, curvePoints) {
            return __awaiter(this, void 0, void 0, function() {
              var outerPaths, innerPaths;
              return __generator(this, function(_a) {
                switch (_a.label) {
                  case 0:
                    if (!(width < 3)) return [3, 2];
                    return [4, this.renderSolidBorder(color2, side, curvePoints)];
                  case 1:
                    _a.sent();
                    return [
                      2
                      /*return*/
                    ];
                  case 2:
                    outerPaths = parsePathForBorderDoubleOuter(curvePoints, side);
                    this.path(outerPaths);
                    this.ctx.fillStyle = asString(color2);
                    this.ctx.fill();
                    innerPaths = parsePathForBorderDoubleInner(curvePoints, side);
                    this.path(innerPaths);
                    this.ctx.fill();
                    return [
                      2
                      /*return*/
                    ];
                }
              });
            });
          };
          CanvasRenderer2.prototype.renderNodeBackgroundAndBorders = function(paint) {
            return __awaiter(this, void 0, void 0, function() {
              var styles, hasBackground, borders, backgroundPaintingArea, side, _i, borders_1, border;
              var _this = this;
              return __generator(this, function(_a) {
                switch (_a.label) {
                  case 0:
                    this.applyEffects(paint.getEffects(
                      2
                      /* BACKGROUND_BORDERS */
                    ));
                    styles = paint.container.styles;
                    hasBackground = !isTransparent(styles.backgroundColor) || styles.backgroundImage.length;
                    borders = [
                      { style: styles.borderTopStyle, color: styles.borderTopColor, width: styles.borderTopWidth },
                      { style: styles.borderRightStyle, color: styles.borderRightColor, width: styles.borderRightWidth },
                      { style: styles.borderBottomStyle, color: styles.borderBottomColor, width: styles.borderBottomWidth },
                      { style: styles.borderLeftStyle, color: styles.borderLeftColor, width: styles.borderLeftWidth }
                    ];
                    backgroundPaintingArea = calculateBackgroundCurvedPaintingArea(getBackgroundValueForIndex(styles.backgroundClip, 0), paint.curves);
                    if (!(hasBackground || styles.boxShadow.length)) return [3, 2];
                    this.ctx.save();
                    this.path(backgroundPaintingArea);
                    this.ctx.clip();
                    if (!isTransparent(styles.backgroundColor)) {
                      this.ctx.fillStyle = asString(styles.backgroundColor);
                      this.ctx.fill();
                    }
                    return [4, this.renderBackgroundImage(paint.container)];
                  case 1:
                    _a.sent();
                    this.ctx.restore();
                    styles.boxShadow.slice(0).reverse().forEach(function(shadow) {
                      _this.ctx.save();
                      var borderBoxArea = calculateBorderBoxPath(paint.curves);
                      var maskOffset = shadow.inset ? 0 : MASK_OFFSET;
                      var shadowPaintingArea = transformPath(borderBoxArea, -maskOffset + (shadow.inset ? 1 : -1) * shadow.spread.number, (shadow.inset ? 1 : -1) * shadow.spread.number, shadow.spread.number * (shadow.inset ? -2 : 2), shadow.spread.number * (shadow.inset ? -2 : 2));
                      if (shadow.inset) {
                        _this.path(borderBoxArea);
                        _this.ctx.clip();
                        _this.mask(shadowPaintingArea);
                      } else {
                        _this.mask(borderBoxArea);
                        _this.ctx.clip();
                        _this.path(shadowPaintingArea);
                      }
                      _this.ctx.shadowOffsetX = shadow.offsetX.number + maskOffset;
                      _this.ctx.shadowOffsetY = shadow.offsetY.number;
                      _this.ctx.shadowColor = asString(shadow.color);
                      _this.ctx.shadowBlur = shadow.blur.number;
                      _this.ctx.fillStyle = shadow.inset ? asString(shadow.color) : "rgba(0,0,0,1)";
                      _this.ctx.fill();
                      _this.ctx.restore();
                    });
                    _a.label = 2;
                  case 2:
                    side = 0;
                    _i = 0, borders_1 = borders;
                    _a.label = 3;
                  case 3:
                    if (!(_i < borders_1.length)) return [3, 13];
                    border = borders_1[_i];
                    if (!(border.style !== 0 && !isTransparent(border.color) && border.width > 0)) return [3, 11];
                    if (!(border.style === 2)) return [3, 5];
                    return [4, this.renderDashedDottedBorder(
                      border.color,
                      border.width,
                      side,
                      paint.curves,
                      2
                      /* DASHED */
                    )];
                  case 4:
                    _a.sent();
                    return [3, 11];
                  case 5:
                    if (!(border.style === 3)) return [3, 7];
                    return [4, this.renderDashedDottedBorder(
                      border.color,
                      border.width,
                      side,
                      paint.curves,
                      3
                      /* DOTTED */
                    )];
                  case 6:
                    _a.sent();
                    return [3, 11];
                  case 7:
                    if (!(border.style === 4)) return [3, 9];
                    return [4, this.renderDoubleBorder(border.color, border.width, side, paint.curves)];
                  case 8:
                    _a.sent();
                    return [3, 11];
                  case 9:
                    return [4, this.renderSolidBorder(border.color, side, paint.curves)];
                  case 10:
                    _a.sent();
                    _a.label = 11;
                  case 11:
                    side++;
                    _a.label = 12;
                  case 12:
                    _i++;
                    return [3, 3];
                  case 13:
                    return [
                      2
                      /*return*/
                    ];
                }
              });
            });
          };
          CanvasRenderer2.prototype.renderDashedDottedBorder = function(color2, width, side, curvePoints, style3) {
            return __awaiter(this, void 0, void 0, function() {
              var strokePaths, boxPaths, startX, startY, endX, endY, length, dashLength, spaceLength, useLineDash, multiplier, numberOfDashes, minSpace, maxSpace, path1, path2, path1, path2;
              return __generator(this, function(_a) {
                this.ctx.save();
                strokePaths = parsePathForBorderStroke(curvePoints, side);
                boxPaths = parsePathForBorder(curvePoints, side);
                if (style3 === 2) {
                  this.path(boxPaths);
                  this.ctx.clip();
                }
                if (isBezierCurve(boxPaths[0])) {
                  startX = boxPaths[0].start.x;
                  startY = boxPaths[0].start.y;
                } else {
                  startX = boxPaths[0].x;
                  startY = boxPaths[0].y;
                }
                if (isBezierCurve(boxPaths[1])) {
                  endX = boxPaths[1].end.x;
                  endY = boxPaths[1].end.y;
                } else {
                  endX = boxPaths[1].x;
                  endY = boxPaths[1].y;
                }
                if (side === 0 || side === 2) {
                  length = Math.abs(startX - endX);
                } else {
                  length = Math.abs(startY - endY);
                }
                this.ctx.beginPath();
                if (style3 === 3) {
                  this.formatPath(strokePaths);
                } else {
                  this.formatPath(boxPaths.slice(0, 2));
                }
                dashLength = width < 3 ? width * 3 : width * 2;
                spaceLength = width < 3 ? width * 2 : width;
                if (style3 === 3) {
                  dashLength = width;
                  spaceLength = width;
                }
                useLineDash = true;
                if (length <= dashLength * 2) {
                  useLineDash = false;
                } else if (length <= dashLength * 2 + spaceLength) {
                  multiplier = length / (2 * dashLength + spaceLength);
                  dashLength *= multiplier;
                  spaceLength *= multiplier;
                } else {
                  numberOfDashes = Math.floor((length + spaceLength) / (dashLength + spaceLength));
                  minSpace = (length - numberOfDashes * dashLength) / (numberOfDashes - 1);
                  maxSpace = (length - (numberOfDashes + 1) * dashLength) / numberOfDashes;
                  spaceLength = maxSpace <= 0 || Math.abs(spaceLength - minSpace) < Math.abs(spaceLength - maxSpace) ? minSpace : maxSpace;
                }
                if (useLineDash) {
                  if (style3 === 3) {
                    this.ctx.setLineDash([0, dashLength + spaceLength]);
                  } else {
                    this.ctx.setLineDash([dashLength, spaceLength]);
                  }
                }
                if (style3 === 3) {
                  this.ctx.lineCap = "round";
                  this.ctx.lineWidth = width;
                } else {
                  this.ctx.lineWidth = width * 2 + 1.1;
                }
                this.ctx.strokeStyle = asString(color2);
                this.ctx.stroke();
                this.ctx.setLineDash([]);
                if (style3 === 2) {
                  if (isBezierCurve(boxPaths[0])) {
                    path1 = boxPaths[3];
                    path2 = boxPaths[0];
                    this.ctx.beginPath();
                    this.formatPath([new Vector(path1.end.x, path1.end.y), new Vector(path2.start.x, path2.start.y)]);
                    this.ctx.stroke();
                  }
                  if (isBezierCurve(boxPaths[1])) {
                    path1 = boxPaths[1];
                    path2 = boxPaths[2];
                    this.ctx.beginPath();
                    this.formatPath([new Vector(path1.end.x, path1.end.y), new Vector(path2.start.x, path2.start.y)]);
                    this.ctx.stroke();
                  }
                }
                this.ctx.restore();
                return [
                  2
                  /*return*/
                ];
              });
            });
          };
          CanvasRenderer2.prototype.render = function(element) {
            return __awaiter(this, void 0, void 0, function() {
              var stack;
              return __generator(this, function(_a) {
                switch (_a.label) {
                  case 0:
                    if (this.options.backgroundColor) {
                      this.ctx.fillStyle = asString(this.options.backgroundColor);
                      this.ctx.fillRect(this.options.x, this.options.y, this.options.width, this.options.height);
                    }
                    stack = parseStackingContexts(element);
                    return [4, this.renderStack(stack)];
                  case 1:
                    _a.sent();
                    this.applyEffects([]);
                    return [2, this.canvas];
                }
              });
            });
          };
          return CanvasRenderer2;
        }(Renderer2)
      );
      var isTextInputElement = function(container) {
        if (container instanceof TextareaElementContainer) {
          return true;
        } else if (container instanceof SelectElementContainer) {
          return true;
        } else if (container instanceof InputElementContainer && container.type !== RADIO && container.type !== CHECKBOX) {
          return true;
        }
        return false;
      };
      var calculateBackgroundCurvedPaintingArea = function(clip, curves) {
        switch (clip) {
          case 0:
            return calculateBorderBoxPath(curves);
          case 2:
            return calculateContentBoxPath(curves);
          case 1:
          default:
            return calculatePaddingBoxPath(curves);
        }
      };
      var canvasTextAlign = function(textAlign2) {
        switch (textAlign2) {
          case 1:
            return "center";
          case 2:
            return "right";
          case 0:
          default:
            return "left";
        }
      };
      var iOSBrokenFonts = ["-apple-system", "system-ui"];
      var fixIOSSystemFonts = function(fontFamilies) {
        return /iPhone OS 15_(0|1)/.test(window.navigator.userAgent) ? fontFamilies.filter(function(fontFamily2) {
          return iOSBrokenFonts.indexOf(fontFamily2) === -1;
        }) : fontFamilies;
      };
      var ForeignObjectRenderer = (
        /** @class */
        function(_super) {
          __extends(ForeignObjectRenderer2, _super);
          function ForeignObjectRenderer2(context, options2) {
            var _this = _super.call(this, context, options2) || this;
            _this.canvas = options2.canvas ? options2.canvas : document.createElement("canvas");
            _this.ctx = _this.canvas.getContext("2d");
            _this.options = options2;
            _this.canvas.width = Math.floor(options2.width * options2.scale);
            _this.canvas.height = Math.floor(options2.height * options2.scale);
            _this.canvas.style.width = options2.width + "px";
            _this.canvas.style.height = options2.height + "px";
            _this.ctx.scale(_this.options.scale, _this.options.scale);
            _this.ctx.translate(-options2.x, -options2.y);
            _this.context.logger.debug("EXPERIMENTAL ForeignObject renderer initialized (" + options2.width + "x" + options2.height + " at " + options2.x + "," + options2.y + ") with scale " + options2.scale);
            return _this;
          }
          ForeignObjectRenderer2.prototype.render = function(element) {
            return __awaiter(this, void 0, void 0, function() {
              var svg, img;
              return __generator(this, function(_a) {
                switch (_a.label) {
                  case 0:
                    svg = createForeignObjectSVG(this.options.width * this.options.scale, this.options.height * this.options.scale, this.options.scale, this.options.scale, element);
                    return [4, loadSerializedSVG(svg)];
                  case 1:
                    img = _a.sent();
                    if (this.options.backgroundColor) {
                      this.ctx.fillStyle = asString(this.options.backgroundColor);
                      this.ctx.fillRect(0, 0, this.options.width * this.options.scale, this.options.height * this.options.scale);
                    }
                    this.ctx.drawImage(img, -this.options.x * this.options.scale, -this.options.y * this.options.scale);
                    return [2, this.canvas];
                }
              });
            });
          };
          return ForeignObjectRenderer2;
        }(Renderer2)
      );
      var loadSerializedSVG = function(svg) {
        return new Promise(function(resolve2, reject2) {
          var img = new Image();
          img.onload = function() {
            resolve2(img);
          };
          img.onerror = reject2;
          img.src = "data:image/svg+xml;charset=utf-8," + encodeURIComponent(new XMLSerializer().serializeToString(svg));
        });
      };
      var Logger = (
        /** @class */
        function() {
          function Logger2(_a) {
            var id = _a.id, enabled = _a.enabled;
            this.id = id;
            this.enabled = enabled;
            this.start = Date.now();
          }
          Logger2.prototype.debug = function() {
            var args = [];
            for (var _i = 0; _i < arguments.length; _i++) {
              args[_i] = arguments[_i];
            }
            if (this.enabled) {
              if (typeof window !== "undefined" && window.console && typeof console.debug === "function") {
                console.debug.apply(console, __spreadArray([this.id, this.getTime() + "ms"], args));
              } else {
                this.info.apply(this, args);
              }
            }
          };
          Logger2.prototype.getTime = function() {
            return Date.now() - this.start;
          };
          Logger2.prototype.info = function() {
            var args = [];
            for (var _i = 0; _i < arguments.length; _i++) {
              args[_i] = arguments[_i];
            }
            if (this.enabled) {
              if (typeof window !== "undefined" && window.console && typeof console.info === "function") {
                console.info.apply(console, __spreadArray([this.id, this.getTime() + "ms"], args));
              }
            }
          };
          Logger2.prototype.warn = function() {
            var args = [];
            for (var _i = 0; _i < arguments.length; _i++) {
              args[_i] = arguments[_i];
            }
            if (this.enabled) {
              if (typeof window !== "undefined" && window.console && typeof console.warn === "function") {
                console.warn.apply(console, __spreadArray([this.id, this.getTime() + "ms"], args));
              } else {
                this.info.apply(this, args);
              }
            }
          };
          Logger2.prototype.error = function() {
            var args = [];
            for (var _i = 0; _i < arguments.length; _i++) {
              args[_i] = arguments[_i];
            }
            if (this.enabled) {
              if (typeof window !== "undefined" && window.console && typeof console.error === "function") {
                console.error.apply(console, __spreadArray([this.id, this.getTime() + "ms"], args));
              } else {
                this.info.apply(this, args);
              }
            }
          };
          Logger2.instances = {};
          return Logger2;
        }()
      );
      var Context = (
        /** @class */
        function() {
          function Context2(options2, windowBounds) {
            var _a;
            this.windowBounds = windowBounds;
            this.instanceName = "#" + Context2.instanceCount++;
            this.logger = new Logger({ id: this.instanceName, enabled: options2.logging });
            this.cache = (_a = options2.cache) !== null && _a !== void 0 ? _a : new Cache(this, options2);
          }
          Context2.instanceCount = 1;
          return Context2;
        }()
      );
      var html2canvas3 = function(element, options2) {
        if (options2 === void 0) {
          options2 = {};
        }
        return renderElement(element, options2);
      };
      if (typeof window !== "undefined") {
        CacheStorage.setContext(window);
      }
      var renderElement = function(element, opts) {
        return __awaiter(void 0, void 0, void 0, function() {
          var ownerDocument2, defaultView, resourceOptions, contextOptions, windowOptions, windowBounds, context, foreignObjectRendering, cloneOptions, documentCloner, clonedElement, container, _a, width, height, left, top, backgroundColor2, renderOptions, canvas, renderer, root2, renderer;
          var _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p2, _q, _r, _s, _t;
          return __generator(this, function(_u) {
            switch (_u.label) {
              case 0:
                if (!element || typeof element !== "object") {
                  return [2, Promise.reject("Invalid element provided as first argument")];
                }
                ownerDocument2 = element.ownerDocument;
                if (!ownerDocument2) {
                  throw new Error("Element is not attached to a Document");
                }
                defaultView = ownerDocument2.defaultView;
                if (!defaultView) {
                  throw new Error("Document is not attached to a Window");
                }
                resourceOptions = {
                  allowTaint: (_b = opts.allowTaint) !== null && _b !== void 0 ? _b : false,
                  imageTimeout: (_c = opts.imageTimeout) !== null && _c !== void 0 ? _c : 15e3,
                  proxy: opts.proxy,
                  useCORS: (_d = opts.useCORS) !== null && _d !== void 0 ? _d : false
                };
                contextOptions = __assign({ logging: (_e = opts.logging) !== null && _e !== void 0 ? _e : true, cache: opts.cache }, resourceOptions);
                windowOptions = {
                  windowWidth: (_f = opts.windowWidth) !== null && _f !== void 0 ? _f : defaultView.innerWidth,
                  windowHeight: (_g = opts.windowHeight) !== null && _g !== void 0 ? _g : defaultView.innerHeight,
                  scrollX: (_h = opts.scrollX) !== null && _h !== void 0 ? _h : defaultView.pageXOffset,
                  scrollY: (_j = opts.scrollY) !== null && _j !== void 0 ? _j : defaultView.pageYOffset
                };
                windowBounds = new Bounds(windowOptions.scrollX, windowOptions.scrollY, windowOptions.windowWidth, windowOptions.windowHeight);
                context = new Context(contextOptions, windowBounds);
                foreignObjectRendering = (_k = opts.foreignObjectRendering) !== null && _k !== void 0 ? _k : false;
                cloneOptions = {
                  allowTaint: (_l = opts.allowTaint) !== null && _l !== void 0 ? _l : false,
                  onclone: opts.onclone,
                  ignoreElements: opts.ignoreElements,
                  inlineImages: foreignObjectRendering,
                  copyStyles: foreignObjectRendering
                };
                context.logger.debug("Starting document clone with size " + windowBounds.width + "x" + windowBounds.height + " scrolled to " + -windowBounds.left + "," + -windowBounds.top);
                documentCloner = new DocumentCloner(context, element, cloneOptions);
                clonedElement = documentCloner.clonedReferenceElement;
                if (!clonedElement) {
                  return [2, Promise.reject("Unable to find element in cloned iframe")];
                }
                return [4, documentCloner.toIFrame(ownerDocument2, windowBounds)];
              case 1:
                container = _u.sent();
                _a = isBodyElement(clonedElement) || isHTMLElement(clonedElement) ? parseDocumentSize(clonedElement.ownerDocument) : parseBounds(context, clonedElement), width = _a.width, height = _a.height, left = _a.left, top = _a.top;
                backgroundColor2 = parseBackgroundColor(context, clonedElement, opts.backgroundColor);
                renderOptions = {
                  canvas: opts.canvas,
                  backgroundColor: backgroundColor2,
                  scale: (_o = (_m = opts.scale) !== null && _m !== void 0 ? _m : defaultView.devicePixelRatio) !== null && _o !== void 0 ? _o : 1,
                  x: ((_p2 = opts.x) !== null && _p2 !== void 0 ? _p2 : 0) + left,
                  y: ((_q = opts.y) !== null && _q !== void 0 ? _q : 0) + top,
                  width: (_r = opts.width) !== null && _r !== void 0 ? _r : Math.ceil(width),
                  height: (_s = opts.height) !== null && _s !== void 0 ? _s : Math.ceil(height)
                };
                if (!foreignObjectRendering) return [3, 3];
                context.logger.debug("Document cloned, using foreign object rendering");
                renderer = new ForeignObjectRenderer(context, renderOptions);
                return [4, renderer.render(clonedElement)];
              case 2:
                canvas = _u.sent();
                return [3, 5];
              case 3:
                context.logger.debug("Document cloned, element located at " + left + "," + top + " with size " + width + "x" + height + " using computed rendering");
                context.logger.debug("Starting DOM parsing");
                root2 = parseTree(context, clonedElement);
                if (backgroundColor2 === root2.styles.backgroundColor) {
                  root2.styles.backgroundColor = COLORS.TRANSPARENT;
                }
                context.logger.debug("Starting renderer for element at " + renderOptions.x + "," + renderOptions.y + " with size " + renderOptions.width + "x" + renderOptions.height);
                renderer = new CanvasRenderer(context, renderOptions);
                return [4, renderer.render(root2)];
              case 4:
                canvas = _u.sent();
                _u.label = 5;
              case 5:
                if ((_t = opts.removeContainer) !== null && _t !== void 0 ? _t : true) {
                  if (!DocumentCloner.destroy(container)) {
                    context.logger.error("Cannot detach cloned iframe as it is not in the DOM anymore");
                  }
                }
                context.logger.debug("Finished rendering");
                return [2, canvas];
            }
          });
        });
      };
      var parseBackgroundColor = function(context, element, backgroundColorOverride) {
        var ownerDocument2 = element.ownerDocument;
        var documentBackgroundColor = ownerDocument2.documentElement ? parseColor(context, getComputedStyle(ownerDocument2.documentElement).backgroundColor) : COLORS.TRANSPARENT;
        var bodyBackgroundColor = ownerDocument2.body ? parseColor(context, getComputedStyle(ownerDocument2.body).backgroundColor) : COLORS.TRANSPARENT;
        var defaultBackgroundColor = typeof backgroundColorOverride === "string" ? parseColor(context, backgroundColorOverride) : backgroundColorOverride === null ? COLORS.TRANSPARENT : 4294967295;
        return element === ownerDocument2.documentElement ? isTransparent(documentBackgroundColor) ? isTransparent(bodyBackgroundColor) ? defaultBackgroundColor : bodyBackgroundColor : documentBackgroundColor : defaultBackgroundColor;
      };
      return html2canvas3;
    });
  }
});

// node_modules/qrious/dist/qrious.js
var require_qrious = __commonJS({
  "node_modules/qrious/dist/qrious.js"(exports, module) {
    (function(global5, factory) {
      typeof exports === "object" && typeof module !== "undefined" ? module.exports = factory() : typeof define === "function" && define.amd ? define(factory) : global5.QRious = factory();
    })(exports, function() {
      "use strict";
      var Constructor = (
        /* istanbul ignore next */
        function() {
        }
      );
      var hasOwnProperty2 = Object.prototype.hasOwnProperty;
      var slice3 = Array.prototype.slice;
      function createObject(prototype, properties) {
        var result2;
        if (typeof Object.create === "function") {
          result2 = Object.create(prototype);
        } else {
          Constructor.prototype = prototype;
          result2 = new Constructor();
          Constructor.prototype = null;
        }
        if (properties) {
          extendObject(true, result2, properties);
        }
        return result2;
      }
      function extend(name, constructor, prototype, statics) {
        var superConstructor = this;
        if (typeof name !== "string") {
          statics = prototype;
          prototype = constructor;
          constructor = name;
          name = null;
        }
        if (typeof constructor !== "function") {
          statics = prototype;
          prototype = constructor;
          constructor = function() {
            return superConstructor.apply(this, arguments);
          };
        }
        extendObject(false, constructor, superConstructor, statics);
        constructor.prototype = createObject(superConstructor.prototype, prototype);
        constructor.prototype.constructor = constructor;
        constructor.class_ = name || superConstructor.class_;
        constructor.super_ = superConstructor;
        return constructor;
      }
      function extendObject(own, target, sources) {
        sources = slice3.call(arguments, 2);
        var property2;
        var source;
        for (var i3 = 0, length = sources.length; i3 < length; i3++) {
          source = sources[i3];
          for (property2 in source) {
            if (!own || hasOwnProperty2.call(source, property2)) {
              target[property2] = source[property2];
            }
          }
        }
      }
      var extend_1 = extend;
      function Nevis() {
      }
      Nevis.class_ = "Nevis";
      Nevis.super_ = Object;
      Nevis.extend = extend_1;
      var nevis = Nevis;
      var lite = nevis;
      var Renderer2 = lite.extend(function(qrious, element, enabled) {
        this.qrious = qrious;
        this.element = element;
        this.element.qrious = qrious;
        this.enabled = Boolean(enabled);
      }, {
        /**
         * Draws the specified QR code <code>frame</code> on the underlying element.
         *
         * Implementations of {@link Renderer} <b>must</b> override this method with their own specific logic.
         *
         * @param {Frame} frame - the {@link Frame} to be drawn
         * @return {void}
         * @protected
         * @abstract
         * @memberof Renderer#
         */
        draw: function(frame) {
        },
        /**
         * Returns the element onto which this {@link Renderer} is rendering the QR code.
         *
         * If this method is called while this {@link Renderer} is disabled, it will be immediately enabled and rendered
         * before the element is returned.
         *
         * @return {*} The element.
         * @public
         * @memberof Renderer#
         */
        getElement: function() {
          if (!this.enabled) {
            this.enabled = true;
            this.render();
          }
          return this.element;
        },
        /**
         * Calculates the size (in pixel units) to represent an individual module within the QR code based on the
         * <code>frame</code> provided.
         *
         * Any configured padding will be excluded from the returned size.
         *
         * The returned value will be at least one, even in cases where the size of the QR code does not fit its contents.
         * This is done so that the inevitable clipping is handled more gracefully since this way at least something is
         * displayed instead of just a blank space filled by the background color.
         *
         * @param {Frame} frame - the {@link Frame} from which the module size is to be derived
         * @return {number} The pixel size for each module in the QR code which will be no less than one.
         * @protected
         * @memberof Renderer#
         */
        getModuleSize: function(frame) {
          var qrious = this.qrious;
          var padding = qrious.padding || 0;
          var pixels = Math.floor((qrious.size - padding * 2) / frame.width);
          return Math.max(1, pixels);
        },
        /**
         * Calculates the offset/padding (in pixel units) to be inserted before the QR code based on the <code>frame</code>
         * provided.
         *
         * The returned value will be zero if there is no available offset or if the size of the QR code does not fit its
         * contents. It will never be a negative value. This is done so that the inevitable clipping appears more naturally
         * and it is not clipped from all directions.
         *
         * @param {Frame} frame - the {@link Frame} from which the offset is to be derived
         * @return {number} The pixel offset for the QR code which will be no less than zero.
         * @protected
         * @memberof Renderer#
         */
        getOffset: function(frame) {
          var qrious = this.qrious;
          var padding = qrious.padding;
          if (padding != null) {
            return padding;
          }
          var moduleSize = this.getModuleSize(frame);
          var offset = Math.floor((qrious.size - moduleSize * frame.width) / 2);
          return Math.max(0, offset);
        },
        /**
         * Renders a QR code on the underlying element based on the <code>frame</code> provided.
         *
         * @param {Frame} frame - the {@link Frame} to be rendered
         * @return {void}
         * @public
         * @memberof Renderer#
         */
        render: function(frame) {
          if (this.enabled) {
            this.resize();
            this.reset();
            this.draw(frame);
          }
        },
        /**
         * Resets the underlying element, effectively clearing any previously rendered QR code.
         *
         * Implementations of {@link Renderer} <b>must</b> override this method with their own specific logic.
         *
         * @return {void}
         * @protected
         * @abstract
         * @memberof Renderer#
         */
        reset: function() {
        },
        /**
         * Ensures that the size of the underlying element matches that defined on the associated {@link QRious} instance.
         *
         * Implementations of {@link Renderer} <b>must</b> override this method with their own specific logic.
         *
         * @return {void}
         * @protected
         * @abstract
         * @memberof Renderer#
         */
        resize: function() {
        }
      });
      var Renderer_1 = Renderer2;
      var CanvasRenderer = Renderer_1.extend({
        /**
         * @override
         */
        draw: function(frame) {
          var i3, j;
          var qrious = this.qrious;
          var moduleSize = this.getModuleSize(frame);
          var offset = this.getOffset(frame);
          var context = this.element.getContext("2d");
          context.fillStyle = qrious.foreground;
          context.globalAlpha = qrious.foregroundAlpha;
          for (i3 = 0; i3 < frame.width; i3++) {
            for (j = 0; j < frame.width; j++) {
              if (frame.buffer[j * frame.width + i3]) {
                context.fillRect(moduleSize * i3 + offset, moduleSize * j + offset, moduleSize, moduleSize);
              }
            }
          }
        },
        /**
         * @override
         */
        reset: function() {
          var qrious = this.qrious;
          var context = this.element.getContext("2d");
          var size4 = qrious.size;
          context.lineWidth = 1;
          context.clearRect(0, 0, size4, size4);
          context.fillStyle = qrious.background;
          context.globalAlpha = qrious.backgroundAlpha;
          context.fillRect(0, 0, size4, size4);
        },
        /**
         * @override
         */
        resize: function() {
          var element = this.element;
          element.width = element.height = this.qrious.size;
        }
      });
      var CanvasRenderer_1 = CanvasRenderer;
      var Alignment = lite.extend(null, {
        /**
         * The alignment pattern block.
         *
         * @public
         * @static
         * @type {number[]}
         * @memberof Alignment
         */
        BLOCK: [
          0,
          11,
          15,
          19,
          23,
          27,
          31,
          16,
          18,
          20,
          22,
          24,
          26,
          28,
          20,
          22,
          24,
          24,
          26,
          28,
          28,
          22,
          24,
          24,
          26,
          26,
          28,
          28,
          24,
          24,
          26,
          26,
          26,
          28,
          28,
          24,
          26,
          26,
          26,
          28,
          28
        ]
      });
      var Alignment_1 = Alignment;
      var ErrorCorrection = lite.extend(null, {
        /**
         * The error correction blocks.
         *
         * There are four elements per version. The first two indicate the number of blocks, then the data width, and finally
         * the ECC width.
         *
         * @public
         * @static
         * @type {number[]}
         * @memberof ErrorCorrection
         */
        BLOCKS: [
          1,
          0,
          19,
          7,
          1,
          0,
          16,
          10,
          1,
          0,
          13,
          13,
          1,
          0,
          9,
          17,
          1,
          0,
          34,
          10,
          1,
          0,
          28,
          16,
          1,
          0,
          22,
          22,
          1,
          0,
          16,
          28,
          1,
          0,
          55,
          15,
          1,
          0,
          44,
          26,
          2,
          0,
          17,
          18,
          2,
          0,
          13,
          22,
          1,
          0,
          80,
          20,
          2,
          0,
          32,
          18,
          2,
          0,
          24,
          26,
          4,
          0,
          9,
          16,
          1,
          0,
          108,
          26,
          2,
          0,
          43,
          24,
          2,
          2,
          15,
          18,
          2,
          2,
          11,
          22,
          2,
          0,
          68,
          18,
          4,
          0,
          27,
          16,
          4,
          0,
          19,
          24,
          4,
          0,
          15,
          28,
          2,
          0,
          78,
          20,
          4,
          0,
          31,
          18,
          2,
          4,
          14,
          18,
          4,
          1,
          13,
          26,
          2,
          0,
          97,
          24,
          2,
          2,
          38,
          22,
          4,
          2,
          18,
          22,
          4,
          2,
          14,
          26,
          2,
          0,
          116,
          30,
          3,
          2,
          36,
          22,
          4,
          4,
          16,
          20,
          4,
          4,
          12,
          24,
          2,
          2,
          68,
          18,
          4,
          1,
          43,
          26,
          6,
          2,
          19,
          24,
          6,
          2,
          15,
          28,
          4,
          0,
          81,
          20,
          1,
          4,
          50,
          30,
          4,
          4,
          22,
          28,
          3,
          8,
          12,
          24,
          2,
          2,
          92,
          24,
          6,
          2,
          36,
          22,
          4,
          6,
          20,
          26,
          7,
          4,
          14,
          28,
          4,
          0,
          107,
          26,
          8,
          1,
          37,
          22,
          8,
          4,
          20,
          24,
          12,
          4,
          11,
          22,
          3,
          1,
          115,
          30,
          4,
          5,
          40,
          24,
          11,
          5,
          16,
          20,
          11,
          5,
          12,
          24,
          5,
          1,
          87,
          22,
          5,
          5,
          41,
          24,
          5,
          7,
          24,
          30,
          11,
          7,
          12,
          24,
          5,
          1,
          98,
          24,
          7,
          3,
          45,
          28,
          15,
          2,
          19,
          24,
          3,
          13,
          15,
          30,
          1,
          5,
          107,
          28,
          10,
          1,
          46,
          28,
          1,
          15,
          22,
          28,
          2,
          17,
          14,
          28,
          5,
          1,
          120,
          30,
          9,
          4,
          43,
          26,
          17,
          1,
          22,
          28,
          2,
          19,
          14,
          28,
          3,
          4,
          113,
          28,
          3,
          11,
          44,
          26,
          17,
          4,
          21,
          26,
          9,
          16,
          13,
          26,
          3,
          5,
          107,
          28,
          3,
          13,
          41,
          26,
          15,
          5,
          24,
          30,
          15,
          10,
          15,
          28,
          4,
          4,
          116,
          28,
          17,
          0,
          42,
          26,
          17,
          6,
          22,
          28,
          19,
          6,
          16,
          30,
          2,
          7,
          111,
          28,
          17,
          0,
          46,
          28,
          7,
          16,
          24,
          30,
          34,
          0,
          13,
          24,
          4,
          5,
          121,
          30,
          4,
          14,
          47,
          28,
          11,
          14,
          24,
          30,
          16,
          14,
          15,
          30,
          6,
          4,
          117,
          30,
          6,
          14,
          45,
          28,
          11,
          16,
          24,
          30,
          30,
          2,
          16,
          30,
          8,
          4,
          106,
          26,
          8,
          13,
          47,
          28,
          7,
          22,
          24,
          30,
          22,
          13,
          15,
          30,
          10,
          2,
          114,
          28,
          19,
          4,
          46,
          28,
          28,
          6,
          22,
          28,
          33,
          4,
          16,
          30,
          8,
          4,
          122,
          30,
          22,
          3,
          45,
          28,
          8,
          26,
          23,
          30,
          12,
          28,
          15,
          30,
          3,
          10,
          117,
          30,
          3,
          23,
          45,
          28,
          4,
          31,
          24,
          30,
          11,
          31,
          15,
          30,
          7,
          7,
          116,
          30,
          21,
          7,
          45,
          28,
          1,
          37,
          23,
          30,
          19,
          26,
          15,
          30,
          5,
          10,
          115,
          30,
          19,
          10,
          47,
          28,
          15,
          25,
          24,
          30,
          23,
          25,
          15,
          30,
          13,
          3,
          115,
          30,
          2,
          29,
          46,
          28,
          42,
          1,
          24,
          30,
          23,
          28,
          15,
          30,
          17,
          0,
          115,
          30,
          10,
          23,
          46,
          28,
          10,
          35,
          24,
          30,
          19,
          35,
          15,
          30,
          17,
          1,
          115,
          30,
          14,
          21,
          46,
          28,
          29,
          19,
          24,
          30,
          11,
          46,
          15,
          30,
          13,
          6,
          115,
          30,
          14,
          23,
          46,
          28,
          44,
          7,
          24,
          30,
          59,
          1,
          16,
          30,
          12,
          7,
          121,
          30,
          12,
          26,
          47,
          28,
          39,
          14,
          24,
          30,
          22,
          41,
          15,
          30,
          6,
          14,
          121,
          30,
          6,
          34,
          47,
          28,
          46,
          10,
          24,
          30,
          2,
          64,
          15,
          30,
          17,
          4,
          122,
          30,
          29,
          14,
          46,
          28,
          49,
          10,
          24,
          30,
          24,
          46,
          15,
          30,
          4,
          18,
          122,
          30,
          13,
          32,
          46,
          28,
          48,
          14,
          24,
          30,
          42,
          32,
          15,
          30,
          20,
          4,
          117,
          30,
          40,
          7,
          47,
          28,
          43,
          22,
          24,
          30,
          10,
          67,
          15,
          30,
          19,
          6,
          118,
          30,
          18,
          31,
          47,
          28,
          34,
          34,
          24,
          30,
          20,
          61,
          15,
          30
        ],
        /**
         * The final format bits with mask (level << 3 | mask).
         *
         * @public
         * @static
         * @type {number[]}
         * @memberof ErrorCorrection
         */
        FINAL_FORMAT: [
          // L
          30660,
          29427,
          32170,
          30877,
          26159,
          25368,
          27713,
          26998,
          // M
          21522,
          20773,
          24188,
          23371,
          17913,
          16590,
          20375,
          19104,
          // Q
          13663,
          12392,
          16177,
          14854,
          9396,
          8579,
          11994,
          11245,
          // H
          5769,
          5054,
          7399,
          6608,
          1890,
          597,
          3340,
          2107
        ],
        /**
         * A map of human-readable ECC levels.
         *
         * @public
         * @static
         * @type {Object.<string, number>}
         * @memberof ErrorCorrection
         */
        LEVELS: {
          L: 1,
          M: 2,
          Q: 3,
          H: 4
        }
      });
      var ErrorCorrection_1 = ErrorCorrection;
      var Galois = lite.extend(null, {
        /**
         * The Galois field exponent table.
         *
         * @public
         * @static
         * @type {number[]}
         * @memberof Galois
         */
        EXPONENT: [
          1,
          2,
          4,
          8,
          16,
          32,
          64,
          128,
          29,
          58,
          116,
          232,
          205,
          135,
          19,
          38,
          76,
          152,
          45,
          90,
          180,
          117,
          234,
          201,
          143,
          3,
          6,
          12,
          24,
          48,
          96,
          192,
          157,
          39,
          78,
          156,
          37,
          74,
          148,
          53,
          106,
          212,
          181,
          119,
          238,
          193,
          159,
          35,
          70,
          140,
          5,
          10,
          20,
          40,
          80,
          160,
          93,
          186,
          105,
          210,
          185,
          111,
          222,
          161,
          95,
          190,
          97,
          194,
          153,
          47,
          94,
          188,
          101,
          202,
          137,
          15,
          30,
          60,
          120,
          240,
          253,
          231,
          211,
          187,
          107,
          214,
          177,
          127,
          254,
          225,
          223,
          163,
          91,
          182,
          113,
          226,
          217,
          175,
          67,
          134,
          17,
          34,
          68,
          136,
          13,
          26,
          52,
          104,
          208,
          189,
          103,
          206,
          129,
          31,
          62,
          124,
          248,
          237,
          199,
          147,
          59,
          118,
          236,
          197,
          151,
          51,
          102,
          204,
          133,
          23,
          46,
          92,
          184,
          109,
          218,
          169,
          79,
          158,
          33,
          66,
          132,
          21,
          42,
          84,
          168,
          77,
          154,
          41,
          82,
          164,
          85,
          170,
          73,
          146,
          57,
          114,
          228,
          213,
          183,
          115,
          230,
          209,
          191,
          99,
          198,
          145,
          63,
          126,
          252,
          229,
          215,
          179,
          123,
          246,
          241,
          255,
          227,
          219,
          171,
          75,
          150,
          49,
          98,
          196,
          149,
          55,
          110,
          220,
          165,
          87,
          174,
          65,
          130,
          25,
          50,
          100,
          200,
          141,
          7,
          14,
          28,
          56,
          112,
          224,
          221,
          167,
          83,
          166,
          81,
          162,
          89,
          178,
          121,
          242,
          249,
          239,
          195,
          155,
          43,
          86,
          172,
          69,
          138,
          9,
          18,
          36,
          72,
          144,
          61,
          122,
          244,
          245,
          247,
          243,
          251,
          235,
          203,
          139,
          11,
          22,
          44,
          88,
          176,
          125,
          250,
          233,
          207,
          131,
          27,
          54,
          108,
          216,
          173,
          71,
          142,
          0
        ],
        /**
         * The Galois field log table.
         *
         * @public
         * @static
         * @type {number[]}
         * @memberof Galois
         */
        LOG: [
          255,
          0,
          1,
          25,
          2,
          50,
          26,
          198,
          3,
          223,
          51,
          238,
          27,
          104,
          199,
          75,
          4,
          100,
          224,
          14,
          52,
          141,
          239,
          129,
          28,
          193,
          105,
          248,
          200,
          8,
          76,
          113,
          5,
          138,
          101,
          47,
          225,
          36,
          15,
          33,
          53,
          147,
          142,
          218,
          240,
          18,
          130,
          69,
          29,
          181,
          194,
          125,
          106,
          39,
          249,
          185,
          201,
          154,
          9,
          120,
          77,
          228,
          114,
          166,
          6,
          191,
          139,
          98,
          102,
          221,
          48,
          253,
          226,
          152,
          37,
          179,
          16,
          145,
          34,
          136,
          54,
          208,
          148,
          206,
          143,
          150,
          219,
          189,
          241,
          210,
          19,
          92,
          131,
          56,
          70,
          64,
          30,
          66,
          182,
          163,
          195,
          72,
          126,
          110,
          107,
          58,
          40,
          84,
          250,
          133,
          186,
          61,
          202,
          94,
          155,
          159,
          10,
          21,
          121,
          43,
          78,
          212,
          229,
          172,
          115,
          243,
          167,
          87,
          7,
          112,
          192,
          247,
          140,
          128,
          99,
          13,
          103,
          74,
          222,
          237,
          49,
          197,
          254,
          24,
          227,
          165,
          153,
          119,
          38,
          184,
          180,
          124,
          17,
          68,
          146,
          217,
          35,
          32,
          137,
          46,
          55,
          63,
          209,
          91,
          149,
          188,
          207,
          205,
          144,
          135,
          151,
          178,
          220,
          252,
          190,
          97,
          242,
          86,
          211,
          171,
          20,
          42,
          93,
          158,
          132,
          60,
          57,
          83,
          71,
          109,
          65,
          162,
          31,
          45,
          67,
          216,
          183,
          123,
          164,
          118,
          196,
          23,
          73,
          236,
          127,
          12,
          111,
          246,
          108,
          161,
          59,
          82,
          41,
          157,
          85,
          170,
          251,
          96,
          134,
          177,
          187,
          204,
          62,
          90,
          203,
          89,
          95,
          176,
          156,
          169,
          160,
          81,
          11,
          245,
          22,
          235,
          122,
          117,
          44,
          215,
          79,
          174,
          213,
          233,
          230,
          231,
          173,
          232,
          116,
          214,
          244,
          234,
          168,
          80,
          88,
          175
        ]
      });
      var Galois_1 = Galois;
      var Version = lite.extend(null, {
        /**
         * The version pattern block.
         *
         * @public
         * @static
         * @type {number[]}
         * @memberof Version
         */
        BLOCK: [
          3220,
          1468,
          2713,
          1235,
          3062,
          1890,
          2119,
          1549,
          2344,
          2936,
          1117,
          2583,
          1330,
          2470,
          1667,
          2249,
          2028,
          3780,
          481,
          4011,
          142,
          3098,
          831,
          3445,
          592,
          2517,
          1776,
          2234,
          1951,
          2827,
          1070,
          2660,
          1345,
          3177
        ]
      });
      var Version_1 = Version;
      var Frame = lite.extend(function(options2) {
        var dataBlock, eccBlock, index2, neccBlock1, neccBlock2;
        var valueLength = options2.value.length;
        this._badness = [];
        this._level = ErrorCorrection_1.LEVELS[options2.level];
        this._polynomial = [];
        this._value = options2.value;
        this._version = 0;
        this._stringBuffer = [];
        while (this._version < 40) {
          this._version++;
          index2 = (this._level - 1) * 4 + (this._version - 1) * 16;
          neccBlock1 = ErrorCorrection_1.BLOCKS[index2++];
          neccBlock2 = ErrorCorrection_1.BLOCKS[index2++];
          dataBlock = ErrorCorrection_1.BLOCKS[index2++];
          eccBlock = ErrorCorrection_1.BLOCKS[index2];
          index2 = dataBlock * (neccBlock1 + neccBlock2) + neccBlock2 - 3 + (this._version <= 9);
          if (valueLength <= index2) {
            break;
          }
        }
        this._dataBlock = dataBlock;
        this._eccBlock = eccBlock;
        this._neccBlock1 = neccBlock1;
        this._neccBlock2 = neccBlock2;
        var width = this.width = 17 + 4 * this._version;
        this.buffer = Frame._createArray(width * width);
        this._ecc = Frame._createArray(dataBlock + (dataBlock + eccBlock) * (neccBlock1 + neccBlock2) + neccBlock2);
        this._mask = Frame._createArray((width * (width + 1) + 1) / 2);
        this._insertFinders();
        this._insertAlignments();
        this.buffer[8 + width * (width - 8)] = 1;
        this._insertTimingGap();
        this._reverseMask();
        this._insertTimingRowAndColumn();
        this._insertVersion();
        this._syncMask();
        this._convertBitStream(valueLength);
        this._calculatePolynomial();
        this._appendEccToData();
        this._interleaveBlocks();
        this._pack();
        this._finish();
      }, {
        _addAlignment: function(x3, y3) {
          var i3;
          var buffer = this.buffer;
          var width = this.width;
          buffer[x3 + width * y3] = 1;
          for (i3 = -2; i3 < 2; i3++) {
            buffer[x3 + i3 + width * (y3 - 2)] = 1;
            buffer[x3 - 2 + width * (y3 + i3 + 1)] = 1;
            buffer[x3 + 2 + width * (y3 + i3)] = 1;
            buffer[x3 + i3 + 1 + width * (y3 + 2)] = 1;
          }
          for (i3 = 0; i3 < 2; i3++) {
            this._setMask(x3 - 1, y3 + i3);
            this._setMask(x3 + 1, y3 - i3);
            this._setMask(x3 - i3, y3 - 1);
            this._setMask(x3 + i3, y3 + 1);
          }
        },
        _appendData: function(data2, dataLength, ecc, eccLength) {
          var bit, i3, j;
          var polynomial = this._polynomial;
          var stringBuffer = this._stringBuffer;
          for (i3 = 0; i3 < eccLength; i3++) {
            stringBuffer[ecc + i3] = 0;
          }
          for (i3 = 0; i3 < dataLength; i3++) {
            bit = Galois_1.LOG[stringBuffer[data2 + i3] ^ stringBuffer[ecc]];
            if (bit !== 255) {
              for (j = 1; j < eccLength; j++) {
                stringBuffer[ecc + j - 1] = stringBuffer[ecc + j] ^ Galois_1.EXPONENT[Frame._modN(bit + polynomial[eccLength - j])];
              }
            } else {
              for (j = ecc; j < ecc + eccLength; j++) {
                stringBuffer[j] = stringBuffer[j + 1];
              }
            }
            stringBuffer[ecc + eccLength - 1] = bit === 255 ? 0 : Galois_1.EXPONENT[Frame._modN(bit + polynomial[0])];
          }
        },
        _appendEccToData: function() {
          var i3;
          var data2 = 0;
          var dataBlock = this._dataBlock;
          var ecc = this._calculateMaxLength();
          var eccBlock = this._eccBlock;
          for (i3 = 0; i3 < this._neccBlock1; i3++) {
            this._appendData(data2, dataBlock, ecc, eccBlock);
            data2 += dataBlock;
            ecc += eccBlock;
          }
          for (i3 = 0; i3 < this._neccBlock2; i3++) {
            this._appendData(data2, dataBlock + 1, ecc, eccBlock);
            data2 += dataBlock + 1;
            ecc += eccBlock;
          }
        },
        _applyMask: function(mask) {
          var r3x, r3y, x3, y3;
          var buffer = this.buffer;
          var width = this.width;
          switch (mask) {
            case 0:
              for (y3 = 0; y3 < width; y3++) {
                for (x3 = 0; x3 < width; x3++) {
                  if (!(x3 + y3 & 1) && !this._isMasked(x3, y3)) {
                    buffer[x3 + y3 * width] ^= 1;
                  }
                }
              }
              break;
            case 1:
              for (y3 = 0; y3 < width; y3++) {
                for (x3 = 0; x3 < width; x3++) {
                  if (!(y3 & 1) && !this._isMasked(x3, y3)) {
                    buffer[x3 + y3 * width] ^= 1;
                  }
                }
              }
              break;
            case 2:
              for (y3 = 0; y3 < width; y3++) {
                for (r3x = 0, x3 = 0; x3 < width; x3++, r3x++) {
                  if (r3x === 3) {
                    r3x = 0;
                  }
                  if (!r3x && !this._isMasked(x3, y3)) {
                    buffer[x3 + y3 * width] ^= 1;
                  }
                }
              }
              break;
            case 3:
              for (r3y = 0, y3 = 0; y3 < width; y3++, r3y++) {
                if (r3y === 3) {
                  r3y = 0;
                }
                for (r3x = r3y, x3 = 0; x3 < width; x3++, r3x++) {
                  if (r3x === 3) {
                    r3x = 0;
                  }
                  if (!r3x && !this._isMasked(x3, y3)) {
                    buffer[x3 + y3 * width] ^= 1;
                  }
                }
              }
              break;
            case 4:
              for (y3 = 0; y3 < width; y3++) {
                for (r3x = 0, r3y = y3 >> 1 & 1, x3 = 0; x3 < width; x3++, r3x++) {
                  if (r3x === 3) {
                    r3x = 0;
                    r3y = !r3y;
                  }
                  if (!r3y && !this._isMasked(x3, y3)) {
                    buffer[x3 + y3 * width] ^= 1;
                  }
                }
              }
              break;
            case 5:
              for (r3y = 0, y3 = 0; y3 < width; y3++, r3y++) {
                if (r3y === 3) {
                  r3y = 0;
                }
                for (r3x = 0, x3 = 0; x3 < width; x3++, r3x++) {
                  if (r3x === 3) {
                    r3x = 0;
                  }
                  if (!((x3 & y3 & 1) + !(!r3x | !r3y)) && !this._isMasked(x3, y3)) {
                    buffer[x3 + y3 * width] ^= 1;
                  }
                }
              }
              break;
            case 6:
              for (r3y = 0, y3 = 0; y3 < width; y3++, r3y++) {
                if (r3y === 3) {
                  r3y = 0;
                }
                for (r3x = 0, x3 = 0; x3 < width; x3++, r3x++) {
                  if (r3x === 3) {
                    r3x = 0;
                  }
                  if (!((x3 & y3 & 1) + (r3x && r3x === r3y) & 1) && !this._isMasked(x3, y3)) {
                    buffer[x3 + y3 * width] ^= 1;
                  }
                }
              }
              break;
            case 7:
              for (r3y = 0, y3 = 0; y3 < width; y3++, r3y++) {
                if (r3y === 3) {
                  r3y = 0;
                }
                for (r3x = 0, x3 = 0; x3 < width; x3++, r3x++) {
                  if (r3x === 3) {
                    r3x = 0;
                  }
                  if (!((r3x && r3x === r3y) + (x3 + y3 & 1) & 1) && !this._isMasked(x3, y3)) {
                    buffer[x3 + y3 * width] ^= 1;
                  }
                }
              }
              break;
          }
        },
        _calculateMaxLength: function() {
          return this._dataBlock * (this._neccBlock1 + this._neccBlock2) + this._neccBlock2;
        },
        _calculatePolynomial: function() {
          var i3, j;
          var eccBlock = this._eccBlock;
          var polynomial = this._polynomial;
          polynomial[0] = 1;
          for (i3 = 0; i3 < eccBlock; i3++) {
            polynomial[i3 + 1] = 1;
            for (j = i3; j > 0; j--) {
              polynomial[j] = polynomial[j] ? polynomial[j - 1] ^ Galois_1.EXPONENT[Frame._modN(Galois_1.LOG[polynomial[j]] + i3)] : polynomial[j - 1];
            }
            polynomial[0] = Galois_1.EXPONENT[Frame._modN(Galois_1.LOG[polynomial[0]] + i3)];
          }
          for (i3 = 0; i3 <= eccBlock; i3++) {
            polynomial[i3] = Galois_1.LOG[polynomial[i3]];
          }
        },
        _checkBadness: function() {
          var b3, b1, h3, x3, y3;
          var bad = 0;
          var badness = this._badness;
          var buffer = this.buffer;
          var width = this.width;
          for (y3 = 0; y3 < width - 1; y3++) {
            for (x3 = 0; x3 < width - 1; x3++) {
              if (buffer[x3 + width * y3] && buffer[x3 + 1 + width * y3] && buffer[x3 + width * (y3 + 1)] && buffer[x3 + 1 + width * (y3 + 1)] || // All background colour.
              !(buffer[x3 + width * y3] || buffer[x3 + 1 + width * y3] || buffer[x3 + width * (y3 + 1)] || buffer[x3 + 1 + width * (y3 + 1)])) {
                bad += Frame.N2;
              }
            }
          }
          var bw = 0;
          for (y3 = 0; y3 < width; y3++) {
            h3 = 0;
            badness[0] = 0;
            for (b3 = 0, x3 = 0; x3 < width; x3++) {
              b1 = buffer[x3 + width * y3];
              if (b3 === b1) {
                badness[h3]++;
              } else {
                badness[++h3] = 1;
              }
              b3 = b1;
              bw += b3 ? 1 : -1;
            }
            bad += this._getBadness(h3);
          }
          if (bw < 0) {
            bw = -bw;
          }
          var count = 0;
          var big = bw;
          big += big << 2;
          big <<= 1;
          while (big > width * width) {
            big -= width * width;
            count++;
          }
          bad += count * Frame.N4;
          for (x3 = 0; x3 < width; x3++) {
            h3 = 0;
            badness[0] = 0;
            for (b3 = 0, y3 = 0; y3 < width; y3++) {
              b1 = buffer[x3 + width * y3];
              if (b3 === b1) {
                badness[h3]++;
              } else {
                badness[++h3] = 1;
              }
              b3 = b1;
            }
            bad += this._getBadness(h3);
          }
          return bad;
        },
        _convertBitStream: function(length) {
          var bit, i3;
          var ecc = this._ecc;
          var version = this._version;
          for (i3 = 0; i3 < length; i3++) {
            ecc[i3] = this._value.charCodeAt(i3);
          }
          var stringBuffer = this._stringBuffer = ecc.slice();
          var maxLength = this._calculateMaxLength();
          if (length >= maxLength - 2) {
            length = maxLength - 2;
            if (version > 9) {
              length--;
            }
          }
          var index2 = length;
          if (version > 9) {
            stringBuffer[index2 + 2] = 0;
            stringBuffer[index2 + 3] = 0;
            while (index2--) {
              bit = stringBuffer[index2];
              stringBuffer[index2 + 3] |= 255 & bit << 4;
              stringBuffer[index2 + 2] = bit >> 4;
            }
            stringBuffer[2] |= 255 & length << 4;
            stringBuffer[1] = length >> 4;
            stringBuffer[0] = 64 | length >> 12;
          } else {
            stringBuffer[index2 + 1] = 0;
            stringBuffer[index2 + 2] = 0;
            while (index2--) {
              bit = stringBuffer[index2];
              stringBuffer[index2 + 2] |= 255 & bit << 4;
              stringBuffer[index2 + 1] = bit >> 4;
            }
            stringBuffer[1] |= 255 & length << 4;
            stringBuffer[0] = 64 | length >> 4;
          }
          index2 = length + 3 - (version < 10);
          while (index2 < maxLength) {
            stringBuffer[index2++] = 236;
            stringBuffer[index2++] = 17;
          }
        },
        _getBadness: function(length) {
          var i3;
          var badRuns = 0;
          var badness = this._badness;
          for (i3 = 0; i3 <= length; i3++) {
            if (badness[i3] >= 5) {
              badRuns += Frame.N1 + badness[i3] - 5;
            }
          }
          for (i3 = 3; i3 < length - 1; i3 += 2) {
            if (badness[i3 - 2] === badness[i3 + 2] && badness[i3 + 2] === badness[i3 - 1] && badness[i3 - 1] === badness[i3 + 1] && badness[i3 - 1] * 3 === badness[i3] && // Background around the foreground pattern? Not part of the specs.
            (badness[i3 - 3] === 0 || i3 + 3 > length || badness[i3 - 3] * 3 >= badness[i3] * 4 || badness[i3 + 3] * 3 >= badness[i3] * 4)) {
              badRuns += Frame.N3;
            }
          }
          return badRuns;
        },
        _finish: function() {
          this._stringBuffer = this.buffer.slice();
          var currentMask, i3;
          var bit = 0;
          var mask = 3e4;
          for (i3 = 0; i3 < 8; i3++) {
            this._applyMask(i3);
            currentMask = this._checkBadness();
            if (currentMask < mask) {
              mask = currentMask;
              bit = i3;
            }
            if (bit === 7) {
              break;
            }
            this.buffer = this._stringBuffer.slice();
          }
          if (bit !== i3) {
            this._applyMask(bit);
          }
          mask = ErrorCorrection_1.FINAL_FORMAT[bit + (this._level - 1 << 3)];
          var buffer = this.buffer;
          var width = this.width;
          for (i3 = 0; i3 < 8; i3++, mask >>= 1) {
            if (mask & 1) {
              buffer[width - 1 - i3 + width * 8] = 1;
              if (i3 < 6) {
                buffer[8 + width * i3] = 1;
              } else {
                buffer[8 + width * (i3 + 1)] = 1;
              }
            }
          }
          for (i3 = 0; i3 < 7; i3++, mask >>= 1) {
            if (mask & 1) {
              buffer[8 + width * (width - 7 + i3)] = 1;
              if (i3) {
                buffer[6 - i3 + width * 8] = 1;
              } else {
                buffer[7 + width * 8] = 1;
              }
            }
          }
        },
        _interleaveBlocks: function() {
          var i3, j;
          var dataBlock = this._dataBlock;
          var ecc = this._ecc;
          var eccBlock = this._eccBlock;
          var k2 = 0;
          var maxLength = this._calculateMaxLength();
          var neccBlock1 = this._neccBlock1;
          var neccBlock2 = this._neccBlock2;
          var stringBuffer = this._stringBuffer;
          for (i3 = 0; i3 < dataBlock; i3++) {
            for (j = 0; j < neccBlock1; j++) {
              ecc[k2++] = stringBuffer[i3 + j * dataBlock];
            }
            for (j = 0; j < neccBlock2; j++) {
              ecc[k2++] = stringBuffer[neccBlock1 * dataBlock + i3 + j * (dataBlock + 1)];
            }
          }
          for (j = 0; j < neccBlock2; j++) {
            ecc[k2++] = stringBuffer[neccBlock1 * dataBlock + i3 + j * (dataBlock + 1)];
          }
          for (i3 = 0; i3 < eccBlock; i3++) {
            for (j = 0; j < neccBlock1 + neccBlock2; j++) {
              ecc[k2++] = stringBuffer[maxLength + i3 + j * eccBlock];
            }
          }
          this._stringBuffer = ecc;
        },
        _insertAlignments: function() {
          var i3, x3, y3;
          var version = this._version;
          var width = this.width;
          if (version > 1) {
            i3 = Alignment_1.BLOCK[version];
            y3 = width - 7;
            for (; ; ) {
              x3 = width - 7;
              while (x3 > i3 - 3) {
                this._addAlignment(x3, y3);
                if (x3 < i3) {
                  break;
                }
                x3 -= i3;
              }
              if (y3 <= i3 + 9) {
                break;
              }
              y3 -= i3;
              this._addAlignment(6, y3);
              this._addAlignment(y3, 6);
            }
          }
        },
        _insertFinders: function() {
          var i3, j, x3, y3;
          var buffer = this.buffer;
          var width = this.width;
          for (i3 = 0; i3 < 3; i3++) {
            j = 0;
            y3 = 0;
            if (i3 === 1) {
              j = width - 7;
            }
            if (i3 === 2) {
              y3 = width - 7;
            }
            buffer[y3 + 3 + width * (j + 3)] = 1;
            for (x3 = 0; x3 < 6; x3++) {
              buffer[y3 + x3 + width * j] = 1;
              buffer[y3 + width * (j + x3 + 1)] = 1;
              buffer[y3 + 6 + width * (j + x3)] = 1;
              buffer[y3 + x3 + 1 + width * (j + 6)] = 1;
            }
            for (x3 = 1; x3 < 5; x3++) {
              this._setMask(y3 + x3, j + 1);
              this._setMask(y3 + 1, j + x3 + 1);
              this._setMask(y3 + 5, j + x3);
              this._setMask(y3 + x3 + 1, j + 5);
            }
            for (x3 = 2; x3 < 4; x3++) {
              buffer[y3 + x3 + width * (j + 2)] = 1;
              buffer[y3 + 2 + width * (j + x3 + 1)] = 1;
              buffer[y3 + 4 + width * (j + x3)] = 1;
              buffer[y3 + x3 + 1 + width * (j + 4)] = 1;
            }
          }
        },
        _insertTimingGap: function() {
          var x3, y3;
          var width = this.width;
          for (y3 = 0; y3 < 7; y3++) {
            this._setMask(7, y3);
            this._setMask(width - 8, y3);
            this._setMask(7, y3 + width - 7);
          }
          for (x3 = 0; x3 < 8; x3++) {
            this._setMask(x3, 7);
            this._setMask(x3 + width - 8, 7);
            this._setMask(x3, width - 8);
          }
        },
        _insertTimingRowAndColumn: function() {
          var x3;
          var buffer = this.buffer;
          var width = this.width;
          for (x3 = 0; x3 < width - 14; x3++) {
            if (x3 & 1) {
              this._setMask(8 + x3, 6);
              this._setMask(6, 8 + x3);
            } else {
              buffer[8 + x3 + width * 6] = 1;
              buffer[6 + width * (8 + x3)] = 1;
            }
          }
        },
        _insertVersion: function() {
          var i3, j, x3, y3;
          var buffer = this.buffer;
          var version = this._version;
          var width = this.width;
          if (version > 6) {
            i3 = Version_1.BLOCK[version - 7];
            j = 17;
            for (x3 = 0; x3 < 6; x3++) {
              for (y3 = 0; y3 < 3; y3++, j--) {
                if (1 & (j > 11 ? version >> j - 12 : i3 >> j)) {
                  buffer[5 - x3 + width * (2 - y3 + width - 11)] = 1;
                  buffer[2 - y3 + width - 11 + width * (5 - x3)] = 1;
                } else {
                  this._setMask(5 - x3, 2 - y3 + width - 11);
                  this._setMask(2 - y3 + width - 11, 5 - x3);
                }
              }
            }
          }
        },
        _isMasked: function(x3, y3) {
          var bit = Frame._getMaskBit(x3, y3);
          return this._mask[bit] === 1;
        },
        _pack: function() {
          var bit, i3, j;
          var k2 = 1;
          var v3 = 1;
          var width = this.width;
          var x3 = width - 1;
          var y3 = width - 1;
          var length = (this._dataBlock + this._eccBlock) * (this._neccBlock1 + this._neccBlock2) + this._neccBlock2;
          for (i3 = 0; i3 < length; i3++) {
            bit = this._stringBuffer[i3];
            for (j = 0; j < 8; j++, bit <<= 1) {
              if (128 & bit) {
                this.buffer[x3 + width * y3] = 1;
              }
              do {
                if (v3) {
                  x3--;
                } else {
                  x3++;
                  if (k2) {
                    if (y3 !== 0) {
                      y3--;
                    } else {
                      x3 -= 2;
                      k2 = !k2;
                      if (x3 === 6) {
                        x3--;
                        y3 = 9;
                      }
                    }
                  } else if (y3 !== width - 1) {
                    y3++;
                  } else {
                    x3 -= 2;
                    k2 = !k2;
                    if (x3 === 6) {
                      x3--;
                      y3 -= 8;
                    }
                  }
                }
                v3 = !v3;
              } while (this._isMasked(x3, y3));
            }
          }
        },
        _reverseMask: function() {
          var x3, y3;
          var width = this.width;
          for (x3 = 0; x3 < 9; x3++) {
            this._setMask(x3, 8);
          }
          for (x3 = 0; x3 < 8; x3++) {
            this._setMask(x3 + width - 8, 8);
            this._setMask(8, x3);
          }
          for (y3 = 0; y3 < 7; y3++) {
            this._setMask(8, y3 + width - 7);
          }
        },
        _setMask: function(x3, y3) {
          var bit = Frame._getMaskBit(x3, y3);
          this._mask[bit] = 1;
        },
        _syncMask: function() {
          var x3, y3;
          var width = this.width;
          for (y3 = 0; y3 < width; y3++) {
            for (x3 = 0; x3 <= y3; x3++) {
              if (this.buffer[x3 + width * y3]) {
                this._setMask(x3, y3);
              }
            }
          }
        }
      }, {
        _createArray: function(length) {
          var i3;
          var array = [];
          for (i3 = 0; i3 < length; i3++) {
            array[i3] = 0;
          }
          return array;
        },
        _getMaskBit: function(x3, y3) {
          var bit;
          if (x3 > y3) {
            bit = x3;
            x3 = y3;
            y3 = bit;
          }
          bit = y3;
          bit += y3 * y3;
          bit >>= 1;
          bit += x3;
          return bit;
        },
        _modN: function(x3) {
          while (x3 >= 255) {
            x3 -= 255;
            x3 = (x3 >> 8) + (x3 & 255);
          }
          return x3;
        },
        // *Badness* coefficients.
        N1: 3,
        N2: 3,
        N3: 40,
        N4: 10
      });
      var Frame_1 = Frame;
      var ImageRenderer = Renderer_1.extend({
        /**
         * @override
         */
        draw: function() {
          this.element.src = this.qrious.toDataURL();
        },
        /**
         * @override
         */
        reset: function() {
          this.element.src = "";
        },
        /**
         * @override
         */
        resize: function() {
          var element = this.element;
          element.width = element.height = this.qrious.size;
        }
      });
      var ImageRenderer_1 = ImageRenderer;
      var Option = lite.extend(function(name, modifiable, defaultValue, valueTransformer) {
        this.name = name;
        this.modifiable = Boolean(modifiable);
        this.defaultValue = defaultValue;
        this._valueTransformer = valueTransformer;
      }, {
        /**
         * Transforms the specified <code>value</code> so that it can be applied for this {@link Option}.
         *
         * If a value transformer has been specified for this {@link Option}, it will be called upon to transform
         * <code>value</code>. Otherwise, <code>value</code> will be returned directly.
         *
         * @param {*} value - the value to be transformed
         * @return {*} The transformed value or <code>value</code> if no value transformer is specified.
         * @public
         * @memberof Option#
         */
        transform: function(value2) {
          var transformer = this._valueTransformer;
          if (typeof transformer === "function") {
            return transformer(value2, this);
          }
          return value2;
        }
      });
      var Option_1 = Option;
      var Utilities = lite.extend(null, {
        /**
         * Returns the absolute value of a given number.
         *
         * This method is simply a convenient shorthand for <code>Math.abs</code> while ensuring that nulls are returned as
         * <code>null</code> instead of zero.
         *
         * @param {number} value - the number whose absolute value is to be returned
         * @return {number} The absolute value of <code>value</code> or <code>null</code> if <code>value</code> is
         * <code>null</code>.
         * @public
         * @static
         * @memberof Utilities
         */
        abs: function(value2) {
          return value2 != null ? Math.abs(value2) : null;
        },
        /**
         * Returns whether the specified <code>object</code> has a property with the specified <code>name</code> as an own
         * (not inherited) property.
         *
         * @param {Object} object - the object on which the property is to be checked
         * @param {string} name - the name of the property to be checked
         * @return {boolean} <code>true</code> if <code>object</code> has an own property with <code>name</code>.
         * @public
         * @static
         * @memberof Utilities
         */
        hasOwn: function(object2, name) {
          return Object.prototype.hasOwnProperty.call(object2, name);
        },
        /**
         * A non-operation method that does absolutely nothing.
         *
         * @return {void}
         * @public
         * @static
         * @memberof Utilities
         */
        noop: function() {
        },
        /**
         * Transforms the specified <code>string</code> to upper case while remaining null-safe.
         *
         * @param {string} string - the string to be transformed to upper case
         * @return {string} <code>string</code> transformed to upper case if <code>string</code> is not <code>null</code>.
         * @public
         * @static
         * @memberof Utilities
         */
        toUpperCase: function(string) {
          return string != null ? string.toUpperCase() : null;
        }
      });
      var Utilities_1 = Utilities;
      var OptionManager = lite.extend(function(options2) {
        this.options = {};
        options2.forEach(function(option) {
          this.options[option.name] = option;
        }, this);
      }, {
        /**
         * Returns whether an option with the specified <code>name</code> is available.
         *
         * @param {string} name - the name of the {@link Option} whose existence is to be checked
         * @return {boolean} <code>true</code> if an {@link Option} exists with <code>name</code>; otherwise
         * <code>false</code>.
         * @public
         * @memberof OptionManager#
         */
        exists: function(name) {
          return this.options[name] != null;
        },
        /**
         * Returns the value of the option with the specified <code>name</code> on the <code>target</code> object provided.
         *
         * @param {string} name - the name of the {@link Option} whose value on <code>target</code> is to be returned
         * @param {Object} target - the object from which the value of the named {@link Option} is to be returned
         * @return {*} The value of the {@link Option} with <code>name</code> on <code>target</code>.
         * @public
         * @memberof OptionManager#
         */
        get: function(name, target) {
          return OptionManager._get(this.options[name], target);
        },
        /**
         * Returns a copy of all of the available options on the <code>target</code> object provided.
         *
         * @param {Object} target - the object from which the option name/value pairs are to be returned
         * @return {Object.<string, *>} A hash containing the name/value pairs of all options on <code>target</code>.
         * @public
         * @memberof OptionManager#
         */
        getAll: function(target) {
          var name;
          var options2 = this.options;
          var result2 = {};
          for (name in options2) {
            if (Utilities_1.hasOwn(options2, name)) {
              result2[name] = OptionManager._get(options2[name], target);
            }
          }
          return result2;
        },
        /**
         * Initializes the available options for the <code>target</code> object provided and then applies the initial values
         * within the speciifed <code>options</code>.
         *
         * This method will throw an error if any of the names within <code>options</code> does not match an available option.
         *
         * This involves setting the default values and defining properties for all of the available options on
         * <code>target</code> before finally calling {@link OptionMananger#setAll} with <code>options</code> and
         * <code>target</code>. Any options that are configured to be modifiable will have a setter included in their defined
         * property that will allow its corresponding value to be modified.
         *
         * If a change handler is specified, it will be called whenever the value changes on <code>target</code> for a
         * modifiable option, but only when done so via the defined property's setter.
         *
         * @param {Object.<string, *>} options - the name/value pairs of the initial options to be set
         * @param {Object} target - the object on which the options are to be initialized
         * @param {Function} [changeHandler] - the function to be called whenever the value of an modifiable option changes on
         * <code>target</code>
         * @return {void}
         * @throws {Error} If <code>options</code> contains an invalid option name.
         * @public
         * @memberof OptionManager#
         */
        init: function(options2, target, changeHandler) {
          if (typeof changeHandler !== "function") {
            changeHandler = Utilities_1.noop;
          }
          var name, option;
          for (name in this.options) {
            if (Utilities_1.hasOwn(this.options, name)) {
              option = this.options[name];
              OptionManager._set(option, option.defaultValue, target);
              OptionManager._createAccessor(option, target, changeHandler);
            }
          }
          this._setAll(options2, target, true);
        },
        /**
         * Sets the value of the option with the specified <code>name</code> on the <code>target</code> object provided to
         * <code>value</code>.
         *
         * This method will throw an error if <code>name</code> does not match an available option or matches an option that
         * cannot be modified.
         *
         * If <code>value</code> is <code>null</code> and the {@link Option} has a default value configured, then that default
         * value will be used instead. If the {@link Option} also has a value transformer configured, it will be used to
         * transform whichever value was determined to be used.
         *
         * This method returns whether the value of the underlying field on <code>target</code> was changed as a result.
         *
         * @param {string} name - the name of the {@link Option} whose value is to be set
         * @param {*} value - the value to be set for the named {@link Option} on <code>target</code>
         * @param {Object} target - the object on which <code>value</code> is to be set for the named {@link Option}
         * @return {boolean} <code>true</code> if the underlying field on <code>target</code> was changed; otherwise
         * <code>false</code>.
         * @throws {Error} If <code>name</code> is invalid or is for an option that cannot be modified.
         * @public
         * @memberof OptionManager#
         */
        set: function(name, value2, target) {
          return this._set(name, value2, target);
        },
        /**
         * Sets all of the specified <code>options</code> on the <code>target</code> object provided to their corresponding
         * values.
         *
         * This method will throw an error if any of the names within <code>options</code> does not match an available option
         * or matches an option that cannot be modified.
         *
         * If any value within <code>options</code> is <code>null</code> and the corresponding {@link Option} has a default
         * value configured, then that default value will be used instead. If an {@link Option} also has a value transformer
         * configured, it will be used to transform whichever value was determined to be used.
         *
         * This method returns whether the value for any of the underlying fields on <code>target</code> were changed as a
         * result.
         *
         * @param {Object.<string, *>} options - the name/value pairs of options to be set
         * @param {Object} target - the object on which the options are to be set
         * @return {boolean} <code>true</code> if any of the underlying fields on <code>target</code> were changed; otherwise
         * <code>false</code>.
         * @throws {Error} If <code>options</code> contains an invalid option name or an option that cannot be modiifed.
         * @public
         * @memberof OptionManager#
         */
        setAll: function(options2, target) {
          return this._setAll(options2, target);
        },
        _set: function(name, value2, target, allowUnmodifiable) {
          var option = this.options[name];
          if (!option) {
            throw new Error("Invalid option: " + name);
          }
          if (!option.modifiable && !allowUnmodifiable) {
            throw new Error("Option cannot be modified: " + name);
          }
          return OptionManager._set(option, value2, target);
        },
        _setAll: function(options2, target, allowUnmodifiable) {
          if (!options2) {
            return false;
          }
          var name;
          var changed = false;
          for (name in options2) {
            if (Utilities_1.hasOwn(options2, name) && this._set(name, options2[name], target, allowUnmodifiable)) {
              changed = true;
            }
          }
          return changed;
        }
      }, {
        _createAccessor: function(option, target, changeHandler) {
          var descriptor = {
            get: function() {
              return OptionManager._get(option, target);
            }
          };
          if (option.modifiable) {
            descriptor.set = function(value2) {
              if (OptionManager._set(option, value2, target)) {
                changeHandler(value2, option);
              }
            };
          }
          Object.defineProperty(target, option.name, descriptor);
        },
        _get: function(option, target) {
          return target["_" + option.name];
        },
        _set: function(option, value2, target) {
          var fieldName = "_" + option.name;
          var oldValue = target[fieldName];
          var newValue = option.transform(value2 != null ? value2 : option.defaultValue);
          target[fieldName] = newValue;
          return newValue !== oldValue;
        }
      });
      var OptionManager_1 = OptionManager;
      var ServiceManager = lite.extend(function() {
        this._services = {};
      }, {
        /**
         * Returns the {@link Service} being managed with the specified <code>name</code>.
         *
         * @param {string} name - the name of the {@link Service} to be returned
         * @return {Service} The {@link Service} is being managed with <code>name</code>.
         * @throws {Error} If no {@link Service} is being managed with <code>name</code>.
         * @public
         * @memberof ServiceManager#
         */
        getService: function(name) {
          var service = this._services[name];
          if (!service) {
            throw new Error("Service is not being managed with name: " + name);
          }
          return service;
        },
        /**
         * Sets the {@link Service} implementation to be managed for the specified <code>name</code> to the
         * <code>service</code> provided.
         *
         * @param {string} name - the name of the {@link Service} to be managed with <code>name</code>
         * @param {Service} service - the {@link Service} implementation to be managed
         * @return {void}
         * @throws {Error} If a {@link Service} is already being managed with the same <code>name</code>.
         * @public
         * @memberof ServiceManager#
         */
        setService: function(name, service) {
          if (this._services[name]) {
            throw new Error("Service is already managed with name: " + name);
          }
          if (service) {
            this._services[name] = service;
          }
        }
      });
      var ServiceManager_1 = ServiceManager;
      var optionManager = new OptionManager_1([
        new Option_1("background", true, "white"),
        new Option_1("backgroundAlpha", true, 1, Utilities_1.abs),
        new Option_1("element"),
        new Option_1("foreground", true, "black"),
        new Option_1("foregroundAlpha", true, 1, Utilities_1.abs),
        new Option_1("level", true, "L", Utilities_1.toUpperCase),
        new Option_1("mime", true, "image/png"),
        new Option_1("padding", true, null, Utilities_1.abs),
        new Option_1("size", true, 100, Utilities_1.abs),
        new Option_1("value", true, "")
      ]);
      var serviceManager = new ServiceManager_1();
      var QRious3 = lite.extend(function(options2) {
        optionManager.init(options2, this, this.update.bind(this));
        var element = optionManager.get("element", this);
        var elementService = serviceManager.getService("element");
        var canvas = element && elementService.isCanvas(element) ? element : elementService.createCanvas();
        var image = element && elementService.isImage(element) ? element : elementService.createImage();
        this._canvasRenderer = new CanvasRenderer_1(this, canvas, true);
        this._imageRenderer = new ImageRenderer_1(this, image, image === element);
        this.update();
      }, {
        /**
         * Returns all of the options configured for this {@link QRious}.
         *
         * Any changes made to the returned object will not be reflected in the options themselves or their corresponding
         * underlying fields.
         *
         * @return {Object.<string, *>} A copy of the applied options.
         * @public
         * @memberof QRious#
         */
        get: function() {
          return optionManager.getAll(this);
        },
        /**
         * Sets all of the specified <code>options</code> and automatically updates this {@link QRious} if any of the
         * underlying fields are changed as a result.
         *
         * This is the preferred method for updating multiple options at one time to avoid unnecessary updates between
         * changes.
         *
         * @param {QRious~Options} options - the options to be set
         * @return {void}
         * @throws {Error} If any <code>options</code> are invalid or cannot be modified.
         * @public
         * @memberof QRious#
         */
        set: function(options2) {
          if (optionManager.setAll(options2, this)) {
            this.update();
          }
        },
        /**
         * Returns the image data URI for the generated QR code using the <code>mime</code> provided.
         *
         * @param {string} [mime] - the MIME type for the image
         * @return {string} The image data URI for the QR code.
         * @public
         * @memberof QRious#
         */
        toDataURL: function(mime) {
          return this.canvas.toDataURL(mime || this.mime);
        },
        /**
         * Updates this {@link QRious} by generating a new {@link Frame} and re-rendering the QR code.
         *
         * @return {void}
         * @protected
         * @memberof QRious#
         */
        update: function() {
          var frame = new Frame_1({
            level: this.level,
            value: this.value
          });
          this._canvasRenderer.render(frame);
          this._imageRenderer.render(frame);
        }
      }, {
        /**
         * Configures the <code>service</code> provided to be used by all {@link QRious} instances.
         *
         * @param {Service} service - the {@link Service} to be configured
         * @return {void}
         * @throws {Error} If a {@link Service} has already been configured with the same name.
         * @public
         * @static
         * @memberof QRious
         */
        use: function(service) {
          serviceManager.setService(service.getName(), service);
        }
      });
      Object.defineProperties(QRious3.prototype, {
        canvas: {
          /**
           * Returns the <code>canvas</code> element being used to render the QR code for this {@link QRious}.
           *
           * @return {*} The <code>canvas</code> element.
           * @public
           * @memberof QRious#
           * @alias canvas
           */
          get: function() {
            return this._canvasRenderer.getElement();
          }
        },
        image: {
          /**
           * Returns the <code>img</code> element being used to render the QR code for this {@link QRious}.
           *
           * @return {*} The <code>img</code> element.
           * @public
           * @memberof QRious#
           * @alias image
           */
          get: function() {
            return this._imageRenderer.getElement();
          }
        }
      });
      var QRious_1$2 = QRious3;
      var index = QRious_1$2;
      var Service = lite.extend({
        /**
         * Returns the name of this {@link Service}.
         *
         * @return {string} The service name.
         * @public
         * @abstract
         * @memberof Service#
         */
        getName: function() {
        }
      });
      var Service_1 = Service;
      var ElementService = Service_1.extend({
        /**
         * Creates an instance of a canvas element.
         *
         * Implementations of {@link ElementService} <b>must</b> override this method with their own specific logic.
         *
         * @return {*} The newly created canvas element.
         * @public
         * @abstract
         * @memberof ElementService#
         */
        createCanvas: function() {
        },
        /**
         * Creates an instance of a image element.
         *
         * Implementations of {@link ElementService} <b>must</b> override this method with their own specific logic.
         *
         * @return {*} The newly created image element.
         * @public
         * @abstract
         * @memberof ElementService#
         */
        createImage: function() {
        },
        /**
         * @override
         */
        getName: function() {
          return "element";
        },
        /**
         * Returns whether the specified <code>element</code> is a canvas.
         *
         * Implementations of {@link ElementService} <b>must</b> override this method with their own specific logic.
         *
         * @param {*} element - the element to be checked
         * @return {boolean} <code>true</code> if <code>element</code> is a canvas; otherwise <code>false</code>.
         * @public
         * @abstract
         * @memberof ElementService#
         */
        isCanvas: function(element) {
        },
        /**
         * Returns whether the specified <code>element</code> is an image.
         *
         * Implementations of {@link ElementService} <b>must</b> override this method with their own specific logic.
         *
         * @param {*} element - the element to be checked
         * @return {boolean} <code>true</code> if <code>element</code> is an image; otherwise <code>false</code>.
         * @public
         * @abstract
         * @memberof ElementService#
         */
        isImage: function(element) {
        }
      });
      var ElementService_1 = ElementService;
      var BrowserElementService = ElementService_1.extend({
        /**
         * @override
         */
        createCanvas: function() {
          return document.createElement("canvas");
        },
        /**
         * @override
         */
        createImage: function() {
          return document.createElement("img");
        },
        /**
         * @override
         */
        isCanvas: function(element) {
          return element instanceof HTMLCanvasElement;
        },
        /**
         * @override
         */
        isImage: function(element) {
          return element instanceof HTMLImageElement;
        }
      });
      var BrowserElementService_1 = BrowserElementService;
      index.use(new BrowserElementService_1());
      var QRious_1 = index;
      return QRious_1;
    });
  }
});

// node_modules/air-datepicker/air-datepicker.js
var require_air_datepicker = __commonJS({
  "node_modules/air-datepicker/air-datepicker.js"(exports, module) {
    !function(e3, t2) {
      "object" == typeof exports && "object" == typeof module ? module.exports = t2() : "function" == typeof define && define.amd ? define([], t2) : "object" == typeof exports ? exports.AirDatepicker = t2() : e3.AirDatepicker = t2();
    }(exports, function() {
      return function() {
        "use strict";
        var e3 = { d: function(t3, i4) {
          for (var s4 in i4) e3.o(i4, s4) && !e3.o(t3, s4) && Object.defineProperty(t3, s4, { enumerable: true, get: i4[s4] });
        }, o: function(e4, t3) {
          return Object.prototype.hasOwnProperty.call(e4, t3);
        } }, t2 = {};
        e3.d(t2, { default: function() {
          return R2;
        } });
        var i3 = { days: "days", months: "months", years: "years", day: "day", month: "month", year: "year", eventChangeViewDate: "changeViewDate", eventChangeCurrentView: "changeCurrentView", eventChangeFocusDate: "changeFocusDate", eventChangeSelectedDate: "changeSelectedDate", eventChangeTime: "changeTime", eventChangeLastSelectedDate: "changeLastSelectedDate", actionSelectDate: "selectDate", actionUnselectDate: "unselectDate", cssClassWeekend: "-weekend-" }, s3 = { classes: "", inline: false, locale: { days: ["\u0412\u043E\u0441\u043A\u0440\u0435\u0441\u0435\u043D\u044C\u0435", "\u041F\u043E\u043D\u0435\u0434\u0435\u043B\u044C\u043D\u0438\u043A", "\u0412\u0442\u043E\u0440\u043D\u0438\u043A", "\u0421\u0440\u0435\u0434\u0430", "\u0427\u0435\u0442\u0432\u0435\u0440\u0433", "\u041F\u044F\u0442\u043D\u0438\u0446\u0430", "\u0421\u0443\u0431\u0431\u043E\u0442\u0430"], daysShort: ["\u0412\u043E\u0441", "\u041F\u043E\u043D", "\u0412\u0442\u043E", "\u0421\u0440\u0435", "\u0427\u0435\u0442", "\u041F\u044F\u0442", "\u0421\u0443\u0431"], daysMin: ["\u0412\u0441", "\u041F\u043D", "\u0412\u0442", "\u0421\u0440", "\u0427\u0442", "\u041F\u0442", "\u0421\u0431"], months: ["\u042F\u043D\u0432\u0430\u0440\u044C", "\u0424\u0435\u0432\u0440\u0430\u043B\u044C", "\u041C\u0430\u0440\u0442", "\u0410\u043F\u0440\u0435\u043B\u044C", "\u041C\u0430\u0439", "\u0418\u044E\u043D\u044C", "\u0418\u044E\u043B\u044C", "\u0410\u0432\u0433\u0443\u0441\u0442", "\u0421\u0435\u043D\u0442\u044F\u0431\u0440\u044C", "\u041E\u043A\u0442\u044F\u0431\u0440\u044C", "\u041D\u043E\u044F\u0431\u0440\u044C", "\u0414\u0435\u043A\u0430\u0431\u0440\u044C"], monthsShort: ["\u042F\u043D\u0432", "\u0424\u0435\u0432", "\u041C\u0430\u0440", "\u0410\u043F\u0440", "\u041C\u0430\u0439", "\u0418\u044E\u043D", "\u0418\u044E\u043B", "\u0410\u0432\u0433", "\u0421\u0435\u043D", "\u041E\u043A\u0442", "\u041D\u043E\u044F", "\u0414\u0435\u043A"], today: "\u0421\u0435\u0433\u043E\u0434\u043D\u044F", clear: "\u041E\u0447\u0438\u0441\u0442\u0438\u0442\u044C", dateFormat: "dd.MM.yyyy", timeFormat: "HH:mm", firstDay: 1 }, startDate: /* @__PURE__ */ new Date(), firstDay: "", weekends: [6, 0], dateFormat: "", altField: "", altFieldDateFormat: "T", toggleSelected: true, keyboardNav: true, selectedDates: false, container: "", isMobile: false, visible: false, position: "bottom left", offset: 12, view: i3.days, minView: i3.days, showOtherMonths: true, selectOtherMonths: true, moveToOtherMonthsOnSelect: true, showOtherYears: true, selectOtherYears: true, moveToOtherYearsOnSelect: true, minDate: "", maxDate: "", disableNavWhenOutOfRange: true, multipleDates: false, multipleDatesSeparator: ", ", range: false, dynamicRange: true, buttons: false, monthsField: "monthsShort", showEvent: "focus", autoClose: false, fixedHeight: false, prevHtml: '<svg><path d="M 17,12 l -5,5 l 5,5"></path></svg>', nextHtml: '<svg><path d="M 14,12 l 5,5 l -5,5"></path></svg>', navTitles: { days: "MMMM, <i>yyyy</i>", months: "yyyy", years: "yyyy1 - yyyy2" }, timepicker: false, onlyTimepicker: false, dateTimeSeparator: " ", timeFormat: "", minHours: 0, maxHours: 24, minMinutes: 0, maxMinutes: 59, hoursStep: 1, minutesStep: 1, onSelect: false, onChangeViewDate: false, onChangeView: false, onRenderCell: false, onShow: false, onHide: false, onClickDayName: false };
        function a3(e4) {
          let t3 = arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : document;
          return "string" == typeof e4 ? t3.querySelector(e4) : e4;
        }
        function n4() {
          let { tagName: e4 = "div", className: t3 = "", innerHtml: i4 = "", id: s4 = "", attrs: a4 = {} } = arguments.length > 0 && void 0 !== arguments[0] ? arguments[0] : {}, n5 = document.createElement(e4);
          return t3 && n5.classList.add(...t3.split(" ")), s4 && (n5.id = s4), i4 && (n5.innerHTML = i4), a4 && r3(n5, a4), n5;
        }
        function r3(e4, t3) {
          for (let [i4, s4] of Object.entries(t3)) void 0 !== s4 && e4.setAttribute(i4, s4);
          return e4;
        }
        function o3(e4) {
          return new Date(e4.getFullYear(), e4.getMonth() + 1, 0).getDate();
        }
        function h3(e4) {
          let t3 = e4.getHours(), { hours: i4, dayPeriod: s4 } = l3(t3);
          return { year: e4.getFullYear(), month: e4.getMonth(), fullMonth: e4.getMonth() + 1 < 10 ? "0" + (e4.getMonth() + 1) : e4.getMonth() + 1, date: e4.getDate(), fullDate: e4.getDate() < 10 ? "0" + e4.getDate() : e4.getDate(), day: e4.getDay(), hours: t3, fullHours: d3(t3), hours12: i4, dayPeriod: s4, fullHours12: d3(i4), minutes: e4.getMinutes(), fullMinutes: e4.getMinutes() < 10 ? "0" + e4.getMinutes() : e4.getMinutes() };
        }
        function l3(e4) {
          return { dayPeriod: e4 > 11 ? "pm" : "am", hours: e4 % 12 == 0 ? 12 : e4 % 12 };
        }
        function d3(e4) {
          return e4 < 10 ? "0" + e4 : e4;
        }
        function c3(e4) {
          let t3 = 10 * Math.floor(e4.getFullYear() / 10);
          return [t3, t3 + 9];
        }
        function u3() {
          let e4 = [];
          for (var t3 = arguments.length, i4 = new Array(t3), s4 = 0; s4 < t3; s4++) i4[s4] = arguments[s4];
          return i4.forEach((t4) => {
            if ("object" == typeof t4) for (let i5 in t4) t4[i5] && e4.push(i5);
            else t4 && e4.push(t4);
          }), e4.join(" ");
        }
        function p3(e4, t3) {
          let s4 = arguments.length > 2 && void 0 !== arguments[2] ? arguments[2] : i3.days;
          if (!e4 || !t3) return false;
          let a4 = h3(e4), n5 = h3(t3);
          return { [i3.days]: a4.date === n5.date && a4.month === n5.month && a4.year === n5.year, [i3.months]: a4.month === n5.month && a4.year === n5.year, [i3.years]: a4.year === n5.year }[s4];
        }
        function m3(e4, t3, i4) {
          let s4 = g3(e4, false).getTime(), a4 = g3(t3, false).getTime();
          return i4 ? s4 >= a4 : s4 > a4;
        }
        function v3(e4, t3) {
          return !m3(e4, t3, true);
        }
        function g3(e4) {
          let t3 = !(arguments.length > 1 && void 0 !== arguments[1]) || arguments[1], i4 = new Date(e4.getTime());
          return "boolean" != typeof t3 || t3 || function(e5) {
            e5.setHours(0, 0, 0, 0);
          }(i4), i4;
        }
        function D3(e4, t3, i4) {
          e4.length ? e4.forEach((e5) => {
            e5.addEventListener(t3, i4);
          }) : e4.addEventListener(t3, i4);
        }
        function y3(e4, t3) {
          return !(!e4 || e4 === document || e4 instanceof DocumentFragment) && (e4.matches(t3) ? e4 : y3(e4.parentNode, t3));
        }
        function f3(e4, t3, i4) {
          return e4 > i4 ? i4 : e4 < t3 ? t3 : e4;
        }
        function w3(e4) {
          for (var t3 = arguments.length, i4 = new Array(t3 > 1 ? t3 - 1 : 0), s4 = 1; s4 < t3; s4++) i4[s4 - 1] = arguments[s4];
          return i4.filter((e5) => e5).forEach((t4) => {
            for (let [i5, s5] of Object.entries(t4)) if (void 0 !== s5 && "[object Object]" === s5.toString()) {
              let t5 = void 0 !== e4[i5] ? e4[i5].toString() : void 0, a4 = s5.toString(), n5 = Array.isArray(s5) ? [] : {};
              e4[i5] = e4[i5] ? t5 !== a4 ? n5 : e4[i5] : n5, w3(e4[i5], s5);
            } else e4[i5] = s5;
          }), e4;
        }
        function b3(e4) {
          let t3 = e4;
          return e4 instanceof Date || ("string" == typeof e4 && /^\d{4}-\d{2}-\d{2}$/.test(e4) && (e4 += "T00:00:00"), t3 = new Date(e4)), isNaN(t3.getTime()) && (console.log(`Unable to convert value "${e4}" to Date object`), t3 = false), t3;
        }
        function k2(e4) {
          let t3 = "\\s|\\.|-|/|\\\\|,|\\$|\\!|\\?|:|;";
          return new RegExp("(^|>|" + t3 + ")(" + e4 + ")($|<|" + t3 + ")", "g");
        }
        function $6(e4, t3, i4) {
          return (t3 = function(e5) {
            var t4 = function(e6, t5) {
              if ("object" != typeof e6 || null === e6) return e6;
              var i5 = e6[Symbol.toPrimitive];
              if (void 0 !== i5) {
                var s4 = i5.call(e6, "string");
                if ("object" != typeof s4) return s4;
                throw new TypeError("@@toPrimitive must return a primitive value.");
              }
              return String(e6);
            }(e5);
            return "symbol" == typeof t4 ? t4 : String(t4);
          }(t3)) in e4 ? Object.defineProperty(e4, t3, { value: i4, enumerable: true, configurable: true, writable: true }) : e4[t3] = i4, e4;
        }
        class C2 {
          constructor() {
            let { type: e4, date: t3, dp: i4, opts: s4, body: a4 } = arguments.length > 0 && void 0 !== arguments[0] ? arguments[0] : {};
            $6(this, "focus", () => {
              this.$cell.classList.add("-focus-"), this.focused = true;
            }), $6(this, "removeFocus", () => {
              this.$cell.classList.remove("-focus-"), this.focused = false;
            }), $6(this, "select", () => {
              this.$cell.classList.add("-selected-"), this.selected = true;
            }), $6(this, "removeSelect", () => {
              this.$cell.classList.remove("-selected-", "-range-from-", "-range-to-"), this.selected = false;
            }), $6(this, "onChangeSelectedDate", () => {
              this.isDisabled || (this._handleSelectedStatus(), this.opts.range && this._handleRangeStatus());
            }), $6(this, "onChangeFocusDate", (e5) => {
              if (!e5) return void (this.focused && this.removeFocus());
              let t4 = p3(e5, this.date, this.type);
              t4 ? this.focus() : !t4 && this.focused && this.removeFocus(), this.opts.range && this._handleRangeStatus();
            }), $6(this, "render", () => (this.$cell.innerHTML = this._getHtml(), this._handleClasses(), this.$cell)), this.type = e4, this.singleType = this.type.slice(0, -1), this.date = t3, this.dp = i4, this.opts = s4, this.body = a4, this.customData = false, this.init();
          }
          init() {
            var e4;
            let { onRenderCell: t3 } = this.opts;
            t3 && (this.customData = t3({ date: this.date, cellType: this.singleType, datepicker: this.dp })), this._createElement(), this._bindDatepickerEvents(), null !== (e4 = this.customData) && void 0 !== e4 && e4.disabled && this.dp.disableDate(this.date);
          }
          _bindDatepickerEvents() {
            this.dp.on(i3.eventChangeSelectedDate, this.onChangeSelectedDate), this.dp.on(i3.eventChangeFocusDate, this.onChangeFocusDate);
          }
          unbindDatepickerEvents() {
            this.dp.off(i3.eventChangeSelectedDate, this.onChangeSelectedDate), this.dp.off(i3.eventChangeFocusDate, this.onChangeFocusDate);
          }
          _createElement() {
            var e4;
            let { year: t3, month: i4, date: s4 } = h3(this.date), a4 = (null === (e4 = this.customData) || void 0 === e4 ? void 0 : e4.attrs) || {};
            this.$cell = n4({ attrs: { "data-year": t3, "data-month": i4, "data-date": s4, ...a4 } }), this.$cell.adpCell = this;
          }
          _getClassName() {
            var e4;
            let t3 = /* @__PURE__ */ new Date(), { selectOtherMonths: s4, selectOtherYears: a4 } = this.opts, { minDate: n5, maxDate: r4, isDateDisabled: o4 } = this.dp, { day: l4 } = h3(this.date), d4 = this._isOutOfMinMaxRange(), c4 = o4(this.date), m4 = u3("air-datepicker-cell", `-${this.singleType}-`, { "-current-": p3(t3, this.date, this.type), "-min-date-": n5 && p3(n5, this.date, this.type), "-max-date-": r4 && p3(r4, this.date, this.type) }), v4 = "";
            switch (this.type) {
              case i3.days:
                v4 = u3({ "-weekend-": this.dp.isWeekend(l4), "-other-month-": this.isOtherMonth, "-disabled-": this.isOtherMonth && !s4 || d4 || c4 });
                break;
              case i3.months:
                v4 = u3({ "-disabled-": d4 });
                break;
              case i3.years:
                v4 = u3({ "-other-decade-": this.isOtherDecade, "-disabled-": d4 || this.isOtherDecade && !a4 });
            }
            return u3(m4, v4, null === (e4 = this.customData) || void 0 === e4 ? void 0 : e4.classes).split(" ");
          }
          _getHtml() {
            var e4;
            let { year: t3, month: s4, date: a4 } = h3(this.date), { showOtherMonths: n5, showOtherYears: r4 } = this.opts;
            if (null !== (e4 = this.customData) && void 0 !== e4 && e4.html) return this.customData.html;
            switch (this.type) {
              case i3.days:
                return !n5 && this.isOtherMonth ? "" : a4;
              case i3.months:
                return this.dp.locale[this.opts.monthsField][s4];
              case i3.years:
                return !r4 && this.isOtherDecade ? "" : t3;
            }
          }
          _isOutOfMinMaxRange() {
            let { minDate: e4, maxDate: t3 } = this.dp, { type: s4, date: a4 } = this, { month: n5, year: r4, date: o4 } = h3(a4), l4 = s4 === i3.days, d4 = s4 === i3.years, c4 = !!e4 && new Date(r4, d4 ? e4.getMonth() : n5, l4 ? o4 : e4.getDate()), u4 = !!t3 && new Date(r4, d4 ? t3.getMonth() : n5, l4 ? o4 : t3.getDate());
            return e4 && t3 ? v3(c4, e4) || m3(u4, t3) : e4 ? v3(c4, e4) : t3 ? m3(u4, t3) : void 0;
          }
          destroy() {
            this.unbindDatepickerEvents();
          }
          _handleRangeStatus() {
            const { selectedDates: e4, focusDate: t3, rangeDateTo: i4, rangeDateFrom: s4 } = this.dp, a4 = e4.length;
            if (!a4) return;
            let n5 = s4, r4 = i4;
            if (1 === a4 && t3) {
              const i5 = m3(t3, e4[0]);
              n5 = i5 ? e4[0] : t3, r4 = i5 ? t3 : e4[0];
            }
            let o4 = u3({ "-in-range-": n5 && r4 && (h4 = this.date, l4 = n5, d4 = r4, m3(h4, l4) && v3(h4, d4)), "-range-from-": n5 && p3(this.date, n5, this.type), "-range-to-": r4 && p3(this.date, r4, this.type) });
            var h4, l4, d4;
            this.$cell.classList.remove("-range-from-", "-range-to-", "-in-range-"), o4 && this.$cell.classList.add(...o4.split(" "));
          }
          _handleSelectedStatus() {
            let e4 = this.dp._checkIfDateIsSelected(this.date, this.type);
            e4 ? this.select() : !e4 && this.selected && this.removeSelect();
          }
          _handleInitialFocusStatus() {
            p3(this.dp.focusDate, this.date, this.type) && this.focus();
          }
          _handleClasses() {
            this.$cell.setAttribute("class", ""), this._handleInitialFocusStatus(), this.dp.hasSelectedDates && (this._handleSelectedStatus(), this.dp.opts.range && this._handleRangeStatus()), this.$cell.classList.add(...this._getClassName());
          }
          get isDisabled() {
            return this.$cell.matches(".-disabled-");
          }
          get isOtherMonth() {
            return this.dp.isOtherMonth(this.date);
          }
          get isOtherDecade() {
            return this.dp.isOtherDecade(this.date);
          }
        }
        function _6(e4, t3, i4) {
          return (t3 = function(e5) {
            var t4 = function(e6, t5) {
              if ("object" != typeof e6 || null === e6) return e6;
              var i5 = e6[Symbol.toPrimitive];
              if (void 0 !== i5) {
                var s4 = i5.call(e6, "string");
                if ("object" != typeof s4) return s4;
                throw new TypeError("@@toPrimitive must return a primitive value.");
              }
              return String(e6);
            }(e5);
            return "symbol" == typeof t4 ? t4 : String(t4);
          }(t3)) in e4 ? Object.defineProperty(e4, t3, { value: i4, enumerable: true, configurable: true, writable: true }) : e4[t3] = i4, e4;
        }
        let M = { [i3.days]: `<div class="air-datepicker-body--day-names"></div><div class="air-datepicker-body--cells -${i3.days}-"></div>`, [i3.months]: `<div class="air-datepicker-body--cells -${i3.months}-"></div>`, [i3.years]: `<div class="air-datepicker-body--cells -${i3.years}-"></div>` };
        const S2 = ".air-datepicker-cell";
        class T3 {
          constructor(e4) {
            let { dp: t3, type: s4, opts: a4 } = e4;
            _6(this, "handleClick", (e5) => {
              let t4 = e5.target.closest(S2).adpCell;
              if (t4.isDisabled) return;
              if (!this.dp.isMinViewReached) return void this.dp.down();
              let i4 = this.dp._checkIfDateIsSelected(t4.date, t4.type);
              i4 ? this.dp._handleAlreadySelectedDates(i4, t4.date) : this.dp.selectDate(t4.date);
            }), _6(this, "handleDayNameClick", (e5) => {
              let t4 = e5.target.getAttribute("data-day-index");
              this.opts.onClickDayName({ dayIndex: Number(t4), datepicker: this.dp });
            }), _6(this, "onChangeCurrentView", (e5) => {
              e5 !== this.type ? this.hide() : (this.show(), this.render());
            }), _6(this, "onMouseOverCell", (e5) => {
              let t4 = y3(e5.target, S2);
              this.dp.setFocusDate(!!t4 && t4.adpCell.date);
            }), _6(this, "onMouseOutCell", () => {
              this.dp.setFocusDate(false);
            }), _6(this, "onClickBody", (e5) => {
              let { onClickDayName: t4 } = this.opts, i4 = e5.target;
              i4.closest(S2) && this.handleClick(e5), t4 && i4.closest(".air-datepicker-body--day-name") && this.handleDayNameClick(e5);
            }), _6(this, "onMouseDown", (e5) => {
              this.pressed = true;
              let t4 = y3(e5.target, S2), i4 = t4 && t4.adpCell;
              p3(i4.date, this.dp.rangeDateFrom) && (this.rangeFromFocused = true), p3(i4.date, this.dp.rangeDateTo) && (this.rangeToFocused = true);
            }), _6(this, "onMouseMove", (e5) => {
              if (!this.pressed || !this.dp.isMinViewReached) return;
              e5.preventDefault();
              let t4 = y3(e5.target, S2), i4 = t4 && t4.adpCell, { selectedDates: s5, rangeDateTo: a5, rangeDateFrom: n5 } = this.dp;
              if (!i4 || i4.isDisabled) return;
              let { date: r4 } = i4;
              if (2 === s5.length) {
                if (this.rangeFromFocused && !m3(r4, a5)) {
                  let { hours: e6, minutes: t5 } = h3(n5);
                  r4.setHours(e6), r4.setMinutes(t5), this.dp.rangeDateFrom = r4, this.dp.replaceDate(n5, r4);
                }
                if (this.rangeToFocused && !v3(r4, n5)) {
                  let { hours: e6, minutes: t5 } = h3(a5);
                  r4.setHours(e6), r4.setMinutes(t5), this.dp.rangeDateTo = r4, this.dp.replaceDate(a5, r4);
                }
              }
            }), _6(this, "onMouseUp", () => {
              this.pressed = false, this.rangeFromFocused = false, this.rangeToFocused = false;
            }), _6(this, "onChangeViewDate", (e5, t4) => {
              if (!this.isVisible) return;
              let s5 = c3(e5), a5 = c3(t4);
              switch (this.dp.currentView) {
                case i3.days:
                  if (p3(e5, t4, i3.months)) return;
                  break;
                case i3.months:
                  if (p3(e5, t4, i3.years)) return;
                  break;
                case i3.years:
                  if (s5[0] === a5[0] && s5[1] === a5[1]) return;
              }
              this.render();
            }), _6(this, "render", () => {
              this.destroyCells(), this._generateCells(), this.cells.forEach((e5) => {
                this.$cells.appendChild(e5.render());
              });
            }), this.dp = t3, this.type = s4, this.opts = a4, this.cells = [], this.$el = "", this.pressed = false, this.isVisible = true, this.init();
          }
          init() {
            this._buildBaseHtml(), this.type === i3.days && this.renderDayNames(), this.render(), this._bindEvents(), this._bindDatepickerEvents();
          }
          _bindEvents() {
            let { range: e4, dynamicRange: t3 } = this.opts;
            D3(this.$el, "mouseover", this.onMouseOverCell), D3(this.$el, "mouseout", this.onMouseOutCell), D3(this.$el, "click", this.onClickBody), e4 && t3 && (D3(this.$el, "mousedown", this.onMouseDown), D3(this.$el, "mousemove", this.onMouseMove), D3(window.document, "mouseup", this.onMouseUp));
          }
          _bindDatepickerEvents() {
            this.dp.on(i3.eventChangeViewDate, this.onChangeViewDate), this.dp.on(i3.eventChangeCurrentView, this.onChangeCurrentView);
          }
          _buildBaseHtml() {
            this.$el = n4({ className: `air-datepicker-body -${this.type}-`, innerHtml: M[this.type] }), this.$names = a3(".air-datepicker-body--day-names", this.$el), this.$cells = a3(".air-datepicker-body--cells", this.$el);
          }
          _getDayNamesHtml() {
            let e4 = arguments.length > 0 && void 0 !== arguments[0] ? arguments[0] : this.dp.locale.firstDay, t3 = "", s4 = this.dp.isWeekend, { onClickDayName: a4 } = this.opts, n5 = e4, r4 = 0;
            for (; r4 < 7; ) {
              let e5 = n5 % 7;
              t3 += `<div class="${u3("air-datepicker-body--day-name", { [i3.cssClassWeekend]: s4(e5), "-clickable-": !!a4 })}" data-day-index='${e5}'>${this.dp.locale.daysMin[e5]}</div>`, r4++, n5++;
            }
            return t3;
          }
          renderDayNames() {
            this.$names.innerHTML = this._getDayNamesHtml();
          }
          _generateCell(e4) {
            let { type: t3, dp: i4, opts: s4 } = this;
            return new C2({ type: t3, dp: i4, opts: s4, date: e4, body: this });
          }
          _generateCells() {
            T3.getDatesFunction(this.type)(this.dp, (e4) => {
              this.cells.push(this._generateCell(e4));
            });
          }
          show() {
            this.isVisible = true, this.$el.classList.remove("-hidden-");
          }
          hide() {
            this.isVisible = false, this.$el.classList.add("-hidden-");
          }
          destroyCells() {
            this.cells.forEach((e4) => e4.destroy()), this.cells = [], this.$cells.innerHTML = "";
          }
          destroy() {
            this.destroyCells(), this.dp.off(i3.eventChangeViewDate, this.onChangeViewDate), this.dp.off(i3.eventChangeCurrentView, this.onChangeCurrentView);
          }
          static getDaysDates(e4, t3) {
            let { viewDate: i4, opts: { fixedHeight: s4 }, locale: { firstDay: a4 } } = e4, n5 = o3(i4), { year: r4, month: l4 } = h3(i4), d4 = new Date(r4, l4, 1), c4 = new Date(r4, l4, n5), u4 = d4.getDay() - a4, p4 = 6 - c4.getDay() + a4;
            u4 = u4 < 0 ? u4 + 7 : u4, p4 = p4 > 6 ? p4 - 7 : p4;
            let m4 = function(e5, t4) {
              let { year: i5, month: s5, date: a5 } = h3(e5);
              return new Date(i5, s5, a5 - t4);
            }(d4, u4), v4 = n5 + u4 + p4, g4 = m4.getDate(), { year: D4, month: y4 } = h3(m4), f4 = 0;
            s4 && (v4 = 42);
            const w4 = [];
            for (; f4 < v4; ) {
              let e5 = new Date(D4, y4, g4 + f4);
              t3 && t3(e5), w4.push(e5), f4++;
            }
            return w4;
          }
          static getMonthsDates(e4, t3) {
            let { year: i4 } = e4.parsedViewDate, s4 = 0, a4 = [];
            for (; s4 < 12; ) {
              const e5 = new Date(i4, s4);
              a4.push(e5), t3 && t3(e5), s4++;
            }
            return a4;
          }
          static getYearsDates(e4, t3) {
            let i4 = c3(e4.viewDate), s4 = i4[0] - 1, a4 = i4[1] + 1, n5 = s4, r4 = [];
            for (; n5 <= a4; ) {
              const e5 = new Date(n5, 0);
              r4.push(e5), t3 && t3(e5), n5++;
            }
            return r4;
          }
          static getDatesFunction() {
            let e4 = arguments.length > 0 && void 0 !== arguments[0] ? arguments[0] : i3.days;
            return { [i3.days]: T3.getDaysDates, [i3.months]: T3.getMonthsDates, [i3.years]: T3.getYearsDates }[e4];
          }
        }
        function F2(e4, t3, i4) {
          return (t3 = function(e5) {
            var t4 = function(e6, t5) {
              if ("object" != typeof e6 || null === e6) return e6;
              var i5 = e6[Symbol.toPrimitive];
              if (void 0 !== i5) {
                var s4 = i5.call(e6, "string");
                if ("object" != typeof s4) return s4;
                throw new TypeError("@@toPrimitive must return a primitive value.");
              }
              return String(e6);
            }(e5);
            return "symbol" == typeof t4 ? t4 : String(t4);
          }(t3)) in e4 ? Object.defineProperty(e4, t3, { value: i4, enumerable: true, configurable: true, writable: true }) : e4[t3] = i4, e4;
        }
        class V2 {
          constructor(e4) {
            let { dp: t3, opts: i4 } = e4;
            F2(this, "onClickNav", (e5) => {
              let t4 = y3(e5.target, ".air-datepicker-nav--action");
              if (!t4) return;
              let i5 = t4.dataset.action;
              this.dp[i5]();
            }), F2(this, "onChangeViewDate", () => {
              this.render(), this._resetNavStatus(), this.handleNavStatus();
            }), F2(this, "onChangeCurrentView", () => {
              this.render(), this._resetNavStatus(), this.handleNavStatus();
            }), F2(this, "onClickNavTitle", () => {
              this.dp.isFinalView || this.dp.up();
            }), F2(this, "update", () => {
              let { prevHtml: e5, nextHtml: t4 } = this.opts;
              this.$prev.innerHTML = e5, this.$next.innerHTML = t4, this._resetNavStatus(), this.render(), this.handleNavStatus();
            }), F2(this, "renderDelay", () => {
              setTimeout(this.render);
            }), F2(this, "render", () => {
              this.$title.innerHTML = this._getTitle(), function(e5, t4) {
                for (let i5 in t4) t4[i5] ? e5.classList.add(i5) : e5.classList.remove(i5);
              }(this.$title, { "-disabled-": this.dp.isFinalView });
            }), this.dp = t3, this.opts = i4, this.init();
          }
          init() {
            this._createElement(), this._buildBaseHtml(), this._defineDOM(), this.render(), this.handleNavStatus(), this._bindEvents(), this._bindDatepickerEvents();
          }
          _defineDOM() {
            this.$title = a3(".air-datepicker-nav--title", this.$el), this.$prev = a3('[data-action="prev"]', this.$el), this.$next = a3('[data-action="next"]', this.$el);
          }
          _bindEvents() {
            this.$el.addEventListener("click", this.onClickNav), this.$title.addEventListener("click", this.onClickNavTitle);
          }
          _bindDatepickerEvents() {
            this.dp.on(i3.eventChangeViewDate, this.onChangeViewDate), this.dp.on(i3.eventChangeCurrentView, this.onChangeCurrentView), this.isNavIsFunction && (this.dp.on(i3.eventChangeSelectedDate, this.renderDelay), this.dp.opts.timepicker && this.dp.on(i3.eventChangeTime, this.render));
          }
          destroy() {
            this.dp.off(i3.eventChangeViewDate, this.onChangeViewDate), this.dp.off(i3.eventChangeCurrentView, this.onChangeCurrentView), this.isNavIsFunction && (this.dp.off(i3.eventChangeSelectedDate, this.renderDelay), this.dp.opts.timepicker && this.dp.off(i3.eventChangeTime, this.render));
          }
          _createElement() {
            this.$el = n4({ tagName: "nav", className: "air-datepicker-nav" });
          }
          _getTitle() {
            let { dp: e4, opts: t3 } = this, i4 = t3.navTitles[e4.currentView];
            return "function" == typeof i4 ? i4(e4) : e4.formatDate(e4.viewDate, i4);
          }
          handleNavStatus() {
            let { disableNavWhenOutOfRange: e4 } = this.opts, { minDate: t3, maxDate: s4 } = this.dp;
            if (!t3 && !s4 || !e4) return;
            let { year: a4, month: n5 } = this.dp.parsedViewDate, r4 = !!t3 && h3(t3), o4 = !!s4 && h3(s4);
            switch (this.dp.currentView) {
              case i3.days:
                t3 && r4.month >= n5 && r4.year >= a4 && this._disableNav("prev"), s4 && o4.month <= n5 && o4.year <= a4 && this._disableNav("next");
                break;
              case i3.months:
                t3 && r4.year >= a4 && this._disableNav("prev"), s4 && o4.year <= a4 && this._disableNav("next");
                break;
              case i3.years: {
                let e5 = c3(this.dp.viewDate);
                t3 && r4.year >= e5[0] && this._disableNav("prev"), s4 && o4.year <= e5[1] && this._disableNav("next");
                break;
              }
            }
          }
          _disableNav(e4) {
            a3('[data-action="' + e4 + '"]', this.$el).classList.add("-disabled-");
          }
          _resetNavStatus() {
            !function(e4) {
              for (var t3 = arguments.length, i4 = new Array(t3 > 1 ? t3 - 1 : 0), s4 = 1; s4 < t3; s4++) i4[s4 - 1] = arguments[s4];
              e4.length ? e4.forEach((e5) => {
                e5.classList.remove(...i4);
              }) : e4.classList.remove(...i4);
            }(this.$el.querySelectorAll(".air-datepicker-nav--action"), "-disabled-");
          }
          _buildBaseHtml() {
            let { prevHtml: e4, nextHtml: t3 } = this.opts;
            this.$el.innerHTML = `<div class="air-datepicker-nav--action" data-action="prev">${e4}</div><div class="air-datepicker-nav--title"></div><div class="air-datepicker-nav--action" data-action="next">${t3}</div>`;
          }
          get isNavIsFunction() {
            let { navTitles: e4 } = this.opts;
            return Object.keys(e4).find((t3) => "function" == typeof e4[t3]);
          }
        }
        var x3 = { today: { content: (e4) => e4.locale.today, onClick: (e4) => e4.setViewDate(/* @__PURE__ */ new Date()) }, clear: { content: (e4) => e4.locale.clear, onClick: (e4) => e4.clear() } };
        class H2 {
          constructor(e4) {
            let { dp: t3, opts: i4 } = e4;
            this.dp = t3, this.opts = i4, this.init();
          }
          init() {
            this.createElement(), this.render();
          }
          createElement() {
            this.$el = n4({ className: "air-datepicker-buttons" });
          }
          destroy() {
            this.$el.parentNode.removeChild(this.$el);
          }
          clearHtml() {
            return this.$el.innerHTML = "", this;
          }
          generateButtons() {
            let { buttons: e4 } = this.opts;
            Array.isArray(e4) || (e4 = [e4]), e4.forEach((e5) => {
              let t3 = e5;
              "string" == typeof e5 && x3[e5] && (t3 = x3[e5]);
              let i4 = this.createButton(t3);
              t3.onClick && this.attachEventToButton(i4, t3.onClick), this.$el.appendChild(i4);
            });
          }
          attachEventToButton(e4, t3) {
            e4.addEventListener("click", () => {
              t3(this.dp);
            });
          }
          createButton(e4) {
            let { content: t3, className: i4, tagName: s4 = "button", attrs: a4 = {} } = e4;
            return n4({ tagName: s4, innerHtml: `<span tabindex='-1'>${"function" == typeof t3 ? t3(this.dp) : t3}</span>`, className: u3("air-datepicker-button", i4), attrs: a4 });
          }
          render() {
            this.generateButtons();
          }
        }
        function E3(e4, t3, i4) {
          return (t3 = function(e5) {
            var t4 = function(e6, t5) {
              if ("object" != typeof e6 || null === e6) return e6;
              var i5 = e6[Symbol.toPrimitive];
              if (void 0 !== i5) {
                var s4 = i5.call(e6, "string");
                if ("object" != typeof s4) return s4;
                throw new TypeError("@@toPrimitive must return a primitive value.");
              }
              return String(e6);
            }(e5);
            return "symbol" == typeof t4 ? t4 : String(t4);
          }(t3)) in e4 ? Object.defineProperty(e4, t3, { value: i4, enumerable: true, configurable: true, writable: true }) : e4[t3] = i4, e4;
        }
        class L3 {
          constructor() {
            let { opts: e4, dp: t3 } = arguments.length > 0 && void 0 !== arguments[0] ? arguments[0] : {};
            E3(this, "toggleTimepickerIsActive", (e5) => {
              this.dp.timepickerIsActive = e5;
            }), E3(this, "onChangeSelectedDate", (e5) => {
              let { date: t4, updateTime: i4 = false } = e5;
              t4 && (this.setMinMaxTime(t4), this.setCurrentTime(!!i4 && t4), this.addTimeToDate(t4));
            }), E3(this, "onChangeLastSelectedDate", (e5) => {
              e5 && (this.setTime(e5), this.render());
            }), E3(this, "onChangeInputRange", (e5) => {
              let t4 = e5.target;
              this[t4.getAttribute("name")] = t4.value, this.updateText(), this.dp.trigger(i3.eventChangeTime, { hours: this.hours, minutes: this.minutes });
            }), E3(this, "onMouseEnterLeave", (e5) => {
              let t4 = e5.target.getAttribute("name"), i4 = this.$minutesText;
              "hours" === t4 && (i4 = this.$hoursText), i4.classList.toggle("-focus-");
            }), E3(this, "onFocus", () => {
              this.toggleTimepickerIsActive(true);
            }), E3(this, "onBlur", () => {
              this.toggleTimepickerIsActive(false);
            }), this.opts = e4, this.dp = t3;
            let { timeFormat: s4 } = this.dp.locale;
            s4 && (s4.match(k2("h")) || s4.match(k2("hh"))) && (this.ampm = true), this.init();
          }
          init() {
            this.setTime(this.dp.lastSelectedDate || this.dp.viewDate), this.createElement(), this.buildHtml(), this.defineDOM(), this.render(), this.bindDatepickerEvents(), this.bindDOMEvents();
          }
          bindDatepickerEvents() {
            this.dp.on(i3.eventChangeSelectedDate, this.onChangeSelectedDate), this.dp.on(i3.eventChangeLastSelectedDate, this.onChangeLastSelectedDate);
          }
          bindDOMEvents() {
            let e4 = "input";
            navigator.userAgent.match(/trident/gi) && (e4 = "change"), D3(this.$ranges, e4, this.onChangeInputRange), D3(this.$ranges, "mouseenter", this.onMouseEnterLeave), D3(this.$ranges, "mouseleave", this.onMouseEnterLeave), D3(this.$ranges, "focus", this.onFocus), D3(this.$ranges, "mousedown", this.onFocus), D3(this.$ranges, "blur", this.onBlur);
          }
          createElement() {
            this.$el = n4({ className: u3("air-datepicker-time", { "-am-pm-": this.dp.ampm }) });
          }
          destroy() {
            this.dp.off(i3.eventChangeSelectedDate, this.onChangeSelectedDate), this.dp.off(i3.eventChangeLastSelectedDate, this.onChangeLastSelectedDate), this.$el.parentNode.removeChild(this.$el);
          }
          buildHtml() {
            let { ampm: e4, hours: t3, displayHours: i4, minutes: s4, minHours: a4, minMinutes: n5, maxHours: r4, maxMinutes: o4, dayPeriod: h4, opts: { hoursStep: l4, minutesStep: c4 } } = this;
            this.$el.innerHTML = `<div class="air-datepicker-time--current">   <span class="air-datepicker-time--current-hours">${d3(i4)}</span>   <span class="air-datepicker-time--current-colon">:</span>   <span class="air-datepicker-time--current-minutes">${d3(s4)}</span>   ` + (e4 ? `<span class='air-datepicker-time--current-ampm'>${h4}</span>` : "") + `</div><div class="air-datepicker-time--sliders">   <div class="air-datepicker-time--row">      <input type="range" name="hours" value="${t3}" min="${a4}" max="${r4}" step="${l4}"/>   </div>   <div class="air-datepicker-time--row">      <input type="range" name="minutes" value="${s4}" min="${n5}" max="${o4}" step="${c4}"/>   </div></div>`;
          }
          defineDOM() {
            let e4 = (e5) => a3(e5, this.$el);
            this.$ranges = this.$el.querySelectorAll('[type="range"]'), this.$hours = e4('[name="hours"]'), this.$minutes = e4('[name="minutes"]'), this.$hoursText = e4(".air-datepicker-time--current-hours"), this.$minutesText = e4(".air-datepicker-time--current-minutes"), this.$ampm = e4(".air-datepicker-time--current-ampm");
          }
          setTime(e4) {
            this.setMinMaxTime(e4), this.setCurrentTime(e4);
          }
          addTimeToDate(e4) {
            e4 && (e4.setHours(this.hours), e4.setMinutes(this.minutes));
          }
          setMinMaxTime(e4) {
            if (this.setMinMaxTimeFromOptions(), e4) {
              let { minDate: t3, maxDate: i4 } = this.dp;
              t3 && p3(e4, t3) && this.setMinTimeFromMinDate(t3), i4 && p3(e4, i4) && this.setMaxTimeFromMaxDate(i4);
            }
          }
          setCurrentTime(e4) {
            let { hours: t3, minutes: i4 } = e4 ? h3(e4) : this;
            this.hours = f3(t3, this.minHours, this.maxHours), this.minutes = f3(i4, this.minMinutes, this.maxMinutes);
          }
          setMinMaxTimeFromOptions() {
            let { minHours: e4, minMinutes: t3, maxHours: i4, maxMinutes: s4 } = this.opts;
            this.minHours = f3(e4, 0, 23), this.minMinutes = f3(t3, 0, 59), this.maxHours = f3(i4, 0, 23), this.maxMinutes = f3(s4, 0, 59);
          }
          setMinTimeFromMinDate(e4) {
            let { lastSelectedDate: t3 } = this.dp;
            this.minHours = e4.getHours(), t3 && t3.getHours() > e4.getHours() ? this.minMinutes = this.opts.minMinutes : this.minMinutes = e4.getMinutes();
          }
          setMaxTimeFromMaxDate(e4) {
            let { lastSelectedDate: t3 } = this.dp;
            this.maxHours = e4.getHours(), t3 && t3.getHours() < e4.getHours() ? this.maxMinutes = this.opts.maxMinutes : this.maxMinutes = e4.getMinutes();
          }
          updateSliders() {
            r3(this.$hours, { min: this.minHours, max: this.maxHours }).value = this.hours, r3(this.$minutes, { min: this.minMinutes, max: this.maxMinutes }).value = this.minutes;
          }
          updateText() {
            this.$hoursText.innerHTML = d3(this.displayHours), this.$minutesText.innerHTML = d3(this.minutes), this.ampm && (this.$ampm.innerHTML = this.dayPeriod);
          }
          set hours(e4) {
            this._hours = e4;
            let { hours: t3, dayPeriod: i4 } = l3(e4);
            this.displayHours = this.ampm ? t3 : e4, this.dayPeriod = i4;
          }
          get hours() {
            return this._hours;
          }
          render() {
            this.updateSliders(), this.updateText();
          }
        }
        function O4(e4, t3, i4) {
          return (t3 = function(e5) {
            var t4 = function(e6, t5) {
              if ("object" != typeof e6 || null === e6) return e6;
              var i5 = e6[Symbol.toPrimitive];
              if (void 0 !== i5) {
                var s4 = i5.call(e6, "string");
                if ("object" != typeof s4) return s4;
                throw new TypeError("@@toPrimitive must return a primitive value.");
              }
              return String(e6);
            }(e5);
            return "symbol" == typeof t4 ? t4 : String(t4);
          }(t3)) in e4 ? Object.defineProperty(e4, t3, { value: i4, enumerable: true, configurable: true, writable: true }) : e4[t3] = i4, e4;
        }
        class A4 {
          constructor(e4) {
            let { dp: t3, opts: i4 } = e4;
            O4(this, "pressedKeys", /* @__PURE__ */ new Set()), O4(this, "hotKeys", /* @__PURE__ */ new Map([[[["Control", "ArrowRight"], ["Control", "ArrowUp"]], (e5) => e5.month++], [[["Control", "ArrowLeft"], ["Control", "ArrowDown"]], (e5) => e5.month--], [[["Shift", "ArrowRight"], ["Shift", "ArrowUp"]], (e5) => e5.year++], [[["Shift", "ArrowLeft"], ["Shift", "ArrowDown"]], (e5) => e5.year--], [[["Alt", "ArrowRight"], ["Alt", "ArrowUp"]], (e5) => e5.year += 10], [[["Alt", "ArrowLeft"], ["Alt", "ArrowDown"]], (e5) => e5.year -= 10], [["Control", "Shift", "ArrowUp"], (e5, t4) => t4.up()]])), O4(this, "handleHotKey", (e5) => {
              let t4 = this.hotKeys.get(e5), i5 = h3(this.getInitialFocusDate());
              t4(i5, this.dp);
              let { year: s4, month: a4, date: n5 } = i5, r4 = o3(new Date(s4, a4));
              r4 < n5 && (n5 = r4);
              let l4 = this.dp.getClampedDate(new Date(s4, a4, n5));
              this.dp.setFocusDate(l4, { viewDateTransition: true });
            }), O4(this, "isHotKeyPressed", () => {
              let e5 = false, t4 = this.pressedKeys.size, i5 = (e6) => this.pressedKeys.has(e6);
              for (let [s4] of this.hotKeys) {
                if (e5) break;
                if (Array.isArray(s4[0])) s4.forEach((a4) => {
                  e5 || t4 !== a4.length || (e5 = a4.every(i5) && s4);
                });
                else {
                  if (t4 !== s4.length) continue;
                  e5 = s4.every(i5) && s4;
                }
              }
              return e5;
            }), O4(this, "isArrow", (e5) => e5 >= 37 && e5 <= 40), O4(this, "onKeyDown", (e5) => {
              let { key: t4, which: i5 } = e5, { dp: s4, dp: { focusDate: a4 }, opts: n5 } = this;
              this.registerKey(t4);
              let r4 = this.isHotKeyPressed();
              if (r4) return e5.preventDefault(), void this.handleHotKey(r4);
              if (this.isArrow(i5)) return e5.preventDefault(), void this.focusNextCell(t4);
              if ("Enter" === t4) {
                if (s4.currentView !== n5.minView) return void s4.down();
                if (a4) {
                  let e6 = s4._checkIfDateIsSelected(a4);
                  return void (e6 ? s4._handleAlreadySelectedDates(e6, a4) : s4.selectDate(a4));
                }
              }
              "Escape" === t4 && this.dp.hide();
            }), O4(this, "onKeyUp", (e5) => {
              this.removeKey(e5.key);
            }), this.dp = t3, this.opts = i4, this.init();
          }
          init() {
            this.bindKeyboardEvents();
          }
          bindKeyboardEvents() {
            let { $el: e4 } = this.dp;
            e4.addEventListener("keydown", this.onKeyDown), e4.addEventListener("keyup", this.onKeyUp);
          }
          destroy() {
            let { $el: e4 } = this.dp;
            e4.removeEventListener("keydown", this.onKeyDown), e4.removeEventListener("keyup", this.onKeyUp), this.hotKeys = null, this.pressedKeys = null;
          }
          getInitialFocusDate() {
            let { focusDate: e4, currentView: t3, selectedDates: s4, parsedViewDate: { year: a4, month: n5 } } = this.dp, r4 = e4 || s4[s4.length - 1];
            if (!r4) switch (t3) {
              case i3.days:
                r4 = new Date(a4, n5, (/* @__PURE__ */ new Date()).getDate());
                break;
              case i3.months:
                r4 = new Date(a4, n5, 1);
                break;
              case i3.years:
                r4 = new Date(a4, 0, 1);
            }
            return r4;
          }
          focusNextCell(e4) {
            let t3 = this.getInitialFocusDate(), { currentView: s4 } = this.dp, { days: a4, months: n5, years: r4 } = i3, o4 = h3(t3), l4 = o4.year, d4 = o4.month, c4 = o4.date;
            switch (e4) {
              case "ArrowLeft":
                s4 === a4 && (c4 -= 1), s4 === n5 && (d4 -= 1), s4 === r4 && (l4 -= 1);
                break;
              case "ArrowUp":
                s4 === a4 && (c4 -= 7), s4 === n5 && (d4 -= 3), s4 === r4 && (l4 -= 4);
                break;
              case "ArrowRight":
                s4 === a4 && (c4 += 1), s4 === n5 && (d4 += 1), s4 === r4 && (l4 += 1);
                break;
              case "ArrowDown":
                s4 === a4 && (c4 += 7), s4 === n5 && (d4 += 3), s4 === r4 && (l4 += 4);
            }
            let u4 = this.dp.getClampedDate(new Date(l4, d4, c4));
            this.dp.setFocusDate(u4, { viewDateTransition: true });
          }
          registerKey(e4) {
            this.pressedKeys.add(e4);
          }
          removeKey(e4) {
            this.pressedKeys.delete(e4);
          }
        }
        let N = { on(e4, t3) {
          this.__events || (this.__events = {}), this.__events[e4] ? this.__events[e4].push(t3) : this.__events[e4] = [t3];
        }, off(e4, t3) {
          this.__events && this.__events[e4] && (this.__events[e4] = this.__events[e4].filter((e5) => e5 !== t3));
        }, removeAllEvents() {
          this.__events = {};
        }, trigger(e4) {
          for (var t3 = arguments.length, i4 = new Array(t3 > 1 ? t3 - 1 : 0), s4 = 1; s4 < t3; s4++) i4[s4 - 1] = arguments[s4];
          this.__events && this.__events[e4] && this.__events[e4].forEach((e5) => {
            e5(...i4);
          });
        } };
        function I(e4, t3, i4) {
          return (t3 = function(e5) {
            var t4 = function(e6, t5) {
              if ("object" != typeof e6 || null === e6) return e6;
              var i5 = e6[Symbol.toPrimitive];
              if (void 0 !== i5) {
                var s4 = i5.call(e6, "string");
                if ("object" != typeof s4) return s4;
                throw new TypeError("@@toPrimitive must return a primitive value.");
              }
              return String(e6);
            }(e5);
            return "symbol" == typeof t4 ? t4 : String(t4);
          }(t3)) in e4 ? Object.defineProperty(e4, t3, { value: i4, enumerable: true, configurable: true, writable: true }) : e4[t3] = i4, e4;
        }
        let P3 = "", j = "", B = false;
        class R2 {
          static buildGlobalContainer(e4) {
            B = true, P3 = n4({ className: e4, id: e4 }), a3("body").appendChild(P3);
          }
          constructor(e4, t3) {
            var r4 = this;
            if (I(this, "viewIndexes", [i3.days, i3.months, i3.years]), I(this, "next", () => {
              let { year: e5, month: t4 } = this.parsedViewDate;
              switch (this.currentView) {
                case i3.days:
                  this.setViewDate(new Date(e5, t4 + 1, 1));
                  break;
                case i3.months:
                  this.setViewDate(new Date(e5 + 1, t4, 1));
                  break;
                case i3.years:
                  this.setViewDate(new Date(e5 + 10, 0, 1));
              }
            }), I(this, "prev", () => {
              let { year: e5, month: t4 } = this.parsedViewDate;
              switch (this.currentView) {
                case i3.days:
                  this.setViewDate(new Date(e5, t4 - 1, 1));
                  break;
                case i3.months:
                  this.setViewDate(new Date(e5 - 1, t4, 1));
                  break;
                case i3.years:
                  this.setViewDate(new Date(e5 - 10, 0, 1));
              }
            }), I(this, "_finishHide", () => {
              this.hideAnimation = false, this._destroyComponents(), this.$container.removeChild(this.$datepicker);
            }), I(this, "setPosition", function(e5) {
              let t4 = arguments.length > 1 && void 0 !== arguments[1] && arguments[1];
              if ("function" == typeof (e5 = e5 || r4.opts.position)) return void (r4.customHide = e5({ $datepicker: r4.$datepicker, $target: r4.$el, $pointer: r4.$pointer, isViewChange: t4, done: r4._finishHide }));
              let i4, s4, { isMobile: a4 } = r4.opts, n5 = r4.$el.getBoundingClientRect(), o5 = r4.$el.getBoundingClientRect(), h4 = r4.$datepicker.offsetParent, l5 = r4.$el.offsetParent, d4 = r4.$datepicker.getBoundingClientRect(), c4 = e5.split(" "), u4 = window.scrollY, p4 = window.scrollX, m4 = r4.opts.offset, v4 = c4[0], g4 = c4[1];
              if (a4) r4.$datepicker.style.cssText = "left: 50%; top: 50%";
              else {
                if (h4 === l5 && h4 !== document.body && (o5 = { top: r4.$el.offsetTop, left: r4.$el.offsetLeft, width: n5.width, height: r4.$el.offsetHeight }, u4 = 0, p4 = 0), h4 !== l5 && h4 !== document.body) {
                  let e6 = h4.getBoundingClientRect();
                  o5 = { top: n5.top - e6.top, left: n5.left - e6.left, width: n5.width, height: n5.height }, u4 = 0, p4 = 0;
                }
                switch (v4) {
                  case "top":
                    i4 = o5.top - d4.height - m4;
                    break;
                  case "right":
                    s4 = o5.left + o5.width + m4;
                    break;
                  case "bottom":
                    i4 = o5.top + o5.height + m4;
                    break;
                  case "left":
                    s4 = o5.left - d4.width - m4;
                }
                switch (g4) {
                  case "top":
                    i4 = o5.top;
                    break;
                  case "right":
                    s4 = o5.left + o5.width - d4.width;
                    break;
                  case "bottom":
                    i4 = o5.top + o5.height - d4.height;
                    break;
                  case "left":
                    s4 = o5.left;
                    break;
                  case "center":
                    /left|right/.test(v4) ? i4 = o5.top + o5.height / 2 - d4.height / 2 : s4 = o5.left + o5.width / 2 - d4.width / 2;
                }
                r4.$datepicker.style.cssText = `left: ${s4 + p4}px; top: ${i4 + u4}px`;
              }
            }), I(this, "_setInputValue", () => {
              let { opts: e5, $altField: t4, locale: { dateFormat: i4 } } = this, { altFieldDateFormat: s4, altField: a4 } = e5;
              a4 && t4 && (t4.value = this._getInputValue(s4)), this.$el.value = this._getInputValue(i4);
            }), I(this, "_getInputValue", (e5) => {
              let { selectedDates: t4, opts: i4 } = this, { multipleDates: s4, multipleDatesSeparator: a4 } = i4;
              if (!t4.length) return "";
              let n5 = "function" == typeof e5, r5 = n5 ? e5(s4 ? t4 : t4[0]) : t4.map((t5) => this.formatDate(t5, e5));
              return r5 = n5 ? r5 : r5.join(a4), r5;
            }), I(this, "_checkIfDateIsSelected", function(e5) {
              let t4 = arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : i3.days, s4 = false;
              return r4.selectedDates.some((i4) => {
                let a4 = p3(e5, i4, t4);
                return s4 = a4 && i4, a4;
              }), s4;
            }), I(this, "_scheduleCallAfterTransition", (e5) => {
              this._cancelScheduledCall(), e5 && e5(false), this._onTransitionEnd = () => {
                e5 && e5(true);
              }, this.$datepicker.addEventListener("transitionend", this._onTransitionEnd, { once: true });
            }), I(this, "_cancelScheduledCall", () => {
              this.$datepicker.removeEventListener("transitionend", this._onTransitionEnd);
            }), I(this, "setViewDate", (e5) => {
              if (!((e5 = b3(e5)) instanceof Date)) return;
              if (p3(e5, this.viewDate)) return;
              let t4 = this.viewDate;
              this.viewDate = e5;
              let { onChangeViewDate: s4 } = this.opts;
              if (s4) {
                let { month: e6, year: t5 } = this.parsedViewDate;
                s4({ month: e6, year: t5, decade: this.curDecade });
              }
              this.trigger(i3.eventChangeViewDate, e5, t4);
            }), I(this, "setFocusDate", function(e5) {
              let t4 = arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : {};
              (!e5 || (e5 = b3(e5)) instanceof Date) && (r4.focusDate = e5, r4.trigger(i3.eventChangeFocusDate, e5, t4));
            }), I(this, "setCurrentView", function(e5) {
              let t4 = arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : {};
              if (r4.viewIndexes.includes(e5)) {
                if (r4.currentView = e5, r4.elIsInput && r4.visible && r4.setPosition(void 0, true), r4.trigger(i3.eventChangeCurrentView, e5), !r4.views[e5]) {
                  let t5 = r4.views[e5] = new T3({ dp: r4, opts: r4.opts, type: e5 });
                  r4.shouldUpdateDOM && r4.$content.appendChild(t5.$el);
                }
                r4.opts.onChangeView && !t4.silent && r4.opts.onChangeView(e5);
              }
            }), I(this, "_updateLastSelectedDate", (e5) => {
              this.lastSelectedDate = e5, this.trigger(i3.eventChangeLastSelectedDate, e5);
            }), I(this, "destroy", () => {
              if (this.isDestroyed) return;
              let { showEvent: e5, isMobile: t4 } = this.opts, i4 = this.$datepicker.parentNode;
              i4 && i4.removeChild(this.$datepicker), this.$el.removeEventListener(e5, this._onFocus), this.$el.removeEventListener("blur", this._onBlur), window.removeEventListener("resize", this._onResize), t4 && this._removeMobileAttributes(), this.keyboardNav && this.keyboardNav.destroy(), this.views = null, this.nav = null, this.$datepicker = null, this.opts = {}, this.$customContainer = null, this.viewDate = null, this.focusDate = null, this.selectedDates = [], this.rangeDateFrom = null, this.rangeDateTo = null, this.isDestroyed = true;
            }), I(this, "update", function() {
              let e5 = arguments.length > 0 && void 0 !== arguments[0] ? arguments[0] : {}, t4 = arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : {}, s4 = w3({}, r4.opts), { silent: a4 } = t4;
              w3(r4.opts, e5);
              let { timepicker: n5, buttons: o5, range: h4, selectedDates: l5, isMobile: d4 } = r4.opts, c4 = r4.visible || r4.treatAsInline;
              r4._createMinMaxDates(), r4._limitViewDateByMaxMinDates(), r4._handleLocale(), l5 && (r4.selectedDates = [], r4.selectDate(l5, { silent: a4 })), e5.view && r4.setCurrentView(e5.view, { silent: a4 }), r4._setInputValue(), s4.range && !h4 ? (r4.rangeDateTo = false, r4.rangeDateFrom = false) : !s4.range && h4 && r4.selectedDates.length && (r4.rangeDateFrom = r4.selectedDates[0], r4.rangeDateTo = r4.selectedDates[1]), s4.timepicker && !n5 ? (c4 && r4.timepicker.destroy(), r4.timepicker = false, r4.$timepicker.parentNode.removeChild(r4.$timepicker)) : !s4.timepicker && n5 && r4._addTimepicker(), !s4.buttons && o5 ? r4._addButtons() : s4.buttons && !o5 ? (r4.buttons.destroy(), r4.$buttons.parentNode.removeChild(r4.$buttons)) : c4 && s4.buttons && o5 && r4.buttons.clearHtml().render(), !s4.isMobile && d4 ? (r4.treatAsInline || j || r4._createMobileOverlay(), r4._addMobileAttributes(), r4.visible && r4._showMobileOverlay()) : s4.isMobile && !d4 && (r4._removeMobileAttributes(), r4.visible && (j.classList.remove("-active-"), "function" != typeof r4.opts.position && r4.setPosition())), c4 && (r4.nav.update(), r4.views[r4.currentView].render(), r4.currentView === i3.days && r4.views[r4.currentView].renderDayNames());
            }), I(this, "disableDate", (e5, t4) => {
              (Array.isArray(e5) ? e5 : [e5]).forEach((e6) => {
                let i4 = b3(e6);
                if (!i4) return;
                let s4 = t4 ? "delete" : "add";
                this.disabledDates[s4](this.formatDate(i4, "yyyy-MM-dd"));
                let a4 = this.getCell(i4, this.currentViewSingular);
                a4 && a4.adpCell.render();
              }, []);
            }), I(this, "enableDate", (e5) => {
              this.disableDate(e5, true);
            }), I(this, "isDateDisabled", (e5) => {
              let t4 = b3(e5);
              return this.disabledDates.has(this.formatDate(t4, "yyyy-MM-dd"));
            }), I(this, "isOtherMonth", (e5) => {
              let { month: t4 } = h3(e5);
              return t4 !== this.parsedViewDate.month;
            }), I(this, "isOtherYear", (e5) => {
              let { year: t4 } = h3(e5);
              return t4 !== this.parsedViewDate.year;
            }), I(this, "isOtherDecade", (e5) => {
              let { year: t4 } = h3(e5), [i4, s4] = c3(this.viewDate);
              return t4 < i4 || t4 > s4;
            }), I(this, "_onChangeSelectedDate", (e5) => {
              let { silent: t4 } = e5;
              setTimeout(() => {
                this._setInputValue(), this.opts.onSelect && !t4 && this._triggerOnSelect();
              });
            }), I(this, "_onChangeFocusedDate", function(e5) {
              let { viewDateTransition: t4 } = arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : {};
              if (!e5) return;
              let i4 = false;
              t4 && (i4 = r4.isOtherMonth(e5) || r4.isOtherYear(e5) || r4.isOtherDecade(e5)), i4 && r4.setViewDate(e5), r4.opts.onFocus && r4.opts.onFocus({ datepicker: r4, date: e5 });
            }), I(this, "_onChangeTime", (e5) => {
              let { hours: t4, minutes: i4 } = e5, s4 = /* @__PURE__ */ new Date(), { lastSelectedDate: a4, opts: { onSelect: n5 } } = this, r5 = a4;
              a4 || (r5 = s4);
              let o5 = this.getCell(r5, this.currentViewSingular), h4 = o5 && o5.adpCell;
              h4 && h4.isDisabled || (r5.setHours(t4), r5.setMinutes(i4), a4 ? (this._setInputValue(), n5 && this._triggerOnSelect()) : this.selectDate(r5));
            }), I(this, "_onFocus", (e5) => {
              this.visible || this.show();
            }), I(this, "_onBlur", (e5) => {
              this.inFocus || !this.visible || this.opts.isMobile || this.hide();
            }), I(this, "_onMouseDown", (e5) => {
              this.inFocus = true;
            }), I(this, "_onMouseUp", (e5) => {
              this.inFocus = false, this.$el.focus();
            }), I(this, "_onResize", () => {
              this.visible && "function" != typeof this.opts.position && this.setPosition();
            }), I(this, "_onClickOverlay", () => {
              this.visible && this.hide();
            }), I(this, "getViewDates", function() {
              let e5 = arguments.length > 0 && void 0 !== arguments[0] ? arguments[0] : i3.days;
              return T3.getDatesFunction(e5)(r4);
            }), I(this, "isWeekend", (e5) => this.opts.weekends.includes(e5)), I(this, "getClampedDate", (e5) => {
              let { minDate: t4, maxDate: i4 } = this, s4 = e5;
              return i4 && m3(e5, i4) ? s4 = i4 : t4 && v3(e5, t4) && (s4 = t4), s4;
            }), this.$el = a3(e4), !this.$el) return;
            this.$datepicker = n4({ className: "air-datepicker" }), this.opts = w3({}, s3, t3), this.$customContainer = !!this.opts.container && a3(this.opts.container), this.$altField = a3(this.opts.altField || false);
            let { view: o4, startDate: l4 } = this.opts;
            l4 || (this.opts.startDate = /* @__PURE__ */ new Date()), "INPUT" === this.$el.nodeName && (this.elIsInput = true), this.inited = false, this.visible = false, this.viewDate = b3(this.opts.startDate), this.focusDate = false, this.initialReadonly = this.$el.getAttribute("readonly"), this.customHide = false, this.currentView = o4, this.selectedDates = [], this.disabledDates = /* @__PURE__ */ new Set(), this.isDestroyed = false, this.views = {}, this.keys = [], this.rangeDateFrom = "", this.rangeDateTo = "", this.timepickerIsActive = false, this.treatAsInline = this.opts.inline || !this.elIsInput, this.init();
          }
          init() {
            let { opts: e4, treatAsInline: t3, opts: { inline: i4, isMobile: s4, selectedDates: n5, keyboardNav: r4, onlyTimepicker: o4 } } = this, h4 = a3("body");
            (!B || B && P3 && !h4.contains(P3)) && !i4 && this.elIsInput && !this.$customContainer && R2.buildGlobalContainer(R2.defaultGlobalContainerId), !s4 || j || t3 || this._createMobileOverlay(), this._handleLocale(), this._bindSubEvents(), this._createMinMaxDates(), this._limitViewDateByMaxMinDates(), this.elIsInput && (i4 || this._bindEvents(), r4 && !o4 && (this.keyboardNav = new A4({ dp: this, opts: e4 }))), n5 && this.selectDate(n5, { silent: true }), this.opts.visible && !t3 && this.show(), s4 && !t3 && this.$el.setAttribute("readonly", true), t3 && this._createComponents();
          }
          _createMobileOverlay() {
            j = n4({ className: "air-datepicker-overlay" }), P3.appendChild(j);
          }
          _createComponents() {
            let { opts: e4, treatAsInline: t3, opts: { inline: i4, buttons: s4, timepicker: a4, position: n5, classes: r4, onlyTimepicker: o4, isMobile: h4 } } = this;
            this._buildBaseHtml(), this.elIsInput && (i4 || this._setPositionClasses(n5)), !i4 && this.elIsInput || this.$datepicker.classList.add("-inline-"), r4 && this.$datepicker.classList.add(...r4.split(" ")), o4 && this.$datepicker.classList.add("-only-timepicker-"), h4 && !t3 && this._addMobileAttributes(), this.views[this.currentView] = new T3({ dp: this, type: this.currentView, opts: e4 }), this.nav = new V2({ dp: this, opts: e4 }), a4 && this._addTimepicker(), s4 && this._addButtons(), this.$content.appendChild(this.views[this.currentView].$el), this.$nav.appendChild(this.nav.$el);
          }
          _destroyComponents() {
            for (let e4 in this.views) this.views[e4].destroy();
            this.views = {}, this.nav.destroy(), this.timepicker && this.timepicker.destroy();
          }
          _addMobileAttributes() {
            j.addEventListener("click", this._onClickOverlay), this.$datepicker.classList.add("-is-mobile-"), this.$el.setAttribute("readonly", true);
          }
          _removeMobileAttributes() {
            j.removeEventListener("click", this._onClickOverlay), this.$datepicker.classList.remove("-is-mobile-"), this.initialReadonly || "" === this.initialReadonly || this.$el.removeAttribute("readonly");
          }
          _createMinMaxDates() {
            let { minDate: e4, maxDate: t3 } = this.opts;
            this.minDate = !!e4 && b3(e4), this.maxDate = !!t3 && b3(t3);
          }
          _addTimepicker() {
            this.$timepicker = n4({ className: "air-datepicker--time" }), this.$datepicker.appendChild(this.$timepicker), this.timepicker = new L3({ dp: this, opts: this.opts }), this.$timepicker.appendChild(this.timepicker.$el);
          }
          _addButtons() {
            this.$buttons = n4({ className: "air-datepicker--buttons" }), this.$datepicker.appendChild(this.$buttons), this.buttons = new H2({ dp: this, opts: this.opts }), this.$buttons.appendChild(this.buttons.$el);
          }
          _bindSubEvents() {
            this.on(i3.eventChangeSelectedDate, this._onChangeSelectedDate), this.on(i3.eventChangeFocusDate, this._onChangeFocusedDate), this.on(i3.eventChangeTime, this._onChangeTime);
          }
          _buildBaseHtml() {
            let { inline: e4 } = this.opts;
            var t3, i4;
            this.elIsInput ? e4 ? (t3 = this.$datepicker, (i4 = this.$el).parentNode.insertBefore(t3, i4.nextSibling)) : this.$container.appendChild(this.$datepicker) : this.$el.appendChild(this.$datepicker), this.$datepicker.innerHTML = '<i class="air-datepicker--pointer"></i><div class="air-datepicker--navigation"></div><div class="air-datepicker--content"></div>', this.$content = a3(".air-datepicker--content", this.$datepicker), this.$pointer = a3(".air-datepicker--pointer", this.$datepicker), this.$nav = a3(".air-datepicker--navigation", this.$datepicker);
          }
          _handleLocale() {
            let { locale: e4, dateFormat: t3, firstDay: i4, timepicker: s4, onlyTimepicker: a4, timeFormat: n5, dateTimeSeparator: r4 } = this.opts;
            var o4;
            this.locale = (o4 = e4, JSON.parse(JSON.stringify(o4))), t3 && (this.locale.dateFormat = t3), void 0 !== n5 && "" !== n5 && (this.locale.timeFormat = n5);
            let { timeFormat: h4 } = this.locale;
            if ("" !== i4 && (this.locale.firstDay = i4), s4 && "function" != typeof t3) {
              let e5 = h4 ? r4 : "";
              this.locale.dateFormat = [this.locale.dateFormat, h4 || ""].join(e5);
            }
            a4 && "function" != typeof t3 && (this.locale.dateFormat = this.locale.timeFormat);
          }
          _setPositionClasses(e4) {
            if ("function" == typeof e4) return void this.$datepicker.classList.add("-custom-position-");
            let t3 = (e4 = e4.split(" "))[0], i4 = `air-datepicker -${t3}-${e4[1]}- -from-${t3}-`;
            this.$datepicker.classList.add(...i4.split(" "));
          }
          _bindEvents() {
            this.$el.addEventListener(this.opts.showEvent, this._onFocus), this.$el.addEventListener("blur", this._onBlur), this.$datepicker.addEventListener("mousedown", this._onMouseDown), this.$datepicker.addEventListener("mouseup", this._onMouseUp), window.addEventListener("resize", this._onResize);
          }
          _limitViewDateByMaxMinDates() {
            let { viewDate: e4, minDate: t3, maxDate: i4 } = this;
            i4 && m3(e4, i4) && this.setViewDate(i4), t3 && v3(e4, t3) && this.setViewDate(t3);
          }
          formatDate() {
            let e4 = arguments.length > 0 && void 0 !== arguments[0] ? arguments[0] : this.viewDate, t3 = arguments.length > 1 ? arguments[1] : void 0;
            if (e4 = b3(e4), !(e4 instanceof Date)) return;
            let i4 = t3, s4 = this.locale, a4 = h3(e4), n5 = a4.dayPeriod, r4 = c3(e4), o4 = R2.replacer, l4 = { T: e4.getTime(), m: a4.minutes, mm: a4.fullMinutes, h: a4.hours12, hh: a4.fullHours12, H: a4.hours, HH: a4.fullHours, aa: n5, AA: n5.toUpperCase(), E: s4.daysShort[a4.day], EEEE: s4.days[a4.day], d: a4.date, dd: a4.fullDate, M: a4.month + 1, MM: a4.fullMonth, MMM: s4.monthsShort[a4.month], MMMM: s4.months[a4.month], yy: a4.year.toString().slice(-2), yyyy: a4.year, yyyy1: r4[0], yyyy2: r4[1] };
            for (let [e5, t4] of Object.entries(l4)) i4 = o4(i4, k2(e5), t4);
            return i4;
          }
          down(e4) {
            this._handleUpDownActions(e4, "down");
          }
          up(e4) {
            this._handleUpDownActions(e4, "up");
          }
          selectDate(e4) {
            let t3, s4 = arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : {}, { currentView: a4, parsedViewDate: n5, selectedDates: r4 } = this, { updateTime: o4 } = s4, { moveToOtherMonthsOnSelect: h4, moveToOtherYearsOnSelect: l4, multipleDates: d4, range: c4, autoClose: u4, onBeforeSelect: p4 } = this.opts, v4 = r4.length;
            if (Array.isArray(e4)) return e4.forEach((e5) => {
              this.selectDate(e5, s4);
            }), new Promise((e5) => {
              setTimeout(e5);
            });
            if ((e4 = b3(e4)) instanceof Date) {
              if (p4 && !p4({ date: e4, datepicker: this })) return Promise.resolve();
              if (a4 === i3.days && e4.getMonth() !== n5.month && h4 && (t3 = new Date(e4.getFullYear(), e4.getMonth(), 1)), a4 === i3.years && e4.getFullYear() !== n5.year && l4 && (t3 = new Date(e4.getFullYear(), 0, 1)), t3 && this.setViewDate(t3), d4 && !c4) {
                if (v4 === d4) return;
                this._checkIfDateIsSelected(e4) || r4.push(e4);
              } else if (c4) switch (v4) {
                case 1:
                  r4.push(e4), this.rangeDateTo || (this.rangeDateTo = e4), m3(this.rangeDateFrom, this.rangeDateTo) && (this.rangeDateTo = this.rangeDateFrom, this.rangeDateFrom = e4), this.selectedDates = [this.rangeDateFrom, this.rangeDateTo];
                  break;
                case 2:
                  this.selectedDates = [e4], this.rangeDateFrom = e4, this.rangeDateTo = "";
                  break;
                default:
                  this.selectedDates = [e4], this.rangeDateFrom = e4;
              }
              else this.selectedDates = [e4];
              return this.trigger(i3.eventChangeSelectedDate, { action: i3.actionSelectDate, silent: null == s4 ? void 0 : s4.silent, date: e4, updateTime: o4 }), this._updateLastSelectedDate(e4), u4 && !this.timepickerIsActive && this.visible && (d4 || c4 ? c4 && 1 === v4 && this.hide() : this.hide()), new Promise((e5) => {
                setTimeout(e5);
              });
            }
          }
          unselectDate(e4) {
            let t3 = this.selectedDates, s4 = this;
            if ((e4 = b3(e4)) instanceof Date) return t3.some((a4, n5) => {
              if (p3(a4, e4)) return t3.splice(n5, 1), s4.selectedDates.length ? (s4.rangeDateTo = "", s4.rangeDateFrom = t3[0], s4._updateLastSelectedDate(s4.selectedDates[s4.selectedDates.length - 1])) : (s4.rangeDateFrom = "", s4.rangeDateTo = "", s4._updateLastSelectedDate(false)), this.trigger(i3.eventChangeSelectedDate, { action: i3.actionUnselectDate, date: e4 }), true;
            });
          }
          replaceDate(e4, t3) {
            let s4 = this.selectedDates.find((t4) => p3(t4, e4, this.currentView)), a4 = this.selectedDates.indexOf(s4);
            a4 < 0 || p3(this.selectedDates[a4], t3, this.currentView) || (this.selectedDates[a4] = t3, this.trigger(i3.eventChangeSelectedDate, { action: i3.actionSelectDate, date: t3, updateTime: true }), this._updateLastSelectedDate(t3));
          }
          clear() {
            let e4 = arguments.length > 0 && void 0 !== arguments[0] ? arguments[0] : {};
            return this.selectedDates = [], this.rangeDateFrom = false, this.rangeDateTo = false, this.lastSelectedDate = false, this.trigger(i3.eventChangeSelectedDate, { action: i3.actionUnselectDate, silent: e4.silent }), new Promise((e5) => {
              setTimeout(e5);
            });
          }
          show() {
            let { onShow: e4, isMobile: t3 } = this.opts;
            this._cancelScheduledCall(), this.visible || this.hideAnimation || this._createComponents(), this.setPosition(this.opts.position), this.$datepicker.classList.add("-active-"), this.visible = true, e4 && this._scheduleCallAfterTransition(e4), t3 && this._showMobileOverlay();
          }
          hide() {
            let { onHide: e4, isMobile: t3 } = this.opts, i4 = this._hasTransition();
            this.visible = false, this.hideAnimation = true, this.$datepicker.classList.remove("-active-"), this.customHide && this.customHide(), this.elIsInput && this.$el.blur(), this._scheduleCallAfterTransition((t4) => {
              !this.customHide && (t4 && i4 || !t4 && !i4) && this._finishHide(), e4 && e4(t4);
            }), t3 && j.classList.remove("-active-");
          }
          _triggerOnSelect() {
            let e4 = [], t3 = [], { selectedDates: i4, locale: s4, opts: { onSelect: a4, multipleDates: n5, range: r4 } } = this, o4 = n5 || r4, h4 = "function" == typeof s4.dateFormat;
            i4.length && (e4 = i4.map(g3), t3 = h4 ? n5 ? s4.dateFormat(e4) : e4.map((e5) => s4.dateFormat(e5)) : e4.map((e5) => this.formatDate(e5, s4.dateFormat))), a4({ date: o4 ? e4 : e4[0], formattedDate: o4 ? t3 : t3[0], datepicker: this });
          }
          _handleAlreadySelectedDates(e4, t3) {
            let { selectedDates: i4, rangeDateFrom: s4, rangeDateTo: a4 } = this, { range: n5, toggleSelected: r4 } = this.opts, o4 = i4.length, h4 = "function" == typeof r4 ? r4({ datepicker: this, date: t3 }) : r4, l4 = Boolean(n5 && 1 === o4 && e4), d4 = l4 ? g3(t3) : t3;
            n5 && !h4 && (2 !== o4 && this.selectDate(d4), 2 === o4 && p3(s4, a4)) || (h4 ? this.unselectDate(d4) : this._updateLastSelectedDate(l4 ? d4 : e4));
          }
          _handleUpDownActions(e4, t3) {
            if (!((e4 = b3(e4 || this.focusDate || this.viewDate)) instanceof Date)) return;
            let i4 = "up" === t3 ? this.viewIndex + 1 : this.viewIndex - 1;
            i4 > 2 && (i4 = 2), i4 < 0 && (i4 = 0), this.setViewDate(new Date(e4.getFullYear(), e4.getMonth(), 1)), this.setCurrentView(this.viewIndexes[i4]);
          }
          getCell(e4) {
            let t3 = arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : i3.day;
            if (!((e4 = b3(e4)) instanceof Date)) return;
            let { year: s4, month: a4, date: n5 } = h3(e4), r4 = `[data-year="${s4}"]`, o4 = `[data-month="${a4}"]`, l4 = { [i3.day]: `${r4}${o4}[data-date="${n5}"]`, [i3.month]: `${r4}${o4}`, [i3.year]: `${r4}` };
            return this.views[this.currentView] ? this.views[this.currentView].$el.querySelector(l4[t3]) : void 0;
          }
          _showMobileOverlay() {
            j.classList.add("-active-");
          }
          _hasTransition() {
            return window.getComputedStyle(this.$datepicker).getPropertyValue("transition-duration").split(", ").reduce((e4, t3) => parseFloat(t3) + e4, 0) > 0;
          }
          get shouldUpdateDOM() {
            return this.visible || this.treatAsInline;
          }
          get parsedViewDate() {
            return h3(this.viewDate);
          }
          get currentViewSingular() {
            return this.currentView.slice(0, -1);
          }
          get curDecade() {
            return c3(this.viewDate);
          }
          get viewIndex() {
            return this.viewIndexes.indexOf(this.currentView);
          }
          get isFinalView() {
            return this.currentView === i3.years;
          }
          get hasSelectedDates() {
            return this.selectedDates.length > 0;
          }
          get isMinViewReached() {
            return this.currentView === this.opts.minView || this.currentView === i3.days;
          }
          get $container() {
            return this.$customContainer || P3;
          }
          static replacer(e4, t3, i4) {
            return e4.replace(t3, function(e5, t4, s4, a4) {
              return t4 + i4 + a4;
            });
          }
        }
        var K;
        return I(R2, "defaults", s3), I(R2, "version", "3.5.3"), I(R2, "defaultGlobalContainerId", "air-datepicker-global-container"), K = R2.prototype, Object.assign(K, N), t2.default;
      }();
    });
  }
});

// node_modules/air-datepicker/locale/en.js
var require_en = __commonJS({
  "node_modules/air-datepicker/locale/en.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    var _default = {
      days: ["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"],
      daysShort: ["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"],
      daysMin: ["Su", "Mo", "Tu", "We", "Th", "Fr", "Sa"],
      months: ["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"],
      monthsShort: ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"],
      today: "Today",
      clear: "Clear",
      dateFormat: "MM/dd/yyyy",
      timeFormat: "hh:mm aa",
      firstDay: 0
    };
    exports.default = _default;
  }
});

// node_modules/air-datepicker/locale/fr.js
var require_fr = __commonJS({
  "node_modules/air-datepicker/locale/fr.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    var _default = {
      days: ["Dimanche", "Lundi", "Mardi", "Mercredi", "Jeudi", "Vendredi", "Samedi"],
      daysShort: ["Dim", "Lun", "Mar", "Mer", "Jeu", "Ven", "Sam"],
      daysMin: ["Di", "Lu", "Ma", "Me", "Je", "Ve", "Sa"],
      months: ["Janvier", "F\xE9vrier", "Mars", "Avril", "Mai", "Juin", "Juillet", "Ao\xFBt", "Septembre", "Octobre", "Novembre", "D\xE9cembre"],
      monthsShort: ["Jan", "F\xE9v", "Mars", "Avr", "Mai", "Juin", "Juil", "Ao\xFBt", "Sep", "Oct", "Nov", "Dec"],
      today: "Aujourd'hui",
      clear: "Effacer",
      dateFormat: "dd/MM/yyyy",
      timeFormat: "HH:mm",
      firstDay: 1
    };
    exports.default = _default;
  }
});

// node_modules/air-datepicker/locale/de.js
var require_de = __commonJS({
  "node_modules/air-datepicker/locale/de.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    var _default = {
      days: ["Sonntag", "Montag", "Dienstag", "Mittwoch", "Donnerstag", "Freitag", "Samstag"],
      daysShort: ["Son", "Mon", "Die", "Mit", "Don", "Fre", "Sam"],
      daysMin: ["So", "Mo", "Di", "Mi", "Do", "Fr", "Sa"],
      months: ["Januar", "Februar", "M\xE4rz", "April", "Mai", "Juni", "Juli", "August", "September", "Oktober", "November", "Dezember"],
      monthsShort: ["Jan", "Feb", "M\xE4r", "Apr", "Mai", "Jun", "Jul", "Aug", "Sep", "Okt", "Nov", "Dez"],
      today: "Heute",
      clear: "L\xF6schen",
      dateFormat: "dd.MM.yyyy",
      timeFormat: "HH:mm",
      firstDay: 1
    };
    exports.default = _default;
  }
});

// node_modules/air-datepicker/locale/es.js
var require_es = __commonJS({
  "node_modules/air-datepicker/locale/es.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    var _default = {
      days: ["Domingo", "Lunes", "Martes", "Mi\xE9rcoles", "Jueves", "Viernes", "S\xE1bado"],
      daysShort: ["Dom", "Lun", "Mar", "Mie", "Jue", "Vie", "Sab"],
      daysMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
      months: ["Enero", "Febrero", "Marzo", "Abril", "Mayo", "Junio", "Julio", "Agosto", "Septiembre", "Octubre", "Noviembre", "Diciembre"],
      monthsShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
      today: "Hoy",
      clear: "Limpiar",
      dateFormat: "dd/MM/yyyy",
      timeFormat: "hh:mm aa",
      firstDay: 1
    };
    exports.default = _default;
  }
});

// node_modules/air-datepicker/locale/it.js
var require_it = __commonJS({
  "node_modules/air-datepicker/locale/it.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    var _default = {
      days: ["Domenica", "Luned\xEC", "Marted\xEC", "Mercoled\xEC", "Gioved\xEC", "Venerd\xEC", "Sabato"],
      daysShort: ["Dom", "Lun", "Mar", "Mer", "Gio", "Ven", "Sab"],
      daysMin: ["Do", "Lu", "Ma", "Me", "Gi", "Ve", "Sa"],
      months: ["Gennaio", "Febbraio", "Marzo", "Aprile", "Maggio", "Giugno", "Luglio", "Agosto", "Settembre", "Ottobre", "Novembre", "Dicembre"],
      monthsShort: ["Gen", "Feb", "Mar", "Apr", "Mag", "Giu", "Lug", "Ago", "Set", "Ott", "Nov", "Dic"],
      today: "Oggi",
      clear: "Cancella",
      dateFormat: "dd/MM/yyyy",
      timeFormat: "HH:mm",
      firstDay: 1
    };
    exports.default = _default;
  }
});

// node_modules/air-datepicker/locale/pt.js
var require_pt = __commonJS({
  "node_modules/air-datepicker/locale/pt.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    var _default = {
      days: ["Domingo", "Segunda", "Ter\xE7a", "Quarta", "Quinta", "Sexta", "S\xE1bado"],
      daysShort: ["Dom", "Seg", "Ter", "Qua", "Qui", "Sex", "Sab"],
      daysMin: ["Do", "Se", "Te", "Qa", "Qi", "Sx", "Sa"],
      months: ["Janeiro", "Fevereiro", "Mar\xE7o", "Abril", "Maio", "Junho", "Julho", "Agosto", "Setembro", "Outubro", "Novembro", "Dezembro"],
      monthsShort: ["Jan", "Fev", "Mar", "Abr", "Mai", "Jun", "Jul", "Ago", "Set", "Out", "Nov", "Dez"],
      today: "Hoje",
      clear: "Limpar",
      dateFormat: "dd/MM/yyyy",
      timeFormat: "HH:mm",
      firstDay: 1
    };
    exports.default = _default;
  }
});

// node_modules/entities/lib/maps/entities.json
var require_entities = __commonJS({
  "node_modules/entities/lib/maps/entities.json"(exports, module) {
    module.exports = { Aacute: "\xC1", aacute: "\xE1", Abreve: "\u0102", abreve: "\u0103", ac: "\u223E", acd: "\u223F", acE: "\u223E\u0333", Acirc: "\xC2", acirc: "\xE2", acute: "\xB4", Acy: "\u0410", acy: "\u0430", AElig: "\xC6", aelig: "\xE6", af: "\u2061", Afr: "\u{1D504}", afr: "\u{1D51E}", Agrave: "\xC0", agrave: "\xE0", alefsym: "\u2135", aleph: "\u2135", Alpha: "\u0391", alpha: "\u03B1", Amacr: "\u0100", amacr: "\u0101", amalg: "\u2A3F", amp: "&", AMP: "&", andand: "\u2A55", And: "\u2A53", and: "\u2227", andd: "\u2A5C", andslope: "\u2A58", andv: "\u2A5A", ang: "\u2220", ange: "\u29A4", angle: "\u2220", angmsdaa: "\u29A8", angmsdab: "\u29A9", angmsdac: "\u29AA", angmsdad: "\u29AB", angmsdae: "\u29AC", angmsdaf: "\u29AD", angmsdag: "\u29AE", angmsdah: "\u29AF", angmsd: "\u2221", angrt: "\u221F", angrtvb: "\u22BE", angrtvbd: "\u299D", angsph: "\u2222", angst: "\xC5", angzarr: "\u237C", Aogon: "\u0104", aogon: "\u0105", Aopf: "\u{1D538}", aopf: "\u{1D552}", apacir: "\u2A6F", ap: "\u2248", apE: "\u2A70", ape: "\u224A", apid: "\u224B", apos: "'", ApplyFunction: "\u2061", approx: "\u2248", approxeq: "\u224A", Aring: "\xC5", aring: "\xE5", Ascr: "\u{1D49C}", ascr: "\u{1D4B6}", Assign: "\u2254", ast: "*", asymp: "\u2248", asympeq: "\u224D", Atilde: "\xC3", atilde: "\xE3", Auml: "\xC4", auml: "\xE4", awconint: "\u2233", awint: "\u2A11", backcong: "\u224C", backepsilon: "\u03F6", backprime: "\u2035", backsim: "\u223D", backsimeq: "\u22CD", Backslash: "\u2216", Barv: "\u2AE7", barvee: "\u22BD", barwed: "\u2305", Barwed: "\u2306", barwedge: "\u2305", bbrk: "\u23B5", bbrktbrk: "\u23B6", bcong: "\u224C", Bcy: "\u0411", bcy: "\u0431", bdquo: "\u201E", becaus: "\u2235", because: "\u2235", Because: "\u2235", bemptyv: "\u29B0", bepsi: "\u03F6", bernou: "\u212C", Bernoullis: "\u212C", Beta: "\u0392", beta: "\u03B2", beth: "\u2136", between: "\u226C", Bfr: "\u{1D505}", bfr: "\u{1D51F}", bigcap: "\u22C2", bigcirc: "\u25EF", bigcup: "\u22C3", bigodot: "\u2A00", bigoplus: "\u2A01", bigotimes: "\u2A02", bigsqcup: "\u2A06", bigstar: "\u2605", bigtriangledown: "\u25BD", bigtriangleup: "\u25B3", biguplus: "\u2A04", bigvee: "\u22C1", bigwedge: "\u22C0", bkarow: "\u290D", blacklozenge: "\u29EB", blacksquare: "\u25AA", blacktriangle: "\u25B4", blacktriangledown: "\u25BE", blacktriangleleft: "\u25C2", blacktriangleright: "\u25B8", blank: "\u2423", blk12: "\u2592", blk14: "\u2591", blk34: "\u2593", block: "\u2588", bne: "=\u20E5", bnequiv: "\u2261\u20E5", bNot: "\u2AED", bnot: "\u2310", Bopf: "\u{1D539}", bopf: "\u{1D553}", bot: "\u22A5", bottom: "\u22A5", bowtie: "\u22C8", boxbox: "\u29C9", boxdl: "\u2510", boxdL: "\u2555", boxDl: "\u2556", boxDL: "\u2557", boxdr: "\u250C", boxdR: "\u2552", boxDr: "\u2553", boxDR: "\u2554", boxh: "\u2500", boxH: "\u2550", boxhd: "\u252C", boxHd: "\u2564", boxhD: "\u2565", boxHD: "\u2566", boxhu: "\u2534", boxHu: "\u2567", boxhU: "\u2568", boxHU: "\u2569", boxminus: "\u229F", boxplus: "\u229E", boxtimes: "\u22A0", boxul: "\u2518", boxuL: "\u255B", boxUl: "\u255C", boxUL: "\u255D", boxur: "\u2514", boxuR: "\u2558", boxUr: "\u2559", boxUR: "\u255A", boxv: "\u2502", boxV: "\u2551", boxvh: "\u253C", boxvH: "\u256A", boxVh: "\u256B", boxVH: "\u256C", boxvl: "\u2524", boxvL: "\u2561", boxVl: "\u2562", boxVL: "\u2563", boxvr: "\u251C", boxvR: "\u255E", boxVr: "\u255F", boxVR: "\u2560", bprime: "\u2035", breve: "\u02D8", Breve: "\u02D8", brvbar: "\xA6", bscr: "\u{1D4B7}", Bscr: "\u212C", bsemi: "\u204F", bsim: "\u223D", bsime: "\u22CD", bsolb: "\u29C5", bsol: "\\", bsolhsub: "\u27C8", bull: "\u2022", bullet: "\u2022", bump: "\u224E", bumpE: "\u2AAE", bumpe: "\u224F", Bumpeq: "\u224E", bumpeq: "\u224F", Cacute: "\u0106", cacute: "\u0107", capand: "\u2A44", capbrcup: "\u2A49", capcap: "\u2A4B", cap: "\u2229", Cap: "\u22D2", capcup: "\u2A47", capdot: "\u2A40", CapitalDifferentialD: "\u2145", caps: "\u2229\uFE00", caret: "\u2041", caron: "\u02C7", Cayleys: "\u212D", ccaps: "\u2A4D", Ccaron: "\u010C", ccaron: "\u010D", Ccedil: "\xC7", ccedil: "\xE7", Ccirc: "\u0108", ccirc: "\u0109", Cconint: "\u2230", ccups: "\u2A4C", ccupssm: "\u2A50", Cdot: "\u010A", cdot: "\u010B", cedil: "\xB8", Cedilla: "\xB8", cemptyv: "\u29B2", cent: "\xA2", centerdot: "\xB7", CenterDot: "\xB7", cfr: "\u{1D520}", Cfr: "\u212D", CHcy: "\u0427", chcy: "\u0447", check: "\u2713", checkmark: "\u2713", Chi: "\u03A7", chi: "\u03C7", circ: "\u02C6", circeq: "\u2257", circlearrowleft: "\u21BA", circlearrowright: "\u21BB", circledast: "\u229B", circledcirc: "\u229A", circleddash: "\u229D", CircleDot: "\u2299", circledR: "\xAE", circledS: "\u24C8", CircleMinus: "\u2296", CirclePlus: "\u2295", CircleTimes: "\u2297", cir: "\u25CB", cirE: "\u29C3", cire: "\u2257", cirfnint: "\u2A10", cirmid: "\u2AEF", cirscir: "\u29C2", ClockwiseContourIntegral: "\u2232", CloseCurlyDoubleQuote: "\u201D", CloseCurlyQuote: "\u2019", clubs: "\u2663", clubsuit: "\u2663", colon: ":", Colon: "\u2237", Colone: "\u2A74", colone: "\u2254", coloneq: "\u2254", comma: ",", commat: "@", comp: "\u2201", compfn: "\u2218", complement: "\u2201", complexes: "\u2102", cong: "\u2245", congdot: "\u2A6D", Congruent: "\u2261", conint: "\u222E", Conint: "\u222F", ContourIntegral: "\u222E", copf: "\u{1D554}", Copf: "\u2102", coprod: "\u2210", Coproduct: "\u2210", copy: "\xA9", COPY: "\xA9", copysr: "\u2117", CounterClockwiseContourIntegral: "\u2233", crarr: "\u21B5", cross: "\u2717", Cross: "\u2A2F", Cscr: "\u{1D49E}", cscr: "\u{1D4B8}", csub: "\u2ACF", csube: "\u2AD1", csup: "\u2AD0", csupe: "\u2AD2", ctdot: "\u22EF", cudarrl: "\u2938", cudarrr: "\u2935", cuepr: "\u22DE", cuesc: "\u22DF", cularr: "\u21B6", cularrp: "\u293D", cupbrcap: "\u2A48", cupcap: "\u2A46", CupCap: "\u224D", cup: "\u222A", Cup: "\u22D3", cupcup: "\u2A4A", cupdot: "\u228D", cupor: "\u2A45", cups: "\u222A\uFE00", curarr: "\u21B7", curarrm: "\u293C", curlyeqprec: "\u22DE", curlyeqsucc: "\u22DF", curlyvee: "\u22CE", curlywedge: "\u22CF", curren: "\xA4", curvearrowleft: "\u21B6", curvearrowright: "\u21B7", cuvee: "\u22CE", cuwed: "\u22CF", cwconint: "\u2232", cwint: "\u2231", cylcty: "\u232D", dagger: "\u2020", Dagger: "\u2021", daleth: "\u2138", darr: "\u2193", Darr: "\u21A1", dArr: "\u21D3", dash: "\u2010", Dashv: "\u2AE4", dashv: "\u22A3", dbkarow: "\u290F", dblac: "\u02DD", Dcaron: "\u010E", dcaron: "\u010F", Dcy: "\u0414", dcy: "\u0434", ddagger: "\u2021", ddarr: "\u21CA", DD: "\u2145", dd: "\u2146", DDotrahd: "\u2911", ddotseq: "\u2A77", deg: "\xB0", Del: "\u2207", Delta: "\u0394", delta: "\u03B4", demptyv: "\u29B1", dfisht: "\u297F", Dfr: "\u{1D507}", dfr: "\u{1D521}", dHar: "\u2965", dharl: "\u21C3", dharr: "\u21C2", DiacriticalAcute: "\xB4", DiacriticalDot: "\u02D9", DiacriticalDoubleAcute: "\u02DD", DiacriticalGrave: "`", DiacriticalTilde: "\u02DC", diam: "\u22C4", diamond: "\u22C4", Diamond: "\u22C4", diamondsuit: "\u2666", diams: "\u2666", die: "\xA8", DifferentialD: "\u2146", digamma: "\u03DD", disin: "\u22F2", div: "\xF7", divide: "\xF7", divideontimes: "\u22C7", divonx: "\u22C7", DJcy: "\u0402", djcy: "\u0452", dlcorn: "\u231E", dlcrop: "\u230D", dollar: "$", Dopf: "\u{1D53B}", dopf: "\u{1D555}", Dot: "\xA8", dot: "\u02D9", DotDot: "\u20DC", doteq: "\u2250", doteqdot: "\u2251", DotEqual: "\u2250", dotminus: "\u2238", dotplus: "\u2214", dotsquare: "\u22A1", doublebarwedge: "\u2306", DoubleContourIntegral: "\u222F", DoubleDot: "\xA8", DoubleDownArrow: "\u21D3", DoubleLeftArrow: "\u21D0", DoubleLeftRightArrow: "\u21D4", DoubleLeftTee: "\u2AE4", DoubleLongLeftArrow: "\u27F8", DoubleLongLeftRightArrow: "\u27FA", DoubleLongRightArrow: "\u27F9", DoubleRightArrow: "\u21D2", DoubleRightTee: "\u22A8", DoubleUpArrow: "\u21D1", DoubleUpDownArrow: "\u21D5", DoubleVerticalBar: "\u2225", DownArrowBar: "\u2913", downarrow: "\u2193", DownArrow: "\u2193", Downarrow: "\u21D3", DownArrowUpArrow: "\u21F5", DownBreve: "\u0311", downdownarrows: "\u21CA", downharpoonleft: "\u21C3", downharpoonright: "\u21C2", DownLeftRightVector: "\u2950", DownLeftTeeVector: "\u295E", DownLeftVectorBar: "\u2956", DownLeftVector: "\u21BD", DownRightTeeVector: "\u295F", DownRightVectorBar: "\u2957", DownRightVector: "\u21C1", DownTeeArrow: "\u21A7", DownTee: "\u22A4", drbkarow: "\u2910", drcorn: "\u231F", drcrop: "\u230C", Dscr: "\u{1D49F}", dscr: "\u{1D4B9}", DScy: "\u0405", dscy: "\u0455", dsol: "\u29F6", Dstrok: "\u0110", dstrok: "\u0111", dtdot: "\u22F1", dtri: "\u25BF", dtrif: "\u25BE", duarr: "\u21F5", duhar: "\u296F", dwangle: "\u29A6", DZcy: "\u040F", dzcy: "\u045F", dzigrarr: "\u27FF", Eacute: "\xC9", eacute: "\xE9", easter: "\u2A6E", Ecaron: "\u011A", ecaron: "\u011B", Ecirc: "\xCA", ecirc: "\xEA", ecir: "\u2256", ecolon: "\u2255", Ecy: "\u042D", ecy: "\u044D", eDDot: "\u2A77", Edot: "\u0116", edot: "\u0117", eDot: "\u2251", ee: "\u2147", efDot: "\u2252", Efr: "\u{1D508}", efr: "\u{1D522}", eg: "\u2A9A", Egrave: "\xC8", egrave: "\xE8", egs: "\u2A96", egsdot: "\u2A98", el: "\u2A99", Element: "\u2208", elinters: "\u23E7", ell: "\u2113", els: "\u2A95", elsdot: "\u2A97", Emacr: "\u0112", emacr: "\u0113", empty: "\u2205", emptyset: "\u2205", EmptySmallSquare: "\u25FB", emptyv: "\u2205", EmptyVerySmallSquare: "\u25AB", emsp13: "\u2004", emsp14: "\u2005", emsp: "\u2003", ENG: "\u014A", eng: "\u014B", ensp: "\u2002", Eogon: "\u0118", eogon: "\u0119", Eopf: "\u{1D53C}", eopf: "\u{1D556}", epar: "\u22D5", eparsl: "\u29E3", eplus: "\u2A71", epsi: "\u03B5", Epsilon: "\u0395", epsilon: "\u03B5", epsiv: "\u03F5", eqcirc: "\u2256", eqcolon: "\u2255", eqsim: "\u2242", eqslantgtr: "\u2A96", eqslantless: "\u2A95", Equal: "\u2A75", equals: "=", EqualTilde: "\u2242", equest: "\u225F", Equilibrium: "\u21CC", equiv: "\u2261", equivDD: "\u2A78", eqvparsl: "\u29E5", erarr: "\u2971", erDot: "\u2253", escr: "\u212F", Escr: "\u2130", esdot: "\u2250", Esim: "\u2A73", esim: "\u2242", Eta: "\u0397", eta: "\u03B7", ETH: "\xD0", eth: "\xF0", Euml: "\xCB", euml: "\xEB", euro: "\u20AC", excl: "!", exist: "\u2203", Exists: "\u2203", expectation: "\u2130", exponentiale: "\u2147", ExponentialE: "\u2147", fallingdotseq: "\u2252", Fcy: "\u0424", fcy: "\u0444", female: "\u2640", ffilig: "\uFB03", fflig: "\uFB00", ffllig: "\uFB04", Ffr: "\u{1D509}", ffr: "\u{1D523}", filig: "\uFB01", FilledSmallSquare: "\u25FC", FilledVerySmallSquare: "\u25AA", fjlig: "fj", flat: "\u266D", fllig: "\uFB02", fltns: "\u25B1", fnof: "\u0192", Fopf: "\u{1D53D}", fopf: "\u{1D557}", forall: "\u2200", ForAll: "\u2200", fork: "\u22D4", forkv: "\u2AD9", Fouriertrf: "\u2131", fpartint: "\u2A0D", frac12: "\xBD", frac13: "\u2153", frac14: "\xBC", frac15: "\u2155", frac16: "\u2159", frac18: "\u215B", frac23: "\u2154", frac25: "\u2156", frac34: "\xBE", frac35: "\u2157", frac38: "\u215C", frac45: "\u2158", frac56: "\u215A", frac58: "\u215D", frac78: "\u215E", frasl: "\u2044", frown: "\u2322", fscr: "\u{1D4BB}", Fscr: "\u2131", gacute: "\u01F5", Gamma: "\u0393", gamma: "\u03B3", Gammad: "\u03DC", gammad: "\u03DD", gap: "\u2A86", Gbreve: "\u011E", gbreve: "\u011F", Gcedil: "\u0122", Gcirc: "\u011C", gcirc: "\u011D", Gcy: "\u0413", gcy: "\u0433", Gdot: "\u0120", gdot: "\u0121", ge: "\u2265", gE: "\u2267", gEl: "\u2A8C", gel: "\u22DB", geq: "\u2265", geqq: "\u2267", geqslant: "\u2A7E", gescc: "\u2AA9", ges: "\u2A7E", gesdot: "\u2A80", gesdoto: "\u2A82", gesdotol: "\u2A84", gesl: "\u22DB\uFE00", gesles: "\u2A94", Gfr: "\u{1D50A}", gfr: "\u{1D524}", gg: "\u226B", Gg: "\u22D9", ggg: "\u22D9", gimel: "\u2137", GJcy: "\u0403", gjcy: "\u0453", gla: "\u2AA5", gl: "\u2277", glE: "\u2A92", glj: "\u2AA4", gnap: "\u2A8A", gnapprox: "\u2A8A", gne: "\u2A88", gnE: "\u2269", gneq: "\u2A88", gneqq: "\u2269", gnsim: "\u22E7", Gopf: "\u{1D53E}", gopf: "\u{1D558}", grave: "`", GreaterEqual: "\u2265", GreaterEqualLess: "\u22DB", GreaterFullEqual: "\u2267", GreaterGreater: "\u2AA2", GreaterLess: "\u2277", GreaterSlantEqual: "\u2A7E", GreaterTilde: "\u2273", Gscr: "\u{1D4A2}", gscr: "\u210A", gsim: "\u2273", gsime: "\u2A8E", gsiml: "\u2A90", gtcc: "\u2AA7", gtcir: "\u2A7A", gt: ">", GT: ">", Gt: "\u226B", gtdot: "\u22D7", gtlPar: "\u2995", gtquest: "\u2A7C", gtrapprox: "\u2A86", gtrarr: "\u2978", gtrdot: "\u22D7", gtreqless: "\u22DB", gtreqqless: "\u2A8C", gtrless: "\u2277", gtrsim: "\u2273", gvertneqq: "\u2269\uFE00", gvnE: "\u2269\uFE00", Hacek: "\u02C7", hairsp: "\u200A", half: "\xBD", hamilt: "\u210B", HARDcy: "\u042A", hardcy: "\u044A", harrcir: "\u2948", harr: "\u2194", hArr: "\u21D4", harrw: "\u21AD", Hat: "^", hbar: "\u210F", Hcirc: "\u0124", hcirc: "\u0125", hearts: "\u2665", heartsuit: "\u2665", hellip: "\u2026", hercon: "\u22B9", hfr: "\u{1D525}", Hfr: "\u210C", HilbertSpace: "\u210B", hksearow: "\u2925", hkswarow: "\u2926", hoarr: "\u21FF", homtht: "\u223B", hookleftarrow: "\u21A9", hookrightarrow: "\u21AA", hopf: "\u{1D559}", Hopf: "\u210D", horbar: "\u2015", HorizontalLine: "\u2500", hscr: "\u{1D4BD}", Hscr: "\u210B", hslash: "\u210F", Hstrok: "\u0126", hstrok: "\u0127", HumpDownHump: "\u224E", HumpEqual: "\u224F", hybull: "\u2043", hyphen: "\u2010", Iacute: "\xCD", iacute: "\xED", ic: "\u2063", Icirc: "\xCE", icirc: "\xEE", Icy: "\u0418", icy: "\u0438", Idot: "\u0130", IEcy: "\u0415", iecy: "\u0435", iexcl: "\xA1", iff: "\u21D4", ifr: "\u{1D526}", Ifr: "\u2111", Igrave: "\xCC", igrave: "\xEC", ii: "\u2148", iiiint: "\u2A0C", iiint: "\u222D", iinfin: "\u29DC", iiota: "\u2129", IJlig: "\u0132", ijlig: "\u0133", Imacr: "\u012A", imacr: "\u012B", image: "\u2111", ImaginaryI: "\u2148", imagline: "\u2110", imagpart: "\u2111", imath: "\u0131", Im: "\u2111", imof: "\u22B7", imped: "\u01B5", Implies: "\u21D2", incare: "\u2105", in: "\u2208", infin: "\u221E", infintie: "\u29DD", inodot: "\u0131", intcal: "\u22BA", int: "\u222B", Int: "\u222C", integers: "\u2124", Integral: "\u222B", intercal: "\u22BA", Intersection: "\u22C2", intlarhk: "\u2A17", intprod: "\u2A3C", InvisibleComma: "\u2063", InvisibleTimes: "\u2062", IOcy: "\u0401", iocy: "\u0451", Iogon: "\u012E", iogon: "\u012F", Iopf: "\u{1D540}", iopf: "\u{1D55A}", Iota: "\u0399", iota: "\u03B9", iprod: "\u2A3C", iquest: "\xBF", iscr: "\u{1D4BE}", Iscr: "\u2110", isin: "\u2208", isindot: "\u22F5", isinE: "\u22F9", isins: "\u22F4", isinsv: "\u22F3", isinv: "\u2208", it: "\u2062", Itilde: "\u0128", itilde: "\u0129", Iukcy: "\u0406", iukcy: "\u0456", Iuml: "\xCF", iuml: "\xEF", Jcirc: "\u0134", jcirc: "\u0135", Jcy: "\u0419", jcy: "\u0439", Jfr: "\u{1D50D}", jfr: "\u{1D527}", jmath: "\u0237", Jopf: "\u{1D541}", jopf: "\u{1D55B}", Jscr: "\u{1D4A5}", jscr: "\u{1D4BF}", Jsercy: "\u0408", jsercy: "\u0458", Jukcy: "\u0404", jukcy: "\u0454", Kappa: "\u039A", kappa: "\u03BA", kappav: "\u03F0", Kcedil: "\u0136", kcedil: "\u0137", Kcy: "\u041A", kcy: "\u043A", Kfr: "\u{1D50E}", kfr: "\u{1D528}", kgreen: "\u0138", KHcy: "\u0425", khcy: "\u0445", KJcy: "\u040C", kjcy: "\u045C", Kopf: "\u{1D542}", kopf: "\u{1D55C}", Kscr: "\u{1D4A6}", kscr: "\u{1D4C0}", lAarr: "\u21DA", Lacute: "\u0139", lacute: "\u013A", laemptyv: "\u29B4", lagran: "\u2112", Lambda: "\u039B", lambda: "\u03BB", lang: "\u27E8", Lang: "\u27EA", langd: "\u2991", langle: "\u27E8", lap: "\u2A85", Laplacetrf: "\u2112", laquo: "\xAB", larrb: "\u21E4", larrbfs: "\u291F", larr: "\u2190", Larr: "\u219E", lArr: "\u21D0", larrfs: "\u291D", larrhk: "\u21A9", larrlp: "\u21AB", larrpl: "\u2939", larrsim: "\u2973", larrtl: "\u21A2", latail: "\u2919", lAtail: "\u291B", lat: "\u2AAB", late: "\u2AAD", lates: "\u2AAD\uFE00", lbarr: "\u290C", lBarr: "\u290E", lbbrk: "\u2772", lbrace: "{", lbrack: "[", lbrke: "\u298B", lbrksld: "\u298F", lbrkslu: "\u298D", Lcaron: "\u013D", lcaron: "\u013E", Lcedil: "\u013B", lcedil: "\u013C", lceil: "\u2308", lcub: "{", Lcy: "\u041B", lcy: "\u043B", ldca: "\u2936", ldquo: "\u201C", ldquor: "\u201E", ldrdhar: "\u2967", ldrushar: "\u294B", ldsh: "\u21B2", le: "\u2264", lE: "\u2266", LeftAngleBracket: "\u27E8", LeftArrowBar: "\u21E4", leftarrow: "\u2190", LeftArrow: "\u2190", Leftarrow: "\u21D0", LeftArrowRightArrow: "\u21C6", leftarrowtail: "\u21A2", LeftCeiling: "\u2308", LeftDoubleBracket: "\u27E6", LeftDownTeeVector: "\u2961", LeftDownVectorBar: "\u2959", LeftDownVector: "\u21C3", LeftFloor: "\u230A", leftharpoondown: "\u21BD", leftharpoonup: "\u21BC", leftleftarrows: "\u21C7", leftrightarrow: "\u2194", LeftRightArrow: "\u2194", Leftrightarrow: "\u21D4", leftrightarrows: "\u21C6", leftrightharpoons: "\u21CB", leftrightsquigarrow: "\u21AD", LeftRightVector: "\u294E", LeftTeeArrow: "\u21A4", LeftTee: "\u22A3", LeftTeeVector: "\u295A", leftthreetimes: "\u22CB", LeftTriangleBar: "\u29CF", LeftTriangle: "\u22B2", LeftTriangleEqual: "\u22B4", LeftUpDownVector: "\u2951", LeftUpTeeVector: "\u2960", LeftUpVectorBar: "\u2958", LeftUpVector: "\u21BF", LeftVectorBar: "\u2952", LeftVector: "\u21BC", lEg: "\u2A8B", leg: "\u22DA", leq: "\u2264", leqq: "\u2266", leqslant: "\u2A7D", lescc: "\u2AA8", les: "\u2A7D", lesdot: "\u2A7F", lesdoto: "\u2A81", lesdotor: "\u2A83", lesg: "\u22DA\uFE00", lesges: "\u2A93", lessapprox: "\u2A85", lessdot: "\u22D6", lesseqgtr: "\u22DA", lesseqqgtr: "\u2A8B", LessEqualGreater: "\u22DA", LessFullEqual: "\u2266", LessGreater: "\u2276", lessgtr: "\u2276", LessLess: "\u2AA1", lesssim: "\u2272", LessSlantEqual: "\u2A7D", LessTilde: "\u2272", lfisht: "\u297C", lfloor: "\u230A", Lfr: "\u{1D50F}", lfr: "\u{1D529}", lg: "\u2276", lgE: "\u2A91", lHar: "\u2962", lhard: "\u21BD", lharu: "\u21BC", lharul: "\u296A", lhblk: "\u2584", LJcy: "\u0409", ljcy: "\u0459", llarr: "\u21C7", ll: "\u226A", Ll: "\u22D8", llcorner: "\u231E", Lleftarrow: "\u21DA", llhard: "\u296B", lltri: "\u25FA", Lmidot: "\u013F", lmidot: "\u0140", lmoustache: "\u23B0", lmoust: "\u23B0", lnap: "\u2A89", lnapprox: "\u2A89", lne: "\u2A87", lnE: "\u2268", lneq: "\u2A87", lneqq: "\u2268", lnsim: "\u22E6", loang: "\u27EC", loarr: "\u21FD", lobrk: "\u27E6", longleftarrow: "\u27F5", LongLeftArrow: "\u27F5", Longleftarrow: "\u27F8", longleftrightarrow: "\u27F7", LongLeftRightArrow: "\u27F7", Longleftrightarrow: "\u27FA", longmapsto: "\u27FC", longrightarrow: "\u27F6", LongRightArrow: "\u27F6", Longrightarrow: "\u27F9", looparrowleft: "\u21AB", looparrowright: "\u21AC", lopar: "\u2985", Lopf: "\u{1D543}", lopf: "\u{1D55D}", loplus: "\u2A2D", lotimes: "\u2A34", lowast: "\u2217", lowbar: "_", LowerLeftArrow: "\u2199", LowerRightArrow: "\u2198", loz: "\u25CA", lozenge: "\u25CA", lozf: "\u29EB", lpar: "(", lparlt: "\u2993", lrarr: "\u21C6", lrcorner: "\u231F", lrhar: "\u21CB", lrhard: "\u296D", lrm: "\u200E", lrtri: "\u22BF", lsaquo: "\u2039", lscr: "\u{1D4C1}", Lscr: "\u2112", lsh: "\u21B0", Lsh: "\u21B0", lsim: "\u2272", lsime: "\u2A8D", lsimg: "\u2A8F", lsqb: "[", lsquo: "\u2018", lsquor: "\u201A", Lstrok: "\u0141", lstrok: "\u0142", ltcc: "\u2AA6", ltcir: "\u2A79", lt: "<", LT: "<", Lt: "\u226A", ltdot: "\u22D6", lthree: "\u22CB", ltimes: "\u22C9", ltlarr: "\u2976", ltquest: "\u2A7B", ltri: "\u25C3", ltrie: "\u22B4", ltrif: "\u25C2", ltrPar: "\u2996", lurdshar: "\u294A", luruhar: "\u2966", lvertneqq: "\u2268\uFE00", lvnE: "\u2268\uFE00", macr: "\xAF", male: "\u2642", malt: "\u2720", maltese: "\u2720", Map: "\u2905", map: "\u21A6", mapsto: "\u21A6", mapstodown: "\u21A7", mapstoleft: "\u21A4", mapstoup: "\u21A5", marker: "\u25AE", mcomma: "\u2A29", Mcy: "\u041C", mcy: "\u043C", mdash: "\u2014", mDDot: "\u223A", measuredangle: "\u2221", MediumSpace: "\u205F", Mellintrf: "\u2133", Mfr: "\u{1D510}", mfr: "\u{1D52A}", mho: "\u2127", micro: "\xB5", midast: "*", midcir: "\u2AF0", mid: "\u2223", middot: "\xB7", minusb: "\u229F", minus: "\u2212", minusd: "\u2238", minusdu: "\u2A2A", MinusPlus: "\u2213", mlcp: "\u2ADB", mldr: "\u2026", mnplus: "\u2213", models: "\u22A7", Mopf: "\u{1D544}", mopf: "\u{1D55E}", mp: "\u2213", mscr: "\u{1D4C2}", Mscr: "\u2133", mstpos: "\u223E", Mu: "\u039C", mu: "\u03BC", multimap: "\u22B8", mumap: "\u22B8", nabla: "\u2207", Nacute: "\u0143", nacute: "\u0144", nang: "\u2220\u20D2", nap: "\u2249", napE: "\u2A70\u0338", napid: "\u224B\u0338", napos: "\u0149", napprox: "\u2249", natural: "\u266E", naturals: "\u2115", natur: "\u266E", nbsp: "\xA0", nbump: "\u224E\u0338", nbumpe: "\u224F\u0338", ncap: "\u2A43", Ncaron: "\u0147", ncaron: "\u0148", Ncedil: "\u0145", ncedil: "\u0146", ncong: "\u2247", ncongdot: "\u2A6D\u0338", ncup: "\u2A42", Ncy: "\u041D", ncy: "\u043D", ndash: "\u2013", nearhk: "\u2924", nearr: "\u2197", neArr: "\u21D7", nearrow: "\u2197", ne: "\u2260", nedot: "\u2250\u0338", NegativeMediumSpace: "\u200B", NegativeThickSpace: "\u200B", NegativeThinSpace: "\u200B", NegativeVeryThinSpace: "\u200B", nequiv: "\u2262", nesear: "\u2928", nesim: "\u2242\u0338", NestedGreaterGreater: "\u226B", NestedLessLess: "\u226A", NewLine: "\n", nexist: "\u2204", nexists: "\u2204", Nfr: "\u{1D511}", nfr: "\u{1D52B}", ngE: "\u2267\u0338", nge: "\u2271", ngeq: "\u2271", ngeqq: "\u2267\u0338", ngeqslant: "\u2A7E\u0338", nges: "\u2A7E\u0338", nGg: "\u22D9\u0338", ngsim: "\u2275", nGt: "\u226B\u20D2", ngt: "\u226F", ngtr: "\u226F", nGtv: "\u226B\u0338", nharr: "\u21AE", nhArr: "\u21CE", nhpar: "\u2AF2", ni: "\u220B", nis: "\u22FC", nisd: "\u22FA", niv: "\u220B", NJcy: "\u040A", njcy: "\u045A", nlarr: "\u219A", nlArr: "\u21CD", nldr: "\u2025", nlE: "\u2266\u0338", nle: "\u2270", nleftarrow: "\u219A", nLeftarrow: "\u21CD", nleftrightarrow: "\u21AE", nLeftrightarrow: "\u21CE", nleq: "\u2270", nleqq: "\u2266\u0338", nleqslant: "\u2A7D\u0338", nles: "\u2A7D\u0338", nless: "\u226E", nLl: "\u22D8\u0338", nlsim: "\u2274", nLt: "\u226A\u20D2", nlt: "\u226E", nltri: "\u22EA", nltrie: "\u22EC", nLtv: "\u226A\u0338", nmid: "\u2224", NoBreak: "\u2060", NonBreakingSpace: "\xA0", nopf: "\u{1D55F}", Nopf: "\u2115", Not: "\u2AEC", not: "\xAC", NotCongruent: "\u2262", NotCupCap: "\u226D", NotDoubleVerticalBar: "\u2226", NotElement: "\u2209", NotEqual: "\u2260", NotEqualTilde: "\u2242\u0338", NotExists: "\u2204", NotGreater: "\u226F", NotGreaterEqual: "\u2271", NotGreaterFullEqual: "\u2267\u0338", NotGreaterGreater: "\u226B\u0338", NotGreaterLess: "\u2279", NotGreaterSlantEqual: "\u2A7E\u0338", NotGreaterTilde: "\u2275", NotHumpDownHump: "\u224E\u0338", NotHumpEqual: "\u224F\u0338", notin: "\u2209", notindot: "\u22F5\u0338", notinE: "\u22F9\u0338", notinva: "\u2209", notinvb: "\u22F7", notinvc: "\u22F6", NotLeftTriangleBar: "\u29CF\u0338", NotLeftTriangle: "\u22EA", NotLeftTriangleEqual: "\u22EC", NotLess: "\u226E", NotLessEqual: "\u2270", NotLessGreater: "\u2278", NotLessLess: "\u226A\u0338", NotLessSlantEqual: "\u2A7D\u0338", NotLessTilde: "\u2274", NotNestedGreaterGreater: "\u2AA2\u0338", NotNestedLessLess: "\u2AA1\u0338", notni: "\u220C", notniva: "\u220C", notnivb: "\u22FE", notnivc: "\u22FD", NotPrecedes: "\u2280", NotPrecedesEqual: "\u2AAF\u0338", NotPrecedesSlantEqual: "\u22E0", NotReverseElement: "\u220C", NotRightTriangleBar: "\u29D0\u0338", NotRightTriangle: "\u22EB", NotRightTriangleEqual: "\u22ED", NotSquareSubset: "\u228F\u0338", NotSquareSubsetEqual: "\u22E2", NotSquareSuperset: "\u2290\u0338", NotSquareSupersetEqual: "\u22E3", NotSubset: "\u2282\u20D2", NotSubsetEqual: "\u2288", NotSucceeds: "\u2281", NotSucceedsEqual: "\u2AB0\u0338", NotSucceedsSlantEqual: "\u22E1", NotSucceedsTilde: "\u227F\u0338", NotSuperset: "\u2283\u20D2", NotSupersetEqual: "\u2289", NotTilde: "\u2241", NotTildeEqual: "\u2244", NotTildeFullEqual: "\u2247", NotTildeTilde: "\u2249", NotVerticalBar: "\u2224", nparallel: "\u2226", npar: "\u2226", nparsl: "\u2AFD\u20E5", npart: "\u2202\u0338", npolint: "\u2A14", npr: "\u2280", nprcue: "\u22E0", nprec: "\u2280", npreceq: "\u2AAF\u0338", npre: "\u2AAF\u0338", nrarrc: "\u2933\u0338", nrarr: "\u219B", nrArr: "\u21CF", nrarrw: "\u219D\u0338", nrightarrow: "\u219B", nRightarrow: "\u21CF", nrtri: "\u22EB", nrtrie: "\u22ED", nsc: "\u2281", nsccue: "\u22E1", nsce: "\u2AB0\u0338", Nscr: "\u{1D4A9}", nscr: "\u{1D4C3}", nshortmid: "\u2224", nshortparallel: "\u2226", nsim: "\u2241", nsime: "\u2244", nsimeq: "\u2244", nsmid: "\u2224", nspar: "\u2226", nsqsube: "\u22E2", nsqsupe: "\u22E3", nsub: "\u2284", nsubE: "\u2AC5\u0338", nsube: "\u2288", nsubset: "\u2282\u20D2", nsubseteq: "\u2288", nsubseteqq: "\u2AC5\u0338", nsucc: "\u2281", nsucceq: "\u2AB0\u0338", nsup: "\u2285", nsupE: "\u2AC6\u0338", nsupe: "\u2289", nsupset: "\u2283\u20D2", nsupseteq: "\u2289", nsupseteqq: "\u2AC6\u0338", ntgl: "\u2279", Ntilde: "\xD1", ntilde: "\xF1", ntlg: "\u2278", ntriangleleft: "\u22EA", ntrianglelefteq: "\u22EC", ntriangleright: "\u22EB", ntrianglerighteq: "\u22ED", Nu: "\u039D", nu: "\u03BD", num: "#", numero: "\u2116", numsp: "\u2007", nvap: "\u224D\u20D2", nvdash: "\u22AC", nvDash: "\u22AD", nVdash: "\u22AE", nVDash: "\u22AF", nvge: "\u2265\u20D2", nvgt: ">\u20D2", nvHarr: "\u2904", nvinfin: "\u29DE", nvlArr: "\u2902", nvle: "\u2264\u20D2", nvlt: "<\u20D2", nvltrie: "\u22B4\u20D2", nvrArr: "\u2903", nvrtrie: "\u22B5\u20D2", nvsim: "\u223C\u20D2", nwarhk: "\u2923", nwarr: "\u2196", nwArr: "\u21D6", nwarrow: "\u2196", nwnear: "\u2927", Oacute: "\xD3", oacute: "\xF3", oast: "\u229B", Ocirc: "\xD4", ocirc: "\xF4", ocir: "\u229A", Ocy: "\u041E", ocy: "\u043E", odash: "\u229D", Odblac: "\u0150", odblac: "\u0151", odiv: "\u2A38", odot: "\u2299", odsold: "\u29BC", OElig: "\u0152", oelig: "\u0153", ofcir: "\u29BF", Ofr: "\u{1D512}", ofr: "\u{1D52C}", ogon: "\u02DB", Ograve: "\xD2", ograve: "\xF2", ogt: "\u29C1", ohbar: "\u29B5", ohm: "\u03A9", oint: "\u222E", olarr: "\u21BA", olcir: "\u29BE", olcross: "\u29BB", oline: "\u203E", olt: "\u29C0", Omacr: "\u014C", omacr: "\u014D", Omega: "\u03A9", omega: "\u03C9", Omicron: "\u039F", omicron: "\u03BF", omid: "\u29B6", ominus: "\u2296", Oopf: "\u{1D546}", oopf: "\u{1D560}", opar: "\u29B7", OpenCurlyDoubleQuote: "\u201C", OpenCurlyQuote: "\u2018", operp: "\u29B9", oplus: "\u2295", orarr: "\u21BB", Or: "\u2A54", or: "\u2228", ord: "\u2A5D", order: "\u2134", orderof: "\u2134", ordf: "\xAA", ordm: "\xBA", origof: "\u22B6", oror: "\u2A56", orslope: "\u2A57", orv: "\u2A5B", oS: "\u24C8", Oscr: "\u{1D4AA}", oscr: "\u2134", Oslash: "\xD8", oslash: "\xF8", osol: "\u2298", Otilde: "\xD5", otilde: "\xF5", otimesas: "\u2A36", Otimes: "\u2A37", otimes: "\u2297", Ouml: "\xD6", ouml: "\xF6", ovbar: "\u233D", OverBar: "\u203E", OverBrace: "\u23DE", OverBracket: "\u23B4", OverParenthesis: "\u23DC", para: "\xB6", parallel: "\u2225", par: "\u2225", parsim: "\u2AF3", parsl: "\u2AFD", part: "\u2202", PartialD: "\u2202", Pcy: "\u041F", pcy: "\u043F", percnt: "%", period: ".", permil: "\u2030", perp: "\u22A5", pertenk: "\u2031", Pfr: "\u{1D513}", pfr: "\u{1D52D}", Phi: "\u03A6", phi: "\u03C6", phiv: "\u03D5", phmmat: "\u2133", phone: "\u260E", Pi: "\u03A0", pi: "\u03C0", pitchfork: "\u22D4", piv: "\u03D6", planck: "\u210F", planckh: "\u210E", plankv: "\u210F", plusacir: "\u2A23", plusb: "\u229E", pluscir: "\u2A22", plus: "+", plusdo: "\u2214", plusdu: "\u2A25", pluse: "\u2A72", PlusMinus: "\xB1", plusmn: "\xB1", plussim: "\u2A26", plustwo: "\u2A27", pm: "\xB1", Poincareplane: "\u210C", pointint: "\u2A15", popf: "\u{1D561}", Popf: "\u2119", pound: "\xA3", prap: "\u2AB7", Pr: "\u2ABB", pr: "\u227A", prcue: "\u227C", precapprox: "\u2AB7", prec: "\u227A", preccurlyeq: "\u227C", Precedes: "\u227A", PrecedesEqual: "\u2AAF", PrecedesSlantEqual: "\u227C", PrecedesTilde: "\u227E", preceq: "\u2AAF", precnapprox: "\u2AB9", precneqq: "\u2AB5", precnsim: "\u22E8", pre: "\u2AAF", prE: "\u2AB3", precsim: "\u227E", prime: "\u2032", Prime: "\u2033", primes: "\u2119", prnap: "\u2AB9", prnE: "\u2AB5", prnsim: "\u22E8", prod: "\u220F", Product: "\u220F", profalar: "\u232E", profline: "\u2312", profsurf: "\u2313", prop: "\u221D", Proportional: "\u221D", Proportion: "\u2237", propto: "\u221D", prsim: "\u227E", prurel: "\u22B0", Pscr: "\u{1D4AB}", pscr: "\u{1D4C5}", Psi: "\u03A8", psi: "\u03C8", puncsp: "\u2008", Qfr: "\u{1D514}", qfr: "\u{1D52E}", qint: "\u2A0C", qopf: "\u{1D562}", Qopf: "\u211A", qprime: "\u2057", Qscr: "\u{1D4AC}", qscr: "\u{1D4C6}", quaternions: "\u210D", quatint: "\u2A16", quest: "?", questeq: "\u225F", quot: '"', QUOT: '"', rAarr: "\u21DB", race: "\u223D\u0331", Racute: "\u0154", racute: "\u0155", radic: "\u221A", raemptyv: "\u29B3", rang: "\u27E9", Rang: "\u27EB", rangd: "\u2992", range: "\u29A5", rangle: "\u27E9", raquo: "\xBB", rarrap: "\u2975", rarrb: "\u21E5", rarrbfs: "\u2920", rarrc: "\u2933", rarr: "\u2192", Rarr: "\u21A0", rArr: "\u21D2", rarrfs: "\u291E", rarrhk: "\u21AA", rarrlp: "\u21AC", rarrpl: "\u2945", rarrsim: "\u2974", Rarrtl: "\u2916", rarrtl: "\u21A3", rarrw: "\u219D", ratail: "\u291A", rAtail: "\u291C", ratio: "\u2236", rationals: "\u211A", rbarr: "\u290D", rBarr: "\u290F", RBarr: "\u2910", rbbrk: "\u2773", rbrace: "}", rbrack: "]", rbrke: "\u298C", rbrksld: "\u298E", rbrkslu: "\u2990", Rcaron: "\u0158", rcaron: "\u0159", Rcedil: "\u0156", rcedil: "\u0157", rceil: "\u2309", rcub: "}", Rcy: "\u0420", rcy: "\u0440", rdca: "\u2937", rdldhar: "\u2969", rdquo: "\u201D", rdquor: "\u201D", rdsh: "\u21B3", real: "\u211C", realine: "\u211B", realpart: "\u211C", reals: "\u211D", Re: "\u211C", rect: "\u25AD", reg: "\xAE", REG: "\xAE", ReverseElement: "\u220B", ReverseEquilibrium: "\u21CB", ReverseUpEquilibrium: "\u296F", rfisht: "\u297D", rfloor: "\u230B", rfr: "\u{1D52F}", Rfr: "\u211C", rHar: "\u2964", rhard: "\u21C1", rharu: "\u21C0", rharul: "\u296C", Rho: "\u03A1", rho: "\u03C1", rhov: "\u03F1", RightAngleBracket: "\u27E9", RightArrowBar: "\u21E5", rightarrow: "\u2192", RightArrow: "\u2192", Rightarrow: "\u21D2", RightArrowLeftArrow: "\u21C4", rightarrowtail: "\u21A3", RightCeiling: "\u2309", RightDoubleBracket: "\u27E7", RightDownTeeVector: "\u295D", RightDownVectorBar: "\u2955", RightDownVector: "\u21C2", RightFloor: "\u230B", rightharpoondown: "\u21C1", rightharpoonup: "\u21C0", rightleftarrows: "\u21C4", rightleftharpoons: "\u21CC", rightrightarrows: "\u21C9", rightsquigarrow: "\u219D", RightTeeArrow: "\u21A6", RightTee: "\u22A2", RightTeeVector: "\u295B", rightthreetimes: "\u22CC", RightTriangleBar: "\u29D0", RightTriangle: "\u22B3", RightTriangleEqual: "\u22B5", RightUpDownVector: "\u294F", RightUpTeeVector: "\u295C", RightUpVectorBar: "\u2954", RightUpVector: "\u21BE", RightVectorBar: "\u2953", RightVector: "\u21C0", ring: "\u02DA", risingdotseq: "\u2253", rlarr: "\u21C4", rlhar: "\u21CC", rlm: "\u200F", rmoustache: "\u23B1", rmoust: "\u23B1", rnmid: "\u2AEE", roang: "\u27ED", roarr: "\u21FE", robrk: "\u27E7", ropar: "\u2986", ropf: "\u{1D563}", Ropf: "\u211D", roplus: "\u2A2E", rotimes: "\u2A35", RoundImplies: "\u2970", rpar: ")", rpargt: "\u2994", rppolint: "\u2A12", rrarr: "\u21C9", Rrightarrow: "\u21DB", rsaquo: "\u203A", rscr: "\u{1D4C7}", Rscr: "\u211B", rsh: "\u21B1", Rsh: "\u21B1", rsqb: "]", rsquo: "\u2019", rsquor: "\u2019", rthree: "\u22CC", rtimes: "\u22CA", rtri: "\u25B9", rtrie: "\u22B5", rtrif: "\u25B8", rtriltri: "\u29CE", RuleDelayed: "\u29F4", ruluhar: "\u2968", rx: "\u211E", Sacute: "\u015A", sacute: "\u015B", sbquo: "\u201A", scap: "\u2AB8", Scaron: "\u0160", scaron: "\u0161", Sc: "\u2ABC", sc: "\u227B", sccue: "\u227D", sce: "\u2AB0", scE: "\u2AB4", Scedil: "\u015E", scedil: "\u015F", Scirc: "\u015C", scirc: "\u015D", scnap: "\u2ABA", scnE: "\u2AB6", scnsim: "\u22E9", scpolint: "\u2A13", scsim: "\u227F", Scy: "\u0421", scy: "\u0441", sdotb: "\u22A1", sdot: "\u22C5", sdote: "\u2A66", searhk: "\u2925", searr: "\u2198", seArr: "\u21D8", searrow: "\u2198", sect: "\xA7", semi: ";", seswar: "\u2929", setminus: "\u2216", setmn: "\u2216", sext: "\u2736", Sfr: "\u{1D516}", sfr: "\u{1D530}", sfrown: "\u2322", sharp: "\u266F", SHCHcy: "\u0429", shchcy: "\u0449", SHcy: "\u0428", shcy: "\u0448", ShortDownArrow: "\u2193", ShortLeftArrow: "\u2190", shortmid: "\u2223", shortparallel: "\u2225", ShortRightArrow: "\u2192", ShortUpArrow: "\u2191", shy: "\xAD", Sigma: "\u03A3", sigma: "\u03C3", sigmaf: "\u03C2", sigmav: "\u03C2", sim: "\u223C", simdot: "\u2A6A", sime: "\u2243", simeq: "\u2243", simg: "\u2A9E", simgE: "\u2AA0", siml: "\u2A9D", simlE: "\u2A9F", simne: "\u2246", simplus: "\u2A24", simrarr: "\u2972", slarr: "\u2190", SmallCircle: "\u2218", smallsetminus: "\u2216", smashp: "\u2A33", smeparsl: "\u29E4", smid: "\u2223", smile: "\u2323", smt: "\u2AAA", smte: "\u2AAC", smtes: "\u2AAC\uFE00", SOFTcy: "\u042C", softcy: "\u044C", solbar: "\u233F", solb: "\u29C4", sol: "/", Sopf: "\u{1D54A}", sopf: "\u{1D564}", spades: "\u2660", spadesuit: "\u2660", spar: "\u2225", sqcap: "\u2293", sqcaps: "\u2293\uFE00", sqcup: "\u2294", sqcups: "\u2294\uFE00", Sqrt: "\u221A", sqsub: "\u228F", sqsube: "\u2291", sqsubset: "\u228F", sqsubseteq: "\u2291", sqsup: "\u2290", sqsupe: "\u2292", sqsupset: "\u2290", sqsupseteq: "\u2292", square: "\u25A1", Square: "\u25A1", SquareIntersection: "\u2293", SquareSubset: "\u228F", SquareSubsetEqual: "\u2291", SquareSuperset: "\u2290", SquareSupersetEqual: "\u2292", SquareUnion: "\u2294", squarf: "\u25AA", squ: "\u25A1", squf: "\u25AA", srarr: "\u2192", Sscr: "\u{1D4AE}", sscr: "\u{1D4C8}", ssetmn: "\u2216", ssmile: "\u2323", sstarf: "\u22C6", Star: "\u22C6", star: "\u2606", starf: "\u2605", straightepsilon: "\u03F5", straightphi: "\u03D5", strns: "\xAF", sub: "\u2282", Sub: "\u22D0", subdot: "\u2ABD", subE: "\u2AC5", sube: "\u2286", subedot: "\u2AC3", submult: "\u2AC1", subnE: "\u2ACB", subne: "\u228A", subplus: "\u2ABF", subrarr: "\u2979", subset: "\u2282", Subset: "\u22D0", subseteq: "\u2286", subseteqq: "\u2AC5", SubsetEqual: "\u2286", subsetneq: "\u228A", subsetneqq: "\u2ACB", subsim: "\u2AC7", subsub: "\u2AD5", subsup: "\u2AD3", succapprox: "\u2AB8", succ: "\u227B", succcurlyeq: "\u227D", Succeeds: "\u227B", SucceedsEqual: "\u2AB0", SucceedsSlantEqual: "\u227D", SucceedsTilde: "\u227F", succeq: "\u2AB0", succnapprox: "\u2ABA", succneqq: "\u2AB6", succnsim: "\u22E9", succsim: "\u227F", SuchThat: "\u220B", sum: "\u2211", Sum: "\u2211", sung: "\u266A", sup1: "\xB9", sup2: "\xB2", sup3: "\xB3", sup: "\u2283", Sup: "\u22D1", supdot: "\u2ABE", supdsub: "\u2AD8", supE: "\u2AC6", supe: "\u2287", supedot: "\u2AC4", Superset: "\u2283", SupersetEqual: "\u2287", suphsol: "\u27C9", suphsub: "\u2AD7", suplarr: "\u297B", supmult: "\u2AC2", supnE: "\u2ACC", supne: "\u228B", supplus: "\u2AC0", supset: "\u2283", Supset: "\u22D1", supseteq: "\u2287", supseteqq: "\u2AC6", supsetneq: "\u228B", supsetneqq: "\u2ACC", supsim: "\u2AC8", supsub: "\u2AD4", supsup: "\u2AD6", swarhk: "\u2926", swarr: "\u2199", swArr: "\u21D9", swarrow: "\u2199", swnwar: "\u292A", szlig: "\xDF", Tab: "	", target: "\u2316", Tau: "\u03A4", tau: "\u03C4", tbrk: "\u23B4", Tcaron: "\u0164", tcaron: "\u0165", Tcedil: "\u0162", tcedil: "\u0163", Tcy: "\u0422", tcy: "\u0442", tdot: "\u20DB", telrec: "\u2315", Tfr: "\u{1D517}", tfr: "\u{1D531}", there4: "\u2234", therefore: "\u2234", Therefore: "\u2234", Theta: "\u0398", theta: "\u03B8", thetasym: "\u03D1", thetav: "\u03D1", thickapprox: "\u2248", thicksim: "\u223C", ThickSpace: "\u205F\u200A", ThinSpace: "\u2009", thinsp: "\u2009", thkap: "\u2248", thksim: "\u223C", THORN: "\xDE", thorn: "\xFE", tilde: "\u02DC", Tilde: "\u223C", TildeEqual: "\u2243", TildeFullEqual: "\u2245", TildeTilde: "\u2248", timesbar: "\u2A31", timesb: "\u22A0", times: "\xD7", timesd: "\u2A30", tint: "\u222D", toea: "\u2928", topbot: "\u2336", topcir: "\u2AF1", top: "\u22A4", Topf: "\u{1D54B}", topf: "\u{1D565}", topfork: "\u2ADA", tosa: "\u2929", tprime: "\u2034", trade: "\u2122", TRADE: "\u2122", triangle: "\u25B5", triangledown: "\u25BF", triangleleft: "\u25C3", trianglelefteq: "\u22B4", triangleq: "\u225C", triangleright: "\u25B9", trianglerighteq: "\u22B5", tridot: "\u25EC", trie: "\u225C", triminus: "\u2A3A", TripleDot: "\u20DB", triplus: "\u2A39", trisb: "\u29CD", tritime: "\u2A3B", trpezium: "\u23E2", Tscr: "\u{1D4AF}", tscr: "\u{1D4C9}", TScy: "\u0426", tscy: "\u0446", TSHcy: "\u040B", tshcy: "\u045B", Tstrok: "\u0166", tstrok: "\u0167", twixt: "\u226C", twoheadleftarrow: "\u219E", twoheadrightarrow: "\u21A0", Uacute: "\xDA", uacute: "\xFA", uarr: "\u2191", Uarr: "\u219F", uArr: "\u21D1", Uarrocir: "\u2949", Ubrcy: "\u040E", ubrcy: "\u045E", Ubreve: "\u016C", ubreve: "\u016D", Ucirc: "\xDB", ucirc: "\xFB", Ucy: "\u0423", ucy: "\u0443", udarr: "\u21C5", Udblac: "\u0170", udblac: "\u0171", udhar: "\u296E", ufisht: "\u297E", Ufr: "\u{1D518}", ufr: "\u{1D532}", Ugrave: "\xD9", ugrave: "\xF9", uHar: "\u2963", uharl: "\u21BF", uharr: "\u21BE", uhblk: "\u2580", ulcorn: "\u231C", ulcorner: "\u231C", ulcrop: "\u230F", ultri: "\u25F8", Umacr: "\u016A", umacr: "\u016B", uml: "\xA8", UnderBar: "_", UnderBrace: "\u23DF", UnderBracket: "\u23B5", UnderParenthesis: "\u23DD", Union: "\u22C3", UnionPlus: "\u228E", Uogon: "\u0172", uogon: "\u0173", Uopf: "\u{1D54C}", uopf: "\u{1D566}", UpArrowBar: "\u2912", uparrow: "\u2191", UpArrow: "\u2191", Uparrow: "\u21D1", UpArrowDownArrow: "\u21C5", updownarrow: "\u2195", UpDownArrow: "\u2195", Updownarrow: "\u21D5", UpEquilibrium: "\u296E", upharpoonleft: "\u21BF", upharpoonright: "\u21BE", uplus: "\u228E", UpperLeftArrow: "\u2196", UpperRightArrow: "\u2197", upsi: "\u03C5", Upsi: "\u03D2", upsih: "\u03D2", Upsilon: "\u03A5", upsilon: "\u03C5", UpTeeArrow: "\u21A5", UpTee: "\u22A5", upuparrows: "\u21C8", urcorn: "\u231D", urcorner: "\u231D", urcrop: "\u230E", Uring: "\u016E", uring: "\u016F", urtri: "\u25F9", Uscr: "\u{1D4B0}", uscr: "\u{1D4CA}", utdot: "\u22F0", Utilde: "\u0168", utilde: "\u0169", utri: "\u25B5", utrif: "\u25B4", uuarr: "\u21C8", Uuml: "\xDC", uuml: "\xFC", uwangle: "\u29A7", vangrt: "\u299C", varepsilon: "\u03F5", varkappa: "\u03F0", varnothing: "\u2205", varphi: "\u03D5", varpi: "\u03D6", varpropto: "\u221D", varr: "\u2195", vArr: "\u21D5", varrho: "\u03F1", varsigma: "\u03C2", varsubsetneq: "\u228A\uFE00", varsubsetneqq: "\u2ACB\uFE00", varsupsetneq: "\u228B\uFE00", varsupsetneqq: "\u2ACC\uFE00", vartheta: "\u03D1", vartriangleleft: "\u22B2", vartriangleright: "\u22B3", vBar: "\u2AE8", Vbar: "\u2AEB", vBarv: "\u2AE9", Vcy: "\u0412", vcy: "\u0432", vdash: "\u22A2", vDash: "\u22A8", Vdash: "\u22A9", VDash: "\u22AB", Vdashl: "\u2AE6", veebar: "\u22BB", vee: "\u2228", Vee: "\u22C1", veeeq: "\u225A", vellip: "\u22EE", verbar: "|", Verbar: "\u2016", vert: "|", Vert: "\u2016", VerticalBar: "\u2223", VerticalLine: "|", VerticalSeparator: "\u2758", VerticalTilde: "\u2240", VeryThinSpace: "\u200A", Vfr: "\u{1D519}", vfr: "\u{1D533}", vltri: "\u22B2", vnsub: "\u2282\u20D2", vnsup: "\u2283\u20D2", Vopf: "\u{1D54D}", vopf: "\u{1D567}", vprop: "\u221D", vrtri: "\u22B3", Vscr: "\u{1D4B1}", vscr: "\u{1D4CB}", vsubnE: "\u2ACB\uFE00", vsubne: "\u228A\uFE00", vsupnE: "\u2ACC\uFE00", vsupne: "\u228B\uFE00", Vvdash: "\u22AA", vzigzag: "\u299A", Wcirc: "\u0174", wcirc: "\u0175", wedbar: "\u2A5F", wedge: "\u2227", Wedge: "\u22C0", wedgeq: "\u2259", weierp: "\u2118", Wfr: "\u{1D51A}", wfr: "\u{1D534}", Wopf: "\u{1D54E}", wopf: "\u{1D568}", wp: "\u2118", wr: "\u2240", wreath: "\u2240", Wscr: "\u{1D4B2}", wscr: "\u{1D4CC}", xcap: "\u22C2", xcirc: "\u25EF", xcup: "\u22C3", xdtri: "\u25BD", Xfr: "\u{1D51B}", xfr: "\u{1D535}", xharr: "\u27F7", xhArr: "\u27FA", Xi: "\u039E", xi: "\u03BE", xlarr: "\u27F5", xlArr: "\u27F8", xmap: "\u27FC", xnis: "\u22FB", xodot: "\u2A00", Xopf: "\u{1D54F}", xopf: "\u{1D569}", xoplus: "\u2A01", xotime: "\u2A02", xrarr: "\u27F6", xrArr: "\u27F9", Xscr: "\u{1D4B3}", xscr: "\u{1D4CD}", xsqcup: "\u2A06", xuplus: "\u2A04", xutri: "\u25B3", xvee: "\u22C1", xwedge: "\u22C0", Yacute: "\xDD", yacute: "\xFD", YAcy: "\u042F", yacy: "\u044F", Ycirc: "\u0176", ycirc: "\u0177", Ycy: "\u042B", ycy: "\u044B", yen: "\xA5", Yfr: "\u{1D51C}", yfr: "\u{1D536}", YIcy: "\u0407", yicy: "\u0457", Yopf: "\u{1D550}", yopf: "\u{1D56A}", Yscr: "\u{1D4B4}", yscr: "\u{1D4CE}", YUcy: "\u042E", yucy: "\u044E", yuml: "\xFF", Yuml: "\u0178", Zacute: "\u0179", zacute: "\u017A", Zcaron: "\u017D", zcaron: "\u017E", Zcy: "\u0417", zcy: "\u0437", Zdot: "\u017B", zdot: "\u017C", zeetrf: "\u2128", ZeroWidthSpace: "\u200B", Zeta: "\u0396", zeta: "\u03B6", zfr: "\u{1D537}", Zfr: "\u2128", ZHcy: "\u0416", zhcy: "\u0436", zigrarr: "\u21DD", zopf: "\u{1D56B}", Zopf: "\u2124", Zscr: "\u{1D4B5}", zscr: "\u{1D4CF}", zwj: "\u200D", zwnj: "\u200C" };
  }
});

// node_modules/markdown-it/lib/common/entities.js
var require_entities2 = __commonJS({
  "node_modules/markdown-it/lib/common/entities.js"(exports, module) {
    "use strict";
    module.exports = require_entities();
  }
});

// node_modules/uc.micro/categories/P/regex.js
var require_regex = __commonJS({
  "node_modules/uc.micro/categories/P/regex.js"(exports, module) {
    module.exports = /[!-#%-\*,-\/:;\?@\[-\]_\{\}\xA1\xA7\xAB\xB6\xB7\xBB\xBF\u037E\u0387\u055A-\u055F\u0589\u058A\u05BE\u05C0\u05C3\u05C6\u05F3\u05F4\u0609\u060A\u060C\u060D\u061B\u061E\u061F\u066A-\u066D\u06D4\u0700-\u070D\u07F7-\u07F9\u0830-\u083E\u085E\u0964\u0965\u0970\u09FD\u0A76\u0AF0\u0C84\u0DF4\u0E4F\u0E5A\u0E5B\u0F04-\u0F12\u0F14\u0F3A-\u0F3D\u0F85\u0FD0-\u0FD4\u0FD9\u0FDA\u104A-\u104F\u10FB\u1360-\u1368\u1400\u166D\u166E\u169B\u169C\u16EB-\u16ED\u1735\u1736\u17D4-\u17D6\u17D8-\u17DA\u1800-\u180A\u1944\u1945\u1A1E\u1A1F\u1AA0-\u1AA6\u1AA8-\u1AAD\u1B5A-\u1B60\u1BFC-\u1BFF\u1C3B-\u1C3F\u1C7E\u1C7F\u1CC0-\u1CC7\u1CD3\u2010-\u2027\u2030-\u2043\u2045-\u2051\u2053-\u205E\u207D\u207E\u208D\u208E\u2308-\u230B\u2329\u232A\u2768-\u2775\u27C5\u27C6\u27E6-\u27EF\u2983-\u2998\u29D8-\u29DB\u29FC\u29FD\u2CF9-\u2CFC\u2CFE\u2CFF\u2D70\u2E00-\u2E2E\u2E30-\u2E4E\u3001-\u3003\u3008-\u3011\u3014-\u301F\u3030\u303D\u30A0\u30FB\uA4FE\uA4FF\uA60D-\uA60F\uA673\uA67E\uA6F2-\uA6F7\uA874-\uA877\uA8CE\uA8CF\uA8F8-\uA8FA\uA8FC\uA92E\uA92F\uA95F\uA9C1-\uA9CD\uA9DE\uA9DF\uAA5C-\uAA5F\uAADE\uAADF\uAAF0\uAAF1\uABEB\uFD3E\uFD3F\uFE10-\uFE19\uFE30-\uFE52\uFE54-\uFE61\uFE63\uFE68\uFE6A\uFE6B\uFF01-\uFF03\uFF05-\uFF0A\uFF0C-\uFF0F\uFF1A\uFF1B\uFF1F\uFF20\uFF3B-\uFF3D\uFF3F\uFF5B\uFF5D\uFF5F-\uFF65]|\uD800[\uDD00-\uDD02\uDF9F\uDFD0]|\uD801\uDD6F|\uD802[\uDC57\uDD1F\uDD3F\uDE50-\uDE58\uDE7F\uDEF0-\uDEF6\uDF39-\uDF3F\uDF99-\uDF9C]|\uD803[\uDF55-\uDF59]|\uD804[\uDC47-\uDC4D\uDCBB\uDCBC\uDCBE-\uDCC1\uDD40-\uDD43\uDD74\uDD75\uDDC5-\uDDC8\uDDCD\uDDDB\uDDDD-\uDDDF\uDE38-\uDE3D\uDEA9]|\uD805[\uDC4B-\uDC4F\uDC5B\uDC5D\uDCC6\uDDC1-\uDDD7\uDE41-\uDE43\uDE60-\uDE6C\uDF3C-\uDF3E]|\uD806[\uDC3B\uDE3F-\uDE46\uDE9A-\uDE9C\uDE9E-\uDEA2]|\uD807[\uDC41-\uDC45\uDC70\uDC71\uDEF7\uDEF8]|\uD809[\uDC70-\uDC74]|\uD81A[\uDE6E\uDE6F\uDEF5\uDF37-\uDF3B\uDF44]|\uD81B[\uDE97-\uDE9A]|\uD82F\uDC9F|\uD836[\uDE87-\uDE8B]|\uD83A[\uDD5E\uDD5F]/;
  }
});

// node_modules/mdurl/encode.js
var require_encode = __commonJS({
  "node_modules/mdurl/encode.js"(exports, module) {
    "use strict";
    var encodeCache = {};
    function getEncodeCache(exclude) {
      var i3, ch, cache3 = encodeCache[exclude];
      if (cache3) {
        return cache3;
      }
      cache3 = encodeCache[exclude] = [];
      for (i3 = 0; i3 < 128; i3++) {
        ch = String.fromCharCode(i3);
        if (/^[0-9a-z]$/i.test(ch)) {
          cache3.push(ch);
        } else {
          cache3.push("%" + ("0" + i3.toString(16).toUpperCase()).slice(-2));
        }
      }
      for (i3 = 0; i3 < exclude.length; i3++) {
        cache3[exclude.charCodeAt(i3)] = exclude[i3];
      }
      return cache3;
    }
    function encode(string, exclude, keepEscaped) {
      var i3, l3, code, nextCode, cache3, result2 = "";
      if (typeof exclude !== "string") {
        keepEscaped = exclude;
        exclude = encode.defaultChars;
      }
      if (typeof keepEscaped === "undefined") {
        keepEscaped = true;
      }
      cache3 = getEncodeCache(exclude);
      for (i3 = 0, l3 = string.length; i3 < l3; i3++) {
        code = string.charCodeAt(i3);
        if (keepEscaped && code === 37 && i3 + 2 < l3) {
          if (/^[0-9a-f]{2}$/i.test(string.slice(i3 + 1, i3 + 3))) {
            result2 += string.slice(i3, i3 + 3);
            i3 += 2;
            continue;
          }
        }
        if (code < 128) {
          result2 += cache3[code];
          continue;
        }
        if (code >= 55296 && code <= 57343) {
          if (code >= 55296 && code <= 56319 && i3 + 1 < l3) {
            nextCode = string.charCodeAt(i3 + 1);
            if (nextCode >= 56320 && nextCode <= 57343) {
              result2 += encodeURIComponent(string[i3] + string[i3 + 1]);
              i3++;
              continue;
            }
          }
          result2 += "%EF%BF%BD";
          continue;
        }
        result2 += encodeURIComponent(string[i3]);
      }
      return result2;
    }
    encode.defaultChars = ";/?:@&=+$,-_.!~*'()#";
    encode.componentChars = "-_.!~*'()";
    module.exports = encode;
  }
});

// node_modules/mdurl/decode.js
var require_decode = __commonJS({
  "node_modules/mdurl/decode.js"(exports, module) {
    "use strict";
    var decodeCache = {};
    function getDecodeCache(exclude) {
      var i3, ch, cache3 = decodeCache[exclude];
      if (cache3) {
        return cache3;
      }
      cache3 = decodeCache[exclude] = [];
      for (i3 = 0; i3 < 128; i3++) {
        ch = String.fromCharCode(i3);
        cache3.push(ch);
      }
      for (i3 = 0; i3 < exclude.length; i3++) {
        ch = exclude.charCodeAt(i3);
        cache3[ch] = "%" + ("0" + ch.toString(16).toUpperCase()).slice(-2);
      }
      return cache3;
    }
    function decode(string, exclude) {
      var cache3;
      if (typeof exclude !== "string") {
        exclude = decode.defaultChars;
      }
      cache3 = getDecodeCache(exclude);
      return string.replace(/(%[a-f0-9]{2})+/gi, function(seq) {
        var i3, l3, b1, b22, b3, b4, chr, result2 = "";
        for (i3 = 0, l3 = seq.length; i3 < l3; i3 += 3) {
          b1 = parseInt(seq.slice(i3 + 1, i3 + 3), 16);
          if (b1 < 128) {
            result2 += cache3[b1];
            continue;
          }
          if ((b1 & 224) === 192 && i3 + 3 < l3) {
            b22 = parseInt(seq.slice(i3 + 4, i3 + 6), 16);
            if ((b22 & 192) === 128) {
              chr = b1 << 6 & 1984 | b22 & 63;
              if (chr < 128) {
                result2 += "\uFFFD\uFFFD";
              } else {
                result2 += String.fromCharCode(chr);
              }
              i3 += 3;
              continue;
            }
          }
          if ((b1 & 240) === 224 && i3 + 6 < l3) {
            b22 = parseInt(seq.slice(i3 + 4, i3 + 6), 16);
            b3 = parseInt(seq.slice(i3 + 7, i3 + 9), 16);
            if ((b22 & 192) === 128 && (b3 & 192) === 128) {
              chr = b1 << 12 & 61440 | b22 << 6 & 4032 | b3 & 63;
              if (chr < 2048 || chr >= 55296 && chr <= 57343) {
                result2 += "\uFFFD\uFFFD\uFFFD";
              } else {
                result2 += String.fromCharCode(chr);
              }
              i3 += 6;
              continue;
            }
          }
          if ((b1 & 248) === 240 && i3 + 9 < l3) {
            b22 = parseInt(seq.slice(i3 + 4, i3 + 6), 16);
            b3 = parseInt(seq.slice(i3 + 7, i3 + 9), 16);
            b4 = parseInt(seq.slice(i3 + 10, i3 + 12), 16);
            if ((b22 & 192) === 128 && (b3 & 192) === 128 && (b4 & 192) === 128) {
              chr = b1 << 18 & 1835008 | b22 << 12 & 258048 | b3 << 6 & 4032 | b4 & 63;
              if (chr < 65536 || chr > 1114111) {
                result2 += "\uFFFD\uFFFD\uFFFD\uFFFD";
              } else {
                chr -= 65536;
                result2 += String.fromCharCode(55296 + (chr >> 10), 56320 + (chr & 1023));
              }
              i3 += 9;
              continue;
            }
          }
          result2 += "\uFFFD";
        }
        return result2;
      });
    }
    decode.defaultChars = ";/?:@&=+$,#";
    decode.componentChars = "";
    module.exports = decode;
  }
});

// node_modules/mdurl/format.js
var require_format = __commonJS({
  "node_modules/mdurl/format.js"(exports, module) {
    "use strict";
    module.exports = function format(url2) {
      var result2 = "";
      result2 += url2.protocol || "";
      result2 += url2.slashes ? "//" : "";
      result2 += url2.auth ? url2.auth + "@" : "";
      if (url2.hostname && url2.hostname.indexOf(":") !== -1) {
        result2 += "[" + url2.hostname + "]";
      } else {
        result2 += url2.hostname || "";
      }
      result2 += url2.port ? ":" + url2.port : "";
      result2 += url2.pathname || "";
      result2 += url2.search || "";
      result2 += url2.hash || "";
      return result2;
    };
  }
});

// node_modules/mdurl/parse.js
var require_parse = __commonJS({
  "node_modules/mdurl/parse.js"(exports, module) {
    "use strict";
    function Url() {
      this.protocol = null;
      this.slashes = null;
      this.auth = null;
      this.port = null;
      this.hostname = null;
      this.hash = null;
      this.search = null;
      this.pathname = null;
    }
    var protocolPattern = /^([a-z0-9.+-]+:)/i;
    var portPattern = /:[0-9]*$/;
    var simplePathPattern = /^(\/\/?(?!\/)[^\?\s]*)(\?[^\s]*)?$/;
    var delims = ["<", ">", '"', "`", " ", "\r", "\n", "	"];
    var unwise = ["{", "}", "|", "\\", "^", "`"].concat(delims);
    var autoEscape = ["'"].concat(unwise);
    var nonHostChars = ["%", "/", "?", ";", "#"].concat(autoEscape);
    var hostEndingChars = ["/", "?", "#"];
    var hostnameMaxLen = 255;
    var hostnamePartPattern = /^[+a-z0-9A-Z_-]{0,63}$/;
    var hostnamePartStart = /^([+a-z0-9A-Z_-]{0,63})(.*)$/;
    var hostlessProtocol = {
      "javascript": true,
      "javascript:": true
    };
    var slashedProtocol = {
      "http": true,
      "https": true,
      "ftp": true,
      "gopher": true,
      "file": true,
      "http:": true,
      "https:": true,
      "ftp:": true,
      "gopher:": true,
      "file:": true
    };
    function urlParse(url2, slashesDenoteHost) {
      if (url2 && url2 instanceof Url) {
        return url2;
      }
      var u3 = new Url();
      u3.parse(url2, slashesDenoteHost);
      return u3;
    }
    Url.prototype.parse = function(url2, slashesDenoteHost) {
      var i3, l3, lowerProto, hec, slashes, rest2 = url2;
      rest2 = rest2.trim();
      if (!slashesDenoteHost && url2.split("#").length === 1) {
        var simplePath = simplePathPattern.exec(rest2);
        if (simplePath) {
          this.pathname = simplePath[1];
          if (simplePath[2]) {
            this.search = simplePath[2];
          }
          return this;
        }
      }
      var proto = protocolPattern.exec(rest2);
      if (proto) {
        proto = proto[0];
        lowerProto = proto.toLowerCase();
        this.protocol = proto;
        rest2 = rest2.substr(proto.length);
      }
      if (slashesDenoteHost || proto || rest2.match(/^\/\/[^@\/]+@[^@\/]+/)) {
        slashes = rest2.substr(0, 2) === "//";
        if (slashes && !(proto && hostlessProtocol[proto])) {
          rest2 = rest2.substr(2);
          this.slashes = true;
        }
      }
      if (!hostlessProtocol[proto] && (slashes || proto && !slashedProtocol[proto])) {
        var hostEnd = -1;
        for (i3 = 0; i3 < hostEndingChars.length; i3++) {
          hec = rest2.indexOf(hostEndingChars[i3]);
          if (hec !== -1 && (hostEnd === -1 || hec < hostEnd)) {
            hostEnd = hec;
          }
        }
        var auth, atSign;
        if (hostEnd === -1) {
          atSign = rest2.lastIndexOf("@");
        } else {
          atSign = rest2.lastIndexOf("@", hostEnd);
        }
        if (atSign !== -1) {
          auth = rest2.slice(0, atSign);
          rest2 = rest2.slice(atSign + 1);
          this.auth = auth;
        }
        hostEnd = -1;
        for (i3 = 0; i3 < nonHostChars.length; i3++) {
          hec = rest2.indexOf(nonHostChars[i3]);
          if (hec !== -1 && (hostEnd === -1 || hec < hostEnd)) {
            hostEnd = hec;
          }
        }
        if (hostEnd === -1) {
          hostEnd = rest2.length;
        }
        if (rest2[hostEnd - 1] === ":") {
          hostEnd--;
        }
        var host = rest2.slice(0, hostEnd);
        rest2 = rest2.slice(hostEnd);
        this.parseHost(host);
        this.hostname = this.hostname || "";
        var ipv6Hostname = this.hostname[0] === "[" && this.hostname[this.hostname.length - 1] === "]";
        if (!ipv6Hostname) {
          var hostparts = this.hostname.split(/\./);
          for (i3 = 0, l3 = hostparts.length; i3 < l3; i3++) {
            var part = hostparts[i3];
            if (!part) {
              continue;
            }
            if (!part.match(hostnamePartPattern)) {
              var newpart = "";
              for (var j = 0, k2 = part.length; j < k2; j++) {
                if (part.charCodeAt(j) > 127) {
                  newpart += "x";
                } else {
                  newpart += part[j];
                }
              }
              if (!newpart.match(hostnamePartPattern)) {
                var validParts = hostparts.slice(0, i3);
                var notHost = hostparts.slice(i3 + 1);
                var bit = part.match(hostnamePartStart);
                if (bit) {
                  validParts.push(bit[1]);
                  notHost.unshift(bit[2]);
                }
                if (notHost.length) {
                  rest2 = notHost.join(".") + rest2;
                }
                this.hostname = validParts.join(".");
                break;
              }
            }
          }
        }
        if (this.hostname.length > hostnameMaxLen) {
          this.hostname = "";
        }
        if (ipv6Hostname) {
          this.hostname = this.hostname.substr(1, this.hostname.length - 2);
        }
      }
      var hash = rest2.indexOf("#");
      if (hash !== -1) {
        this.hash = rest2.substr(hash);
        rest2 = rest2.slice(0, hash);
      }
      var qm = rest2.indexOf("?");
      if (qm !== -1) {
        this.search = rest2.substr(qm);
        rest2 = rest2.slice(0, qm);
      }
      if (rest2) {
        this.pathname = rest2;
      }
      if (slashedProtocol[lowerProto] && this.hostname && !this.pathname) {
        this.pathname = "";
      }
      return this;
    };
    Url.prototype.parseHost = function(host) {
      var port = portPattern.exec(host);
      if (port) {
        port = port[0];
        if (port !== ":") {
          this.port = port.substr(1);
        }
        host = host.substr(0, host.length - port.length);
      }
      if (host) {
        this.hostname = host;
      }
    };
    module.exports = urlParse;
  }
});

// node_modules/mdurl/index.js
var require_mdurl = __commonJS({
  "node_modules/mdurl/index.js"(exports, module) {
    "use strict";
    module.exports.encode = require_encode();
    module.exports.decode = require_decode();
    module.exports.format = require_format();
    module.exports.parse = require_parse();
  }
});

// node_modules/uc.micro/properties/Any/regex.js
var require_regex2 = __commonJS({
  "node_modules/uc.micro/properties/Any/regex.js"(exports, module) {
    module.exports = /[\0-\uD7FF\uE000-\uFFFF]|[\uD800-\uDBFF][\uDC00-\uDFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF]/;
  }
});

// node_modules/uc.micro/categories/Cc/regex.js
var require_regex3 = __commonJS({
  "node_modules/uc.micro/categories/Cc/regex.js"(exports, module) {
    module.exports = /[\0-\x1F\x7F-\x9F]/;
  }
});

// node_modules/uc.micro/categories/Cf/regex.js
var require_regex4 = __commonJS({
  "node_modules/uc.micro/categories/Cf/regex.js"(exports, module) {
    module.exports = /[\xAD\u0600-\u0605\u061C\u06DD\u070F\u08E2\u180E\u200B-\u200F\u202A-\u202E\u2060-\u2064\u2066-\u206F\uFEFF\uFFF9-\uFFFB]|\uD804[\uDCBD\uDCCD]|\uD82F[\uDCA0-\uDCA3]|\uD834[\uDD73-\uDD7A]|\uDB40[\uDC01\uDC20-\uDC7F]/;
  }
});

// node_modules/uc.micro/categories/Z/regex.js
var require_regex5 = __commonJS({
  "node_modules/uc.micro/categories/Z/regex.js"(exports, module) {
    module.exports = /[ \xA0\u1680\u2000-\u200A\u2028\u2029\u202F\u205F\u3000]/;
  }
});

// node_modules/uc.micro/index.js
var require_uc = __commonJS({
  "node_modules/uc.micro/index.js"(exports) {
    "use strict";
    exports.Any = require_regex2();
    exports.Cc = require_regex3();
    exports.Cf = require_regex4();
    exports.P = require_regex();
    exports.Z = require_regex5();
  }
});

// node_modules/markdown-it/lib/common/utils.js
var require_utils = __commonJS({
  "node_modules/markdown-it/lib/common/utils.js"(exports) {
    "use strict";
    function _class(obj) {
      return Object.prototype.toString.call(obj);
    }
    function isString3(obj) {
      return _class(obj) === "[object String]";
    }
    var _hasOwnProperty = Object.prototype.hasOwnProperty;
    function has3(object2, key) {
      return _hasOwnProperty.call(object2, key);
    }
    function assign3(obj) {
      var sources = Array.prototype.slice.call(arguments, 1);
      sources.forEach(function(source) {
        if (!source) {
          return;
        }
        if (typeof source !== "object") {
          throw new TypeError(source + "must be object");
        }
        Object.keys(source).forEach(function(key) {
          obj[key] = source[key];
        });
      });
      return obj;
    }
    function arrayReplaceAt(src, pos, newElements) {
      return [].concat(src.slice(0, pos), newElements, src.slice(pos + 1));
    }
    function isValidEntityCode(c3) {
      if (c3 >= 55296 && c3 <= 57343) {
        return false;
      }
      if (c3 >= 64976 && c3 <= 65007) {
        return false;
      }
      if ((c3 & 65535) === 65535 || (c3 & 65535) === 65534) {
        return false;
      }
      if (c3 >= 0 && c3 <= 8) {
        return false;
      }
      if (c3 === 11) {
        return false;
      }
      if (c3 >= 14 && c3 <= 31) {
        return false;
      }
      if (c3 >= 127 && c3 <= 159) {
        return false;
      }
      if (c3 > 1114111) {
        return false;
      }
      return true;
    }
    function fromCodePoint(c3) {
      if (c3 > 65535) {
        c3 -= 65536;
        var surrogate1 = 55296 + (c3 >> 10), surrogate2 = 56320 + (c3 & 1023);
        return String.fromCharCode(surrogate1, surrogate2);
      }
      return String.fromCharCode(c3);
    }
    var UNESCAPE_MD_RE = /\\([!"#$%&'()*+,\-.\/:;<=>?@[\\\]^_`{|}~])/g;
    var ENTITY_RE = /&([a-z#][a-z0-9]{1,31});/gi;
    var UNESCAPE_ALL_RE = new RegExp(UNESCAPE_MD_RE.source + "|" + ENTITY_RE.source, "gi");
    var DIGITAL_ENTITY_TEST_RE = /^#((?:x[a-f0-9]{1,8}|[0-9]{1,8}))/i;
    var entities = require_entities2();
    function replaceEntityPattern(match, name) {
      var code = 0;
      if (has3(entities, name)) {
        return entities[name];
      }
      if (name.charCodeAt(0) === 35 && DIGITAL_ENTITY_TEST_RE.test(name)) {
        code = name[1].toLowerCase() === "x" ? parseInt(name.slice(2), 16) : parseInt(name.slice(1), 10);
        if (isValidEntityCode(code)) {
          return fromCodePoint(code);
        }
      }
      return match;
    }
    function unescapeMd(str) {
      if (str.indexOf("\\") < 0) {
        return str;
      }
      return str.replace(UNESCAPE_MD_RE, "$1");
    }
    function unescapeAll(str) {
      if (str.indexOf("\\") < 0 && str.indexOf("&") < 0) {
        return str;
      }
      return str.replace(UNESCAPE_ALL_RE, function(match, escaped, entity) {
        if (escaped) {
          return escaped;
        }
        return replaceEntityPattern(match, entity);
      });
    }
    var HTML_ESCAPE_TEST_RE = /[&<>"]/;
    var HTML_ESCAPE_REPLACE_RE = /[&<>"]/g;
    var HTML_REPLACEMENTS = {
      "&": "&amp;",
      "<": "&lt;",
      ">": "&gt;",
      '"': "&quot;"
    };
    function replaceUnsafeChar(ch) {
      return HTML_REPLACEMENTS[ch];
    }
    function escapeHtml(str) {
      if (HTML_ESCAPE_TEST_RE.test(str)) {
        return str.replace(HTML_ESCAPE_REPLACE_RE, replaceUnsafeChar);
      }
      return str;
    }
    var REGEXP_ESCAPE_RE = /[.?*+^$[\]\\(){}|-]/g;
    function escapeRE(str) {
      return str.replace(REGEXP_ESCAPE_RE, "\\$&");
    }
    function isSpace(code) {
      switch (code) {
        case 9:
        case 32:
          return true;
      }
      return false;
    }
    function isWhiteSpace(code) {
      if (code >= 8192 && code <= 8202) {
        return true;
      }
      switch (code) {
        case 9:
        // \t
        case 10:
        // \n
        case 11:
        // \v
        case 12:
        // \f
        case 13:
        // \r
        case 32:
        case 160:
        case 5760:
        case 8239:
        case 8287:
        case 12288:
          return true;
      }
      return false;
    }
    var UNICODE_PUNCT_RE = require_regex();
    function isPunctChar(ch) {
      return UNICODE_PUNCT_RE.test(ch);
    }
    function isMdAsciiPunct(ch) {
      switch (ch) {
        case 33:
        case 34:
        case 35:
        case 36:
        case 37:
        case 38:
        case 39:
        case 40:
        case 41:
        case 42:
        case 43:
        case 44:
        case 45:
        case 46:
        case 47:
        case 58:
        case 59:
        case 60:
        case 61:
        case 62:
        case 63:
        case 64:
        case 91:
        case 92:
        case 93:
        case 94:
        case 95:
        case 96:
        case 123:
        case 124:
        case 125:
        case 126:
          return true;
        default:
          return false;
      }
    }
    function normalizeReference(str) {
      str = str.trim().replace(/\s+/g, " ");
      if ("\u1E9E".toLowerCase() === "\u1E7E") {
        str = str.replace(/ẞ/g, "\xDF");
      }
      return str.toLowerCase().toUpperCase();
    }
    exports.lib = {};
    exports.lib.mdurl = require_mdurl();
    exports.lib.ucmicro = require_uc();
    exports.assign = assign3;
    exports.isString = isString3;
    exports.has = has3;
    exports.unescapeMd = unescapeMd;
    exports.unescapeAll = unescapeAll;
    exports.isValidEntityCode = isValidEntityCode;
    exports.fromCodePoint = fromCodePoint;
    exports.escapeHtml = escapeHtml;
    exports.arrayReplaceAt = arrayReplaceAt;
    exports.isSpace = isSpace;
    exports.isWhiteSpace = isWhiteSpace;
    exports.isMdAsciiPunct = isMdAsciiPunct;
    exports.isPunctChar = isPunctChar;
    exports.escapeRE = escapeRE;
    exports.normalizeReference = normalizeReference;
  }
});

// node_modules/markdown-it/lib/helpers/parse_link_label.js
var require_parse_link_label = __commonJS({
  "node_modules/markdown-it/lib/helpers/parse_link_label.js"(exports, module) {
    "use strict";
    module.exports = function parseLinkLabel(state, start, disableNested) {
      var level, found2, marker, prevPos, labelEnd = -1, max3 = state.posMax, oldPos = state.pos;
      state.pos = start + 1;
      level = 1;
      while (state.pos < max3) {
        marker = state.src.charCodeAt(state.pos);
        if (marker === 93) {
          level--;
          if (level === 0) {
            found2 = true;
            break;
          }
        }
        prevPos = state.pos;
        state.md.inline.skipToken(state);
        if (marker === 91) {
          if (prevPos === state.pos - 1) {
            level++;
          } else if (disableNested) {
            state.pos = oldPos;
            return -1;
          }
        }
      }
      if (found2) {
        labelEnd = state.pos;
      }
      state.pos = oldPos;
      return labelEnd;
    };
  }
});

// node_modules/markdown-it/lib/helpers/parse_link_destination.js
var require_parse_link_destination = __commonJS({
  "node_modules/markdown-it/lib/helpers/parse_link_destination.js"(exports, module) {
    "use strict";
    var unescapeAll = require_utils().unescapeAll;
    module.exports = function parseLinkDestination(str, pos, max3) {
      var code, level, lines = 0, start = pos, result2 = {
        ok: false,
        pos: 0,
        lines: 0,
        str: ""
      };
      if (str.charCodeAt(pos) === 60) {
        pos++;
        while (pos < max3) {
          code = str.charCodeAt(pos);
          if (code === 10) {
            return result2;
          }
          if (code === 60) {
            return result2;
          }
          if (code === 62) {
            result2.pos = pos + 1;
            result2.str = unescapeAll(str.slice(start + 1, pos));
            result2.ok = true;
            return result2;
          }
          if (code === 92 && pos + 1 < max3) {
            pos += 2;
            continue;
          }
          pos++;
        }
        return result2;
      }
      level = 0;
      while (pos < max3) {
        code = str.charCodeAt(pos);
        if (code === 32) {
          break;
        }
        if (code < 32 || code === 127) {
          break;
        }
        if (code === 92 && pos + 1 < max3) {
          if (str.charCodeAt(pos + 1) === 32) {
            break;
          }
          pos += 2;
          continue;
        }
        if (code === 40) {
          level++;
          if (level > 32) {
            return result2;
          }
        }
        if (code === 41) {
          if (level === 0) {
            break;
          }
          level--;
        }
        pos++;
      }
      if (start === pos) {
        return result2;
      }
      if (level !== 0) {
        return result2;
      }
      result2.str = unescapeAll(str.slice(start, pos));
      result2.lines = lines;
      result2.pos = pos;
      result2.ok = true;
      return result2;
    };
  }
});

// node_modules/markdown-it/lib/helpers/parse_link_title.js
var require_parse_link_title = __commonJS({
  "node_modules/markdown-it/lib/helpers/parse_link_title.js"(exports, module) {
    "use strict";
    var unescapeAll = require_utils().unescapeAll;
    module.exports = function parseLinkTitle(str, pos, max3) {
      var code, marker, lines = 0, start = pos, result2 = {
        ok: false,
        pos: 0,
        lines: 0,
        str: ""
      };
      if (pos >= max3) {
        return result2;
      }
      marker = str.charCodeAt(pos);
      if (marker !== 34 && marker !== 39 && marker !== 40) {
        return result2;
      }
      pos++;
      if (marker === 40) {
        marker = 41;
      }
      while (pos < max3) {
        code = str.charCodeAt(pos);
        if (code === marker) {
          result2.pos = pos + 1;
          result2.lines = lines;
          result2.str = unescapeAll(str.slice(start + 1, pos));
          result2.ok = true;
          return result2;
        } else if (code === 40 && marker === 41) {
          return result2;
        } else if (code === 10) {
          lines++;
        } else if (code === 92 && pos + 1 < max3) {
          pos++;
          if (str.charCodeAt(pos) === 10) {
            lines++;
          }
        }
        pos++;
      }
      return result2;
    };
  }
});

// node_modules/markdown-it/lib/helpers/index.js
var require_helpers = __commonJS({
  "node_modules/markdown-it/lib/helpers/index.js"(exports) {
    "use strict";
    exports.parseLinkLabel = require_parse_link_label();
    exports.parseLinkDestination = require_parse_link_destination();
    exports.parseLinkTitle = require_parse_link_title();
  }
});

// node_modules/markdown-it/lib/renderer.js
var require_renderer = __commonJS({
  "node_modules/markdown-it/lib/renderer.js"(exports, module) {
    "use strict";
    var assign3 = require_utils().assign;
    var unescapeAll = require_utils().unescapeAll;
    var escapeHtml = require_utils().escapeHtml;
    var default_rules = {};
    default_rules.code_inline = function(tokens, idx, options2, env, slf) {
      var token = tokens[idx];
      return "<code" + slf.renderAttrs(token) + ">" + escapeHtml(tokens[idx].content) + "</code>";
    };
    default_rules.code_block = function(tokens, idx, options2, env, slf) {
      var token = tokens[idx];
      return "<pre" + slf.renderAttrs(token) + "><code>" + escapeHtml(tokens[idx].content) + "</code></pre>\n";
    };
    default_rules.fence = function(tokens, idx, options2, env, slf) {
      var token = tokens[idx], info = token.info ? unescapeAll(token.info).trim() : "", langName = "", langAttrs = "", highlighted, i3, arr, tmpAttrs, tmpToken;
      if (info) {
        arr = info.split(/(\s+)/g);
        langName = arr[0];
        langAttrs = arr.slice(2).join("");
      }
      if (options2.highlight) {
        highlighted = options2.highlight(token.content, langName, langAttrs) || escapeHtml(token.content);
      } else {
        highlighted = escapeHtml(token.content);
      }
      if (highlighted.indexOf("<pre") === 0) {
        return highlighted + "\n";
      }
      if (info) {
        i3 = token.attrIndex("class");
        tmpAttrs = token.attrs ? token.attrs.slice() : [];
        if (i3 < 0) {
          tmpAttrs.push(["class", options2.langPrefix + langName]);
        } else {
          tmpAttrs[i3] = tmpAttrs[i3].slice();
          tmpAttrs[i3][1] += " " + options2.langPrefix + langName;
        }
        tmpToken = {
          attrs: tmpAttrs
        };
        return "<pre><code" + slf.renderAttrs(tmpToken) + ">" + highlighted + "</code></pre>\n";
      }
      return "<pre><code" + slf.renderAttrs(token) + ">" + highlighted + "</code></pre>\n";
    };
    default_rules.image = function(tokens, idx, options2, env, slf) {
      var token = tokens[idx];
      token.attrs[token.attrIndex("alt")][1] = slf.renderInlineAsText(token.children, options2, env);
      return slf.renderToken(tokens, idx, options2);
    };
    default_rules.hardbreak = function(tokens, idx, options2) {
      return options2.xhtmlOut ? "<br />\n" : "<br>\n";
    };
    default_rules.softbreak = function(tokens, idx, options2) {
      return options2.breaks ? options2.xhtmlOut ? "<br />\n" : "<br>\n" : "\n";
    };
    default_rules.text = function(tokens, idx) {
      return escapeHtml(tokens[idx].content);
    };
    default_rules.html_block = function(tokens, idx) {
      return tokens[idx].content;
    };
    default_rules.html_inline = function(tokens, idx) {
      return tokens[idx].content;
    };
    function Renderer2() {
      this.rules = assign3({}, default_rules);
    }
    Renderer2.prototype.renderAttrs = function renderAttrs(token) {
      var i3, l3, result2;
      if (!token.attrs) {
        return "";
      }
      result2 = "";
      for (i3 = 0, l3 = token.attrs.length; i3 < l3; i3++) {
        result2 += " " + escapeHtml(token.attrs[i3][0]) + '="' + escapeHtml(token.attrs[i3][1]) + '"';
      }
      return result2;
    };
    Renderer2.prototype.renderToken = function renderToken(tokens, idx, options2) {
      var nextToken, result2 = "", needLf = false, token = tokens[idx];
      if (token.hidden) {
        return "";
      }
      if (token.block && token.nesting !== -1 && idx && tokens[idx - 1].hidden) {
        result2 += "\n";
      }
      result2 += (token.nesting === -1 ? "</" : "<") + token.tag;
      result2 += this.renderAttrs(token);
      if (token.nesting === 0 && options2.xhtmlOut) {
        result2 += " /";
      }
      if (token.block) {
        needLf = true;
        if (token.nesting === 1) {
          if (idx + 1 < tokens.length) {
            nextToken = tokens[idx + 1];
            if (nextToken.type === "inline" || nextToken.hidden) {
              needLf = false;
            } else if (nextToken.nesting === -1 && nextToken.tag === token.tag) {
              needLf = false;
            }
          }
        }
      }
      result2 += needLf ? ">\n" : ">";
      return result2;
    };
    Renderer2.prototype.renderInline = function(tokens, options2, env) {
      var type, result2 = "", rules = this.rules;
      for (var i3 = 0, len = tokens.length; i3 < len; i3++) {
        type = tokens[i3].type;
        if (typeof rules[type] !== "undefined") {
          result2 += rules[type](tokens, i3, options2, env, this);
        } else {
          result2 += this.renderToken(tokens, i3, options2);
        }
      }
      return result2;
    };
    Renderer2.prototype.renderInlineAsText = function(tokens, options2, env) {
      var result2 = "";
      for (var i3 = 0, len = tokens.length; i3 < len; i3++) {
        if (tokens[i3].type === "text") {
          result2 += tokens[i3].content;
        } else if (tokens[i3].type === "image") {
          result2 += this.renderInlineAsText(tokens[i3].children, options2, env);
        } else if (tokens[i3].type === "softbreak") {
          result2 += "\n";
        }
      }
      return result2;
    };
    Renderer2.prototype.render = function(tokens, options2, env) {
      var i3, len, type, result2 = "", rules = this.rules;
      for (i3 = 0, len = tokens.length; i3 < len; i3++) {
        type = tokens[i3].type;
        if (type === "inline") {
          result2 += this.renderInline(tokens[i3].children, options2, env);
        } else if (typeof rules[type] !== "undefined") {
          result2 += rules[tokens[i3].type](tokens, i3, options2, env, this);
        } else {
          result2 += this.renderToken(tokens, i3, options2, env);
        }
      }
      return result2;
    };
    module.exports = Renderer2;
  }
});

// node_modules/markdown-it/lib/ruler.js
var require_ruler = __commonJS({
  "node_modules/markdown-it/lib/ruler.js"(exports, module) {
    "use strict";
    function Ruler() {
      this.__rules__ = [];
      this.__cache__ = null;
    }
    Ruler.prototype.__find__ = function(name) {
      for (var i3 = 0; i3 < this.__rules__.length; i3++) {
        if (this.__rules__[i3].name === name) {
          return i3;
        }
      }
      return -1;
    };
    Ruler.prototype.__compile__ = function() {
      var self2 = this;
      var chains = [""];
      self2.__rules__.forEach(function(rule) {
        if (!rule.enabled) {
          return;
        }
        rule.alt.forEach(function(altName) {
          if (chains.indexOf(altName) < 0) {
            chains.push(altName);
          }
        });
      });
      self2.__cache__ = {};
      chains.forEach(function(chain3) {
        self2.__cache__[chain3] = [];
        self2.__rules__.forEach(function(rule) {
          if (!rule.enabled) {
            return;
          }
          if (chain3 && rule.alt.indexOf(chain3) < 0) {
            return;
          }
          self2.__cache__[chain3].push(rule.fn);
        });
      });
    };
    Ruler.prototype.at = function(name, fn, options2) {
      var index = this.__find__(name);
      var opt = options2 || {};
      if (index === -1) {
        throw new Error("Parser rule not found: " + name);
      }
      this.__rules__[index].fn = fn;
      this.__rules__[index].alt = opt.alt || [];
      this.__cache__ = null;
    };
    Ruler.prototype.before = function(beforeName, ruleName, fn, options2) {
      var index = this.__find__(beforeName);
      var opt = options2 || {};
      if (index === -1) {
        throw new Error("Parser rule not found: " + beforeName);
      }
      this.__rules__.splice(index, 0, {
        name: ruleName,
        enabled: true,
        fn,
        alt: opt.alt || []
      });
      this.__cache__ = null;
    };
    Ruler.prototype.after = function(afterName, ruleName, fn, options2) {
      var index = this.__find__(afterName);
      var opt = options2 || {};
      if (index === -1) {
        throw new Error("Parser rule not found: " + afterName);
      }
      this.__rules__.splice(index + 1, 0, {
        name: ruleName,
        enabled: true,
        fn,
        alt: opt.alt || []
      });
      this.__cache__ = null;
    };
    Ruler.prototype.push = function(ruleName, fn, options2) {
      var opt = options2 || {};
      this.__rules__.push({
        name: ruleName,
        enabled: true,
        fn,
        alt: opt.alt || []
      });
      this.__cache__ = null;
    };
    Ruler.prototype.enable = function(list, ignoreInvalid) {
      if (!Array.isArray(list)) {
        list = [list];
      }
      var result2 = [];
      list.forEach(function(name) {
        var idx = this.__find__(name);
        if (idx < 0) {
          if (ignoreInvalid) {
            return;
          }
          throw new Error("Rules manager: invalid rule name " + name);
        }
        this.__rules__[idx].enabled = true;
        result2.push(name);
      }, this);
      this.__cache__ = null;
      return result2;
    };
    Ruler.prototype.enableOnly = function(list, ignoreInvalid) {
      if (!Array.isArray(list)) {
        list = [list];
      }
      this.__rules__.forEach(function(rule) {
        rule.enabled = false;
      });
      this.enable(list, ignoreInvalid);
    };
    Ruler.prototype.disable = function(list, ignoreInvalid) {
      if (!Array.isArray(list)) {
        list = [list];
      }
      var result2 = [];
      list.forEach(function(name) {
        var idx = this.__find__(name);
        if (idx < 0) {
          if (ignoreInvalid) {
            return;
          }
          throw new Error("Rules manager: invalid rule name " + name);
        }
        this.__rules__[idx].enabled = false;
        result2.push(name);
      }, this);
      this.__cache__ = null;
      return result2;
    };
    Ruler.prototype.getRules = function(chainName) {
      if (this.__cache__ === null) {
        this.__compile__();
      }
      return this.__cache__[chainName] || [];
    };
    module.exports = Ruler;
  }
});

// node_modules/markdown-it/lib/rules_core/normalize.js
var require_normalize = __commonJS({
  "node_modules/markdown-it/lib/rules_core/normalize.js"(exports, module) {
    "use strict";
    var NEWLINES_RE = /\r\n?|\n/g;
    var NULL_RE = /\0/g;
    module.exports = function normalize2(state) {
      var str;
      str = state.src.replace(NEWLINES_RE, "\n");
      str = str.replace(NULL_RE, "\uFFFD");
      state.src = str;
    };
  }
});

// node_modules/markdown-it/lib/rules_core/block.js
var require_block = __commonJS({
  "node_modules/markdown-it/lib/rules_core/block.js"(exports, module) {
    "use strict";
    module.exports = function block2(state) {
      var token;
      if (state.inlineMode) {
        token = new state.Token("inline", "", 0);
        token.content = state.src;
        token.map = [0, 1];
        token.children = [];
        state.tokens.push(token);
      } else {
        state.md.block.parse(state.src, state.md, state.env, state.tokens);
      }
    };
  }
});

// node_modules/markdown-it/lib/rules_core/inline.js
var require_inline = __commonJS({
  "node_modules/markdown-it/lib/rules_core/inline.js"(exports, module) {
    "use strict";
    module.exports = function inline2(state) {
      var tokens = state.tokens, tok, i3, l3;
      for (i3 = 0, l3 = tokens.length; i3 < l3; i3++) {
        tok = tokens[i3];
        if (tok.type === "inline") {
          state.md.inline.parse(tok.content, state.md, state.env, tok.children);
        }
      }
    };
  }
});

// node_modules/markdown-it/lib/rules_core/linkify.js
var require_linkify = __commonJS({
  "node_modules/markdown-it/lib/rules_core/linkify.js"(exports, module) {
    "use strict";
    var arrayReplaceAt = require_utils().arrayReplaceAt;
    function isLinkOpen(str) {
      return /^<a[>\s]/i.test(str);
    }
    function isLinkClose(str) {
      return /^<\/a\s*>/i.test(str);
    }
    module.exports = function linkify(state) {
      var i3, j, l3, tokens, token, currentToken, nodes2, ln, text, pos, lastPos, level, htmlLinkLevel, url2, fullUrl, urlText, blockTokens = state.tokens, links;
      if (!state.md.options.linkify) {
        return;
      }
      for (j = 0, l3 = blockTokens.length; j < l3; j++) {
        if (blockTokens[j].type !== "inline" || !state.md.linkify.pretest(blockTokens[j].content)) {
          continue;
        }
        tokens = blockTokens[j].children;
        htmlLinkLevel = 0;
        for (i3 = tokens.length - 1; i3 >= 0; i3--) {
          currentToken = tokens[i3];
          if (currentToken.type === "link_close") {
            i3--;
            while (tokens[i3].level !== currentToken.level && tokens[i3].type !== "link_open") {
              i3--;
            }
            continue;
          }
          if (currentToken.type === "html_inline") {
            if (isLinkOpen(currentToken.content) && htmlLinkLevel > 0) {
              htmlLinkLevel--;
            }
            if (isLinkClose(currentToken.content)) {
              htmlLinkLevel++;
            }
          }
          if (htmlLinkLevel > 0) {
            continue;
          }
          if (currentToken.type === "text" && state.md.linkify.test(currentToken.content)) {
            text = currentToken.content;
            links = state.md.linkify.match(text);
            nodes2 = [];
            level = currentToken.level;
            lastPos = 0;
            if (links.length > 0 && links[0].index === 0 && i3 > 0 && tokens[i3 - 1].type === "text_special") {
              links = links.slice(1);
            }
            for (ln = 0; ln < links.length; ln++) {
              url2 = links[ln].url;
              fullUrl = state.md.normalizeLink(url2);
              if (!state.md.validateLink(fullUrl)) {
                continue;
              }
              urlText = links[ln].text;
              if (!links[ln].schema) {
                urlText = state.md.normalizeLinkText("http://" + urlText).replace(/^http:\/\//, "");
              } else if (links[ln].schema === "mailto:" && !/^mailto:/i.test(urlText)) {
                urlText = state.md.normalizeLinkText("mailto:" + urlText).replace(/^mailto:/, "");
              } else {
                urlText = state.md.normalizeLinkText(urlText);
              }
              pos = links[ln].index;
              if (pos > lastPos) {
                token = new state.Token("text", "", 0);
                token.content = text.slice(lastPos, pos);
                token.level = level;
                nodes2.push(token);
              }
              token = new state.Token("link_open", "a", 1);
              token.attrs = [["href", fullUrl]];
              token.level = level++;
              token.markup = "linkify";
              token.info = "auto";
              nodes2.push(token);
              token = new state.Token("text", "", 0);
              token.content = urlText;
              token.level = level;
              nodes2.push(token);
              token = new state.Token("link_close", "a", -1);
              token.level = --level;
              token.markup = "linkify";
              token.info = "auto";
              nodes2.push(token);
              lastPos = links[ln].lastIndex;
            }
            if (lastPos < text.length) {
              token = new state.Token("text", "", 0);
              token.content = text.slice(lastPos);
              token.level = level;
              nodes2.push(token);
            }
            blockTokens[j].children = tokens = arrayReplaceAt(tokens, i3, nodes2);
          }
        }
      }
    };
  }
});

// node_modules/markdown-it/lib/rules_core/replacements.js
var require_replacements = __commonJS({
  "node_modules/markdown-it/lib/rules_core/replacements.js"(exports, module) {
    "use strict";
    var RARE_RE = /\+-|\.\.|\?\?\?\?|!!!!|,,|--/;
    var SCOPED_ABBR_TEST_RE = /\((c|tm|r)\)/i;
    var SCOPED_ABBR_RE = /\((c|tm|r)\)/ig;
    var SCOPED_ABBR = {
      c: "\xA9",
      r: "\xAE",
      tm: "\u2122"
    };
    function replaceFn(match, name) {
      return SCOPED_ABBR[name.toLowerCase()];
    }
    function replace_scoped(inlineTokens) {
      var i3, token, inside_autolink = 0;
      for (i3 = inlineTokens.length - 1; i3 >= 0; i3--) {
        token = inlineTokens[i3];
        if (token.type === "text" && !inside_autolink) {
          token.content = token.content.replace(SCOPED_ABBR_RE, replaceFn);
        }
        if (token.type === "link_open" && token.info === "auto") {
          inside_autolink--;
        }
        if (token.type === "link_close" && token.info === "auto") {
          inside_autolink++;
        }
      }
    }
    function replace_rare(inlineTokens) {
      var i3, token, inside_autolink = 0;
      for (i3 = inlineTokens.length - 1; i3 >= 0; i3--) {
        token = inlineTokens[i3];
        if (token.type === "text" && !inside_autolink) {
          if (RARE_RE.test(token.content)) {
            token.content = token.content.replace(/\+-/g, "\xB1").replace(/\.{2,}/g, "\u2026").replace(/([?!])…/g, "$1..").replace(/([?!]){4,}/g, "$1$1$1").replace(/,{2,}/g, ",").replace(/(^|[^-])---(?=[^-]|$)/mg, "$1\u2014").replace(/(^|\s)--(?=\s|$)/mg, "$1\u2013").replace(/(^|[^-\s])--(?=[^-\s]|$)/mg, "$1\u2013");
          }
        }
        if (token.type === "link_open" && token.info === "auto") {
          inside_autolink--;
        }
        if (token.type === "link_close" && token.info === "auto") {
          inside_autolink++;
        }
      }
    }
    module.exports = function replace2(state) {
      var blkIdx;
      if (!state.md.options.typographer) {
        return;
      }
      for (blkIdx = state.tokens.length - 1; blkIdx >= 0; blkIdx--) {
        if (state.tokens[blkIdx].type !== "inline") {
          continue;
        }
        if (SCOPED_ABBR_TEST_RE.test(state.tokens[blkIdx].content)) {
          replace_scoped(state.tokens[blkIdx].children);
        }
        if (RARE_RE.test(state.tokens[blkIdx].content)) {
          replace_rare(state.tokens[blkIdx].children);
        }
      }
    };
  }
});

// node_modules/markdown-it/lib/rules_core/smartquotes.js
var require_smartquotes = __commonJS({
  "node_modules/markdown-it/lib/rules_core/smartquotes.js"(exports, module) {
    "use strict";
    var isWhiteSpace = require_utils().isWhiteSpace;
    var isPunctChar = require_utils().isPunctChar;
    var isMdAsciiPunct = require_utils().isMdAsciiPunct;
    var QUOTE_TEST_RE = /['"]/;
    var QUOTE_RE = /['"]/g;
    var APOSTROPHE = "\u2019";
    function replaceAt(str, index, ch) {
      return str.slice(0, index) + ch + str.slice(index + 1);
    }
    function process_inlines(tokens, state) {
      var i3, token, text, t2, pos, max3, thisLevel, item, lastChar, nextChar, isLastPunctChar, isNextPunctChar, isLastWhiteSpace, isNextWhiteSpace, canOpen, canClose, j, isSingle, stack, openQuote, closeQuote;
      stack = [];
      for (i3 = 0; i3 < tokens.length; i3++) {
        token = tokens[i3];
        thisLevel = tokens[i3].level;
        for (j = stack.length - 1; j >= 0; j--) {
          if (stack[j].level <= thisLevel) {
            break;
          }
        }
        stack.length = j + 1;
        if (token.type !== "text") {
          continue;
        }
        text = token.content;
        pos = 0;
        max3 = text.length;
        OUTER:
          while (pos < max3) {
            QUOTE_RE.lastIndex = pos;
            t2 = QUOTE_RE.exec(text);
            if (!t2) {
              break;
            }
            canOpen = canClose = true;
            pos = t2.index + 1;
            isSingle = t2[0] === "'";
            lastChar = 32;
            if (t2.index - 1 >= 0) {
              lastChar = text.charCodeAt(t2.index - 1);
            } else {
              for (j = i3 - 1; j >= 0; j--) {
                if (tokens[j].type === "softbreak" || tokens[j].type === "hardbreak") break;
                if (!tokens[j].content) continue;
                lastChar = tokens[j].content.charCodeAt(tokens[j].content.length - 1);
                break;
              }
            }
            nextChar = 32;
            if (pos < max3) {
              nextChar = text.charCodeAt(pos);
            } else {
              for (j = i3 + 1; j < tokens.length; j++) {
                if (tokens[j].type === "softbreak" || tokens[j].type === "hardbreak") break;
                if (!tokens[j].content) continue;
                nextChar = tokens[j].content.charCodeAt(0);
                break;
              }
            }
            isLastPunctChar = isMdAsciiPunct(lastChar) || isPunctChar(String.fromCharCode(lastChar));
            isNextPunctChar = isMdAsciiPunct(nextChar) || isPunctChar(String.fromCharCode(nextChar));
            isLastWhiteSpace = isWhiteSpace(lastChar);
            isNextWhiteSpace = isWhiteSpace(nextChar);
            if (isNextWhiteSpace) {
              canOpen = false;
            } else if (isNextPunctChar) {
              if (!(isLastWhiteSpace || isLastPunctChar)) {
                canOpen = false;
              }
            }
            if (isLastWhiteSpace) {
              canClose = false;
            } else if (isLastPunctChar) {
              if (!(isNextWhiteSpace || isNextPunctChar)) {
                canClose = false;
              }
            }
            if (nextChar === 34 && t2[0] === '"') {
              if (lastChar >= 48 && lastChar <= 57) {
                canClose = canOpen = false;
              }
            }
            if (canOpen && canClose) {
              canOpen = isLastPunctChar;
              canClose = isNextPunctChar;
            }
            if (!canOpen && !canClose) {
              if (isSingle) {
                token.content = replaceAt(token.content, t2.index, APOSTROPHE);
              }
              continue;
            }
            if (canClose) {
              for (j = stack.length - 1; j >= 0; j--) {
                item = stack[j];
                if (stack[j].level < thisLevel) {
                  break;
                }
                if (item.single === isSingle && stack[j].level === thisLevel) {
                  item = stack[j];
                  if (isSingle) {
                    openQuote = state.md.options.quotes[2];
                    closeQuote = state.md.options.quotes[3];
                  } else {
                    openQuote = state.md.options.quotes[0];
                    closeQuote = state.md.options.quotes[1];
                  }
                  token.content = replaceAt(token.content, t2.index, closeQuote);
                  tokens[item.token].content = replaceAt(
                    tokens[item.token].content,
                    item.pos,
                    openQuote
                  );
                  pos += closeQuote.length - 1;
                  if (item.token === i3) {
                    pos += openQuote.length - 1;
                  }
                  text = token.content;
                  max3 = text.length;
                  stack.length = j;
                  continue OUTER;
                }
              }
            }
            if (canOpen) {
              stack.push({
                token: i3,
                pos: t2.index,
                single: isSingle,
                level: thisLevel
              });
            } else if (canClose && isSingle) {
              token.content = replaceAt(token.content, t2.index, APOSTROPHE);
            }
          }
      }
    }
    module.exports = function smartquotes(state) {
      var blkIdx;
      if (!state.md.options.typographer) {
        return;
      }
      for (blkIdx = state.tokens.length - 1; blkIdx >= 0; blkIdx--) {
        if (state.tokens[blkIdx].type !== "inline" || !QUOTE_TEST_RE.test(state.tokens[blkIdx].content)) {
          continue;
        }
        process_inlines(state.tokens[blkIdx].children, state);
      }
    };
  }
});

// node_modules/markdown-it/lib/rules_core/text_join.js
var require_text_join = __commonJS({
  "node_modules/markdown-it/lib/rules_core/text_join.js"(exports, module) {
    "use strict";
    module.exports = function text_join(state) {
      var j, l3, tokens, curr, max3, last3, blockTokens = state.tokens;
      for (j = 0, l3 = blockTokens.length; j < l3; j++) {
        if (blockTokens[j].type !== "inline") continue;
        tokens = blockTokens[j].children;
        max3 = tokens.length;
        for (curr = 0; curr < max3; curr++) {
          if (tokens[curr].type === "text_special") {
            tokens[curr].type = "text";
          }
        }
        for (curr = last3 = 0; curr < max3; curr++) {
          if (tokens[curr].type === "text" && curr + 1 < max3 && tokens[curr + 1].type === "text") {
            tokens[curr + 1].content = tokens[curr].content + tokens[curr + 1].content;
          } else {
            if (curr !== last3) {
              tokens[last3] = tokens[curr];
            }
            last3++;
          }
        }
        if (curr !== last3) {
          tokens.length = last3;
        }
      }
    };
  }
});

// node_modules/markdown-it/lib/token.js
var require_token = __commonJS({
  "node_modules/markdown-it/lib/token.js"(exports, module) {
    "use strict";
    function Token(type, tag, nesting) {
      this.type = type;
      this.tag = tag;
      this.attrs = null;
      this.map = null;
      this.nesting = nesting;
      this.level = 0;
      this.children = null;
      this.content = "";
      this.markup = "";
      this.info = "";
      this.meta = null;
      this.block = false;
      this.hidden = false;
    }
    Token.prototype.attrIndex = function attrIndex(name) {
      var attrs2, i3, len;
      if (!this.attrs) {
        return -1;
      }
      attrs2 = this.attrs;
      for (i3 = 0, len = attrs2.length; i3 < len; i3++) {
        if (attrs2[i3][0] === name) {
          return i3;
        }
      }
      return -1;
    };
    Token.prototype.attrPush = function attrPush(attrData) {
      if (this.attrs) {
        this.attrs.push(attrData);
      } else {
        this.attrs = [attrData];
      }
    };
    Token.prototype.attrSet = function attrSet(name, value2) {
      var idx = this.attrIndex(name), attrData = [name, value2];
      if (idx < 0) {
        this.attrPush(attrData);
      } else {
        this.attrs[idx] = attrData;
      }
    };
    Token.prototype.attrGet = function attrGet(name) {
      var idx = this.attrIndex(name), value2 = null;
      if (idx >= 0) {
        value2 = this.attrs[idx][1];
      }
      return value2;
    };
    Token.prototype.attrJoin = function attrJoin(name, value2) {
      var idx = this.attrIndex(name);
      if (idx < 0) {
        this.attrPush([name, value2]);
      } else {
        this.attrs[idx][1] = this.attrs[idx][1] + " " + value2;
      }
    };
    module.exports = Token;
  }
});

// node_modules/markdown-it/lib/rules_core/state_core.js
var require_state_core = __commonJS({
  "node_modules/markdown-it/lib/rules_core/state_core.js"(exports, module) {
    "use strict";
    var Token = require_token();
    function StateCore(src, md2, env) {
      this.src = src;
      this.env = env;
      this.tokens = [];
      this.inlineMode = false;
      this.md = md2;
    }
    StateCore.prototype.Token = Token;
    module.exports = StateCore;
  }
});

// node_modules/markdown-it/lib/parser_core.js
var require_parser_core = __commonJS({
  "node_modules/markdown-it/lib/parser_core.js"(exports, module) {
    "use strict";
    var Ruler = require_ruler();
    var _rules = [
      ["normalize", require_normalize()],
      ["block", require_block()],
      ["inline", require_inline()],
      ["linkify", require_linkify()],
      ["replacements", require_replacements()],
      ["smartquotes", require_smartquotes()],
      // `text_join` finds `text_special` tokens (for escape sequences)
      // and joins them with the rest of the text
      ["text_join", require_text_join()]
    ];
    function Core() {
      this.ruler = new Ruler();
      for (var i3 = 0; i3 < _rules.length; i3++) {
        this.ruler.push(_rules[i3][0], _rules[i3][1]);
      }
    }
    Core.prototype.process = function(state) {
      var i3, l3, rules;
      rules = this.ruler.getRules("");
      for (i3 = 0, l3 = rules.length; i3 < l3; i3++) {
        rules[i3](state);
      }
    };
    Core.prototype.State = require_state_core();
    module.exports = Core;
  }
});

// node_modules/markdown-it/lib/rules_block/table.js
var require_table = __commonJS({
  "node_modules/markdown-it/lib/rules_block/table.js"(exports, module) {
    "use strict";
    var isSpace = require_utils().isSpace;
    function getLine(state, line) {
      var pos = state.bMarks[line] + state.tShift[line], max3 = state.eMarks[line];
      return state.src.slice(pos, max3);
    }
    function escapedSplit(str) {
      var result2 = [], pos = 0, max3 = str.length, ch, isEscaped = false, lastPos = 0, current = "";
      ch = str.charCodeAt(pos);
      while (pos < max3) {
        if (ch === 124) {
          if (!isEscaped) {
            result2.push(current + str.substring(lastPos, pos));
            current = "";
            lastPos = pos + 1;
          } else {
            current += str.substring(lastPos, pos - 1);
            lastPos = pos;
          }
        }
        isEscaped = ch === 92;
        pos++;
        ch = str.charCodeAt(pos);
      }
      result2.push(current + str.substring(lastPos));
      return result2;
    }
    module.exports = function table(state, startLine, endLine, silent) {
      var ch, lineText, pos, i3, l3, nextLine, columns2, columnCount, token, aligns, t2, tableLines, tbodyLines, oldParentType, terminate, terminatorRules, firstCh, secondCh;
      if (startLine + 2 > endLine) {
        return false;
      }
      nextLine = startLine + 1;
      if (state.sCount[nextLine] < state.blkIndent) {
        return false;
      }
      if (state.sCount[nextLine] - state.blkIndent >= 4) {
        return false;
      }
      pos = state.bMarks[nextLine] + state.tShift[nextLine];
      if (pos >= state.eMarks[nextLine]) {
        return false;
      }
      firstCh = state.src.charCodeAt(pos++);
      if (firstCh !== 124 && firstCh !== 45 && firstCh !== 58) {
        return false;
      }
      if (pos >= state.eMarks[nextLine]) {
        return false;
      }
      secondCh = state.src.charCodeAt(pos++);
      if (secondCh !== 124 && secondCh !== 45 && secondCh !== 58 && !isSpace(secondCh)) {
        return false;
      }
      if (firstCh === 45 && isSpace(secondCh)) {
        return false;
      }
      while (pos < state.eMarks[nextLine]) {
        ch = state.src.charCodeAt(pos);
        if (ch !== 124 && ch !== 45 && ch !== 58 && !isSpace(ch)) {
          return false;
        }
        pos++;
      }
      lineText = getLine(state, startLine + 1);
      columns2 = lineText.split("|");
      aligns = [];
      for (i3 = 0; i3 < columns2.length; i3++) {
        t2 = columns2[i3].trim();
        if (!t2) {
          if (i3 === 0 || i3 === columns2.length - 1) {
            continue;
          } else {
            return false;
          }
        }
        if (!/^:?-+:?$/.test(t2)) {
          return false;
        }
        if (t2.charCodeAt(t2.length - 1) === 58) {
          aligns.push(t2.charCodeAt(0) === 58 ? "center" : "right");
        } else if (t2.charCodeAt(0) === 58) {
          aligns.push("left");
        } else {
          aligns.push("");
        }
      }
      lineText = getLine(state, startLine).trim();
      if (lineText.indexOf("|") === -1) {
        return false;
      }
      if (state.sCount[startLine] - state.blkIndent >= 4) {
        return false;
      }
      columns2 = escapedSplit(lineText);
      if (columns2.length && columns2[0] === "") columns2.shift();
      if (columns2.length && columns2[columns2.length - 1] === "") columns2.pop();
      columnCount = columns2.length;
      if (columnCount === 0 || columnCount !== aligns.length) {
        return false;
      }
      if (silent) {
        return true;
      }
      oldParentType = state.parentType;
      state.parentType = "table";
      terminatorRules = state.md.block.ruler.getRules("blockquote");
      token = state.push("table_open", "table", 1);
      token.map = tableLines = [startLine, 0];
      token = state.push("thead_open", "thead", 1);
      token.map = [startLine, startLine + 1];
      token = state.push("tr_open", "tr", 1);
      token.map = [startLine, startLine + 1];
      for (i3 = 0; i3 < columns2.length; i3++) {
        token = state.push("th_open", "th", 1);
        if (aligns[i3]) {
          token.attrs = [["style", "text-align:" + aligns[i3]]];
        }
        token = state.push("inline", "", 0);
        token.content = columns2[i3].trim();
        token.children = [];
        token = state.push("th_close", "th", -1);
      }
      token = state.push("tr_close", "tr", -1);
      token = state.push("thead_close", "thead", -1);
      for (nextLine = startLine + 2; nextLine < endLine; nextLine++) {
        if (state.sCount[nextLine] < state.blkIndent) {
          break;
        }
        terminate = false;
        for (i3 = 0, l3 = terminatorRules.length; i3 < l3; i3++) {
          if (terminatorRules[i3](state, nextLine, endLine, true)) {
            terminate = true;
            break;
          }
        }
        if (terminate) {
          break;
        }
        lineText = getLine(state, nextLine).trim();
        if (!lineText) {
          break;
        }
        if (state.sCount[nextLine] - state.blkIndent >= 4) {
          break;
        }
        columns2 = escapedSplit(lineText);
        if (columns2.length && columns2[0] === "") columns2.shift();
        if (columns2.length && columns2[columns2.length - 1] === "") columns2.pop();
        if (nextLine === startLine + 2) {
          token = state.push("tbody_open", "tbody", 1);
          token.map = tbodyLines = [startLine + 2, 0];
        }
        token = state.push("tr_open", "tr", 1);
        token.map = [nextLine, nextLine + 1];
        for (i3 = 0; i3 < columnCount; i3++) {
          token = state.push("td_open", "td", 1);
          if (aligns[i3]) {
            token.attrs = [["style", "text-align:" + aligns[i3]]];
          }
          token = state.push("inline", "", 0);
          token.content = columns2[i3] ? columns2[i3].trim() : "";
          token.children = [];
          token = state.push("td_close", "td", -1);
        }
        token = state.push("tr_close", "tr", -1);
      }
      if (tbodyLines) {
        token = state.push("tbody_close", "tbody", -1);
        tbodyLines[1] = nextLine;
      }
      token = state.push("table_close", "table", -1);
      tableLines[1] = nextLine;
      state.parentType = oldParentType;
      state.line = nextLine;
      return true;
    };
  }
});

// node_modules/markdown-it/lib/rules_block/code.js
var require_code = __commonJS({
  "node_modules/markdown-it/lib/rules_block/code.js"(exports, module) {
    "use strict";
    module.exports = function code(state, startLine, endLine) {
      var nextLine, last3, token;
      if (state.sCount[startLine] - state.blkIndent < 4) {
        return false;
      }
      last3 = nextLine = startLine + 1;
      while (nextLine < endLine) {
        if (state.isEmpty(nextLine)) {
          nextLine++;
          continue;
        }
        if (state.sCount[nextLine] - state.blkIndent >= 4) {
          nextLine++;
          last3 = nextLine;
          continue;
        }
        break;
      }
      state.line = last3;
      token = state.push("code_block", "code", 0);
      token.content = state.getLines(startLine, last3, 4 + state.blkIndent, false) + "\n";
      token.map = [startLine, state.line];
      return true;
    };
  }
});

// node_modules/markdown-it/lib/rules_block/fence.js
var require_fence = __commonJS({
  "node_modules/markdown-it/lib/rules_block/fence.js"(exports, module) {
    "use strict";
    module.exports = function fence(state, startLine, endLine, silent) {
      var marker, len, params, nextLine, mem, token, markup, haveEndMarker = false, pos = state.bMarks[startLine] + state.tShift[startLine], max3 = state.eMarks[startLine];
      if (state.sCount[startLine] - state.blkIndent >= 4) {
        return false;
      }
      if (pos + 3 > max3) {
        return false;
      }
      marker = state.src.charCodeAt(pos);
      if (marker !== 126 && marker !== 96) {
        return false;
      }
      mem = pos;
      pos = state.skipChars(pos, marker);
      len = pos - mem;
      if (len < 3) {
        return false;
      }
      markup = state.src.slice(mem, pos);
      params = state.src.slice(pos, max3);
      if (marker === 96) {
        if (params.indexOf(String.fromCharCode(marker)) >= 0) {
          return false;
        }
      }
      if (silent) {
        return true;
      }
      nextLine = startLine;
      for (; ; ) {
        nextLine++;
        if (nextLine >= endLine) {
          break;
        }
        pos = mem = state.bMarks[nextLine] + state.tShift[nextLine];
        max3 = state.eMarks[nextLine];
        if (pos < max3 && state.sCount[nextLine] < state.blkIndent) {
          break;
        }
        if (state.src.charCodeAt(pos) !== marker) {
          continue;
        }
        if (state.sCount[nextLine] - state.blkIndent >= 4) {
          continue;
        }
        pos = state.skipChars(pos, marker);
        if (pos - mem < len) {
          continue;
        }
        pos = state.skipSpaces(pos);
        if (pos < max3) {
          continue;
        }
        haveEndMarker = true;
        break;
      }
      len = state.sCount[startLine];
      state.line = nextLine + (haveEndMarker ? 1 : 0);
      token = state.push("fence", "code", 0);
      token.info = params;
      token.content = state.getLines(startLine + 1, nextLine, len, true);
      token.markup = markup;
      token.map = [startLine, state.line];
      return true;
    };
  }
});

// node_modules/markdown-it/lib/rules_block/blockquote.js
var require_blockquote = __commonJS({
  "node_modules/markdown-it/lib/rules_block/blockquote.js"(exports, module) {
    "use strict";
    var isSpace = require_utils().isSpace;
    module.exports = function blockquote(state, startLine, endLine, silent) {
      var adjustTab, ch, i3, initial2, l3, lastLineEmpty, lines, nextLine, offset, oldBMarks, oldBSCount, oldIndent, oldParentType, oldSCount, oldTShift, spaceAfterMarker, terminate, terminatorRules, token, isOutdented, oldLineMax = state.lineMax, pos = state.bMarks[startLine] + state.tShift[startLine], max3 = state.eMarks[startLine];
      if (state.sCount[startLine] - state.blkIndent >= 4) {
        return false;
      }
      if (state.src.charCodeAt(pos++) !== 62) {
        return false;
      }
      if (silent) {
        return true;
      }
      initial2 = offset = state.sCount[startLine] + 1;
      if (state.src.charCodeAt(pos) === 32) {
        pos++;
        initial2++;
        offset++;
        adjustTab = false;
        spaceAfterMarker = true;
      } else if (state.src.charCodeAt(pos) === 9) {
        spaceAfterMarker = true;
        if ((state.bsCount[startLine] + offset) % 4 === 3) {
          pos++;
          initial2++;
          offset++;
          adjustTab = false;
        } else {
          adjustTab = true;
        }
      } else {
        spaceAfterMarker = false;
      }
      oldBMarks = [state.bMarks[startLine]];
      state.bMarks[startLine] = pos;
      while (pos < max3) {
        ch = state.src.charCodeAt(pos);
        if (isSpace(ch)) {
          if (ch === 9) {
            offset += 4 - (offset + state.bsCount[startLine] + (adjustTab ? 1 : 0)) % 4;
          } else {
            offset++;
          }
        } else {
          break;
        }
        pos++;
      }
      oldBSCount = [state.bsCount[startLine]];
      state.bsCount[startLine] = state.sCount[startLine] + 1 + (spaceAfterMarker ? 1 : 0);
      lastLineEmpty = pos >= max3;
      oldSCount = [state.sCount[startLine]];
      state.sCount[startLine] = offset - initial2;
      oldTShift = [state.tShift[startLine]];
      state.tShift[startLine] = pos - state.bMarks[startLine];
      terminatorRules = state.md.block.ruler.getRules("blockquote");
      oldParentType = state.parentType;
      state.parentType = "blockquote";
      for (nextLine = startLine + 1; nextLine < endLine; nextLine++) {
        isOutdented = state.sCount[nextLine] < state.blkIndent;
        pos = state.bMarks[nextLine] + state.tShift[nextLine];
        max3 = state.eMarks[nextLine];
        if (pos >= max3) {
          break;
        }
        if (state.src.charCodeAt(pos++) === 62 && !isOutdented) {
          initial2 = offset = state.sCount[nextLine] + 1;
          if (state.src.charCodeAt(pos) === 32) {
            pos++;
            initial2++;
            offset++;
            adjustTab = false;
            spaceAfterMarker = true;
          } else if (state.src.charCodeAt(pos) === 9) {
            spaceAfterMarker = true;
            if ((state.bsCount[nextLine] + offset) % 4 === 3) {
              pos++;
              initial2++;
              offset++;
              adjustTab = false;
            } else {
              adjustTab = true;
            }
          } else {
            spaceAfterMarker = false;
          }
          oldBMarks.push(state.bMarks[nextLine]);
          state.bMarks[nextLine] = pos;
          while (pos < max3) {
            ch = state.src.charCodeAt(pos);
            if (isSpace(ch)) {
              if (ch === 9) {
                offset += 4 - (offset + state.bsCount[nextLine] + (adjustTab ? 1 : 0)) % 4;
              } else {
                offset++;
              }
            } else {
              break;
            }
            pos++;
          }
          lastLineEmpty = pos >= max3;
          oldBSCount.push(state.bsCount[nextLine]);
          state.bsCount[nextLine] = state.sCount[nextLine] + 1 + (spaceAfterMarker ? 1 : 0);
          oldSCount.push(state.sCount[nextLine]);
          state.sCount[nextLine] = offset - initial2;
          oldTShift.push(state.tShift[nextLine]);
          state.tShift[nextLine] = pos - state.bMarks[nextLine];
          continue;
        }
        if (lastLineEmpty) {
          break;
        }
        terminate = false;
        for (i3 = 0, l3 = terminatorRules.length; i3 < l3; i3++) {
          if (terminatorRules[i3](state, nextLine, endLine, true)) {
            terminate = true;
            break;
          }
        }
        if (terminate) {
          state.lineMax = nextLine;
          if (state.blkIndent !== 0) {
            oldBMarks.push(state.bMarks[nextLine]);
            oldBSCount.push(state.bsCount[nextLine]);
            oldTShift.push(state.tShift[nextLine]);
            oldSCount.push(state.sCount[nextLine]);
            state.sCount[nextLine] -= state.blkIndent;
          }
          break;
        }
        oldBMarks.push(state.bMarks[nextLine]);
        oldBSCount.push(state.bsCount[nextLine]);
        oldTShift.push(state.tShift[nextLine]);
        oldSCount.push(state.sCount[nextLine]);
        state.sCount[nextLine] = -1;
      }
      oldIndent = state.blkIndent;
      state.blkIndent = 0;
      token = state.push("blockquote_open", "blockquote", 1);
      token.markup = ">";
      token.map = lines = [startLine, 0];
      state.md.block.tokenize(state, startLine, nextLine);
      token = state.push("blockquote_close", "blockquote", -1);
      token.markup = ">";
      state.lineMax = oldLineMax;
      state.parentType = oldParentType;
      lines[1] = state.line;
      for (i3 = 0; i3 < oldTShift.length; i3++) {
        state.bMarks[i3 + startLine] = oldBMarks[i3];
        state.tShift[i3 + startLine] = oldTShift[i3];
        state.sCount[i3 + startLine] = oldSCount[i3];
        state.bsCount[i3 + startLine] = oldBSCount[i3];
      }
      state.blkIndent = oldIndent;
      return true;
    };
  }
});

// node_modules/markdown-it/lib/rules_block/hr.js
var require_hr = __commonJS({
  "node_modules/markdown-it/lib/rules_block/hr.js"(exports, module) {
    "use strict";
    var isSpace = require_utils().isSpace;
    module.exports = function hr(state, startLine, endLine, silent) {
      var marker, cnt, ch, token, pos = state.bMarks[startLine] + state.tShift[startLine], max3 = state.eMarks[startLine];
      if (state.sCount[startLine] - state.blkIndent >= 4) {
        return false;
      }
      marker = state.src.charCodeAt(pos++);
      if (marker !== 42 && marker !== 45 && marker !== 95) {
        return false;
      }
      cnt = 1;
      while (pos < max3) {
        ch = state.src.charCodeAt(pos++);
        if (ch !== marker && !isSpace(ch)) {
          return false;
        }
        if (ch === marker) {
          cnt++;
        }
      }
      if (cnt < 3) {
        return false;
      }
      if (silent) {
        return true;
      }
      state.line = startLine + 1;
      token = state.push("hr", "hr", 0);
      token.map = [startLine, state.line];
      token.markup = Array(cnt + 1).join(String.fromCharCode(marker));
      return true;
    };
  }
});

// node_modules/markdown-it/lib/rules_block/list.js
var require_list = __commonJS({
  "node_modules/markdown-it/lib/rules_block/list.js"(exports, module) {
    "use strict";
    var isSpace = require_utils().isSpace;
    function skipBulletListMarker(state, startLine) {
      var marker, pos, max3, ch;
      pos = state.bMarks[startLine] + state.tShift[startLine];
      max3 = state.eMarks[startLine];
      marker = state.src.charCodeAt(pos++);
      if (marker !== 42 && marker !== 45 && marker !== 43) {
        return -1;
      }
      if (pos < max3) {
        ch = state.src.charCodeAt(pos);
        if (!isSpace(ch)) {
          return -1;
        }
      }
      return pos;
    }
    function skipOrderedListMarker(state, startLine) {
      var ch, start = state.bMarks[startLine] + state.tShift[startLine], pos = start, max3 = state.eMarks[startLine];
      if (pos + 1 >= max3) {
        return -1;
      }
      ch = state.src.charCodeAt(pos++);
      if (ch < 48 || ch > 57) {
        return -1;
      }
      for (; ; ) {
        if (pos >= max3) {
          return -1;
        }
        ch = state.src.charCodeAt(pos++);
        if (ch >= 48 && ch <= 57) {
          if (pos - start >= 10) {
            return -1;
          }
          continue;
        }
        if (ch === 41 || ch === 46) {
          break;
        }
        return -1;
      }
      if (pos < max3) {
        ch = state.src.charCodeAt(pos);
        if (!isSpace(ch)) {
          return -1;
        }
      }
      return pos;
    }
    function markTightParagraphs(state, idx) {
      var i3, l3, level = state.level + 2;
      for (i3 = idx + 2, l3 = state.tokens.length - 2; i3 < l3; i3++) {
        if (state.tokens[i3].level === level && state.tokens[i3].type === "paragraph_open") {
          state.tokens[i3 + 2].hidden = true;
          state.tokens[i3].hidden = true;
          i3 += 2;
        }
      }
    }
    module.exports = function list(state, startLine, endLine, silent) {
      var ch, contentStart, i3, indent, indentAfterMarker, initial2, isOrdered, itemLines, l3, listLines, listTokIdx, markerCharCode, markerValue, max3, nextLine, offset, oldListIndent, oldParentType, oldSCount, oldTShift, oldTight, pos, posAfterMarker, prevEmptyEnd, start, terminate, terminatorRules, token, isTerminatingParagraph = false, tight = true;
      if (state.sCount[startLine] - state.blkIndent >= 4) {
        return false;
      }
      if (state.listIndent >= 0 && state.sCount[startLine] - state.listIndent >= 4 && state.sCount[startLine] < state.blkIndent) {
        return false;
      }
      if (silent && state.parentType === "paragraph") {
        if (state.sCount[startLine] >= state.blkIndent) {
          isTerminatingParagraph = true;
        }
      }
      if ((posAfterMarker = skipOrderedListMarker(state, startLine)) >= 0) {
        isOrdered = true;
        start = state.bMarks[startLine] + state.tShift[startLine];
        markerValue = Number(state.src.slice(start, posAfterMarker - 1));
        if (isTerminatingParagraph && markerValue !== 1) return false;
      } else if ((posAfterMarker = skipBulletListMarker(state, startLine)) >= 0) {
        isOrdered = false;
      } else {
        return false;
      }
      if (isTerminatingParagraph) {
        if (state.skipSpaces(posAfterMarker) >= state.eMarks[startLine]) return false;
      }
      markerCharCode = state.src.charCodeAt(posAfterMarker - 1);
      if (silent) {
        return true;
      }
      listTokIdx = state.tokens.length;
      if (isOrdered) {
        token = state.push("ordered_list_open", "ol", 1);
        if (markerValue !== 1) {
          token.attrs = [["start", markerValue]];
        }
      } else {
        token = state.push("bullet_list_open", "ul", 1);
      }
      token.map = listLines = [startLine, 0];
      token.markup = String.fromCharCode(markerCharCode);
      nextLine = startLine;
      prevEmptyEnd = false;
      terminatorRules = state.md.block.ruler.getRules("list");
      oldParentType = state.parentType;
      state.parentType = "list";
      while (nextLine < endLine) {
        pos = posAfterMarker;
        max3 = state.eMarks[nextLine];
        initial2 = offset = state.sCount[nextLine] + posAfterMarker - (state.bMarks[startLine] + state.tShift[startLine]);
        while (pos < max3) {
          ch = state.src.charCodeAt(pos);
          if (ch === 9) {
            offset += 4 - (offset + state.bsCount[nextLine]) % 4;
          } else if (ch === 32) {
            offset++;
          } else {
            break;
          }
          pos++;
        }
        contentStart = pos;
        if (contentStart >= max3) {
          indentAfterMarker = 1;
        } else {
          indentAfterMarker = offset - initial2;
        }
        if (indentAfterMarker > 4) {
          indentAfterMarker = 1;
        }
        indent = initial2 + indentAfterMarker;
        token = state.push("list_item_open", "li", 1);
        token.markup = String.fromCharCode(markerCharCode);
        token.map = itemLines = [startLine, 0];
        if (isOrdered) {
          token.info = state.src.slice(start, posAfterMarker - 1);
        }
        oldTight = state.tight;
        oldTShift = state.tShift[startLine];
        oldSCount = state.sCount[startLine];
        oldListIndent = state.listIndent;
        state.listIndent = state.blkIndent;
        state.blkIndent = indent;
        state.tight = true;
        state.tShift[startLine] = contentStart - state.bMarks[startLine];
        state.sCount[startLine] = offset;
        if (contentStart >= max3 && state.isEmpty(startLine + 1)) {
          state.line = Math.min(state.line + 2, endLine);
        } else {
          state.md.block.tokenize(state, startLine, endLine, true);
        }
        if (!state.tight || prevEmptyEnd) {
          tight = false;
        }
        prevEmptyEnd = state.line - startLine > 1 && state.isEmpty(state.line - 1);
        state.blkIndent = state.listIndent;
        state.listIndent = oldListIndent;
        state.tShift[startLine] = oldTShift;
        state.sCount[startLine] = oldSCount;
        state.tight = oldTight;
        token = state.push("list_item_close", "li", -1);
        token.markup = String.fromCharCode(markerCharCode);
        nextLine = startLine = state.line;
        itemLines[1] = nextLine;
        contentStart = state.bMarks[startLine];
        if (nextLine >= endLine) {
          break;
        }
        if (state.sCount[nextLine] < state.blkIndent) {
          break;
        }
        if (state.sCount[startLine] - state.blkIndent >= 4) {
          break;
        }
        terminate = false;
        for (i3 = 0, l3 = terminatorRules.length; i3 < l3; i3++) {
          if (terminatorRules[i3](state, nextLine, endLine, true)) {
            terminate = true;
            break;
          }
        }
        if (terminate) {
          break;
        }
        if (isOrdered) {
          posAfterMarker = skipOrderedListMarker(state, nextLine);
          if (posAfterMarker < 0) {
            break;
          }
          start = state.bMarks[nextLine] + state.tShift[nextLine];
        } else {
          posAfterMarker = skipBulletListMarker(state, nextLine);
          if (posAfterMarker < 0) {
            break;
          }
        }
        if (markerCharCode !== state.src.charCodeAt(posAfterMarker - 1)) {
          break;
        }
      }
      if (isOrdered) {
        token = state.push("ordered_list_close", "ol", -1);
      } else {
        token = state.push("bullet_list_close", "ul", -1);
      }
      token.markup = String.fromCharCode(markerCharCode);
      listLines[1] = nextLine;
      state.line = nextLine;
      state.parentType = oldParentType;
      if (tight) {
        markTightParagraphs(state, listTokIdx);
      }
      return true;
    };
  }
});

// node_modules/markdown-it/lib/rules_block/reference.js
var require_reference = __commonJS({
  "node_modules/markdown-it/lib/rules_block/reference.js"(exports, module) {
    "use strict";
    var normalizeReference = require_utils().normalizeReference;
    var isSpace = require_utils().isSpace;
    module.exports = function reference(state, startLine, _endLine, silent) {
      var ch, destEndPos, destEndLineNo, endLine, href, i3, l3, label, labelEnd, oldParentType, res, start, str, terminate, terminatorRules, title, lines = 0, pos = state.bMarks[startLine] + state.tShift[startLine], max3 = state.eMarks[startLine], nextLine = startLine + 1;
      if (state.sCount[startLine] - state.blkIndent >= 4) {
        return false;
      }
      if (state.src.charCodeAt(pos) !== 91) {
        return false;
      }
      while (++pos < max3) {
        if (state.src.charCodeAt(pos) === 93 && state.src.charCodeAt(pos - 1) !== 92) {
          if (pos + 1 === max3) {
            return false;
          }
          if (state.src.charCodeAt(pos + 1) !== 58) {
            return false;
          }
          break;
        }
      }
      endLine = state.lineMax;
      terminatorRules = state.md.block.ruler.getRules("reference");
      oldParentType = state.parentType;
      state.parentType = "reference";
      for (; nextLine < endLine && !state.isEmpty(nextLine); nextLine++) {
        if (state.sCount[nextLine] - state.blkIndent > 3) {
          continue;
        }
        if (state.sCount[nextLine] < 0) {
          continue;
        }
        terminate = false;
        for (i3 = 0, l3 = terminatorRules.length; i3 < l3; i3++) {
          if (terminatorRules[i3](state, nextLine, endLine, true)) {
            terminate = true;
            break;
          }
        }
        if (terminate) {
          break;
        }
      }
      str = state.getLines(startLine, nextLine, state.blkIndent, false).trim();
      max3 = str.length;
      for (pos = 1; pos < max3; pos++) {
        ch = str.charCodeAt(pos);
        if (ch === 91) {
          return false;
        } else if (ch === 93) {
          labelEnd = pos;
          break;
        } else if (ch === 10) {
          lines++;
        } else if (ch === 92) {
          pos++;
          if (pos < max3 && str.charCodeAt(pos) === 10) {
            lines++;
          }
        }
      }
      if (labelEnd < 0 || str.charCodeAt(labelEnd + 1) !== 58) {
        return false;
      }
      for (pos = labelEnd + 2; pos < max3; pos++) {
        ch = str.charCodeAt(pos);
        if (ch === 10) {
          lines++;
        } else if (isSpace(ch)) {
        } else {
          break;
        }
      }
      res = state.md.helpers.parseLinkDestination(str, pos, max3);
      if (!res.ok) {
        return false;
      }
      href = state.md.normalizeLink(res.str);
      if (!state.md.validateLink(href)) {
        return false;
      }
      pos = res.pos;
      lines += res.lines;
      destEndPos = pos;
      destEndLineNo = lines;
      start = pos;
      for (; pos < max3; pos++) {
        ch = str.charCodeAt(pos);
        if (ch === 10) {
          lines++;
        } else if (isSpace(ch)) {
        } else {
          break;
        }
      }
      res = state.md.helpers.parseLinkTitle(str, pos, max3);
      if (pos < max3 && start !== pos && res.ok) {
        title = res.str;
        pos = res.pos;
        lines += res.lines;
      } else {
        title = "";
        pos = destEndPos;
        lines = destEndLineNo;
      }
      while (pos < max3) {
        ch = str.charCodeAt(pos);
        if (!isSpace(ch)) {
          break;
        }
        pos++;
      }
      if (pos < max3 && str.charCodeAt(pos) !== 10) {
        if (title) {
          title = "";
          pos = destEndPos;
          lines = destEndLineNo;
          while (pos < max3) {
            ch = str.charCodeAt(pos);
            if (!isSpace(ch)) {
              break;
            }
            pos++;
          }
        }
      }
      if (pos < max3 && str.charCodeAt(pos) !== 10) {
        return false;
      }
      label = normalizeReference(str.slice(1, labelEnd));
      if (!label) {
        return false;
      }
      if (silent) {
        return true;
      }
      if (typeof state.env.references === "undefined") {
        state.env.references = {};
      }
      if (typeof state.env.references[label] === "undefined") {
        state.env.references[label] = { title, href };
      }
      state.parentType = oldParentType;
      state.line = startLine + lines + 1;
      return true;
    };
  }
});

// node_modules/markdown-it/lib/common/html_blocks.js
var require_html_blocks = __commonJS({
  "node_modules/markdown-it/lib/common/html_blocks.js"(exports, module) {
    "use strict";
    module.exports = [
      "address",
      "article",
      "aside",
      "base",
      "basefont",
      "blockquote",
      "body",
      "caption",
      "center",
      "col",
      "colgroup",
      "dd",
      "details",
      "dialog",
      "dir",
      "div",
      "dl",
      "dt",
      "fieldset",
      "figcaption",
      "figure",
      "footer",
      "form",
      "frame",
      "frameset",
      "h1",
      "h2",
      "h3",
      "h4",
      "h5",
      "h6",
      "head",
      "header",
      "hr",
      "html",
      "iframe",
      "legend",
      "li",
      "link",
      "main",
      "menu",
      "menuitem",
      "nav",
      "noframes",
      "ol",
      "optgroup",
      "option",
      "p",
      "param",
      "section",
      "source",
      "summary",
      "table",
      "tbody",
      "td",
      "tfoot",
      "th",
      "thead",
      "title",
      "tr",
      "track",
      "ul"
    ];
  }
});

// node_modules/markdown-it/lib/common/html_re.js
var require_html_re = __commonJS({
  "node_modules/markdown-it/lib/common/html_re.js"(exports, module) {
    "use strict";
    var attr_name = "[a-zA-Z_:][a-zA-Z0-9:._-]*";
    var unquoted = "[^\"'=<>`\\x00-\\x20]+";
    var single_quoted = "'[^']*'";
    var double_quoted = '"[^"]*"';
    var attr_value = "(?:" + unquoted + "|" + single_quoted + "|" + double_quoted + ")";
    var attribute = "(?:\\s+" + attr_name + "(?:\\s*=\\s*" + attr_value + ")?)";
    var open_tag = "<[A-Za-z][A-Za-z0-9\\-]*" + attribute + "*\\s*\\/?>";
    var close_tag = "<\\/[A-Za-z][A-Za-z0-9\\-]*\\s*>";
    var comment = "<!---->|<!--(?:-?[^>-])(?:-?[^-])*-->";
    var processing = "<[?][\\s\\S]*?[?]>";
    var declaration = "<![A-Z]+\\s+[^>]*>";
    var cdata = "<!\\[CDATA\\[[\\s\\S]*?\\]\\]>";
    var HTML_TAG_RE = new RegExp("^(?:" + open_tag + "|" + close_tag + "|" + comment + "|" + processing + "|" + declaration + "|" + cdata + ")");
    var HTML_OPEN_CLOSE_TAG_RE = new RegExp("^(?:" + open_tag + "|" + close_tag + ")");
    module.exports.HTML_TAG_RE = HTML_TAG_RE;
    module.exports.HTML_OPEN_CLOSE_TAG_RE = HTML_OPEN_CLOSE_TAG_RE;
  }
});

// node_modules/markdown-it/lib/rules_block/html_block.js
var require_html_block = __commonJS({
  "node_modules/markdown-it/lib/rules_block/html_block.js"(exports, module) {
    "use strict";
    var block_names = require_html_blocks();
    var HTML_OPEN_CLOSE_TAG_RE = require_html_re().HTML_OPEN_CLOSE_TAG_RE;
    var HTML_SEQUENCES = [
      [/^<(script|pre|style|textarea)(?=(\s|>|$))/i, /<\/(script|pre|style|textarea)>/i, true],
      [/^<!--/, /-->/, true],
      [/^<\?/, /\?>/, true],
      [/^<![A-Z]/, />/, true],
      [/^<!\[CDATA\[/, /\]\]>/, true],
      [new RegExp("^</?(" + block_names.join("|") + ")(?=(\\s|/?>|$))", "i"), /^$/, true],
      [new RegExp(HTML_OPEN_CLOSE_TAG_RE.source + "\\s*$"), /^$/, false]
    ];
    module.exports = function html_block(state, startLine, endLine, silent) {
      var i3, nextLine, token, lineText, pos = state.bMarks[startLine] + state.tShift[startLine], max3 = state.eMarks[startLine];
      if (state.sCount[startLine] - state.blkIndent >= 4) {
        return false;
      }
      if (!state.md.options.html) {
        return false;
      }
      if (state.src.charCodeAt(pos) !== 60) {
        return false;
      }
      lineText = state.src.slice(pos, max3);
      for (i3 = 0; i3 < HTML_SEQUENCES.length; i3++) {
        if (HTML_SEQUENCES[i3][0].test(lineText)) {
          break;
        }
      }
      if (i3 === HTML_SEQUENCES.length) {
        return false;
      }
      if (silent) {
        return HTML_SEQUENCES[i3][2];
      }
      nextLine = startLine + 1;
      if (!HTML_SEQUENCES[i3][1].test(lineText)) {
        for (; nextLine < endLine; nextLine++) {
          if (state.sCount[nextLine] < state.blkIndent) {
            break;
          }
          pos = state.bMarks[nextLine] + state.tShift[nextLine];
          max3 = state.eMarks[nextLine];
          lineText = state.src.slice(pos, max3);
          if (HTML_SEQUENCES[i3][1].test(lineText)) {
            if (lineText.length !== 0) {
              nextLine++;
            }
            break;
          }
        }
      }
      state.line = nextLine;
      token = state.push("html_block", "", 0);
      token.map = [startLine, nextLine];
      token.content = state.getLines(startLine, nextLine, state.blkIndent, true);
      return true;
    };
  }
});

// node_modules/markdown-it/lib/rules_block/heading.js
var require_heading = __commonJS({
  "node_modules/markdown-it/lib/rules_block/heading.js"(exports, module) {
    "use strict";
    var isSpace = require_utils().isSpace;
    module.exports = function heading(state, startLine, endLine, silent) {
      var ch, level, tmp, token, pos = state.bMarks[startLine] + state.tShift[startLine], max3 = state.eMarks[startLine];
      if (state.sCount[startLine] - state.blkIndent >= 4) {
        return false;
      }
      ch = state.src.charCodeAt(pos);
      if (ch !== 35 || pos >= max3) {
        return false;
      }
      level = 1;
      ch = state.src.charCodeAt(++pos);
      while (ch === 35 && pos < max3 && level <= 6) {
        level++;
        ch = state.src.charCodeAt(++pos);
      }
      if (level > 6 || pos < max3 && !isSpace(ch)) {
        return false;
      }
      if (silent) {
        return true;
      }
      max3 = state.skipSpacesBack(max3, pos);
      tmp = state.skipCharsBack(max3, 35, pos);
      if (tmp > pos && isSpace(state.src.charCodeAt(tmp - 1))) {
        max3 = tmp;
      }
      state.line = startLine + 1;
      token = state.push("heading_open", "h" + String(level), 1);
      token.markup = "########".slice(0, level);
      token.map = [startLine, state.line];
      token = state.push("inline", "", 0);
      token.content = state.src.slice(pos, max3).trim();
      token.map = [startLine, state.line];
      token.children = [];
      token = state.push("heading_close", "h" + String(level), -1);
      token.markup = "########".slice(0, level);
      return true;
    };
  }
});

// node_modules/markdown-it/lib/rules_block/lheading.js
var require_lheading = __commonJS({
  "node_modules/markdown-it/lib/rules_block/lheading.js"(exports, module) {
    "use strict";
    module.exports = function lheading(state, startLine, endLine) {
      var content, terminate, i3, l3, token, pos, max3, level, marker, nextLine = startLine + 1, oldParentType, terminatorRules = state.md.block.ruler.getRules("paragraph");
      if (state.sCount[startLine] - state.blkIndent >= 4) {
        return false;
      }
      oldParentType = state.parentType;
      state.parentType = "paragraph";
      for (; nextLine < endLine && !state.isEmpty(nextLine); nextLine++) {
        if (state.sCount[nextLine] - state.blkIndent > 3) {
          continue;
        }
        if (state.sCount[nextLine] >= state.blkIndent) {
          pos = state.bMarks[nextLine] + state.tShift[nextLine];
          max3 = state.eMarks[nextLine];
          if (pos < max3) {
            marker = state.src.charCodeAt(pos);
            if (marker === 45 || marker === 61) {
              pos = state.skipChars(pos, marker);
              pos = state.skipSpaces(pos);
              if (pos >= max3) {
                level = marker === 61 ? 1 : 2;
                break;
              }
            }
          }
        }
        if (state.sCount[nextLine] < 0) {
          continue;
        }
        terminate = false;
        for (i3 = 0, l3 = terminatorRules.length; i3 < l3; i3++) {
          if (terminatorRules[i3](state, nextLine, endLine, true)) {
            terminate = true;
            break;
          }
        }
        if (terminate) {
          break;
        }
      }
      if (!level) {
        return false;
      }
      content = state.getLines(startLine, nextLine, state.blkIndent, false).trim();
      state.line = nextLine + 1;
      token = state.push("heading_open", "h" + String(level), 1);
      token.markup = String.fromCharCode(marker);
      token.map = [startLine, state.line];
      token = state.push("inline", "", 0);
      token.content = content;
      token.map = [startLine, state.line - 1];
      token.children = [];
      token = state.push("heading_close", "h" + String(level), -1);
      token.markup = String.fromCharCode(marker);
      state.parentType = oldParentType;
      return true;
    };
  }
});

// node_modules/markdown-it/lib/rules_block/paragraph.js
var require_paragraph = __commonJS({
  "node_modules/markdown-it/lib/rules_block/paragraph.js"(exports, module) {
    "use strict";
    module.exports = function paragraph(state, startLine) {
      var content, terminate, i3, l3, token, oldParentType, nextLine = startLine + 1, terminatorRules = state.md.block.ruler.getRules("paragraph"), endLine = state.lineMax;
      oldParentType = state.parentType;
      state.parentType = "paragraph";
      for (; nextLine < endLine && !state.isEmpty(nextLine); nextLine++) {
        if (state.sCount[nextLine] - state.blkIndent > 3) {
          continue;
        }
        if (state.sCount[nextLine] < 0) {
          continue;
        }
        terminate = false;
        for (i3 = 0, l3 = terminatorRules.length; i3 < l3; i3++) {
          if (terminatorRules[i3](state, nextLine, endLine, true)) {
            terminate = true;
            break;
          }
        }
        if (terminate) {
          break;
        }
      }
      content = state.getLines(startLine, nextLine, state.blkIndent, false).trim();
      state.line = nextLine;
      token = state.push("paragraph_open", "p", 1);
      token.map = [startLine, state.line];
      token = state.push("inline", "", 0);
      token.content = content;
      token.map = [startLine, state.line];
      token.children = [];
      token = state.push("paragraph_close", "p", -1);
      state.parentType = oldParentType;
      return true;
    };
  }
});

// node_modules/markdown-it/lib/rules_block/state_block.js
var require_state_block = __commonJS({
  "node_modules/markdown-it/lib/rules_block/state_block.js"(exports, module) {
    "use strict";
    var Token = require_token();
    var isSpace = require_utils().isSpace;
    function StateBlock(src, md2, env, tokens) {
      var ch, s3, start, pos, len, indent, offset, indent_found;
      this.src = src;
      this.md = md2;
      this.env = env;
      this.tokens = tokens;
      this.bMarks = [];
      this.eMarks = [];
      this.tShift = [];
      this.sCount = [];
      this.bsCount = [];
      this.blkIndent = 0;
      this.line = 0;
      this.lineMax = 0;
      this.tight = false;
      this.ddIndent = -1;
      this.listIndent = -1;
      this.parentType = "root";
      this.level = 0;
      this.result = "";
      s3 = this.src;
      indent_found = false;
      for (start = pos = indent = offset = 0, len = s3.length; pos < len; pos++) {
        ch = s3.charCodeAt(pos);
        if (!indent_found) {
          if (isSpace(ch)) {
            indent++;
            if (ch === 9) {
              offset += 4 - offset % 4;
            } else {
              offset++;
            }
            continue;
          } else {
            indent_found = true;
          }
        }
        if (ch === 10 || pos === len - 1) {
          if (ch !== 10) {
            pos++;
          }
          this.bMarks.push(start);
          this.eMarks.push(pos);
          this.tShift.push(indent);
          this.sCount.push(offset);
          this.bsCount.push(0);
          indent_found = false;
          indent = 0;
          offset = 0;
          start = pos + 1;
        }
      }
      this.bMarks.push(s3.length);
      this.eMarks.push(s3.length);
      this.tShift.push(0);
      this.sCount.push(0);
      this.bsCount.push(0);
      this.lineMax = this.bMarks.length - 1;
    }
    StateBlock.prototype.push = function(type, tag, nesting) {
      var token = new Token(type, tag, nesting);
      token.block = true;
      if (nesting < 0) this.level--;
      token.level = this.level;
      if (nesting > 0) this.level++;
      this.tokens.push(token);
      return token;
    };
    StateBlock.prototype.isEmpty = function isEmpty2(line) {
      return this.bMarks[line] + this.tShift[line] >= this.eMarks[line];
    };
    StateBlock.prototype.skipEmptyLines = function skipEmptyLines(from2) {
      for (var max3 = this.lineMax; from2 < max3; from2++) {
        if (this.bMarks[from2] + this.tShift[from2] < this.eMarks[from2]) {
          break;
        }
      }
      return from2;
    };
    StateBlock.prototype.skipSpaces = function skipSpaces(pos) {
      var ch;
      for (var max3 = this.src.length; pos < max3; pos++) {
        ch = this.src.charCodeAt(pos);
        if (!isSpace(ch)) {
          break;
        }
      }
      return pos;
    };
    StateBlock.prototype.skipSpacesBack = function skipSpacesBack(pos, min3) {
      if (pos <= min3) {
        return pos;
      }
      while (pos > min3) {
        if (!isSpace(this.src.charCodeAt(--pos))) {
          return pos + 1;
        }
      }
      return pos;
    };
    StateBlock.prototype.skipChars = function skipChars(pos, code) {
      for (var max3 = this.src.length; pos < max3; pos++) {
        if (this.src.charCodeAt(pos) !== code) {
          break;
        }
      }
      return pos;
    };
    StateBlock.prototype.skipCharsBack = function skipCharsBack(pos, code, min3) {
      if (pos <= min3) {
        return pos;
      }
      while (pos > min3) {
        if (code !== this.src.charCodeAt(--pos)) {
          return pos + 1;
        }
      }
      return pos;
    };
    StateBlock.prototype.getLines = function getLines(begin, end, indent, keepLastLF) {
      var i3, lineIndent, ch, first2, last3, queue2, lineStart, line = begin;
      if (begin >= end) {
        return "";
      }
      queue2 = new Array(end - begin);
      for (i3 = 0; line < end; line++, i3++) {
        lineIndent = 0;
        lineStart = first2 = this.bMarks[line];
        if (line + 1 < end || keepLastLF) {
          last3 = this.eMarks[line] + 1;
        } else {
          last3 = this.eMarks[line];
        }
        while (first2 < last3 && lineIndent < indent) {
          ch = this.src.charCodeAt(first2);
          if (isSpace(ch)) {
            if (ch === 9) {
              lineIndent += 4 - (lineIndent + this.bsCount[line]) % 4;
            } else {
              lineIndent++;
            }
          } else if (first2 - lineStart < this.tShift[line]) {
            lineIndent++;
          } else {
            break;
          }
          first2++;
        }
        if (lineIndent > indent) {
          queue2[i3] = new Array(lineIndent - indent + 1).join(" ") + this.src.slice(first2, last3);
        } else {
          queue2[i3] = this.src.slice(first2, last3);
        }
      }
      return queue2.join("");
    };
    StateBlock.prototype.Token = Token;
    module.exports = StateBlock;
  }
});

// node_modules/markdown-it/lib/parser_block.js
var require_parser_block = __commonJS({
  "node_modules/markdown-it/lib/parser_block.js"(exports, module) {
    "use strict";
    var Ruler = require_ruler();
    var _rules = [
      // First 2 params - rule name & source. Secondary array - list of rules,
      // which can be terminated by this one.
      ["table", require_table(), ["paragraph", "reference"]],
      ["code", require_code()],
      ["fence", require_fence(), ["paragraph", "reference", "blockquote", "list"]],
      ["blockquote", require_blockquote(), ["paragraph", "reference", "blockquote", "list"]],
      ["hr", require_hr(), ["paragraph", "reference", "blockquote", "list"]],
      ["list", require_list(), ["paragraph", "reference", "blockquote"]],
      ["reference", require_reference()],
      ["html_block", require_html_block(), ["paragraph", "reference", "blockquote"]],
      ["heading", require_heading(), ["paragraph", "reference", "blockquote"]],
      ["lheading", require_lheading()],
      ["paragraph", require_paragraph()]
    ];
    function ParserBlock() {
      this.ruler = new Ruler();
      for (var i3 = 0; i3 < _rules.length; i3++) {
        this.ruler.push(_rules[i3][0], _rules[i3][1], { alt: (_rules[i3][2] || []).slice() });
      }
    }
    ParserBlock.prototype.tokenize = function(state, startLine, endLine) {
      var ok, i3, rules = this.ruler.getRules(""), len = rules.length, line = startLine, hasEmptyLines = false, maxNesting = state.md.options.maxNesting;
      while (line < endLine) {
        state.line = line = state.skipEmptyLines(line);
        if (line >= endLine) {
          break;
        }
        if (state.sCount[line] < state.blkIndent) {
          break;
        }
        if (state.level >= maxNesting) {
          state.line = endLine;
          break;
        }
        for (i3 = 0; i3 < len; i3++) {
          ok = rules[i3](state, line, endLine, false);
          if (ok) {
            break;
          }
        }
        state.tight = !hasEmptyLines;
        if (state.isEmpty(state.line - 1)) {
          hasEmptyLines = true;
        }
        line = state.line;
        if (line < endLine && state.isEmpty(line)) {
          hasEmptyLines = true;
          line++;
          state.line = line;
        }
      }
    };
    ParserBlock.prototype.parse = function(src, md2, env, outTokens) {
      var state;
      if (!src) {
        return;
      }
      state = new this.State(src, md2, env, outTokens);
      this.tokenize(state, state.line, state.lineMax);
    };
    ParserBlock.prototype.State = require_state_block();
    module.exports = ParserBlock;
  }
});

// node_modules/markdown-it/lib/rules_inline/text.js
var require_text = __commonJS({
  "node_modules/markdown-it/lib/rules_inline/text.js"(exports, module) {
    "use strict";
    function isTerminatorChar(ch) {
      switch (ch) {
        case 10:
        case 33:
        case 35:
        case 36:
        case 37:
        case 38:
        case 42:
        case 43:
        case 45:
        case 58:
        case 60:
        case 61:
        case 62:
        case 64:
        case 91:
        case 92:
        case 93:
        case 94:
        case 95:
        case 96:
        case 123:
        case 125:
        case 126:
          return true;
        default:
          return false;
      }
    }
    module.exports = function text(state, silent) {
      var pos = state.pos;
      while (pos < state.posMax && !isTerminatorChar(state.src.charCodeAt(pos))) {
        pos++;
      }
      if (pos === state.pos) {
        return false;
      }
      if (!silent) {
        state.pending += state.src.slice(state.pos, pos);
      }
      state.pos = pos;
      return true;
    };
  }
});

// node_modules/markdown-it/lib/rules_inline/linkify.js
var require_linkify2 = __commonJS({
  "node_modules/markdown-it/lib/rules_inline/linkify.js"(exports, module) {
    "use strict";
    var SCHEME_RE = /(?:^|[^a-z0-9.+-])([a-z][a-z0-9.+-]*)$/i;
    module.exports = function linkify(state, silent) {
      var pos, max3, match, proto, link, url2, fullUrl, token;
      if (!state.md.options.linkify) return false;
      if (state.linkLevel > 0) return false;
      pos = state.pos;
      max3 = state.posMax;
      if (pos + 3 > max3) return false;
      if (state.src.charCodeAt(pos) !== 58) return false;
      if (state.src.charCodeAt(pos + 1) !== 47) return false;
      if (state.src.charCodeAt(pos + 2) !== 47) return false;
      match = state.pending.match(SCHEME_RE);
      if (!match) return false;
      proto = match[1];
      link = state.md.linkify.matchAtStart(state.src.slice(pos - proto.length));
      if (!link) return false;
      url2 = link.url;
      url2 = url2.replace(/\*+$/, "");
      fullUrl = state.md.normalizeLink(url2);
      if (!state.md.validateLink(fullUrl)) return false;
      if (!silent) {
        state.pending = state.pending.slice(0, -proto.length);
        token = state.push("link_open", "a", 1);
        token.attrs = [["href", fullUrl]];
        token.markup = "linkify";
        token.info = "auto";
        token = state.push("text", "", 0);
        token.content = state.md.normalizeLinkText(url2);
        token = state.push("link_close", "a", -1);
        token.markup = "linkify";
        token.info = "auto";
      }
      state.pos += url2.length - proto.length;
      return true;
    };
  }
});

// node_modules/markdown-it/lib/rules_inline/newline.js
var require_newline = __commonJS({
  "node_modules/markdown-it/lib/rules_inline/newline.js"(exports, module) {
    "use strict";
    var isSpace = require_utils().isSpace;
    module.exports = function newline(state, silent) {
      var pmax, max3, ws, pos = state.pos;
      if (state.src.charCodeAt(pos) !== 10) {
        return false;
      }
      pmax = state.pending.length - 1;
      max3 = state.posMax;
      if (!silent) {
        if (pmax >= 0 && state.pending.charCodeAt(pmax) === 32) {
          if (pmax >= 1 && state.pending.charCodeAt(pmax - 1) === 32) {
            ws = pmax - 1;
            while (ws >= 1 && state.pending.charCodeAt(ws - 1) === 32) ws--;
            state.pending = state.pending.slice(0, ws);
            state.push("hardbreak", "br", 0);
          } else {
            state.pending = state.pending.slice(0, -1);
            state.push("softbreak", "br", 0);
          }
        } else {
          state.push("softbreak", "br", 0);
        }
      }
      pos++;
      while (pos < max3 && isSpace(state.src.charCodeAt(pos))) {
        pos++;
      }
      state.pos = pos;
      return true;
    };
  }
});

// node_modules/markdown-it/lib/rules_inline/escape.js
var require_escape = __commonJS({
  "node_modules/markdown-it/lib/rules_inline/escape.js"(exports, module) {
    "use strict";
    var isSpace = require_utils().isSpace;
    var ESCAPED = [];
    for (i3 = 0; i3 < 256; i3++) {
      ESCAPED.push(0);
    }
    var i3;
    "\\!\"#$%&'()*+,./:;<=>?@[]^_`{|}~-".split("").forEach(function(ch) {
      ESCAPED[ch.charCodeAt(0)] = 1;
    });
    module.exports = function escape2(state, silent) {
      var ch1, ch2, origStr, escapedStr, token, pos = state.pos, max3 = state.posMax;
      if (state.src.charCodeAt(pos) !== 92) return false;
      pos++;
      if (pos >= max3) return false;
      ch1 = state.src.charCodeAt(pos);
      if (ch1 === 10) {
        if (!silent) {
          state.push("hardbreak", "br", 0);
        }
        pos++;
        while (pos < max3) {
          ch1 = state.src.charCodeAt(pos);
          if (!isSpace(ch1)) break;
          pos++;
        }
        state.pos = pos;
        return true;
      }
      escapedStr = state.src[pos];
      if (ch1 >= 55296 && ch1 <= 56319 && pos + 1 < max3) {
        ch2 = state.src.charCodeAt(pos + 1);
        if (ch2 >= 56320 && ch2 <= 57343) {
          escapedStr += state.src[pos + 1];
          pos++;
        }
      }
      origStr = "\\" + escapedStr;
      if (!silent) {
        token = state.push("text_special", "", 0);
        if (ch1 < 256 && ESCAPED[ch1] !== 0) {
          token.content = escapedStr;
        } else {
          token.content = origStr;
        }
        token.markup = origStr;
        token.info = "escape";
      }
      state.pos = pos + 1;
      return true;
    };
  }
});

// node_modules/markdown-it/lib/rules_inline/backticks.js
var require_backticks = __commonJS({
  "node_modules/markdown-it/lib/rules_inline/backticks.js"(exports, module) {
    "use strict";
    module.exports = function backtick(state, silent) {
      var start, max3, marker, token, matchStart, matchEnd, openerLength, closerLength, pos = state.pos, ch = state.src.charCodeAt(pos);
      if (ch !== 96) {
        return false;
      }
      start = pos;
      pos++;
      max3 = state.posMax;
      while (pos < max3 && state.src.charCodeAt(pos) === 96) {
        pos++;
      }
      marker = state.src.slice(start, pos);
      openerLength = marker.length;
      if (state.backticksScanned && (state.backticks[openerLength] || 0) <= start) {
        if (!silent) state.pending += marker;
        state.pos += openerLength;
        return true;
      }
      matchStart = matchEnd = pos;
      while ((matchStart = state.src.indexOf("`", matchEnd)) !== -1) {
        matchEnd = matchStart + 1;
        while (matchEnd < max3 && state.src.charCodeAt(matchEnd) === 96) {
          matchEnd++;
        }
        closerLength = matchEnd - matchStart;
        if (closerLength === openerLength) {
          if (!silent) {
            token = state.push("code_inline", "code", 0);
            token.markup = marker;
            token.content = state.src.slice(pos, matchStart).replace(/\n/g, " ").replace(/^ (.+) $/, "$1");
          }
          state.pos = matchEnd;
          return true;
        }
        state.backticks[closerLength] = matchStart;
      }
      state.backticksScanned = true;
      if (!silent) state.pending += marker;
      state.pos += openerLength;
      return true;
    };
  }
});

// node_modules/markdown-it/lib/rules_inline/strikethrough.js
var require_strikethrough = __commonJS({
  "node_modules/markdown-it/lib/rules_inline/strikethrough.js"(exports, module) {
    "use strict";
    module.exports.tokenize = function strikethrough(state, silent) {
      var i3, scanned, token, len, ch, start = state.pos, marker = state.src.charCodeAt(start);
      if (silent) {
        return false;
      }
      if (marker !== 126) {
        return false;
      }
      scanned = state.scanDelims(state.pos, true);
      len = scanned.length;
      ch = String.fromCharCode(marker);
      if (len < 2) {
        return false;
      }
      if (len % 2) {
        token = state.push("text", "", 0);
        token.content = ch;
        len--;
      }
      for (i3 = 0; i3 < len; i3 += 2) {
        token = state.push("text", "", 0);
        token.content = ch + ch;
        state.delimiters.push({
          marker,
          length: 0,
          // disable "rule of 3" length checks meant for emphasis
          token: state.tokens.length - 1,
          end: -1,
          open: scanned.can_open,
          close: scanned.can_close
        });
      }
      state.pos += scanned.length;
      return true;
    };
    function postProcess(state, delimiters) {
      var i3, j, startDelim, endDelim, token, loneMarkers = [], max3 = delimiters.length;
      for (i3 = 0; i3 < max3; i3++) {
        startDelim = delimiters[i3];
        if (startDelim.marker !== 126) {
          continue;
        }
        if (startDelim.end === -1) {
          continue;
        }
        endDelim = delimiters[startDelim.end];
        token = state.tokens[startDelim.token];
        token.type = "s_open";
        token.tag = "s";
        token.nesting = 1;
        token.markup = "~~";
        token.content = "";
        token = state.tokens[endDelim.token];
        token.type = "s_close";
        token.tag = "s";
        token.nesting = -1;
        token.markup = "~~";
        token.content = "";
        if (state.tokens[endDelim.token - 1].type === "text" && state.tokens[endDelim.token - 1].content === "~") {
          loneMarkers.push(endDelim.token - 1);
        }
      }
      while (loneMarkers.length) {
        i3 = loneMarkers.pop();
        j = i3 + 1;
        while (j < state.tokens.length && state.tokens[j].type === "s_close") {
          j++;
        }
        j--;
        if (i3 !== j) {
          token = state.tokens[j];
          state.tokens[j] = state.tokens[i3];
          state.tokens[i3] = token;
        }
      }
    }
    module.exports.postProcess = function strikethrough(state) {
      var curr, tokens_meta = state.tokens_meta, max3 = state.tokens_meta.length;
      postProcess(state, state.delimiters);
      for (curr = 0; curr < max3; curr++) {
        if (tokens_meta[curr] && tokens_meta[curr].delimiters) {
          postProcess(state, tokens_meta[curr].delimiters);
        }
      }
    };
  }
});

// node_modules/markdown-it/lib/rules_inline/emphasis.js
var require_emphasis = __commonJS({
  "node_modules/markdown-it/lib/rules_inline/emphasis.js"(exports, module) {
    "use strict";
    module.exports.tokenize = function emphasis(state, silent) {
      var i3, scanned, token, start = state.pos, marker = state.src.charCodeAt(start);
      if (silent) {
        return false;
      }
      if (marker !== 95 && marker !== 42) {
        return false;
      }
      scanned = state.scanDelims(state.pos, marker === 42);
      for (i3 = 0; i3 < scanned.length; i3++) {
        token = state.push("text", "", 0);
        token.content = String.fromCharCode(marker);
        state.delimiters.push({
          // Char code of the starting marker (number).
          //
          marker,
          // Total length of these series of delimiters.
          //
          length: scanned.length,
          // A position of the token this delimiter corresponds to.
          //
          token: state.tokens.length - 1,
          // If this delimiter is matched as a valid opener, `end` will be
          // equal to its position, otherwise it's `-1`.
          //
          end: -1,
          // Boolean flags that determine if this delimiter could open or close
          // an emphasis.
          //
          open: scanned.can_open,
          close: scanned.can_close
        });
      }
      state.pos += scanned.length;
      return true;
    };
    function postProcess(state, delimiters) {
      var i3, startDelim, endDelim, token, ch, isStrong, max3 = delimiters.length;
      for (i3 = max3 - 1; i3 >= 0; i3--) {
        startDelim = delimiters[i3];
        if (startDelim.marker !== 95 && startDelim.marker !== 42) {
          continue;
        }
        if (startDelim.end === -1) {
          continue;
        }
        endDelim = delimiters[startDelim.end];
        isStrong = i3 > 0 && delimiters[i3 - 1].end === startDelim.end + 1 && // check that first two markers match and adjacent
        delimiters[i3 - 1].marker === startDelim.marker && delimiters[i3 - 1].token === startDelim.token - 1 && // check that last two markers are adjacent (we can safely assume they match)
        delimiters[startDelim.end + 1].token === endDelim.token + 1;
        ch = String.fromCharCode(startDelim.marker);
        token = state.tokens[startDelim.token];
        token.type = isStrong ? "strong_open" : "em_open";
        token.tag = isStrong ? "strong" : "em";
        token.nesting = 1;
        token.markup = isStrong ? ch + ch : ch;
        token.content = "";
        token = state.tokens[endDelim.token];
        token.type = isStrong ? "strong_close" : "em_close";
        token.tag = isStrong ? "strong" : "em";
        token.nesting = -1;
        token.markup = isStrong ? ch + ch : ch;
        token.content = "";
        if (isStrong) {
          state.tokens[delimiters[i3 - 1].token].content = "";
          state.tokens[delimiters[startDelim.end + 1].token].content = "";
          i3--;
        }
      }
    }
    module.exports.postProcess = function emphasis(state) {
      var curr, tokens_meta = state.tokens_meta, max3 = state.tokens_meta.length;
      postProcess(state, state.delimiters);
      for (curr = 0; curr < max3; curr++) {
        if (tokens_meta[curr] && tokens_meta[curr].delimiters) {
          postProcess(state, tokens_meta[curr].delimiters);
        }
      }
    };
  }
});

// node_modules/markdown-it/lib/rules_inline/link.js
var require_link = __commonJS({
  "node_modules/markdown-it/lib/rules_inline/link.js"(exports, module) {
    "use strict";
    var normalizeReference = require_utils().normalizeReference;
    var isSpace = require_utils().isSpace;
    module.exports = function link(state, silent) {
      var attrs2, code, label, labelEnd, labelStart, pos, res, ref, token, href = "", title = "", oldPos = state.pos, max3 = state.posMax, start = state.pos, parseReference = true;
      if (state.src.charCodeAt(state.pos) !== 91) {
        return false;
      }
      labelStart = state.pos + 1;
      labelEnd = state.md.helpers.parseLinkLabel(state, state.pos, true);
      if (labelEnd < 0) {
        return false;
      }
      pos = labelEnd + 1;
      if (pos < max3 && state.src.charCodeAt(pos) === 40) {
        parseReference = false;
        pos++;
        for (; pos < max3; pos++) {
          code = state.src.charCodeAt(pos);
          if (!isSpace(code) && code !== 10) {
            break;
          }
        }
        if (pos >= max3) {
          return false;
        }
        start = pos;
        res = state.md.helpers.parseLinkDestination(state.src, pos, state.posMax);
        if (res.ok) {
          href = state.md.normalizeLink(res.str);
          if (state.md.validateLink(href)) {
            pos = res.pos;
          } else {
            href = "";
          }
          start = pos;
          for (; pos < max3; pos++) {
            code = state.src.charCodeAt(pos);
            if (!isSpace(code) && code !== 10) {
              break;
            }
          }
          res = state.md.helpers.parseLinkTitle(state.src, pos, state.posMax);
          if (pos < max3 && start !== pos && res.ok) {
            title = res.str;
            pos = res.pos;
            for (; pos < max3; pos++) {
              code = state.src.charCodeAt(pos);
              if (!isSpace(code) && code !== 10) {
                break;
              }
            }
          }
        }
        if (pos >= max3 || state.src.charCodeAt(pos) !== 41) {
          parseReference = true;
        }
        pos++;
      }
      if (parseReference) {
        if (typeof state.env.references === "undefined") {
          return false;
        }
        if (pos < max3 && state.src.charCodeAt(pos) === 91) {
          start = pos + 1;
          pos = state.md.helpers.parseLinkLabel(state, pos);
          if (pos >= 0) {
            label = state.src.slice(start, pos++);
          } else {
            pos = labelEnd + 1;
          }
        } else {
          pos = labelEnd + 1;
        }
        if (!label) {
          label = state.src.slice(labelStart, labelEnd);
        }
        ref = state.env.references[normalizeReference(label)];
        if (!ref) {
          state.pos = oldPos;
          return false;
        }
        href = ref.href;
        title = ref.title;
      }
      if (!silent) {
        state.pos = labelStart;
        state.posMax = labelEnd;
        token = state.push("link_open", "a", 1);
        token.attrs = attrs2 = [["href", href]];
        if (title) {
          attrs2.push(["title", title]);
        }
        state.linkLevel++;
        state.md.inline.tokenize(state);
        state.linkLevel--;
        token = state.push("link_close", "a", -1);
      }
      state.pos = pos;
      state.posMax = max3;
      return true;
    };
  }
});

// node_modules/markdown-it/lib/rules_inline/image.js
var require_image = __commonJS({
  "node_modules/markdown-it/lib/rules_inline/image.js"(exports, module) {
    "use strict";
    var normalizeReference = require_utils().normalizeReference;
    var isSpace = require_utils().isSpace;
    module.exports = function image(state, silent) {
      var attrs2, code, content, label, labelEnd, labelStart, pos, ref, res, title, token, tokens, start, href = "", oldPos = state.pos, max3 = state.posMax;
      if (state.src.charCodeAt(state.pos) !== 33) {
        return false;
      }
      if (state.src.charCodeAt(state.pos + 1) !== 91) {
        return false;
      }
      labelStart = state.pos + 2;
      labelEnd = state.md.helpers.parseLinkLabel(state, state.pos + 1, false);
      if (labelEnd < 0) {
        return false;
      }
      pos = labelEnd + 1;
      if (pos < max3 && state.src.charCodeAt(pos) === 40) {
        pos++;
        for (; pos < max3; pos++) {
          code = state.src.charCodeAt(pos);
          if (!isSpace(code) && code !== 10) {
            break;
          }
        }
        if (pos >= max3) {
          return false;
        }
        start = pos;
        res = state.md.helpers.parseLinkDestination(state.src, pos, state.posMax);
        if (res.ok) {
          href = state.md.normalizeLink(res.str);
          if (state.md.validateLink(href)) {
            pos = res.pos;
          } else {
            href = "";
          }
        }
        start = pos;
        for (; pos < max3; pos++) {
          code = state.src.charCodeAt(pos);
          if (!isSpace(code) && code !== 10) {
            break;
          }
        }
        res = state.md.helpers.parseLinkTitle(state.src, pos, state.posMax);
        if (pos < max3 && start !== pos && res.ok) {
          title = res.str;
          pos = res.pos;
          for (; pos < max3; pos++) {
            code = state.src.charCodeAt(pos);
            if (!isSpace(code) && code !== 10) {
              break;
            }
          }
        } else {
          title = "";
        }
        if (pos >= max3 || state.src.charCodeAt(pos) !== 41) {
          state.pos = oldPos;
          return false;
        }
        pos++;
      } else {
        if (typeof state.env.references === "undefined") {
          return false;
        }
        if (pos < max3 && state.src.charCodeAt(pos) === 91) {
          start = pos + 1;
          pos = state.md.helpers.parseLinkLabel(state, pos);
          if (pos >= 0) {
            label = state.src.slice(start, pos++);
          } else {
            pos = labelEnd + 1;
          }
        } else {
          pos = labelEnd + 1;
        }
        if (!label) {
          label = state.src.slice(labelStart, labelEnd);
        }
        ref = state.env.references[normalizeReference(label)];
        if (!ref) {
          state.pos = oldPos;
          return false;
        }
        href = ref.href;
        title = ref.title;
      }
      if (!silent) {
        content = state.src.slice(labelStart, labelEnd);
        state.md.inline.parse(
          content,
          state.md,
          state.env,
          tokens = []
        );
        token = state.push("image", "img", 0);
        token.attrs = attrs2 = [["src", href], ["alt", ""]];
        token.children = tokens;
        token.content = content;
        if (title) {
          attrs2.push(["title", title]);
        }
      }
      state.pos = pos;
      state.posMax = max3;
      return true;
    };
  }
});

// node_modules/markdown-it/lib/rules_inline/autolink.js
var require_autolink = __commonJS({
  "node_modules/markdown-it/lib/rules_inline/autolink.js"(exports, module) {
    "use strict";
    var EMAIL_RE = /^([a-zA-Z0-9.!#$%&'*+\/=?^_`{|}~-]+@[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?(?:\.[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?)*)$/;
    var AUTOLINK_RE = /^([a-zA-Z][a-zA-Z0-9+.\-]{1,31}):([^<>\x00-\x20]*)$/;
    module.exports = function autolink(state, silent) {
      var url2, fullUrl, token, ch, start, max3, pos = state.pos;
      if (state.src.charCodeAt(pos) !== 60) {
        return false;
      }
      start = state.pos;
      max3 = state.posMax;
      for (; ; ) {
        if (++pos >= max3) return false;
        ch = state.src.charCodeAt(pos);
        if (ch === 60) return false;
        if (ch === 62) break;
      }
      url2 = state.src.slice(start + 1, pos);
      if (AUTOLINK_RE.test(url2)) {
        fullUrl = state.md.normalizeLink(url2);
        if (!state.md.validateLink(fullUrl)) {
          return false;
        }
        if (!silent) {
          token = state.push("link_open", "a", 1);
          token.attrs = [["href", fullUrl]];
          token.markup = "autolink";
          token.info = "auto";
          token = state.push("text", "", 0);
          token.content = state.md.normalizeLinkText(url2);
          token = state.push("link_close", "a", -1);
          token.markup = "autolink";
          token.info = "auto";
        }
        state.pos += url2.length + 2;
        return true;
      }
      if (EMAIL_RE.test(url2)) {
        fullUrl = state.md.normalizeLink("mailto:" + url2);
        if (!state.md.validateLink(fullUrl)) {
          return false;
        }
        if (!silent) {
          token = state.push("link_open", "a", 1);
          token.attrs = [["href", fullUrl]];
          token.markup = "autolink";
          token.info = "auto";
          token = state.push("text", "", 0);
          token.content = state.md.normalizeLinkText(url2);
          token = state.push("link_close", "a", -1);
          token.markup = "autolink";
          token.info = "auto";
        }
        state.pos += url2.length + 2;
        return true;
      }
      return false;
    };
  }
});

// node_modules/markdown-it/lib/rules_inline/html_inline.js
var require_html_inline = __commonJS({
  "node_modules/markdown-it/lib/rules_inline/html_inline.js"(exports, module) {
    "use strict";
    var HTML_TAG_RE = require_html_re().HTML_TAG_RE;
    function isLinkOpen(str) {
      return /^<a[>\s]/i.test(str);
    }
    function isLinkClose(str) {
      return /^<\/a\s*>/i.test(str);
    }
    function isLetter(ch) {
      var lc = ch | 32;
      return lc >= 97 && lc <= 122;
    }
    module.exports = function html_inline(state, silent) {
      var ch, match, max3, token, pos = state.pos;
      if (!state.md.options.html) {
        return false;
      }
      max3 = state.posMax;
      if (state.src.charCodeAt(pos) !== 60 || pos + 2 >= max3) {
        return false;
      }
      ch = state.src.charCodeAt(pos + 1);
      if (ch !== 33 && ch !== 63 && ch !== 47 && !isLetter(ch)) {
        return false;
      }
      match = state.src.slice(pos).match(HTML_TAG_RE);
      if (!match) {
        return false;
      }
      if (!silent) {
        token = state.push("html_inline", "", 0);
        token.content = state.src.slice(pos, pos + match[0].length);
        if (isLinkOpen(token.content)) state.linkLevel++;
        if (isLinkClose(token.content)) state.linkLevel--;
      }
      state.pos += match[0].length;
      return true;
    };
  }
});

// node_modules/markdown-it/lib/rules_inline/entity.js
var require_entity = __commonJS({
  "node_modules/markdown-it/lib/rules_inline/entity.js"(exports, module) {
    "use strict";
    var entities = require_entities2();
    var has3 = require_utils().has;
    var isValidEntityCode = require_utils().isValidEntityCode;
    var fromCodePoint = require_utils().fromCodePoint;
    var DIGITAL_RE = /^&#((?:x[a-f0-9]{1,6}|[0-9]{1,7}));/i;
    var NAMED_RE = /^&([a-z][a-z0-9]{1,31});/i;
    module.exports = function entity(state, silent) {
      var ch, code, match, token, pos = state.pos, max3 = state.posMax;
      if (state.src.charCodeAt(pos) !== 38) return false;
      if (pos + 1 >= max3) return false;
      ch = state.src.charCodeAt(pos + 1);
      if (ch === 35) {
        match = state.src.slice(pos).match(DIGITAL_RE);
        if (match) {
          if (!silent) {
            code = match[1][0].toLowerCase() === "x" ? parseInt(match[1].slice(1), 16) : parseInt(match[1], 10);
            token = state.push("text_special", "", 0);
            token.content = isValidEntityCode(code) ? fromCodePoint(code) : fromCodePoint(65533);
            token.markup = match[0];
            token.info = "entity";
          }
          state.pos += match[0].length;
          return true;
        }
      } else {
        match = state.src.slice(pos).match(NAMED_RE);
        if (match) {
          if (has3(entities, match[1])) {
            if (!silent) {
              token = state.push("text_special", "", 0);
              token.content = entities[match[1]];
              token.markup = match[0];
              token.info = "entity";
            }
            state.pos += match[0].length;
            return true;
          }
        }
      }
      return false;
    };
  }
});

// node_modules/markdown-it/lib/rules_inline/balance_pairs.js
var require_balance_pairs = __commonJS({
  "node_modules/markdown-it/lib/rules_inline/balance_pairs.js"(exports, module) {
    "use strict";
    function processDelimiters(state, delimiters) {
      var closerIdx, openerIdx, closer, opener, minOpenerIdx, newMinOpenerIdx, isOddMatch, lastJump, openersBottom = {}, max3 = delimiters.length;
      if (!max3) return;
      var headerIdx = 0;
      var lastTokenIdx = -2;
      var jumps = [];
      for (closerIdx = 0; closerIdx < max3; closerIdx++) {
        closer = delimiters[closerIdx];
        jumps.push(0);
        if (delimiters[headerIdx].marker !== closer.marker || lastTokenIdx !== closer.token - 1) {
          headerIdx = closerIdx;
        }
        lastTokenIdx = closer.token;
        closer.length = closer.length || 0;
        if (!closer.close) continue;
        if (!openersBottom.hasOwnProperty(closer.marker)) {
          openersBottom[closer.marker] = [-1, -1, -1, -1, -1, -1];
        }
        minOpenerIdx = openersBottom[closer.marker][(closer.open ? 3 : 0) + closer.length % 3];
        openerIdx = headerIdx - jumps[headerIdx] - 1;
        newMinOpenerIdx = openerIdx;
        for (; openerIdx > minOpenerIdx; openerIdx -= jumps[openerIdx] + 1) {
          opener = delimiters[openerIdx];
          if (opener.marker !== closer.marker) continue;
          if (opener.open && opener.end < 0) {
            isOddMatch = false;
            if (opener.close || closer.open) {
              if ((opener.length + closer.length) % 3 === 0) {
                if (opener.length % 3 !== 0 || closer.length % 3 !== 0) {
                  isOddMatch = true;
                }
              }
            }
            if (!isOddMatch) {
              lastJump = openerIdx > 0 && !delimiters[openerIdx - 1].open ? jumps[openerIdx - 1] + 1 : 0;
              jumps[closerIdx] = closerIdx - openerIdx + lastJump;
              jumps[openerIdx] = lastJump;
              closer.open = false;
              opener.end = closerIdx;
              opener.close = false;
              newMinOpenerIdx = -1;
              lastTokenIdx = -2;
              break;
            }
          }
        }
        if (newMinOpenerIdx !== -1) {
          openersBottom[closer.marker][(closer.open ? 3 : 0) + (closer.length || 0) % 3] = newMinOpenerIdx;
        }
      }
    }
    module.exports = function link_pairs(state) {
      var curr, tokens_meta = state.tokens_meta, max3 = state.tokens_meta.length;
      processDelimiters(state, state.delimiters);
      for (curr = 0; curr < max3; curr++) {
        if (tokens_meta[curr] && tokens_meta[curr].delimiters) {
          processDelimiters(state, tokens_meta[curr].delimiters);
        }
      }
    };
  }
});

// node_modules/markdown-it/lib/rules_inline/fragments_join.js
var require_fragments_join = __commonJS({
  "node_modules/markdown-it/lib/rules_inline/fragments_join.js"(exports, module) {
    "use strict";
    module.exports = function fragments_join(state) {
      var curr, last3, level = 0, tokens = state.tokens, max3 = state.tokens.length;
      for (curr = last3 = 0; curr < max3; curr++) {
        if (tokens[curr].nesting < 0) level--;
        tokens[curr].level = level;
        if (tokens[curr].nesting > 0) level++;
        if (tokens[curr].type === "text" && curr + 1 < max3 && tokens[curr + 1].type === "text") {
          tokens[curr + 1].content = tokens[curr].content + tokens[curr + 1].content;
        } else {
          if (curr !== last3) {
            tokens[last3] = tokens[curr];
          }
          last3++;
        }
      }
      if (curr !== last3) {
        tokens.length = last3;
      }
    };
  }
});

// node_modules/markdown-it/lib/rules_inline/state_inline.js
var require_state_inline = __commonJS({
  "node_modules/markdown-it/lib/rules_inline/state_inline.js"(exports, module) {
    "use strict";
    var Token = require_token();
    var isWhiteSpace = require_utils().isWhiteSpace;
    var isPunctChar = require_utils().isPunctChar;
    var isMdAsciiPunct = require_utils().isMdAsciiPunct;
    function StateInline(src, md2, env, outTokens) {
      this.src = src;
      this.env = env;
      this.md = md2;
      this.tokens = outTokens;
      this.tokens_meta = Array(outTokens.length);
      this.pos = 0;
      this.posMax = this.src.length;
      this.level = 0;
      this.pending = "";
      this.pendingLevel = 0;
      this.cache = {};
      this.delimiters = [];
      this._prev_delimiters = [];
      this.backticks = {};
      this.backticksScanned = false;
      this.linkLevel = 0;
    }
    StateInline.prototype.pushPending = function() {
      var token = new Token("text", "", 0);
      token.content = this.pending;
      token.level = this.pendingLevel;
      this.tokens.push(token);
      this.pending = "";
      return token;
    };
    StateInline.prototype.push = function(type, tag, nesting) {
      if (this.pending) {
        this.pushPending();
      }
      var token = new Token(type, tag, nesting);
      var token_meta = null;
      if (nesting < 0) {
        this.level--;
        this.delimiters = this._prev_delimiters.pop();
      }
      token.level = this.level;
      if (nesting > 0) {
        this.level++;
        this._prev_delimiters.push(this.delimiters);
        this.delimiters = [];
        token_meta = { delimiters: this.delimiters };
      }
      this.pendingLevel = this.level;
      this.tokens.push(token);
      this.tokens_meta.push(token_meta);
      return token;
    };
    StateInline.prototype.scanDelims = function(start, canSplitWord) {
      var pos = start, lastChar, nextChar, count, can_open, can_close, isLastWhiteSpace, isLastPunctChar, isNextWhiteSpace, isNextPunctChar, left_flanking = true, right_flanking = true, max3 = this.posMax, marker = this.src.charCodeAt(start);
      lastChar = start > 0 ? this.src.charCodeAt(start - 1) : 32;
      while (pos < max3 && this.src.charCodeAt(pos) === marker) {
        pos++;
      }
      count = pos - start;
      nextChar = pos < max3 ? this.src.charCodeAt(pos) : 32;
      isLastPunctChar = isMdAsciiPunct(lastChar) || isPunctChar(String.fromCharCode(lastChar));
      isNextPunctChar = isMdAsciiPunct(nextChar) || isPunctChar(String.fromCharCode(nextChar));
      isLastWhiteSpace = isWhiteSpace(lastChar);
      isNextWhiteSpace = isWhiteSpace(nextChar);
      if (isNextWhiteSpace) {
        left_flanking = false;
      } else if (isNextPunctChar) {
        if (!(isLastWhiteSpace || isLastPunctChar)) {
          left_flanking = false;
        }
      }
      if (isLastWhiteSpace) {
        right_flanking = false;
      } else if (isLastPunctChar) {
        if (!(isNextWhiteSpace || isNextPunctChar)) {
          right_flanking = false;
        }
      }
      if (!canSplitWord) {
        can_open = left_flanking && (!right_flanking || isLastPunctChar);
        can_close = right_flanking && (!left_flanking || isNextPunctChar);
      } else {
        can_open = left_flanking;
        can_close = right_flanking;
      }
      return {
        can_open,
        can_close,
        length: count
      };
    };
    StateInline.prototype.Token = Token;
    module.exports = StateInline;
  }
});

// node_modules/markdown-it/lib/parser_inline.js
var require_parser_inline = __commonJS({
  "node_modules/markdown-it/lib/parser_inline.js"(exports, module) {
    "use strict";
    var Ruler = require_ruler();
    var _rules = [
      ["text", require_text()],
      ["linkify", require_linkify2()],
      ["newline", require_newline()],
      ["escape", require_escape()],
      ["backticks", require_backticks()],
      ["strikethrough", require_strikethrough().tokenize],
      ["emphasis", require_emphasis().tokenize],
      ["link", require_link()],
      ["image", require_image()],
      ["autolink", require_autolink()],
      ["html_inline", require_html_inline()],
      ["entity", require_entity()]
    ];
    var _rules2 = [
      ["balance_pairs", require_balance_pairs()],
      ["strikethrough", require_strikethrough().postProcess],
      ["emphasis", require_emphasis().postProcess],
      // rules for pairs separate '**' into its own text tokens, which may be left unused,
      // rule below merges unused segments back with the rest of the text
      ["fragments_join", require_fragments_join()]
    ];
    function ParserInline() {
      var i3;
      this.ruler = new Ruler();
      for (i3 = 0; i3 < _rules.length; i3++) {
        this.ruler.push(_rules[i3][0], _rules[i3][1]);
      }
      this.ruler2 = new Ruler();
      for (i3 = 0; i3 < _rules2.length; i3++) {
        this.ruler2.push(_rules2[i3][0], _rules2[i3][1]);
      }
    }
    ParserInline.prototype.skipToken = function(state) {
      var ok, i3, pos = state.pos, rules = this.ruler.getRules(""), len = rules.length, maxNesting = state.md.options.maxNesting, cache3 = state.cache;
      if (typeof cache3[pos] !== "undefined") {
        state.pos = cache3[pos];
        return;
      }
      if (state.level < maxNesting) {
        for (i3 = 0; i3 < len; i3++) {
          state.level++;
          ok = rules[i3](state, true);
          state.level--;
          if (ok) {
            break;
          }
        }
      } else {
        state.pos = state.posMax;
      }
      if (!ok) {
        state.pos++;
      }
      cache3[pos] = state.pos;
    };
    ParserInline.prototype.tokenize = function(state) {
      var ok, i3, rules = this.ruler.getRules(""), len = rules.length, end = state.posMax, maxNesting = state.md.options.maxNesting;
      while (state.pos < end) {
        if (state.level < maxNesting) {
          for (i3 = 0; i3 < len; i3++) {
            ok = rules[i3](state, false);
            if (ok) {
              break;
            }
          }
        }
        if (ok) {
          if (state.pos >= end) {
            break;
          }
          continue;
        }
        state.pending += state.src[state.pos++];
      }
      if (state.pending) {
        state.pushPending();
      }
    };
    ParserInline.prototype.parse = function(str, md2, env, outTokens) {
      var i3, rules, len;
      var state = new this.State(str, md2, env, outTokens);
      this.tokenize(state);
      rules = this.ruler2.getRules("");
      len = rules.length;
      for (i3 = 0; i3 < len; i3++) {
        rules[i3](state);
      }
    };
    ParserInline.prototype.State = require_state_inline();
    module.exports = ParserInline;
  }
});

// node_modules/linkify-it/lib/re.js
var require_re = __commonJS({
  "node_modules/linkify-it/lib/re.js"(exports, module) {
    "use strict";
    module.exports = function(opts) {
      var re = {};
      opts = opts || {};
      re.src_Any = require_regex2().source;
      re.src_Cc = require_regex3().source;
      re.src_Z = require_regex5().source;
      re.src_P = require_regex().source;
      re.src_ZPCc = [re.src_Z, re.src_P, re.src_Cc].join("|");
      re.src_ZCc = [re.src_Z, re.src_Cc].join("|");
      var text_separators = "[><\uFF5C]";
      re.src_pseudo_letter = "(?:(?!" + text_separators + "|" + re.src_ZPCc + ")" + re.src_Any + ")";
      re.src_ip4 = "(?:(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)";
      re.src_auth = "(?:(?:(?!" + re.src_ZCc + "|[@/\\[\\]()]).)+@)?";
      re.src_port = "(?::(?:6(?:[0-4]\\d{3}|5(?:[0-4]\\d{2}|5(?:[0-2]\\d|3[0-5])))|[1-5]?\\d{1,4}))?";
      re.src_host_terminator = "(?=$|" + text_separators + "|" + re.src_ZPCc + ")(?!" + (opts["---"] ? "-(?!--)|" : "-|") + "_|:\\d|\\.-|\\.(?!$|" + re.src_ZPCc + "))";
      re.src_path = "(?:[/?#](?:(?!" + re.src_ZCc + "|" + text_separators + `|[()[\\]{}.,"'?!\\-;]).|\\[(?:(?!` + re.src_ZCc + "|\\]).)*\\]|\\((?:(?!" + re.src_ZCc + "|[)]).)*\\)|\\{(?:(?!" + re.src_ZCc + '|[}]).)*\\}|\\"(?:(?!' + re.src_ZCc + `|["]).)+\\"|\\'(?:(?!` + re.src_ZCc + "|[']).)+\\'|\\'(?=" + re.src_pseudo_letter + "|[-])|\\.{2,}[a-zA-Z0-9%/&]|\\.(?!" + re.src_ZCc + "|[.]|$)|" + (opts["---"] ? "\\-(?!--(?:[^-]|$))(?:-*)|" : "\\-+|") + ",(?!" + re.src_ZCc + "|$)|;(?!" + re.src_ZCc + "|$)|\\!+(?!" + re.src_ZCc + "|[!]|$)|\\?(?!" + re.src_ZCc + "|[?]|$))+|\\/)?";
      re.src_email_name = '[\\-;:&=\\+\\$,\\.a-zA-Z0-9_][\\-;:&=\\+\\$,\\"\\.a-zA-Z0-9_]*';
      re.src_xn = "xn--[a-z0-9\\-]{1,59}";
      re.src_domain_root = // Allow letters & digits (http://test1)
      "(?:" + re.src_xn + "|" + re.src_pseudo_letter + "{1,63})";
      re.src_domain = "(?:" + re.src_xn + "|(?:" + re.src_pseudo_letter + ")|(?:" + re.src_pseudo_letter + "(?:-|" + re.src_pseudo_letter + "){0,61}" + re.src_pseudo_letter + "))";
      re.src_host = "(?:(?:(?:(?:" + re.src_domain + ")\\.)*" + re.src_domain + "))";
      re.tpl_host_fuzzy = "(?:" + re.src_ip4 + "|(?:(?:(?:" + re.src_domain + ")\\.)+(?:%TLDS%)))";
      re.tpl_host_no_ip_fuzzy = "(?:(?:(?:" + re.src_domain + ")\\.)+(?:%TLDS%))";
      re.src_host_strict = re.src_host + re.src_host_terminator;
      re.tpl_host_fuzzy_strict = re.tpl_host_fuzzy + re.src_host_terminator;
      re.src_host_port_strict = re.src_host + re.src_port + re.src_host_terminator;
      re.tpl_host_port_fuzzy_strict = re.tpl_host_fuzzy + re.src_port + re.src_host_terminator;
      re.tpl_host_port_no_ip_fuzzy_strict = re.tpl_host_no_ip_fuzzy + re.src_port + re.src_host_terminator;
      re.tpl_host_fuzzy_test = "localhost|www\\.|\\.\\d{1,3}\\.|(?:\\.(?:%TLDS%)(?:" + re.src_ZPCc + "|>|$))";
      re.tpl_email_fuzzy = "(^|" + text_separators + '|"|\\(|' + re.src_ZCc + ")(" + re.src_email_name + "@" + re.tpl_host_fuzzy_strict + ")";
      re.tpl_link_fuzzy = // Fuzzy link can't be prepended with .:/\- and non punctuation.
      // but can start with > (markdown blockquote)
      "(^|(?![.:/\\-_@])(?:[$+<=>^`|\uFF5C]|" + re.src_ZPCc + "))((?![$+<=>^`|\uFF5C])" + re.tpl_host_port_fuzzy_strict + re.src_path + ")";
      re.tpl_link_no_ip_fuzzy = // Fuzzy link can't be prepended with .:/\- and non punctuation.
      // but can start with > (markdown blockquote)
      "(^|(?![.:/\\-_@])(?:[$+<=>^`|\uFF5C]|" + re.src_ZPCc + "))((?![$+<=>^`|\uFF5C])" + re.tpl_host_port_no_ip_fuzzy_strict + re.src_path + ")";
      return re;
    };
  }
});

// node_modules/linkify-it/index.js
var require_linkify_it = __commonJS({
  "node_modules/linkify-it/index.js"(exports, module) {
    "use strict";
    function assign3(obj) {
      var sources = Array.prototype.slice.call(arguments, 1);
      sources.forEach(function(source) {
        if (!source) {
          return;
        }
        Object.keys(source).forEach(function(key) {
          obj[key] = source[key];
        });
      });
      return obj;
    }
    function _class(obj) {
      return Object.prototype.toString.call(obj);
    }
    function isString3(obj) {
      return _class(obj) === "[object String]";
    }
    function isObject4(obj) {
      return _class(obj) === "[object Object]";
    }
    function isRegExp(obj) {
      return _class(obj) === "[object RegExp]";
    }
    function isFunction3(obj) {
      return _class(obj) === "[object Function]";
    }
    function escapeRE(str) {
      return str.replace(/[.?*+^$[\]\\(){}|-]/g, "\\$&");
    }
    var defaultOptions2 = {
      fuzzyLink: true,
      fuzzyEmail: true,
      fuzzyIP: false
    };
    function isOptionsObj(obj) {
      return Object.keys(obj || {}).reduce(function(acc, k2) {
        return acc || defaultOptions2.hasOwnProperty(k2);
      }, false);
    }
    var defaultSchemas = {
      "http:": {
        validate: function(text, pos, self2) {
          var tail = text.slice(pos);
          if (!self2.re.http) {
            self2.re.http = new RegExp(
              "^\\/\\/" + self2.re.src_auth + self2.re.src_host_port_strict + self2.re.src_path,
              "i"
            );
          }
          if (self2.re.http.test(tail)) {
            return tail.match(self2.re.http)[0].length;
          }
          return 0;
        }
      },
      "https:": "http:",
      "ftp:": "http:",
      "//": {
        validate: function(text, pos, self2) {
          var tail = text.slice(pos);
          if (!self2.re.no_http) {
            self2.re.no_http = new RegExp(
              "^" + self2.re.src_auth + // Don't allow single-level domains, because of false positives like '//test'
              // with code comments
              "(?:localhost|(?:(?:" + self2.re.src_domain + ")\\.)+" + self2.re.src_domain_root + ")" + self2.re.src_port + self2.re.src_host_terminator + self2.re.src_path,
              "i"
            );
          }
          if (self2.re.no_http.test(tail)) {
            if (pos >= 3 && text[pos - 3] === ":") {
              return 0;
            }
            if (pos >= 3 && text[pos - 3] === "/") {
              return 0;
            }
            return tail.match(self2.re.no_http)[0].length;
          }
          return 0;
        }
      },
      "mailto:": {
        validate: function(text, pos, self2) {
          var tail = text.slice(pos);
          if (!self2.re.mailto) {
            self2.re.mailto = new RegExp(
              "^" + self2.re.src_email_name + "@" + self2.re.src_host_strict,
              "i"
            );
          }
          if (self2.re.mailto.test(tail)) {
            return tail.match(self2.re.mailto)[0].length;
          }
          return 0;
        }
      }
    };
    var tlds_2ch_src_re = "a[cdefgilmnoqrstuwxz]|b[abdefghijmnorstvwyz]|c[acdfghiklmnoruvwxyz]|d[ejkmoz]|e[cegrstu]|f[ijkmor]|g[abdefghilmnpqrstuwy]|h[kmnrtu]|i[delmnoqrst]|j[emop]|k[eghimnprwyz]|l[abcikrstuvy]|m[acdeghklmnopqrstuvwxyz]|n[acefgilopruz]|om|p[aefghklmnrstwy]|qa|r[eosuw]|s[abcdeghijklmnortuvxyz]|t[cdfghjklmnortvwz]|u[agksyz]|v[aceginu]|w[fs]|y[et]|z[amw]";
    var tlds_default = "biz|com|edu|gov|net|org|pro|web|xxx|aero|asia|coop|info|museum|name|shop|\u0440\u0444".split("|");
    function resetScanCache(self2) {
      self2.__index__ = -1;
      self2.__text_cache__ = "";
    }
    function createValidator(re) {
      return function(text, pos) {
        var tail = text.slice(pos);
        if (re.test(tail)) {
          return tail.match(re)[0].length;
        }
        return 0;
      };
    }
    function createNormalizer() {
      return function(match, self2) {
        self2.normalize(match);
      };
    }
    function compile(self2) {
      var re = self2.re = require_re()(self2.__opts__);
      var tlds = self2.__tlds__.slice();
      self2.onCompile();
      if (!self2.__tlds_replaced__) {
        tlds.push(tlds_2ch_src_re);
      }
      tlds.push(re.src_xn);
      re.src_tlds = tlds.join("|");
      function untpl(tpl) {
        return tpl.replace("%TLDS%", re.src_tlds);
      }
      re.email_fuzzy = RegExp(untpl(re.tpl_email_fuzzy), "i");
      re.link_fuzzy = RegExp(untpl(re.tpl_link_fuzzy), "i");
      re.link_no_ip_fuzzy = RegExp(untpl(re.tpl_link_no_ip_fuzzy), "i");
      re.host_fuzzy_test = RegExp(untpl(re.tpl_host_fuzzy_test), "i");
      var aliases = [];
      self2.__compiled__ = {};
      function schemaError(name, val) {
        throw new Error('(LinkifyIt) Invalid schema "' + name + '": ' + val);
      }
      Object.keys(self2.__schemas__).forEach(function(name) {
        var val = self2.__schemas__[name];
        if (val === null) {
          return;
        }
        var compiled = { validate: null, link: null };
        self2.__compiled__[name] = compiled;
        if (isObject4(val)) {
          if (isRegExp(val.validate)) {
            compiled.validate = createValidator(val.validate);
          } else if (isFunction3(val.validate)) {
            compiled.validate = val.validate;
          } else {
            schemaError(name, val);
          }
          if (isFunction3(val.normalize)) {
            compiled.normalize = val.normalize;
          } else if (!val.normalize) {
            compiled.normalize = createNormalizer();
          } else {
            schemaError(name, val);
          }
          return;
        }
        if (isString3(val)) {
          aliases.push(name);
          return;
        }
        schemaError(name, val);
      });
      aliases.forEach(function(alias) {
        if (!self2.__compiled__[self2.__schemas__[alias]]) {
          return;
        }
        self2.__compiled__[alias].validate = self2.__compiled__[self2.__schemas__[alias]].validate;
        self2.__compiled__[alias].normalize = self2.__compiled__[self2.__schemas__[alias]].normalize;
      });
      self2.__compiled__[""] = { validate: null, normalize: createNormalizer() };
      var slist = Object.keys(self2.__compiled__).filter(function(name) {
        return name.length > 0 && self2.__compiled__[name];
      }).map(escapeRE).join("|");
      self2.re.schema_test = RegExp("(^|(?!_)(?:[><\uFF5C]|" + re.src_ZPCc + "))(" + slist + ")", "i");
      self2.re.schema_search = RegExp("(^|(?!_)(?:[><\uFF5C]|" + re.src_ZPCc + "))(" + slist + ")", "ig");
      self2.re.schema_at_start = RegExp("^" + self2.re.schema_search.source, "i");
      self2.re.pretest = RegExp(
        "(" + self2.re.schema_test.source + ")|(" + self2.re.host_fuzzy_test.source + ")|@",
        "i"
      );
      resetScanCache(self2);
    }
    function Match2(self2, shift2) {
      var start = self2.__index__, end = self2.__last_index__, text = self2.__text_cache__.slice(start, end);
      this.schema = self2.__schema__.toLowerCase();
      this.index = start + shift2;
      this.lastIndex = end + shift2;
      this.raw = text;
      this.text = text;
      this.url = text;
    }
    function createMatch(self2, shift2) {
      var match = new Match2(self2, shift2);
      self2.__compiled__[match.schema].normalize(match, self2);
      return match;
    }
    function LinkifyIt(schemas, options2) {
      if (!(this instanceof LinkifyIt)) {
        return new LinkifyIt(schemas, options2);
      }
      if (!options2) {
        if (isOptionsObj(schemas)) {
          options2 = schemas;
          schemas = {};
        }
      }
      this.__opts__ = assign3({}, defaultOptions2, options2);
      this.__index__ = -1;
      this.__last_index__ = -1;
      this.__schema__ = "";
      this.__text_cache__ = "";
      this.__schemas__ = assign3({}, defaultSchemas, schemas);
      this.__compiled__ = {};
      this.__tlds__ = tlds_default;
      this.__tlds_replaced__ = false;
      this.re = {};
      compile(this);
    }
    LinkifyIt.prototype.add = function add3(schema4, definition) {
      this.__schemas__[schema4] = definition;
      compile(this);
      return this;
    };
    LinkifyIt.prototype.set = function set(options2) {
      this.__opts__ = assign3(this.__opts__, options2);
      return this;
    };
    LinkifyIt.prototype.test = function test(text) {
      this.__text_cache__ = text;
      this.__index__ = -1;
      if (!text.length) {
        return false;
      }
      var m3, ml, me, len, shift2, next2, re, tld_pos, at_pos;
      if (this.re.schema_test.test(text)) {
        re = this.re.schema_search;
        re.lastIndex = 0;
        while ((m3 = re.exec(text)) !== null) {
          len = this.testSchemaAt(text, m3[2], re.lastIndex);
          if (len) {
            this.__schema__ = m3[2];
            this.__index__ = m3.index + m3[1].length;
            this.__last_index__ = m3.index + m3[0].length + len;
            break;
          }
        }
      }
      if (this.__opts__.fuzzyLink && this.__compiled__["http:"]) {
        tld_pos = text.search(this.re.host_fuzzy_test);
        if (tld_pos >= 0) {
          if (this.__index__ < 0 || tld_pos < this.__index__) {
            if ((ml = text.match(this.__opts__.fuzzyIP ? this.re.link_fuzzy : this.re.link_no_ip_fuzzy)) !== null) {
              shift2 = ml.index + ml[1].length;
              if (this.__index__ < 0 || shift2 < this.__index__) {
                this.__schema__ = "";
                this.__index__ = shift2;
                this.__last_index__ = ml.index + ml[0].length;
              }
            }
          }
        }
      }
      if (this.__opts__.fuzzyEmail && this.__compiled__["mailto:"]) {
        at_pos = text.indexOf("@");
        if (at_pos >= 0) {
          if ((me = text.match(this.re.email_fuzzy)) !== null) {
            shift2 = me.index + me[1].length;
            next2 = me.index + me[0].length;
            if (this.__index__ < 0 || shift2 < this.__index__ || shift2 === this.__index__ && next2 > this.__last_index__) {
              this.__schema__ = "mailto:";
              this.__index__ = shift2;
              this.__last_index__ = next2;
            }
          }
        }
      }
      return this.__index__ >= 0;
    };
    LinkifyIt.prototype.pretest = function pretest(text) {
      return this.re.pretest.test(text);
    };
    LinkifyIt.prototype.testSchemaAt = function testSchemaAt(text, schema4, pos) {
      if (!this.__compiled__[schema4.toLowerCase()]) {
        return 0;
      }
      return this.__compiled__[schema4.toLowerCase()].validate(text, pos, this);
    };
    LinkifyIt.prototype.match = function match(text) {
      var shift2 = 0, result2 = [];
      if (this.__index__ >= 0 && this.__text_cache__ === text) {
        result2.push(createMatch(this, shift2));
        shift2 = this.__last_index__;
      }
      var tail = shift2 ? text.slice(shift2) : text;
      while (this.test(tail)) {
        result2.push(createMatch(this, shift2));
        tail = tail.slice(this.__last_index__);
        shift2 += this.__last_index__;
      }
      if (result2.length) {
        return result2;
      }
      return null;
    };
    LinkifyIt.prototype.matchAtStart = function matchAtStart(text) {
      this.__text_cache__ = text;
      this.__index__ = -1;
      if (!text.length) return null;
      var m3 = this.re.schema_at_start.exec(text);
      if (!m3) return null;
      var len = this.testSchemaAt(text, m3[2], m3[0].length);
      if (!len) return null;
      this.__schema__ = m3[2];
      this.__index__ = m3.index + m3[1].length;
      this.__last_index__ = m3.index + m3[0].length + len;
      return createMatch(this, 0);
    };
    LinkifyIt.prototype.tlds = function tlds(list, keepOld) {
      list = Array.isArray(list) ? list : [list];
      if (!keepOld) {
        this.__tlds__ = list.slice();
        this.__tlds_replaced__ = true;
        compile(this);
        return this;
      }
      this.__tlds__ = this.__tlds__.concat(list).sort().filter(function(el, idx, arr) {
        return el !== arr[idx - 1];
      }).reverse();
      compile(this);
      return this;
    };
    LinkifyIt.prototype.normalize = function normalize2(match) {
      if (!match.schema) {
        match.url = "http://" + match.url;
      }
      if (match.schema === "mailto:" && !/^mailto:/i.test(match.url)) {
        match.url = "mailto:" + match.url;
      }
    };
    LinkifyIt.prototype.onCompile = function onCompile() {
    };
    module.exports = LinkifyIt;
  }
});

// node_modules/punycode/punycode.js
var require_punycode = __commonJS({
  "node_modules/punycode/punycode.js"(exports, module) {
    "use strict";
    var maxInt = 2147483647;
    var base2 = 36;
    var tMin = 1;
    var tMax = 26;
    var skew = 38;
    var damp = 700;
    var initialBias = 72;
    var initialN = 128;
    var delimiter = "-";
    var regexPunycode = /^xn--/;
    var regexNonASCII = /[^\0-\x7E]/;
    var regexSeparators = /[\x2E\u3002\uFF0E\uFF61]/g;
    var errors = {
      "overflow": "Overflow: input needs wider integers to process",
      "not-basic": "Illegal input >= 0x80 (not a basic code point)",
      "invalid-input": "Invalid input"
    };
    var baseMinusTMin = base2 - tMin;
    var floor = Math.floor;
    var stringFromCharCode = String.fromCharCode;
    function error(type) {
      throw new RangeError(errors[type]);
    }
    function map3(array, fn) {
      const result2 = [];
      let length = array.length;
      while (length--) {
        result2[length] = fn(array[length]);
      }
      return result2;
    }
    function mapDomain(string, fn) {
      const parts = string.split("@");
      let result2 = "";
      if (parts.length > 1) {
        result2 = parts[0] + "@";
        string = parts[1];
      }
      string = string.replace(regexSeparators, ".");
      const labels = string.split(".");
      const encoded = map3(labels, fn).join(".");
      return result2 + encoded;
    }
    function ucs2decode(string) {
      const output = [];
      let counter2 = 0;
      const length = string.length;
      while (counter2 < length) {
        const value2 = string.charCodeAt(counter2++);
        if (value2 >= 55296 && value2 <= 56319 && counter2 < length) {
          const extra = string.charCodeAt(counter2++);
          if ((extra & 64512) == 56320) {
            output.push(((value2 & 1023) << 10) + (extra & 1023) + 65536);
          } else {
            output.push(value2);
            counter2--;
          }
        } else {
          output.push(value2);
        }
      }
      return output;
    }
    var ucs2encode = (array) => String.fromCodePoint(...array);
    var basicToDigit = function(codePoint) {
      if (codePoint - 48 < 10) {
        return codePoint - 22;
      }
      if (codePoint - 65 < 26) {
        return codePoint - 65;
      }
      if (codePoint - 97 < 26) {
        return codePoint - 97;
      }
      return base2;
    };
    var digitToBasic = function(digit, flag) {
      return digit + 22 + 75 * (digit < 26) - ((flag != 0) << 5);
    };
    var adapt = function(delta, numPoints, firstTime) {
      let k2 = 0;
      delta = firstTime ? floor(delta / damp) : delta >> 1;
      delta += floor(delta / numPoints);
      for (; delta > baseMinusTMin * tMax >> 1; k2 += base2) {
        delta = floor(delta / baseMinusTMin);
      }
      return floor(k2 + (baseMinusTMin + 1) * delta / (delta + skew));
    };
    var decode = function(input) {
      const output = [];
      const inputLength = input.length;
      let i3 = 0;
      let n4 = initialN;
      let bias = initialBias;
      let basic = input.lastIndexOf(delimiter);
      if (basic < 0) {
        basic = 0;
      }
      for (let j = 0; j < basic; ++j) {
        if (input.charCodeAt(j) >= 128) {
          error("not-basic");
        }
        output.push(input.charCodeAt(j));
      }
      for (let index = basic > 0 ? basic + 1 : 0; index < inputLength; ) {
        let oldi = i3;
        for (let w3 = 1, k2 = base2; ; k2 += base2) {
          if (index >= inputLength) {
            error("invalid-input");
          }
          const digit = basicToDigit(input.charCodeAt(index++));
          if (digit >= base2 || digit > floor((maxInt - i3) / w3)) {
            error("overflow");
          }
          i3 += digit * w3;
          const t2 = k2 <= bias ? tMin : k2 >= bias + tMax ? tMax : k2 - bias;
          if (digit < t2) {
            break;
          }
          const baseMinusT = base2 - t2;
          if (w3 > floor(maxInt / baseMinusT)) {
            error("overflow");
          }
          w3 *= baseMinusT;
        }
        const out = output.length + 1;
        bias = adapt(i3 - oldi, out, oldi == 0);
        if (floor(i3 / out) > maxInt - n4) {
          error("overflow");
        }
        n4 += floor(i3 / out);
        i3 %= out;
        output.splice(i3++, 0, n4);
      }
      return String.fromCodePoint(...output);
    };
    var encode = function(input) {
      const output = [];
      input = ucs2decode(input);
      let inputLength = input.length;
      let n4 = initialN;
      let delta = 0;
      let bias = initialBias;
      for (const currentValue of input) {
        if (currentValue < 128) {
          output.push(stringFromCharCode(currentValue));
        }
      }
      let basicLength = output.length;
      let handledCPCount = basicLength;
      if (basicLength) {
        output.push(delimiter);
      }
      while (handledCPCount < inputLength) {
        let m3 = maxInt;
        for (const currentValue of input) {
          if (currentValue >= n4 && currentValue < m3) {
            m3 = currentValue;
          }
        }
        const handledCPCountPlusOne = handledCPCount + 1;
        if (m3 - n4 > floor((maxInt - delta) / handledCPCountPlusOne)) {
          error("overflow");
        }
        delta += (m3 - n4) * handledCPCountPlusOne;
        n4 = m3;
        for (const currentValue of input) {
          if (currentValue < n4 && ++delta > maxInt) {
            error("overflow");
          }
          if (currentValue == n4) {
            let q = delta;
            for (let k2 = base2; ; k2 += base2) {
              const t2 = k2 <= bias ? tMin : k2 >= bias + tMax ? tMax : k2 - bias;
              if (q < t2) {
                break;
              }
              const qMinusT = q - t2;
              const baseMinusT = base2 - t2;
              output.push(
                stringFromCharCode(digitToBasic(t2 + qMinusT % baseMinusT, 0))
              );
              q = floor(qMinusT / baseMinusT);
            }
            output.push(stringFromCharCode(digitToBasic(q, 0)));
            bias = adapt(delta, handledCPCountPlusOne, handledCPCount == basicLength);
            delta = 0;
            ++handledCPCount;
          }
        }
        ++delta;
        ++n4;
      }
      return output.join("");
    };
    var toUnicode = function(input) {
      return mapDomain(input, function(string) {
        return regexPunycode.test(string) ? decode(string.slice(4).toLowerCase()) : string;
      });
    };
    var toASCII = function(input) {
      return mapDomain(input, function(string) {
        return regexNonASCII.test(string) ? "xn--" + encode(string) : string;
      });
    };
    var punycode = {
      /**
       * A string representing the current Punycode.js version number.
       * @memberOf punycode
       * @type String
       */
      "version": "2.1.0",
      /**
       * An object of methods to convert from JavaScript's internal character
       * representation (UCS-2) to Unicode code points, and back.
       * @see <https://mathiasbynens.be/notes/javascript-encoding>
       * @memberOf punycode
       * @type Object
       */
      "ucs2": {
        "decode": ucs2decode,
        "encode": ucs2encode
      },
      "decode": decode,
      "encode": encode,
      "toASCII": toASCII,
      "toUnicode": toUnicode
    };
    module.exports = punycode;
  }
});

// node_modules/markdown-it/lib/presets/default.js
var require_default = __commonJS({
  "node_modules/markdown-it/lib/presets/default.js"(exports, module) {
    "use strict";
    module.exports = {
      options: {
        html: false,
        // Enable HTML tags in source
        xhtmlOut: false,
        // Use '/' to close single tags (<br />)
        breaks: false,
        // Convert '\n' in paragraphs into <br>
        langPrefix: "language-",
        // CSS language prefix for fenced blocks
        linkify: false,
        // autoconvert URL-like texts to links
        // Enable some language-neutral replacements + quotes beautification
        typographer: false,
        // Double + single quotes replacement pairs, when typographer enabled,
        // and smartquotes on. Could be either a String or an Array.
        //
        // For example, you can use '«»„“' for Russian, '„“‚‘' for German,
        // and ['«\xA0', '\xA0»', '‹\xA0', '\xA0›'] for French (including nbsp).
        quotes: "\u201C\u201D\u2018\u2019",
        /* “”‘’ */
        // Highlighter function. Should return escaped HTML,
        // or '' if the source string is not changed and should be escaped externaly.
        // If result starts with <pre... internal wrapper is skipped.
        //
        // function (/*str, lang*/) { return ''; }
        //
        highlight: null,
        maxNesting: 100
        // Internal protection, recursion limit
      },
      components: {
        core: {},
        block: {},
        inline: {}
      }
    };
  }
});

// node_modules/markdown-it/lib/presets/zero.js
var require_zero = __commonJS({
  "node_modules/markdown-it/lib/presets/zero.js"(exports, module) {
    "use strict";
    module.exports = {
      options: {
        html: false,
        // Enable HTML tags in source
        xhtmlOut: false,
        // Use '/' to close single tags (<br />)
        breaks: false,
        // Convert '\n' in paragraphs into <br>
        langPrefix: "language-",
        // CSS language prefix for fenced blocks
        linkify: false,
        // autoconvert URL-like texts to links
        // Enable some language-neutral replacements + quotes beautification
        typographer: false,
        // Double + single quotes replacement pairs, when typographer enabled,
        // and smartquotes on. Could be either a String or an Array.
        //
        // For example, you can use '«»„“' for Russian, '„“‚‘' for German,
        // and ['«\xA0', '\xA0»', '‹\xA0', '\xA0›'] for French (including nbsp).
        quotes: "\u201C\u201D\u2018\u2019",
        /* “”‘’ */
        // Highlighter function. Should return escaped HTML,
        // or '' if the source string is not changed and should be escaped externaly.
        // If result starts with <pre... internal wrapper is skipped.
        //
        // function (/*str, lang*/) { return ''; }
        //
        highlight: null,
        maxNesting: 20
        // Internal protection, recursion limit
      },
      components: {
        core: {
          rules: [
            "normalize",
            "block",
            "inline",
            "text_join"
          ]
        },
        block: {
          rules: [
            "paragraph"
          ]
        },
        inline: {
          rules: [
            "text"
          ],
          rules2: [
            "balance_pairs",
            "fragments_join"
          ]
        }
      }
    };
  }
});

// node_modules/markdown-it/lib/presets/commonmark.js
var require_commonmark = __commonJS({
  "node_modules/markdown-it/lib/presets/commonmark.js"(exports, module) {
    "use strict";
    module.exports = {
      options: {
        html: true,
        // Enable HTML tags in source
        xhtmlOut: true,
        // Use '/' to close single tags (<br />)
        breaks: false,
        // Convert '\n' in paragraphs into <br>
        langPrefix: "language-",
        // CSS language prefix for fenced blocks
        linkify: false,
        // autoconvert URL-like texts to links
        // Enable some language-neutral replacements + quotes beautification
        typographer: false,
        // Double + single quotes replacement pairs, when typographer enabled,
        // and smartquotes on. Could be either a String or an Array.
        //
        // For example, you can use '«»„“' for Russian, '„“‚‘' for German,
        // and ['«\xA0', '\xA0»', '‹\xA0', '\xA0›'] for French (including nbsp).
        quotes: "\u201C\u201D\u2018\u2019",
        /* “”‘’ */
        // Highlighter function. Should return escaped HTML,
        // or '' if the source string is not changed and should be escaped externaly.
        // If result starts with <pre... internal wrapper is skipped.
        //
        // function (/*str, lang*/) { return ''; }
        //
        highlight: null,
        maxNesting: 20
        // Internal protection, recursion limit
      },
      components: {
        core: {
          rules: [
            "normalize",
            "block",
            "inline",
            "text_join"
          ]
        },
        block: {
          rules: [
            "blockquote",
            "code",
            "fence",
            "heading",
            "hr",
            "html_block",
            "lheading",
            "list",
            "reference",
            "paragraph"
          ]
        },
        inline: {
          rules: [
            "autolink",
            "backticks",
            "emphasis",
            "entity",
            "escape",
            "html_inline",
            "image",
            "link",
            "newline",
            "text"
          ],
          rules2: [
            "balance_pairs",
            "emphasis",
            "fragments_join"
          ]
        }
      }
    };
  }
});

// node_modules/markdown-it/lib/index.js
var require_lib = __commonJS({
  "node_modules/markdown-it/lib/index.js"(exports, module) {
    "use strict";
    var utils = require_utils();
    var helpers2 = require_helpers();
    var Renderer2 = require_renderer();
    var ParserCore = require_parser_core();
    var ParserBlock = require_parser_block();
    var ParserInline = require_parser_inline();
    var LinkifyIt = require_linkify_it();
    var mdurl = require_mdurl();
    var punycode = require_punycode();
    var config = {
      default: require_default(),
      zero: require_zero(),
      commonmark: require_commonmark()
    };
    var BAD_PROTO_RE = /^(vbscript|javascript|file|data):/;
    var GOOD_DATA_RE = /^data:image\/(gif|png|jpeg|webp);/;
    function validateLink(url2) {
      var str = url2.trim().toLowerCase();
      return BAD_PROTO_RE.test(str) ? GOOD_DATA_RE.test(str) ? true : false : true;
    }
    var RECODE_HOSTNAME_FOR = ["http:", "https:", "mailto:"];
    function normalizeLink(url2) {
      var parsed = mdurl.parse(url2, true);
      if (parsed.hostname) {
        if (!parsed.protocol || RECODE_HOSTNAME_FOR.indexOf(parsed.protocol) >= 0) {
          try {
            parsed.hostname = punycode.toASCII(parsed.hostname);
          } catch (er) {
          }
        }
      }
      return mdurl.encode(mdurl.format(parsed));
    }
    function normalizeLinkText(url2) {
      var parsed = mdurl.parse(url2, true);
      if (parsed.hostname) {
        if (!parsed.protocol || RECODE_HOSTNAME_FOR.indexOf(parsed.protocol) >= 0) {
          try {
            parsed.hostname = punycode.toUnicode(parsed.hostname);
          } catch (er) {
          }
        }
      }
      return mdurl.decode(mdurl.format(parsed), mdurl.decode.defaultChars + "%");
    }
    function MarkdownIt(presetName, options2) {
      if (!(this instanceof MarkdownIt)) {
        return new MarkdownIt(presetName, options2);
      }
      if (!options2) {
        if (!utils.isString(presetName)) {
          options2 = presetName || {};
          presetName = "default";
        }
      }
      this.inline = new ParserInline();
      this.block = new ParserBlock();
      this.core = new ParserCore();
      this.renderer = new Renderer2();
      this.linkify = new LinkifyIt();
      this.validateLink = validateLink;
      this.normalizeLink = normalizeLink;
      this.normalizeLinkText = normalizeLinkText;
      this.utils = utils;
      this.helpers = utils.assign({}, helpers2);
      this.options = {};
      this.configure(presetName);
      if (options2) {
        this.set(options2);
      }
    }
    MarkdownIt.prototype.set = function(options2) {
      utils.assign(this.options, options2);
      return this;
    };
    MarkdownIt.prototype.configure = function(presets) {
      var self2 = this, presetName;
      if (utils.isString(presets)) {
        presetName = presets;
        presets = config[presetName];
        if (!presets) {
          throw new Error('Wrong `markdown-it` preset "' + presetName + '", check name');
        }
      }
      if (!presets) {
        throw new Error("Wrong `markdown-it` preset, can't be empty");
      }
      if (presets.options) {
        self2.set(presets.options);
      }
      if (presets.components) {
        Object.keys(presets.components).forEach(function(name) {
          if (presets.components[name].rules) {
            self2[name].ruler.enableOnly(presets.components[name].rules);
          }
          if (presets.components[name].rules2) {
            self2[name].ruler2.enableOnly(presets.components[name].rules2);
          }
        });
      }
      return this;
    };
    MarkdownIt.prototype.enable = function(list, ignoreInvalid) {
      var result2 = [];
      if (!Array.isArray(list)) {
        list = [list];
      }
      ["core", "block", "inline"].forEach(function(chain3) {
        result2 = result2.concat(this[chain3].ruler.enable(list, true));
      }, this);
      result2 = result2.concat(this.inline.ruler2.enable(list, true));
      var missed = list.filter(function(name) {
        return result2.indexOf(name) < 0;
      });
      if (missed.length && !ignoreInvalid) {
        throw new Error("MarkdownIt. Failed to enable unknown rule(s): " + missed);
      }
      return this;
    };
    MarkdownIt.prototype.disable = function(list, ignoreInvalid) {
      var result2 = [];
      if (!Array.isArray(list)) {
    