"""card_toolbars

Revision ID: 0278
Revises: 0277
Create Date: 2025-02-28 11:02:20.935912

"""
from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql
import datetime

# revision identifiers, used by Alembic.
revision = '0278'
down_revision = '0277'
branch_labels = None
depends_on = None


def upgrade():
    op.create_table('card_toolbars',
        sa.Column('id', sa.Integer, primary_key=True),
        sa.Column('created_at', sa.DateTime, default=datetime.datetime.utcnow),
        sa.Column('updated_at', sa.DateTime, default=datetime.datetime.utcnow),
        sa.Column('project_id', sa.Integer, sa.ForeignKey('projects.id', ondelete='CASCADE')),
        sa.Column('model_id', sa.Integer, sa.ForeignKey('card_models.id', ondelete='CASCADE')),
    )
    op.create_index(op.f('ix_card_toolbars_project_id_model_id'), 'card_toolbars', ['project_id', 'model_id'], unique=False)

    op.create_table('card_toolbar_automation_rules',
        sa.Column('toolbar_id', sa.Integer, sa.ForeignKey('card_toolbars.id', ondelete='CASCADE')),
        sa.Column('rule_id', sa.Integer, sa.ForeignKey('automation_rules.id', ondelete='CASCADE')),
        sa.Column('position', sa.Integer, nullable=False, server_default="0"),
        sa.PrimaryKeyConstraint('toolbar_id', 'rule_id'),
    )
    op.create_index(op.f('ix_card_toolbar_automation_rules_toolbar_id'), 'card_toolbar_automation_rules', ['toolbar_id'], unique=False)


def downgrade():
    op.drop_table('card_toolbar_automation_rules')
    op.drop_table('card_toolbars')

