"""date_attribute_options_change

Revision ID: 0269
Revises: 0268
Create Date: 2025-03-25 11:49:05.967184

"""
from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql


# revision identifiers, used by Alembic.
revision = '0269'
down_revision = '0268'
branch_labels = None
depends_on = None


def upgrade():
    op.execute("""
        UPDATE attributes
        SET options = (
            CASE
                WHEN jsonb_typeof(options) = 'object' OR options IS NULL THEN
                    (
                        jsonb_set(
                            jsonb_set(
                                COALESCE(options, '{}'::jsonb),
                                '{precision}',
                                CASE
                                    WHEN (COALESCE(options, '{}'::jsonb) ->> 'time')::boolean THEN
                                        '"days_time"'::jsonb
                                    ELSE
                                        '"days"'::jsonb
                                END,
                                true
                            ),
                            '{daterange}',
                            CASE
                                WHEN NOT (COALESCE(options, '{}'::jsonb) ? 'daterange') THEN
                                    'true'::jsonb
                                ELSE
                                    COALESCE(options, '{}'::jsonb)->'daterange'
                            END,
                            true
                        )
                    ) - 'time'
                ELSE
                    options
            END
        )
        WHERE type_name = 'date';
    """)


def downgrade():
    pass
