"""oauth

Revision ID: 0268
Revises: 0267
Create Date: 2025-06-17 13:16:17.623883

"""
from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql


# revision identifiers, used by Alembic.
revision = '0268'
down_revision = '0267'
branch_labels = None
depends_on = None


def upgrade():
    op.add_column('oauth_authz_codes', sa.Column('acr', sa.Text()))
    op.add_column('oauth_authz_codes', sa.Column('amr', sa.Text()))
    op.add_column('oauth_app_tokens', sa.Column('access_token_revoked_at', sa.Integer(), nullable=False, server_default='0'))
    op.add_column('oauth_app_tokens', sa.Column('refresh_token_revoked_at', sa.Integer(), nullable=False, server_default='0'))


def downgrade():
    op.drop_column('oauth_authz_codes', 'acr')
    op.drop_column('oauth_authz_codes', 'amr')
    op.drop_column('oauth_app_tokens', 'access_token_revoked_at')
    op.drop_column('oauth_app_tokens', 'refresh_token_revoked_at')