"""fix_request_forms_foreign_key_ondelete

Revision ID: 0263
Revises: 0262
Create Date: 2025-01-24 16:41:14.029721

"""
from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql


# revision identifiers, used by Alembic.
revision = '0263'
down_revision = '0262'
branch_labels = None
depends_on = None


def upgrade():
    op.drop_constraint("request_forms_anonymous_email_field_id_fkey", "request_forms", type_="foreignkey")
    op.drop_constraint("request_forms_email_subject_field_id_fkey", "request_forms", type_="foreignkey")
    op.drop_constraint("request_forms_email_body_field_id_fkey", "request_forms", type_="foreignkey")
    op.drop_constraint("request_forms_email_attachments_field_id_fkey", "request_forms", type_="foreignkey")
    op.create_foreign_key(None, 'request_forms', 'request_form_fields', ['anonymous_email_field_id'], ['id'], ondelete='SET NULL')
    op.create_foreign_key(None, 'request_forms', 'request_form_fields', ['email_subject_field_id'], ['id'], ondelete='SET NULL')
    op.create_foreign_key(None, 'request_forms', 'request_form_fields', ['email_body_field_id'], ['id'], ondelete='SET NULL')
    op.create_foreign_key(None, 'request_forms', 'request_form_fields', ['email_attachments_field_id'], ['id'], ondelete='SET NULL')
    pass


def downgrade():
    pass
