"""portfolio

Revision ID: 0258
Revises: 0257
Create Date: 2023-03-22 15:51:49.836478

"""
from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql


# revision identifiers, used by Alembic.
revision = '0258'
down_revision = '0257'
branch_labels = None
depends_on = None


def upgrade():
    op.add_column('projects', sa.Column('is_portfolio', sa.Boolean(), nullable=False, server_default="false"))
    op.create_index(op.f('ix_projects_is_portfolio'), 'projects', ['is_portfolio'])

    op.create_table('portfolio_projects',
        sa.Column('portfolio_id', sa.Integer()),
        sa.Column('project_id', sa.Integer()),
        sa.ForeignKeyConstraint(['portfolio_id'], ['projects.id'], ondelete='CASCADE'),
        sa.ForeignKeyConstraint(['project_id'], ['projects.id'], ondelete='CASCADE'),
        sa.PrimaryKeyConstraint('portfolio_id', 'project_id')
    )
    op.create_index(op.f('ix_portfolio_projects_portfolio_id'), 'portfolio_projects', ['portfolio_id'])
    op.create_index(op.f('ix_portfolio_projects_portfolio_id_project_id'), 'portfolio_projects', ['portfolio_id', 'project_id'])


def downgrade():
    op.drop_table('portfolio_projects')
    op.drop_column('projects', 'is_portfolio')
