"""cleanup_orphan_card_logs

Revision ID: 0250
Revises: 0249
Create Date: 2023-05-05 21:10:33.820171

"""
from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql


# revision identifiers, used by Alembic.
revision = '0250'
down_revision = '0249'
branch_labels = None
depends_on = None


def upgrade():
    op.execute("""
        DELETE FROM card_logs
        WHERE id IN (
            SELECT cl.id
            FROM card_logs cl
            JOIN card_log_types clt ON clt.id = cl.log_type_id
            JOIN project_enabled_log_types pelt ON pelt.log_type_id = clt.id
            JOIN cards c ON c.id = cl.card_id
            WHERE pelt.project_id != c.project_id
        )
    """)


def downgrade():
    pass
