"""view_categories

Revision: 0234
Revision ID: 249b8b1c2bd6
Revises: 437b60ce2a7c
Create Date: 2021-11-30 16:31:08.580092

"""
from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql


# revision identifiers, used by Alembic.
revision = '249b8b1c2bd6'
down_revision = '437b60ce2a7c'
branch_labels = None
depends_on = None


def upgrade():
    op.create_table('view_categories',
        sa.Column('id', sa.Integer(), nullable=False),
        sa.Column('created_at', sa.DateTime(), nullable=True),
        sa.Column('created_by_id', sa.Integer(), nullable=True),
        sa.Column('project_id', sa.Integer(), nullable=True),
        sa.Column('name', sa.String(), nullable=False),
        sa.Column('position', sa.Integer(), nullable=False),
        sa.ForeignKeyConstraint(['created_by_id'], ['users.id'], ondelete='SET NULL'),
        sa.ForeignKeyConstraint(['project_id'], ['projects.id'], ondelete='CASCADE'),
        sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_view_categories_project_id'), 'view_categories', ['project_id'], unique=False)

    op.add_column('views', sa.Column('category_id', sa.Integer(), nullable=True))
    op.create_foreign_key(None, 'views', 'view_categories', ['category_id'], ['id'], ondelete='SET NULL')


def downgrade():
    op.drop_column('views', 'category_id')
    op.drop_table('view_categories')
