"""add-run-automation-role

Revision: 0230
Revision ID: 4748ed576de4
Revises: 9a7f12dce0ad
Create Date: 2022-03-02 07:35:35.760488

"""
from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql


# revision identifiers, used by Alembic.
revision = '4748ed576de4'
down_revision = '9a7f12dce0ad'
branch_labels = None
depends_on = None


def upgrade():
    op.execute("""
        UPDATE role_permissions SET actions = array_append(actions, 'RUN_AUTO_ACTIONS')
        FROM roles WHERE roles.id = role_permissions.role_id
        AND roles.builtin in ('ADMIN', 'MEMBER')
        AND role_permissions.object_type = 'project'
        AND role_permissions.object_id IS NULL
        AND NOT (role_permissions.actions @> '{"RUN_AUTO_ACTIONS"}'::varchar[])
    """)


def downgrade():
    pass
