"""org_invite_token

Revision: 0228
Revision ID: ad80214e4b12
Revises: cec3b3150599
Create Date: 2021-12-07 10:16:04.190989

"""
from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql


# revision identifiers, used by Alembic.
revision = 'ad80214e4b12'
down_revision = 'cec3b3150599'
branch_labels = None
depends_on = None


def upgrade():
    op.add_column('organizations', sa.Column('invite_token', sa.String(), nullable=True))
    op.add_column('organizations', sa.Column('invite_token_default_perm', sa.Integer(), nullable=True))
    op.create_index(op.f('ix_organizations_invite_token'), 'organizations', ['invite_token'], unique=False)
    op.execute("UPDATE organizations SET invite_token = uuid_generate_v4(), invite_token_default_perm = 2")


def downgrade():
    op.drop_column('organizations', 'invite_token')
    op.drop_column('organizations', 'invite_token_default_perm')
