"""user_timezone

Revision: 0227
Revision ID: cec3b3150599
Revises: b069c965f0d3
Create Date: 2021-11-29 10:11:08.355866

"""
from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql


# revision identifiers, used by Alembic.
revision = 'cec3b3150599'
down_revision = 'b069c965f0d3'
branch_labels = None
depends_on = None


user_time_format = sa.Enum('am_pm', '24h', name='user_time_format')


def upgrade():
    op.add_column('users', sa.Column('dow_start', sa.Integer(), nullable=True))
    user_time_format.create(op.get_bind(), checkfirst=False)
    op.add_column('users', sa.Column('time_format', user_time_format, nullable=True))


def downgrade():
    op.drop_column('users', 'dow_start')
    op.drop_column('users', 'time_format')
    user_time_format.drop(op.get_bind(), checkfirst=False)
