"""org_stat_counter

Revision: 0221
Revision ID: 27f0fec65f2e
Revises: 1a49f15e6ab4
Create Date: 2021-10-08 13:29:21.339263

"""
from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql


# revision identifiers, used by Alembic.
revision = '27f0fec65f2e'
down_revision = '1a49f15e6ab4'
branch_labels = None
depends_on = None


def upgrade():
    op.create_table('organization_stat_counters',
        sa.Column('org_id', sa.Integer(), nullable=False),
        sa.Column('name', sa.String(), nullable=False),
        sa.Column('total', sa.Integer(), nullable=False),
        sa.Column('period', sa.String(), nullable=False),
        sa.Column('periods_count', postgresql.JSON(), nullable=True),
        sa.ForeignKeyConstraint(['org_id'], ['organizations.id'], ondelete='CASCADE'),
        sa.PrimaryKeyConstraint('org_id', 'name')
    )


def downgrade():
    op.drop_table('organization_stat_counters')
