"""automations

Revision: 0219
Revision ID: 233b7875868c
Revises: 681ff6dac033
Create Date: 2021-06-15 12:06:16.718318

"""
from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql


# revision identifiers, used by Alembic.
revision = '233b7875868c'
down_revision = '681ff6dac033'
branch_labels = None
depends_on = None


def upgrade():
    op.create_table('automation_rules',
        sa.Column('id', sa.Integer(), nullable=False),
        sa.Column('project_id', sa.Integer(), nullable=True),
        sa.Column('created_at', sa.DateTime(), nullable=True),
        sa.Column('updated_at', sa.DateTime(), nullable=True),
        sa.Column('created_by_id', sa.Integer(), nullable=True),
        sa.Column('name', sa.String(), nullable=False),
        sa.Column('description', sa.String(), nullable=True),
        sa.Column('trigger_event_name', sa.String(), nullable=False),
        sa.Column('trigger_options', postgresql.JSONB(), nullable=True),
        sa.Column('sequence', postgresql.JSON(), nullable=True),
        sa.Column('active', sa.Boolean(), nullable=False),
        sa.Column('parallel', sa.Boolean(), nullable=False),
        sa.Column('last_trigger_at', sa.DateTime(), nullable=True),
        sa.Column('trigger_count_total', sa.Integer(), nullable=False),
        sa.Column('trigger_count_period', sa.Integer(), nullable=False),
        sa.Column('run_token', sa.Text(), nullable=False),
        sa.ForeignKeyConstraint(['created_by_id'], ['users.id'], ondelete='SET NULL'),
        sa.ForeignKeyConstraint(['project_id'], ['projects.id'], ondelete='CASCADE'),
        sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_automation_rules_project_id'), 'automation_rules', ['project_id'], unique=False)
    op.create_index(op.f('ix_automation_rules_active'), 'automation_rules', ['active'], unique=False)
    op.create_index(op.f('ix_automation_rules_trigger_event_name'), 'automation_rules', ['trigger_event_name'], unique=False)
    op.create_index(op.f('ix_automation_rules_trigger_options'), 'automation_rules', ['trigger_options'], unique=False)
    op.create_index(op.f('ix_automation_rules_run_token'), 'automation_rules', ['run_token'], unique=True)

    op.create_table('automation_states',
        sa.Column('id', sa.Integer(), nullable=False),
        sa.Column('rule_id', sa.Integer(), nullable=False),
        sa.Column('created_at', sa.DateTime(), nullable=True),
        sa.Column('updated_at', sa.DateTime(), nullable=True),
        sa.Column('namespace', sa.String(), nullable=True),
        sa.Column('step', sa.String(), nullable=True),
        sa.Column('data', postgresql.JSON(), nullable=True),
        sa.Column('error', sa.String(), nullable=True),
        sa.ForeignKeyConstraint(['rule_id'], ['automation_rules.id'], ondelete='CASCADE'),
        sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_automation_states_rule_id'), 'automation_states', ['rule_id'], unique=False)
    op.create_index(op.f('ix_automation_states_namespace'), 'automation_states', ['namespace'], unique=False)
    op.create_index(op.f('ix_automation_states_error_updated_at'), 'automation_states', ['error', 'updated_at'], unique=False)


def downgrade():
    op.drop_table('automation_states')
    op.drop_table('automation_rules')
