"""oauth_apps

Revision: 0217
Revision ID: bac8354bc42a
Revises: 84adae4688a7
Create Date: 2021-07-07 15:37:26.054150

"""
from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql


# revision identifiers, used by Alembic.
revision = 'bac8354bc42a'
down_revision = '84adae4688a7'
branch_labels = None
depends_on = None


def upgrade():
    op.create_table('oauth_apps',
        sa.Column('id', sa.Integer(), nullable=False),
        sa.Column('user_id', sa.Integer(), nullable=True),
        sa.Column('client_id', sa.String()),
        sa.Column('client_secret', sa.String()),
        sa.Column('client_id_issued_at', sa.Integer(), nullable=False),
        sa.Column('client_secret_expires_at', sa.Integer(), nullable=False),
        sa.Column('client_metadata', sa.Text()),
        sa.Column('trusted', sa.Boolean()),
        sa.Column('description', sa.Text(), nullable=True),
        sa.Column('icon_id', sa.Integer(), nullable=True),
        sa.ForeignKeyConstraint(['user_id'], ['users.id'], ondelete='CASCADE'),
        sa.ForeignKeyConstraint(['icon_id'], ['files.id'], ondelete='SET NULL'),
        sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_oauth_apps_user_id'), 'oauth_apps', ['user_id'], unique=False)
    op.create_index(op.f('ix_oauth_apps_client_id'), 'oauth_apps', ['client_id'], unique=True)
    op.create_index(op.f('ix_oauth_apps_client_secret'), 'oauth_apps', ['client_secret'], unique=True)

    op.create_table('oauth_authz_codes',
        sa.Column('id', sa.Integer(), nullable=False),
        sa.Column('user_id', sa.Integer(), nullable=False),
        sa.Column('code', sa.String(120), nullable=False),
        sa.Column('client_id', sa.String(48)),
        sa.Column('redirect_uri', sa.Text()),
        sa.Column('response_type', sa.Text()),
        sa.Column('scope', sa.Text()),
        sa.Column('nonce', sa.Text()),
        sa.Column('auth_time', sa.Integer(), nullable=False),
        sa.Column('code_challenge', sa.Text()),
        sa.Column('code_challenge_method', sa.String(48)),
        sa.ForeignKeyConstraint(['user_id'], ['users.id'], ondelete='CASCADE'),
        sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_oauth_authz_codes_user_id'), 'oauth_authz_codes', ['user_id'], unique=False)
    op.create_index(op.f('ix_oauth_authz_codes_code'), 'oauth_authz_codes', ['code'], unique=True)

    op.create_table('oauth_app_tokens',
        sa.Column('id', sa.Integer(), nullable=False),
        sa.Column('user_id', sa.Integer(), nullable=False),
        sa.Column('client_id', sa.String(48)),
        sa.Column('token_type', sa.String(40)),
        sa.Column('access_token', sa.String(255), nullable=False),
        sa.Column('refresh_token', sa.String(255), index=True),
        sa.Column('scope', sa.Text(), default=''),
        sa.Column('revoked', sa.Boolean()),
        sa.Column('issued_at', sa.Integer(), nullable=False),
        sa.Column('expires_in', sa.Integer(), nullable=False),
        sa.ForeignKeyConstraint(['user_id'], ['users.id'], ondelete='CASCADE'),
        sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_oauth_app_tokens_user_id'), 'oauth_app_tokens', ['user_id'], unique=False)
    op.create_index(op.f('ix_oauth_app_tokens_access_token'), 'oauth_app_tokens', ['access_token'], unique=True)


def downgrade():
    pass
