"""users_report_view

Revision: 0216
Revision ID: 84adae4688a7
Revises: 3c258d81bd0c
Create Date: 2021-06-21 11:55:30.611082

"""
from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql


# revision identifiers, used by Alembic.
revision = '84adae4688a7'
down_revision = '3c258d81bd0c'
branch_labels = None
depends_on = None


def upgrade():
    op.execute("""
        CREATE OR REPLACE VIEW users_report_view AS
        SELECT users.id,
            users.signup_at,
            users.signup_from,
            users.signup_provider,
            users.auth_providers,
            users.last_login_at,
            users.last_login_from,
            users.last_login_provider,
            split_part(users.email::text, '@'::text, 2) AS email_domain,
            users.can_create_organizations,
            users.locale,
            users.timezone,
            users.enable_email_notifications,
            users.updated_at,
            users.is_admin,
            users.subscription_required,
            users.trial_ends_at,
            users.can_join_organizations,
            users.is_observer,
            users.is_disabled,
            users.disabled_at,
            users.last_activity_at,
            users.onboarded,
            users.last_password_change_at,
            users.last_terms_validation,
            users.email_newsletter,
            users.email_notifications,
            users.is_super_admin,
            users.signup_country,
            users.signup_cpc_source,
            users.signup_cpc_campaign,
            users.signup_cpc_ad,
            users.signup_cpc_keyword,
            users.signup_cpc_sessionid,
            users.last_access_at,
            users.last_password_change_from,
            users.is_auto_disabled,
            users.two_factor_auth_enabled,
            users.email_validated,
            users.email_validated_at
        FROM users;
    """)


def downgrade():
    pass
