"""form-views

Revision: 0210
Revision ID: ee6fba69aef3
Revises: f8fc6ca825a2
Create Date: 2021-05-24 16:16:10.321086

"""
from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql


# revision identifiers, used by Alembic.
revision = 'ee6fba69aef3'
down_revision = 'f8fc6ca825a2'
branch_labels = None
depends_on = None


def upgrade():
    op.execute("""
        DELETE FROM views WHERE mode = 'forms';
    """)

    op.execute("""
        INSERT INTO views (created_at, created_by, mode, mode_options, name, project_id, card_ref, limit_to_ref, position)
        SELECT
            rf.created_at,
            rf.created_by_id,
            'form',
            jsonb_build_object('formId', rf.id),
            rf.name,
            rf.project_id,
            0,
            true,
            (SELECT MAX(position) FROM views WHERE project_id = rf.project_id)
        FROM request_forms rf
    """)


def downgrade():
    pass
