"""count_working_days

Revision: 0197
Revision ID: 3b5a33bad9e7
Revises: e1180f3ae5fe
Create Date: 2020-11-12 15:41:33.637297

"""
from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql


# revision identifiers, used by Alembic.
revision = '3b5a33bad9e7'
down_revision = 'e1180f3ae5fe'
branch_labels = None
depends_on = None


def upgrade():
    op.execute("""
        CREATE OR REPLACE FUNCTION count_working_days(from_date date, to_date date) RETURNS bigint
        AS $body$
            SELECT count(*)
            FROM generate_series(from_date, to_date, '1 day'::interval) d
            WHERE EXTRACT('isodow' from d) < 6
        $body$ LANGUAGE sql;
    """)


def downgrade():
    pass
