"""update_organizations_report_view

Revision: 0196
Revision ID: e1180f3ae5fe
Revises: b1c116f20ed0
Create Date: 2020-10-15 12:13:15.850314

"""
from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql


# revision identifiers, used by Alembic.
revision = 'e1180f3ae5fe'
down_revision = 'b1c116f20ed0'
branch_labels = None
depends_on = None


def upgrade():
    op.execute("DROP VIEW IF EXISTS organizations_report_view")
    op.execute("""
        CREATE VIEW organizations_report_view AS
        SELECT
            o.id,
            o.created_at,
            o.created_by_id,
            o.name,
            o.can_invite_guest_collabs,
            o.trial_ends_at,
            o.updated_at,
            o.slug,
            (b.id IS NOT NULL) AS "has_billing_account",
            b.billing_address_country,
            b.eu_vat_country,
            b.has_stripe_payment_method,
            b.plan_last_invoice_amount,
            b.plan_last_invoice_at,
            b.plan_name,
            b.seat_count,
            b.auto_adjust_seat_count,
            b.billing_type,
            b.billing_country,
            b.plan_current_period_start,
            b.plan_current_period_end,
            b.plan_cancel_at_period_end,
            b.plan_next_charge_at,
            b.plan_cancelled_at,
            b.plan_status,
            b.stripe_customer_id,
            b.stripe_subscription_id,
            b.company,
            o.subscription_required,
            b.payment_method,
            o.can_create_private_projects,
            o.can_create_projects,
            o.total_invites,
            o.is_prepaid,
            o.prepaid_until,
            o.max_allowed_users,
            o.can_self_export,
            o.email_templates_send_counter,
            (SELECT string_agg(email_domains.d, ', ') FROM (SELECT DISTINCT split_part(u.email, '@', 2) d FROM users u JOIN organization_members om ON om.user_id = u.id WHERE om.org_id = o.id AND om.permission = 4) email_domains) "owner_email_domains",
            (SELECT COUNT(*) FROM organization_members WHERE org_id = o.id) nb_members,
            (SELECT COUNT(*) FROM projects WHERE owner_id = o.id AND NOT is_archived AND NOT is_template) nb_projects,
            (SELECT COUNT(*) FROM projects WHERE owner_id = o.id AND is_archived AND NOT is_template) nb_archived_projects,
            (SELECT COUNT(*) FROM projects WHERE owner_id = o.id AND is_template) nb_templates
        FROM organizations o
        LEFT JOIN billing_accounts b ON b.id = o.billing_account_id
        WHERE NOT is_user_org
    """)


def downgrade():
    op.execute("DROP VIEW organizations_report_view")
    op.execute("""
        CREATE OR REPLACE VIEW organizations_report_view AS
        SELECT
            id,
            created_at,
            created_by_id,
            name,
            can_invite_guest_collabs,
            trial_ends_at,
            updated_at,
            slug,
            billing_country,
            eu_vat_country,
            has_stripe_source,
            plan_last_charge_amount,
            plan_last_charge_successful,
            plan_last_charged_at,
            plan_name,
            plan_next_charge_at,
            plan_status,
            stripe_customer_id,
            stripe_subscription_id,
            company,
            subscription_required,
            payment_method,
            can_create_private_projects,
            can_create_projects,
            total_invites,
            is_prepaid,
            prepaid_until,
            max_allowed_users,
            can_self_export,
            email_templates_send_counter,
            (SELECT string_agg(email_domains.d, ', ') FROM (SELECT DISTINCT split_part(u.email, '@', 2) d FROM users u JOIN organization_members om ON om.user_id = u.id WHERE om.org_id = organizations.id AND om.permission = 4) email_domains) "owner_email_domains",
            (SELECT COUNT(*) FROM organization_members WHERE org_id = organizations.id) nb_members,
            (SELECT COUNT(*) FROM projects WHERE owner_id = organizations.id AND NOT is_archived AND NOT is_template) nb_projects,
            (SELECT COUNT(*) FROM projects WHERE owner_id = organizations.id AND is_archived AND NOT is_template) nb_archived_projects,
            (SELECT COUNT(*) FROM projects WHERE owner_id = organizations.id AND is_template) nb_templates
        FROM organizations
        WHERE NOT is_user_org
    """)
