"""user_onboarded_as_array

Revision: 0191
Revision ID: 16a37635c0ed
Revises: f6c9987ca2e6
Create Date: 2020-08-31 14:42:54.853154

"""
from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql


# revision identifiers, used by Alembic.
revision = '16a37635c0ed'
down_revision = 'f6c9987ca2e6'
branch_labels = None
depends_on = None


def upgrade():
    op.execute("DROP VIEW IF EXISTS users_report_view")
    op.execute("ALTER TABLE users RENAME COLUMN onboarded TO onboarded_old")

    op.add_column('users', sa.Column('onboarded', postgresql.ARRAY(sa.String()), nullable=True))
    op.add_column('users', sa.Column('preferred_template_library_tag', sa.String(), nullable=True))

    op.execute("""UPDATE users SET onboarded = '{"user", "project"}'::text[] WHERE onboarded_old""")
    op.drop_column('users', 'onboarded_old')

    op.execute("""
        CREATE OR REPLACE VIEW users_report_view AS
        SELECT
            id,
            signup_at,
            signup_from,
            signup_provider,
            auth_providers,
            last_login_at,
            last_login_from,
            last_login_provider,
            split_part(email, '@', 2) email_domain,
            can_create_organizations,
            locale,
            timezone,
            enable_email_notifications,
            updated_at,
            is_admin,
            subscription_required,
            trial_ends_at,
            can_join_organizations,
            is_observer,
            is_disabled,
            disabled_at,
            last_activity_at,
            onboarded,
            last_password_change_at,
            last_terms_validation,
            email_newsletter,
            email_notifications,
            is_super_admin,
            signup_country,
            signup_cpc_source,
            signup_cpc_campaign,
            signup_cpc_ad,
            signup_cpc_keyword,
            signup_cpc_sessionid,
            last_access_at,
            last_password_change_from,
            is_auto_disabled,
            two_factor_auth_enabled
        FROM users
    """)


def downgrade():
    pass
