"""org_desc_and_featured_items

Revision: 0187
Revision ID: 24858bb4f862
Revises: 416d8e4d464b
Create Date: 2020-05-28 22:06:20.170593

"""
from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql


# revision identifiers, used by Alembic.
revision = '24858bb4f862'
down_revision = '416d8e4d464b'
branch_labels = None
depends_on = None


def upgrade():
    op.add_column('organizations', sa.Column('description', sa.Text(), nullable=True))

    op.create_table('organization_featured_items',
        sa.Column('id', sa.Integer(), primary_key=True),
        sa.Column('org_id', sa.Integer(), nullable=True),
        sa.Column('created_by_id', sa.Integer(), nullable=True),
        sa.Column('created_at', sa.DateTime(), nullable=True),
        sa.Column('object_type', sa.String(), nullable=True),
        sa.Column('object_id', sa.Integer(), nullable=True),
        sa.ForeignKeyConstraint(['org_id'], ['organizations.id'], ondelete='CASCADE'),
        sa.ForeignKeyConstraint(['created_by_id'], ['users.id'], ondelete='SET NULL'),
        sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_organization_featured_items_org_id'), 'organization_featured_items', ['org_id'], unique=False)
    op.create_unique_constraint("organization_featured_items_object_unique", "organization_featured_items", ["org_id", "object_type", "object_id"])


def downgrade():
    op.drop_column('organizations', 'description')
    op.drop_table('organization_featured_items')
