"""teams

Revision: 0186
Revision ID: 416d8e4d464b
Revises: d3e47057f56
Create Date: 2020-04-30 22:09:38.117394

"""
from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql


# revision identifiers, used by Alembic.
revision = '416d8e4d464b'
down_revision = 'd3e47057f56'
branch_labels = None
depends_on = None


def upgrade():
    op.create_table('teams',
        sa.Column('id', sa.Integer(), nullable=False),
        sa.Column('created_by_id', sa.Integer(), nullable=True),
        sa.Column('created_at', sa.DateTime(), nullable=True),
        sa.Column('updated_at', sa.DateTime(), nullable=True),
        sa.Column('org_id', sa.Integer(), nullable=True),
        sa.Column('name', sa.String(), nullable=True),
        sa.Column('slug', sa.String(), nullable=True),
        sa.Column('org_members_can_observe', sa.Boolean(), nullable=True),
        sa.Column('org_members_can_autojoin', sa.Boolean(), nullable=True),
        sa.Column('org_members_autojoin_perm', sa.Integer(), nullable=True),
        sa.Column('max_allowed_users', sa.Integer(), nullable=True),
        sa.Column('color', sa.String(), nullable=True),
        sa.Column('description', sa.Text(), nullable=True),
        sa.ForeignKeyConstraint(['created_by_id'], ['users.id'], ondelete='SET NULL'),
        sa.ForeignKeyConstraint(['org_id'], ['organizations.id'], ondelete='SET NULL'),
        sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_teams_org_id'), 'teams', ['org_id'], unique=False)
    op.create_index(op.f('ix_teams_slug'), 'teams', ['slug'], unique=True)

    op.create_table('team_members',
        sa.Column('id', sa.Integer(), nullable=False),
        sa.Column('created_by_id', sa.Integer(), nullable=True),
        sa.Column('created_at', sa.DateTime(), nullable=True),
        sa.Column('team_id', sa.Integer(), nullable=True),
        sa.Column('org_member_id', sa.Integer(), nullable=False),
        sa.Column('permission', sa.Integer(), nullable=False),
        sa.ForeignKeyConstraint(['created_by_id'], ['users.id'], ondelete='SET NULL'),
        sa.ForeignKeyConstraint(['team_id'], ['teams.id'], ondelete='CASCADE'),
        sa.ForeignKeyConstraint(['org_member_id'], ['organization_members.id'], ondelete='CASCADE'),
        sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_team_members_team_id'), 'team_members', ['team_id'], unique=False)
    op.create_index(op.f('ix_team_members_team_id_permission'), 'team_members', ['team_id', 'permission'], unique=False)
    op.create_index(op.f('ix_team_members_team_id_org_member_id'), 'team_members', ['team_id', 'org_member_id'], unique=True)

    op.add_column('projects', sa.Column('team_id', sa.Integer(), nullable=True))
    op.create_foreign_key('projects_team_id_fkey', 'projects', 'teams', ['team_id'], ['id'], ondelete='SET NULL')
    op.create_index(op.f('ix_projects_team_id'), 'projects', ['team_id'], unique=False)
    op.add_column('projects', sa.Column('team_members_can_observe', sa.Boolean(), nullable=True))
    op.add_column('projects', sa.Column('team_members_can_autojoin', sa.Boolean(), nullable=True))
    op.execute("UPDATE projects SET team_members_can_observe = org_members_can_observe, team_members_can_autojoin = org_members_can_autojoin")

    op.add_column('organizations', sa.Column('logo_id', sa.Integer(), nullable=True))
    op.add_column('organizations', sa.Column('image_cover_id', sa.Integer(), nullable=True))
    op.add_column('organizations', sa.Column('cover_color', sa.String(), nullable=True))
    op.create_foreign_key('organizations_logo_id_fkey', 'organizations', 'files', ['logo_id'], ['id'], ondelete='CASCADE')
    op.create_foreign_key('organizations_image_cover_id_fkey', 'organizations', 'files', ['image_cover_id'], ['id'], ondelete='CASCADE')


def downgrade():
    op.drop_column('projects', 'team_id')
    op.drop_column('projects', 'team_members_can_observe')
    op.drop_column('projects', 'team_members_can_autojoin')
    op.drop_table('team_members')
    op.drop_table('teams')
