"""create_request_perm

Revision: 0184
Revision ID: ebacad20699
Revises: 3b4dea6ade9d
Create Date: 2020-05-19 13:26:26.771370

"""
from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql


# revision identifiers, used by Alembic.
revision = 'ebacad20699'
down_revision = '3b4dea6ade9d'
branch_labels = None
depends_on = None


def upgrade():
    op.execute("""
        INSERT INTO role_permissions (role_id, object_type, actions)
        SELECT
            roles.id,
            'request',
            '{"CREATE", "DELETE"}'::varchar[]
        FROM roles WHERE roles.builtin in ('ADMIN', 'MEMBER')
    """)

    op.execute("""
        UPDATE roles SET cache_id = uuid_generate_v4()
        WHERE roles.id IN (
            SELECT DISTINCT roles.id
            FROM roles, role_permissions
            WHERE role_permissions.role_id = roles.id
            AND roles.builtin in ('ADMIN', 'MEMBER')
            AND role_permissions.object_type = 'request'
        )
    """)

    op.execute("""
        UPDATE projects SET members_cache_id = uuid_generate_v4()
    """)


def downgrade():
    pass
