"""reporting_views

Revision: 0172
Revision ID: 34c57eb46c8a
Revises: 595a3ffb3b2
Create Date: 2019-08-28 10:04:42.691654

"""
from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql


# revision identifiers, used by Alembic.
revision = '34c57eb46c8a'
down_revision = '595a3ffb3b2'
branch_labels = None
depends_on = None


def upgrade():
    op.execute("""
        CREATE OR REPLACE VIEW users_report_view AS
        SELECT
            id,
            signup_at,
            signup_from,
            signup_provider,
            auth_providers,
            last_login_at,
            last_login_from,
            last_login_provider,
            split_part(email, '@', 2) email_domain,
            can_create_organizations,
            locale,
            timezone,
            enable_email_notifications,
            updated_at,
            is_admin,
            subscription_required,
            trial_ends_at,
            can_join_organizations,
            is_observer,
            is_disabled,
            disabled_at,
            last_activity_at,
            onboarded,
            last_password_change_at,
            last_terms_validation,
            email_newsletter,
            email_notifications,
            is_super_admin,
            signup_country,
            signup_cpc_source,
            signup_cpc_campaign,
            signup_cpc_ad,
            signup_cpc_keyword,
            signup_cpc_sessionid,
            last_access_at,
            last_password_change_from,
            is_auto_disabled,
            two_factor_auth_enabled
        FROM users
    """)

    op.execute("""
        CREATE OR REPLACE VIEW projects_report_view AS
        SELECT
            p.id,
            p.created_at,
            p.updated_at,
            p.owner_id,
            p.created_by_id,
            p.is_template,
            p.is_archived,
            p.org_members_can_observe,
            p.org_members_can_autojoin,
            p.default_org_member_permission,
            p.import_status,
            p.total_invites,
            p.default_org_member_role_id,
            p.is_public,
            p.send_emails,
            p.allow_anon_inbound_emails,
            p.include_in_template_library,
            p.copied_from_template_id,
            c.last_activity_at,
            (SELECT COUNT(*) FROM project_members WHERE project_id = p.id) nb_members,
            (SELECT COUNT(*) FROM cards WHERE project_id = p.id) nb_cards,
            (SELECT MAX(last_activity_at) FROM cards WHERE project_id = p.id) last_card_activity_at
        FROM projects p JOIN cards c ON c.id = p.top_level_card_id
    """)

    op.execute("""
        CREATE OR REPLACE VIEW organizations_report_view AS
        SELECT
            id,
            created_at,
            created_by_id,
            name,
            can_invite_guest_collabs,
            trial_ends_at,
            updated_at,
            slug,
            billing_country,
            eu_vat_country,
            has_stripe_source,
            plan_last_charge_amount,
            plan_last_charge_successful,
            plan_last_charged_at,
            plan_name,
            plan_next_charge_at,
            plan_status,
            stripe_customer_id,
            stripe_subscription_id,
            company,
            subscription_required,
            payment_method,
            can_create_private_projects,
            can_create_projects,
            total_invites,
            is_prepaid,
            prepaid_until,
            max_allowed_users,
            can_self_export,
            email_templates_send_counter,
            (SELECT string_agg(email_domains.d, ', ') FROM (SELECT DISTINCT split_part(u.email, '@', 2) d FROM users u JOIN organization_members om ON om.user_id = u.id WHERE om.org_id = organizations.id AND om.permission = 4) email_domains) "owner_email_domains",
            (SELECT COUNT(*) FROM organization_members WHERE org_id = organizations.id) nb_members,
            (SELECT COUNT(*) FROM projects WHERE owner_id = organizations.id AND NOT is_archived AND NOT is_template) nb_projects,
            (SELECT COUNT(*) FROM projects WHERE owner_id = organizations.id AND is_archived AND NOT is_template) nb_archived_projects,
            (SELECT COUNT(*) FROM projects WHERE owner_id = organizations.id AND is_template) nb_templates
        FROM organizations
        WHERe NOT is_user_org
    """)


def downgrade():
    op.execute("DROP VIEW users_report_view")
    op.execute("DROP VIEW projects_report_view")
    op.execute("DROP VIEW organizations_report_view")
