"""template_library

Revision: 0171
Revision ID: 595a3ffb3b2
Revises: 27a5b637092e
Create Date: 2019-06-07 17:37:49.858242

"""
from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql


# revision identifiers, used by Alembic.
revision = '595a3ffb3b2'
down_revision = '27a5b637092e'
branch_labels = None
depends_on = None


def upgrade():
    op.add_column('projects', sa.Column('include_in_template_library', sa.Boolean(), nullable=True))
    op.add_column('projects', sa.Column('template_author', sa.String(), nullable=True))
    op.add_column('projects', sa.Column('template_description', sa.String(), nullable=True))
    op.add_column('projects', sa.Column('template_locale', sa.String(), nullable=True))
    op.add_column('projects', sa.Column('template_tags', postgresql.JSONB(), nullable=True))
    op.add_column('projects', sa.Column('copied_from_template_id', sa.Integer(), nullable=True))
    op.create_foreign_key(None, 'projects', 'projects', ['copied_from_template_id'], ['id'], ondelete='SET NULL')
    op.create_index(op.f('ix_projects_include_in_template_library'), 'projects', ['include_in_template_library'], unique=False)
    op.create_index(op.f('ix_projects_template_tags'), 'projects', ['template_tags'], unique=False)
    op.execute("UPDATE projects SET include_in_template_library = false, template_description = oneliner, template_locale = 'en'")


def downgrade():
    op.drop_column('projects', 'include_in_template_library')
    op.drop_column('projects', 'template_description')
    op.drop_column('projects', 'template_tags')
    op.drop_column('projects', 'template_author')
    op.drop_column('projects', 'template_locale')
    op.drop_column('projects', 'copied_from_template_id')
