"""requests_via_email_cc

Revision: 0167
Revision ID: 3cdc91fa1c35
Revises: 46d38eb71ef6
Create Date: 2019-06-21 10:43:58.002639

"""
from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql


# revision identifiers, used by Alembic.
revision = '3cdc91fa1c35'
down_revision = '46d38eb71ef6'
branch_labels = None
depends_on = None


def upgrade():
    op.add_column('requests', sa.Column('via_email', sa.Boolean(), nullable=True))
    op.add_column('requests', sa.Column('email_cc', sa.String(), nullable=True))
    op.add_column('requests', sa.Column('email_subject', sa.String(), nullable=True))
    op.add_column('requests', sa.Column('email_last_message_id', sa.String(), nullable=True))
    op.add_column('requests', sa.Column('email_last_references', sa.String(), nullable=True))
    op.execute("UPDATE requests SET via_email = false")


def downgrade():
    op.drop_column('requests', 'via_email')
    op.drop_column('requests', 'email_cc')
    op.drop_column('requests', 'email_subject')
    op.drop_column('requests', 'email_last_message_id')
    op.drop_column('requests', 'email_last_references')
