"""two_factor_auth

Revision: 0165
Revision ID: f5482137635
Revises: 13a7a762d14a
Create Date: 2019-04-11 16:45:34.794811

"""
from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql


# revision identifiers, used by Alembic.
revision = 'f5482137635'
down_revision = '13a7a762d14a'
branch_labels = None
depends_on = None


def upgrade():
    op.add_column('users', sa.Column('two_factor_auth_enabled', sa.Boolean(), nullable=True))
    op.add_column('users', sa.Column('otp_code', sa.String(), nullable=True))
    op.add_column('users', sa.Column('otp_recovery_code', sa.String(), nullable=True))
    op.create_index(op.f('ix_users_otp_code'), 'users', ['otp_code'], unique=True)
    op.execute("UPDATE users SET two_factor_auth_enabled = false")


def downgrade():
    op.drop_column('users', 'two_factor_auth_enabled')
    op.drop_column('users', 'otp_code')
    op.drop_column('users', 'otp_recovery_code')
