"""email_template_attachments

Revision: 0164
Revision ID: 13a7a762d14a
Revises: d8e7e0bbb09
Create Date: 2019-03-23 10:49:54.357036

"""
from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql


# revision identifiers, used by Alembic.
revision = '13a7a762d14a'
down_revision = 'd8e7e0bbb09'
branch_labels = None
depends_on = None


def upgrade():
    op.create_table('email_template_attachments',
        sa.Column('id', sa.Integer(), nullable=False),
        sa.Column('template_id', sa.Integer(), nullable=False),
        sa.Column('file_id', sa.Integer(), nullable=True),
        sa.Column('attribute_id', sa.Integer(), nullable=True),
        sa.ForeignKeyConstraint(['template_id'], ['email_templates.id'], ondelete='CASCADE'),
        sa.ForeignKeyConstraint(['file_id'], ['files.id'], ondelete='CASCADE'),
        sa.ForeignKeyConstraint(['attribute_id'], ['attributes.id'], ondelete='CASCADE'),
        sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_email_template_attachments_template_id'), 'email_template_attachments', ['template_id'], unique=False)

    op.add_column('email_templates', sa.Column('reply_to', sa.String(), nullable=True))
    op.add_column('email_templates', sa.Column('cc', sa.String(), nullable=True))
    op.add_column('email_templates', sa.Column('bcc', sa.String(), nullable=True))
    op.drop_column('email_templates', 'attachments_from_attributes')


def downgrade():
    op.drop_table('email_template_attachments')
    op.drop_column('email_templates', 'reply_to')
    op.drop_column('email_templates', 'cc')
    op.drop_column('email_templates', 'bcc')
    op.add_column('email_templates', sa.Column('attachments_from_attributes', postgresql.ARRAY(sa.String), nullable=True))
