"""comment_is_from_anonymous

Revision: 0162
Revision ID: 41184106cb68
Revises: 493635f05ca5
Create Date: 2019-03-15 09:54:28.379444

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = '41184106cb68'
down_revision = '493635f05ca5'
branch_labels = None
depends_on = None


def upgrade():
    op.add_column('card_comments', sa.Column('is_from_anonymous', sa.Boolean(), nullable=True))
    op.execute("UPDATE card_comments SET is_from_anonymous = false")
    op.execute("""UPDATE card_comments SET is_from_anonymous = true, created_by_username = r.email FROM requests r
        WHERE r.card_id = card_comments.card_id AND card_comments.created_by_id IS NULL
        AND card_comments.created_by_username IS NULL AND r.email IS NOT NULL""")

    op.add_column('activities', sa.Column('is_from_anonymous', sa.Boolean(), nullable=True))
    op.execute("UPDATE activities SET is_from_anonymous = false")
    op.execute("""UPDATE activities SET is_from_anonymous = true, created_by_username = r.email FROM requests r
        WHERE activities.object_type = 'Card' and r.card_id = activities.object_id AND activities.created_by_id IS NULL
        AND activities.created_by_username IS NULL AND r.email IS NOT NULL""")


def downgrade():
    op.drop_column('card_comments', 'is_from_anonymous')
    op.drop_column('activities', 'is_from_anonymous')
