"""request_form_inbound_email

Revision: 0161
Revision ID: 493635f05ca5
Revises: 1ef3e95bf70d
Create Date: 2019-03-12 13:59:32.638392

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = '493635f05ca5'
down_revision = '1ef3e95bf70d'
branch_labels = None
depends_on = None


def upgrade():
    op.add_column('request_forms', sa.Column('notify_requester_of_group_change', sa.Boolean(), nullable=True))
    op.add_column('request_forms', sa.Column('allow_request_via_email', sa.Boolean(), nullable=True))
    op.add_column('request_forms', sa.Column('email_subject_field_id', sa.Integer(), nullable=True))
    op.create_foreign_key(None, 'request_forms', 'request_form_fields', ['email_subject_field_id'], ['id'])
    op.add_column('request_forms', sa.Column('email_body_field_id', sa.Integer(), nullable=True))
    op.create_foreign_key(None, 'request_forms', 'request_form_fields', ['email_body_field_id'], ['id'])
    op.add_column('request_forms', sa.Column('email_attachments_field_id', sa.Integer(), nullable=True))
    op.create_foreign_key(None, 'request_forms', 'request_form_fields', ['email_attachments_field_id'], ['id'])

    op.execute("UPDATE request_forms SET notify_requester_of_group_change = true, allow_request_via_email = false")
    op.execute("UPDATE request_form_fields SET field_type = 'title' WHERE field_type = 'attribute' AND attribute_id IS NULL")


def downgrade():
    op.drop_column('request_forms', 'allow_request_via_email')
    op.drop_column('request_forms', 'email_subject_field_id')
    op.drop_column('request_forms', 'email_body_field_id')
    op.drop_column('request_forms', 'email_attachments_field_id')
