"""refactoring

Revision: 0156
Revision ID: 3dd85740e8ac
Revises: 284aac8ecbc6
Create Date: 2018-12-21 16:30:30.541069

"""
from alembic import op
import sqlalchemy as sa
from sqlalchemy import text
from sqlalchemy.dialects import postgresql


# revision identifiers, used by Alembic.
revision = '3dd85740e8ac'
down_revision = '284aac8ecbc6'
branch_labels = None
depends_on = None


def upgrade():
    op.add_column('users', sa.Column('last_password_change_from', sa.String(), nullable=True))
    op.add_column('user_logins', sa.Column('login_country', sa.String(), nullable=True))
    op.add_column('user_logins', sa.Column('login_user_agent', sa.String(), nullable=True))

    op.create_table('user_oauth_tokens',
        sa.Column('id', sa.Integer(), nullable=False),
        sa.Column('user_id', sa.Integer(), nullable=True),
        sa.Column('created_at', sa.DateTime(), nullable=True),
        sa.Column('provider', sa.String(), nullable=True),
        sa.Column('token_type', sa.String(), nullable=True),
        sa.Column('access_token', sa.String(), nullable=True),
        sa.Column('access_token_secret', sa.String(), nullable=True),
        sa.Column('refresh_token', sa.String(), nullable=True),
        sa.Column('token_expires_at', sa.DateTime(), nullable=True),
        sa.Column('scope', sa.String(), nullable=True),
        sa.Column('data', postgresql.JSONB(), nullable=True),
        sa.ForeignKeyConstraint(['user_id'], ['users.id'], ondelete='CASCADE'),
        sa.PrimaryKeyConstraint('id')
    )

    op.create_index(op.f('ix_user_oauth_tokens_user_id_provider'), 'user_oauth_tokens', ['user_id', 'provider'], unique=False)
    op.create_index(op.f('ix_user_oauth_tokens_data'), 'user_oauth_tokens', ['data'], unique=False)
    op.create_index(op.f('ix_users_username_lower'), 'users', [text('lower(username)')], unique=False)

    op.execute("""
        INSERT INTO user_oauth_tokens (user_id, created_at, provider, access_token, access_token_secret, data)
        SELECT id, now(), 'trello', trello_oauth_token, trello_oauth_token_secret, ('{"user_id": "' || trello_user_id || '", "username": "' || trello_username || '"}')::jsonb
        FROM users WHERE ARRAY['trello'] <@ auth_providers::text[]
    """)

    op.execute("""
        INSERT INTO user_oauth_tokens (user_id, created_at, provider, access_token, scope, data)
        SELECT id, now(), 'github', github_access_token, github_scope, ('{"id": "' || github_id || '", "username": "' || github_username || '", "email": "' || github_email || '"}')::jsonb
        FROM users WHERE ARRAY['github'] <@ auth_providers::text[]
    """)

    op.execute("""
        INSERT INTO user_oauth_tokens (user_id, created_at, provider, access_token, data)
        SELECT id, now(), 'asana', asana_token, ('{"id": "' || asana_id || '", "name": "' || asana_name || '", "email": "' || asana_email || '"}')::jsonb
        FROM users WHERE ARRAY['asana'] <@ auth_providers::text[]
    """)

    op.execute("""
        INSERT INTO user_oauth_tokens (user_id, created_at, provider, access_token, refresh_token, token_expires_at, data)
        SELECT id, now(), 'google', google_token, google_refresh_token, google_token_expiry, ('{"id": "' || google_id || '", "name": "' || google_name || '", "email": "' || google_email || '"}')::jsonb
        FROM users WHERE ARRAY['google'] <@ auth_providers::text[]
    """)


def downgrade():
    op.drop_column('users', 'last_password_change_from')
    op.drop_column('user_logins', 'login_country')
    op.drop_column('user_logins', 'login_user_agent')
    op.drop_table('user_oauth_tokens')
