"""share_object_forms

Revision: 0155
Revision ID: 284aac8ecbc6
Revises: 64703a6228b
Create Date: 2018-12-06 16:23:18.371420

"""

# revision identifiers, used by Alembic.
revision = '284aac8ecbc6'
down_revision = '64703a6228b'
branch_labels = None
depends_on = None

from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql

def upgrade():
    op.create_table('share_object_forms',
        sa.Column('share_object_id', sa.Integer(), nullable=True),
        sa.Column('form_id', sa.Integer(), nullable=True),
        sa.ForeignKeyConstraint(['form_id'], ['request_forms.id'], ondelete='CASCADE'),
        sa.ForeignKeyConstraint(['share_object_id'], ['share_objects.id'], ondelete='CASCADE')
    )
    op.create_index(op.f('ix_share_object_forms_form_id_share_object_id'), 'share_object_forms', ['form_id', 'share_object_id'], unique=False)
    op.add_column('share_objects', sa.Column('cache_id', sa.String(), nullable=True))


def downgrade():
    #op.drop_column('share_objects', 'cache_id')
    op.drop_index(op.f('ix_share_object_forms_form_id_share_object_id'), table_name='share_object_forms')
    op.drop_table('share_object_forms')
