"""users_last_access_at

Revision: 0153
Revision ID: 25a07f58df10
Revises: 4fd1516bbd51
Create Date: 2018-12-04 13:05:18.453897

"""

# revision identifiers, used by Alembic.
revision = '25a07f58df10'
down_revision = '4fd1516bbd51'
branch_labels = None
depends_on = None

from alembic import op
import sqlalchemy as sa


def upgrade():
    op.add_column('users', sa.Column('last_access_at', sa.Date(), nullable=True))
    op.create_index(op.f('ix_users_last_access_at'), 'users', ['last_access_at'], unique=False)
    op.execute("UPDATE users SET last_access_at = (SELECT MAX(v) FROM unnest(ARRAY[last_activity_at, last_login_at, signup_at]) as v)")


def downgrade():
    op.drop_column('users', 'last_access_at')
