"""build_tsvector

Revision: 0149
Revision ID: 49495b7b574
Revises: 1d8095d7022a
Create Date: 2018-11-14 11:33:48.476417

"""

# revision identifiers, used by Alembic.
revision = '49495b7b574'
down_revision = '1d8095d7022a'
branch_labels = None
depends_on = None

from alembic import op
import sqlalchemy as sa


def upgrade():
    op.execute("""
        CREATE OR REPLACE FUNCTION build_tsvector(content text) RETURNS tsvector
        AS
        $BODY$
            SELECT to_tsvector(public.unaccent('public.unaccent', left(content, 500000)));
        $BODY$
        LANGUAGE sql
        IMMUTABLE;
    """)

    op.execute("""DROP INDEX IF EXISTS ix_cards_fulltext""")
    op.execute("""DROP INDEX IF EXISTS ix_card_attributes_fulltext""")

    op.execute("""CREATE INDEX ix_cards_fulltext ON cards USING gin(build_tsvector(title))""")
    op.execute("""CREATE INDEX ix_card_attributes_fulltext ON card_attributes USING gin(build_tsvector(unindexed_value))""")
    op.execute("""CREATE INDEX ix_card_comments_fulltext ON card_comments USING gin(build_tsvector(message))""")

def downgrade():
    pass
