"""add_sharing_via_url

Revision: 0148
Revision ID: 1d8095d7022a
Revises: 44e27652773
Create Date: 2018-09-24 15:24:05.813512

"""

# revision identifiers, used by Alembic.
revision = '1d8095d7022a'
down_revision = '44e27652773'
branch_labels = None
depends_on = None

from alembic import op
import sqlalchemy as sa


def upgrade():
    conn = op.get_bind()

    reminders = op.create_table('share_objects',
        sa.Column('id', sa.Integer(), nullable=False),
        sa.Column('created_at', sa.DateTime(), nullable=True),
        sa.Column('created_by_id', sa.Integer(), nullable=True),
        sa.Column('token', sa.String(), nullable=False, unique=True),
        sa.Column('project_id', sa.Integer(), nullable=False),
        sa.Column('object_type', sa.String(), nullable=False),
        sa.Column('object_id', sa.Integer(), nullable=False),
        sa.ForeignKeyConstraint(['project_id'], ['projects.id'], ondelete='CASCADE'),
        sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_share_objects_token'), 'share_objects', ['token'], unique=True)
    op.create_index(op.f('ix_share_objects_object_type_object_id'), 'share_objects', ['object_type', 'object_id'], unique=False)

def downgrade():
    op.drop_table('share_objects')
