"""signup_cpc

Revision: 0146
Revision ID: 51e932e2e7f7
Revises: 2e10b78f004e
Create Date: 2018-10-25 21:44:07.672445

"""

# revision identifiers, used by Alembic.
revision = '51e932e2e7f7'
down_revision = '2e10b78f004e'
branch_labels = None
depends_on = None

from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql


def upgrade():
    op.drop_column('users', 'signup_utma')
    op.drop_column('users', 'signup_utmz')
    op.add_column('users', sa.Column('signup_country', sa.String(), nullable=True))
    op.add_column('users', sa.Column('signup_cpc_source', sa.String(), nullable=True))
    op.add_column('users', sa.Column('signup_cpc_campaign', sa.String(), nullable=True))
    op.add_column('users', sa.Column('signup_cpc_ad', sa.String(), nullable=True))
    op.add_column('users', sa.Column('signup_cpc_keyword', sa.String(), nullable=True))
    op.add_column('users', sa.Column('signup_cpc_sessionid', sa.String(), nullable=True))
    op.create_index(op.f('ix_users_signup_country'), 'users', ['signup_country'], unique=False)
    op.create_index(op.f('ix_users_signup_cpc_source'), 'users', ['signup_cpc_source'], unique=False)


def downgrade():
    op.drop_column('users', 'signup_country')
    op.drop_column('users', 'signup_cpc_source')
    op.drop_column('users', 'signup_cpc_campaign')
    op.drop_column('users', 'signup_cpc_ad')
    op.drop_column('users', 'signup_cpc_keyword')
    op.drop_column('users', 'signup_cpc_sessionid')
    op.add_column('users', sa.Column('signup_utma', postgresql.JSONB(), nullable=True))
    op.add_column('users', sa.Column('signup_utmz', postgresql.JSONB(), nullable=True))
