"""missing_indexes

Revision: 0140
Revision ID: 25ae23668316
Revises: 537f032a290d
Create Date: 2018-06-25 19:18:38.163151

"""

# revision identifiers, used by Alembic.
revision = '25ae23668316'
down_revision = '537f032a290d'
branch_labels = None
depends_on = None

from alembic import op
import sqlalchemy as sa


def upgrade():
    op.create_index(op.f('ix_users_pins_user_id_card_id'), 'users_pins', ['user_id', 'card_id'], unique=False)
    op.create_index(op.f('ix_project_webhooks_project_id_active'), 'project_webhooks', ['project_id', 'active'], unique=False)
    op.create_index(op.f('ix_organizations_is_user_org_created_by_id'), 'organizations', ['is_user_org', 'created_by_id'], unique=False)
    op.create_index(op.f('ix_projects_created_by_id'), 'projects', ['created_by_id'], unique=False)


def downgrade():
    op.drop_index(op.f('ix_users_pins_user_id_card_id'), table_name='users_pins')
    op.drop_index(op.f('ix_project_webhooks_project_id_active'), table_name='project_webhooks')
    op.drop_index(op.f('ix_organizations_is_user_org_created_by_id'), table_name='organizations')
    op.drop_index(op.f('ix_projects_created_by_id'), table_name='projects')
