"""export_templates

Revision: 0138
Revision ID: 4e52740ad490
Revises: 17e5c6904ce1
Create Date: 2018-07-13 05:19:47.102187

"""

# revision identifiers, used by Alembic.
revision = '4e52740ad490'
down_revision = '17e5c6904ce1'
branch_labels = None
depends_on = None

from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql


def upgrade():
    op.create_table('project_export_templates',
        sa.Column('id', sa.Integer(), nullable=False),
        sa.Column('project_id', sa.Integer(), nullable=False),
        sa.Column('created_at', sa.DateTime(), nullable=True),
        sa.Column('created_by_id', sa.Integer(), nullable=True),
        sa.Column('name', sa.String(), nullable=True),
        sa.Column('format', sa.String(), nullable=True),
        sa.Column('attributes', postgresql.ARRAY(sa.String()), nullable=True),
        sa.ForeignKeyConstraint(['project_id'], ['projects.id'], ondelete='CASCADE'),
        sa.ForeignKeyConstraint(['created_by_id'], ['users.id'], ondelete='SET NULL'),
        sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_project_export_templates_project_id'), 'project_export_templates', ['project_id'], unique=False)


def downgrade():
    op.drop_table('project_export_templates')
