"""webhooks

Revision: 0129
Revision ID: 6e7bf3fa1d3
Revises: 26834f77e639
Create Date: 2018-05-03 17:04:40.502709

"""

# revision identifiers, used by Alembic.
revision = '6e7bf3fa1d3'
down_revision = '26834f77e639'
branch_labels = None
depends_on = None

from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql


def upgrade():
    op.create_table('project_webhooks',
        sa.Column('id', sa.Integer(), nullable=False),
        sa.Column('project_id', sa.Integer(), nullable=False),
        sa.Column('created_at', sa.DateTime(), nullable=True),
        sa.Column('created_by_id', sa.Integer(), nullable=True),
        sa.Column('url', sa.String(), nullable=True),
        sa.Column('events', postgresql.ARRAY(sa.String()), nullable=True),
        sa.Column('active', sa.Boolean(), nullable=True),
        sa.Column('card_object_only', sa.Boolean(), nullable=True),
        sa.Column('card_object_only_as_array', sa.Boolean(), nullable=True),
        sa.Column('last_called_at', sa.DateTime(), nullable=True),
        sa.Column('last_call_response_code', sa.Integer(), nullable=True),
        sa.Column('last_call_response_body', sa.String(), nullable=True),
        sa.ForeignKeyConstraint(['project_id'], ['projects.id'], ondelete='CASCADE'),
        sa.ForeignKeyConstraint(['created_by_id'], ['users.id'], ondelete='SET NULL'),
        sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_project_webhooks_project_id'), 'project_webhooks', ['project_id'], unique=False)
    op.create_index(op.f('ix_project_webhooks_events_active'), 'project_webhooks', ['events', 'active'], unique=False)


def downgrade():
    op.drop_table('project_webhooks')
