"""integrations

Revision: 0126
Revision ID: 431110172682
Revises: 2387660ed43b
Create Date: 2017-08-10 17:46:53.622528

"""

# revision identifiers, used by Alembic.
revision = '431110172682'
down_revision = '2387660ed43b'
branch_labels = None
depends_on = None

from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql


def upgrade():
    op.create_table('integrations',
        sa.Column('id', sa.Integer(), nullable=False),
        sa.Column('org_id', sa.Integer(), nullable=True),
        sa.Column('created_at', sa.DateTime(), nullable=True),
        sa.Column('created_by_id', sa.Integer(), nullable=True),
        sa.Column('name', sa.String(), nullable=True),
        sa.Column('account', sa.String(), nullable=True),
        sa.Column('meta', postgresql.JSON(), nullable=True),
        sa.Column('authorized', sa.Boolean(), nullable=True),
        sa.Column('error', sa.String(), nullable=True),
        sa.ForeignKeyConstraint(['org_id'], ['organizations.id'], ondelete='CASCADE'),
        sa.ForeignKeyConstraint(['created_by_id'], ['users.id'], ondelete='SET NULL'),
        sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_integrations_org_id'), 'integrations', ['org_id'], unique=False)
    op.create_index(op.f('ix_integrations_name'), 'integrations', ['name'], unique=False)

    op.create_table('project_integration_scopes',
        sa.Column('id', sa.Integer(), nullable=False),
        sa.Column('project_id', sa.Integer(), nullable=True),
        sa.Column('integration_id', sa.Integer(), nullable=True),
        sa.Column('created_at', sa.DateTime(), nullable=True),
        sa.Column('created_by_id', sa.Integer(), nullable=True),
        sa.Column('options', postgresql.JSON(), nullable=True),
        sa.Column('webhook_token', sa.String(), nullable=True),
        sa.ForeignKeyConstraint(['project_id'], ['projects.id'], ondelete='CASCADE'),
        sa.ForeignKeyConstraint(['integration_id'], ['integrations.id'], ondelete='CASCADE'),
        sa.ForeignKeyConstraint(['created_by_id'], ['users.id'], ondelete='SET NULL'),
        sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_project_integration_scopes_project_id'), 'project_integration_scopes', ['project_id'], unique=False)
    op.create_index(op.f('ix_project_integration_scopes_integration_id'), 'project_integration_scopes', ['integration_id'], unique=False)

    op.add_column('attributes', sa.Column('is_from_integration', sa.String(), nullable=True))
    op.add_column('attributes', sa.Column('integration_ref', sa.String(), nullable=True))
    op.create_index(op.f('ix_attributes_is_from_integration_integration_ref'), 'attributes', ['is_from_integration', 'integration_ref'], unique=False)

    op.execute("""INSERT INTO integrations (org_id, created_at, created_by_id, name, meta, authorized, error)
        SELECT p.owner_id, cb.activated_at, cb.activated_by_id, cb.name, cb.meta, not cb.needs_reactivation, cb.error
        FROM card_behaviors cb JOIN projects p ON p.id = cb.project_id""")

    op.execute("""INSERT INTO project_integration_scopes (project_id, integration_id, created_at, created_by_id, options)
        SELECT p.id, i.id, cb.enabled_at, cb.enabled_by_id, cb.options::json
        FROM integrations i JOIN projects p ON p.owner_id = i.org_id JOIN card_behaviors cb ON cb.name = i.name AND cb.project_id = p.id""")

    # TEMPORARY
    op.execute("""DELETE FROM integrations WHERE id IN (
        SELECT integrations.id FROM integrations JOIN organizations ON organizations.id = integrations.org_id
        WHERE organizations.is_user_org
    )""")


def downgrade():
    op.drop_table('project_integration_scopes')
    op.drop_table('integrations')
    op.drop_column('attributes', 'is_from_integration')
    op.drop_column('attributes', 'integration_ref')
