"""users_password_policy

Revision: 0119
Revision ID: 537252d4f3d3
Revises: 252587fbe66d
Create Date: 2018-03-21 17:19:32.960014

"""

# revision identifiers, used by Alembic.
revision = '537252d4f3d3'
down_revision = '252587fbe66d'
branch_labels = None
depends_on = None

from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql


def upgrade():
    op.add_column('users', sa.Column('last_password_change_at', sa.DateTime(), nullable=True))
    op.add_column('users', sa.Column('previous_passwords', postgresql.ARRAY(sa.String), nullable=True))
    op.add_column('users', sa.Column('must_reset_password_at_login', sa.Boolean(), nullable=True))


def downgrade():
    op.drop_column('users', 'last_password_change_at')
    op.drop_column('users', 'previous_passwords')
    op.drop_column('users', 'must_reset_password_at_login')
