"""activity_username

Revision: 0113
Revision ID: 4d7f1ad39d84
Revises: edc4da1f645
Create Date: 2018-02-27 11:07:15.183763

"""

# revision identifiers, used by Alembic.
revision = '4d7f1ad39d84'
down_revision = 'edc4da1f645'
branch_labels = None
depends_on = None

from alembic import op
import sqlalchemy as sa


def upgrade():
    op.add_column('activities', sa.Column('created_by_username', sa.String(), nullable=True))
    op.add_column('card_comments', sa.Column('created_by_username', sa.String(), nullable=True))
    op.add_column('card_logs', sa.Column('created_by_username', sa.String(), nullable=True))
    op.add_column('card_change_history', sa.Column('created_by_username', sa.String(), nullable=True))

    op.execute("""
        UPDATE activities
        SET created_by_username = users.username
        FROM users
        WHERE users.id = activities.created_by_id
    """)
    op.execute("""
        UPDATE card_comments
        SET created_by_username = users.username
        FROM users
        WHERE users.id = card_comments.created_by_id
    """)
    op.execute("""
        UPDATE card_logs
        SET created_by_username = users.username
        FROM users
        WHERE users.id = card_logs.created_by_id
    """)
    op.execute("""
        UPDATE card_change_history
        SET created_by_username = users.username
        FROM users
        WHERE users.id = card_change_history.created_by_id
    """)


def downgrade():
    op.drop_column('activities', 'created_by_username')
    op.drop_column('card_comments', 'created_by_username')
    op.drop_column('card_logs', 'created_by_username')
    op.drop_column('card_change_history', 'created_by_username')
