"""add_monthly_tasks

Revision: 0112
Revision ID: edc4da1f645
Revises: 54c1c3cc20fd
Create Date: 2018-02-21 17:01:09.750527

"""

# revision identifiers, used by Alembic.
revision = 'edc4da1f645'
down_revision = '54c1c3cc20fd'
branch_labels = None
depends_on = None

from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql
from sqlalchemy.sql.expression import bindparam


def upgrade():
    conn = op.get_bind()
    op.execute("UPDATE recurring_tasks SET recurring_days = regexp_replace(recurring_days, '\d', 'weekly:\&', 'g') WHERE recurring_days != 'daily'")
    op.alter_column('recurring_tasks', 'recurring_days', new_column_name='recurrence', nullable=True)


def downgrade():
    conn = op.get_bind()
    op.alter_column('recurring_tasks', 'recurrence', new_column_name='recurring_days', nullable=True)
    op.execute("UPDATE recurring_tasks SET recurring_days = regexp_replace(recurring_days, 'weekly:(\d)', '\\1', 'g') WHERE recurring_days != 'daily'")
