"""card_group_actions

Revision: 0111
Revision ID: 54c1c3cc20fd
Revises: 1b7722f7b357
Create Date: 2018-01-31 16:40:54.911871

"""

# revision identifiers, used by Alembic.
revision = '54c1c3cc20fd'
down_revision = '1b7722f7b357'
branch_labels = None
depends_on = None

from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql

def upgrade():
    op.create_table('card_group_actions',
        sa.Column('id', sa.Integer(), nullable=False),
        sa.Column('group_id', sa.Integer(), nullable=True),
        sa.Column('created_at', sa.DateTime(), nullable=True),
        sa.Column('updated_at', sa.DateTime(), nullable=True),
        sa.Column('created_by_id', sa.Integer(), nullable=True),
        sa.Column('action_name', sa.String(), nullable=True),
        sa.Column('options', postgresql.JSONB(), nullable=True),
        sa.ForeignKeyConstraint(['created_by_id'], ['users.id'], ondelete='SET NULL'),
        sa.ForeignKeyConstraint(['group_id'], ['card_groups.id'], ondelete='CASCADE'),
        sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_card_group_actions_group_id'), 'card_group_actions', ['group_id'], unique=False)

    op.execute("""
        INSERT INTO card_group_actions (group_id, created_at, action_name, options)
        SELECT id, updated_at, 'set_attribute', ('{"attr": {"name": "' || auto_assign_user || '", "type": "members", "value": "@me"}}')::jsonb
        FROM card_groups WHERE auto_assign_user is not null
    """)


def downgrade():
    op.drop_index(op.f('ix_card_group_actions_group_id'), table_name='card_group_actions')
    op.drop_table('card_group_actions')
