"""total_invites

Revision: 0100
Revision ID: 3b0d34ece0d5
Revises: 439d72ec8dc4
Create Date: 2017-07-18 13:49:44.968381

"""

# revision identifiers, used by Alembic.
revision = '3b0d34ece0d5'
down_revision = '439d72ec8dc4'
branch_labels = None
depends_on = None

from alembic import op
import sqlalchemy as sa


def upgrade():
    op.add_column('organizations', sa.Column('total_invites', sa.Integer(), nullable=True))
    op.add_column('projects', sa.Column('total_invites', sa.Integer(), nullable=True))
    op.execute("UPDATE organizations SET total_invites = (SELECT COUNT(*) FROM organization_members om WHERE om.org_id = organizations.id)")
    op.execute("UPDATE projects SET total_invites = (SELECT COUNT(*) FROM project_members pm WHERE pm.project_id = projects.id)")


def downgrade():
    op.drop_column('organizations', 'total_invites')
    op.drop_column('projects', 'total_invites')
