"""user_logins

Revision: 0099
Revision ID: 439d72ec8dc4
Revises: 3a512b4f3d8f
Create Date: 2017-06-30 15:22:35.192111

"""

# revision identifiers, used by Alembic.
revision = '439d72ec8dc4'
down_revision = '3a512b4f3d8f'
branch_labels = None
depends_on = None

from alembic import op
import sqlalchemy as sa


def upgrade():
    user_logins = op.create_table('user_logins',
        sa.Column('id', sa.Integer(), nullable=False),
        sa.Column('user_id', sa.Integer(), nullable=True),
        sa.Column('login_at', sa.DateTime(), nullable=True),
        sa.Column('login_from', sa.String(), nullable=True),
        sa.Column('login_provider', sa.String(), nullable=True),
        sa.ForeignKeyConstraint(['user_id'], ['users.id'], ondelete='SET NULL'),
        sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_user_logins_user_id'), 'user_logins', ['user_id'], unique=False)


def downgrade():
    op.drop_table('user_logins')
