"""group_subscriptions

Revision: 0092
Revision ID: 1f5aaa83bebb
Revises: 10fc44ad31fa
Create Date: 2017-04-11 10:57:02.945124

"""

# revision identifiers, used by Alembic.
revision = '1f5aaa83bebb'
down_revision = '10fc44ad31fa'
branch_labels = None
depends_on = None

from alembic import op
import sqlalchemy as sa


def upgrade():
    op.create_table('card_group_subscriptions',
        sa.Column('id', sa.Integer(), nullable=False),
        sa.Column('group_id', sa.Integer(), nullable=True),
        sa.Column('user_id', sa.Integer(), nullable=True),
        sa.Column('created_at', sa.DateTime(), nullable=True),
        sa.Column('auto', sa.Boolean(), nullable=True),
        sa.Column('send_emails', sa.Boolean(), nullable=True),
        sa.Column('notify_card_changes', sa.Boolean(), nullable=True),
        sa.ForeignKeyConstraint(['group_id'], ['card_groups.id'], ondelete='CASCADE'),
        sa.ForeignKeyConstraint(['user_id'], ['users.id'], ondelete='CASCADE'),
        sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_card_group_subscriptions_group_id'), 'card_group_subscriptions', ['group_id'], unique=False)
    op.create_index(op.f('ix_card_group_subscriptions_group_id_user_id'), 'card_group_subscriptions', ['group_id', 'user_id'], unique=False)


def downgrade():
    op.drop_table('card_group_subscriptions')
