"""copy_log_type

Revision: 0091
Revision ID: 10fc44ad31fa
Revises: 4be9e24293aa
Create Date: 2017-03-22 10:33:52.812237

"""

# revision identifiers, used by Alembic.
revision = '10fc44ad31fa'
down_revision = '4be9e24293aa'
branch_labels = None
depends_on = None

from alembic import op
import sqlalchemy as sa


def upgrade():
    op.add_column('card_log_types', sa.Column('copied_from_id', sa.Integer(), nullable=True))
    op.create_foreign_key(None, 'card_log_types', 'card_log_types', ['copied_from_id'], ['id'], ondelete='SET NULL')
    op.create_index(op.f('ix_card_log_types_copied_from_id'), 'card_log_types', ['copied_from_id'], unique=False)
    op.add_column('card_log_types', sa.Column('builtin', sa.String(), nullable=True))


def downgrade():
    op.drop_column('card_log_types', 'builtin')
    op.drop_index(op.f('ix_card_log_types_copied_from_id'), table_name='card_log_types')
    op.drop_column('card_log_types', 'copied_from_id')
