# -*- coding: utf-8 -*-
"""dashboard_sections

Revision: 0085
Revision ID: 2d68c5dd350e
Revises: 427a0e562031
Create Date: 2017-02-27 13:26:37.792586

"""

# revision identifiers, used by Alembic.
revision = '2d68c5dd350e'
down_revision = '427a0e562031'
branch_labels = None
depends_on = None

from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql


def upgrade():
    op.add_column('users', sa.Column('dashboard_sections', postgresql.JSON(), nullable=True))

    op.execute("""
        UPDATE users SET dashboard_sections = ('['
            || '{"title": "Overdue cards assigned to me", "filter": "@me {due date}<today state!=done", "collapsed": false},'
            || '{"title": "Due cards assigned to me", "filter": "@me {due date}>=today state!=done", "collapsed": false},'
            || '{"title": "Assigned to me", "filter": "@me {due date}=empty state!=done", "collapsed": false}]')::json
        WHERE locale is null or locale != 'fr'
    """)

    op.execute("""
        UPDATE users SET dashboard_sections = ('['
            || '{"title": "Cartes en retard qui me sont assignées", "filter": "@me {due date}<today state!=done", "collapsed": false},'
            || '{"title": "Cartes avec une échéance qui me sont assignées", "filter": "@me {due date}>=today state!=done", "collapsed": false},'
            || '{"title": "Cartes qui me sont assignées", "filter": "@me {due date}=empty state!=done", "collapsed": false}]')::json
        WHERE locale = 'fr'
    """)


def downgrade():
    op.drop_column('users', 'dashboard_sections')
